<?php
/**
* Fichier d'initialisation des variables pour le module de Sudoku.
* 
* @package Sudoku 
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2008, Vincent RUIZ
* @version 0.1
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

//contient le nom des variables  passer pour le fonctionnement du Sudoku
require_once("g_db.php");

$db_session = new BD_Sessions(); 
session_set_save_handler(array(&$db_session,"open"), 
						 array(&$db_session,"close"), 
						 array(&$db_session,"read"), 
						 array(&$db_session,"write"), 
						 array(&$db_session,"destroy"), 
						 array(&$db_session,"gc"));
session_start();

/**
 * $var array $My_SQL Tableau contenant les paramtres d'accs  la base de donnes
 */
$My_SQL = array();
$My_SQL["clients"] = "becms_clients";
$My_SQL["sudoku"] = "becms_sudoku_grilles";
$My_SQL["parties"] = "becms_sudoku_sauvegardes";
$My_SQL["pays"] = "becms_commerce_pays";

/**
 * Adresse e-mail de l'expditeur des messages
 */
$vars_mail = array("from" => "webmaster@arobase.fr", "nom" => "Vincent RUIZ Commercant");

/**
 *Quelques variables d'initialisation
 */
$cheminIcones = "modules/$module_name/lib/icns";
$cheminModule = "modules/$module_name/";

/**
 * $var array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
$vars_mod = array(
	"page_en_cours"=>"page_listing",
	"action" => "act",
	"id_client" => "ident_client",
	"id_sudoku" => "-1",
	"id_partie_sudoku" => "-1",
	"cheminIcones" => $cheminIcones,
	"cheminModule" => $cheminModule,
	"confirm" => "ok",
	"tri" => "order",
	"n_grilles" => "nbre_grilles",
	"mailclient" => "email",
	"leniveau" => "niveau"
);

$vars_mod[$vars_mod["action"]] = testinit($GLOBALS[$vars_mod["action"]],"list");
$vars_mod[$vars_mod["id_client"]] = testinit($GLOBALS[$vars_mod["id_client"]],-1);
$vars_mod["id_sudoku"] = testinit($GLOBALS["id_sudoku"],-1);
$vars_mod["id_partie_sudoku"] = testinit($GLOBALS["id_partie_sudoku"],-1);
$vars_mod[$vars_mod["confirm"]] = testinit($GLOBALS[$vars_mod["confirm"]],"n");
$vars_mod[$vars_mod["tri"]] = testinit($GLOBALS[$vars_mod["tri"]]);
$vars_mod[$vars_mod["n_grilles"]] = testinit($GLOBALS[$vars_mod["n_grilles"]],"10");
$vars_mod[$vars_mod["mailclient"]] = testinit($GLOBALS[$vars_mod["mailclient"]]);
$vars_mod[$vars_mod["leniveau"]] = testinit($GLOBALS[$vars_mod["leniveau"]]);

/**
 * Paramtres de recherche par dfaut.
 */
$crit_find_sudoku = array(
"page_en_cours"=>testinit($GLOBALS[$vars_mod["page_en_cours"]],"1"),
"articles_par_page"=>testinit($GLOBALS["articles_par_page"],"10"),
"sudokus_par_page"=>testinit($GLOBALS["articles_par_page"],"15"),
);

function testinit(&$valeur,$valeurinit="") {
	if (!isset($valeur)) {
		return $valeurinit;
	}
	return $valeur;
}

$vars_mod["sortie_action"] = "";
$new_client = array(
"Id"=>testinit($GLOBALS[$vars_mod["id_client"]],"-1"),
"civilite"=>testinit($GLOBALS["civilite"]),
"nom"=>testinit($GLOBALS["nom"]),
"prenom"=>testinit($GLOBALS["prenom"]),
"societe"=>testinit($GLOBALS["societe"]),
"adresse"=>testinit($GLOBALS["adresse"]),
"codepostal"=>testinit($GLOBALS["codepostal"]),
"ville"=>testinit($GLOBALS["ville"]),
"pays"=>testinit($GLOBALS["pays"]),
"tel"=>testinit($GLOBALS["tel"]),
"fax"=>testinit($GLOBALS["fax"]),
"portable"=>testinit($GLOBALS["portable"]),
"email"=>testinit($GLOBALS["email"]),
"services"=>testinit($GLOBALS["services"]),
"codeclient"=>testinit($GLOBALS["codeclient"]),
"passwd"=>testinit($GLOBALS["passwd"]),
"valide"=>testinit($GLOBALS["valide"],"0"),
"divers"=>testinit($GLOBALS["divers"]),
"datenaissance"=>testinit($GLOBALS["datenaissance"],"0000-00-00")
);

$new_sudoku = array(
"Id"=>testinit($GLOBALS["id_sudoku"],"-1"),
"niveau"=>testinit($GLOBALS["niveau"]),
"grille"=>testinit($GLOBALS["grille"]),
"masque"=>testinit($GLOBALS["masque"]),
"date"=>testinit($GLOBALS["date"],"0000-00-00")
);

if (testinit($GLOBALS["id_sudoku"],"-1") != "-1") {
	$_SESSION["s_id_sudoku"] = $GLOBALS["id_sudoku"];
}
else {
	$_SESSION["s_id_sudoku"] = testinit($_SESSION["s_id_sudoku"],"-1");
}
if (testinit($GLOBALS[$vars_mod["id_client"]],"-1") != "-1") {
	$_SESSION["s_id_client"] = $GLOBALS[$vars_mod["id_client"]];
}
else {
	$_SESSION["s_id_client"] = testinit($_SESSION["s_id_client"],"-1");
}
if (testinit($GLOBALS["mygrille"]) != "") {
	$_SESSION["s_mygrille"] = $GLOBALS["mygrille"];
}
else {
	$_SESSION["s_mygrille"] = testinit($_SESSION["s_mygrille"]);
}
if (testinit($GLOBALS["mymask"]) != "") {
	$_SESSION["s_mymask"] = $GLOBALS["mymask"];
}
else {
	$_SESSION["s_mymask"] = testinit($_SESSION["s_mymask"]);
}

$clef = array(
"Id"=>testinit($GLOBALS["Id"],"-1"),
"codeclient"=>testinit($GLOBALS["codeclient"]),
"passwd"=>testinit($GLOBALS["passwd"])
);

$new_partie_sudoku = array(
"Id"=>testinit($GLOBALS["Id"],"-1"),
"id_sudoku"=>testinit($GLOBALS["id_sudoku"],"-1"),
"id_utilisateur"=>testinit($GLOBALS[$vars_mod["id_client"]],"-1"),
"grille_utilisateur"=>testinit($GLOBALS["mygrille"]),
"masque_utilisateur"=>testinit($GLOBALS["mymask"]),
"date"=>testinit($GLOBALS["date"],"0000-00-00")
);
?>