<?php 
require_once("core/becms_mainlib_lib.php");
require_once("includes/truncate_string.php");
require_once("modules/Sections/connector_class.php");
$monObjet = new pageconnector();
$pageaccueilbrut = $monObjet->getPageContent(183,"",true);
/*$piedpagebrut = $monObjet->getPageContent(189,"",true);*/
require_once("themes/orzhc/menus.php");
/*require_once("blocks/block-Last_2_Actus.php");
$actualites = $content;
require_once("blocks/block-Last_2_Actus_Expos.php");

$manifestations = $content;*/

function template_obs($observations) {
    $sortie = 'var dataset = [';
    if (count($observations) > 0 ) {
        foreach($observations as $observation) {
            $sortie .= ($sortie != "") ? "," : "";
            $sortie .= '
				{
					"date": "'.$observation["date"].'",
                    "centre" : "'.$observation["geom"].'",
                    "nombre" : "'.$observation["nombre"].'"
				}';
        }
    }
    $sortie .= '];';
    return $sortie;
}

function insert_leaflet_map($letexte) {
    if (preg_match_all("/<img[^>]+type=\"leafletmap\"[^>]*>/im", $letexte, $tabcartes, PREG_PATTERN_ORDER)) {
        foreach ($tabcartes[0] as $tabcarte) {
            $lamap = '<div id="map"></div>';
            $nbre = 1;
            $letexte = str_replace($tabcarte, $lamap, $letexte, $nbre);
        }
    }
    return $letexte;
}

$observations =  json_decode(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_last_inv&key=fea9a667df9db40499ebf94e5b6a07f6"), true)["result"]["data"];
$observation = template_obs($observations);

$pageaccueilbrut = addslashes($pageaccueilbrut);
$pageaccueilbrut = "\$pageaccueil=\"".$pageaccueilbrut."\";";
eval($pageaccueilbrut);
$pageaccueil = stripslashes($pageaccueil);
$pageaccueil = insert_video_player($pageaccueil,true);
/*$pageaccueil = insert_simple_map($pageaccueil,true);*/
$pageaccueil = insert_leaflet_map($pageaccueil);
$pageaccueil = insert_photo_zoom($pageaccueil, true);
$pageaccueil = utf8_encode($pageaccueil);

$pageaccueilaction = $monObjet->getPageContent(184,"",true);
$pageaccueilaction = utf8_encode($pageaccueilaction);

$pageaccueillogos = $monObjet->getPageContent(185,"",true);
$pageaccueillogos = utf8_encode($pageaccueillogos);

$pageaccueilfinanceurs = $monObjet->getPageContent(186,"",true);
$pageaccueilfinanceurs = utf8_encode($pageaccueilfinanceurs);

/*$piedpagebrut = addslashes($piedpagebrut);
$piedpagebrut = "\$piedpage=\"".$piedpagebrut."\";";
eval($piedpagebrut);
$piedpage = utf8_encode(stripslashes($piedpage));*/


global $sitename;
$sitename = utf8_encode(str_replace("\"","'", $sitename));
global $meta_description;
$meta_description = utf8_encode(str_replace("\"","'", $meta_description));
global $meta_keyword;
$meta_keyword = utf8_encode(str_replace("\"","'", $meta_keyword));

global $popupSearch, $bouton_search_menu;
$popupSearch = utf8_encode($popupSearch);
$bouton_search_menu = utf8_encode($bouton_search_menu);

/* recherche des photos slider et affichage aléatoire */
if($dir = @opendir("catalog_repository/UserFiles/Image/accueil/slider")) {
    $liste_images_tab = array();
    while($file = readdir($dir)) {
        if($file != "." && $file != ".." && $file[0] != '.' && (preg_match("#\\.jpg$#i", $file) || preg_match("#\\.jpeg$#i", $file) || preg_match("#\\.png$#i", $file))) {
            $liste_images_tab[] = $file;
        }
    }
    shuffle($liste_images_tab);
    $liste_images = "";
    foreach($liste_images_tab as $une_image) {
        $liste_images .= '<img src="catalog_repository/UserFiles/Image/accueil/slider/'.$une_image.'" />';
    }
}

require_once("themes/orzhc/news.php");
$news = get_news();
$news = utf8_encode($news);

?>
<!DOCTYPE HTML>
<html lang="fr">
<head>
<meta charset="utf-8">
<title><?php echo $sitename; ?></title>
<META NAME="KEYWORDS" CONTENT="<?php echo $meta_keyword; ?>">
<META NAME="DESCRIPTION" CONTENT="<?php echo $meta_description; ?>">
<META NAME="ROBOTS" CONTENT="INDEX, FOLLOW">
<META NAME="AUTHOR" CONTENT="<?php echo $sitename; ?>">

<META NAME="ROBOTS" CONTENT="INDEX, FOLLOW">
<META NAME="REVISIT-AFTER" CONTENT="1 DAYS">
<META NAME="RATING" CONTENT="GENERAL">
<META HTTP-EQUIV="imagetoolbar" CONTENT="no">

<meta name="format-detection" content="telephone=no" />
<meta name="apple-mobile-web-app-capable" content="yes"/>

<link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
<link rel="icon" href="favicon.png" type="image/png">
<link rel="icon" sizes="32x32" href="favicon-32.png" type="image/png">
<link rel="icon" sizes="64x64" href="favicon-64.png" type="image/png">
<link rel="icon" sizes="96x96" href="favicon-96.png" type="image/png">
<link rel="icon" sizes="196x196" href="favicon-196.png" type="image/png">
<link rel="apple-touch-icon" sizes="152x152" href="apple-touch-icon.png">
<link rel="apple-touch-icon" sizes="60x60" href="apple-touch-icon-60x60.png">
<link rel="apple-touch-icon" sizes="76x76" href="apple-touch-icon-76x76.png">
<link rel="apple-touch-icon" sizes="114x114" href="apple-touch-icon-114x114.png">
<link rel="apple-touch-icon" sizes="120x120" href="apple-touch-icon-120x120.png">
<link rel="apple-touch-icon" sizes="144x144" href="apple-touch-icon-144x144.png">
<meta name="msapplication-TileImage" content="favicon-144.png">
<meta name="msapplication-TileColor" content="#FFFFFF">

<link rel="stylesheet" href="themes/orzhc/style/style.css">
<link rel="stylesheet" href="themes/orzhc/style/side_menu.css">
<link rel="stylesheet" href="themes/orzhc/style/owl.carousel.css">
<link rel="stylesheet" href="themes/orzhc/style/owl.theme.css">
<link rel="stylesheet" href="themes/orzhc/style/index.css">

<script src="themes/orzhc/js/jquery.js"></script>
<script src="themes/orzhc/js/jquery-migrate-1.1.1.js"></script>
<script src="themes/orzhc/js/jquery.easing.1.3.js"></script>
<script src="themes/orzhc/js/script.js"></script> 
<script src="themes/orzhc/js/superfish.js"></script>
<script src="themes/orzhc/js/side_menu.js"></script>
<script src="themes/orzhc/js/jquery.equalheights.js"></script>
<!-- <script src="themes/orzhc/js/jquery.mobilemenu.js"></script> -->
<script src="themes/orzhc/js/tmStickUp.js"></script>
<script src="themes/orzhc/js/jquery.ui.totop.js"></script>
<script src="themes/orzhc/js/owl.carousel.min.js"></script>
<script src="themes/orzhc/js/index.js"></script>

<script src="themes/orzhc/js/slider.js"></script>
<link rel="stylesheet" href="themes/orzhc/style/slider.css">

<link rel="stylesheet" href="themes/orzhc/js/map_arob/leaflet/leaflet.css" />
<link rel="stylesheet" href="themes/orzhc/js/map_arob/Leaflet.EasyButton/easy-button.css" />
<link rel="stylesheet" href="themes/orzhc/js/map_arob/Leaflet.fullscreen/leaflet.fullscreen.css" />
<link rel="stylesheet" href="themes/orzhc/js/map_arob/map_arob-UImap_arob/map_arob.editmap/editmap.css" />
<link rel="stylesheet" href="themes/orzhc/js/map_arob/map_arob-UImap_arob/map_arob.screenshot/screenshot.css" />
<link rel="stylesheet" href="themes/orzhc/js/map_arob/map_arob-UImap_arob/UImap_arob.proj/UImap_arob.proj.css">
<link rel="stylesheet" href="themes/orzhc/js/Leaflet.markercluster/dist/MarkerCluster.css">
<link rel="stylesheet" href="themes/orzhc/js/Leaflet.markercluster/dist/MarkerCluster.Default.css">
<link rel="stylesheet" href="themes/orzhc/js/map_arob/map_arob-UImap_arob/map_arob.editLayerProperties/editLayerProperties.css">

<?php echo $scripts_extra; ?>
<script>
jQuery(window).load(function(){
	jQuery().UItoTop({ easingType: 'easeOutQuart' });
	jQuery('#stuck_container').tmStickUp({});  
}); 
</script>
<script>
$(function() {
        /* données à afficher*/
		<?php echo $observation; ?>
        /* init propriétés de la map */
        map_arob.layer_tile.init({
            // obligatoire
            "mburl" : "https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", 
            // optionnel, par défault tous les tuiles suivantes sont integrées
            "tiles" : [
            	{
	                "id" : "vincent2b/ckacgndr602if1iloq3zpxoif",
	                "nom" : "Outdoors",
	                "url_zxy" : "mapbox_zxy"
				},
            	/*{
	                "id" : "openstreetmap",
	                "nom" : "openstreetmap",
	                "url_zxy" : "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
	                "attribution" : "&copy; <a href=\'https://www.openstreetmap.org/copyright\'>OpenStreetMap</a> contributors"
				},*/
				{
	                "id" : "opentopomap",
	                "nom" : "opentopomap",
	                "url_zxy" : "https://c.tile.opentopomap.org/{z}/{x}/{y}.png",
	                "attribution" : "© OpenStreetMap contributors, SRTM | map style: © OpenTopoMap (CC-BY-SA)"
	            },
	            /*{
					id : "arobase_BDORTHO",
					nom : "BD-ORTHO corse",
					url_zxy : "https://bdortho.arobase.corsica/corsica/{z}/{x}/{y}.jpg",
					attribution : "Carte BD-ORTHO _ arobase.fr"
				},*/
	            {
	                "id" : "vincent2b/ckadls8ql0l7k1ilo0lps4swq",
	                "nom" : "Satellite monde",
	                "url_zxy" : "mapbox_zxy"
				},
	            {
	                "id" : "vincent2b/ckadl6ni406ou1irtli71fwll",
	                "nom" : "Light",
	                "url_zxy" : "mapbox_zxy"
				}
			]
        });

        map_arob.CustomIconMarker.setCustomRootPath("themes/orzhc/js/map_arob/");
        (map_arob.editmap = new editmap(true)).init({
            stylePolygonDefault: {
                color: "#111111",
                weight: 2,
                fillColor: "#111111",
                fillOpacity: 0.2
            },
            styleBackgroundPolygonDefault : {
                color: "#2e6da4",
                weight: 2,
                fillColor: "#049fff",
                fillOpacity: 0.4
            },
            styleLineStringDefault : {
                color: "#FF2600",
                weight: 5
            },
            buttonsEdition : [],
            displayControlBackground : false
        });
        map_arob.editLayerProperties.init({
            "disable" : true,  //masque les boutons d'édition de données 
            "allowStyleJsonEdit" :  true
        });
        
        /* init carto avec les valeurs converties sous forme geojson */
        if (dataset.length > 0) {
            var Buffer = require("buffer").Buffer;
            var wkx = require("wkx");
            var wkbBuffer = null;
            var geometry = null;
            dataset.forEach(function(item){
                wkbBuffer = new Buffer(item.centre, "hex");
                geometry = wkx.Geometry.parse(wkbBuffer);
                item.geometry = geometry.toGeoJSON();
            });
            var mon_geo_json_init = {
                                        "type": "FeatureCollection",
                                        "name" : "Observations trouvées",
                                        "features": []
                                    };
            dataset.forEach(function(item){
                mon_geo_json_init.features.push({ 
                                                    "type": "Feature",
                                                    "geometry": item.geometry,
                                                    "properties": {
                                                                    "date":item.date,
                                                                    "nombre": item.nombre
                                                                }
                                                });
            });

            map_arob.editmap.SET_backgroundGeojson(mon_geo_json_init);
            var map_bound = map_arob.editmap.BGLayers.getLayers()[map_arob.editmap.BGLayers.getLayers().length - 1].getBounds();
            if (map_bound.isValid()) {
                map_arob.map.fitBounds(map_bound, {"maxZoom" : 15});
            }
            else {
                map_arob.map.panTo(new L.latLng(43.5,7));
                map_arob.map.setZoom(4);
            }
        }
        else {
            map_arob.map.panTo(new L.latLng(43.5,7));
            map_arob.map.setZoom(6);
        }
        map_arob.map.setMinZoom(3);

        /* personnalisation des icones */
        map_arob.map.eachLayer(function (layer) {
            var icon_file = "themes/orzhc/js/map_arob/map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-red.png"
            if (typeof layer.feature != "undefined") {
                if (typeof layer.feature.properties != "undefined") {
                    var taille_icone = tailleIcone(layer.feature.properties);
                    var new_icon = L.Icon.extend({
                                                   options :{
                                                              iconUrl: icon_file,
                                                              iconSize: taille_icone,
                                                              iconAnchor: ancre_icone(taille_icone)
                                                            }
                                                });
                    layer.setIcon(new new_icon);
                }
            }
        });

        /* regroupement des observations en clusters */
        var markers_grouped = L.markerClusterGroup();
        map_arob.map.eachLayer(function (layer) {
            if (typeof layer.feature != "undefined") {
                markers_grouped.addLayer(layer);
                map_arob.map.removeLayer(layer);//pour éviter d\'avoir des doublons
            }
        });
        map_arob.map.addLayer(markers_grouped);

    });
    function ancre_icone(taille_icone) {
        var y = taille_icone[1];
        var x = Math.floor(taille_icone[0]/2);
        return [x,y];
    }
    function tailleIcone(properties) {
        return [20, 33];
    }
</script>


<!--[if lt IE 8]>
 <div style=' clear: both; text-align:center; position: relative;'>
   <a href="http://windows.microsoft.com/en-US/internet-explorer/products/ie/home?ocid=ie6_countdown_bannercode">
     <img src="http://storage.ie6countdown.com/assets/100/images/banners/warning_bar_0000_us.jpg" border="0" height="42" width="820" alt="You are using an outdated browser. For a faster, safer browsing experience, upgrade for free today." />
   </a>
</div>
<![endif]-->
<!--[if lt IE 9]>
<script src="js/html5shiv.js"></script>
<link rel="stylesheet" media="screen" href="themes/orzhc/style/ie.css">
<![endif]-->
<!-- Global site tag (gtag.js) - Google Analytics -->
<!-- <script async src="https://www.googletagmanager.com/gtag/js?id=UA-114004451-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'UA-114004451-1');
</script>-->
</head>
<body>
<!-- ==================================
		Menu mobile
  =================================== -->
	<div id="mySidenav" class="sidenav">
        <?php echo $bouton_search_menu; ?>
		<a href="javascript:void(0)" class="closebtn" onclick="sidenav.closeNav()">&nbsp;&times;&nbsp;</a>
        <?php echo $menuhaut1_mobile; ?>
    </div>
    <span id="bouton_sandwich" onclick="sidenav.openNav()">
        <i class="fa fa-bars" aria-hidden="true"></i>
    </span>
	<div id="myBackGroundSidenav" style="display:none;" onclick="sidenav.closeNav()"></div>
<!--==============================
              header
=================================-->
	<header>
		<?php echo $popupSearch; ?>
		<div class="container">
			<div class="row">
				<div class="grid_6 rel">
					 <h1 style="float: none;">
						<a href="index.php"> <img src="themes/orzhc/images/logo_site.jpg" alt="Logo Observatoire Régional des Zones Humides de Corse" id="header_logo">
						</a>
					</h1>
				</div>
				<div class="grid_6 rel">
					<?php echo $userlogheader; ?>
				</div>
			</div>
		</div>
		<section id="stuck_container">
<!--==============================
            Stuck menu
=================================-->
			<div class="container">
				<div class="row">
					<div class="grid_12 ">
						<div class="navigation ">
							<nav><?php echo $menuhaut1; ?>
								<div id="menuopt">
									<a href="javascript:void(0)" class="btn_alternate mt0 gosearch"><div class="count"><i class="fa fa-search" aria-hidden="true" title="Recherche"></i></div></a>
								</div>
							</nav>
							<div class="clear"></div>
						</div>
						<div class="clear"></div>
					</div>
				</div>
			</div>
		</section>
	</header>
	<section>
    	<div id="slider">
    		<?php echo $liste_images; ?>
    		<div class="piedslider">
    			<div class="container">
					<div class="row">
						<div class="grid_1"></div>
						<div class="grid_10 titre ta__center">
            				BIENVENUE SUR LE SITE DE <br />L'OBSERVATOIRE RÉGIONAL DES ZONES HUMIDES DE CORSE&nbsp;!
            			</div>
            			<div class="grid_1"></div>
            			<!-- <div class="grid_5 slogan">
            				L'ORZHC émane d'une réfexion commune entre les différents acteurs insulaires, afin de préserver, valoriser, gérer et restaurer les zones humides corses.
            			</div>-->
					</div>
				</div>
    		</div>
    	</div>
	</section>
	<section id="action_accueil">
    	<?php echo $pageaccueilaction; ?>
    </section>
    <section id="news" class="">
		<?php echo $news; ?>
	</section>
	<section id="signalements">
		<?php echo $pageaccueil; ?>
	</section>
	<section id="financeurs">
		<?php echo $pageaccueilfinanceurs; ?>
	</section>
<!--==============================
              footer
=================================-->
<footer id="footer">
	<div class="container">
		<div class="row">
			<div class="grid_3">
				<img src="themes/orzhc/images/oec.png" alt="Logo Office de l'Environnement de la Corse" id="footer_logo" style="border: 3px solid #fff; margin-top: 3px; margin-bottom: 20px;">
			</div>
			<div class="grid_3">
				<p class="title condensed">OFFICE DE L'ENVIRONNEMENT DE&nbsp;LA&nbsp;CORSE</p>
				<p>Office de l'Environnement de la Corse<br />
Uffiziu di l'ambiente di a Corsica<br />
14, Avenue Jean Nicoli<br />
20250 Corte</p>
<p>Tél : <a href="tel:0495450400">04.95.45.04.00</a><br />
Courriel : <a href="mailto:contact@oec.fr">contact@oec.fr</a></p>
			</div>
			<div class="grid_3">
				<p class="title condensed ta__center">NOUS SUIVRE !</p>
				<p class = "ta__center"><img src="themes/orzhc/images/social_fb.png" style="max-width: 120px; margin-bottom: 8px;"><br />
				<img src="themes/orzhc/images/social_ig.png" style="max-width: 120px; margin-bottom: 8px;"></p>
			</div>
			<div class="grid_3">
				<p class="title condensed ta__center">INFOS PRATIQUES</p>
				<ul class="ul_">
    				<li class="mb10"><a href="#">Cartographie interactive</a></li>
                    <li class="mb10"><a href="#">Actualité</a></li>
                    <li class="mb10"><a href="#">Agenda</a></li>
                    <li class="mb10"><a href="#">Lettre des lagunes</a></li>
                    <li class="mb10"><a href="#">Base de données bibliographiques</a></li>
				</ul>
				<!-- <p>&diams; <a href="#">Cartographie interactive</a></p>
                <p>&diams; <a href="#">Actualité</a></p>
                <p>&diams; <a href="#">Agenda</a></p>
                <p>&diams; <a href="#">Lettre des lagunes</a></p>
                <p>&diams; <a href="#">Base de données bibliographiques</a></p>-->
			</div>
		</div>
		<div class="row">
			<div class="grid_12">
				<div class="copyright">
					<?php echo $menubas1; ?>
				</div>
			</div>
		</div>
	</div>
</footer>
<section id="logosanime">
	<?php echo $pageaccueillogos; ?>
</section>
<a href="#" id="toTop" class="fa fa-chevron-up"></a>
<script src="themes/orzhc/js/wkx/dist/wkx.min.js"></script>
    
<script src="themes/orzhc/js/map_arob/leaflet/leaflet.js"></script>
<script src="themes/orzhc/js/map_arob/Editable/Leaflet.Editable.js"></script>
<script src="themes/orzhc/js/map_arob/leaflet.filelayer/togeojson.js"></script>
<script src="themes/orzhc/js/map_arob/leaflet.filelayer/leaflet.filelayer.js"></script>
<script src="themes/orzhc/js/map_arob/Leaflet.EasyButton/easy-button.js"></script>
<script src="themes/orzhc/js/map_arob/Leaflet.leaflet-image/leaflet-image.js"></script>
<script src="themes/orzhc/js/map_arob/Leaflet.fullscreen/Leaflet.fullscreen.min.js"></script>
<script src="themes/orzhc/js/map_arob/Leaflet.TileLayer.Fallback/leaflet.tilelayer.fallback.js"></script>
<script src="themes/orzhc/js/map_arob/map_arob-UImap_arob/UImap_arob.proj/proj4js-2.5.0/dist/proj4-src.js"></script>
<script src="themes/orzhc/js/map_arob/map_arob-UImap_arob/map_arob.map-only.full.js"></script>
<script src="themes/orzhc/js/map_arob/lang_fr.js"></script>

<script src="themes/orzhc/js/Leaflet.markercluster/dist/leaflet.markercluster.js"></script>
</body>
</html>