<?php
/*     les liens gnrs sont pour la version mobile !     */

	class utils_last2manifs {
		function htm2txt_sf($text) {
			// Cre un tableau contenant les codes ascii des caractres ayant un codage en html
			$ascii_array=array_merge(array(34,38,60,62),range(160,255));
		
			// Cre un tableau contenant les caractres correspondants aux codes ascci prcdents
			$chars_array=array_map("chr", $ascii_array);
		
			// Cre un tableau contenant les mmes caractres au format html
			$html_array=array_map("htmlentities", $chars_array);
		
			// Remplace les codes html par leurs quivalents txt dans le texte
			for($i=0; $i<count($ascii_array); $i++) {
				//$text=preg_replace("#$html_array[$i]#",$chars_array[$i],$text);
				$text=str_replace($html_array[$i],$chars_array[$i],$text);
			}
		
			// Remplace les sauts de ligne html <br> par \n dans le texte
			$text=preg_replace("#<br>#","\n",$text);
		
			// Supprime les ventuelles balises html et php
			$text=strip_tags($text);
		
			// Retourne le texte trait
			return($text);
		}
		
		function reduiretexte_sf($texte,$lim=100) {
			if ($texte == "") return "";
			if (preg_match_all("#(<script[^>]*>)(.*)(</script>)#imsU", $texte, $matches)) {
				for ($i=1;$i<count($matches); $i++) {
					$texte = str_replace($matches[$i], "", $texte);
				}
			}
			$texte = $this->htm2txt_sf($texte);
			if (strlen($texte) <= $lim) return $texte;
			$pos = strlen($texte);
			$lastpos = strpos($texte, " ");
			while($lastpos < $lim && $pos != $lastpos && $lastpos !== false) {
				$pos = $lastpos;
				$lastpos = strpos($texte, " ",($lastpos+1));
			}
			return substr($texte, 0, $pos)." ...";
		}
		
		function date2JMA($ladate, $formatdate="d/m/Y H:i:s"){
			if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
				return "";
			}
			else {
				list($lejour,$lemoment) = explode(" ",$ladate);
				list($an,$mois,$jour) = explode("-",$lejour);
				if ($lemoment != "") {
					list($heure, $minute,$seconde) = explode(":", $lemoment);
				}
				else {
					list($heure, $minute,$seconde) = array(0,0,0);
				}
				$ladate = date($formatdate, mktime($heure, $minute,$seconde, $mois,$jour,$an));
				return $ladate;
				//return preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#i","\\3/\\2/\\1",$ladate);
			}
		}
	}
	
	$utilsmanifs = new utils_last2manifs();
	
	global $withrewriting, $prefix, $db, $locale;
	setlocale(LC_TIME, "$locale");
	
	/*
	$sql = "SELECT sid,title,time,hometext,bodytext from ".$prefix."_stories where status='P'".$querylang."AND topic=8 ORDER BY time DESC limit 2";
	$result = $db->sql_query($sql);
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query');
	}
	*/
	
	$datejour = date("Y-m-d");
	$where = " WHERE status='P'".$querylang."AND topic=8 AND time>='".$datejour."'";
	$limite = " LIMIT 0,2";
	$result = $db->sql_query("select sid,title,time,hometext,bodytext from ".$prefix."_stories $where order by time ASC $limite;");
	if ($db->sql_numrows($result) < 2) {
		$limite = " LIMIT 0,2";
		$where = " WHERE status='P'".$querylang."AND topic=8";
		$result = $db->sql_query("select sid,title,time,hometext,bodytext from ".$prefix."_stories $where order by time DESC $limite");
	}
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query');
	}
	
	$content = "";
	while(list($sid, $title, $time, $hometext, $bodytext) = $db->sql_fetchrow($result)) {
		$texteactu = $utilsmanifs->reduiretexte_sf($bodytext." ".$hometext, 300);
		$dateactu = strftime("%d %B %Y",$utilsmanifs->date2JMA($time,"U"));
		if (!$withrewriting) {
			$pagename = "";
			$urlprefix = "mobiles.php?name=News&op=viewactu&sid=";
			$urlmedium = "";
			$urlpostfix = "";
		}
		else {
			$pagename = $title;
			if (strlen($pagename) > $maxtitlerewriting) {
				do {
					$pagename = substr($pagename, 0, strrpos($pagename, " "));
				} while(strlen($pagename) > $maxtitlerewriting);
			}
			$urlprefix = "";
			$urlmedium = "_mactu_";
			$urlpostfix = ".htm";
		}
		
		$link = $urlprefix.normalize_name($pagename).$urlmedium.$sid.$urlpostfix;
		$content .= '
		<div class="block-2">
			<div class="text4"><a href="'.$link.'" class="color4">'.$title.'</a></div>
			<strong><a href="'.$link.'" class="color4">'.$dateactu.'</a></strong><br />
			<a href="'.$link.'" class="color4">'.nl2br(trim($texteactu)).'</a>
		</div>';
	}
	
	$link = "mobiles.php?name=News&new_topic=8";
	
	$content .= '
		<div class="top_36">
			<a href="'.$link.'" class="btn" data-type="submit">Voir plus</a>
		</div>
	';

?>