<?php
/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2010 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * This is the File Manager Connector for PHP.
 */

function GetFolders( $resourceType, $currentFolder )
{
	// Map the virtual path to the local server path.
	$sServerDir = ServerMapFolder( $resourceType, $currentFolder, 'GetFolders' ) ;

	// Array that will hold the folders names.
	$aFolders	= array() ;

	$oCurrentFolder = @opendir( $sServerDir ) ;

	if ($oCurrentFolder !== false)
	{
		while ( $sFile = readdir( $oCurrentFolder ) )
		{
			if ( $sFile != '.' && $sFile != '..' && is_dir( $sServerDir . $sFile ) && !preg_match("/^\./i",$sFile))
				$aFolders[] = '<Folder name="' . ConvertToXmlAttribute( $sFile ) . '" />' ;
		}
		closedir( $oCurrentFolder ) ;
	}

	// Open the "Folders" node.
	echo "<Folders>" ;

	natcasesort( $aFolders ) ;
	foreach ( $aFolders as $sFolder )
		echo $sFolder ;

	// Close the "Folders" node.
	echo "</Folders>" ;
}

function GetFoldersAndFiles( $resourceType, $currentFolder, $sortFiles="" )
{
	// Map the virtual path to the local server path.
	$sServerDir = ServerMapFolder( $resourceType, $currentFolder, 'GetFoldersAndFiles' ) ;

	// Arrays that will hold the folders and files names.
	$aFolders	= array() ;
	$aFiles		= array() ;
	$tab_aFiles = array() ;
	
	#
	/*if ($oCurrentFolder = opendir($sServerDir)) {
		while (false !== ($sFile = readdir($oCurrentFolder))) {*/
		
	$oCurrentFolder = opendir( $sServerDir ) ;

	if ($oCurrentFolder !== false)
	{
		while ( $sFile = readdir( $oCurrentFolder ) )
		{
			if ( $sFile != '.' && $sFile != '..' && $sFile != 'index.html' && !preg_match("/^\./i",$sFile))
			{
				if ( is_dir( $sServerDir . $sFile ) )
					$aFolders[] = '<Folder name="' . ConvertToXmlAttribute( $sFile ) . '" />' ;
				else
				{
					$iFileSize = @filesize( $sServerDir . $sFile ) ;
					if ( !$iFileSize ) {
						$iFileSize = 0 ;
					}
					if ( $iFileSize > 0 )
					{
						$iFileSize = round( $iFileSize / 1024 ) ;
						if ( $iFileSize < 1 )
							$iFileSize = 1 ;
					}

					$mod_file_date = filemtime($sServerDir . $sFile);//modif Vince pour permettre le tri des fichiers
					$ext = strtolower(substr(strrchr($sFile, '.'), 1));
					if ($ext == "jpg" || $ext == "jpeg" || $ext == "gif" || $ext == "png") {
						$size = @getimagesize($sServerDir . $sFile);
						$width = $size[0];
						$height = $size[1];
						$pictsize = "";
						if ($width != 0 && $height != 0) {
							$pictsize = $width.'x'.$height;
						}
					}
					$tab_aFiles[] = array("name"=>ConvertToXmlAttribute( $sFile ), "size"=>$iFileSize, "date"=>$mod_file_date, "pictsize"=>$pictsize);//modif Vince pour permettre le tri des fichiers
				//$mod_file_date = date("d/m/Y H:i:s",filemtime($sServerDir . $sFile));
				//$aFiles[] = '<File name="' . ConvertToXmlAttribute( $sFile ) . '" size="' . $iFileSize . '" date="'.$mod_file_date.'"/>' ;
				}
			}
		}
		closedir( $oCurrentFolder ) ;
	}

	$lignename = array();//modif Vince pour permettre le tri des fichiers
	$lignesize = array();
	$lignedate = array();
	foreach ($tab_aFiles as $key => $row) {
	    $lignename[$key]  = $row['name'];
	    $lignesize[$key] = $row['size'];
	    $lignedate[$key] = $row['date'];
	}
	
	switch ($sortFiles) {
		case "name_asc":
			array_multisort($lignename, SORT_ASC, $lignedate, SORT_ASC, $tab_aFiles); //tri par rapport au nom puis  la date
			break;
		case "name_desc":
			array_multisort($lignename, SORT_DESC, $lignedate, SORT_ASC, $tab_aFiles); //tri par rapport au nom puis  la date
			break;
		case "date_asc":
			array_multisort($lignedate, SORT_ASC, $lignename, SORT_ASC, $tab_aFiles); //tri par rapport  la date puis au nom
			break;
		case "date_desc":
			array_multisort($lignedate, SORT_DESC, $lignename, SORT_ASC, $tab_aFiles); //tri par rapport  la date puis au nom
			break;
		case "size_asc":
			array_multisort($lignesize, SORT_ASC, $lignename, SORT_ASC, $tab_aFiles); //tri par rapport  la taille puis au nom
			break;
		case "size_desc":
			array_multisort($lignesize, SORT_DESC, $lignename, SORT_ASC, $tab_aFiles); //tri par rapport  la taille puis au nom
			break;
		default :
			array_multisort($lignedate, SORT_DESC, $lignename, SORT_ASC, $tab_aFiles); //tri par rapport  la date puis au nom
			break;
	}
	
	foreach ($tab_aFiles as $tab_aFile) {
		$aFiles[] = '<File name="' . ConvertToXmlAttribute( $tab_aFile["name"] ) . '" size="' . $tab_aFile["size"] . '" date="'.date("d/m/Y H:i:s",$tab_aFile["date"]).'" pictsize="'.$tab_aFile["pictsize"].'"/>' ;
	}//fin modif Vince pour permettre le tri des fichiers


	// Send the folders
	natcasesort( $aFolders ) ;
	echo '<Folders>' ;

	foreach ( $aFolders as $sFolder )
		echo $sFolder ;

	echo '</Folders>' ;

	// Send the files
	//natcasesort( $aFiles ) ;
	echo '<Files>' ;

	foreach ( $aFiles as $sFiles )
		echo $sFiles ;

	echo '</Files>' ;
}

function CreateFolder( $resourceType, $currentFolder )
{
	if (!isset($_GET)) {
		global $_GET;
	}
	$sErrorNumber	= '0' ;
	$sErrorMsg		= '' ;

	if ( isset( $_GET['NewFolderName'] ) )
	{
		$sNewFolderName = $_GET['NewFolderName'] ;
		$sNewFolderName = SanitizeFolderName( $sNewFolderName ) ;

		if ( strpos( $sNewFolderName, '..' ) !== FALSE )
			$sErrorNumber = '102' ;		// Invalid folder name.
		else
		{
			// Map the virtual path to the local server path of the current folder.
			$sServerDir = ServerMapFolder( $resourceType, $currentFolder, 'CreateFolder' ) ;

			if ( is_writable( $sServerDir ) )
			{
				$sServerDir .= $sNewFolderName ;

				$sErrorMsg = CreateServerFolder( $sServerDir ) ;

				switch ( $sErrorMsg )
				{
					case '' :
						$sErrorNumber = '0' ;
						break ;
					case 'Invalid argument' :
					case 'No such file or directory' :
						$sErrorNumber = '102' ;		// Path too long.
						break ;
					default :
						$sErrorNumber = '110' ;
						break ;
				}
			}
			else {
				die("arrete brutal");
				$sErrorNumber = '103' ;
			}
		}
	}
	else
		$sErrorNumber = '102' ;

	// Create the "Error" node.
	echo '<Error number="' . $sErrorNumber . '" />' ;
}

function FileUpload( $resourceType, $currentFolder, $sCommand ) {
	if (!isset($_FILES)) {
		global $_FILES;
	}
	$sErrorNumber = '0' ;
	$sFileName = '' ;

	if ( isset( $_FILES['NewFile'] ) && !is_null( $_FILES['NewFile']['tmp_name'] ) ){
		global $Config ;

		$oFile = $_FILES['NewFile'] ;

		// Map the virtual path to the local server path.
		$sServerDir = ServerMapFolder( $resourceType, $currentFolder, $sCommand ) ;

		// Get the uploaded file name.
		$sFileName = $oFile['name'] ;
		$sFileName = SanitizeFileName( $sFileName ) ;

		$sOriginalFileName = $sFileName ;

		// Get the extension.
		$sExtension = substr( $sFileName, ( strrpos($sFileName, '.') + 1 ) ) ;
		$sExtension = strtolower( $sExtension ) ;

		if ( isset( $Config['SecureImageUploads'] ) ) {
			if ( ( $isImageValid = IsImageValid( $oFile['tmp_name'], $sExtension ) ) === false ) {
				$sErrorNumber = '202' ;
			}
		}

		if ( isset( $Config['HtmlExtensions'] ) ) {
			if ( !IsHtmlExtension( $sExtension, $Config['HtmlExtensions'] ) &&
			( $detectHtml = DetectHtml( $oFile['tmp_name'] ) ) === true )
			{
				$sErrorNumber = '202' ;
			}
		}

		// Check if it is an allowed extension.
		if ( !$sErrorNumber && IsAllowedExt( $sExtension, $resourceType ) ) {
			$iCounter = 0 ;

			while ( true ) {
				$sFilePath = $sServerDir . $sFileName ;

				if ( is_file( $sFilePath ) )
				{
					$iCounter++ ;
					$sFileName = RemoveExtension( $sOriginalFileName ) . '(' . $iCounter . ').' . $sExtension ;
					$sErrorNumber = '201' ;
				}
				else {
					if (($Config['MaxWidthImageUpload'] != "" && $Config['MaxWidthImageUpload'] != "0") || ($Config['MaxHeightImageUpload'] != "" && $Config['MaxHeightImageUpload'] != "0")) {
						if ($Config['MaxWidthImageUpload'] == "" || $Config['MaxWidthImageUpload'] == "0") {
							$Config['MaxWidthImageUpload'] = 0;
						}
						if ($Config['MaxHeightImageUpload'] == "" || $Config['MaxHeightImageUpload'] == "0") {
							$Config['MaxHeightImageUpload'] = 0;
						}
						//Fonction permettant le redimenssionement des images
						$filename = $oFile['tmp_name'];	//ou = $_FILES['NewFile']['tmp_name']
						$size = getimagesize($filename);
						$width = $size[0];
						$height = $size[1];

						//test si les dimensions de l'image sont correctes et sinon applique le redimensionement
						if (($width > $Config['MaxWidthImageUpload'] && $Config['MaxWidthImageUpload'] != "0") || ($height > $Config['MaxHeightImageUpload'] && $Config['MaxHeightImageUpload'] != "0")) {
							//calcul nouvelle taille
							$delta_x = 0;
							$delta_y = 0;
							if ($Config['MaxHeightImageUpload'] == 0) { //calcul uniquement en fonction de la largeur
								$newwidth = $Config['MaxWidthImageUpload'];
								$newheight = ($height * $Config['MaxWidthImageUpload']) / $width;
								
								$widthdest = $newwidth;
								$heightdest = $newheight;
							}
							if ($Config['MaxWidthImageUpload'] == 0) { //calcul uniquement en fonction de la hauteur
								$newwidth = ($width * $Config['MaxHeightImageUpload']) / $height;
								$newheight = $Config['MaxHeightImageUpload'];
								
								$widthdest = $newwidth;
								$heightdest = $newheight;
								
							}
							if ($Config['MaxWidthImageUpload'] != 0 && $Config['MaxHeightImageUpload'] != 0) { //calcul pour crop
								$x_ratio = $Config['MaxWidthImageUpload'] / $width;
								$y_ratio = $Config['MaxHeightImageUpload'] / $height;
								$ratio = max($x_ratio,$y_ratio);
								
								$newwidth = ceil($ratio * $width);
								$newheight = ceil($ratio * $height);
								
								$delta_x = floor(($Config['MaxWidthImageUpload'] - $newwidth)/2);
								$delta_y = floor(($Config['MaxHeightImageUpload'] - $newheight)/2);
								
								$widthdest = $Config['MaxWidthImageUpload'];
								$heightdest = $Config['MaxHeightImageUpload'];
							}
							//pour les cas des jpg
							if($sExtension == 'jpg' || $sExtension == 'jpeg') {
								$src = imagecreatefromjpeg($filename);
								$tmp=imagecreatetruecolor($widthdest,$heightdest);
								imagecopyresampled($tmp,$src,$delta_x,$delta_y,0,0,$newwidth,$newheight,$width,$height);
								imagejpeg($tmp,$filename,70);
								imagedestroy($src);
								imagedestroy($tmp);
							}
							//pour les cas des gif
							if($sExtension == 'gif') {
								$src = imagecreatefromgif($filename);
								$tmp=imagecreatetruecolor($widthdest,$heightdest);
								$trans = imagecolorallocate($tmp,255,255,255);
								imagefilledrectangle($tmp,0,0,$newwidth,$newheight,$trans);
								imagecopyresampled($tmp,$src,$delta_x,$delta_y,0,0,$newwidth,$newheight,$width,$height);
								imageinterlace($tmp);
								imagegif($tmp,$filename);
								imagedestroy($src);
								imagedestroy($tmp);
							}
							//pour les cas des png
							if($sExtension == 'png') {
								$src = imagecreatefrompng($filename);
								$tmp=imagecreatetruecolor($widthdest,$heightdest);
								imagealphablending($tmp, false);
								imagesavealpha($tmp, true);
								imagecopyresampled($tmp,$src,$delta_x,$delta_y,0,0,$newwidth,$newheight,$width,$height);
								$fond_noir = imagecolorallocate($destination, 0, 0, 0);
								imagecolortransparent($destination, $fond_noir);
								imagepng($tmp,$filename);
								imagedestroy($src);
								imagedestroy($tmp);
							}
						}
					}
					if ( is_file( $sFilePath ) ) {
						if ( isset( $Config['ChmodOnUpload'] ) && !$Config['ChmodOnUpload'] ) {
							break ;
						}

						$permissions = 0777;

						if ( isset( $Config['ChmodOnUpload'] ) && $Config['ChmodOnUpload'] ) {
							$permissions = $Config['ChmodOnUpload'] ;
						}

						$oldumask = umask(0) ;
						chmod( $sFilePath, $permissions ) ;
						umask( $oldumask ) ;
					}
					move_uploaded_file( $oFile['tmp_name'], $sFilePath);
					break ;
				}
			}


			if ( file_exists( $sFilePath ) ) {
				//previous checks failed, try once again
				if ( isset( $isImageValid ) && $isImageValid === -1 && IsImageValid( $sFilePath, $sExtension ) === false ) {
					@unlink( $sFilePath ) ;
					$sErrorNumber = '202' ;
				}
				else if ( isset( $detectHtml ) && $detectHtml === -1 && DetectHtml( $sFilePath ) === true ) {
					@unlink( $sFilePath ) ;
					$sErrorNumber = '202' ;
				}
			}
		}
		else
		$sErrorNumber = '202' ;
	}
	else
	$sErrorNumber = '202' ;


	$sFileUrl = CombinePaths( GetResourceTypePath( $resourceType, $sCommand ) , $currentFolder ) ;
	$sFileUrl = CombinePaths( $sFileUrl, $sFileName ) ;

	SendUploadResults( $sErrorNumber, $sFileUrl, $sFileName ) ;

	exit ;
}
?>
