/*
 * jQuery File Upload Plugin JS Example
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 */

/* global $, window */

$(function () {
    'use strict';

    // Initialize the jQuery File Upload widget:
    $('#fileupload').fileupload({
        // Uncomment the following to send cross-domain cookies:
        //xhrFields: {withCredentials: true},
        url: 'javascripts/jQuery-File-Upload/server/php/'
    });

    // Enable iframe cross-domain access via redirect option:
    $('#fileupload').fileupload(
        'option',
        'redirect',
        window.location.href.replace(
            /\/[^\/]*$/,
            '/cors/result.html?%s'
        )
    );
/*debut ajout vince*/
$('#fileupload')
	.bind('fileuploadsubmit', function (e, data) {
	    var inputs = data.context.find(':input');
	    if (inputs.filter(function () {
	            return !this.value && $(this).prop('required');
	        }).first().focus().length) {
	        data.context.find('button').attr('disabled', false);
	        data.context.find('.start').attr('disabled', false);
	        return false;
	    }
	    data.formData = inputs.serializeArray();
	})
	.bind('fileuploadadded', function (e, data) {
		/* ajout de ficheir avant expédition */
		$.each(data.files, function (index, file) {
	        console.log('Added file: ' + file.name);
	        if (typeof callback_form == "object") {
	        	callback_form.fileplus();
	        }
	    });
	})
	.bind('fileuploadfailed', function (e, data) {
		/* fichiers supprimés avant upload par un cancel  */
		if (typeof data.files != "undefined") {
			if (typeof data.files.error == "undefined" || (typeof data.files.error != "undefined" && data.files.error != true)) {
				$.each(data.files, function (index, file) {
			        console.log('Deleted file: ' + file.name);
			        if (typeof callback_form == "object") {
			        	callback_form.filemoins();
			        }
			    });
			}
		}
	})
	.bind('fileuploaddone', function (e, data) {
		/* fichiers correctement uploadés */
		if (typeof data.files != "undefined") {
			$.each(data.files, function (index, file) {
		        console.log('Sent file: ' + file.name);
		        if (typeof callback_form == "object") {
		        	callback_form.filemoins();
		        }
		    });
		}
	})
;
if (typeof callback_form == "object") {
	callback_form.enable_form_submit();
}
/*fin ajout vince*/
    if (window.location.hostname === 'blueimp.github.io') {
        // Demo settings:
        $('#fileupload').fileupload('option', {
            url: '//jquery-file-upload.appspot.com/',
            // Enable image resizing, except for Android and Opera,
            // which actually support image resizing, but fail to
            // send Blob objects via XHR requests:
            disableImageResize: /Android(?!.*Chrome)|Opera/
                .test(window.navigator.userAgent),
            maxFileSize: 999000,
            acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i
        });
        // Upload server status check for browsers with CORS support:
        if ($.support.cors) {
            $.ajax({
                url: '//jquery-file-upload.appspot.com/',
                type: 'HEAD'
            }).fail(function () {
                $('<div class="alert alert-danger"/>')
                    .text('Upload server currently unavailable - ' +
                            new Date())
                    .appendTo('#fileupload');
            });
        }
    } else {
    	$('#fileupload').fileupload({
    	    // Enable image resizing, except for Android and Opera,
    	    // which actually support image resizing, but fail to
    	    // send Blob objects via XHR requests:
    	    //disableImageResize: /Android(?!.*Chrome)|Opera/.test(window.navigator && navigator.userAgent),
    	    disableImageResize: false,
    	    imageMaxWidth: 1920,
    	    imageMaxHeight: 1920,
    	    imageCrop: false, // Force cropped images
    	    maxFileSize: 32000000
    	    //acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i
    	});
        // Load existing files:
        $('#fileupload').addClass('fileupload-processing');
        $.ajax({
            // Uncomment the following to send cross-domain cookies:
            //xhrFields: {withCredentials: true},
            url: $('#fileupload').fileupload('option', 'url'),
            dataType: 'json',
            context: $('#fileupload')[0]
        }).always(function () {
            $(this).removeClass('fileupload-processing');
        }).done(function (result) {
            $(this).fileupload('option', 'done')
                .call(this, $.Event('done'), {result: result});
        });
    }

});
