<?php

if (!preg_match("#system_mobile.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight("Sections")) {
		
	function date2JMA($ladate, $formatdate="d/m/Y H:i:s"){
		if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($lejour,$lemoment) = explode(" ",$ladate);
			list($an,$mois,$jour) = explode("-",$lejour);
			if ($lemoment != "") {
				list($heure, $minute,$seconde) = explode(":", $lemoment);
			}
			else {
				list($heure, $minute,$seconde) = array(0,0,0);
			}
			$ladate = date($formatdate, mktime($heure, $minute,$seconde, $mois,$jour,$an));
			return $ladate;
		}
	}
	
	function getTopicList() {
		global $db, $prefix;
		
		$topicList = array();
		$result = $db->sql_query("select topicid, topicname, count(".$prefix."_events.eid) as nbre from ".$prefix."_topics left join ".$prefix."_events on ".$prefix."_topics.topicid=".$prefix."_events.topic where topicname <> '' group by topicid order by topicname ASC");
		while (list($topicid, $topicname, $nbre) = $db->sql_fetchrow($result)) {
			$topicList[]= array($topicid, $topicname, $nbre);
		}
		$db->sql_freeresult($result);
		return $topicList;
	}
	
	function getAlbumList() {
		global $db, $prefix;
		
		$albumList = array();
		$result = $db->sql_query("select albumid, album_name from ".$prefix."_gallery_album order by album_name ASC");
		while (list($albumid, $album_name) = $db->sql_fetchrow($result)) {
			$albumList[]= array($albumid, $album_name);
		}
		$db->sql_freeresult($result);
		return $albumList;
	}
	
	function getAgendaList($topicid,$langRestrict=""){
		global $db, $prefix, $multilingual;
		
		$agendaList = array();
		$cond = "";
		if ($topicid !="") {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .= " topic=$topicid";
		}
		/*if ($multilingual == 1 && $langRestrict != "" && $langRestrict != "All") {
			if ($cond != "") {
				$cond .= " AND";
			}
			$cond .= " alanguage='$langRestrict'";
		}*/
		if ($cond != "") {
			$cond = " WHERE".$cond;
		}

		$result = $db->sql_query("select eid, title, eventDate, endDate, startTime, endTime, informant from ".$prefix."_events $cond order by `startTime` desc;");

		while ($ligne = $db->sql_fetchrow($result)) {
			$agendaList[]= array($ligne["eid"], $ligne["title"], $ligne["eventDate"], $ligne["startTime"], $ligne["endDate"], $ligne["endTime"], $ligne["informant"]);
		}
		$db->sql_freeresult($result);
		return $agendaList;
	}
	
	function getAgendaContent($eid){
		global $db,$prefix;
		
		if ($eid =="") {
			return "";
		}
		else {
			$cond = "";
			if ($eid !="") {
				if ($cond != "") {
					$cond .= " AND";
				}
				$cond .= " eid=$eid";
			}
			
			if ($cond != "") {
				$cond = " WHERE".$cond;
			}			 	
			$result = $db->sql_query("select title, hometext, topic, aid, informant, eventDate, endDate, startTime, endTime, album from ".$prefix."_events $cond;");
			if ($ligne = $db->sql_fetchrow($result)) {
				$sortie= array(
					"title" => $ligne["title"],
					"hometext" => $ligne["hometext"],
					"topic" => $ligne["topic"],
					"aid" => $ligne["aid"],
					"informant" => $ligne["informant"],
					"eventDate" => $ligne["eventDate"],
					"startTime" => $ligne["startTime"],
					"endDate" => $ligne["endDate"],
					"endTime" => $ligne["endTime"],
					"album" => $ligne["album"]
				);
			}
			$db->sql_freeresult($result);
			return $sortie; 
		}
	}
	
	function list_agenda() {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $module_name;
    
	    $page_header_title = 'Liste des agendas';
	    
	    include ("system/header_system_mobile.php");
	   	
	    $sortie = "";
	    
	    $sortie .= '<div class="marge">';
	    
	    $topics = getTopicList();
	    $nbreactus = count(getAgendaList("0"));
	    if ($nbreactus > 0) {
	    	$topics[] = array("0", "Agenda sans sujet",$nbreactus);
	    }
	    $compteur = -1;
	    foreach ($topics as $onetopics) {
	    	if ($onetopics[2] > 0) {
		    	$compteur++;
		    	$sortie .= '
<div class="combo"><a href="javascript:void(0)" class="combo" id="btn_content'.$compteur.'">'.$onetopics[1].' ('.$onetopics[2].')'.'</a>
<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
	    	
		    	$listeagenda= '';
		    	$agendas = getAgendaList($onetopics[0]);
		    	foreach ($agendas as $oneagenda) {
		    		if ($oneagenda[2] != $oneagenda[4]) {
		    			$dateDeb = date2JMA($oneagenda[2]." ".$oneagenda[3],"d/m/Y H:i");
		    			$dateFin = date2JMA($oneagenda[4]." ".$oneagenda[5],"d/m/Y H:i");
		    			$date = 'Du '.$dateDeb.' au '.$dateFin;
		    		}
		    		else {
		    			if ($oneagenda[3] != $oneagenda[5]) {
			    			$dateDeb = date2JMA($oneagenda[2],"d/m/Y");
			    			$heureDeb = date2JMA($oneagenda[2]." ".$oneagenda[3],"H:i");
			    			$heureFin = date2JMA($oneagenda[4]." ".$oneagenda[5],"H:i");
			    			$date = 'Le '.$dateDeb.' de '.$heureDeb.'  '.$heureFin;
		    			}
		    			else {
		    				$dateDeb = date2JMA($oneagenda[2],"d/m/Y");
			    			$heureDeb = date2JMA($oneagenda[2]." ".$oneagenda[3],"H:i");
			    			$date = 'Le '.$dateDeb.'  '.$heureDeb;
		    			}
		    		}
		    		$listeagenda .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editagenda&eid='.$oneagenda[0].'">'.$oneagenda[1].' <span class="infos">'.$date.' - '.$oneagenda[6].$picto.'</span></a></li>';
		    	}
				if ($listeagenda != '') {
					$sortie .= '<ul class="collection-combo-docs">'.$listeagenda.'</ul>';
				}
	    	
				$sortie .= '
</div>
</div>';
	    	}
	    }
	    
	    //$sortie .= '<help><span style="display: inline-block"><img src="themes/System_mobile/images/desktop.png"> page au format desktop</span> <span style="display: inline-block"><img src="themes/System_mobile/images/mobile.png"> page au format mobile</span></help>';
	    
	    $sortie .= '</div>';
    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}

	function edit_agenda($eid) {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system, $admincontrolsection, $Default_Theme, $Default_Theme_mobile;	
		$contenu = array();
		$menutopics = '';
		if ($eid != "") {
			$contenu = getAgendaContent($eid);
		}
		else {
			$contenu= array(
					"title" => "",
					"hometext" => "",
					"topic" => 0,
					"aid" => $aid,
					"informant" => $aid,
					"eventDate" => date("Y-m-d"),
					"startTime" => date("H:i:s"),
					"endDate" => date("Y-m-d"),
					"endTime" => date("H:i:s"),
					"album" => -1
			);
		}		
		$topics = getTopicList();
		$menutopics = '<select name="data[topic]" class="saisie_text">';
		foreach($topics as $topic) {
			$selected = ($topic[0] == $contenu["topic"]) ? ' selected="selected"' : '';
			$menutopics .= '<option value="'.$topic[0].'"'.$selected.'>'.$topic[1].'</option>';
		}
		$menutopics .= '</select>';
		
		/*if ($admincontrolsection) {
		    if ($aid != $contenu["informant"] && !is_super($admin)) {
		    	display_denied();
		    	return;
		    }
	    }*/
		
		$albums = getAlbumList();
		$menualbums = '<select name="data[album]" class="saisie_text">';
		$menualbums .= '<option value="-1"'.$selected.'>Aucun album</option>';
		foreach($albums as $album) {
			$selected = ($album[0] == $contenu["album"]) ? ' selected="selected"' : '';
			$menualbums .= '<option value="'.$album[0].'"'.$selected.'>'.$album[1].'</option>';
		}
		$menualbums .= '</select>';
    
	    $page_header_title = 'dition d\'agenda';
	    
	    require_once 'system/modules/core/becmsTinyMCEconfig.php';
	    $header_system .= '<script src="javascripts/tinymce/tinymce.min.js"></script>
		<script>
		'.init_becms_tinymce("mobile_article",0).'
		</script>';
	    $header_system .= '
	    <script>
	    jQuery(document).ready(function(){
	    	jQuery("#debut").one("blur change", function(){  
				if (jQuery("#debut").val() > jQuery("#fin").val()) {
			    	jQuery("#fin").val(jQuery("#debut").val());
			    }
			});
		});
	    </script>';
	    
	    include ("system/header_system_mobile.php");
	    	    
	    $sortie = '';
	    
	    $sortie .= '
<form action="system_mobile.php" method="post" class="nomarge">
	<div class="marge">
		Titre de l\'agenda : <input type="text" name="data[title]" value="'.str_replace('"', "&quot;", $contenu["title"]).'" class="saisie_text" />
		Date de dbut : <input type="datetime-local" id="debut" name="data[debut]" value="'.date("Y-m-d\TH:i:s",strtotime($contenu["eventDate"]." ".$contenu["startTime"])).'" class="saisie_text" />
		Date de fin : <input type="datetime-local" id="fin" name="data[fin]" value="'.date("Y-m-d\TH:i:s",strtotime($contenu["endDate"]." ".$contenu["endTime"])).'" class="saisie_text" />
		Sujet : '.$menutopics.'
		Album associ : '.$menualbums.'
	</div>
	<textarea id="article" name="data[hometext]">'.$contenu["hometext"].'</textarea>
	<div class="marge"><input type="submit" value="Enregistrer l\'agenda" class="saisie_text submit" name="valid"></div>
	<input type="hidden" name="op" value="saveagenda" />
	<input type="hidden" name="data[eid]" value="'.$eid.'" />
	<input type="hidden" name="data[informant]" value="'.$contenu["informant"].'" />
	<input type="hidden" name="data[aid]" value="'.$contenu["aid"].'" />
</form>';
	    
	    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}

	function save_agenda($agenda) {
		global $page_header_title, $header_system;
		global $prefix, $db ;
		$agenda = array_map("FixQuotes", $agenda);
		$agenda = array_map("stripslashes", $agenda);
	
		$myservernotport="http://".$_SERVER['SERVER_NAME'];
		$agenda["hometext"] = str_replace($myservernotport,"",$agenda["hometext"]);
		$myservernotport="https://".$_SERVER['SERVER_NAME'];
		$agenda["hometext"] = str_replace($myservernotport,"",$agenda["hometext"]);
		
		$agenda["eventDate"] = date("Y-m-d",strtotime($agenda["debut"]));
		$agenda["startTime"] = date("H:i:s",strtotime($agenda["debut"]));
		$agenda["endDate"] = date("Y-m-d",strtotime($agenda["fin"]));
		$agenda["endTime"] = date("H:i:s",strtotime($agenda["fin"]));
		
		/*			"title" => "",
					"hometext" => "",
					"topic" => 0,
					"aid" => $aid,
					"informant" => $aid,
					"eventDate" => date("Y-m-d"),
					"startTime" => date("H:i:s"),
					"endDate" => date("Y-m-d"),
					"endTime" => date("H:i:s"),*/
    
	    if ($agenda["sid"] != "") {
		    $sql = "UPDATE ".$prefix."_events";
		    $sql .= " SET title='".$agenda["title"]."', hometext='".$agenda["hometext"]."', topic='".$agenda["topic"]."', aid='".$agenda["aid"]."', informant='".$agenda["informant"]."', eventDate='".$agenda["eventDate"]."', startTime='".$agenda["startTime"]."', endDate='".$agenda["endDate"]."', endTime='".$agenda["endTime"]."', album='".$agenda["album"]."'";
		    $sql .= " WHERE sid = ".$agenda["eid"]."";
			$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
	    }
	    else {
	    	$sql = "INSERT INTO ".$prefix."_events";
		    $sql .= " (title, hometext, topic, aid, informant, eventDate, startTime, endDate, endTime, album)";
		    $sql .= "VALUES ('".$agenda["title"]."','".$agenda["hometext"]."','".$agenda["topic"]."','".$agenda["aid"]."','".$agenda["informant"]."','".$agenda["eventDate"]."', '".$agenda["startTime"]."', '".$agenda["endDate"]."', '".$agenda["endTime"]."', '".$agenda["album"]."');"; 
	    	$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
	    }
		
		$header_system .= '
		<script>
			allerPage("system_mobile.php?op=listagenda",2000);
		</script>';
		
		$page_header_title = 'Enregistrement d\'agenda';
		include ("system/header_system_mobile.php");
		
		//enregistrement dans la base de donnes  faire
		
		$sortie = '<alert class="center_v_abs">Agenda enregistr</alert>';

		echo $sortie;
		include ("system/footer_system_mobile.php");
	}

	if (!isset($eid)) {
		$eid = "";
	}
	switch ($op) {
		case "newagenda":
		case "editagenda":
			edit_agenda($eid);
			break;
		case "saveagenda":
			save_agenda($data);
			break;
		case "listagenda":
		default:
			list_agenda();
			break;
	}
}
else {
	display_denied();
}

?>