<?php
/**
* Interface d'administration du module de Chuck Norris.
* 
* Cette valeur est fixe dans link.php.
* @package ChuckNorris
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2008, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight("Chuck_Norris_Facts")) {
//setPath(_TXT_Modules,0);
//setPath(_SIMPLECARTO,1);
//require_once("modules/$module_name/lib/g_db.php");
//require_once("modules/$module_name/lib/ba_adminsudoku.php");

function list_index($nbreFiches, $page, $ligne_par_page,$tab_words="") {
	if ($tab_words != "") {
		$tab_words = "&search_words=".urlencode($tab_words);
	}
	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);
	
	
	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._CHUCKFOUND;
	}
	else {
		$indexPages .= _CHUCKNOTFOUND;
	}
	$indexPages .= _CHUCKPAGES;
	if ($min < $liminf) {
		if ($min == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$min";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?op=chuck&action=list&page=$min".$tab_words."\">$min</a>";
			$indexPages .= "</div>";
		}
		if ($min < $liminf - 1) {
			$indexPages .= "...";
		}
	}
	for ($i=$liminf;$i<=$limsup;$i++) {
		if ($i == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$i";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?op=chuck&action=list&page=$i".$tab_words."\">$i</a>";
			$indexPages .= "</div>";
		}
	}
	if ($max > $limsup) {
		if ($max > $limsup + 1) {
			$indexPages .= "...";
		}
		if ($max == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$max";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?op=chuck&action=list&page=$max".$tab_words."\">$max</a>";
			$indexPages .= "</div>";
		}
		
	}
	$indexPages .= "</div>";
	return $indexPages;
}

function list_citations($page,$search_words="") {
	global $prefix, $db;
	
	$cond = "";
	if ($search_words != "") {
		$tab_words = explode(" ",$search_words);
		foreach($tab_words as $tab_word) {
			if ($cond == "") {
				$cond = " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$tab_word = str_replace("'","''",$tab_word);
			$cond .= " fact LIKE '%".$tab_word."%'";
		}
	}
	
	$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
	$ligne_par_page = 20;
	$result = $db->sql_query("SELECT count(Id) AS nbre FROM ".$prefix."_chuck_norris_facts".$cond.";");
	list($nbrefiches) = $db->sql_fetchrow($result);
	if ($page=="-1") {
		$page = ceil($nbrefiches/$ligne_par_page);
	}
	$liste .= list_index($nbrefiches, $page, $ligne_par_page,$search_words);
	$liste .= '</td><td width="50"></td><td>';
	$liste .= '<form name="search_form" action="system.php?op=chuck&action=search" method="POST">';
	$liste .= _CHUCKWORDSTOSEARCH.'<input type="text" name="search_words" value="'.$search_words.'">';
	$liste .= ' <input name="validsearch" type="submit" value="'._CHUCKSEARCHBTN.'">';
	$liste .= '</form>';
	$liste .= '</td></tr></table>';
	$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
	$result = $db->sql_query("SELECT Id, fact FROM ".$prefix."_chuck_norris_facts".$cond." ORDER BY Id LIMIT ".$limit.";");
	$liste .= '
			<table  class="lisTable">
			<tr class="systemTabHeader">
				<th class="systemTabHeader" style="text-align: left">'._CHUCKCITE.'</th>
    			<th class="systemTabHeader">'._CHUCKACTION.'</th>
	    		</tr>';
	$pos=0;
	if ($search_words != "") {
		$search_words = "&search_words=".urlencode($search_words);
	}
	while(list($Id, $fact) = $db->sql_fetchrow($result)) {
		$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=chuck&action=edit&onglet=list&page=".$page."&Id=".$Id.$search_words,"comment"=>_EDIT, "status"=>"ON"),
  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=chuck&action=delete&onglet=list&page=".$page."&Id=".$Id.$search_words,"comment"=>_DELETE,"status"=>"ON"));
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		$pos++;
		$liste .= '<tr class="'.$thestyle.'">';
		$liste .= '<td>';
		$longlim = 150;
		if (strlen($fact) > $longlim) {
			$i = $longlim;
			while (substr($fact,$i,1) != " ") {
				$i--;
			}
			$liste .= substr($fact,0,$i)."...";
		}
		else {
			$liste .= $fact;
		}
		$liste .= '</td><td align="center">';
		$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
		$liste .= '</td>';
		$liste .= '</tr>';
	}
	$liste .= '</table>';
	return $liste;
}

function edit_citation($Id, $page,$search_words="") {
	global $prefix, $db;
	$fact = "";
	if ($Id == "") {
		$Id = "-1";
	}
	if ($Id != "-1") {
		$result = $db->sql_query("SELECT Id,fact FROM ".$prefix."_chuck_norris_facts WHERE Id='".$Id."';");
		if (!$result) {
			die("DB problem");
		}
		list($Id,$fact) = $db->sql_fetchrow($result);
	}
	$sortie = '<form name="editfact" action="system.php?op=chuck&action=save&Id='.$Id.'" method="POST">';
	$sortie .= '<div align="center">';
	$sortie .= '&nbsp;<br />';
	$sortie .= '<textarea name="fact" cols="50" rows="20">'.$fact.'</textarea>';
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._CHUCKSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
	$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
	$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</div>';
	$sortie.= "</form>";
	return $sortie;
}

function save_citation ($Id,$fact,$page,$search_words="") {
	global $prefix, $db;
	$fact = stripslashes($fact);
	$fact = str_replace("'","''",$fact);
	if ($Id == "-1") {
		$result = $db->sql_query("INSERT INTO ".$prefix."_chuck_norris_facts (fact) VALUES ('".$fact."') WHERE Id='".$Id."';");
		$page = "-1";
	}
	else {
		$result = $db->sql_query("UPDATE ".$prefix."_chuck_norris_facts SET fact='".$fact."' WHERE Id='".$Id."';");
	}
	if (!$result) {
		die("DB problem");
	}
	return list_citations($page,$search_words);
}

function delete_citation($Id,$page,$search_words,$confirm="n") {
	global $prefix, $db;
	if ($Id != "") {
		if ($confirm == "y"){
			if($db->sql_query("DELETE FROM ".$prefix."_chuck_norris_facts WHERE Id='".$Id."';")) {
				return list_citations($page,$search_words);
			}
			else {
				die("DB problem");
			}
		}
		else {
			if ($search_words != "") {
				$search_words = "&search_words=".urlencode($search_words);
			}
			$sortie = "<div style=\"text-align: center; font-weight: bold\">";
			$sortie .= "<p>"._CHUCKCONFIRMDELETE."</p>";
			$sortie .= "<p>&nbsp;</p>";
			$sortie .= "<p>";
			$sortie .= '<a href="system.php?op=chuck&action=delete&onglet=list&page='.$page.'&Id='.$Id.$search_words.'&confirm=y">';
			$sortie .= "["._CHUCKYES."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._CHUCKNO."]";
			$sortie .= '</a>';
			$sortie .= "</p>";
			$sortie .= "</div>";
			return $sortie;
		}
	}
	return list_citations($page);
}

function import() {
	$sortie = '<form name="importfact" action="system.php?op=chuck&action=import_fact" method="POST" enctype="multipart/form-data">';
	$sortie .= '<div align="center">';
	$sortie .= '&nbsp;<br />';
	$sortie .= '<b>'._CHUCKIMPORTALERTS."</b>";
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= _CHUCKFILETOIMPORT.'<input type="file" name="file_facts" size="25">';
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._CHUCKIMPORTBTN.'" name="valid">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</div>';
	$sortie.= "</form>";
	return $sortie;
}

function import_fact() {
	global $prefix, $db;
	$chemin="catalog_repository";
	if ($_FILES["file_facts"]["name"] != "") {
		$nomDestination = $_FILES["file_facts"]["name"];
		if (is_uploaded_file($_FILES["file_facts"]["tmp_name"])) {
			$fichier = $chemin."/".$nomDestination;
			if (rename($_FILES["file_facts"]["tmp_name"],$fichier)) { 
				chmod($fichier,0777);
				if ($db->sql_query("TRUNCATE ".$prefix."_chuck_norris_facts")) {
					$source = fopen($fichier,"r");
					$fact = "";
					while (!feof($source)) {
						$ligne = fgets($source);
						if ($ligne != "%\n") {
							$fact .= $ligne;
						}
						else {
							$fact = trim($fact,"\n");
							$fact = str_replace("'","''",$fact);
							if (!$db->sql_query("INSERT INTO ".$prefix."_chuck_norris_facts (fact) VALUES ('".$fact."');")) {
								die("DB problem");
							}
							$fact = "";
						}
					}
					unlink($fichier);
					return list_citations("1");
				}
				else {
					die("DB problem");
				}
			}
			else {
				die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
			}          
		}
		else {
			die("Le fichier n'a pas t upload (trop gros ? droits ?)");
		}
	}
}
	
/**
* Renvoie l'interface d'administration de ce module.
* 
* La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
* Elle ne retourne aucune valeur mais effectue rellement l'affichage.
*/
function process_chuck(){
	global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$Id,$fact,$search_words;
		
	include("system/header_system.php");

	
	if (!isset($action) || $action == "") {
		$action = "list";
	}
	if (!isset($page) || $page == "") {
		$page = "1";
	}
	
	$sortie = "";
	$operationOnglet = "";
	
	switch ($action) {
		case "list" :
			$sortie = list_citations($page,$search_words);
			$operationOnglet = _CHUCKLIST;
			break;	
		case "delete" :
			$sortie = delete_citation($Id,$page,$search_words);
			$operationOnglet = _CHUCKLIST;
			break;
		case "edit" :
			$sortie = edit_citation($Id,$page,$search_words);
			$operationOnglet = _CHUCKEDIT;
			break;
		case "save" :
			$sortie = save_citation ($Id,$fact,$page,$search_words);
			$operationOnglet = _CHUCKLIST;
			break;
		case "new" :
			$sortie = edit_citation("-1","1");
			$operationOnglet = _CHUCKNEW;
			break;
		case "import" :
			$sortie = import();
			$operationOnglet = _CHUCKIMPORT;
			break;
		case "import_fact" :
			$sortie = import_fact();
			$operationOnglet = _CHUCKLIST;
			break;
		case "search" :
			$sortie = list_citations($page,$search_words);
			$operationOnglet = _CHUCKLISTFOUND;
			break;
	}
	
	if (!isset($onglet)) {
		$onglet = "list";
	}
	if ($onglet == "") {
		$onglet = "list";
	}
	$ongletDef=array("list"=> array( "text"=>_CHUCKONGLETLIST, "url"=>"system.php?action=list&op=chuck&onglet=list"),
                 "new"=> array( "text"=>_CHUCKONGLETNEW, "url"=>"system.php?action=new&op=chuck&onglet=new"),
					"import"=> array( "text"=>_CHUCKONGLETIMPORT, "url"=>"system.php?action=import&op=chuck&onglet=import"));
	
	echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_chuck.css\">";
    GraphicAdmin(_CHUCKMODULE);
	OpenOngletTable();
	displayOngletBar($onglet,$operationOnglet,$ongletDef);
	OpenSysTable();
	echo $sortie;
	CloseSysTable();
	CloseOngletTable();
    include("system/footer_system.php");    
}

/**
* Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
*/
switch ($op) {
    case "chuck":
    		process_chuck();
    		break;
	}
}
else {
    display_denied();
}

?>