var OAUTH2_CLIENT_ID = client_id_youtube;
var OAUTH2_SCOPES = "https://www.googleapis.com/auth/youtube https://www.googleapis.com/auth/youtube.upload https://www.googleapis.com/auth/youtubepartner";

var accessToken;

googleApiClientReady = function() {
	gapi.auth.init(function() {
		window.setTimeout(checkAuth, 1);
	});
}

function checkAuth() {
	gapi.auth.authorize({
		client_id: OAUTH2_CLIENT_ID,
		scope: OAUTH2_SCOPES,
		immediate: true
	}, handleAuthResult);
}

function signIn() {
	gapi.auth.authorize({
		client_id: OAUTH2_CLIENT_ID,
		scope: OAUTH2_SCOPES,
		immediate: false
	}, handleAuthResult);
}

function handleAuthResult(authResult) {
	if (authResult && !authResult.error) {
		accessToken = authResult['access_token'];
		loadAPIClientInterfaces();
	}
}

function loadAPIClientInterfaces() {
	gapi.client.load('youtube', 'v3', function() {
		handleAPILoaded();
	});
}

function handleAPILoaded() {
	var container = document.getElementById('login-container');
	if(container != null) {
		container.style.display = "none";
	}
	if( 'function' == typeof(initYouTube) )
		initYouTube();
}