/**
 * 
 */

function deleteVideo(videoID) {
	var request = gapi.client.youtube.videos.delete({
		id: videoID
	});
	request.execute(function(response) {
		//deleteVideoInPlayList(videoID);
	});
}

function deleteVideoInPlayList(videoID) {
	getChannel(videoID);
}

function getChannel(videoID) {
	$.ajax({
		url: CHANNELS_SERVICE_URL,
		method: 'GET',
		headers: {
			Authorization: 'Bearer ' + accessToken
		},
		data: {
			part: 'id,snippet',
			mine: true
		}
	}).done(function(response) {
		if( response.items.length == 1 ) {
			channelId = response.items[0].id;
			getPlayLists(channelId, videoID);
		}
	});
}

function getPlayLists(channelId, videoId) {
	$.ajax({
		url: PLAYLISTS_SERVICE_URL,
		method: 'GET',
		headers: {
			Authorization: 'Bearer ' + accessToken
		},
		data: {
			part: 'id,contentDetails',
			maxResults: 50,
			channelId: channelId
		}
	}).done(function(response) {
		if( response ) {
			for(var i = 0; i < response.items.length; i++) {
				if( videoId == response.items[i].contentDetails.videoId ) {
					deleteVideoPlayList(videoId, response.items[i].id);
				}
			}
		}
	});
}

/**
 * Peremt de supprimer la video
 */
function deleteVideoPlayList(videoId, id) {
	var request = gapi.client.youtube.playlistItems.delete({
		id: id
	});
	request.execute(function(response) {
		
	});
}