<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*   																	*/
/* Balsite Section Module . Stephan ACQUATELLA 2002						*/
/* Based on PHP Nuke Section module done by        						*/
/* Francisco Burzi (fbc@mandrakesoft.com)         						*/
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight("Sections")) {
setPath(_TXT_Edit,0);
setPath(_SECTIONSMANAGER,1);
/************************** Onglet definition ***********************/
$ongletDef=array("sections"=> array( "text"=>_SECTION,
                                   "url"=>"system.php?op=sections&onglet=sections"),
                 "cats"=> array( "text"=>_MULTICATS,
                                   "url"=>"system.php?op=sections&onglet=cats"),
                 "articles"=> array( "text"=>_SECPAGE,
                                   "url"=>"system.php?op=sections&onglet=articles"),
                 "NewActicle"=> array( "text"=>_NEW_SECPAGE,
                                   "url"=>"system.php?op=sections&onglet=NewActicle"),
				"NewActicleMobile"=> array( "text"=>"Nouvelle page mobile",
                                   "url"=>"system.php?op=sections&onglet=NewActicleMobile&mobile=1"),
                 "multicat"=> array( "text"=>_CAT_SECPAGE,
                                   "url"=>"system.php?op=sections&onglet=multicat")
                                   );


/*********************************************************/
/* Sections Manager Functions                            */
/*********************************************************/

require_once("includes/truncate_string.php");

/*--------------------------------------*/
/* 				sections()				*/
/* @abstract							*/
/* @param								*/
/* @see 								*/
/*--------------------------------------*/
function sections($onglet,$idsec, $min=0, $id_section="") {
    global $prefix, $db, $language, $multilingual, $ongletDef, $Default_Skin, $SkinPath, $header_system,$module_name,$op, $idsec;
	global $maxtitlerewriting, $withrewriting;
	global $aid, $admin,$admincontrolsection;
	
    $header_system .= '
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_AJAX.js"></script>
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_interface.js"> </script>
<script type="text/javascript">
	function categorize(id_art,id_sec, valid) {
		var value;
		if (valid) {
			value="1";
		}
		else {
			value= "0";
		}
		var results = GetAJAXData("system.php?op=categorizepage&id_art="+id_art+"&id_sec="+id_sec+"&valid="+value);
		/*if (results == "") {
			//window.location.reload();//inutile : les rsultats sont dj affich...
		}
		else {
			alert(results);
		}*/
		//alert(results);
		writeContent("bbbox_" + id_art, results);
		return true;
	}
	function hideCats(id) {
		showContent("b"+id);
		hideContent(id);
	}
	function showCats(id) {
		showContent(id);
		hideContent("b"+id);

		/*var elt = document.getElementById(id);
		elt.style.display= "block";
		var elt2 = document.getElementById("b"+id);
		elt2.style.display= "none";*/
	}
	function vdeskmob(ismobile, formulaire) {
		if (confirm("En tes vous sr ? Toutes les modifications vont tre enregistres")) {
			formulaire.submit();
		}
		else {
			formulaire.elements["mobile"].checked = !ismobile;
		}
	}
</script>
';
    
    include("system/header_system.php");
    GraphicAdmin(_SECTIONSADMIN);

    $result = $db->sql_query("select secid, secname from ".$prefix."_sections order by secname");
    if ($db->sql_numrows($result) > 0) {

	// if not arguments section is chosen
	if ($onglet=="") $onglet="sections";

	switch ($onglet) {
	/* -----------------------------------------------------------------*/
	/*              List of All section									*/
	/* -----------------------------------------------------------------*/
	  case "sections":

	    OpenOngletTable();
		displayOngletBar("$onglet",_ACTIVESECTIONS,$ongletDef);

		/* table head */
		echo "<center><table  class=lisTable>"
  			."<tr class=systemTabHeader>"
    		."<th class=systemTabHeader width=\"80%\">"._SECTIONNAME."</th>"
			//."<th class=systemTabHeader width=\"10%\">View</th>"
    		."<th class=systemTabHeader width=\"20%\">"._FUNCTION."</th>"
    		." </tr>";
		$pos=0;
		$result = $db->sql_query("select secid, secname from ".$prefix."_sections where secname not like '!%' order by secname");
		
		while(list($secid, $secname) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0) {
				$thestyle="listTableOdd";
			}
			else {
				$thestyle="listTableNone";
			}
			$sectionLink="<a href=\"system.php?op=sections&onglet=articles&idsec=$secid\" >";
			if (preg_match("#^!(.*)$#",$secname,$subname)) {
				$myicon = "";
				$secname = "<span style=\"width: 22px; height: 10px; float: left; display: block\"></span>".$subname[1];
			}
			else {
				$myicon = "<img src=\"$SkinPath/unpublish_16x16.png\" height=\"16\" border=\"0\" align=\"absmiddle\" />";
			}
			//	echo "<strong><big>&middot;</big></strong>&nbsp;&nbsp;<a href=\"system.php?op=sectionedit&amp;secid=$secid\">$secname</a>";
			echo "<tr class=\"$thestyle\">"
			."<td>$myicon $sectionLink $secname</a></td>";
			//."<td align=center><a href=\"modules.php?name=Sections&sop=listarticles&secid=$secid\"><img src=\"$SkinPath/icon_eye.gif\" border=0></a></td>";
			echo "<td align=center>";
			$barDef=array("view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif",
				"url"=>"modules.php?name=Sections&sop=listarticles&secid=$secid","comment"=>_PREVIEW, "status"=>"ON"),
				"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png",
				"url"=>"system.php?op=sectionedit&amp;secid=$secid","comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png",
				"url"=>"system.php?op=sectiondelete&amp;secid=$secid&amp;ok=0","comment"=>_DELETE,"status"=>"ON"));

			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";
			$pos++;
		}
		$db->sql_freeresult($result);
		/*$result = $db->sql_query("select secid, secname from ".$prefix."_sections where secname like '!%' order by secname");
		
		while(list($secid, $secname) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0) {
				$thestyle="listTableOdd";
			}
			else {
				$thestyle="listTableNone";
			}
			$sectionLink="<a href=\"system.php?op=sections&onglet=articles&idsec=$secid\" >";
			if (preg_match("#^!(.*)$#",$secname,$subname)) {
				$myicon = "<img src=\"$SkinPath/unpublish_off_16x16.png\" height=\"16\" border=\"0\" align=\"absmiddle\" />";
				$secname = $subname[1];
				//$secname = "<span style=\"width: 22px; height: 10px; float: left; display: block\"></span>".$subname[1];
			}
			else {
				$myicon = "<img src=\"$SkinPath/folder.gif\" height=16 border=0>";
			}
			//	echo "<strong><big>&middot;</big></strong>&nbsp;&nbsp;<a href=\"system.php?op=sectionedit&amp;secid=$secid\">$secname</a>";
			echo "<tr class=\"$thestyle\">"
			."<td>$myicon $sectionLink $secname</a></td>";
			//."<td align=center><a href=\"modules.php?name=Sections&sop=listarticles&secid=$secid\"><img src=\"$SkinPath/icon_eye.gif\" border=0></a></td>";
			echo "<td align=center>";
			$barDef=array("view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif",
				"url"=>"modules.php?name=Sections&sop=listarticles&secid=$secid","comment"=>_PREVIEW, "status"=>"ON"),
				"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png",
				"url"=>"system.php?op=sectionedit&amp;secid=$secid","comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png",
				"url"=>"system.php?op=sectiondelete&amp;secid=$secid&amp;ok=0","comment"=>_DELETE,"status"=>"ON"));

			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";
			$pos++;
		}
		$db->sql_freeresult($result);*/
		echo "<tr class=systemTabFooter><td colspan=9 class=systemTabFooter></td></tr>";
		echo "</table>";

		echo "<br>";

		/* --------------------------- Add a new section ---------------------*/
    	OpenOngletTable();
    	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] "._ADDSECTION."</a>";

		echo "<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n";
    	echo "<center><font class=\"option\"><b>"._ADDSECTION."</b></font></center><br>"
		."<form action=\"system.php\" method=\"post\">"
		."<table class=systemTab>"
		."<tr><td><b>"._SECTIONNAME.":</b></td>"
		."<td><input type=\"text\" name=\"secname\" size=\"40\" maxlength=\"40\">".displayHelp(_SECTIONNAME,true)."</td></tr>"
		."<tr><td><b>"._SECTIONIMG."</b></td>"
		."<td><input type=\"text\" name=\"image\" size=\"40\" maxlength=\"50\">".displayHelp(_SECIMGEXAMPLE,true)."</td></tr></table>"
		."<input type=\"hidden\" name=\"op\" value=\"sectionmake\">"
		."<INPUT type=\"submit\" value=\""._ADDSECTIONBUT."\">"
		."</form>"
		."</div>";
    	CloseOngletTable();
    	CloseOngletTable();
	break;
	
	
	case "cats":

	    OpenOngletTable();
		displayOngletBar("$onglet",_ACTIVESECTIONS,$ongletDef);

		/* table head */
		echo "<center><table  class=lisTable>"
  			."<tr class=systemTabHeader>"
    		."<th class=systemTabHeader width=\"80%\">"._SECTIONNAME."</th>"
			//."<th class=systemTabHeader width=\"10%\">View</th>"
    		."<th class=systemTabHeader width=\"20%\">"._FUNCTION."</th>"
    		." </tr>";
		$pos=0;
		$result = $db->sql_query("select secid, secname from ".$prefix."_sections where secname like '!%' order by secname");
		
		while(list($secid, $secname) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0) {
				$thestyle="listTableOdd";
			}
			else {
				$thestyle="listTableNone";
			}
			$sectionLink="<a href=\"system.php?op=sections&onglet=articles&id_section=$secid\" >";
			if (preg_match("#^!(.*)$#",$secname,$subname)) {
				$myicon = "<img src=\"$SkinPath/unpublish_off_16x16.png\" height=\"16\" border=\"0\" align=\"absmiddle\" />";
				$secname = $subname[1];
				//$secname = "<span style=\"width: 22px; height: 10px; float: left; display: block\"></span>".$subname[1];
			}
			else {
				$myicon = "<img src=\"$SkinPath/folder.gif\" height=16 border=0>";
			}
			//	echo "<strong><big>&middot;</big></strong>&nbsp;&nbsp;<a href=\"system.php?op=sectionedit&amp;secid=$secid\">$secname</a>";
			echo "<tr class=\"$thestyle\">"
			."<td>$myicon $sectionLink $secname</a></td>";
			//."<td align=center><a href=\"modules.php?name=Sections&sop=listarticles&secid=$secid\"><img src=\"$SkinPath/icon_eye.gif\" border=0></a></td>";
			echo "<td align=center>";
			$barDef=array("view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif",
				"url"=>"modules.php?name=Sections&sop=listarticles&secid=$secid","comment"=>_PREVIEW, "status"=>"ON"),
				"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png",
				"url"=>"system.php?op=sectionedit&amp;secid=$secid","comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png",
				"url"=>"system.php?op=sectiondelete&amp;secid=$secid&amp;ok=0","comment"=>_DELETE,"status"=>"ON"));

			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";
			$pos++;
		}
		$db->sql_freeresult($result);
		echo "<tr class=systemTabFooter><td colspan=9 class=systemTabFooter></td></tr>";
		echo "</table>";

		echo "<br>";

		/* --------------------------- Add a new section ---------------------*/
    	OpenOngletTable();
    	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	    echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] "._ADDSECTION."</a>";

		echo "<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n";
    	echo "<center><font class=\"option\"><b>"._ADDSECTION."</b></font></center><br>"
		."<form action=\"system.php\" method=\"post\">"
		."<table class=systemTab>"
		."<tr><td><b>"._SECTIONNAME.":</b></td>"
		."<td><input type=\"text\" name=\"secname\" size=\"40\" maxlength=\"40\">".displayHelp(_SECTIONNAME,true)."</td></tr>"
		."<tr><td><b>"._SECTIONIMG."</b></td>"
		."<td><input type=\"text\" name=\"image\" size=\"40\" maxlength=\"50\">".displayHelp(_SECIMGEXAMPLE,true)."</td></tr></table>"
		."<input type=\"hidden\" name=\"op\" value=\"sectionmake\">"
		."<INPUT type=\"submit\" value=\""._ADDSECTIONBUT."\">"
		."</form>"
		."</div>";
    	CloseOngletTable();
    	CloseOngletTable();
	break;

	/* -----------------------------------------------------------------*/
	/*              Add new Page/Article									*/
	/* -----------------------------------------------------------------*/
	case "NewActicleMobile":
	case "NewActicle":

		OpenOngletTable();
		displayOngletBar("$onglet",_ADDSECARTICLE,$ongletDef);

		/* Step One load editor hidden form */
		
		if (is_super($admin)) {
			$result4 = $db->sql_query("SELECT aid FROM ".$prefix."_authors ORDER BY aid ASC");
			$menuauteur = "";
			if ($db->sql_numrows($result4) != 0) {
				$menuauteur = '<select size="1" name="informant">';
				while (list($idadmin) = $db->sql_fetchrow($result4)) {
					$selected = ($aid == $idadmin) ? " selected=\"selected\"" : "";
					$menuauteur .= '<option value="'.$idadmin.'"'.$selected.'>'.$idadmin."</option>";
				}
				$menuauteur .= "</select>";
			}
	    }
	    else {
	    	$menuauteur = "<input type=\"text\" name=\"informant\" value=\"".$aid."\" size=\"25\" maxlength=\"20\" readonly=\"readonly\">";
	    }

		//attribution des catgories//
		$lescats = array();
		$result3 = $db->sql_query("SELECT id_section FROM ".$prefix."_seccont_section_link WHERE id_article='".$artid."'");
		if ($db->sql_numrows($result3) != 0) {
			while ($ligneencours3 = $db->sql_fetchrow($result3)) {
				$lescats[$ligneencours3["id_section"]] = "ok";
			}
		}
		//$result2 = $db->sql_query("select secid, secname from ".$prefix."_sections where secid='$secid'");
		$result2 = $db->sql_query("select secid, secname from ".$prefix."_sections where secname like '!%' order by secname");
		$ncats = $db->sql_numrows($result2);
		
		$ncols = 4;
		
		$catbox = array();
		if ($ncats > 0) {
			while (list($secid2, $secname) = $db->sql_fetchrow($result2)) {
				if (preg_match("#^!(.*)$#",$secname,$subname)) {
					$secname = $subname[1];
				}
				if ($lescats[$secid2] == "ok") {
					$checked = " checked=\"checked\"";
				}
				else {
					$checked = "";
				}
				$catbox[] .= '<input type="checkbox" name="cats[]" value="'.$secid2.'"'.$checked.' id="cats'.$secid2.'" />&nbsp;<label for="cats'.$secid2.'">'.$secname.'</label> ';
			}
		}
		$boitecat = colonnes($catbox,4,"800",true,"v");
		//fin d'attribution//

		echo "<script type=\"text/javascript\" src=\"javascripts/fckeditor/fckeditor.js\"></script>";
		echo "<script type=\"text/javascript\" src=\"javascripts/initfck.js\"></script>";

		/* Step One define form */
		echo "<form id=\"theForm\" action=\"system.php\" method=\"post\">"
		."<input type=\"hidden\" name=\"status\" value=\"NP\">"
		."<input type=\"hidden\" name=\"op\" value=\"secarticleadd\">";

		// title
		//addslashes doesn't work for double quote in javascript '
		$title = str_replace("'", "\'", $title);
    	$title = str_replace('"', "&quot;", $title);

		/*  define BECMS Bar  bar */
		// title
		$tbform=new toolbarform();
		$tbform->startForm();
		$tbform->startBar();
		$tbform->startItem();
		echo _TITLE." <input type=\"text\" name=\"title\" size=60 value=\"$title\">";
		$tbform->closeItem();
		// section list
		$tbform->addSeparator();
		$tbform->startItem();
		echo _SELSECTION." <select name=secid>";
		$optionValues="<option value=' '>Choisissez la rubrique</option>";
		//$result = $db->sql_query("select secid, secname from ".$prefix."_sections order by secid");
		$result = $db->sql_query("select secid, secname from ".$prefix."_sections where secname not like '!%' order by secid");
		while(list($secid2, $secname) = $db->sql_fetchrow($result)) {
		 if ($secid2 == $secid) {
		 $che = "selected";
	     }
	  	 $optionValues=$optionValues."<option value='$secid2' $che>$secname</option>";
	  	 $che="";
		}
		$db->sql_freeresult($result);
		echo $optionValues;
		echo "</select>";
		$tbform->closeItem();
		$tbform->addSeparator();
		$tbform->startItem();
		echo _SECTION_AUTHOR." ".$menuauteur;
		$tbform->closeItem();
		$tbform->closeBar();
		
	
		// Language list
		$tbform->startBar();

		$tbform->startItem();
		echo _LANGUAGE." <select name=slanguage>";
		$optionValues="<option value=' '>Choisissez la langue</option>";
		if ($multilingual == 1) {
	    $handle=opendir('language');
	    while ($file = readdir($handle)) {
			if (preg_match("/^lang\-(.+)\.php/", $file, $matches)) {
	    	    $langFound = $matches[1];
		    $languageslist .= "$langFound ";
			}
	    }
	    closedir($handle);
	    $languageslist = explode(" ", $languageslist);
	    sort($languageslist);
	    for ($i=0; $i < sizeof($languageslist); $i++) {
	    	if($languageslist[$i]!="") {
			$optionValues = $optionValues."<option value='$languageslist[$i]'";
				if($languageslist[$i]==$slanguage) $optionValues = $optionValues."selected";
			$optionValues = $optionValues.">".ucfirst($languageslist[$i])."</option>";
	    	}
		}
		} else {
	    echo " ";
		}
		echo $optionValues;
		echo "</select>";
		$tbform->closeItem();
		// separator
		$tbform->addSeparator();
		// publish checkbox
		$tbform->startItem();
		if ($status=="P") {$ischecked="checked";} else {$ischecked="";}
			echo _PUBLISHED ."<input type=\"checkbox\" name=status $ischecked value=\"P\">";
		$tbform->closeItem();
		// ------------- affichage pop-up -----------
		$tbform->addSeparator();
		$tbform->startItem();
		global $mobile;
		$checked = ($mobile == "1") ? ' checked=\"checked\"' : '';
		echo "Version mobile " ."<input type=\"checkbox\" name=\"mobile\" value=\"1\" onchange=\"vdeskmob(this.checked, this.form)\"$checked>";
		$tbform->closeItem();
		$tbform->addSeparator();
		$tbform->startItem();
		echo _PAGEPOPUP ."<input type=\"checkbox\" name=\"popup\" value=\"1\">";
		$tbform->closeItem();
		$tbform->addSeparator();
		// Set rights
		$tbform->startItem();
		echo _VIEWPRIV. " "
		."<select name=\"view\">";
		$myresult = $db->sql_query("select id, name from ".$prefix."_groups order by points");
		if ($view=="0") {$isSelected="selected";} else {$isSelected="";}
			echo "<option value=\"0\" $isSelected>"._MVALL."</option>";
		if ($view=="999") {$isSelected="selected";} else {$isSelected="";}
			echo "<option value=\"999\" $isSelected>"._MVUSERS."</option>";
		while(list($group_id, $group_name) = $db->sql_fetchrow($myresult)) {
		if ($view==$group_id) {$isSelected="selected";} else {$isSelected="";}		
			echo "<option value=\"$group_id\" $isSelected>$group_name</option>";
		}
		echo "</select> ";
	
		$tbform->closeItem();
		$tbform->closeBar();
		//catgories
		$tbform->startBar();
		$tbform->startItem();
		echo '<table border="0" cellpadding="0" cellspacing="0"><tr><td valign="top">'._CATSARTICLESCHOOSEEDIT.'</td><td valign="top">'.$boitecat.'</td></tr></table>';
		$tbform->closeItem();
		$tbform->closeBar();
		//fin catgories
		$tbform->closeForm();
		/* start editor with content value */
		echo "<textarea name=\"content\" >$content</textarea>";
		if ($onglet == "NewActicleMobile") {
			echo "<script type=\"text/javascript\">editOne('content',null,null,1);</script>";
		}
		else {
			echo "<script type=\"text/javascript\">editOne('content');</script>";
		}
		echo "</form>";

		echo "</form>";
		//echo "<font class=\"content\">"._PAGEBREAK."</font><br><br>";
		CloseOngletTable();
		echo "<br>";
	break;
	/* -----------------------------------------------------------------*/
	/*              List all last 20 article							*/
	/* -----------------------------------------------------------------*/
	case "articles":
		// get data
		$perpages=20;
        if (!isset($min)) $min=0;
        if ($idsec!="") {
		    $where=" WHERE secid='$idsec'";
		}
		$jointure= "";
		if ($id_section != "") {
			$jointure .= " inner join ".$prefix."_seccont_section_link ON ".$prefix."_seccont_section_link.id_article=".$prefix."_seccont.artid";
			$where=" WHERE ".$prefix."_seccont_section_link.id_section='".$id_section."'";
		}
		$result = $db->sql_query("select artid, secid, title, content, slanguage, date, informant, status , counter, view, keywords, description, mobile, twitter_card, twitter_site, twitter_creator, og_url, og_title, og_description, og_image, og_type from ".$prefix."_seccont ".$jointure.$where." order by artid desc limit $min,$perpages");
		$fullcountresult = $db->sql_query("select artid, secid, title, content, slanguage from ".$prefix."_seccont ".$jointure.$where." order by artid desc");
		$pagenumber = $db->sql_numrows($fullcountresult);
        // display result

		OpenOngletTable();
		displayOngletBar("$onglet",_LAST." $perpages "._PAGES." (/ $pagenumber )",$ongletDef);

		/* table head */
		echo "<table  class=lisTable>"
  			."<tr class=systemTabHeader>"
    		."<th class=systemTabHeader width=\"30%\">"._SECPAGETITLE."</th>"
    		."<th class=systemTabHeader width=\"5%\">"._LANGUAGE."</th>"
    		."<th class=systemTabHeader width=\"13%\">"._SECTION."</th>"
    		."<th class=systemTabHeader width=\"16%\">"._DATE."</th>"
    		."<th class=systemTabHeader width=\"8%\">"._AUTHOR."</th>"
    		."<th class=systemTabHeader width=\"5%\">"._MAPACCES."</th>"
    		."<th class=systemTabHeader width=\"5%\">"._META."</th>"
    		."<th class=systemTabHeader width=\"5%\">"._READNUMBER."</th>"
    		."<th class=systemTabHeader width=\"5%\">"._PUBLISHED."</th>"
    		."<th class=systemTabHeader width=\"8%\">"._ACTION."</th>"
    	//	."<th class=systemTabHeader width=\"8%\">Delete</th>"
    		." </tr>";
		$pos=0;
		while(list($artid, $secid, $title, $content, $slanguage, $date, $informant, $status, $counter, $view, $keywords, $description, $mobile, $page_twitter_card, $page_twitter_site, $page_twitter_creator, $page_og_url, $page_og_title, $page_og_description, $page_og_image, $page_og_type) = $db->sql_fetchrow($result)) {
	    	if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
	    	$result2 = $db->sql_query("select secid, secname from ".$prefix."_sections where secid='$secid'");
	    	list($secid, $secname) = $db->sql_fetchrow($result2);
	    	//echo "<li>$title - ($slanguage) - ($secname) [ <a href=\"system.php?op=secartedit&amp;artid=$artid\">"._EDIT."</a> | <a href=\"system.php?op=secartdelete&amp;artid=$artid&amp;ok=0\">"._DELETE."</a> ]";
			$myicon="<img src=\"$SkinPath/document.png\" height=16 border=0>";
			if (($keywords.$description.$page_twitter_card.$page_twitter_site.$page_twitter_creator.$page_og_url.$page_og_title.$page_og_description.$page_og_image.$page_og_type) == "") {
				$iconemetaedit = "<img src=\"$SkinPath/meta_16x16.png\" height=16 border=0>";
			}
			else {
				$iconemetaedit = "<img src=\"$SkinPath/checkin.png\" height=16 border=0>";
			}
			$meta="<a href=\"system.php?op=metaedit&artid=$artid\">$iconemetaedit</a>";
			echo "<tr class=\"$thestyle\">"
			."<td>$myicon $title</td>"
			."<td align=center>$slanguage</td>"
			."<td align=center>$secname</td>"
			."<td align=center>$date</td>"
			."<td align=center>$informant</td>"
			."<td align=center>".get_group_name($view)."</td>"
			."<td align=center>$meta</td>"
			."<td align=center>$counter</td>"
			."<td align=center>$status</td>";

			echo "<td align=center>";
			
			if ($withrewriting) {
				$pagename = normalize_name($title);
				if (strlen($pagename) > $maxtitlerewriting) {
					do {
						$pagename = substr($pagename, 0, strrpos($pagename, " "));
					} while(strlen($pagename) > $maxtitlerewriting);
				}
				if ($mobile == 1) {
					$urlView = $pagename."_mpage_$artid.htm";
				}
				else {
					$urlView = $pagename."_page_$artid.htm";
				}
			} else {
				if ($mobile == 1) {
					$urlView = "mobiles.php?name=Sections&sop=viewarticle&artid=$artid";
				}
				else {
					$urlView = "modules.php?name=Sections&sop=viewarticle&artid=$artid";
				}
			}
			
			$barDef=array("view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif",
                                     "url"=>$urlView,"comment"=>_PREVIEW, "status"=>"ON"),
						  "edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png",
                                     "url"=>"system.php?op=secartedit&amp;artid=$artid","comment"=>_EDIT, "status"=>"ON"),
						  "duplicate"=> array( "text"=>_SECTION_DUPLICATE,"icon"=>"icon_layers.png",
                                     "url"=>"system.php?op=secartduppl&amp;artid=$artid&amp;onglet=$onglet&amp;idsec=$idsec","comment"=>_SECTION_DUPLICATE, "status"=>"ON"),
  					      "delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png",
                                      "url"=>"system.php?op=secartdelete&amp;artid=$artid&amp;ok=0","comment"=>_DELETE,"status"=>"ON"));

	    	displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";


			//."<td align=center><a href=\"system.php?op=secartedit&amp;artid=$artid\">["._EDIT."</a>]</td><td align=center><a href=\"system.php?op=secartdelete&amp;artid=$artid&amp;ok=0\">["._DELETE."</a>]</td></tr>";
			$pos++;
			}
			$db->sql_freeresult($result);
			$db->sql_freeresult($result2);
			$db->sql_freeresult($fullcountresult);
		echo "<tr class=systemTabFooter><td colspan=9 class=systemTabFooter></td></tr>";
		echo "</table>";
		pageNumbering($min,$perpages,$pagenumber,$pos,$idsec);
		echo "</ul>"
	    	."<form action=\"system.php\" method=\"post\">"
	    	.""._EDITARTID.": <input type=\"text\" name=\"artid\" size=\"10\">&nbsp;&nbsp;"
	    	."<input type=\"hidden\" name=\"op\" value=\"secartedit\">"
	    	."<input type=\"submit\" value=\""._OK."\">"
	    	."</form>";

		CloseOngletTable();
    	//}
    	echo "<br>";
	break;
	case "multicat":
		$result2 = $db->sql_query("select secid, secname from ".$prefix."_sections where secname like '!%' order by secname");
		$menucats = "";
		if ($db->sql_numrows($result2) != 0) {
			$menucats = '<select size="1" name="idsec" onchange="this.form.submit()">';
			$menucats .= '<option value="">'._CATSARTICLESCHOOSE."</option>";
			while (list($secid, $secname) = $db->sql_fetchrow($result2)) {
				if (preg_match("#^!(.*)$#",$secname,$subname)) {
					$secname = $subname[1];
				}
				$selected = ($idsec == $secid) ? " selected=\"selected\"" : "";
				$menucats .= '<option value="'.$secid.'"'.$selected.'>'.$secname."</option>";
			}
			$menucats .= "</select>";
		}
		
		
		// get data
		$perpages=20;
		if (!isset($min)) $min=0;
		if ($idsec!="") {
			$where=" INNER JOIN ".$prefix."_seccont_section_link ON artid=id_article WHERE id_section='$idsec'";
		}
		$result = $db->sql_query("select artid, secid, title, slanguage, status from ".$prefix."_seccont ".$where." order by artid desc limit $min,$perpages");
		$fullcountresult = $db->sql_query("select artid, secid, title, content, slanguage from ".$prefix."_seccont ".$where." order by artid desc");
		$pagenumber = $db->sql_numrows($fullcountresult);
		// display result

		OpenOngletTable();
		displayOngletBar("$onglet",_LAST." $perpages "._PAGES." (/ $pagenumber )",$ongletDef);
		/* choix catgorie*/
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td style="padding: 10px 0 10px 0">';
		$liste .= '<form name="formfilter" action="system.php" method="POST">';
		/*$liste .= _BIBLIOWORDSTOSEARCH.'<input type="text" name="query" value="'.$query.'">';
		$liste .= ' <input name="validsearch" type="submit" value="'._BIBLIOSEARCHBTN.'">';
		$liste .= "&nbsp;&nbsp;&nbsp;&nbsp;";*/
		$liste .= '<input type="hidden" name="onglet" value="'.$onglet.'">';
		$liste .= '<input type="hidden" name="op" value="'.$op.'">';
		$liste .= $menucats;
		$liste .= "</form>";
		$liste .= '</td></tr></table>';
		echo $liste;

		/* table head */
		echo "<table  class=lisTable>"
  			."<tr class=systemTabHeader>"
	    		."<th class=systemTabHeader>"._SECPAGETITLE."</th>"
	    		."<th class=systemTabHeader>"._LANGUAGE."</th>"
	    		."<th class=systemTabHeader>"._MULTICATS."</th>"
	    		."<th class=systemTabHeader>"._PUBLISHED."</th>"
	    		."<th class=systemTabHeader>"._ACTION."</th>"
	    		." </tr>";
		$pos=0;
		while(list($artid, $secid, $title, $slanguage, $status) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0){
				$thestyle="listTableOdd";
			}
			else {
				$thestyle="listTableNone";
			}
			
			$lescats = array();
			$result3 = $db->sql_query("SELECT id_section FROM ".$prefix."_seccont_section_link WHERE id_article='".$artid."'");
			if ($db->sql_numrows($result3) != 0) {
				while ($ligneencours3 = $db->sql_fetchrow($result3)) {
					$lescats[$ligneencours3["id_section"]] = "ok";
				}
			}
			//$result2 = $db->sql_query("select secid, secname from ".$prefix."_sections where secid='$secid'");
			$result2 = $db->sql_query("select secid, secname from ".$prefix."_sections where secname like '!%' order by secname");
			$catbox = array();
			$catlist = "";
			while (list($secid, $secname) = $db->sql_fetchrow($result2)) {
				if (preg_match("#^!(.*)$#",$secname,$subname)) {
					$secname = $subname[1];
				}
				if ($lescats[$secid] == "ok") {
					$checked = " checked=\"checked\"";
					$catlist .= ($catlist != "") ? ", " : "" ;
					$catlist .= $secname;
				}
				else {
					$checked = "";
				}
				$catbox[] .= '<input type="checkbox" name="cats[]" value="'.$secid.'"'.$checked.' id="cats'.$secid."_".$artid.'" onchange="categorize('.$artid.','.$secid.', this.checked)">&nbsp;<label for="cats'.$secid."_".$artid.'">'.$secname.'</label> ';
			}
			$catbox = colonnes($catbox,4,"800",true,"v");
			$myiconact2="<img src=\"$SkinPath/edit_no_16x16.png\" border=\"0\">";
			$myiconact="<img src=\"$SkinPath/edit_16x16.png\" border=\"0\">";
			$catlist = '<div id="bbox_'.$artid.'"><a href="#" onclick="showCats(\'box_'.$artid.'\'); return false">'.$myiconact.'</a><span id="bbbox_'.$artid.'">'.$catlist.'</span></div>';
			$catbox = $catlist.'<div id="box_'.$artid.'" style="display: none"><form><a href="#" onclick="hideCats(\'box_'.$artid.'\'); return false">'.$myiconact2.'</a>'.$catbox.'</form></div>';
			//echo "<li>$title - ($slanguage) - ($secname) [ <a href=\"system.php?op=secartedit&amp;artid=$artid\">"._EDIT."</a> | <a href=\"system.php?op=secartdelete&amp;artid=$artid&amp;ok=0\">"._DELETE."</a> ]";
			$myicon="<img src=\"$SkinPath/document.png\" height=16 border=0>";
			if (($keywords.$description) == "") {
				$iconemetaedit = "<img src=\"$SkinPath/meta_16x16.png\" height=16 border=0>";
			}
			else {
				$iconemetaedit = "<img src=\"$SkinPath/checkin.png\" height=16 border=0>";
			}
			$meta="<a href=\"system.php?op=metaedit&artid=$artid\">$iconemetaedit</a>";
			echo "<tr class=\"$thestyle\">"
			."<td>$myicon $title</td>"
			."<td align=center>$slanguage</td>"
			."<td>$catbox</td>"
			."<td align=center>$status</td>";

			echo "<td align=center>";
			$barDef=array("view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif",
			"url"=>"modules.php?name=Sections&sop=viewarticle&artid=$artid","comment"=>_PREVIEW, "status"=>"ON"),
			"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png",
			"url"=>"system.php?op=secartedit&amp;artid=$artid","comment"=>_EDIT, "status"=>"ON"),
			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png",
			"url"=>"system.php?op=secartdelete&amp;artid=$artid&amp;ok=0","comment"=>_DELETE,"status"=>"ON"));

			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";


			//."<td align=center><a href=\"system.php?op=secartedit&amp;artid=$artid\">["._EDIT."</a>]</td><td align=center><a href=\"system.php?op=secartdelete&amp;artid=$artid&amp;ok=0\">["._DELETE."</a>]</td></tr>";
			$pos++;
		}
		$db->sql_freeresult($result);
		$db->sql_freeresult($result2);
		$db->sql_freeresult($fullcountresult);
		echo "<tr class=systemTabFooter><td colspan=9 class=systemTabFooter></td></tr>";
		echo "</table>";
		pageNumbering($min,$perpages,$pagenumber,$pos,$idsec,$onglet);
		echo "</ul>"
	    	."<form action=\"system.php\" method=\"post\">"
	    	.""._EDITARTID.": <input type=\"text\" name=\"artid\" size=\"10\">&nbsp;&nbsp;"
	    	."<input type=\"hidden\" name=\"op\" value=\"secartedit\">"
	    	."<input type=\"submit\" value=\""._OK."\">"
	    	."</form>";

		CloseOngletTable();
		//}
		echo "<br>";
		break;
    } // end swith for onglet
   } else {// end sql rows
         /* nothing in DB display add section form */
         /* --------------------------- Add a new section ---------------------*/
    	OpenOngletTable();
    	echo "<center><font class=\"option\"><b>"._ADDSECTION."</b></font></center><br>"
		."<form action=\"system.php\" method=\"post\"><br>"
		."<b>"._SECTIONNAME.":</b><br>"
		."<input type=\"text\" name=\"secname\" size=\"40\" maxlength=\"40\"><br><br>"
		."<b>"._SECTIONIMG."</b><br><font class=\"tiny\">"._SECIMGEXAMPLE."</font><br>"
		."<input type=\"text\" name=\"image\" size=\"40\" maxlength=\"50\"><br><br>"
		."<input type=\"hidden\" name=\"op\" value=\"sectionmake\">"
		."<INPUT type=\"submit\" value=\""._ADDSECTIONBUT."\">"
		."</form>";
    	CloseOngletTable();
		}
    include("system/footer_system.php");
}


/*--------------------------------------------------*/
/*          secarticleadd()							*/
/* @abstract: Add articke in DB					*/
/* @param: secid	: section id						*/
/* @param: title	: Title of the article id			*/
/* @param: content : Article content					*/
/* @param: slanguage	: Language use for the article	*/
/* @see											*/
/*--------------------------------------------------*/
function secarticleadd($secid, $title, $content, $slanguage, $status, $view, $cats, $popup, $mobile, $informant) {
    global $prefix, $db, $aid;
    $title = stripslashes(FixQuotes($title));
    $content = stripslashes(FixQuotes($content));
    $status = stripslashes(FixQuotes($status));
    $view = stripslashes(FixQuotes($view));
    $informant = stripslashes(FixQuotes($informant));
	// clean URL . If full url has been added to local link by wysiwyg editor, clean it.
	$myservernotport="http://".$_SERVER['SERVER_NAME'];
	$content = str_replace($myservernotport,"",$content);
	$myservernotport="https://".$_SERVER['SERVER_NAME']; // case https .. in futur test with regex for one line
	$content = str_replace($myservernotport,"",$content);
	$popup = ($popup == "1") ? "1" : "0";
	$mobile = ($mobile == "1") ? "1" : "0";
	
	global $twitter_card, $twitter_site, $twitter_creator, $og_type, $nukeurl;
	
	$racine = str_replace("http://","https://", format_nuke_url($nukeurl));
	
	$metasenplus = "";
	
	$page_twitter_card = $twitter_card;
	$metasenplus .= ", '$twitter_card'";

	$page_twitter_site = $twitter_site;
	$metasenplus .= ", '$page_twitter_site'";

	$page_twitter_creator = $twitter_creator;
	$metasenplus .= ", '$page_twitter_creator'";
	
	$pagename = normalize_name($title);
	$page_og_url = $racine."/".$pagename."_mpage_".$artid.".htm";
	$metasenplus .= ", '$page_og_url'";

	$page_og_title = $title;
	$metasenplus .= ", '$page_og_title'";

	$page_og_description = truncate_string(strip_tags($content), 200);
	$metasenplus .= ", '$page_og_description'";
	
	$vignette = get_vignette($content, $racine);
	$page_og_image = $vignette;
	$metasenplus .= ", '$page_og_image'";

	$page_og_type = $og_type;
	$metasenplus .= ", '$page_og_type'";
	
    $result=$db->sql_query("INSERT INTO ".$prefix."_seccont VALUES (NULL,'$secid','$title','$content','0','$slanguage',now(),'$informant','$status', NULL, NULL, '$view', '9999', '$popup', '$mobile'$metasenplus)");
	if (!$result) {
		$error = $db->sql_error();
		die('Invalid query:'.$error["message"]);
     }
    // Solve automatic url fill with wysiwyg editor on Internet Explorer when src="#toto".
    // IE add automaticaly current page url before #. That cause issue because current page is a system url.
    /*$_id=$db->sql_nextid();
    $systemUrlPage="system.php?op=sections&amp;onglet=NewActicle" ;
    $userUrlPage="modules.php?name=Sections&sop=viewarticle&artid=$_id";
    $content = str_replace($systemUrlPage,$userUrlPage,$content);
    $result=$db->sql_query("update ".$prefix."_seccont set content='$content' where artid=$_id");
    if (!$result) {
    	$error = $db->sql_error();
		die('Invalid query:'.$error["message"]);
     }*/
	$idart = $db->sql_nextid();
	
	$pagename = normalize_name($title);
	$page_og_url = $racine."/".$pagename."_mpage_".$idart.".htm";
	$result=$db->sql_query("update ".$prefix."_seccont set og_url='$page_og_url' where artid=$idart");
	if (!$result) {
		$error = $db->sql_error();
		die('Invalid query:'.$error["message"]);
	}
     
     if(isset($cats) && is_array($cats)) {
	     foreach ($cats as $cat) {
	     	$result=$db->sql_query("INSERT INTO ".$prefix."_seccont_section_link VALUES (NULL,'$idart','$cat');");
	     }
     } 
     else {
     	$result=$db->sql_query("DELETE FROM ".$prefix."_seccont_section_link WHERE id_article='$idart';");
     }
     
     write_to_log("","","","",_LOG_SECTION_PAGECREATE.$title);

    Header("Location: system.php?op=sections&onglet=articles&idsec=$secid");
}

/**
* secartsaveversion()
* @abstract: save a version of an article in DB
* @param: secid	: section id
* @param: title	: Title of the article id
* @param: content : Article content
* @param: slanguage	: Language use for the article
* @see
*/
function secartsaveversion($artid) {
    global $prefix, $db, $pageversionning;
    $pageversionning=1;
    if ($pageversionning) {    
		$result=$db->sql_query("select secid, title,content,counter,slanguage,date,informant,status,keywords,description,view,weight from ".$prefix."_seccont where artid='$artid'");
		list($secid, $title,$content,$counter,$slanguage,$date,$informant,$status,$keywords,$description,$view,$weight)=$db->sql_fetchrow($result);
		$db->sql_freeresult($result);
		$title = stripslashes(FixQuotes($title));
    	$content = stripslashes(FixQuotes($content));
    	$keywords = stripslashes(FixQuotes($keywords));
    	$description = stripslashes(FixQuotes($description));
		$next_version=getnextversion($artid);		
		$history_id=$artid."_".$next_version['version'];
		$new_version=$next_version['version'];
		//echo "V : ".$next_version['version']."<br>";
		//echo "::".$next_version['isnew'];
	    if ($next_version['isnew']){
	    //echo "new";
	    //echo "<pre> INSERT INTO ".$prefix."_seccont_history VALUES ('$history_id','$artid','$secid','$title','$content','$counter','$slanguage','$date','$informant','$status', '$keywords', '$description', '$view', '$weight','$new_version')</pre>";
    	$result=$db->sql_query("INSERT INTO ".$prefix."_seccont_history VALUES ('$history_id','$artid','$secid','$title','$content','$counter','$slanguage','$date','$informant','$status', '$keywords', '$description', '$view', '$weight','$new_version')");
	    } else {
	    //echo "update";
	    $result=$db->sql_query("UPDATE ".$prefix."_seccont_history SET historyid='$history_id', artid='$artid',secid='$secid',title='$title',content='$content',counter='$counter',slanguage='$slanguage',date='$date',informant='$informant',status='$status',keywords='$keywords',description='$description',view='$view',weight='$weight',version='$new_version' where historyid='$history_id'");
	    }
		if (!$result) {
			$error=$db->sql_error();
    		die('Invalid query: secartsaveversion() :'.$error['message']);
     	}
     return true;	
    }
    return false;
}
/**
 * getnextversion()
 * @abstract provide next version for provided page Version bigger number is the last one (default 5)
 * @param int article id
 */
function getnextversion($artid){
	global $prefix, $db;
	$maxVersion['version']=0;
	$maxVersion['isnew']=0;
	$result=$db->sql_query("select version, date from ".$prefix."_seccont_history where artid='$artid'");
	while (list($version, $date)=$db->sql_fetchrow($result)){
		$versionArray[$date]=$version;
		$dateArray[]=$date;
	}
	if (isset($dateArray)) {
		$maxVersion['version']=max($versionArray)+1;
		$lastDate=max($dateArray);
		$maxVersion['version']=$versionArray[$lastDate]+1;
		if (sizeof($dateArray)<=$maxVersion['version']) $maxVersion['isnew']=1; // new only if no backup exist with the same id
	}else{
		$maxVersion['version']=0;
		$maxVersion['isnew']=1;
	}
		
	if ($maxVersion['version']>=5) {
		$maxVersion['version']=0; // only 5 versions will be stored.
		$maxVersion['isnew']=0;
	}
	return $maxVersion;
}

/**
 * restorePage() 
 * Restore an history Page
 * @param sting historyid History Page ID
 * @return status true or false
 */
 function restorePage($historyid, $ok=0){
 	global $prefix, $db;
 	 if ($ok==1) {
 	 	
 	 	$result=$db->sql_query("select artid, secid, title,content,counter,slanguage,date,informant,status,keywords,description,view,weight from ".$prefix."_seccont_history where historyid='$historyid'");
		list($artid, $secid, $title,$content,$counter,$slanguage,$date,$informant,$status,$keywords,$description,$view,$weight)=$db->sql_fetchrow($result);
		$db->sql_freeresult($result);
		$title = stripslashes(FixQuotes($title));
    	$content = stripslashes(FixQuotes($content));
 	 	
 	 	$result=$db->sql_query("UPDATE ".$prefix."_seccont SET secid='$secid',title='$title',content='$content',counter='$counter',slanguage='$slanguage',date='$date',informant='$informant',status='$status',keywords='$keywords',description='$description',view='$view',weight='$weight' where artid='$artid'");	    
		if (!$result) {
			$error=$db->sql_error();
    		die('Invalid query: restorePage() :'.$error['message']);
     	}
     	write_to_log("","","","",_LOG_SECTION_PAGECHANGE.$title);
        Header("Location: system.php?op=secartedit&artid=$artid");
    } else {
        include("system/header_system.php");
        GraphicAdmin(_SECTIONSADMIN);
		echo "<br>";
		$result = $db->sql_query("select title, date from ".$prefix."_seccont_history where historyid='$historyid'");
		list($title, $mydate) = $db->sql_fetchrow($result);
		OpenSysTable();
			echo "<center><b>"._RESTOREARTICLE.": $title "._PUBLISHEDON." $mydate</b><br><br>"
	    	.""._RESTOREARTWARNING."<br><br>"
	    	."[ <a href=\"system.php?op=sections\">"._NO."</a> | <a href=\"system.php?op=restorePage&amp;historyid=$historyid&amp;ok=1\">"._YES."</a> ]</center>";
		CloseSysTable();
        include("system/footer_system.php");
    }
 	
 }
/**
 * ecartedit($artid)
 * @abstract edit an existing article
 * @param artid : Aticle id
 * @see
 */
	function liste($valeur, $classe="nopuce") {
		$sortie = "";
		if (count($valeur) > 0) {
			$sortie .= "<ul";
			if ($classe != "" ) {
				$sortie .= ' class="'.$classe.'"';
			}
			$sortie .= ">";
			foreach ($valeur as $elt) {
				$sortie .= "<li>".$elt."</li>";
			}
			$sortie .= "</ul>";
		}
		return $sortie;
	}
	function colonnes($valeurs = array(), $nbcols = 1,$largeur = "", $equicols = false, $senslecture = "v", $classe = "") {
		$nbrevals = count($valeurs);
		if ($nbrevals > 0) {
			$largeurscols = array();
			if ($equicols) { //calcul des largeurs de colonnes si elles doivent tre gales
				$largeurcol = floor(100/$nbcols);
				$total = 0;
				for ($i=0;$i<$nbcols-1;$i++) {
					$largeurscols[] = ' width="'.$largeurcol.'%"';
					$total += $largeurcol;
				}
				$largeurscols[] = $largeurscols[] = ' width="'.(100 - $total).'%"';
			}
			$lignesMax = ceil(count($valeurs)/$nbcols); //nbre de lignes maximal
			$classe = ($classe != "") ? ' class="'.$classe.'"' : "";
			
			$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"".$classe;
			if ($largeur != "") {
				$sortie .= " width=\"".$largeur."\"";
			}
			$sortie .= ">";
			$contenus = array();
			if ($senslecture == "v") {
				for ($c=0;$c<$nbcols;$c++) {
					$contenus[$c] = '<td'.$largeurscols[$c].'>';
					$contenus[$c] .= liste(array_slice($valeurs,$lignesMax*$c,$lignesMax));
					$contenus[$c] .= '</td>';
				}
			}
			if ($senslecture == "h") {
				for ($c=0;$c<$nbcols;$c++) {
					$cvaleurs = array();
					for ($i=0;$i<$lignesMax;$i++) {
						$indice = $i*$nbcols+$c;
						if (isset($valeurs[$indice])) {
							$cvaleurs[] = $valeurs[$indice];
						}
					}
					$contenus[$c] = '<td'.$largeurscols[$c].'>';
					$contenus[$c] .= $this->liste($cvaleurs);
					$contenus[$c] .= '</td>';
				}
			}
			$sortie .= '<tr>';
			foreach($contenus as $contenu) {
				$sortie .= $contenu;
			}
			$sortie .= '</tr>';
			$sortie .= "</table>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}
function secartedit($artid) {
    global $prefix, $db, $multilingual, $ongletDef, $aid, $admin,$admincontrolsection, $header_system;
    
    $result = $db->sql_query("select artid, secid, title, content, slanguage, status, view, informant, popup, mobile from ".$prefix."_seccont where artid='$artid'");
    list($artid, $secid, $title, $content, $slanguage, $status, $view, $informant,$popup, $mobile) = $db->sql_fetchrow($result);
    
    //vrif droits utilisateur sur article
    if ($admincontrolsection) {
	    if ($aid != $informant && !is_super($admin)) {
	    		display_denied();
	    		return;
	    }
    }
    //fin vrif
    
	if (is_super($admin)) {
		$result4 = $db->sql_query("SELECT aid FROM ".$prefix."_authors ORDER BY aid ASC");
		$menuauteur = "";
		if ($db->sql_numrows($result4) != 0) {
			$menuauteur = '<select size="1" name="informant">';
			while (list($idadmin) = $db->sql_fetchrow($result4)) {
				$selected = ($informant == $idadmin) ? " selected=\"selected\"" : "";
				$menuauteur .= '<option value="'.$idadmin.'"'.$selected.'>'.$idadmin."</option>";
			}
			$menuauteur .= "</select>";
		}
    }
    else {
    	$menuauteur = "<input type=\"text\" name=\"informant\" value=\"".$informant."\" size=\"25\" maxlength=\"20\" readonly=\"readonly\">";
    }

	//attribution des catgories//
	$lescats = array();
	$result3 = $db->sql_query("SELECT id_section FROM ".$prefix."_seccont_section_link WHERE id_article='".$artid."'");
	if ($db->sql_numrows($result3) != 0) {
		while ($ligneencours3 = $db->sql_fetchrow($result3)) {
			$lescats[$ligneencours3["id_section"]] = "ok";
		}
	}
	//$result2 = $db->sql_query("select secid, secname from ".$prefix."_sections where secid='$secid'");
	$result2 = $db->sql_query("select secid, secname from ".$prefix."_sections where secname like '!%' order by secname");
	$ncats = $db->sql_numrows($result2);
	
	$ncols = 4;
	
	$catbox = array();
	if ($ncats > 0) {
		while (list($secid2, $secname) = $db->sql_fetchrow($result2)) {
			if (preg_match("#^!(.*)$#",$secname,$subname)) {
				$secname = $subname[1];
			}
			if ($lescats[$secid2] == "ok") {
				$checked = " checked=\"checked\"";
			}
			else {
				$checked = "";
			}
			$catbox[] .= '<input type="checkbox" name="cats[]" value="'.$secid2.'"'.$checked.' id="cats'.$secid2.'" />&nbsp;<label for="cats'.$secid2.'">'.$secname.'</label> ';
		}
	}
	$boitecat = colonnes($catbox,4,"800",true,"v");
	//fin d'attribution//
    $header_system .= '
<script type="text/javascript">
	function vdeskmob(ismobile, formulaire) {
		if (confirm("En tes vous sr ? Toutes les modifications vont tre enregistres")) {
			formulaire.submit();
		}
		else {
			formulaire.elements["mobile"].checked = !ismobile;
		}
	}
</script>
';
	
    include("system/header_system.php");
    echo "<script type=\"text/javascript\" src=\"javascripts/fckeditor/fckeditor.js\"></script>";
	echo "<script type=\"text/javascript\" src=\"javascripts/initfck.js\"></script>";

    GraphicAdmin(_SECTIONSADMIN);
    
	// add onglet tab
	OpenOngletTable();

	displayOngletBar("articles",_EDITARTICLE,$ongletDef);
	/* Step One load editor hidden form */


	/* Step One define form */
	echo "<form id=\"theForm\" action=\"system.php\" method=\"post\">"
		."<input type=\"hidden\" name=\"artid\" value=\"$artid\">"
		."<input type=\"hidden\" name=\"op\" value=\"secartchange\">";


	// title
	//addslashes doesn't work for double quote in javascript '
	//$title = str_replace("'", "\'", $title);
    $title = str_replace('"', "&quot;", $title);

	/*  define BECMS Bar  bar */
	// title
	$tbform=new toolbarform();
	$tbform->startForm();
	$tbform->startBar();
	$tbform->startItem();
	echo _TITLE." <input type=\"text\" name=\"title\" size=60 value=\"$title\">";
	$tbform->closeItem();
	// section list
	$tbform->addSeparator();
	$tbform->startItem();
	echo _SELSECTION." <select name=secid>";
	$optionValues="<option value=' '>Choisissez la rubrique</option>";
	$result = $db->sql_query("select secid, secname from ".$prefix."_sections where secname not like '!%' order by secname ASC");
	while(list($secid2, $secname) = $db->sql_fetchrow($result)) {
	if ($secid2 == $secid) {
		$che = "selected";
	    }
	  $optionValues=$optionValues."<option value='$secid2' $che>$secname</option>";
	  $che="";
	}
	$db->sql_freeresult($result);
	echo $optionValues;
	echo "</select>";
	$tbform->closeItem();
	$tbform->addSeparator();
	$tbform->startItem();
	echo _SECTION_AUTHOR." ".$menuauteur;
	$tbform->closeItem();
	$tbform->closeBar();
	// Language list
	$tbform->startBar();

	$tbform->startItem();
	echo _LANGUAGE." <select name=slanguage>";
	$optionValues="<option value=' '>Choisissez la langue</option>";
	if ($multilingual == 1) {
	    $handle=opendir('language');
	    while ($file = readdir($handle)) {
		if (preg_match("/^lang\-(.+)\.php/", $file, $matches)) {
	    	    $langFound = $matches[1];
		    $languageslist .= "$langFound ";
		}
	    }
	    closedir($handle);
	    $languageslist = explode(" ", $languageslist);
	    sort($languageslist);
	    for ($i=0; $i < sizeof($languageslist); $i++) {
	    	if($languageslist[$i]!="") {
			$optionValues = $optionValues."<option value='$languageslist[$i]'";
				if($languageslist[$i]==$slanguage) $optionValues = $optionValues."selected";
			$optionValues = $optionValues.">".ucfirst($languageslist[$i])."</option>";
	    }
	}
	} else {
	    echo " ";
	}
	echo $optionValues;
	echo "</select>";
	$tbform->closeItem();
	// separator
	$tbform->addSeparator();
	// ------------- publish checkbox -------
	$tbform->startItem();
	if ($status=="P") {$ischecked="checked";} else {$ischecked="";}
	echo _PUBLISHED ."<input type=\"checkbox\" name=status $ischecked value=\"P\">";
	$tbform->closeItem();
	$tbform->addSeparator();
	$tbform->startItem();
	//--------------- version mobile --------
	$checked = ($mobile == "1") ? ' checked=\"checked\"' : '';
	echo "Version mobile " ."<input type=\"checkbox\" name=\"mobile\" value=\"1\" onchange=\"vdeskmob(this.checked, this.form)\"$checked>";
	$tbform->closeItem();
	$tbform->addSeparator();
	// ------------- affichage pop-up -----------
	$tbform->startItem();
	if ($popup=="1") {$ischecked="checked";} else {$ischecked="";}
	echo _PAGEPOPUP ."<input type=\"checkbox\" $ischecked name=\"popup\" value=\"1\">";
	$tbform->closeItem();
	$tbform->addSeparator();
	// -----------  Set rights --------------
	$tbform->startItem();
	echo _VIEWPRIV. " "
		."<select name=\"view\">";
		$myresult = $db->sql_query("select id, name from ".$prefix."_groups order by points");
		if ($view=="0") {$isSelected="selected";} else {$isSelected="";}
			echo "<option value=\"0\" $isSelected>"._MVALL."</option>";
		if ($view=="999") {$isSelected="selected";} else {$isSelected="";}
			echo "<option value=\"999\" $isSelected>"._MVUSERS."</option>";
		while(list($group_id, $group_name) = $db->sql_fetchrow($myresult)) {
		if ($view==$group_id) {$isSelected="selected";} else {$isSelected="";}		
			echo "<option value=\"$group_id\" $isSelected>$group_name</option>";
		}
		echo "</select> ";
	
	$tbform->closeItem();
	// ------------ History -------------
	$tbform->addSeparator();
	$tbform->startItem();
	echo _VIEWHISTORY. " "
		."<select name=\"history\" id=\"history\" >";
		$myresult = $db->sql_query("select historyid, date, version from ".$prefix."_seccont_history where artid='$artid' order by date");
		//$userversion=5;
		$userversion=$db->sql_numrows();
		while(list($historyid, $mydate, $version) = $db->sql_fetchrow($myresult)) {
			echo "<option value=\"$historyid\" $isSelected>version : -$userversion :: $mydate</option>";
			$userversion --;
		}
		echo "</select> ";
	if (!$result) {
			$error=$db->sql_error();
    		die('Invalid query: secartedit() :'.$error['message']);
     	}
    $restoreButtonLink="box=document.getElementById('history');"
    ."historyId=box.options[box.selectedIndex].value;"
    ."if (historyId) document.location='system.php?op=restorePage&historyid='+box.options[box.selectedIndex].value;";	
	$tbform->closeItem();
	$tbform->startItem();
     echo "<img src=\"images/rte/icon_category_add.gif\" title=\""._RESTORE."\" alt=\""._RESTORE."\" border=0 onClick=\"$restoreButtonLink\">";
     $tbform->closeItem();
	
	$tbform->closeBar();
	//catgories
	if (count($catbox) > 0) {
		$tbform->startBar();
		$tbform->startItem();
		echo '<table border="0" cellpadding="0" cellspacing="0"><tr><td valign="top">'._CATSARTICLESCHOOSEEDIT.'</td><td valign="top">'.$boitecat.'</td></tr></table>';
		$tbform->closeItem();
		$tbform->closeBar();
	}
	//fin catgories
	
	$tbform->closeForm();
	/* start editor with content value */
	$content = str_replace("<textarea>","&lt;textarea&gt;",$content);
	$content = str_replace("</textarea>","&lt;/textarea&gt;",$content);
	echo "<textarea name=\"content\" ROWS=40>$content</textarea>";
	if ($mobile == "1") {
			echo "<script type=\"text/javascript\">editOne('content',null,null,1);</script>";
		}
		else {
			echo "<script type=\"text/javascript\">editOne('content');</script>";
		}
	echo "</form>";
	//echo "<font class=\"content\">"._PAGEBREAK."</font><br>";
	echo "[ <a href=\"system.php?op=secartdelete&amp;artid=$artid&amp;ok=0\">"._DELETE."</a> ]";

    CloseOngletTable();

	include("system/footer_system.php");
}
/*--------------------------------------*/
/*        sectionmake()					*/
/* @abstract: Add a new section in DB	*/
/* @param: secname: section name		*/
/* @param: image : section icon			*/
/* @see								    */
/*--------------------------------------*/
function sectionmake($secname, $image) {
    global $prefix, $db;
    $secname = stripslashes(FixQuotes($secname));
    $image = stripslashes(FixQuotes($image));
    $db->sql_query("INSERT INTO ".$prefix."_sections VALUES (NULL,'$secname', '$image')");
    write_to_log("","","","",_LOG_SECTION_SECTIONCREATE.$secname);
    if (preg_match("#^!(.*)#", $secname)) {
    		Header("Location: system.php?op=sections&onglet=cats");	
    }
    else {
		Header("Location: system.php?op=sections");
    }
}
/*--------------------------------------*/
/*				sectionedit()			*/
/* @abstract:							*/
/* @param								*/
/* @see								*/
/*--------------------------------------*/
function sectionedit($secid) {
    global $prefix, $db, $ongletDef,$admincontrolsection,$admin;
    
    //vrif droits utilisateur sur section
    /*if ($admincontrolsection) {
	    if (!is_super($admin)) {
	    		display_denied();
	    		return;
	    }
    }*/
    //fin vrif
    
    include("system/header_system.php");
    GraphicAdmin(_SECTIONSADMIN);

    $result = $db->sql_query("select secid, secname, image from ".$prefix."_sections where secid=$secid");
    list($secid, $secname, $image) = $db->sql_fetchrow($result);
    $result2 = $db->sql_query("select artid from ".$prefix."_seccont where secid=$secid");
    $number = $db->sql_numrows($result2);
    $db->sql_freeresult($result);
    $db->sql_freeresult($result2);
    OpenOngletTable();
    displayOngletBar("sections",_EDITSECTION.": $secname <br>("._SECTIONHAS." $number "._ARTICLESATTACH.")",$ongletDef);
    if ($image=="") $image="folder-left.gif";
    echo "<br>";
    OpenOngletTable();
	echo "<form action=\"system.php\" method=\"post\" name=\"leformulaire\">"
	."<tr><td width=50%></td>"
	."<td><img name=\"myicon\" src=\"images/topics/$image\" border=\"0\" alt=\"\"></td><tr>"
	."<tr bgcolor=\"#CCCCCC\"><td align=right>"._SECTIONNAME."</b><br><font class=\"tiny\">"._40CHARSMAX."</font></td>"
	."<td><input type=\"text\" name=\"secname\" size=\"40\" maxlength=\"40\" value=\"$secname\"></td></tr>"
	."<tr bgcolor=\"#CCCCCC\"><td align=right>"._SECTIONIMG."</b><br><font class=\"tiny\">"._SECIMGEXAMPLE."</font></td>"
	."<td>"
	."<SCRIPT language=\"JavaScript\" src=\"javascripts/images.js\"></SCRIPT>\n";
	/*echo "<select name=\"image\" onChange=\"displayImg('myicon','images/sections/icones/'+this.options[selectedIndex].value)\">";
    $path1 = explode ("/", "images/sections/icones");
    $path = "$path1[0]/$path1[1]/$path1[2]";
    $handle=opendir($path);
    while ($file = readdir($handle)) {
	if ( (preg_match("#^([0-9a-z]+)([.]{1})([a-z0-9]{3})$#",$file)) ) {
	    $tlist .= "$file ";
	}
    }
    closedir($handle);
    $tlist = explode(" ", $tlist);
    sort($tlist);
    for ($i=0; $i < sizeof($tlist); $i++) {
	if($tlist[$i]!="") {
	    if ($image == $tlist[$i]) {
		$sel = "selected";
	    } else {
		$sel = "";
	    }
	    echo "<option name=\"topicimage\" value=\"$tlist[$i]\" $sel>$tlist[$i]\n";
	}
    }*/
	echo "<select name=\"image\" onChange=\"displayImg('myicon','images/topics/'+this.options[selectedIndex].value)\">";
	$path1 = explode ("/", "images/topics/");
		$path = "$path1[0]/$path1[1]";
		$handle=opendir($path);
		$tlist2 = "";
		while ($file = readdir($handle)) {
			if(substr($file,0,1) != "!" && substr($file,0,1) != "_" && substr($file,0,1) != "." && !is_file($path . '/' . $file) && !is_link($path . '/' . $file)) {
				$path2 = $path."/".$file;
				$handle2=opendir($path2);
				while ($file2 = readdir($handle2)) {
					if(substr($file2,0,1) != "!" && substr($file2,0,1) != "_" && substr($file2,0,1) != "." && is_file($path2 . '/' . $file2)) {
						if ( (preg_match("#^([0-9a-z]+)([.]{1})([a-z0-9]{3})$#",$file2)) ) {
							$tlist2 .= $file."/$file2 ";
						}
					}
				}
				closedir($handle2);
			}
			if ( (preg_match("#^([0-9a-z]+)([.]{1})([a-z0-9]{3})$#",$file)) ) {
				$tlist .= "$file ";
			}
		}
		closedir($handle);
		$tlist = explode(" ", $tlist);
		sort($tlist);
		$tlist2 = explode(" ", $tlist2);
		sort($tlist2);
		$tlist = array_merge($tlist,$tlist2);
		for ($i=0; $i < sizeof($tlist); $i++) {
			if($tlist[$i]!="") {
				if ($image == $tlist[$i]) {
					$sel = "selected";
				} else {
					$sel = "";
				}
				echo "<option name=\"topicimage\" value=\"$tlist[$i]\" $sel>$tlist[$i]\n";
			}
		}
    echo "</select>";
    echo "<a href=\"images/topics/section_icons.php\" onclick=\"window.open('images/topics/section_icons.php','catalogue','menubar=no, status=no, scrollbars=yes, menubar=no, width=500, height=400');return false\" target=\"_blank\">Voir catalogue</a>";
		
    
    echo "</td></tr>";
	echo "<input type=\"hidden\" name=\"secid\" value=\"$secid\">"
	."<input type=\"hidden\" name=\"op\" value=\"sectionchange\">"
	."<tr><td align=right><input type=\"submit\" value=\""._SAVECHANGES."\"></td><td> [ <a href=\"system.php?op=sectiondelete&amp;secid=$secid&amp;ok=0\">"._DELETE."</a> ]</td></tr>"
	."</form>";
    CloseOngletTable();
    CloseOngletTable();
    include("system/footer_system.php");
}
/*--------------------------------------*/
/*			sectionchange()				*/
/* @abstract:							*/
/* @param:								*/
/* @see								    */
/*--------------------------------------*/
function sectionchange($secid, $secname, $image) {
    global $prefix, $db;
    $secname = stripslashes(FixQuotes($secname));
    $image = stripslashes(FixQuotes($image));
    $db->sql_query("update ".$prefix."_sections set secname='$secname', image='$image' where secid=$secid");
    write_to_log("","","","",_LOG_SECTION_SECTIONCHANGE.$secname);
    Header("Location: system.php?op=sections");
}
/*--------------------------------------*/
/*			secartchange				*/
/* @abstract:							*/
/* @param:								*/
/* @see	  							    */
/*--------------------------------------*/

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;
}

function get_vignette($text, $racine) {
	$vignette = "";
	if (preg_match_all("/(<img[^>]+>)/mi",$text,$tabimages)) {
		$vignette = $tabimages[1][0];
		for ($i=0; $i<count($tabimages[1]); $i++) {
			if (preg_match('/thumb="true"/mi',$tabimages[1][$i])) {
				$vignette = $tabimages[1][$i];
			}
		}	
	}
	$urlvignette = "";
	if ($vignette != "") {
		preg_match("/src=\"([^\"]+)\"/i",$vignette,$taburls);
		$urlvignette = $taburls[1];
		
		$tab_vignette = parse_url($urlvignette);
		$tab_racine = parse_url($racine);
		if ($tab_vignette["host"] != "") {
			if ($tab_vignette["host"] == $tab_racine["host"]) {
				$path     = isset($tab_vignette['path']) ? $tab_vignette['path'] : '';
				$query    = isset($tab_vignette['query']) ? '?' . $tab_vignette['query'] : '';
				$fragment = isset($tab_vignette['fragment']) ? '#' . $tab_vignette['fragment'] : '';
				$urlvignette = $racine."/".$path.$query.$fragment;
			}
		}
		else {
			$urlvignette = $racine."/".$urlvignette;
		}
	}
	return $urlvignette;
}

function secartchange($artid, $secid, $title, $content, $slanguage, $status, $view, $cats, $popup, $mobile, $informant) {
    global $prefix, $db ;
    global $nukeurl;

    $title = stripslashes(FixQuotes($title));
    $content = stripslashes(FixQuotes($content));
    $status = stripslashes(FixQuotes($status));
    $view = stripslashes(FixQuotes($view));
    $informant = stripslashes(FixQuotes($informant));
    if (($status!="P")||($status=="")) $status="NP"; // default is published
	// clean URL . If full url has been added to local link by wysiwyg editor, clean it.
	$myservernotport="\"http://".$_SERVER['SERVER_NAME']; // case of http
	$content = str_replace($myservernotport,"\"",$content);
	$myservernotport="\"https://".$_SERVER['SERVER_NAME']; // case https .. in futur test with regex for one line
	$content = str_replace($myservernotport,"\"",$content);

	// Solve automatic url fill with wysiwyg editor on Internet Explorer when src="#toto".
    // IE add automaticaly current page url before #. That cause issue because current page is a system url.
    $systemUrlPage="system.php?op=secartedit&amp;artid=$artid";
    $userUrlPage="modules.php?name=Sections&sop=viewarticle&artid=$artid";
    $content = str_replace($systemUrlPage,$userUrlPage,$content);
    
    $popup = ($popup == "1") ? "1" : "0";
    $mobile = ($mobile == "1") ? "1" : "0";
    
    global $twitter_card, $twitter_site, $twitter_creator, $og_type;
    $result = $db->sql_query("select twitter_card, twitter_site, twitter_creator, og_url, og_title, og_description, og_image, og_type from ".$prefix."_seccont where artid=$artid");
    if (!$result) {
    	$error = $db->sql_error();
    	die('Invalid query:'.$error["message"]);
    }
    list($page_twitter_card, $page_twitter_site, $page_twitter_creator, $page_og_url, $page_og_title, $page_og_description, $page_og_image, $page_og_type) = $db->sql_fetchrow($result);
    $metasenplus = "";
    if ($page_twitter_card == "") {
    	$page_twitter_card = $twitter_card;
    	$metasenplus .= ", twitter_card='$twitter_card'";
    }
    if ($page_twitter_site == "") {
    	$page_twitter_site = $twitter_site;
    	$metasenplus .= ", twitter_site='$page_twitter_site'";
    }
    if ($page_twitter_creator == "") {
    	$page_twitter_creator = $twitter_creator;
    	$metasenplus .= ", twitter_creator='$page_twitter_creator'";
    }
    if ($page_og_type == "") {
    	$page_og_type = $og_type;
    	$metasenplus .= ", og_type='$page_og_type'";
    }
    if ($page_og_title == "") {
    	$page_og_title = $title;
    	$metasenplus .= ", og_title='$page_og_title'";
    }
    if ($page_og_description == "") {
    	$page_og_description = truncate_string(strip_tags($content), 200);
    	$metasenplus .= ", og_description='$page_og_description'";
    }
    $racine = str_replace("http://","https://", format_nuke_url($nukeurl));
    $vignette = get_vignette($content, $racine);
    if ($page_og_image == "") {
    	$page_og_image = $vignette;
    	$metasenplus .= ", og_image='$page_og_image'";
    }
    if ($page_og_url == "") {
    	$pagename = normalize_name($title);
    	$page_og_url = $racine."/".$pagename."_mpage_".$artid.".htm";
    	$metasenplus .= ", og_url='$page_og_url'";
    }
    
    $result=$db->sql_query("update ".$prefix."_seccont set secid='$secid', title='$title', content='$content', slanguage='$slanguage' , date=now(), status='$status', view='$view', popup='$popup', mobile='$mobile', informant='$informant'$metasenplus where artid=$artid");
    if (!$result) {
    	$error = $db->sql_error();
		die('Invalid query:'.$error["message"]);
     }
     $db->sql_query("DELETE FROM ".$prefix."_seccont_section_link WHERE id_article='".$artid."';");
	if(isset($cats) && is_array($cats))
	{
		foreach ($cats as $cat) {
			$result=$db->sql_query("INSERT INTO ".$prefix."_seccont_section_link VALUES (NULL,'$artid','$cat');");
		}
	}
	else
	{
		$result=$db->sql_query("DELETE FROM ".$prefix."_seccont_section_link WHERE id_article='$artid';");
	}
    // if versionning is actived save a version 
	secartsaveversion($artid);
	
	write_to_log("","","","",_LOG_SECTION_PAGECHANGE.$title);
	
    Header("Location: system.php?op=sections&onglet=articles&idsec=$secid");
}
/*--------------------------------------*/
/*				sectiondelete()			*/
/* @abstract:							*/
/* @param:								*/
/* @see 								*/
/*--------------------------------------*/
function sectiondelete($secid, $ok=0) {
	global $prefix, $db, $admincontrolsection, $admin;
	if ($ok==1) {
		//vrif droits utilisateur sur section
	    if ($admincontrolsection) {
		    if (!is_super($admin)) {
		    		display_denied();
		    		return;
		    }
	    }
	    //fin vrif

		$result=$db->sql_query("select secname from ".$prefix."_sections where secid=$secid");
		list($secname) = $db->sql_fetchrow($result);
		$db->sql_query("delete from ".$prefix."_seccont where secid='$secid'");
		$db->sql_query("delete from ".$prefix."_sections where secid='$secid'");
		write_to_log("","","","",_LOG_SECTION_SECTIONDELETE.$secname);
		Header("Location: system.php?op=sections");
	}
	else {
		//vrif droits utilisateur sur section
	    if ($admincontrolsection) {
		    if (!is_super($admin)) {
		    		display_denied();
		    		return;
		    }
	    }
	    //fin vrif
		
		include("system/header_system.php");
		GraphicAdmin(_SECTIONSADMIN);

		echo "<br>";
		$result=$db->sql_query("select secname from ".$prefix."_sections where secid=$secid");
		list($secname) = $db->sql_fetchrow($result);
		OpenOngletTable();
		echo "<center><b>"._DELSECTION.": $secname</b><br><br>"
		.""._DELSECWARNING." $secname?<br>"
		.""._DELSECWARNING1."<br><br>"
	    ."[ <a href=\"system.php?op=sections\">"._NO."</a> | <a href=\"system.php?op=sectiondelete&amp;secid=$secid&amp;ok=1\">"._YES."</a> ]</center>";
		CloseOngletTable();
		include("system/footer_system.php");
	}
}
/*--------------------------------------*/
/*           secartdelete()				*/
/* @abstract:							*/
/* @param:								*/
/* @see								*/
/*--------------------------------------*/
function secartdelete($artid, $ok=0) {
	global $prefix, $db,$aid, $admin,$admincontrolsection;
	if ($ok==1) {
		$result = $db->sql_query("select title,informant from ".$prefix."_seccont where artid=$artid");
		list($title, $informant) = $db->sql_fetchrow($result);
		
		//vrif droits utilisateur sur article
		if ($admincontrolsection) {
		    if ($aid != $informant && !is_super($admin)) {
		    		display_denied();
		    		return;
		    }
		}
	    //fin vrif

		$db->sql_query("delete from ".$prefix."_seccont where artid='$artid'");
		write_to_log("","","","",_LOG_SECTION_PAGEDELETE.$title);
		Header("Location: system.php?op=sections");
	}
	else {
		$result = $db->sql_query("select title,informant from ".$prefix."_seccont where artid=$artid");
		list($title, $informant) = $db->sql_fetchrow($result);
		
	    //vrif droits utilisateur sur article
		if ($admincontrolsection) {
		    if ($aid != $informant && !is_super($admin)) {
		    		display_denied();
		    		return;
		    }
		}
	    //fin vrif

		include("system/header_system.php");
		GraphicAdmin(_SECTIONSADMIN);
		echo "<br>";
		OpenSysTable();
		echo "<center><b>"._DELARTICLE.": $title</b><br><br>"
		.""._DELARTWARNING."<br><br>"
	    ."[ <a href=\"system.php?op=sections\">"._NO."</a> | <a href=\"system.php?op=secartdelete&amp;artid=$artid&amp;ok=1\">"._YES."</a> ]</center>";
		CloseSysTable();
		include("system/footer_system.php");
	}
}
/**
 * pageNumbering($min, $perpage, $pagenumber,$pos ) display page by page
 * @param
 * @return
 */
 function pageNumbering($min,$perpage,$pagenumber,$pos, $id, $onglet="articles"){

 	if (!isset($min)) $min=0;
    if (!isset($max)) $max=$min+$perpage;


 /* Calculates how many pages exist. Which page one should be on, etc... */
    $pagesint = ($pagenumber / $perpage);
    $pageremainder = ($pagenumber % $perpage);
    if ($pageremainder != 0) {
    	$pages = ceil($pagesint);
    	if ($pagenumber < $perpage) {
    		$pageremainder = 0;
    	}
    } else {
    	$pages = $pagesint;
    }
 /* Page Numbering */
    if ($pages!=1 && $pages!=0) {
        echo "<br><br>";
      	//echo ""._SELECTPAGE.": ";
     	$prev=$min-$perpage;
     	if ($prev>=0) {
    	    echo "&nbsp;&nbsp;<b>[ <a href=\"system.php?op=sections&onglet=$onglet&idsec=$id&amp;min=$prev\" >";
    	    echo " &lt;&lt; "._PREVIOUS."</a> ]</b> ";
  	}
    	$counter = 1;
 	    $currentpage = ($max / $perpage);
       	while ($counter<=$downloadpages ) {
      	    $cpage = $counter;
      	    $mintemp = ($perpage * $counter) - $perpage;
      	    if ($counter == $currentpage) {
		echo "<b>$counter</b>&nbsp";
	    } else {
		echo "<a href=\"system.php?op=section&onglet=$onglet&idsec=$id&amp;min=$mintemp\" >$counter</a> ";
	    }
       	    $counter++;
       	}
     	$next=$min+$perpage;
     	if ($pos>=$perpage) {
    		echo "&nbsp;&nbsp;<b>[ <a href=\"system.php?op=sections&onglet=$onglet&idsec=$id&amp;min=$max\">";
    		echo " "._NEXT." &gt;&gt;</a> ]</b> ";
     	}
    }
 }

/**
 * metaedit()
 * Edit page meta information
 * @param article id
 */
function metaedit($artid){
 global $prefix, $db, $ongletDef;
    include("system/header_system.php");
    GraphicAdmin(_SECTIONSADMIN);

    $result = $db->sql_query("select title, keywords, description, twitter_card, twitter_site, twitter_creator, og_url, og_title, og_description, og_image, og_type, status from ".$prefix."_seccont where artid=$artid");
    if (!$result) {
    	$error = $db->sql_error();
		die('Invalid query:'.$error["message"]);
	}

    list($title, $page_meta_keyword, $page_meta_description, $page_twitter_card, $page_twitter_site, $page_twitter_creator, $page_og_url, $page_og_title, $page_og_description, $page_og_image, $page_og_type, $status) = $db->sql_fetchrow($result);
    
	OpenOngletTable();
	displayOngletBar("articles",_EDITARTICLE." Meta information",$ongletDef);
	OpenOngletTable();

	echo "<tr><td valign=top>";
	echo "Meta Information pour l'Article : $title<br></td><td></td></tr>";
	echo "<tr><td>";


	echo "<form id=\"theForm\" action=\"system.php\" method=\"post\">"
		."<input type=\"hidden\" name=\"artid\" value=\"$artid\">"
		."<input type=\"hidden\" name=\"op\" value=\"metachange\">";

	echo "<table class=systemTab align=center>";
	echo "<tr><td valign=top>"
		.""._METADESCRIPTION.":</td><td valign=top><textarea name=\"page_meta_description\" cols=\"100\" rows=\"5\">$page_meta_description</textarea> "
		."</td></tr><tr><td valign=top>"
		.""._METAKEYWORD.":</td><td valign=top><textarea name=\"page_meta_keyword\" cols=\"100\" rows=\"5\">$page_meta_keyword</textarea> "
		."</td></tr><tr><td valign=top>"
		.""."Format de carte Twitter (twitter:card)"." : </td><td valign=top><textarea name=\"page_twitter_card\" cols=\"100\" rows=\"3\">$page_twitter_card</textarea> "
		."</td></tr><tr><td valign=top>"
		.""."Identifiant twitter du compte du site (twitter:site)"." : </td><td valign=top><textarea name=\"page_twitter_site\" cols=\"100\" rows=\"3\">$page_twitter_site</textarea> "
		."</td></tr><tr><td valign=top>"
		.""."Identifiant twitter du compte de l'diteur (twitter:creator)"." : </td><td valign=top><textarea name=\"page_twitter_creator\" cols=\"100\" rows=\"3\">$page_twitter_creator</textarea> "
		."</td></tr><tr><td valign=top>"
		.""."Adresse de l'article  partager (og:url)"." : </td><td valign=top><textarea name=\"page_og_url\" cols=\"100\" rows=\"3\">$page_og_url</textarea> "
		."</td></tr><tr><td valign=top>"
		.""."Titre de l'article (og:title)"." : </td><td valign=top><textarea name=\"page_og_title\" cols=\"100\" rows=\"3\">$page_og_title</textarea> "
		."</td></tr><tr><td valign=top>"
		.""."Description de l'article (og:description)"." : </td><td valign=top><textarea name=\"page_og_description\" cols=\"100\" rows=\"5\">$page_og_description</textarea> "
		."</td></tr><tr><td valign=top>"
		.""."Illustration de l'article (og:image)"." : </td><td valign=top><textarea name=\"page_og_image\" cols=\"100\" rows=\"3\">$page_og_image</textarea> "
		."</td></tr><tr><td valign=top>"
		.""."Type de document (og:type)"." : </td><td valign=top><textarea name=\"page_og_type\" cols=\"100\" rows=\"3\">$page_og_type</textarea> "
		."</td></tr></table>"
		."</td></tr>"
	    ."<tr><td align=right><input type=\"submit\" value=\""._SAVECHANGES."\"></td></tr>";
 	echo "</form>";
	CloseOngletTable();
	CloseOngletTable();
}

/**
 * metachange()
 * @param int artid Aticle ID
 * @param string meta_keyword Meta data keywords
 * @param string meta_description meta data description
 */
function metachange($artid, $page_meta_keyword, $page_meta_description, $page_twitter_card, $page_twitter_site, $page_twitter_creator, $page_og_url, $page_og_title, $page_og_description, $page_og_image, $page_og_type){
	global $prefix, $db;
    $artid = stripslashes(FixQuotes($artid));
    $result = $db->sql_query("select title from ".$prefix."_seccont where artid=$artid");
	list($title) = $db->sql_fetchrow($result);
    $page_meta_keyword = stripslashes(FixQuotes($page_meta_keyword));
    $page_meta_description = stripslashes(FixQuotes($page_meta_description));
    $result=$db->sql_query("update ".$prefix."_seccont set keywords='$page_meta_keyword', description='$page_meta_description', twitter_card='$page_twitter_card', twitter_site='$page_twitter_site', twitter_creator='$page_twitter_creator', og_url='$page_og_url', og_title='$page_og_title', og_description='$page_og_description', og_image='$page_og_image', og_type='$page_og_type' where artid=$artid");
    if (!$result) {
    	$error = $db->sql_error();
		die('Invalid query:'.$error["message"]);
	}
	write_to_log("","","","",_LOG_SECTION_METACHANGE.$title);
    Header("Location: system.php?op=sections");
}

function categorizepage($id_art,$id_sec,$value) {
	global $prefix,$db;
	if ($value==0) {
		//suppression
		$sql = "DELETE FROM ".$prefix."_seccont_section_link WHERE id_article='".$id_art."' AND id_section='".$id_sec."';";
	}
	else {
		//ajout
		$sql = "INSERT INTO ".$prefix."_seccont_section_link (id_article, id_section) VALUES ('".$id_art."', '".$id_sec."');";
	}
	//echo ($db->sql_query($sql)) ? "" : "Erreur enregistrement !";
	$db->sql_query($sql);
	$sql = "SELECT secname FROM ".$prefix."_sections INNER JOIN ".$prefix."_seccont_section_link ON secid=id_section WHERE id_article='".$id_art."' ORDER BY secname ASC;";
	$result = $db->sql_query($sql);
	$sortie = "";
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$sortie .= ($sortie != "") ? ", " : "";
			if (preg_match("#^!(.*)$#",$ligne["secname"],$subname)) {
				$secname = $subname[1];
			}
			else {
				$secname = $ligne["secname"];
			}
			$sortie .= $secname;
		}
	}
	echo $sortie;
}

function secartdupplicate($artid) {
	global $prefix,$db;
	
	$sql = "SELECT secid, title, content, counter, slanguage, date, informant, status, keywords, description, view, weight, popup, mobile,twitter_card,twitter_site,twitter_creator,og_url,og_title,og_description,og_image,og_type";
	$sql .= " FROM ".$prefix."_seccont";
	$sql .= " WHERE artid='".$artid."'";
	$result = $db->sql_query($sql);
    if ($db->sql_numrows($result) > 0) {
		if ($ligne = $db->sql_fetchrow($result)) {
			$title = $ligne["title"];
			$ligne["title"] = str_replace("'", "''", $ligne["title"])." copy";
			$ligne["content"] = str_replace("'", "''", $ligne["content"]);
			$ligne["informant"] = str_replace("'", "''", $ligne["informant"]);
			$ligne["keywords"] = str_replace("'", "''", $ligne["keywords"]);
			$ligne["description"] = str_replace("'", "''", $ligne["description"]);			
			$ligne["twitter_card"] = str_replace("'", "''", $ligne["twitter_card"]);
			$ligne["twitter_site"] = str_replace("'", "''", $ligne["twitter_site"]);
			$ligne["twitter_creator"] = str_replace("'", "''", $ligne["twitter_creator"]);
			$ligne["og_url"] = str_replace("'", "''", $ligne["og_url"]);
			$ligne["og_title"] = str_replace("'", "''", $ligne["og_title"]);
			$ligne["og_description"] = str_replace("'", "''", $ligne["og_description"]);
			$ligne["og_image"] = str_replace("'", "''", $ligne["og_image"]);
			$ligne["og_type"] = str_replace("'", "''", $ligne["og_type"]);
			
			$ligne["counter"] = "0";
			
			/*
			$newarticle = array (
					"secid" => $ligne["secid"], 
					"title" => $ligne["title"], 
					"content" => $ligne["content"], 
					"counter" => $ligne["counter"], 
					"slanguage" => $ligne["slanguage"], 
					"date" => $ligne["date"], 
					"informant" => $ligne["informant"], 
					"status" => $ligne["status"], 
					"keywords" => $ligne["keywords"], 
					"description" => $ligne["description"], 
					"view" => $ligne["view"], 
					"weight" => $ligne["weight"], 
					"popup" => $ligne["popup"], 
					"mobile" => $ligne["mobile"]
				);
			*/
			
			$newarticle = array();
			$resultColumns = $db->sql_query("SHOW COLUMNS FROM ".$prefix."_seccont;");
			while ($field = $db->sql_fetchrow($resultColumns)) {
				if (isset($ligne[$field['Field']])) {
					$newarticle[$field['Field']] = $ligne[$field['Field']];
				}
			}
	
			$list_champs = ""; $list_valeurs="";
			foreach($newarticle as $key => $value) {
			if ($key != "id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO ".$prefix."_seccont (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
			$ok = $db->sql_query($sql);
			if ($ok) {
				global $nukeurl;
				$idart = $db->sql_nextid();
				$racine = str_replace("http://","https://", format_nuke_url($nukeurl));
				$pagename = normalize_name($title);
				$page_og_url = $racine."/".$pagename."_mpage_".$idart.".htm";
				$result=$db->sql_query("update ".$prefix."_seccont set og_url='$page_og_url' where artid=$idart");
				if (!$result) {
					$error = $db->sql_error();
					die('Invalid query:'.$error["message"]);
				}
			}
			return $ok;
		}
		else {
			die("Erreur dupplication 2");
		}
	}
	else {
		die("Erreur dupplication 1");
	}
}

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/
switch ($op) {

    case "sections":
    sections($onglet,$idsec, $min, $id_section);
    break;

    case "sectionedit":
    sectionedit($secid);
    break;

    case "sectionmake":
    sectionmake($secname, $image);
    break;

    case "sectiondelete":
    sectiondelete($secid, $ok);
    break;

    case "sectionchange":
    sectionchange($secid, $secname, $image);
    break;

    case "metachange":
    metachange($artid, $page_meta_keyword, $page_meta_description, $page_twitter_card, $page_twitter_site, $page_twitter_creator, $page_og_url, $page_og_title, $page_og_description, $page_og_image, $page_og_type);
    break;

    case "metaedit":
    metaedit($artid);
    break;

    case "secarticleadd":
    secarticleadd($secid, $title, $content, $slanguage, $status, $view, $cats,$popup,$mobile, $informant);
    break;

    case "secartedit":
    secartedit($artid);
    break;

    case "secartchange":
    secartchange($artid, $secid, $title, $content, $slanguage, $status, $view,$cats,$popup, $mobile, $informant);
    break;

    case "secartdelete":
    secartdelete($artid, $ok);
    break;
    
    case "restorePage":
    restorePage($historyid, $ok);
    break;
    
    case "categorizepage" :
    	categorizepage($id_art,$id_sec,$valid);
    	die();
    	break;
    
    case "secartduppl" :
    	if (secartdupplicate($artid)) {
    		header("Location: system.php?op=sections&onglet=".$onglet."&idsec=".$idsec);
    		die();
    	}
    	else {
    		die("Erreur dupplication 3");
    	}
    	break;
}

}
else {
    display_denied();
}

?>