<?php
/**
* Interfaage du module avec le Front Office du CMS.
* 
* Son inclusion dans le Back Office est automatique, et son accs se trouve dans le menu "Modules"
* Ce module excute des actions dclenches par les formulaires.
* @package becmsSimpleActForm
* @version 1.0
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/


if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");

/**
* Expdition d'un e-mail.
* @param string $email Adresse d'expdition de l'e-mail.
* @param string $subject Sujet de l'e-mail.
* @param string $message Corps du massage  expdier.
* @return boolean True si le message a t expdi, false sinon.
*/
	function send_email($email,$nom,$from,$subject, $message){
		// En-ttes
		$headers = "From: ".$from."\n";
		$headers .= "X-Sender: ".$from."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".$from."\n";
		if ($nom != "") {
			$headers .= "Reply-To: ".$nom." <".$from.">\n";
		}
		else {
			$headers .= "Reply-To: ".$from."\n";
		}
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
		return mail($email, $subject, $message, $headers);
	}
	
	function send_email_pj($email,$nom,$from,$subject, $message, $nomfichier, &$fichier){
		// En-ttes

		$limite1 = "=_".md5(uniqid(rand()));
				
		$headers = "From: ".$from."\n";
		$headers .= "X-Sender: ".$from."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "MIME-Version: 1.0\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".$from."\n";
		if ($nom != "") {
			$headers .= "Reply-To: ".$nom." <".$from.">\n";
		}
		else {
			$headers .= "Reply-To: ".$from."\n";
		}
		$headers .= "Date: ".date ("r")."\n";
		$headers .= "Content-Type: multipart/mixed; boundary=\"".$limite1."\"\n\n";
		
		$message = "--".$limite1."\n"."Content-Type: text/plain; charset=ISO-8859-1\n\n".$message."\n\n";
		
		$message .= "--".$limite1."\n";
		$message .= "Content-Type: application/octet-stream; name=\"".$nomfichier."\"r\n";
		$message .= "Content-Transfer-Encoding: base64\n";
		$message .= "Content-Disposition: attachment; filename=\"".$nomfichier."\"\n\n";
		
		$message .= $fichier;
		
		$message .= "--".$limite1."--\n\n";
		
		return mail($email, $subject, $message, $headers);
	}

function testinit(&$valeur,$valeurinit="") {
	if (!isset($valeur)) {
		return $valeurinit;
	}
	return $valeur;
}



$varemail = array(
"nom"=>testinit($GLOBALS["nom"]),
"from"=>testinit($GLOBALS["emailexp"]),
"email"=>testinit($GLOBALS["email"]),
"email1"=>testinit($GLOBALS["email1"]),
"email2"=>testinit($GLOBALS["email2"]),
"subject"=>testinit($GLOBALS["subject"]),
"message"=>testinit($GLOBALS["message"]),

"prenom"=>testinit($GLOBALS["prenom"]),
"societe"=>testinit($GLOBALS["societe"]),
"siret"=>testinit($GLOBALS["siret"]),
"adresse"=>testinit($GLOBALS["adresse"]),
"tel"=>testinit($GLOBALS["tel"]),
"codepostal"=>testinit($GLOBALS["codepostal"]),
"ville"=>testinit($GLOBALS["ville"]),
"pays"=>testinit($GLOBALS["pays"]),
"tva"=>testinit($GLOBALS["tva"]),
"pj"=>testinit($GLOBALS["pj"])
);
$varemail = array_map("stripslashes",$varemail);

if (isset($messdata)) {
	$messdata = array_map("stripslashes",$messdata);
	$varemail["messdata"] = $messdata;
}

if ($varemail["from"] == "" && $messdata["courriel"] != "") {
	$varemail["from"] = $messdata["courriel"];
}

if ($varemail["from"] == "" && $messdata["Courriel"] != "") {
	$varemail["from"] = $messdata["Courriel"];
}

if ($varemail["subject"] == "") {
	$varemail["subject"] = $messdata["sujet"];
}

if ($varemail["from"] == "") {
	$taburl=parse_url($nukeurl);
	$tabdomain=explode('.', $taburl["host"]);
	array_shift($tabdomain);
	$domain = join(".",$tabdomain);
	$varemail["from"] = "serveur_web@".$domain;
}


	
/**
* Expdie un e-mail et affiche le rsultat.
* 
* Doit tre utilis avec ce formulaire (ou utilisant les mmes champs) :
* <form name="form_message" action="modules.php?name=SimpleActForm&amp;sop=send_mail" method="post">
*    <table width="" cellspacing="5" cellpadding="0" border="0" align="center" summary="">
*        <tbody>
*            <tr>
*                <td><p>Votre nom :</p></td>
*               <td><input type="text" style="width: 250px;" name="nom" /></td>
*            </tr>
*            <tr>
*                <td><p>Votre e-mail :</p></td>
*                <td><input type="text" style="width: 250px;" name="emailexp" /></td>
*            </tr>
*            <tr>
*                <td><p>Sujet du message :</p></td>
*                <td><input type="text" style="width: 250px;" name="subject" /></td>
*            </tr>
*            <tr>
*                <td><p>Votre message :</p></td>
*                <td><textarea style="width: 250px;" name="message" rows="5"></textarea></td>
*            </tr>
*            <tr>
*                <td align="center" colspan="2">&nbsp;<input type="hidden" name="email" value="mairie-saintelucie@wanadoo.fr" /><br />
*                <input type="submit" value="Expdier le message" name="bexp" /></td>
*            </tr>
*        </tbody>
*    </table>
*</form>
* @param array $varemail Tableau contenant tous les paramtres d'expdition du message.
*/
function sendEmail($varemail) {
	include ('header.php');
    if (send_email($varemail["email"],$varemail["nom"],$varemail["from"],$varemail["subject"], $varemail["message"])) {
    		echo _CONFIRMEXPMAIL;
    }
    else {
    		echo _CONFIRMNOTEXPMAIL;
    }
    include ('footer.php');
}


/**
* Expdie un e-mail et affiche le rsultat.
* 
* Doit tre utilis avec ce formulaire (ou utilisant les mmes champs) :
<form name="form_message" onsubmit="return submit_form(this)" method="post" action="modules.php?name=SimpleActForm&amp;sop=send_mail2">
    <table cellspacing="5" cellpadding="0" border="0" align="center" summary="">
        <tbody>
            <tr>
                <td>
                <p>Votre nom* :<br />
                </p>
                </td>
                <td><input type="text" name="nom" style="width: 350px;" /></td>
            </tr>
            <tr>
                <td>
                <p>Votre pr&eacute;nom* :<br />
                </p>
                </td>
                <td><input type="text" name="prenom" style="width: 350px;" /></td>
            </tr>
            <tr>
                <td>
                <p>Soci&eacute;t&eacute; :<br />
                </p>
                </td>
                <td><input type="text" name="societe" style="width: 350px;" /></td>
            </tr>
            <tr>
                <td>
                <p>N&deg; SIRET :<br />
                </p>
                </td>
                <td><input type="text" name="siret" style="width: 350px;" /></td>
            </tr>
            <tr>
                <td>
                <p>Adresse postale* :<br />
                </p>
                </td>
                <td><textarea name="adresse" rows="3" style="width: 350px;"></textarea></td>
            </tr>
            <tr>
                <td>
                <p>T&eacute;l&eacute;phone* :<br />
                </p>
                </td>
                <td><input type="text" name="tel" style="width: 350px;" /></td>
            </tr>
            <tr>
                <td>
                <p>Votre e-mail* :<br />
                </p>
                </td>
                <td><input type="text" name="emailexp" style="width: 350px;" /></td>
            </tr>
            <tr>
                <td>
                <p>Sujet du message :<br />
                </p>
                </td>
                <td><input type="text" name="subject" style="width: 350px;" /></td>
            </tr>
            <tr>
                <td>
                <p>Votre message* :<br />
                </p>
                </td>
                <td><textarea name="message" rows="5" style="width: 350px;"></textarea></td>
            </tr>
            <tr>
                <td align="center" colspan="2"><font size="2" color="#ff0000"><span class="texte_rouge">* Les champs obligatoires</span> sont signal&eacute;s par un ast&eacute;risque.</font></td>
            </tr>
            <tr>
                <td align="center" colspan="2"><input type="hidden" value="ps-kollen@club-internet.fr" name="email" /><br />
                <input type="submit" value="Expdier le message" name="bexp" /></td>
            </tr>
        </tbody>
    </table>
</form>
* @param array $varemail Tableau contenant tous les paramtres d'expdition du message.
*/
function sendEmail2($varemail) {
	include ('header.php');

	$expediteur = $varemail["nom"]." ".$varemail["prenom"]."\n";
	if ($varemail["societe"] != "") {
		$expediteur .= "Socit : ".$varemail["societe"]."\n";
	}
	$expediteur .= $varemail["adresse"]."\n";
	$expediteur .= $varemail["codepostal"]." ".$varemail["ville"]."\n";
	$expediteur .= $varemail["pays"]."\n";
	
	$expediteur .= "Tlphone : ".$varemail["tel"]."\n";
	$expediteur .= "Siret : ".$varemail["siret"]."\n";
	$expediteur .= "TVA intracommunautaire : ".$varemail["tva"]."\n";
	
	$varemail["message"] = $expediteur."\n\n\n".$varemail["message"];
	
    if (send_email($varemail["email"],$varemail["nom"],$varemail["from"],$varemail["subject"], $varemail["message"])) {
    		echo _CONFIRMEXPMAIL;
    }
    else {
    		echo _CONFIRMNOTEXPMAIL;
    }
    include ('footer.php');
}

/**
* Expdie un e-mail et affiche le rsultat.
* 
* Doit tre utilis avec ce formulaire (ou utilisant les mmes champs) :
* <form method="post" action="modules.php?name=SimpleActForm&amp;sop=send_mail_obfus" name="form_message" onsubmit="return submit_form(this)">
*    <table width="" cellspacing="5" cellpadding="0" border="0" align="center" summary="">
*        <tbody>
*            <tr>
*                <td>
*                <p>Votre nom :<br />
*                </p>
*                </td>
*                <td><input type="text" name="nom" style="width: 250px;" /></td>
*            </tr>
*            <tr>
*                <td>
*                <p>Votre e-mail :<br />
*                </p>
*                </td>
*                <td><champ lim="3,100" nom="emailexp" lib="Votre e-mail" ctl="email"></champ><input type="text" name="emailexp" style="width: 250px;" /></td>
*            </tr>
*            <tr>
*                <td>
*                <p>Sujet du message :<br />
*                </p>
*                </td>
*                <td><input type="text" name="subject" style="width: 250px;" /></td>
*            </tr>
*            <tr>
*                <td>
*                <p>Votre message:                 </p>
*                </td>
*                <td><champ lim="5" nom="message" lib="Votre message"></champ><textarea rows="5" name="message" style="width: 250px;"></textarea></td>
*            </tr>
*            <tr>
*                <td align="center" colspan="2"> <input type="hidden" value="webmaster@blackhole.org" name="email1" /> <input type="hidden" value="arobase.fr@blackhole.org" name="email2" /><br />
*                <input type="submit" name="bexp" value="Expdier le message" /></td>
*           </tr>
*        </tbody>
*    </table>
* </form>
* @param array $varemail Tableau contenant tous les paramtres d'expdition du message.
*/
function sendEmailObfus($varemail) {
	include ('header.php');
	$emails1 = explode(",", $varemail["email1"]);
	$emails2 = explode(",", $varemail["email2"]);
	$ok = true;
	for ($i=0; $i<count($emails1); $i++) {
		$temp1 = explode("@",trim($emails1[$i]));
		$temp2 = explode("@",trim($emails2[$i]));
		$ok = $ok && send_email($temp1[0]."@".$temp2[0],$varemail["nom"],$varemail["from"],$varemail["subject"], $varemail["message"]);
	}
	if ($ok) {
    		echo '<div id="bloc_repere_fond">'._CONFIRMEXPMAIL.'<p>&nbsp;</p></div>';
    }
    else {
    		echo '<div id="bloc_repere_fond">'._CONFIRMNOTEXPMAIL.'<p>&nbsp;</p></div>';
    }
    /*
	$temp1 = explode("@",$varemail["email1"]);
	$temp2 = explode("@",$varemail["email2"]);
    if (send_email($temp1[0]."@".$temp2[0],$varemail["nom"],$varemail["from"],$varemail["subject"], $varemail["message"])) {
    		echo _CONFIRMEXPMAIL;
    }
    else {
    		echo _CONFIRMNOTEXPMAIL;
    }
    */
    include ('footer.php');
}

function sendMailFede($varemail) {
	include ('header.php');
	$temp1 = explode("@",$varemail["email1"]);
	$temp2 = explode("@",$varemail["email2"]);
	$destinataire = $temp1[0]."@".$temp2[0];
	if ($varemail["subject"] == "") {
		$varemail["subject"] = "Pas de sujet";
	}
	if ($varemail["from"] == "") {
		$varemail["from"] = "webmaster@arobase.fr";
	}
	
	$message = "Nom : ".$varemail["nom"]."\n";
	$message .= "Socit : ".$varemail["societe"]."\n";
	$message .= "E-mail : ".$varemail["from"]."\n\n";
	$message .= $varemail["message"]."\n";
	
	if ($_FILES["pj"]["name"] != "") {
		if (is_uploaded_file($_FILES["pj"]["tmp_name"])) {
			$handle = fopen ($_FILES["pj"]["tmp_name"], "rb");
			$image = fread ($handle, filesize ($_FILES["pj"]["tmp_name"]));
			fclose ($handle);
			$fichier = str_replace("\r\n","\n",chunk_split(base64_encode($image)));
			unset($image);
			$nomfichier = $_FILES["pj"]["name"];
			unlink($_FILES["pj"]["tmp_name"]);
		}
		else {
			die("Le fichier n'a pas t upload (trop gros ? droits ?)");
		}
		$resulat = send_email_pj($destinataire,$varemail["nom"],$varemail["from"],$varemail["subject"], $message,$nomfichier, $fichier);
	}
	else {
		$resulat = send_email($destinataire,$varemail["nom"],$varemail["from"],$varemail["subject"], $message);
	}
    if ($resulat) {
    		echo _CONFIRMEXPMAIL;
    }
    else {
    		echo _CONFIRMNOTEXPMAIL;
    }
    include ('footer.php');
}

function sendEmailMessdata($varemail) {
	include ('header.php');
	$temp1 = explode("@",$varemail["email1"]);
	$temp2 = explode("@",$varemail["email2"]);
	
	foreach($varemail["messdata"] as $key=>$value) {
		$varemail["message"] .= "\n\n".$key." : ".$value;
	}
	
/*	echo '<pre>';
	global $messdata;
	print_r($messdata);
	echo "\n\n".$temp1[0]."@".$temp2[0]."\n\n".$varemail["nom"]."\n\n".$varemail["from"]."\n\n".$varemail["subject"]."\n\n".$varemail["message"];
	echo'</pre>';
*/
	
    if (send_email($temp1[0]."@".$temp2[0],$varemail["nom"],$varemail["from"],$varemail["subject"], $varemail["message"])) {
    		echo _CONFIRMEXPMAIL;
    }
    else {
    		echo _CONFIRMNOTEXPMAIL;
    }
    include ('footer.php');
}

function sendEmailMessdataPJ($varemail) {
	include ('header.php');
	$temp1 = explode("@",$varemail["email1"]);
	$temp2 = explode("@",$varemail["email2"]);
	$destinataire = $temp1[0]."@".$temp2[0];
	
	foreach($varemail["messdata"] as $key=>$value) {
		$varemail["message"] .= "\n\n".$key." : ".$value;
	}
	
	if ($_FILES["pj"]["name"] != "") {
		if (is_uploaded_file($_FILES["pj"]["tmp_name"])) {
			$handle = fopen ($_FILES["pj"]["tmp_name"], "rb");
			$image = fread ($handle, filesize ($_FILES["pj"]["tmp_name"]));
			fclose ($handle);
			$fichier = str_replace("\r\n","\n",chunk_split(base64_encode($image)));
			unset($image);
			$nomfichier = $_FILES["pj"]["name"];
			unlink($_FILES["pj"]["tmp_name"]);
		}
		else {
			die("Le fichier n'a pas t upload (trop gros ? droits ?)");
		}
		$resulat = send_email_pj($destinataire,$varemail["nom"],$varemail["from"],$varemail["subject"], $varemail["message"],$nomfichier, $fichier);
	}
	else {
		$resulat = send_email($destinataire,$varemail["nom"],$varemail["from"],$varemail["subject"], $varemail["message"]);
	}
    if ($resulat) {
    		echo _CONFIRMEXPMAIL;
    }
    else {
    		echo _CONFIRMNOTEXPMAIL;
    }
    include ('footer.php');
}


/**
 * Appel des fonctions en fonction du paramtre $sop.
 */
switch($sop) {
    case "send_mail":
		sendEmail($varemail);
	    break;
	case "send_mail2":
		sendEmail2($varemail);
	    break;
	case "send_mail_obfus":
		sendEmailObfus($varemail);
	    break;
	case "send_mail_messdata":
		sendEmailMessdata($varemail);
	    break;
	case "send_mail_messdata_pj":
		sendEmailMessdataPJ($varemail);
	    break;
	case "send_mail_fede":
		sendMailFede($varemail);
		break;
	default:
    		include ('header.php');
    		echo _ACTFORMLIST;
    		include ('footer.php');
	    break;
}

?>