<?php
/*
 * $cat peut recevoir des valeurs spares par "," ou par ";"
 * la spartion par "," signifie que la recherche est effectue avec un ET logique entre les catgories
 * la spartion par ";" signifie que la recherche est effectue avec un OU logique entre les catgories
 * les deux sparations ne peuvent pas tre mixes
 * */
function getXMLcarto($metacat="", $cat ="", $village="") {
	global $db, $prefix,$module_name;
	global $My_SQL, $vars_mod;
	global $Default_Theme;
	global $currentlang;
	//carte
	require_once("modules/SimpleCarto/lib/g_params.php");
	require_once("modules/SimpleCarto/lib/g_db.php");
	require_once("modules/SimpleCarto/lib/ba_admincarto.php");
	require_once("modules/".$module_name."/system/language/lang-".$currentlang.".php");
	
	
	$My_SQL["maBase"] = $db;
	
	$sgbd = new BD_Cartos();
	$utils = new adminCartos();
	
	$cartes = $sgbd->getCartes($My_SQL,$vars_mod[$vars_mod["id_carte"]]);
	
	require_once("modules/Sections/connector_class.php");
	$pages = new pageconnector();
	
	$sortie = '<?xml version="1.0" encoding="UTF-8"?>';
/*<?xml-stylesheet type="text/xsl" href="'.$vars_mod["cheminIcones"].'/cartes.xsl"?>
<!DOCTYPE cartes SYSTEM "'.$vars_mod["cheminIcones"].'/cartes.dtd">
';*/
$sortie .= '<cartes>';
	
	if (count($cartes) != 0) {
		foreach ($cartes as $carte) {
			$sortie .= '
	<carte Id="'.$carte["Id"].'">
		<titre><![CDATA['.$utils->conditionnerXML($carte["designation"]).']]></titre>
		<latitudeinit>'.$carte["latitudeinit"].'</latitudeinit>
		<longitudeinit>'.$carte["longitudeinit"].'</longitudeinit>
		<zoominit>'.$carte["zoominit"].'</zoominit>
		<zoomclic>'.$carte["zoomclic"].'</zoomclic>
		<points_bordure><![CDATA['.$carte["bordure"].']]></points_bordure>
		<points_visibilite><![CDATA['.$carte["visibilite"].']]></points_visibilite>
		<points_epaisseur>'.$carte["epaisseur"].'</points_epaisseur>
		<points_couleur>'.$carte["couleur"].'</points_couleur>
		<points_opacite>'.$carte["opacite"].'</points_opacite>
		<page_carte><![CDATA['.$pages->getPageContent($carte["page"],"",true).']]></page_carte>
		<commentaire><![CDATA['.$utils->conditionnerXML($carte["commentaire"]).']]></commentaire>
		<option_print>'.$carte["print"].'</option_print>
		<option_bulles>'.$carte["bulles"].'</option_bulles>
		<option_bordure>'.$carte["limites"].'</option_bordure>
		<option_polygones>'.$carte["polygones"].'</option_polygones>
		<option_pictos>'.$carte["pictos"].'</option_pictos>
		<option_legende>'.$carte["legende"].'</option_legende>
		<option_type_map>'.$carte["type"].'</option_type_map>
		<option_mini_map>'.$carte["mini"].'</option_mini_map>
		<option_titre>'.$carte["titre"].'</option_titre>
		<option_commentaire>'.$carte["commenter"].'</option_commentaire>
		<option_seuil_texte>'.$carte["seuil"].'</option_seuil_texte>
		<option_controles>'.$carte["controles"].'</option_controles>
		<option_taille>'.$carte["taille"].'</option_taille>
		<option_zoom_min>'.$carte["zoommin"].'</option_zoom_min>
		<option_zoom_max>'.$carte["zoommax"].'</option_zoom_max>';
		
		$lieux = $sgbd->getLieux($My_SQL,"",$carte["Id"]);
		
		if (count($lieux) != 0) {
			$sortie .= '
		<points>';
			foreach ($lieux as $lieu) {
				if ($lieu["isbordure"] != "1" && $lieu["istext"] != "1") {
					$sortie .= '
			<point Id="'.$lieu["Id"].'">
				<latitude>'.$lieu["latitude"].'</latitude>
				<longitude>'.$lieu["longitude"].'</longitude>
				<picto>'.$utils->conditionnerXML($lieu["icone"]).'</picto>
				<lieu><![CDATA['.$utils->conditionnerXML($lieu["lieu"]).']]></lieu>
				<lien><![CDATA['.$utils->conditionnerXML($lieu["fiche"]).']]></lien>
				<cible>'.$utils->conditionnerXML($lieu["target"]).'</cible>
				<commentaire_point><![CDATA['.$utils->conditionnerXML($lieu["commentaire"]).']]></commentaire_point>';
						$sortie .= '
			</point>';
				}
			}
			
			$sortie .= '
		</points>';
		}
		
		if (count($lieux) != 0) {
			$sortie .= '
		<textes>';
			foreach ($lieux as $lieu) {
				if ($lieu["isbordure"] != "1" && $lieu["istext"] == "1") {
					$sortie .= '
			<texte Id="'.$lieu["Id"].'">
				<latitude_texte>'.$lieu["latitude"].'</latitude_texte>
				<longitude_texte>'.$lieu["longitude"].'</longitude_texte>
				<lieu_texte><![CDATA['.$utils->conditionnerXML($lieu["lieu"]).']]></lieu_texte>
				<commentaire_texte><![CDATA['.$utils->conditionnerXML($lieu["commentaire"]).']]></commentaire_texte>
				<dim_texte>'.$utils->tailleLieuDit($lieu["lieu"],$lieu["angle"],$lieu["typo"],$lieu["taille"],$vars_mod["cheminPolices"]).'</dim_texte>
				<angle_texte>'.$lieu["angle"].'</angle_texte>
				<couleur_texte>'.$lieu["couleur"].'</couleur_texte>
				<police_texte>'.$lieu["typo"].'</police_texte>
				<taille_texte>'.$lieu["taille"].'</taille_texte>
				<lien_texte><![CDATA['.$utils->conditionnerXML($lieu["fiche"]).']]></lien_texte>
				<cible_texte>'.$utils->conditionnerXML($lieu["target"]).'</cible_texte>
			</texte>';
				}
			}
			$sortie .= '
		</textes>';
		}
		
		if (count($lieux) != 0) {
			$sortie .= '
		<polygones>';
			foreach ($lieux as $lieu) {
				if ($lieu["isbordure"] == "1") {
					$sortie .= '
			<polygone Id="'.$lieu["Id"].'">
				<nom><![CDATA['.$utils->conditionnerXML($lieu["lieu"]).']]></nom>
				<details><![CDATA['.$utils->conditionnerXML($lieu["commentaire"]).']]></details>
				<polyencode><![CDATA['.$lieu["bordure"].']]></polyencode>
				<polyvisibilite><![CDATA['.$lieu["b_visibilite"].']]></polyvisibilite>
				<epaisseur>'.$lieu["b_epaisseur"].'</epaisseur>
				<couleur>'.$lieu["b_couleur"].'</couleur>
				<opacite>'.$lieu["b_opacite"].'</opacite>
				<plein>'.$lieu["b_plein"].'</plein>
				<lien_polygone><![CDATA['.$utils->conditionnerXML($lieu["fiche"]).']]></lien_polygone>
				<cible_polygone>'.$utils->conditionnerXML($lieu["target"]).'</cible_polygone>
			</polygone>';
				}
			}
			$sortie .= '
		</polygones>';
		}
		
		//recherche des adhrents
		$where = "";
		$having = "";
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$prefix."_adherents.sansfiche='0'"; // uniquement des adhrents avec fiche
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$prefix."_adherents.latitude<>'' AND ".$prefix."_adherents.longitude<>''"; // uniquement des adhrents avec coords
		if ($cat != "") {
			if (strpos($cat, ";") === false) {
				$tabcats = explode(",",$cat);
				$tabcats = array_map(array('utilFuncs_adherents', 'trimtodb'), $tabcats);
				$tabcats = array_unique($tabcats);
				$nbrecats = count($tabcats);
				$where .= ($where == "" && $nbrecats > 0) ? " WHERE " : " AND "; 
				$where2 = "";
				foreach ($tabcats as $tabcat) {
					$where2 .= ($where2 != "") ? " OR " : "";
					$where2 .= "".$prefix."_adherents_link_cat.id_cat='".$tabcat."'";
				}
				if ($where2 != "") {
					$where .= "($where2)";
					$having .= ($having == "") ? " HAVING " : " AND "; 
					$having .= "nbrefiche='".count($tabcats)."'";
				}
			}
			else {
				$tabcats = explode(";",$cat);
				$tabcats = array_map(array('utilFuncs_adherents', 'trimtodb'), $tabcats);
				$tabcats = array_unique($tabcats);
				$where .= ($where == "" && $nbrecats > 0) ? " WHERE " : " AND "; 
				$where2 = "";
				foreach ($tabcats as $tabcat) {
					$where2 .= ($where2 != "") ? " OR " : "";
					$where2 .= "".$prefix."_adherents_link_cat.id_cat='".$tabcat."'";
				}
				if ($where2 != "") {
					$where .= "($where2)";
				}
			}
		}
		if ($metacat != "") {
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= "".$prefix."_adherents.metacat='".$metacat."'";
		}
		$whereVillage = $where; //pour be pas tenir compte du choix du village !!
		if ($village != "") {
			$where .= ($where == "") ? " WHERE " : " AND ";
			$where .= "".$prefix."_adherents.commune='".$village."'";
		}
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "".$prefix."_adherents.valide='1'";
		$sql = "SELECT count(".$prefix."_adherents.id) as nbrefiche, ".$prefix."_adherents.id,`societe` , `responsable` , `adresse` , `tel` , `fax` , `mobile` , `email` , `web` , `commune` , `description_french` , `description_english` , `description_italian` , `description_german` , `description_spanish` , `tarifs_french` , `tarifs_english` , `tarifs_italian` , `tarifs_german` , `tarifs_spanish` , `periodeouverture_french` , `periodeouverture_italian` , `periodeouverture_english` , `periodeouverture_german` , `periodeouverture_spanish` , `services_french` , `services_italian` , `services_english` , `services_german` , `services_spanish` , `activites_french` , `activites_italian` , `activites_english` , `activites_german` , `activite_spanish` , `metacat` , `classe` , `unite` , `latitude` , `longitude` , `photo` , `dateimport`, `sansfiche` ";
	   	$sql .= " FROM ".$prefix."_adherents";
	   	$sql .= " INNER JOIN ".$prefix."_adherents_link_cat ON ".$prefix."_adherents.id=".$prefix."_adherents_link_cat.id_adh";
	   	$sql .= $where."";
	   	$sql .= " GROUP BY ".$prefix."_adherents.id";
	   	$sql .= $having;
		$sql .= " ORDER BY classe ASC, societe ASC";
	  	$result = $db->sql_query($sql);
		$centre["lat"]["min"] = "";
		$centre["lat"]["max"] = "";
		$centre["lon"]["min"] = "";
		$centre["lon"]["max"] = "";
		if ($db->sql_numrows($result) > 0) {
			$sortie .= '
		<symboles>';	
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					if ($ligne["latitude"] < $centre["lat"]["min"] || $centre["lat"]["min"] == "") {
						$centre["lat"]["min"] = $ligne["latitude"];
					}
					if ($ligne["latitude"] > $centre["lat"]["max"] || $centre["lat"]["max"] == "") {
						$centre["lat"]["max"] = $ligne["latitude"];
					}
					if ($ligne["longitude"] < $centre["lon"]["min"] || $centre["lon"]["min"] == "") {
						$centre["lon"]["min"] = $ligne["longitude"];
					}
					if ($ligne["longitude"] > $centre["lon"]["max"] || $centre["lon"]["max"] == "") {
						$centre["lon"]["max"] = $ligne["longitude"];
					}
					
					$photo_file = "";
					$classe = '';
		   			if (preg_match("#^toile#",$ligne["unite"]) && $ligne["classe"] > 0) {
		   				for ($i=0;$i<$ligne["classe"]; $i++) {
		   					$classe .= '<img src="themes/'.$Default_Theme.'/images/etoile.gif" width="12" height="12" alt="*">';
		   				}
		   			}
		  			if (preg_match("#^pi#",$ligne["unite"]) && $ligne["classe"] > 0) {
		   				for ($i=0;$i<$ligne["classe"]; $i++) {
		   					$classe .= '<img src="themes/'.$Default_Theme.'/images/epi.gif" width="12" height="12" alt="*">';
		   				}
		   			}
		   			if (preg_match("#^clef#",$ligne["unite"]) && $ligne["classe"] > 0) {
		   				for ($i=0;$i<$ligne["classe"]; $i++) {
		   					$classe .= '<img src="themes/'.$Default_Theme.'/images/clevacance.gif" width="12" height="12" alt="*">';
		   				}
		   			}
		   			if ($ligne["photo"] != "") {
		   				$lesphotos = explode(",",$ligne["photo"]);
		   				$laphoto = trim($lesphotos[0]);
		   				//$vignette = '<img src="modules/'.$module_name.'/resizer.php?imgfile=../../'.$laphoto.'&max_width=220&max_height=75" class="photo" />';
		   				$vignette = 'modules/'.$module_name.'/resizer.php?imgfile=../../'.$laphoto.'&max_width=220&max_height=75';
		   			}
		   			else {
			   			if (file_exists("themes/$Default_Theme/images/nopict.gif")) {
							$urlvignetteredim = "modules/".$module_name."/resizer.php?imgfile=../../themes/$Default_Theme/images/nopict.gif&max_width=220&max_height=75";
						}
						else {
							$urlvignetteredim = "modules/".$module_name."/resizer.php?imgfile=images/nopict.gif&max_width=220&max_height=75";
						}
		   				//$vignette = '<img src="'.$urlvignetteredim.'" class="photo" />';
		   				$vignette = $urlvignetteredim;
		   			}
					/*if ($ligne["periodeouverture_".$currentlang.""] != "") {
			   			$etatouverture = '<span class="ferme">Ferm</span>';
			   			if (preg_match("#([0-9]+)/([0-9]+)/([0-9]+)[ \-]+([0-9]+)/([0-9]+)/([0-9]+)#",$ligne["periodeouverture_".$currentlang.""],$tab_ouverture)) {
			   				$dateinf = str_pad($tab_ouverture[3], 4, "2010", STR_PAD_LEFT)."-".str_pad($tab_ouverture[2], 2, "0", STR_PAD_LEFT)."-".str_pad($tab_ouverture[1], 2, "0", STR_PAD_LEFT);
			   				$datesup = str_pad($tab_ouverture[6], 4, "2010", STR_PAD_LEFT)."-".str_pad($tab_ouverture[5], 2, "0", STR_PAD_LEFT)."-".str_pad($tab_ouverture[4], 2, "0", STR_PAD_LEFT);
			   				$datecourante = date("Y-m-d");
			   				if ($dateinf <= $datecourante && $datesup >= $datecourante) {
			   					$etatouverture = '<span class="ouvert">Ouvert</span>';
			   				}
			   				else {
			   					$etatouverture = '<span class="ferme">Ferm</span>';
			   				}
			   			}
		   			}
		   			else {
		   				$etatouverture = "";
		   			}*/
		   			$ligne["periodeouverture_".$currentlang.""] = strip_tags($ligne["periodeouverture_".$currentlang.""]);
		   			$ligne["periodeouverture_".$currentlang.""] = $texte = html_entity_decode($ligne["periodeouverture_".$currentlang.""],ENT_QUOTES,"ISO-8859-1");;
					if ($ligne["periodeouverture_".$currentlang.""] != "") {
			   			$etatouverture = '';
			   			if (preg_match("#([0-9]+)/([0-9]+)/([0-9]+)[ \-]+([0-9]+)/([0-9]+)/([0-9]+)#",$ligne["periodeouverture_".$currentlang.""],$tab_ouverture)) {
			   				$dateinf = str_pad($tab_ouverture[3], 4, "2010", STR_PAD_LEFT)."-".str_pad($tab_ouverture[2], 2, "0", STR_PAD_LEFT)."-".str_pad($tab_ouverture[1], 2, "0", STR_PAD_LEFT);
			   				$datesup = str_pad($tab_ouverture[6], 4, "2010", STR_PAD_LEFT)."-".str_pad($tab_ouverture[5], 2, "0", STR_PAD_LEFT)."-".str_pad($tab_ouverture[4], 2, "0", STR_PAD_LEFT);
			   				$datecourante = date("Y-m-d");
			   				if ($dateinf <= $datecourante && $datesup >= $datecourante) {
			   					$etatouverture = '<span class="ouvert">Ouvert</span>';
			   				}
			   				else {
			   					$etatouverture = '<span class="ferme">Ferm</span>';
			   				}
			   			}
			   			else {
			   				$etatouverture = '<span class="ouvert">Ouverture : '.$ligne["periodeouverture_".$currentlang.""].'</span>';
			   			}
		   			}
		   			else {
		   				$etatouverture = "";
		   			}
			  		if (substr($ligne["description_".$currentlang] , 0 ,1 ) != "<") {
						$ligne["description_".$currentlang] = $ligne["description_".$currentlang];
					}
					$description = truncate_string(strip_tags($ligne["description_".$currentlang],"100"));
					
					$telephone = "";
					$telephone .= ($telephone != "" && $ligne["tel"] != "") ? " - " : "";
					$telephone .= $ligne["tel"];
					$telephone .= ($telephone != "" && $ligne["mobile"] != "") ? " - " : "";
					$telephone .= $ligne["mobile"];
					if ($telephone != "") {
						$telephone = '<span class="tel">'._ADHS_SERVICES_TEL.$telephone.'</span>';
					}
					
					if ($ligne["sansfiche"] == '0') {
			   			$urlfiche = "mobiles.php?name=$module_name&op=showoneadh".$paramsurl."&id=".$ligne["id"];
					}
					else {
						$urlfiche = "";
					}
					$nomadh = $ligne["societe"].' <span class="classement">'.$classe.'</span>';
					
					$thepicto = "picto_vide.gif";
					switch ($ligne["metacat"]) {
						case "3":
							$thepicto = "picto_act_nature.gif";
							break;
						case "4":
							$thepicto = "picto_restos.gif";
							break;
						case "5":
							$thepicto = "picto_hebergement.gif";
							break;	
						case "6":
							$thepicto = "picto_ot.gif";
							break;
							
					}
					$thepicto = "modules/SimpleCarto/lib/pictos/office_tourisme/".$thepicto;
		   			
					$commentaire = "";
					//$commentaire .= $vignette ;
					//$commentaire .= $description ;
					$commentaire .= $telephone;
					$commentaire .= $etatouverture;
					
					$sortie .= '
			<symbole Id="'.$ligne["id"].'">
				<latitude_symb>'.$ligne["latitude"].'</latitude_symb>
				<longitude_symb>'.$ligne["longitude"].'</longitude_symb>
				<picto_symb>'.$utils->conditionnerXML($thepicto).'</picto_symb>
				<nom_symb><![CDATA['.$utils->conditionnerXML($nomadh).']]></nom_symb>
				<lien_symb>'.$urlfiche.'</lien_symb>
				<cible_symb></cible_symb>
				<commentaire_symb><![CDATA['.$photo_file.$utils->conditionnerXML($commentaire).']]></commentaire_symb>
				<photo_symb><![CDATA['.$photo_file.$utils->conditionnerXML($vignette).']]></photo_symb>
			</symbole>';
				}
			}
			$sortie .= '
		</symboles>';
		}
		$sortie .= '
		<latitudeinitadhs>'.(($centre["lat"]["max"]+$centre["lat"]["min"])/2).'</latitudeinitadhs>
		<longitudeinitadhs>'.(($centre["lon"]["max"]+$centre["lon"]["min"])/2).'</longitudeinitadhs>
		<latitudeminadhs>'.($centre["lat"]["min"]).'</latitudeminadhs>
		<latitudemaxadhs>'.($centre["lat"]["max"]).'</latitudemaxadhs>
		<longitudeminadhs>'.($centre["lon"]["min"]).'</longitudeminadhs>
		<longitudemaxadhs>'.($centre["lon"]["max"]).'</longitudemaxadhs>
		<pictoportable><![CDATA[themes/'.$Default_Theme.'/images/marker.png]]></pictoportable>';
		
		$metacats = array();
		$metacatstab = explode(";", _SIMPLEADHMETACATS);
		foreach($metacatstab as $onematcat) {
			$onematcattab = explode("@",$onematcat);
			$metacats[] = $onematcattab[1];
		}
		$sortie .= '
		<metacats>';
		foreach($metacats as $onematcat) {
			$tempcats = "";
			$sql = "SELECT DISTINCT ".$prefix."_adherents_cat.label_".$currentlang.", ".$prefix."_adherents_cat.id FROM ".$prefix."_adherents_cat";
			$sql .= " INNER JOIN ".$prefix."_adherents_link_cat ON ".$prefix."_adherents_link_cat.id_cat=".$prefix."_adherents_cat.id"; 
			$sql .= " INNER JOIN ".$prefix."_adherents ON ".$prefix."_adherents_link_cat.id_adh=".$prefix."_adherents.id";
			$sql .= " WHERE ".$prefix."_adherents.metacat='".$onematcat."' and ".$prefix."_adherents_cat.prive='0'"; 
			$sql .= " ORDER BY ".$prefix."_adherents_cat.label_".$currentlang." ASC";
//echo $sql;
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while (list($label, $idcat) = $db->sql_fetchrow($result)) {
					$tempcats .='
					<cat>
						<idcat>'.$idcat.'</idcat>
						<labelcat>'.$utils->conditionnerXML($label).'</labelcat>
					</cat>
					';
				}
			}
			$sortie .= '
			<metacat Id="'.$onematcat.'">
			'.$tempcats.'
			</metacat>
			';
		}
		$sortie .= '
		</metacats>';
		$sortie .= '
	</carte>';
		}
	}
	$sortie .= '
</cartes>';
	return str_replace("&","&amp;", $sortie);
}
?>