	//<![CDATA[
	
	//Decode points
	function decodeLine(encoded) {
		var len = encoded.length;
		var index = 0;
		var array = [];
		var lat = 0;
		var lng = 0;
		try
		{
			while (index < len) {
				var b;
				var shift = 0;
				var result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lat += dlat;
	
				shift = 0;
				result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lng += dlng;
	
				array.push(new google.maps.LatLng((lat * 1e-5), (lng * 1e-5)));
			}
		} catch(ex)
		{
			//error in encoding.
		}
		return array;
	}
	
	function theMapType(letype) {
		var type_carte = google.maps.MapTypeId.HYBRID;
		if (letype == "P") {
			type_carte = google.maps.MapTypeId.ROADMAP;
		}
		if (letype == "S") {
			type_carte = google.maps.MapTypeId.SATELLITE;
		}
		if (letype == "R") {
			type_carte = google.maps.MapTypeId.TERRAIN;
		}
		if (letype == "3D") {
			type_carte = google.maps.MapTypeId.TERRAIN;
		}
		return type_carte;
	}
	
	function is3D(letype) {
		return false;
		/*if (letype == G_SATELLITE_3D_MAP) {
			return true;
		}
		else {
			return false;
		}*/
	}
	
	function test3D(letype) {
		if (is3D(letype)) {
			type3D = true;
		}
		return type3D
	}
	
	function clearOverlays() {
		for (var i = 0; i < markers.length; i++) {
		   markers[i].setMap(null);
		}
		markers = [];
		for (var i = 0; i < polygones.length; i++) {
			polygones[i].setMap(null);
		}
		polygones = [];
	}
	
	function clearOverlaysFullscreen() {
		for (var i = 0; i < markersFullscreen.length; i++) {
		   markersFullscreen[i].setMap(null);
		}
		markersFullscreen = [];
		for (var i = 0; i < polygonesFullscreen.length; i++) {
			polygonesFullscreen[i].setMap(null);
		}
		polygonesFullscreen = [];
	}
	
	function convertMapTypeV2InV3(mapTypes) {
		var mapTypesV3 = [];
		for(var i = 0; i < mapTypes.length; i++) {
			var mapType = mapTypes[i];
			if(mapType == "G_NORMAL_MAP") {
				mapTypesV3.push(google.maps.MapTypeId.ROADMAP);
			} else if(mapType == "G_SATELLITE_MAP") {
				mapTypesV3.push(google.maps.MapTypeId.SATELLITE);
			} else if(mapType == "G_HYBRID_MAP") {
				mapTypesV3.push(google.maps.MapTypeId.HYBRID);
			} else if(mapType == "G_PHYSICAL_MAP") {
				mapTypesV3.push(google.maps.MapTypeId.TERRAIN);
			}
		}
		return mapTypesV3;
	}
	
	function GetMap(id,idadh) {
		if (window.JSON) {
			if (cartes == null) {
		 		cartes = GetXMLSymbols(id,idadh);
		 	}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");
			var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
			var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
			options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
			options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
			options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
			options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
			options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
			options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
			options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
			options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
			options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
			options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
			options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
			options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
			taille_hv = getXMLvalue(racine_carte,"option_taille");
			/*if (tailleforcee) {
				taille_hv = tailleforcee;
			}*/
			var sep_taille=new RegExp("[/]+", "g");
			var map_hv = String(taille_hv).split(sep_taille);
			options["map_h"] = String(map_hv[0]) + "px";
			options["map_v"] = String(map_hv[1]) + "px";
			options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
			options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
			
			leDiv = document.getElementById("map");
			if (leDiv == null) {
				return false;
			}
			/*var reg_taille=new RegExp("([0-9]+)([/]+)([0-9])+", "g");
			if (String(taille_hv).match(reg_taille)) {
				leDiv.style.width = options["map_h"];
				leDiv.style.height = options["map_v"];
			}
			*/
			var mapTypeIds = convertMapTypeV2InV3(options["btnstypes"]);
			var type_carte = theMapType(options["type_map"]);
			var centre = new google.maps.LatLng(latitudeinit, longitudeinit);
			var mapOptions = {
				center: centre,
		        zoom: zoominit,
		        mapTypeId: type_carte,
		        panControl: false,
    			zoomControl: false,
    			scaleControl: false,
    			streetViewControl: false,
			    mapTypeControlOptions: {
			    	mapTypeIds: mapTypeIds
			    }
		    };
			
			if (options["controles"]) {
				mapOptions.panControl = true;
				mapOptions.zoomControl = true;
				mapOptions.scaleControl = true;
			}
			
			if (options["centermap"].lat() != 0 || options["centermap"].lng() != 0) {
				mapOptions.center = options["centermap"];
			}
			else {
				mapOptions.center = new google.maps.LatLng(latitudeinit, longitudeinit);
			}
			
			//restriction des niveaux de zoom
			if ((! isNaN(options["zoom_min"] + options["zoom_max"]))) {
				if (options["zoom_min"] != "") {
					mapOptions.minZoom = options["zoom_min"];
				}
				
				if (options["zoom_max"] != "") {
					mapOptions.maxZoom = options["zoom_max"];
				}
			}
			
			map = new google.maps.Map(leDiv, mapOptions);
			map.setTilt(45);
			
			/*************************/
			function MiniMapControl(map) {
				var container = document.createElement("div");
				container.style.borderTop = "1px solid #fff";
				container.style.borderLeft = "1px solid #fff";
				container.style.overflow = "hidden";
				
				var containerDivMiniMap = document.createElement("div");
				container.appendChild(containerDivMiniMap);
				containerDivMiniMap.setAttribute('id','mini-map');
				containerDivMiniMap.style.width = "100px";
				containerDivMiniMap.style.height = "140px";
				
				var containerDivButtonShowMiniMap = document.createElement("div");
				container.appendChild(containerDivButtonShowMiniMap);
				containerDivButtonShowMiniMap.setAttribute('id','button-show-mini-map');
				containerDivButtonShowMiniMap.style.display = 'none';
				containerDivButtonShowMiniMap.style.cursor = "pointer";
				var image = document.createElement('img');
				image.src = racine_lib_module+"/icns/show_mini.gif";
				image.title = "Afficher mini-carte";
				image.width = "20";
				image.height = "20";
				containerDivButtonShowMiniMap.appendChild(image);
				
				google.maps.event.addDomListener(containerDivButtonShowMiniMap, "click", function() {
			   		var divMiniMap = document.getElementById('mini-map');
			   		var divButtonShowMiniMap = document.getElementById('button-show-mini-map');
			   		divMiniMap.style.display = "block";
			   		divButtonShowMiniMap.style.display = "none";
				});
				
				var miniMapOptions = {
					center: new google.maps.LatLng(43.27561738622256, 8.036131265624983),
			        zoom: 6,
			        maxZoom: 6,
			        minZoom: 6,
			        mapTypeId: map.getMapTypeId(),
			        draggable: false,
			        panControl: false,
	    			zoomControl: false,
	    			scaleControl: false,
	    			streetViewControl: false,
	    			mapTypeControl: false
			    };
				
				miniMap = new google.maps.Map(containerDivMiniMap, miniMapOptions);
				var rectangleOptions = {
					strokeColor: '#FFFFFF',
					strokeOpacity: 1.0,
					fillColor: '#FF0000',
					fillOpacity: 0,
					map: miniMap,
					strokeWeight: 2.0
				};
				rectangle = new google.maps.Rectangle(rectangleOptions);
				
				google.maps.event.addDomListener(map, "bounds_changed", function() {
					rectangle.setBounds(map.getBounds());
				});
				
				function CloseMiniMapControl(map) {
					var container = document.createElement("div");
					var containerDiv = document.createElement("div");
					container.appendChild(containerDiv);
					containerDiv.style.cursor = "pointer";
					var image = document.createElement('img');
					image.src = racine_lib_module+"/icns/miniclose.gif";
					image.title = "Fermer mini-carte";
					image.width = "12";
					image.height = "12";
					containerDiv.appendChild(image);
					
					google.maps.event.addDomListener(containerDiv, "click", function() {
				   		var divMiniMap = document.getElementById('mini-map');
				   		var divButtonShowMiniMap = document.getElementById('button-show-mini-map');
				   		divMiniMap.style.display = "none";
				   		divButtonShowMiniMap.style.display = "block";
					});
					return container;
				}
				
				var CloseMiniMapControlDiv = new CloseMiniMapControl(miniMap);
				CloseMiniMapControlDiv.index = 2;
				miniMap.controls[google.maps.ControlPosition.LEFT_TOP].push(CloseMiniMapControlDiv);
				
				return container;
			}
			
			if (options["mini_vue"]) {
				var MiniMapControlDiv = new MiniMapControl(map);
				MiniMapControlDiv.index = 2;
				map.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(MiniMapControlDiv);
			}
			
			/*************************/
			/** Bouton plein écran **/
						
			function PleinEcranControl(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginBottom = "10px";
				container.style.marginRight = "10px";
				container.style.border = "0.8px solid #b1b1b1";
				container.style.borderRadius = "2.5px";
				container.style.boxShadow = "-0px 1px 2px #666";
				container.style.backgroundColor = "#fff";
				
				var containerDiv = document.createElement("div");
				containerDiv.setAttribute('id','btn-plein-ecran');
				containerDiv.style.cursor = "pointer";
				containerDiv.style.display = "block";
				container.appendChild(containerDiv);
				
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/fullscreen.png";
				image.title = "Mettre la carte en plein écran";
				containerDiv.appendChild(image);
				
				google.maps.event.addDomListener(containerDiv, "click", function() {
					var divMapFullscreen = document.createElement('div');
					divMapFullscreen.setAttribute('id','map-fullscreen');
					divMapFullscreen.style.position = 'absolute';
					divMapFullscreen.style.top = '0';
					divMapFullscreen.style.left = '0';
					divMapFullscreen.style.zIndex = '999999';
					document.body.appendChild(divMapFullscreen);
					
					if(window.innerWidth !== undefined && window.innerHeight !== undefined) {
		                 var w = window.innerWidth;
		                 var h = window.innerHeight;
		             } else {
		                 var w = document.documentElement.clientWidth;
		                 var h = document.documentElement.clientHeight;
		            }
					
					divMapFullscreen.style.width = w + "px";
					divMapFullscreen.style.height = h + "px";
					
					positionScrollPage.y = window.pageYOffset;
					positionScrollPage.x = window.pageXOffset;
					window.scrollTo(0, 0);
					document.body.style.overflowX = 'hidden';
					document.body.style.overflowY = 'hidden';
					
					var position = map.getCenter();
					options["zoominit"] = map.getZoom();
					options["latitudeinit"] = position.lat();
					options["longitudeinit"] = position.lng();
					
					GetMapFullscreen(id, idadh);
					
					window.onresize = function() {
						if(window.innerWidth !== undefined && window.innerHeight !== undefined) {
			                 var w = window.innerWidth;
			                 var h = window.innerHeight;
			             } else {
			                 var w = document.documentElement.clientWidth;
			                 var h = document.documentElement.clientHeight;
			            }
						
						divMapFullscreen.style.width = w + "px";
						divMapFullscreen.style.height = h + "px";
					};
					
					window.onscroll = function() {
						window.scrollTo(0, 0);
					};
				});
				
				return container;
			}
			
			if( options["fullscreen"] ) {
				var PleinEcranControlDiv = new PleinEcranControl(map);
				PleinEcranControlDiv.index = 1;
				map.controls[google.maps.ControlPosition.RIGHT_TOP].push(PleinEcranControlDiv);
			}
			
			/*************************/
	
			//ajout de pictos
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var echelle = map.getZoom();
				
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				
				largeur = (options["width_picto"] && options["width_picto"] != "") ? options["width_picto"] : taille;
				hauteur = (options["height_picto"] && options["height_picto"] != "") ? options["height_picto"] : taille;
				
				var anchor_picto;
				switch(options["anchor_picto"]) {
					case "top":
						anchor_picto = new google.maps.Point(largeur/2, hauteur);
						break;
					case "top_left":
						anchor_picto = new google.maps.Point(largeur, hauteur);
						break;
					case "top_right":
						anchor_picto = new google.maps.Point(0, hauteur);
						break;
					case "bottom":
						anchor_picto = new google.maps.Point(largeur/2, 0);
						break;
					case "bottom_left":
						anchor_picto = new google.maps.Point(largeur, 0);
						break;
					case "bottom_right":
						anchor_picto = new google.maps.Point(0, 0);
						break;
					case "left":
						anchor_picto = new google.maps.Point(largeur, hauteur/2);
						break;
					case "right":
						anchor_picto = new google.maps.Point(0, hauteur/2);
						break;
					case "center":
					default:
						anchor_picto = new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2));
						break;
				}
				
				var icone = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(largeur, hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: anchor_picto
				};
				
				var marker = new google.maps.Marker({
				 	position: point,
				 	icon: icone
				});
								
				if (options["bulle"] != "") {
					//var saut =new RegExp(String.fromCharCode(13), "g");
					var saut =new RegExp("(\n|\r)", "g");
					commentaire = commentaire.replace(saut,"<br />");
					
					var cont_mess = "";
					if (fiche != "") {
						if (message != "") {
							var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
						}
					}
					else {
						if (message != "") {
							var link_mess = "";
						}
					}
					cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
					
					if (options["bulle"] == "C") {
						cont_mess = '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>';
					} else if (options["bulle"] == "TC") {

					}
					
					var infowindow = new google.maps.InfoWindow({
					      content: cont_mess,
					      maxWidth: 230
					});
					
					google.maps.event.addListener(marker, 'click', function() {
					    infowindow.open(map, marker);
					    
					    if (options["bulle"] == "C") {
					    	var dMapDiv = document.getElementById("detailmap");
							
							var detailMapOptions = {
								center: point,
						        zoom: map.getZoom()+2,
						        mapTypeId: map.getMapTypeId(),
						        panControl: false,
				    			zoomControl: true,
				    			scaleControl: true,
				    			streetViewControl: false
						    };
							
							var detailmap = new google.maps.Map(dMapDiv, detailMapOptions);
							
							new google.maps.Marker({
							      position: point,
							      map: detailmap,
							      icon: icone
							});
					    }
					});
				}
				return marker;
			}
			
			//ajout de textes 
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {		
				if (test3D(map.getMapTypeId())) {
					return null;
				}
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				
				var image = {
				    url: racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte,
				    scaledSize: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
					
				var marker = new google.maps.Marker({
				      position: point,
				      title: message,
				      icon: image
				});
					
				if (fiche == "") {
					marker.setClickable(false);
					marker.setDraggable(false);
				}
				else {	
					google.maps.event.addListener(marker, 'click', function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			//affiche les textes
			function afficheTextes() {
				var textes = getXMLchild(racine_carte,"textes");
				if (textes != null) {
					var texte_courant = getXMLchild(textes,"texte");
					while (texte_courant) {
						var point2 = new google.maps.LatLng(eval(getXMLvalue(texte_courant,"latitude_texte")), eval(getXMLvalue(texte_courant,"longitude_texte")));
						var fiche = getXMLvalue(texte_courant,"lien_texte");
						var target = getXMLvalue(texte_courant,"cible_texte");
						var message = getXMLvalue(texte_courant,"lieu_texte");
						var commentaire = getXMLvalue(texte_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(texte_courant,"dim_texte");
						var angletxt = getXMLvalue(texte_courant,"angle_texte");
						var couleurtxt = getXMLvalue(texte_courant,"couleur_texte");
						var typotxt = getXMLvalue(texte_courant,"police_texte");
						var tailletxt = getXMLvalue(texte_courant,"taille_texte");
						var tempMark = createTextMarker(point2,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							markers.push(tempMark);
							tempMark.setMap(map);
						}
						texte_courant = next_sibling(texte_courant);
					}
				}
			}
			
			//affiche les pictos
			function afficheLieux() {
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point2 = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point2,message,commentaire,chemicone,fiche,target);
						if (tempMark != null) {
							markers.push(tempMark);
							tempMark.setMap(map);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
				function afficherCBordure() {
					return true;
					/*var bordure = new GPolyline.fromEncoded({
						color: getXMLvalue(racine_carte,"points_couleur"),
						weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
						opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
						points: getXMLvalue(racine_carte,"points_bordure"),
						levels: getXMLvalue(racine_carte,"points_visibilite"),
						numLevels: 3,
						zoomFactor: 12
					});
				map.addOverlay(bordure);*/
			}
			
			//cr�er polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				var polygone;
				if (plein == "1") {
					polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: 1,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: opacite,
					    zIndex: 0
					  });
				}
				else {
					polygone = new google.maps.Polyline({
					    path: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: opacite,
					    strokeWeight: epaisseur
					 });
				}
				if (fiche != "" && plein == "1") {
					google.maps.event.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return polygone;
			}
			//afficher polygones
			function afficherPolygones() {
				var polygone = getXMLchild(racine_carte,"polygones");
				if (polygone != null) {
					var polygone_courant = getXMLchild(polygone,"polygone");
					while (polygone_courant) {
						var couleur = getXMLvalue(polygone_courant,"couleur");
						var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
						var points = getXMLvalue(polygone_courant,"polyencode");
						var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
						var fiche = getXMLvalue(polygone_courant,"lien_polygone");
						var target = getXMLvalue(polygone_courant,"cible_polygone");
						var plein = getXMLvalue(polygone_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							tempZone.setMap(map);
							polygones.push(tempZone);
						}
						polygone_courant = next_sibling(polygone_courant);
					}
				}
			}
			//ajout de pictos
			function createMarkerSymb(point, chemicone) {
				var image = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(26, 26),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(13, 13)
				};
					
				var marker = new google.maps.Marker({
				      position: point,
				      icon: image
				});

				return marker;
			}
			
			//afficher les symboles
			function afficherSymboles() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"symboles");
				if (points != null) {
					var point_courant = getXMLchild(points,"symbole");
					while (point_courant) {
						var lat = getXMLvalue(point_courant,"latitude_symb");
						var lon = getXMLvalue(point_courant,"longitude_symb");
						if (lat != "" && lon!= "" && eval(lat) <= 360 && eval(lon) < 90) {
							var point2 = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
							var chemicone = getXMLvalue(point_courant,"picto_symb");
							var tempMark = createMarkerSymb(point2,chemicone);
							if (tempMark != null) {
								tempMark.setMap(map);
								polygones.push(tempMark);
							}
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			google.maps.event.addListener(map, "click", function(event) {
				map.panTo(event.latLng);
			});
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficherSymboles();
			
			if (options["titre"]) {
				titrer(id,'titre')
			}
			if (options ["obs"]) {
				listLieux(id,'obs');
			}
			if (options["commentaire"]) {
				commenter(id,'commentaire');
			}
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre � jour.");
		}
	}
	
	function GetMapFullscreen(id,idadh) {
		if (window.JSON) {
			if (cartes == null) {
		 		cartes = GetXMLSymbols(id,idadh);
		 	}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");
			var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
			var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
			options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
			options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
			options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
			options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
			options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
			options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
			options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
			options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
			options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
			options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
			options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
			options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
			taille_hv = getXMLvalue(racine_carte,"option_taille");
			/*if (tailleforcee) {
				taille_hv = tailleforcee;
			}*/
			var sep_taille=new RegExp("[/]+", "g");
			var map_hv = String(taille_hv).split(sep_taille);
			options["map_h"] = String(map_hv[0]) + "px";
			options["map_v"] = String(map_hv[1]) + "px";
			options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
			options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
			
			leDiv = document.getElementById("map-fullscreen");
			if (leDiv == null) {
				return false;
			}
			/*var reg_taille=new RegExp("([0-9]+)([/]+)([0-9])+", "g");
			if (String(taille_hv).match(reg_taille)) {
				leDiv.style.width = options["map_h"];
				leDiv.style.height = options["map_v"];
			}
			*/
			var mapTypeIds = convertMapTypeV2InV3(options["btnstypes"]);
			var type_carte = theMapType(options["type_map"]);
			var centre = new google.maps.LatLng(latitudeinit, longitudeinit);
			var mapOptions = {
				center: centre,
		        zoom: zoominit,
		        mapTypeId: type_carte,
		        panControl: false,
    			zoomControl: false,
    			scaleControl: false,
    			streetViewControl: false,
			    mapTypeControlOptions: {
			    	mapTypeIds: mapTypeIds
			    }
		    };
			
			if (options["controles"]) {
				mapOptions.panControl = true;
				mapOptions.zoomControl = true;
				mapOptions.scaleControl = true;
			}
			
			if (options["centermap"].lat() != 0 || options["centermap"].lng() != 0) {
				mapOptions.center = options["centermap"];
			}
			else {
				mapOptions.center = new google.maps.LatLng(latitudeinit, longitudeinit);
			}
			
			//restriction des niveaux de zoom
			if ((! isNaN(options["zoom_min"] + options["zoom_max"]))) {
				if (options["zoom_min"] != "") {
					mapOptions.minZoom = options["zoom_min"];
				}
				
				if (options["zoom_max"] != "") {
					mapOptions.maxZoom = options["zoom_max"];
				}
			}
			
			mapFullscreen = new google.maps.Map(leDiv, mapOptions);
			mapFullscreen.setTilt(45);
			
			/*************************/
			function MiniMapControl(map) {
				var container = document.createElement("div");
				container.style.borderTop = "1px solid #fff";
				container.style.borderLeft = "1px solid #fff";
				container.style.overflow = "hidden";
				
				var containerDivMiniMap = document.createElement("div");
				container.appendChild(containerDivMiniMap);
				containerDivMiniMap.setAttribute('id','mini-map-fullscreen');
				containerDivMiniMap.style.width = "100px";
				containerDivMiniMap.style.height = "140px";
				
				var containerDivButtonShowMiniMap = document.createElement("div");
				container.appendChild(containerDivButtonShowMiniMap);
				containerDivButtonShowMiniMap.setAttribute('id','button-show-mini-map-fullscreen');
				containerDivButtonShowMiniMap.style.display = 'none';
				containerDivButtonShowMiniMap.style.cursor = "pointer";
				var image = document.createElement('img');
				image.src = racine_lib_module+"/icns/show_mini.gif";
				image.title = "Afficher mini-carte";
				image.width = "20";
				image.height = "20";
				containerDivButtonShowMiniMap.appendChild(image);
				
				google.maps.event.addDomListener(containerDivButtonShowMiniMap, "click", function() {
			   		var divMiniMap = document.getElementById('mini-map-fullscreen');
			   		var divButtonShowMiniMap = document.getElementById('button-show-mini-map-fullscreen');
			   		divMiniMap.style.display = "block";
			   		divButtonShowMiniMap.style.display = "none";
				});
				
				var miniMapOptions = {
					center: new google.maps.LatLng(43.27561738622256, 8.036131265624983),
			        zoom: 6,
			        maxZoom: 6,
			        minZoom: 6,
			        mapTypeId: map.getMapTypeId(),
			        draggable: false,
			        panControl: false,
	    			zoomControl: false,
	    			scaleControl: false,
	    			streetViewControl: false,
	    			mapTypeControl: false
			    };
				
				miniMapFullscreen = new google.maps.Map(containerDivMiniMap, miniMapOptions);
				var rectangleOptions = {
					strokeColor: '#FFFFFF',
					strokeOpacity: 1.0,
					fillColor: '#FF0000',
					fillOpacity: 0,
					map: miniMapFullscreen,
					strokeWeight: 2.0
				};
				rectangle = new google.maps.Rectangle(rectangleOptions);
				
				google.maps.event.addDomListener(map, "bounds_changed", function() {
					rectangle.setBounds(map.getBounds());
				});
				
				function CloseMiniMapControl(map) {
					var container = document.createElement("div");
					var containerDiv = document.createElement("div");
					container.appendChild(containerDiv);
					containerDiv.style.cursor = "pointer";
					var image = document.createElement('img');
					image.src = racine_lib_module+"/icns/miniclose.gif";
					image.title = "Fermer mini-carte";
					image.width = "12";
					image.height = "12";
					containerDiv.appendChild(image);
					
					google.maps.event.addDomListener(containerDiv, "click", function() {
				   		var divMiniMap = document.getElementById('mini-map-fullscreen');
				   		var divButtonShowMiniMap = document.getElementById('button-show-mini-map-fullscreen');
				   		divMiniMap.style.display = "none";
				   		divButtonShowMiniMap.style.display = "block";
					});
					return container;
				}
				
				var CloseMiniMapControlDiv = new CloseMiniMapControl(miniMapFullscreen);
				CloseMiniMapControlDiv.index = 2;
				miniMapFullscreen.controls[google.maps.ControlPosition.LEFT_TOP].push(CloseMiniMapControlDiv);
				
				return container;
			}
			
			if (options["mini_vue"]) {
				var MiniMapControlDiv = new MiniMapControl(mapFullscreen);
				MiniMapControlDiv.index = 2;
				mapFullscreen.controls[google.maps.ControlPosition.RIGHT_BOTTOM].push(MiniMapControlDiv);
			}
			
			/*************************/
			/** Bouton plein écran **/
			
			function PleinEcranControl(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginBottom = "10px";
				container.style.marginRight = "10px";
				container.style.border = "0.8px solid #b1b1b1";
				container.style.borderRadius = "2.5px";
				container.style.boxShadow = "-0px 1px 2px #666";
				container.style.backgroundColor = "#fff";
				
				var containeDiv = document.createElement("div");
				containeDiv.setAttribute('id','btn-petit-ecran');
				containeDiv.style.cursor = "pointer";
				container.appendChild(containeDiv);
				
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/putscreen.png";
				image.title = "Mettre la carte en petit";
				containeDiv.appendChild(image);
				
				google.maps.event.addDomListener(containeDiv, "click", function() {
					var mapFullscreenDiv = document.getElementById('map-fullscreen');
					document.body.removeChild(mapFullscreenDiv);
					
					document.body.style.overflowX = 'auto';
					document.body.style.overflowY = 'auto';
					
					window.onscroll = function() {};
					window.onresize = function() {};
					
					window.scrollTo(positionScrollPage.x, positionScrollPage.y);
				});
				
				return container;
			}
			
			var PleinEcranControlDiv = new PleinEcranControl(mapFullscreen);
			PleinEcranControlDiv.index = 1;
			mapFullscreen.controls[google.maps.ControlPosition.RIGHT_TOP].push(PleinEcranControlDiv);
			
			if( options["zoominit"] ) {
				mapFullscreen.setZoom(options["zoominit"]);
			}
			if( options["latitudeinit"] && options["longitudeinit"] ) {
				var center = new google.maps.LatLng(options["latitudeinit"], options["longitudeinit"]);
				mapFullscreen.setCenter(center);
			}
			
			/*************************/
	
			//ajout de pictos
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var echelle = mapFullscreen.getZoom();
				
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				
				largeur = (options["width_picto"] && options["width_picto"] != "") ? options["width_picto"] : taille;
				hauteur = (options["height_picto"] && options["height_picto"] != "") ? options["height_picto"] : taille;
				
				var anchor_picto;
				switch(options["anchor_picto"]) {
					case "top":
						anchor_picto = new google.maps.Point(largeur/2, hauteur);
						break;
					case "top_left":
						anchor_picto = new google.maps.Point(largeur, hauteur);
						break;
					case "top_right":
						anchor_picto = new google.maps.Point(0, hauteur);
						break;
					case "bottom":
						anchor_picto = new google.maps.Point(largeur/2, 0);
						break;
					case "bottom_left":
						anchor_picto = new google.maps.Point(largeur, 0);
						break;
					case "bottom_right":
						anchor_picto = new google.maps.Point(0, 0);
						break;
					case "left":
						anchor_picto = new google.maps.Point(largeur, hauteur/2);
						break;
					case "right":
						anchor_picto = new google.maps.Point(0, hauteur/2);
						break;
					case "center":
					default:
						anchor_picto = new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2));
						break;
				}
				
				var icone = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(largeur, hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: anchor_picto
				};
				
				var marker = new google.maps.Marker({
				 	position: point,
				 	icon: icone
				});
								
				if (options["bulle"] != "") {
					//var saut =new RegExp(String.fromCharCode(13), "g");
					var saut =new RegExp("(\n|\r)", "g");
					commentaire = commentaire.replace(saut,"<br />");
					
					var cont_mess = "";
					if (fiche != "") {
						if (message != "") {
							var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
						}
					}
					else {
						if (message != "") {
							var link_mess = "";
						}
					}
					cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
					
					if (options["bulle"] == "C") {
						cont_mess = '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>';
					} else if (options["bulle"] == "TC") {

					}
					
					var infowindow = new google.maps.InfoWindow({
					      content: cont_mess,
					      maxWidth: 230
					});
					
					google.maps.event.addListener(marker, 'click', function() {
					    infowindow.open(mapFullscreen, marker);
					    
					    if (options["bulle"] == "C") {
					    	var dMapDiv = document.getElementById("detailmap");
							
							var detailMapOptions = {
								center: point,
						        zoom: mapFullscreen.getZoom()+2,
						        mapTypeId: mapFullscreen.getMapTypeId(),
						        panControl: false,
				    			zoomControl: true,
				    			scaleControl: true,
				    			streetViewControl: false
						    };
							
							var detailmap = new google.maps.Map(dMapDiv, detailMapOptions);
							
							new google.maps.Marker({
							      position: point,
							      map: detailmap,
							      icon: icone
							});
					    }
					});
				}
				return marker;
			}
			
			//ajout de textes 
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {		
				if (test3D(mapFullscreen.getMapTypeId())) {
					return null;
				}
				var echelle = mapFullscreen.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (mapFullscreen.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				
				var image = {
				    url: racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte,
				    scaledSize: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
					
				var marker = new google.maps.Marker({
				      position: point,
				      title: message,
				      icon: image
				});
					
				if (fiche == "") {
					marker.setClickable(false);
					marker.setDraggable(false);
				}
				else {	
					google.maps.event.addListener(marker, 'click', function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			//affiche les textes
			function afficheTextes() {
				var textes = getXMLchild(racine_carte,"textes");
				if (textes != null) {
					var texte_courant = getXMLchild(textes,"texte");
					while (texte_courant) {
						var point2 = new google.maps.LatLng(eval(getXMLvalue(texte_courant,"latitude_texte")), eval(getXMLvalue(texte_courant,"longitude_texte")));
						var fiche = getXMLvalue(texte_courant,"lien_texte");
						var target = getXMLvalue(texte_courant,"cible_texte");
						var message = getXMLvalue(texte_courant,"lieu_texte");
						var commentaire = getXMLvalue(texte_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(texte_courant,"dim_texte");
						var angletxt = getXMLvalue(texte_courant,"angle_texte");
						var couleurtxt = getXMLvalue(texte_courant,"couleur_texte");
						var typotxt = getXMLvalue(texte_courant,"police_texte");
						var tailletxt = getXMLvalue(texte_courant,"taille_texte");
						var tempMark = createTextMarker(point2,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							tempMark.setMap(mapFullscreen);
							markersFullscreen.push(tempMark);
						}
						texte_courant = next_sibling(texte_courant);
					}
				}
			}
			
			//affiche les pictos
			function afficheLieux() {
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point2 = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point2,message,commentaire,chemicone,fiche,target);
						if (tempMark != null) {
							tempMark.setMap(mapFullscreen);
							markersFullscreen.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
				function afficherCBordure() {
					return true;
					/*var bordure = new GPolyline.fromEncoded({
						color: getXMLvalue(racine_carte,"points_couleur"),
						weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
						opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
						points: getXMLvalue(racine_carte,"points_bordure"),
						levels: getXMLvalue(racine_carte,"points_visibilite"),
						numLevels: 3,
						zoomFactor: 12
					});
				map.addOverlay(bordure);*/
			}
			
			//cr�er polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				var polygone;
				if (plein == "1") {
					polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: 1,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: opacite,
					    zIndex: 0
					  });
				}
				else {
					polygone = new google.maps.Polyline({
					    path: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: opacite,
					    strokeWeight: epaisseur
					 });
				}
				if (fiche != "" && plein == "1") {
					google.maps.event.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return polygone;
			}
			//afficher polygones
			function afficherPolygones() {
				var polygone = getXMLchild(racine_carte,"polygones");
				if (polygone != null) {
					var polygone_courant = getXMLchild(polygone,"polygone");
					while (polygone_courant) {
						var couleur = getXMLvalue(polygone_courant,"couleur");
						var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
						var points = getXMLvalue(polygone_courant,"polyencode");
						var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
						var fiche = getXMLvalue(polygone_courant,"lien_polygone");
						var target = getXMLvalue(polygone_courant,"cible_polygone");
						var plein = getXMLvalue(polygone_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							tempZone.setMap(mapFullscreen);
							polygonesFullscreen.push(tempZone);
						}
						polygone_courant = next_sibling(polygone_courant);
					}
				}
			}
			//ajout de pictos
			function createMarkerSymb(point, chemicone) {
				var image = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(26, 26),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(13, 13)
				};
					
				var marker = new google.maps.Marker({
				      position: point,
				      icon: image
				});

				return marker;
			}
			
			//afficher les symboles
			function afficherSymboles() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"symboles");
				if (points != null) {
					var point_courant = getXMLchild(points,"symbole");
					while (point_courant) {
						var lat = getXMLvalue(point_courant,"latitude_symb");
						var lon = getXMLvalue(point_courant,"longitude_symb");
						if (lat != "" && lon!= "" && eval(lat) <= 360 && eval(lon) < 90) {
							var point2 = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
							var chemicone = getXMLvalue(point_courant,"picto_symb");
							var tempMark = createMarkerSymb(point2,chemicone);
							if (tempMark != null) {
								tempMark.setMap(mapFullscreen);
								polygonesFullscreen.push(tempMark);
							}
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			google.maps.event.addListener(map, "click", function(event) {
				map.panTo(event.latLng);
			});
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficherSymboles();
			
			if (options["titre"]) {
				titrer(id,'titre')
			}
			if (options ["obs"]) {
				listLieux(id,'obs');
			}
			if (options["commentaire"]) {
				commenter(id,'commentaire');
			}
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre � jour.");
		}
	}
	
	function listLieux(id,zone_id) {
		if (options["obs"]) {
			if (cartes == null) {
				cartes = GetXMLSymbols(id);
			}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");	
			var points = getXMLchild(racine_carte,"points");
			if (points != null) {
				var point_courant = getXMLchild(points,"point");
				var observations = "";
				observations += "<table border=\"0\" cellpadding=\"0\" celspacing=\"0\" class=\"observations\">";
				observations += "<tr><th colspan=\"4\">D&eacute;tails</th></tr>";
				while (point_courant) {
					var point2 = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
					var message = getXMLvalue(point_courant,"lieu");
					var chemicone = getXMLvalue(point_courant,"picto");
					var commentaire = getXMLvalue(point_courant,"commentaire_point");
					var fiche = getXMLvalue(point_courant,"lien");
					var target = getXMLvalue(point_courant,"cible");
					
					observations += "<tr>";
					observations += "<td>";
					observations += "<img src=\""+chemicone+"\" />";
					observations += "</td><td>";
					observations += message;
					observations += "</td><td>";
					observations += commentaire;
					observations += "</td><td>";
					if (fiche != "") {
						observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
					}
					observations += "</td>";
					observations += "<tr>";
					
					point_courant = next_sibling(point_courant);
				}
			}
			var polygones = getXMLchild(racine_carte,"polygones");
			if (polygones != null) {
				var polygone_courant = getXMLchild(polygones,"polygone");
				while (polygone_courant) {
					var nom =  getXMLvalue(polygone_courant,"nom");
					var details =  getXMLvalue(polygone_courant,"details");
					var couleur = getXMLvalue(polygone_courant,"couleur");
					var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
					var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
					var points = getXMLvalue(polygone_courant,"polyencode");
					var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
					var plein = getXMLvalue(polygone_courant,"plein");
					var fiche = getXMLvalue(polygone_courant,"lien_polygone");
					var target = getXMLvalue(polygone_courant,"cible_polygone");
					
					observations += "<tr>";
						observations += "<td>";
						observations += "<div style=\"display: block; line-height: 1px; width: 30px; height: "+epaisseur+"; background-color: "+couleur+"; filter: alpha(opacity="+eval(opacite*100)+"); -moz-opacity: "+opacite+"; opacity: "+opacite+" \"></div>";
						observations += "</td><td>";
						observations += nom;
						observations += "</td><td>";
						observations += details;
						observations += "</td><td>";
						if (fiche != "") {
							observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
						}
						observations += "</td>";
						observations += "<tr>";
					polygone_courant = next_sibling(polygone_courant);
				}
			}
			observations += "</table>";
			
	  		var ie = false;
			if (document.all) {
				ie = true;
			}
			if (ie) {
				 var leDiv = document.all[zone_id];
			}
			else {
				var leDiv =  document.getElementById(zone_id);
			}
			if (leDiv == null) {
				return false;
			}
			leDiv.innerHTML = observations;
		}
	}
	
	function titrer(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var titre = getXMLvalue(racine_carte,"titre");
		
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = titre;
		document.title = document.title + " - " + titre;
	}
	
	function commenter(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var commentaire = getXMLvalue(racine_carte,"page_carte");
		if (commentaire == "") {
			commentaire = getXMLvalue(racine_carte,"commentaire");
		}
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = commentaire;
	}
	
	function GetXMLSymbols(id,idadh) {
		var sortie = "";
		var params = "";
		if (id != "") {
			params += "&Idc="+id;
		}
		if (idadh != "") {
			params += "&id="+idadh;
		}
		var sources_cartes = "modules.php?name=SimpleAdherents&op=map_adh_XML"+params;
		var cartes = GetAJAXData(sources_cartes);
		return cartes;
	}
	
	function calculeX(r){
	  return calculeOffset(r,"offsetLeft");
	}
	
	function calculeH(r){
	  return r["offsetHeight"];
	}
	
	function calculeL(r){
	  return r["offsetWidth"];
	}
	
	function calculeY(r){
	  return calculeOffset(r,"offsetTop")
	}
	function calculeOffset(element,attr){
	  var offset=0;
	  while(element){
	    offset+=element[attr];
	    element=element.offsetParent;
	  }
	  return offset;
	}
	
	var map = null;
	var miniMap = null;
	var markers = [];
	var polygones = [];
	
	var mapFullscreen = null;
	var miniMapFullscreen = null;
	var markersFullscreen = [];
	var polygonesFullscreen = [];
	
	var rectangle = null;
	//var minimap = null;
	var cartes = null;
	var latitudeinit = 0;
	var longitudeinit = 0;
	var type3D = false;
	var positionScrollPage = {x: 0, y: 0};
	//]]>