	//<![CDATA[
	
	//Decode points
	function decodeLine(encoded) {
		var len = encoded.length;
		var index = 0;
		var array = [];
		var lat = 0;
		var lng = 0;
		try
		{
			while (index < len) {
				var b;
				var shift = 0;
				var result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lat += dlat;
	
				shift = 0;
				result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lng += dlng;
	
				array.push(new google.maps.LatLng((lat * 1e-5), (lng * 1e-5)));
			}
		} catch(ex)
		{
			alert("error in encoding");
		}
		return array;
	}
	
	function theMapType(letype) {
		var type_carte = google.maps.MapTypeId.HYBRID;
		if (letype == "P") {
			type_carte = google.maps.MapTypeId.ROADMAP;
		}
		if (letype == "S") {
			type_carte = google.maps.MapTypeId.SATELLITE;
		}
		if (letype == "R") {
			type_carte = google.maps.MapTypeId.TERRAIN;
		}
		if (letype == "3D") {
			//type_carte = G_SATELLITE_3D_MAP;
			type_carte = google.maps.MapTypeId.TERRAIN;
		}
		return type_carte;
	}
	
	function is3D(letype) {
		return false;
		/*if (letype == G_SATELLITE_3D_MAP) {
			return true;
		}
		else {
			return false;
		}*/
	}
	
	function test3D(letype) {
		if (is3D(letype)) {
			type3D = true;
		}
		return type3D
	}
	
	function clearOverlays() {
		for (var i = 0; i < markers.length; i++) {
		   markers[i].setMap(null);
		}
		markers = [];
	}
	
	function GetMap(id,idmetacat,idcat,village) {
		var latitudeinitauto = 0;
		var longitudeinitauto = 0;
		if (window.JSON) {
			if (cartes == null) {
		 		cartes = GetXMLSymbols(id, idmetacat, idcat,village);
		 	}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");
			var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
			var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
			options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
			options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
			options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
			options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
			options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
			options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
			options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
			options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
			options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
			options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
			options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
			options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
			taille_hv = getXMLvalue(racine_carte,"option_taille");
			/*if (tailleforcee) {
				taille_hv = tailleforcee;
			}*/
			var sep_taille=new RegExp("[/]+", "g");
			var map_hv = String(taille_hv).split(sep_taille);
			options["map_h"] = String(map_hv[0]) + "px";
			options["map_v"] = String(map_hv[1]) + "px";
			options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
			options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
			if (eval(getXMLvalue(racine_carte,"latitudeinitadhs")) != 0 && eval(getXMLvalue(racine_carte,"longitudeinitadhs")) != 0) {
				latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinitadhs"));
				longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinitadhs"));
			}
			leDiv = document.getElementById("map");
			if (leDiv == null) {
				return false;
			}
			
			//map = new GMap2(leDiv,{mapTypes: [G_NORMAL_MAP,G_HYBRID_MAP]});
			var mapOptions = {
				center: new google.maps.LatLng(latitudeinit, longitudeinit),
		        zoom: zoominit,
		        mapTypeId: google.maps.MapTypeId.ROADMAP,
		        panControl: false,
    			zoomControl: false,
    			scaleControl: true,
    			streetViewControl: true,
    			streetViewControlOptions: {
			        position: google.maps.ControlPosition.TOP_RIGHT
			    }
    			 
		    };
			map = new google.maps.Map(leDiv, mapOptions);
			map.setTilt(45);
	
			//ajout boutons zoom
			function ZoomPlusControl(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginBottom = "10px";
				container.style.marginLeft = "10px";
				var containerDiv = document.createElement("div");
				containerDiv.style.cursor = "pointer";
				container.appendChild(containerDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoomplus.png";
				image.title = "Augmenter le zoom de la carte";
				containerDiv.appendChild(image);
				google.maps.event.addDomListener(containerDiv, "click", function() {
			   		map.setZoom(map.getZoom()+1);
				});
				return container;
			}
			var ZoomPlusControlDiv = new ZoomPlusControl(map);
			ZoomPlusControlDiv.index = 1;
			map.controls[google.maps.ControlPosition.TOP_LEFT].push(ZoomPlusControlDiv);
			
			function ZoomMoinsControl(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginBottom = "10px";
				container.style.marginLeft = "10px";
				var containerDiv = document.createElement("div");
				containerDiv.style.cursor = "pointer";
				container.appendChild(containerDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoommoins.png";
				image.title = "Augmenter le zoom de la carte";
				containerDiv.appendChild(image);
				google.maps.event.addDomListener(containerDiv, "click", function() {
			   		map.setZoom(map.getZoom()-1);
				});
				return container;
			}
			var ZoomMoinsControlDiv = new ZoomMoinsControl(map);
			ZoomMoinsControlDiv.index = 2;
			map.controls[google.maps.ControlPosition.TOP_LEFT].push(ZoomMoinsControlDiv);
			
			// boutons meta-catégories
			var metacat1 = "5";//hébergement
			function Meta1Control(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginLeft = "10px";
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/hbgt.png";
				image.title = "Hébergements";
				container.appendChild(image);
				google.maps.event.addDomListener(container, "click", function() {
			   		var mapDiv = document.getElementById("map");
					if (mapDiv == null) {
						return false;
					}
					if (dialogDiv ==null) {
						dialogDiv=document.createElement('div');
						dialogDiv.setAttribute('id','dialogcats');
						mapDiv.appendChild(dialogDiv);
					}
					else {
						dialogDiv.style.display = 'block';
					}
					var metacats = getXMLchild(racine_carte,"metacats");
					if (metacats) {
						var metacat_courant = getXMLchild(metacats,"metacat");
						while (metacat_courant && getXMLparam(metacat_courant,"Id") != metacat1) {
							metacat_courant = next_sibling(metacat_courant);
						}
						if (metacat_courant) {
							var cat_courant = getXMLchild(metacat_courant,"cat");
							var listcats = "";
							while (cat_courant) {
								var idcat = getXMLvalue(cat_courant,"idcat");
								var labelcat = getXMLvalue(cat_courant,"labelcat");
								listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','', '"+idcat+"','"+village+"'); return false\">"+labelcat+"</a></li>";
								cat_courant = next_sibling(cat_courant);
							}
							listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','"+metacat1+"', '','"+village+"'); return false\">Tous les h&eacute;bergements</a></li>";
							if (listcats != "") {
								listcats = "<ul>"+listcats+"</ul>";
							}
						}
						else {
							listcats = "<p>Aucune catégorie correspondante</p>";
						}
						dialogDiv.innerHTML =listcats;
					}
				});
				map.getDiv().appendChild(container);
				return container;
			};
			var Meta1ControlDiv = new Meta1Control(map);
			Meta1ControlDiv.index = 3;
			map.controls[google.maps.ControlPosition.LEFT_TOP].push(Meta1ControlDiv);
			
			var metacat2 = "4";//restauration
			function Meta2Control(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginLeft = "10px";
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/rest.png";
				image.title = "Restauration";
				container.appendChild(image);
				google.maps.event.addDomListener(container, "click", function() {
			   		var mapDiv = document.getElementById("map");
					if (mapDiv == null) {
						return false;
					}
					if (dialogDiv ==null) {
						dialogDiv=document.createElement('div');
						dialogDiv.setAttribute('id','dialogcats');
						mapDiv.appendChild(dialogDiv);
					}
					else {
						dialogDiv.style.display = 'block';
					}
					var metacats = getXMLchild(racine_carte,"metacats");
					if (metacats) {
						var metacat_courant = getXMLchild(metacats,"metacat");
						while (metacat_courant && getXMLparam(metacat_courant,"Id") != metacat2) {
							metacat_courant = next_sibling(metacat_courant);
						}
						if (metacat_courant) {
							var cat_courant = getXMLchild(metacat_courant,"cat");
							var listcats = "";
							while (cat_courant) {
								var idcat = getXMLvalue(cat_courant,"idcat");
								var labelcat = getXMLvalue(cat_courant,"labelcat");
								listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','', '"+idcat+"','"+village+"'); return false\">"+labelcat+"</a></li>";
								cat_courant = next_sibling(cat_courant);
							}
							listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','"+metacat2+"', '','"+village+"'); return false\">Toute la restauration</a></li>";
							if (listcats != "") {
								listcats = "<ul>"+listcats+"</ul>";
							}
						}
						else {
							listcats = "<p>Aucune catégorie correspondante</p>";
						}
						dialogDiv.innerHTML =listcats;
					}
				});
				map.getDiv().appendChild(container);
				return container;
			};
			var Meta2ControlDiv = new Meta2Control(map);
			Meta2ControlDiv.index = 4;
			map.controls[google.maps.ControlPosition.LEFT_TOP].push(Meta2ControlDiv);
			
			var metacat3 = "3";//activités
			function Meta3Control(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginLeft = "10px";
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/acts.png";
				image.title = "Activités";
				container.appendChild(image);
				google.maps.event.addDomListener(container, "click", function() {
			   		var mapDiv = document.getElementById("map");
					if (mapDiv == null) {
						return false;
					}
					if (dialogDiv ==null) {
						dialogDiv=document.createElement('div');
						dialogDiv.setAttribute('id','dialogcats');
						mapDiv.appendChild(dialogDiv);
					}
					else {
						dialogDiv.style.display = 'block';
					}
					var metacats = getXMLchild(racine_carte,"metacats");
					if (metacats) {
						var metacat_courant = getXMLchild(metacats,"metacat");
						while (metacat_courant && getXMLparam(metacat_courant,"Id") != metacat3) {
							metacat_courant = next_sibling(metacat_courant);
						}
						if (metacat_courant) {
							var cat_courant = getXMLchild(metacat_courant,"cat");
							var listcats = "";
							while (cat_courant) {
								var idcat = getXMLvalue(cat_courant,"idcat");
								var labelcat = getXMLvalue(cat_courant,"labelcat");
								listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','', '"+idcat+"','"+village+"'); return false\">"+labelcat+"</a></li>";
								cat_courant = next_sibling(cat_courant);
							}
							listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','"+metacat3+"', '','"+village+"'); return false\">Toutes les activit&eacute;s</a></li>";
							if (listcats != "") {
								listcats = "<ul>"+listcats+"</ul>";
							}
						}
						else {
							listcats = "<p>Aucune catégorie correspondante</p>";
						}
						dialogDiv.innerHTML =listcats;
					}
				});
				map.getDiv().appendChild(container);
				return container;
			};
			var Meta3ControlDiv = new Meta3Control(map);
			Meta3ControlDiv.index = 5;
			map.controls[google.maps.ControlPosition.LEFT_TOP].push(Meta3ControlDiv);
			
			/*var metacat4 = "6";//infos utiles
			function Meta4Control(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginLeft = "10px";
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/infos.png";
				image.title = "Infos utiles";
				container.appendChild(image);
				google.maps.event.addDomListener(container, "click", function() {
			   		var mapDiv = document.getElementById("map");
					if (mapDiv == null) {
						return false;
					}
					if (dialogDiv ==null) {
						dialogDiv=document.createElement('div');
						dialogDiv.setAttribute('id','dialogcats');
						mapDiv.appendChild(dialogDiv);
					}
					else {
						dialogDiv.style.display = 'block';
					}
					var metacats = getXMLchild(racine_carte,"metacats");
					if (metacats) {
						var metacat_courant = getXMLchild(metacats,"metacat");
						while (metacat_courant && getXMLparam(metacat_courant,"Id") != metacat4) {
							metacat_courant = next_sibling(metacat_courant);
						}
						if (metacat_courant) {
							var cat_courant = getXMLchild(metacat_courant,"cat");
							var listcats = "";
							while (cat_courant) {
								var idcat = getXMLvalue(cat_courant,"idcat");
								var labelcat = getXMLvalue(cat_courant,"labelcat");
								listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','', '"+idcat+"','"+village+"'); return false\">"+labelcat+"</a></li>";
								cat_courant = next_sibling(cat_courant);
							}
							listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','"+metacat4+"', '','"+village+"'); return false\">Toutes les infos utiles</a></li>";
							if (listcats != "") {
								listcats = "<ul>"+listcats+"</ul>";
							}
						}
						else {
							listcats = "<p>Aucune catégorie correspondante</p>";
						}
						dialogDiv.innerHTML =listcats;
					}
				});
				map.getDiv().appendChild(container);
				return container;
			};
			var Meta4ControlDiv = new Meta4Control(map);
			Meta4ControlDiv.index = 6;
			map.controls[google.maps.ControlPosition.LEFT_TOP].push(Meta4ControlDiv);*/
			//fin boutons méta catégories
			
			//afficher les points du fonds de carte
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var cont_mess = "";
				if (fiche != "") {
					if (message != "") {
						var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
					}
				}
				else {
					if (message != "") {
						var link_mess = "";
					}
				}
				cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
				var infowindow = new google.maps.InfoWindow({
				      content: cont_mess,
				      maxWidth: 250
				});
				
				var echelle = map.getZoom();
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				largeur = taille;
				hauteur = taille;
				var image = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon: image
				});
				google.maps.event.addListener(marker, 'click', function() {
				    infowindow.open(map,marker);
				});
				return marker;
			}
			
			function afficheLieux() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point,message,commentaire,chemicone,fiche,target)
						if (tempMark != null) {
							markers.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//afficher les textes du fonds de carte
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {
				if (test3D(map.getMapTypeId())) {
					return null;
				}
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				var image = {
				    url: racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte,
				    size: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon: image
				});
				if (fiche != "") {
					google.maps.event.addListener(marker, 'click', function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			function afficheTextes() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"textes");
				if (points != null) {
					var point_courant = getXMLchild(points,"texte");
					while (point_courant) {
						var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_texte")), eval(getXMLvalue(point_courant,"longitude_texte")));
						var fiche = getXMLvalue(point_courant,"lien_texte");
						var target = getXMLvalue(point_courant,"cible_texte");
						var message = getXMLvalue(point_courant,"lieu_texte");
						var commentaire = getXMLvalue(point_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(point_courant,"dim_texte");
						var angletxt = getXMLvalue(point_courant,"angle_texte");
						var couleurtxt = getXMLvalue(point_courant,"couleur_texte");
						var typotxt = getXMLvalue(point_courant,"police_texte");
						var tailletxt = getXMLvalue(point_courant,"taille_texte");
						var tempMark = createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							markers.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//afficher polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				if (plein == "1") {
					var polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: 1,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: opacite
					  });
				}
				else {
					var polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: opacite,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: 0
					  });
				}
				if (fiche != "" && plein == "1") {
					google.maps.event.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				polygone.setMap(map);
				
				return polygone;
			}
			
			function afficherPolygones() {
				var polygones = getXMLchild(racine_carte,"polygones");
				if (polygones != null) {
					var point_courant = getXMLchild(polygones,"polygone");
					while (point_courant) {
						var couleur = getXMLvalue(point_courant,"couleur");
						var epaisseur = eval(getXMLvalue(point_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(point_courant,"opacite"));
						var points = getXMLvalue(point_courant,"polyencode");
						var visibilite = getXMLvalue(point_courant,"polyvisibilite");
						var fiche = getXMLvalue(point_courant,"lien_polygone");
						var target = getXMLvalue(point_courant,"cible_polygone");
						var plein = getXMLvalue(point_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							markers.push(tempZone);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}			
			
			//afficher les symboles
			function createMarkerSymb(point,message,commentaire,chemicone,photo,fiche,target) {
				var cont_mess = "";
				if (fiche != "") {
					if (message != "") {
						var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"&from=carto\" target=\""+target+"\">Pour en savoir plus...</a></p>";
					}
				}
				else {
					if (message != "") {
						var link_mess = "";
					}
				}
				cont_mess = '<div class="bulle"><div class="illustalert"><img src="'+photo+'"/></div><div class="blockalert"><h1 class="messalert">'+message+'</h1><p class="messalert">'+commentaire+'</p>'+link_mess+'</div></div>';
				var infowindow = new google.maps.InfoWindow({
				      content: cont_mess,
				      maxWidth: 280
				      
				});
				var image = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(32,32),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(0, 32)
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon:image
				});
				google.maps.event.addListener(marker, 'click', function() {
				    infowindow.open(map,marker);
				});
				return marker;
			}
			
			function afficherSymboles() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"symboles");
				if (points != null) {
					var point_courant = getXMLchild(points,"symbole");
					while (point_courant) {
						var lat = getXMLvalue(point_courant,"latitude_symb");
						var lon = getXMLvalue(point_courant,"longitude_symb");
						if (lat != "" && lon!= "" && eval(lat) <= 360 && eval(lon) < 90) {
							var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
							var message = getXMLvalue(point_courant,"nom_symb");
							var chemicone = getXMLvalue(point_courant,"picto_symb");
							var photo = getXMLvalue(point_courant,"photo_symb");
							var commentaire = getXMLvalue(point_courant,"commentaire_symb");
							var fiche = getXMLvalue(point_courant,"lien_symb");
							//var target = getXMLvalue(texte_courant,"cible_texte");
							var target = '_blank';
							var tempMark = createMarkerSymb(point,message,commentaire,chemicone,photo, fiche,target);
							if (tempMark != null) {
								markers.push(tempMark);
							}
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
			function afficherCBordure() {
				return true; //pour neutraliser la fonction
				/*var bordure = new GPolyline.fromEncoded({
					color: getXMLvalue(racine_carte,"points_couleur"),
					weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
					opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
					points: getXMLvalue(racine_carte,"points_bordure"),
					levels: getXMLvalue(racine_carte,"points_visibilite"),
					numLevels: 3,
					zoomFactor: 12
				});
				map.addOverlay(bordure);*/
			}
			
			function getLocation() {
				// Get location no more than 10 minutes old. 600000 ms = 10 minutes.
				navigator.geolocation.getCurrentPosition(showLocation, showError, {enableHighAccuracy:true,maximumAge:600000});
			}
			function showError(error) {
				alert(error.code + ' ' + error.message);
			}
			function showLocation(position) {
				var smartpositionlat = position.coords.latitude;
				var smartpositionlon = position.coords.longitude;
				//rome
				/*smartpositionlat = 41.89001042401824;
				smartpositionlon = 12.392578125;*/
				//monaco
				/*smartpositionlat = 43.74208054609992;
				smartpositionlon = 7.426414489746094;*/
				//aleria
				/*smartpositionlat = 42.11325452493734;
				smartpositionlon = 9.513623714447021;*/
				
				/*geoinfo.innerHTML='<p>Latitude: ' + position.coords.latitude + '</p>' 
				+ '<p>Longitude: ' + position.coords.longitude + '</p>' 
				+ '<p>Accuracy: ' + position.coords.accuracy + '</p>' 
				+ '<p>Altitude: ' + position.coords.altitude + '</p>' 
				+ '<p>Altitude accuracy: ' + position.coords.altitudeAccuracy + '</p>' 
				+ '<p>Speed: ' + position.coords.speed + '</p>' 
				+ '<p>Heading: ' + position.coords.heading + '</p>';*/
				//return {latitude: position.coords.latitude,  longitude : position.coords.longitude}
				//améliorer en fonction des règles de localisation
				//map.panTo(new GLatLng(position.coords.latitude, position.coords.longitude));
				positionPortable = new google.maps.LatLng(smartpositionlat, smartpositionlon);
				//montrerPortable();
				//setTimeout("map.panTo(positionPortable)",2000);
				// ********** test en foction des règles de positionnement *********//
				var latitudeinitadhs = eval(getXMLvalue(racine_carte,"latitudeinitadhs"));
				var longitudeinitadhs = eval(getXMLvalue(racine_carte,"longitudeinitadhs"));
				var latitudeminadhs = eval(getXMLvalue(racine_carte,"latitudeminadhs"));
				var latitudemaxadhs = eval(getXMLvalue(racine_carte,"latitudemaxadhs"));
				var longitudeminadhs = eval(getXMLvalue(racine_carte,"longitudeminadhs"));
				var longitudemaxadhs = eval(getXMLvalue(racine_carte,"longitudemaxadhs"));
				//var zoneadhs = new GLatLngBounds(new GLatLng(latitudeminadhs,longitudeminadhs), new GLatLng(latitudemaxadhs,longitudemaxadhs));
				var latitudezonemin =  Math.min(latitudeminadhs,smartpositionlat);
				var latitudezonemax =  Math.max(latitudemaxadhs,smartpositionlat);
				var longitudezonemin =  Math.min(longitudeminadhs,smartpositionlon);
				var longitudezonemax =  Math.max(longitudemaxadhs,smartpositionlon);
				//alert(latitudezonemin+", "+longitudezonemin+", "+latitudezonemax+", "+longitudezonemax);
				var zonetotale = new google.maps.LatLngBounds(new google.maps.LatLng(latitudezonemin,longitudezonemin), new google.maps.LatLng(latitudezonemax,longitudezonemax));;
				map.fitBounds(zonetotale);
				montrerPortable();
			}
			
			function orderOfCreation(marker,b) {
        		return 1;
      		}
			
			function montrerPortable() {
				if (positionPortable != null) {
					var urlimage = getXMLvalue(racine_carte,"pictoportable");
					var image = {
					    url: urlimage,
					    size: new google.maps.Size(20,34),
					    origin: new google.maps.Point(0,0),
					    anchor: new google.maps.Point(Math.ceil(20/2),Math.ceil(34/2))
					};
					var message = "Votre position";
					var commentaire = "Vous &ecirc;tes ici";
					var fiche = "";
					var target = "";
					var cont_mess = "";
					if (fiche != "") {
						if (message != "") {
							var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p>";
						}
					}
					else {
						if (message != "") {
							var link_mess = "";
						}
					}
					cont_mess = "<div class=\"bulle\"><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div></div>";
					var infowindow = new google.maps.InfoWindow({
				      content: cont_mess,
				      maxWidth: 250
				      
					});
					var marker = new google.maps.Marker({
					      position: positionPortable,
					      map: map,
					      title: message,
					      icon:image,
					      zIndexProcess:orderOfCreation
					});
					google.maps.event.addListener(marker, 'click', function() {
					    infowindow.open(map,marker);
					});
				}
			}
			
			//afficher position courante
			if (navigator.geolocation) {
				getLocation();
			}
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficherSymboles();
			
			if (options["mini_vue"]) {
				//minivue();
				//map.addControl(new GOverviewMapControl());
			}
			if (options["titre"]) {
				titrer(id,'titre')
			}
			if (options ["obs"]) {
				listLieux(id,'obs');
			}
			if (options["commentaire"]) {
				commenter(id,'commentaire');
			}
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre à jour.");
		}
	}
	
	function reloadsymboles (id,idmetacat,idcat,village){
		if (window.JSON) {
			cartes = GetXMLSymbols(id,idmetacat,idcat,village);
		 	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");

			clearOverlays();

			//afficher les points du fonds de carte
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var cont_mess = "";
				if (fiche != "") {
					if (message != "") {
						var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
					}
				}
				else {
					if (message != "") {
						var link_mess = "";
					}
				}
				cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
				var infowindow = new google.maps.InfoWindow({
				      content: cont_mess,
				      maxWidth: 250
				});
				
				var echelle = map.getZoom();
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				largeur = taille;
				hauteur = taille;
				var image = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon: image
				});
				google.maps.event.addListener(marker, 'click', function() {
				    infowindow.open(map,marker);
				});
				return marker;
			}
			
			function afficheLieux() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point,message,commentaire,chemicone,fiche,target)
						if (tempMark != null) {
							markers.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//afficher les textes du fonds de carte
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {
				if (test3D(map.getMapTypeId())) {
					return null;
				}
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				var image = {
				    url: racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte,
				    size: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon: image
				});
				if (fiche != "") {
					google.maps.event.addListener(marker, 'click', function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			function afficheTextes() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"textes");
				if (points != null) {
					var point_courant = getXMLchild(points,"texte");
					while (point_courant) {
						var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_texte")), eval(getXMLvalue(point_courant,"longitude_texte")));
						var fiche = getXMLvalue(point_courant,"lien_texte");
						var target = getXMLvalue(point_courant,"cible_texte");
						var message = getXMLvalue(point_courant,"lieu_texte");
						var commentaire = getXMLvalue(point_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(point_courant,"dim_texte");
						var angletxt = getXMLvalue(point_courant,"angle_texte");
						var couleurtxt = getXMLvalue(point_courant,"couleur_texte");
						var typotxt = getXMLvalue(point_courant,"police_texte");
						var tailletxt = getXMLvalue(point_courant,"taille_texte");
						var tempMark = createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							markers.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//afficher polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				if (plein == "1") {
					var polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: 1,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: opacite
					  });
				}
				else {
					var polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: opacite,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: 0
					  });
				}
				if (fiche != "" && plein == "1") {
					google.maps.event.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				polygone.setMap(map);
				
				return polygone;
			}
			
			function afficherPolygones() {
				var polygones = getXMLchild(racine_carte,"polygones");
				if (polygones != null) {
					var point_courant = getXMLchild(polygones,"polygone");
					while (point_courant) {
						var couleur = getXMLvalue(point_courant,"couleur");
						var epaisseur = eval(getXMLvalue(point_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(point_courant,"opacite"));
						var points = getXMLvalue(point_courant,"polyencode");
						var visibilite = getXMLvalue(point_courant,"polyvisibilite");
						var fiche = getXMLvalue(point_courant,"lien_polygone");
						var target = getXMLvalue(point_courant,"cible_polygone");
						var plein = getXMLvalue(point_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							markers.push(tempZone);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}			
			
			//afficher les symboles
			function createMarkerSymb(point,message,commentaire,chemicone,photo,fiche,target) {
				var cont_mess = "";
				if (fiche != "") {
					if (message != "") {
						var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"&from=carto\" target=\""+target+"\">Pour en savoir plus...</a></p>";
					}
				}
				else {
					if (message != "") {
						var link_mess = "";
					}
				}
				cont_mess = '<div class="bulle"><div class="illustalert"><img src="'+photo+'" /></div><div class="blockalert"><h1 class="messalert">'+message+'</h1><p class="messalert">'+commentaire+'</p>'+link_mess+'</div></div>';
				var infowindow = new google.maps.InfoWindow({
				      content: cont_mess,
				      maxWidth: 280
				      
				});
				var image = {
				    url: chemicone,
				    size: new google.maps.Size(32,32),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(0, 32)
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon:image
				});
				google.maps.event.addListener(marker, 'click', function() {
				    infowindow.open(map,marker);
				});
				return marker;
			}
			
			function afficherSymboles() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"symboles");
				if (points != null) {
					var point_courant = getXMLchild(points,"symbole");
					while (point_courant) {
						var lat = getXMLvalue(point_courant,"latitude_symb");
						var lon = getXMLvalue(point_courant,"longitude_symb");
						if (lat != "" && lon!= "" && eval(lat) <= 360 && eval(lon) < 90) {
							var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
							var message = getXMLvalue(point_courant,"nom_symb");
							var chemicone = getXMLvalue(point_courant,"picto_symb");
							var photo = getXMLvalue(point_courant,"photo_symb");
							var commentaire = getXMLvalue(point_courant,"commentaire_symb");
							var fiche = getXMLvalue(point_courant,"lien_symb");
							//var target = getXMLvalue(texte_courant,"cible_texte");
							var target = '_blank';
							var tempMark = createMarkerSymb(point,message,commentaire,chemicone,photo, fiche,target);
							if (tempMark != null) {
								markers.push(tempMark);
							}
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
			function afficherCBordure() {
				return true; //pour neutraliser la fonction
				/*var bordure = new GPolyline.fromEncoded({
					color: getXMLvalue(racine_carte,"points_couleur"),
					weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
					opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
					points: getXMLvalue(racine_carte,"points_bordure"),
					levels: getXMLvalue(racine_carte,"points_visibilite"),
					numLevels: 3,
					zoomFactor: 12
				});
				map.addOverlay(bordure);*/
			}
			
			function getLocation() {
				// Get location no more than 10 minutes old. 600000 ms = 10 minutes.
				navigator.geolocation.getCurrentPosition(showLocation, showError, {enableHighAccuracy:true,maximumAge:600000});
			}
			function showError(error) {
				alert(error.code + ' ' + error.message);
			}
			function showLocation(position) {
				var smartpositionlat = position.coords.latitude;
				var smartpositionlon = position.coords.longitude;
				//rome
				/*smartpositionlat = 41.89001042401824;
				smartpositionlon = 12.392578125;*/
				//monaco
				/*smartpositionlat = 43.74208054609992;
				smartpositionlon = 7.426414489746094;*/
				//aleria
				/*smartpositionlat = 42.11325452493734;
				smartpositionlon = 9.513623714447021;*/
				
				/*geoinfo.innerHTML='<p>Latitude: ' + position.coords.latitude + '</p>' 
				+ '<p>Longitude: ' + position.coords.longitude + '</p>' 
				+ '<p>Accuracy: ' + position.coords.accuracy + '</p>' 
				+ '<p>Altitude: ' + position.coords.altitude + '</p>' 
				+ '<p>Altitude accuracy: ' + position.coords.altitudeAccuracy + '</p>' 
				+ '<p>Speed: ' + position.coords.speed + '</p>' 
				+ '<p>Heading: ' + position.coords.heading + '</p>';*/
				//return {latitude: position.coords.latitude,  longitude : position.coords.longitude}
				//améliorer en fonction des règles de localisation
				//map.panTo(new GLatLng(position.coords.latitude, position.coords.longitude));
				positionPortable = new google.maps.LatLng(smartpositionlat, smartpositionlon);
				//montrerPortable();
				//setTimeout("map.panTo(positionPortable)",2000);
				// ********** test en foction des règles de positionnement *********//
				var latitudeinitadhs = eval(getXMLvalue(racine_carte,"latitudeinitadhs"));
				var longitudeinitadhs = eval(getXMLvalue(racine_carte,"longitudeinitadhs"));
				var latitudeminadhs = eval(getXMLvalue(racine_carte,"latitudeminadhs"));
				var latitudemaxadhs = eval(getXMLvalue(racine_carte,"latitudemaxadhs"));
				var longitudeminadhs = eval(getXMLvalue(racine_carte,"longitudeminadhs"));
				var longitudemaxadhs = eval(getXMLvalue(racine_carte,"longitudemaxadhs"));
				//var zoneadhs = new GLatLngBounds(new GLatLng(latitudeminadhs,longitudeminadhs), new GLatLng(latitudemaxadhs,longitudemaxadhs));
				var latitudezonemin =  Math.min(latitudeminadhs,smartpositionlat);
				var latitudezonemax =  Math.max(latitudemaxadhs,smartpositionlat);
				var longitudezonemin =  Math.min(longitudeminadhs,smartpositionlon);
				var longitudezonemax =  Math.max(longitudemaxadhs,smartpositionlon);
				//alert(latitudezonemin+", "+longitudezonemin+", "+latitudezonemax+", "+longitudezonemax);
				var zonetotale = new google.maps.LatLngBounds(new google.maps.LatLng(latitudezonemin,longitudezonemin), new google.maps.LatLng(latitudezonemax,longitudezonemax));;
				map.fitBounds(zonetotale);
				montrerPortable();
			}
			
			function orderOfCreation(marker,b) {
        		return 1;
      		}
			
			function montrerPortable() {
				if (positionPortable != null) {
					var urlimage = getXMLvalue(racine_carte,"pictoportable");
					var image = {
					    url: urlimage,
					    size: new google.maps.Size(20,34),
					    origin: new google.maps.Point(0,0),
					    anchor: new google.maps.Point(Math.ceil(20/2),Math.ceil(34/2))
					};
					var message = "Votre position";
					var commentaire = "Vous &ecirc;tes ici";
					var fiche = "";
					var target = "";
					var cont_mess = "";
					if (fiche != "") {
						if (message != "") {
							var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p>";
						}
					}
					else {
						if (message != "") {
							var link_mess = "";
						}
					}
					cont_mess = "<div class=\"bulle\"><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div></div>";
					var infowindow = new google.maps.InfoWindow({
				      content: cont_mess,
				      maxWidth: 250
				      
					});
					var marker = new google.maps.Marker({
					      position: positionPortable,
					      map: map,
					      title: message,
					      icon:image,
					      zIndexProcess:orderOfCreation
					});
					google.maps.event.addListener(marker, 'click', function() {
					    infowindow.open(map,marker);
					});
				}
			}
			
			//afficher position courante
			if (navigator.geolocation) {
				getLocation();
			}
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficherSymboles();
			
			if (options["mini_vue"]) {
				//minivue();
				//map.addControl(new GOverviewMapControl());
			}
			if (options["titre"]) {
				titrer(id,'titre')
			}
			if (options ["obs"]) {
				listLieux(id,'obs');
			}
			if (options["commentaire"]) {
				commenter(id,'commentaire');
			}
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre à jour.");
		}
	}
	
	function listLieux(id,zone_id) {
		if (options["obs"]) {
			if (cartes == null) {
				cartes = GetXMLSymbols(id);
			}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");	
			var points = getXMLchild(racine_carte,"points");
			if (points != null) {
				var point_courant = getXMLchild(points,"point");
				var observations = "";
				observations += "<table border=\"0\" cellpadding=\"0\" celspacing=\"0\" class=\"observations\">";
				observations += "<tr><th colspan=\"4\">D&eacute;tails</th></tr>";
				while (point_courant) {
					var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
					var message = getXMLvalue(point_courant,"lieu");
					var chemicone = getXMLvalue(point_courant,"picto");
					var commentaire = getXMLvalue(point_courant,"commentaire_point");
					var fiche = getXMLvalue(point_courant,"lien");
					var target = getXMLvalue(point_courant,"cible");
					
					observations += "<tr>";
					observations += "<td>";
					observations += "<img src=\""+chemicone+"\" />";
					observations += "</td><td>";
					observations += message;
					observations += "</td><td>";
					observations += commentaire;
					observations += "</td><td>";
					if (fiche != "") {
						observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
					}
					observations += "</td>";
					observations += "<tr>";
					
					point_courant = next_sibling(point_courant);
				}
			}
			var polygones = getXMLchild(racine_carte,"polygones");
			if (polygones != null) {
				var polygone_courant = getXMLchild(polygones,"polygone");
				while (polygone_courant) {
					var nom =  getXMLvalue(polygone_courant,"nom");
					var details =  getXMLvalue(polygone_courant,"details");
					var couleur = getXMLvalue(polygone_courant,"couleur");
					var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
					var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
					var points = getXMLvalue(polygone_courant,"polyencode");
					var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
					var plein = getXMLvalue(polygone_courant,"plein");
					var fiche = getXMLvalue(polygone_courant,"lien_polygone");
					var target = getXMLvalue(polygone_courant,"cible_polygone");
					
					observations += "<tr>";
						observations += "<td>";
						observations += "<div style=\"display: block; line-height: 1px; width: 30px; height: "+epaisseur+"; background-color: "+couleur+"; filter: alpha(opacity="+eval(opacite*100)+"); -moz-opacity: "+opacite+"; opacity: "+opacite+" \"></div>";
						observations += "</td><td>";
						observations += nom;
						observations += "</td><td>";
						observations += details;
						observations += "</td><td>";
						if (fiche != "") {
							observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
						}
						observations += "</td>";
						observations += "<tr>";
					polygone_courant = next_sibling(polygone_courant);
				}
			}
			observations += "</table>";
			
	  		var ie = false;
			if (document.all) {
				ie = true;
			}
			if (ie) {
				 var leDiv = document.all[zone_id];
			}
			else {
				var leDiv =  document.getElementById(zone_id);
			}
			if (leDiv == null) {
				return false;
			}
			leDiv.innerHTML = observations;
		}
	}
	
	function titrer(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var titre = getXMLvalue(racine_carte,"titre");
		
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = titre;
		document.title = document.title + " - " + titre;
	}
	
	function commenter(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var commentaire = getXMLvalue(racine_carte,"page_carte");
		if (commentaire == "") {
			commentaire = getXMLvalue(racine_carte,"commentaire");
		}
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = commentaire;
	}
	
	function GetXMLSymbols(id,idmetacat,idcat,village) {
		var sortie = "";
		var params = "";
		if (id != "") {
			params += "&Idc="+id;
		}
		if (idmetacat != "") {
			params += "&metacat="+idmetacat;
		}
		if (idcat != "") {
			params += "&cat="+idcat;
		}
		if (village != "") {
			params += "&vilage="+village;
		}
		var sources_cartes = "mobiles.php?name=SimpleAdherents&op=map_alladhs_XML"+params;
		var cartes = GetAJAXData(sources_cartes);
		return cartes;
	}
	
	function calculeX(r){
	  return calculeOffset(r,"offsetLeft");
	}
	
	function calculeH(r){
	  return r["offsetHeight"];
	}
	
	function calculeL(r){
	  return r["offsetWidth"];
	}
	
	function calculeY(r){
	  return calculeOffset(r,"offsetTop")
	}
	function calculeOffset(element,attr){
	  var offset=0;
	  while(element){
	    offset+=element[attr];
	    element=element.offsetParent;
	  }
	  return offset;
	}
	
	var map = null;
	var markers = [];
	var minimap = null;
	var cartes = null;
	var latitudeinit = 0;
	var longitudeinit = 0;
	var type3D = false;
	var positionPortable = null;
	var dialogDiv = null;
	//]]>