<?php
/**
* Classes d'accs  la base de donnes pour la gestion des petites annonces.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleAds
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

require_once("utils.php");

/**
* Classe d'accs  la base de donnes petites annonces pour isoler les fonctions.
* 
* @package becmsSimpleAds
*/
class BD_Ads {
	var $My_SQL = array();
	
	function BD_Ads() {
		global $db,$prefix;
		$this->My_SQL["maBase"] = $db;
		$this->My_SQL["ads"] = $prefix."_ads_annonce";
		$this->My_SQL["cats"] = $prefix."_ads_categorie";
		$this->My_SQL["users"] = $prefix."_users";
	}
	
/**
* Efface la fiche de la petite annonce dsigne
* @param integer $Id Identifiant de l'annonce  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delAds($Id,$cat="") {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "" || $cat != "") {
			$cond = "";
			if ($Id != "-1" && $Id != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`Id`='".$Id."'";
			}
			if ($cat != "-1" && $cat != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`categorie`='".$cat."'";
			}
			$sql = "DELETE FROM `".$this->My_SQL["ads"]."`".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
/**
* Enregistre une fiche annonce
* 
* Si l'annonce esiste dj, elle est simplement modifie, sinon elle est cre.
* @param array $ads Tableau contenant tous les champs de l'annonce  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveAds($ads) {
		$db=$this->My_SQL["maBase"];
		$ads = array_map(array('utilFuncs', 'conditionnertodb'), $ads);
		$list_champs = "";
		$list_valeurs = "";
		if ($ads["Id"] == "-1") {
			foreach($ads as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["ads"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($ads as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["ads"]."` SET ".$list_champs." WHERE `Id` = '".$ads["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie la liste des annonces correspondants  la demande
* 
* Un tableau vide est renvoy si aucune annonce n'est trouve. Si tous les critres sont vides,toutes les annonces sont renvoyes.
* @param string $the_type Type de recherche (fiches/nbre de fiches) dont les valeurs sont "files" ou "count"
* @param integer $Id Identifiant de l'annonce  retrouver
* @param string $categorie Chaine pour limiter la recherche  cette catgorie.
* @param date $du Date de dbut de la recherche.
* @param date $au Date de fin de la recherche.
* @param integer $redateur Utilisateur ayant rdig l'annonce.
* @param string $item Texte contenu dans le sujet ou le texte de l'annonce.
* @param string $tri_par Nom de la rubrique servant au tri.
* @param string $limit Indication des enregistrements  retourner (index et nombre).
* @return array Retourne la liste des clients retrouvs
*/	
	function getAds($the_type="files", $Id="" , $categorie = "", $du="", $au="", $redacteur="", $item="", $tri_par="",$limit="") {
		$db=$this->My_SQL["maBase"];
		
		$ads = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`Id`='".$Id."'";
		}
		if ($categorie != "") {
			$categorie = utilFuncs::conditionnertodb($categorie);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`categorie`='".$categorie."'";
		}
		if ($du != "") {
			$du = utilFuncs::date2AMJ($du);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`date_debut`<='".$du."'";
		}
		if ($au != "") {
			$au = utilFuncs::date2AMJ($au);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`date_fin`>='".$au."'";
		}
		if ($redacteur != "") {
			$redacteur = utilFuncs::conditionnertodb($redacteur);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`redacteur`='".$redacteur."'";
		}
		if ($item != "") {
			$item = utilFuncs::conditionnertodb($item);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`object` LIKE '%".$item."%' OR `".$this->My_SQL["ads"]."`.`content` LIKE '%".$item."%'";
		}
		if ($the_type == "files") {
			$oderby = "";
			if ($tri_par =="") {
				$oderby = " ORDER BY `".$this->My_SQL["ads"]."`.`date_saisie` DESC";
			}
			if ($tri_par == "categorie") {
				$oderby = " ORDER BY `".$this->My_SQL["ads"]."`.`categorie` ASC, `".$this->My_SQL["ads"]."`.`date_saisie` DESC";
			}
			if ($tri_par == "redacteur") {
				$oderby = " ORDER BY `".$this->My_SQL["ads"]."`.`redacteur` ASC, `".$this->My_SQL["ads"]."`.`date_saisie` DESC";
			}
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT `".$this->My_SQL["ads"]."`.`Id`,`".$this->My_SQL["ads"]."`.`object`,`".$this->My_SQL["ads"]."`.`content`,`".$this->My_SQL["ads"]."`.`categorie`,`".$this->My_SQL["ads"]."`.`date_saisie`,`".$this->My_SQL["ads"]."`.`date_debut`,`".$this->My_SQL["ads"]."`.`date_fin`,`".$this->My_SQL["ads"]."`.`redacteur` FROM `".$this->My_SQL["ads"]."` ".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($ads, $ligneCourante);
				}
			}
			return $ads;
		}
		if ($the_type == "count") {
			$sql = "SELECT count(Id) AS nbre FROM `".$this->My_SQL["ads"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
	
/**
* Renvoie la liste des catgories des annonces correspondants  la demande
* 
* Un tableau vide est renvoy si aucune catgorie n'est trouve. Si tous les critres sont vides,toutes les catgories sont renvoyes.
* @param integer $Id Identifiant de l'annonce  retrouver
* @return array Retourne la liste des catgories retrouvs
*/	
	function getCats($Id="") {
	$db=$this->My_SQL["maBase"];
		
		$ads = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["cats"]."`.`Id`='".$Id."'";
		}
		$oderby = " ORDER BY `".$this->My_SQL["cats"]."`.`categorie` ASC";
		$resultatRecherche = $db->sql_query("SELECT `".$this->My_SQL["cats"]."`.`Id`,`".$this->My_SQL["cats"]."`.`categorie`,`".$this->My_SQL["cats"]."`.`image` FROM `".$this->My_SQL["cats"]."` ".$cond.$oderby.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($ads, $ligneCourante);
			}
		}
		return $ads;
	}
/**
* Efface la fiche de la catgorie et des petites annonces incluses
* @param integer $Id Identifiant la catgorie  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delCat($Id) {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$this->My_SQL["cats"]."` WHERE ".$cond.";";
			return $db->sql_query($sql) && $this->delAds($this->My_SQL,"",$Id);
		}
		else {
			return false;
		}
	}
/**
* Enregistre une catgorie
* 
* Si la catgorie esiste dj, elle est simplement modifie, sinon elle est cre.
* @param array $ads Tableau contenant tous les champs de la catgorie  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveCat($cat) {
		$db=$this->My_SQL["maBase"];
		$cat = array_map(array('utilFuncs', 'conditionnertodb'), $cat);
		$list_champs = "";
		$list_valeurs = "";
		if ($cat["Id"] == "-1") {
			foreach($cat as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["cats"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($cat as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["cats"]."` SET ".$list_champs." WHERE `Id` = '".$cat["Id"]."';";
		}
		return $db->sql_query($sql);
	}
	
/**
* Renvoie l'utilisateur correspondant  l'identifiant.
* @param integer $id_user Numro identifiant l'utilisateur.
* @return array Retourne l'utilisateur retrouv.
*/	
	function get_users($id_user="") {
		$db=$this->My_SQL["maBase"];
		$users = array();
		if ($id_user != "-1" && $id_user != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["users"]."`.`uid`='".$id_user."'";
		}
		$select = "select uid, uname from ".$this->My_SQL["users"].$cond.";";
		$resultatRecherche = $db->sql_query($select);
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($users, $ligneCourante);
			}
		}
		return $users;
	}
}
?>