<?php
/**
 * Interface d'administration du module de gestion des petites annonces.
 *
 * Cette valeur est fixe dans link.php.
 * @package becmsSimpleAds
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2008, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
	//setPath(_TXT_Modules,0);
	//setPath(_SIMPLECARTO,1);
	require_once("modules/$module_name/lib_db.php");
	require_once("modules/$module_name/utils.php");

	function list_index($nbreFiches, $page, $ligne_par_page,$tab_words="") {
		if ($tab_words != "") {
			$tab_words = "&search_words=".urlencode($tab_words);
		}
		$nboites = 5;
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._ADSFOUND;
			$indexPages .= _ADSPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=chuck&action=list&page=$min".$tab_words."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=chuck&action=list&page=$i".$tab_words."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=chuck&action=list&page=$max".$tab_words."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _ADSNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	function list_ads($page,$search_words="",$cat="") {
		$obj_cat = new BD_Ads();
		$nbrefiches = $obj_cat->getAds("count","",$cat,"","","",$search_words);
		$ligne_par_page = 20;
		if ($page=="-1") {
			$page = ceil($nbrefiches/$ligne_par_page);
		}
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= list_index($nbrefiches, $page, $ligne_par_page,$search_words);
		$liste .= '</td><td width="50"></td><td>';
		$liste .= '<form name="search_form" action="system.php?op=ads&action=search_ads&onglet=ads" method="POST">';
		$liste .= _ADSWORDSTOSEARCH.'<input type="text" name="search_words" value="'.$search_words.'">';
		$liste .= ' <input name="validsearch" type="submit" value="'._ADSSEARCHBTN.'">';
		$liste .= '</form>';
		$liste .= '</td></tr></table>';
		$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
		$results = $obj_cat->getAds("files","",$cat,"","","",$search_words,"",$limit);
		$liste .= '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader" style="text-align: left">'._ADSOBJECT.'</th>
					<th class="systemTabHeader">'._ADSPERIOD.'</th>
					<th class="systemTabHeader">'._ADSREDAC.'</th>
	    			<th class="systemTabHeader">'._ADSACTIONS.'</th>
		    		</tr>';
		$pos=0;
		if ($search_words != "") {
			$search_words = "&search_words=".urlencode($search_words);
		}
		foreach ($results as $result) {
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=ads&action=edit_ads&onglet=ads&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_EDIT, "status"=>"ON"),
	  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=ads&action=delete_ads&onglet=ads&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$longlim = 150;
			if (strlen($result["object"]) > $longlim) {
				$i = $longlim;
				while (substr($result["object"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["object"],0,$i)."...";
			}
			else {
				$liste .= $result["object"];
			}
			$liste .= '</td><td align="center">';
			$liste .= _ADSPERIODFROM.utilFuncs::date2JMA($result["date_debut"])._ADSPERIODTO.utilFuncs::date2JMA($result["date_fin"]);
			$liste .= '</td><td align="center">';
			$clients = $obj_cat->get_users($result["redacteur"]);
			$liste .= utilFuncs::conditionnerHTML($clients[0]["uname"]);
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=ads&action=add_ads&onglet=ads">'._ADSADDADS.'</a></div>';
		return $liste;
	}
	
	function edit_ads($Id, $page,$search_words="") {
		$obj_cat = new BD_Ads();
		$results = array();
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$results = $obj_cat->getAds("files",$Id,"","","","","","",$limit);
			$result = $results[0];
			$menu_cat = '<select name="categorie" size="1" class="saisie">'; 
			$cats = $obj_cat->getCats();
			foreach($cats as $cat) {
				$select = "";
				if ($result["categorie"] == $cat["Id"]) {
					$select = ' selected="selected"';
				}
				$menu_cat .= '<option value="'.$cat["Id"].'"'.$select.'>'.$cat["categorie"].'</option>';
			}
			$menu_cat .= '</select>';
			$menu_user = '<select name="redacteur" size="1" class="saisie">'; 
			$users = $obj_cat->get_users();
			foreach($users as $user) {
				$select = "";
				if ($result["redacteur"] == $user["uid"]) {
					$select = ' selected="selected"';
				}
				$menu_user .= '<option value="'.$user["uid"].'"'.$select.'>'.$user["uname"].'</option>';
			}
			$menu_user .= '</select>';
		}
		else {
			$menu_cat = '<select name="categorie" size="1" class="saisie">'; 
			$cats = $obj_cat->getCats();
			foreach($cats as $cat) {
				$menu_cat .= '<option value="'.$cat["Id"].'">'.$cat["categorie"].'</option>';
			}
			$menu_cat .= '</select>';
			$menu_user = '<select name="redacteur" size="1">';
			$users = $obj_cat->get_users();
			foreach($users as $user) {
				$menu_user .= '<option value="'.$user["uid"].'">'.$user["uname"].'</option>';
			}
			$menu_user .= '</select>';
		}
		$sortie = '<form name="editads" action="system.php?op=ads&action=save_ads&onglet=ads" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		$sortie .= '<tr><td>';
		$sortie .= _ADSOBJECTEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="object" value="'.$result["object"].'" class="saisie">';
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _ADSMESSAGEEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="content" cols="50" rows="10" class="saisie">'.$result["content"].'</textarea>';
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _ADSCATEDIT;
		$sortie .= '</td><td>';
		$sortie .= $menu_cat;
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _ADSSAISIEEDIT;
		$sortie .= '</td><td>';
		list($t1,$t2) = explode(" ",$result["date_saisie"]);
		$t1 = utilFuncs::date2JMA($t1);
		$result["date_saisie"] = $t1." ".$t2;
		$sortie .= '<input type="text" name="date_saisie" value="'.$result["date_saisie"].'" class="saisie">';
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _ADSDEBEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="date_debut" value="'.utilFuncs::date2JMA($result["date_debut"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _ADSFINEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="date_fin" value="'.utilFuncs::date2JMA($result["date_fin"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _ADSUSEREDIT;
		$sortie .= '</td><td>';
		$sortie .= $menu_user;
		$sortie .= '</td></tr>';
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._ADSCATSAVEBTN.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}
	
	function save_ads ($Id,$object,$content,$categorie,$date_saisie,$date_debut,$date_fin,$redacteur, $page,$search_words="") {
		if ($Id=="-1" || $Id == "") {
			$date_saisie = date("Y-m-d h:i:s");
		}
		else {
			list($t1,$t2) = explode(" ",$date_saisie);
			$t1 = utilFuncs::date2AMJ($t1);
			$date_saisie = $t1." ".$t2;
		}
		$date_debut = utilFuncs::date2AMJ($date_debut);
		$date_fin = utilFuncs::date2AMJ($date_fin);
		$ads = array("Id"=>$Id,"object"=>$object,"content"=>$content,"categorie"=>$categorie,"date_saisie"=>$date_saisie,"date_debut"=>$date_debut,"date_fin"=>$date_fin,"redacteur"=>$redacteur);
		$obj_ads = new BD_Ads();
		if (!$obj_ads->saveAds($ads)) {
			die("DB problem");
		}
		return true;
	}
	
	function delete_ads($Id,$page,$search_words,$cat,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_Ads();
				if($obj_ads->delAds($Id)) {
					return list_ads($page,$search_words,$cat);
				}
				else {
					die("DB problem");
				}
			}
			else {
				if ($search_words != "") {
					$search_words = "&search_words=".urlencode($search_words);
				}
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._ADSCONFIRMDELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=ads&action=delete_ads&onglet=ads&page='.$page.'&Id='.$Id.$search_words.'&confirm=y">';
				$sortie .= "["._ADSYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._ADSNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				return $sortie;
			}
		}
		return list_ads($page,$search_words,$cat);
	}

	function list_categories() {
		$obj_cat = new BD_Ads();
		$results = $obj_cat->getCats();
		$liste = '<table  class="lisTable">
			<tr class="systemTabHeader">
				<th class="systemTabHeader" style="text-align: left">'._ADSLISTCAT.'</th>
    			<th class="systemTabHeader">'._ADSACTION.'</th>
	    		</tr>';
		foreach($results as $result) {
			list($Id, $categorie,$image) = $result;
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=ads&action=edit_cat&onglet=cats&Id=".$Id,"comment"=>_EDIT, "status"=>"ON"),
  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=ads&action=delete_cat&onglet=cats&Id=".$Id,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$liste .= '<a href="system.php?op=ads&action=list_ads&onglet=ads&cat='.$Id.'">';
			$liste .= utilFuncs::conditionnerHTML($categorie);
			$liste .= '</a>';
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=ads&action=add_cat&onglet=cats">'._ADSADDCAT.'</a></div>';
		return $liste;
	}

	function edit_categorie($Id) {
		$categorie = "";
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$obj_cat = new BD_Ads();
			$results = $obj_cat->getCats($Id);
			list($Id, $categorie,$image) = $results[0];
		}
		$sortie = '<form name="editcat" action="system.php?op=ads&action=save_cat&onglet=cats" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		$sortie .= '<tr><td>';
		$sortie .= _ADSCATNAME;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="categorie" value="'.$categorie.'" class="saisie">';
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _ADSCATIMAGE;
		$sortie .= '</td><td>';
		$sortie .= '<SCRIPT language="JavaScript" src="javascripts/images.js"></SCRIPT>';
		//$sortie .= '<input type="text" name="image" value="'.$image.'">';
		$sortie .= '<select name="image" onChange="displayImg(\'myicon\',\'images/topics/\'+this.options[selectedIndex].value)" class="saisie">';
		$path1 = explode ("/", "images/topics/");
		$path = "$path1[0]/$path1[1]";
		$handle=opendir($path);
		$tlist2 = "";
		while ($file = readdir($handle)) {
			if(substr($file,0,1) != "!" && substr($file,0,1) != "_" && substr($file,0,1) != "." && !is_file($path . '/' . $file) && !is_link($path . '/' . $file)) {
				$path2 = $path."/".$file;
				$handle2=opendir($path2);
				while ($file2 = readdir($handle2)) {
					if(substr($file2,0,1) != "!" && substr($file2,0,1) != "_" && substr($file2,0,1) != "." && is_file($path2 . '/' . $file2)) {
						if ( (preg_match("#^([0-9a-zA-Z]+)([.]{1})([a-z0-9A-Z]{3})$#",$file2)) ) {
							$tlist2 .= $file."/$file2 ";
						}
					}
				}
				closedir($handle2);
			}
			if ( (preg_match("#^([0-9a-zA-Z]+)([.]{1})([a-z0-9A-Z]{3})$#",$file)) ) {
				$tlist .= "$file ";
			}
		}
		closedir($handle);
		$tlist = explode(" ", $tlist);
		sort($tlist);
		$tlist2 = explode(" ", $tlist2);
		sort($tlist2);
		$tlist = array_merge($tlist,$tlist2);
		for ($i=0; $i < sizeof($tlist); $i++) {
			if($tlist[$i]!="") {
				if ($image == $tlist[$i]) {
					$sel = ' selected="selected"';
				} else {
					$sel = '';
				}
				$sortie .= '<option value="'.$tlist[$i].'"'.$sel.'>'.$tlist[$i].'</option>';
			}
		}
		$sortie .= '</select>';
		if ($image == "") {
			$image = $tlist[1];
		}
		$sortie .= '&nbsp;<img src="images/topics/'.$image.'" name="myicon" align="middle">&nbsp;';
		$sortie .= '<a href="images/topics/ads_icons.php" onclick="window.open(\'images/topics/ads_icons.php\',\'catalogue\',\'menubar=no, status=no, scrollbars=yes, menubar=no, width=500, height=400\');return false" target="_blank">Voir catalogue</a>';
		$sortie .= '</td></tr>';
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._ADSCATSAVEBTN.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		//$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		//$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}

	function save_categorie($Id,$categorie,$image) {
		$cat = array("Id"=>$Id,"categorie"=>$categorie,"image"=>$image);
		$obj_cat = new BD_Ads();
		if (!$obj_cat->saveCat($cat)) {
			die("DB problem");
		}
		return true;
	}
	
	function delete_categorie($Id,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_Ads();
				if($obj_ads->delCat($Id)) {
					return list_categories();
				}
				else {
					die("DB problem");
				}
			}
			else {
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._ADSCONFIRMDELETECAT."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=ads&action=delete_cat&onglet=cats&Id='.$Id.'&confirm=y">';
				$sortie .= "["._ADSYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._ADSNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				return $sortie;
			}
		}
		return list_ads($page,$search_words,$cat);
	}

	function edit_citation($Id, $page,$search_words="") {
		global $prefix, $db;
		$fact = "";
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$result = $db->sql_query("SELECT Id,fact FROM ".$prefix."_chuck_norris_facts WHERE Id='".$Id."';");
			if (!$result) {
				die("DB problem");
			}
			list($Id,$fact) = $db->sql_fetchrow($result);
		}
		$sortie = '<form name="editfact" action="system.php?op=chuck&action=save&Id='.$Id.'" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<textarea name="fact" cols="50" rows="20">'.$fact.'</textarea>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._CHUCKSAVEBTN.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}

	function save_citation ($Id,$fact,$page,$search_words="") {
		global $prefix, $db;
		$fact = stripslashes($fact);
		$fact = str_replace("'","''",$fact);
		if ($Id == "-1") {
			$result = $db->sql_query("INSERT INTO ".$prefix."_chuck_norris_facts (fact) VALUES ('".$fact."') WHERE Id='".$Id."';");
			$page = "-1";
		}
		else {
			$result = $db->sql_query("UPDATE ".$prefix."_chuck_norris_facts SET fact='".$fact."' WHERE Id='".$Id."';");
		}
		if (!$result) {
			die("DB problem");
		}
		return list_citations($page,$search_words);
	}

	function delete_citation($Id,$page,$search_words,$confirm="n") {
		global $prefix, $db;
		if ($Id != "") {
			if ($confirm == "y"){
				if($db->sql_query("DELETE FROM ".$prefix."_chuck_norris_facts WHERE Id='".$Id."';")) {
					return list_citations($page,$search_words);
				}
				else {
					die("DB problem");
				}
			}
			else {
				if ($search_words != "") {
					$search_words = "&search_words=".urlencode($search_words);
				}
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._CHUCKCONFIRMDELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=chuck&action=delete&onglet=list&page='.$page.'&Id='.$Id.$search_words.'&confirm=y">';
				$sortie .= "["._CHUCKYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._CHUCKNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				return $sortie;
			}
		}
		return list_citations($page);
	}

	function import() {
		$sortie = '<form name="importfact" action="system.php?op=chuck&action=import_fact" method="POST" enctype="multipart/form-data">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<b>'._CHUCKIMPORTALERTS."</b>";
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= _CHUCKFILETOIMPORT.'<input type="file" name="file_facts" size="25">';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._CHUCKIMPORTBTN.'" name="valid">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}

	function import_fact() {
		global $prefix, $db;
		$chemin="catalog_repository";
		if ($_FILES["file_facts"]["name"] != "") {
			$nomDestination = $_FILES["file_facts"]["name"];
			if (is_uploaded_file($_FILES["file_facts"]["tmp_name"])) {
				$fichier = $chemin."/".$nomDestination;
				if (rename($_FILES["file_facts"]["tmp_name"],$fichier)) {
					chmod($fichier,0777);
					if ($db->sql_query("TRUNCATE ".$prefix."_chuck_norris_facts")) {
						$source = fopen($fichier,"r");
						$fact = "";
						while (!feof($source)) {
							$ligne = fgets($source);
							if ($ligne != "%\n") {
								$fact .= $ligne;
							}
							else {
								$fact = trim($fact,"\n");
								$fact = str_replace("'","''",$fact);
								if (!$db->sql_query("INSERT INTO ".$prefix."_chuck_norris_facts (fact) VALUES ('".$fact."');")) {
									die("DB problem");
								}
								$fact = "";
							}
						}
						unlink($fichier);
						return list_citations("1");
					}
					else {
						die("DB problem");
					}
				}
				else {
					die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
				}
			}
			else {
				die("Le fichier n'a pas t upload (trop gros ? droits ?)");
			}
		}
	}

	/**
	 * Renvoie l'interface d'administration de ce module.
	 *
	 * La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
	 * Elle ne retourne aucune valeur mais effectue rellement l'affichage.
	 */
	function process_ads(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$Id,$categorie,$image,$search_words,$object,$content,$date_saisie,$date_debut,$date_fin,$redacteur,$cat,$confirm;

		include("system/header_system.php");


		if (!isset($action) || $action == "") {
			$action = "list_cat";
		}
		if (!isset($page) || $page == "") {
			$page = "1";
		}

		$sortie = "";
		$operationOnglet = "";

		switch ($action) {
			case "list_cat" :
				$sortie = list_categories();
				$operationOnglet = _ADSLISTCAT;
				break;
			case "edit_cat" :
				$sortie = edit_categorie($Id);
				$operationOnglet = _ADSEDITCAT;
				break;
			case "save_cat" :
				if (save_categorie($Id,$categorie,$image)) {
					$sortie = list_categories();
				}
				$operationOnglet = _ADSLISTCAT;
				break;
			case "add_cat" :
				$sortie = edit_categorie($Id);
				$operationOnglet = _ADSNEWCAT;
				break;
			case "delete_cat" :
				$sortie = delete_categorie($Id,$confirm);
				$operationOnglet = _ADSLISTCAT;
				break;
			case "list_ads" :
				$sortie = list_ads($page,$search_words,$cat);
				$operationOnglet = _ADSLIST;
				break;
			case "edit_ads" :
				$sortie = edit_ads($Id,$page,$search_words);
				$operationOnglet = _ADSEDIT;
				break;
			case "save_ads" :
				if (save_ads($Id,$object,$content,$categorie,$date_saisie,$date_debut,$date_fin,$redacteur, $page,$search_words)) {
					$sortie = list_ads($page,$search_words,$cat);
				}
				$operationOnglet = _ADSLISTCAT;
				break;
			case "add_ads" :
				$sortie = edit_ads("",$page,$search_words);
				$operationOnglet = _ADSNEWADS;
				break;	
			case "search_ads" :
				$sortie = list_ads($page,$search_words,"");//sur la recherche par mot clef, la catgorie est neutralise
				$operationOnglet = _ADSLISTFOUND;
				break;
			case "delete_ads" :
				$sortie = delete_ads($Id,$page,$cat,$search_words,$confirm);
				$operationOnglet = _ADSLIST;
				break;
		}

		if (!isset($onglet)) {
			$onglet = "cats";
		}
		if ($onglet == "") {
			$onglet = "cats";
		}
		$ongletDef=array("cats"=> array( "text"=>_ADSONGLETCATS, "url"=>"system.php?action=list_cat&op=ads&onglet=cats"),
						"ads"=> array( "text"=>_ADSONGLETLIST, "url"=>"system.php?action=list_ads&op=ads&onglet=ads"));

		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_ads.css\">";
		GraphicAdmin(_ADSMODULE);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		OpenSysTable();
		echo $sortie;
		CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}

	/**
	 * Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
	 */
	switch ($op) {
		case "ads":
			process_ads();
			break;
	}
}
else {
	display_denied();
}
/*if (is_user($user)) {
 $user_data_bloc = base64_decode($user);
 $userdata_tab = explode(":", $user_data_bloc);
 $_SESSION["s_id_client"] = $userdata_tab[0];
 }
 else {
 $_SESSION["s_id_client"] = "-1";
 }*/

?>