<?php
/**
* Classes d'accs  la base de donnes pour la gestion du Livre d'Or.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleBoard
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2008, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

require_once("utils.php");

/**
* Classe d'accs  la base de donnes petites annonces pour isoler les fonctions.
* 
* @package becmsSimpleBoard
*/
class BD_Livre {
	var $My_SQL = array();
	
	function BD_Livre() {
		global $db,$prefix;
		$this->My_SQL["maBase"] = $db;
		$this->My_SQL["book"] = $prefix."_livre_or";
	}
	
/**
* Efface la fiche du commentaire dsigne
* @param integer $Id Identifiant ddu commentaire  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delCommentaire($Id) {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "";
			if ($Id != "-1" && $Id != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`Id`='".$Id."'";
			}
			$sql = "DELETE FROM `".$this->My_SQL["book"]."`".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Enregistre un commentaire
* 
* Si le commentaire existe dj, il est simplement modifi, sinon il est cr.
* @param array $commentaire Tableau contenant tous les champs du commentaire  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveCommentaire($commentaire) {
		$db=$this->My_SQL["maBase"];
		$commentaire = array_map(array('utilFuncs_SimpleBoard', 'conditionnertodb'), $commentaire);
		$list_champs = "";
		$list_valeurs = "";
		if ($commentaire["Id"] == "-1") {
			foreach($commentaire as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["book"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($commentaire as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["book"]."` SET ".$list_champs." WHERE `Id` = '".$commentaire["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie la liste des commentaires correspondants  la demande
* 
* Un tableau vide est renvoy si aucun commentaire n'est trouv.
* Si tous les critres sont vides,tous les commentairess sont renvoys.
* @param string $the_type Type de recherche (fiches/nbre de fiches) dont les valeurs sont "files" ou "count"
* @param integer $Id Identifiant du commentaire  retrouver
* @param string $redacteur Nom de la personne ayant ajout le commentaire.
* @param string $content Contenu  rechercher.
* @param integer $valid tat du commentaire : valide ou pas.
* @param string $du Date de dbut de recherche.
* @param string $au Date de fin de recherche.
* @param string $tri_par Ordre de tri des fiches renvoyes.
* @param string $limit Indication des enregistrements  retourner (index et nombre).
* @return array Retourne la liste des commentaires retrouvs
*/	
	function getCommentaire($the_type="files", $Id="" , $redacteur="", $content="", $valid="", $du="", $au="", $tri_par="",$limit="") {
		$db=$this->My_SQL["maBase"];
		
		$commentaire = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["book"]."`.`Id`='".$Id."'";
		}
		if ($du != "") {
			$du = utilFuncs_SimpleBoard::date2AMJ($du);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["book"]."`.`dateajout`>='".$du."'";
		}
		if ($au != "") {
			list($jour,$mois,$an) = explode("/",$au);
			$au = utilFuncs_SimpleBoard::date2AMJ(date("d/m/Y",mktime(0,0,0,$mois,$jour+1,$an)));
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["book"]."`.`dateajout`<'".$au."'";
		}
		if ($redacteur != "") {
			$redacteur = utilFuncs_SimpleBoard::conditionnertodb($redacteur);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["book"]."`.`auteur` LIKE '%".$redacteur."%'";
		}
		if ($content != "") {
			$content = utilFuncs_SimpleBoard::conditionnertodb($content);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "(";
			$cond .= "`".$this->My_SQL["book"]."`.`commentaire` LIKE '%".$content."%'";
			$cond .= " OR ";
			$cond .= "`".$this->My_SQL["book"]."`.`reponse` LIKE '%".$content."%'";
			$cond .= ")";
		}
		if ($valid !== "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			switch ($valid) {
				case true :
					$valid = "1";
					break;
				case false :
					$valid = "0";
					break;
			}
			$cond .= "`".$this->My_SQL["book"]."`.`visible` = '".$valid."'";
		}
		//echo  "//$cond//";
		if ($the_type == "files") {
			$oderby = "";
			if ($tri_par =="" || $tri_par =="date") {
				$oderby = " ORDER BY `".$this->My_SQL["book"]."`.`dateajout` DESC";
			}
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT `Id`,`nomprenom`,`email`,`commentaire`,`dateajout`,`auteur`,`reponse`,`visible` FROM `".$this->My_SQL["book"]."` ".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($commentaire, $ligneCourante);
				}
			}
			return $commentaire;
		}
		if ($the_type == "count") {
			$sql = "SELECT count(Id) AS nbre FROM `".$this->My_SQL["book"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
	
	function lastSaved() {
		$db=$this->My_SQL["maBase"];
		return $db->sql_nextid();
	}
}
?>