//Decode points
function decodeLine(encoded) {
    var len = encoded.length;
    var index = 0;
    var array = [];
    var lat = 0;
    var lng = 0;
    try
    {
        while (index < len) {
            var b;
            var shift = 0;
            var result = 0;
            do {
                  b = encoded.charCodeAt(index++) - 63;
                  result |= (b & 0x1f) << shift;
                  shift += 5;
            } while (b >= 0x20);
            var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
            lat += dlat;

            shift = 0;
            result = 0;
            do {
                  b = encoded.charCodeAt(index++) - 63;
                  result |= (b & 0x1f) << shift;
                  shift += 5;
            } while (b >= 0x20);
            var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
            lng += dlng;

            array.push(new google.maps.LatLng((lat * 1e-5), (lng * 1e-5)));
        }
    } catch(ex)
    {
        //error in encoding.
    }
    return array;
}

function getCoords(monpoint) {
	if (monpoint == null) {
		//document.fiche.coords.value = "";
		document.formfiche.latitude.value = "";
		document.formfiche.longitude.value = "";
	}
	else {
		//document.fiche.coords.value = monpoint.toString();
		document.formfiche.latitude.value = monpoint.lat();
		document.formfiche.longitude.value = monpoint.lng();
	}
}

function getMapValues(rublat,rublng,rubzoom) {
	rubzoom.value = map.getZoom();
	rublat.value = map.getCenter().lat();
	rublng.value = map.getCenter().lng();
}

function getZoomClic(rubzoom) {
	rubzoom.value = map.getZoom();
}

function action_preview() {
	fix_poly(document.formfiche);
}

function fix_poly(formulaire) {
	bordureCEdit = formulaire.bordure.value;
	visibiliteCEdit = formulaire.b_visibilite.value;
	epaisseurCEdit = formulaire.b_epaisseur.value;
	couleurCEdit = formulaire.b_couleur.value;
	opaciteCEdit = formulaire.b_opacite.value;
	afficherCBordure();
}

function afficherCBordure() {
	if (bordure != null) {
		bordure.setMap(null);
		//map.removeOverlay(bordure);
	}
	if (bordureCEdit != "") {
		bordure = new google.maps.Polyline({
			strokeColor: couleurCEdit,
			strokeWeight: epaisseurCEdit,
			strokeOpacity: opaciteCEdit,
			path: decodeLine(bordureCEdit),
			map: map
		});
		/*bordure = new GPolyline.fromEncoded({
			color: couleurCEdit,
			weight: epaisseurCEdit,
			opacity : opaciteCEdit,
			points: bordureCEdit,
			levels: visibiliteCEdit,
			numLevels: 3,
			zoomFactor: 12
		});
		map.addOverlay(bordure);*/
	}
}

function Gload() {
	//v�rification de l\'existence du div de la carte
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all["map"];
	}
	else {
		var objMenu = document.getElementById("map");
	}
	if (objMenu == null) {
		return false;
	}
		
    //traitements cartos
	if (window.JSON) {
        var iconLieuEdit = init_icone;
        var latitudeLieuEdit = init_latitude;
        var longitudeLieuEdit = init_longitude;
        var lieuEdit = init_lieu;
        
        var bordureEdit = init_b_bordure;
        var visibiliteEdit = init_b_visibilite;
        var couleurEdit2 = init_b_couleur;
        var epaisseurEdit = init_b_epaisseur;
        var opaciteEdit = init_b_opacite;

		var angleEdit = init_angle;
		var policeEdit = init_typo;
		var couleurEdit = init_couleur;
		var tailleEdit = init_taille;
		var tailleTextEdit = init_taille_text;

		if (latitudeLieuEdit != "" && longitudeLieuEdit != "") {
			var zoomclic = init_zoomclic;
			var zoominit = init_zoominit;
			var latitudeinit = latitudeLieuEdit;
			var longitudeinit = longitudeLieuEdit;
		}
		else {
			var zoomclic = 16;
			var zoominit = 8;
			var latitudeinit = 42.167475;
			var longitudeinit = 9.695434;
		}
		
		var mapOptions = {
			center: new google.maps.LatLng(latitudeinit, longitudeinit),
	        zoom: zoominit,
	        mapTypeId: google.maps.MapTypeId.HYBRID,
	        panControl: true,
			zoomControl: true,
			scaleControl: true,
			streetViewControl: false
	    };
		map = new google.maps.Map(document.getElementById("map"), mapOptions);
		
		/*var MapDiv = document.getElementById("map");
		var CopyrightDiv = MapDiv.firstChild.nextSibling;
		var CopyrightImg = MapDiv.firstChild.nextSibling.nextSibling;
		CopyrightDiv.style.display = "none"; 
		CopyrightImg.style.display = "none";*/
		
		google.maps.event.addListener(map, 'click', function(event) {
			map.panTo(event.latLng);
		});
		
		afficherCBordure();
	}
}

//diverses fonction de controles
var uneDate = new RegExp("^([0-9]{1,2})[/]([0-9]{1,2})[/]([0-9]{2}||[0-9]{4})$");
function isDate(dateStr) {

	var datePat = /^(\d{1,2})(\/|-)(\d{1,2})(\/|-)(\d{1,4})$/;
	var matchArray = dateStr.match(datePat); // is the format ok?
	
	if (matchArray == null) {
		//alert("Please enter date as either mm/dd/yyyy or mm-dd-yyyy.");
		return false;
	}
	
	month = matchArray[3]; // p@rse date into variables
	day = matchArray[1];
	year = matchArray[5];
	year = year/1;
	if (year < 10) {
		year = "0"+year;
	}
	if (year < 100) {
		year = "20"+year;
	}
	if (year.length < 4) {
		return false;
	}
	
	if (month < 1 || month > 12) { // check month range
		//alert("Month must be between 1 and 12.");
		return false;
	}
	
	if (day < 1 || day > 31) {
		//alert("Day must be between 1 and 31.");
		return false;
	}
	
	if ((month==4 || month==6 || month==9 || month==11) && day==31) {
		//alert("Month "+month+" doesn`t have 31 days!")
		return false;
	}
	
	if (month == 2) { // check for february 29th
		var isleap = (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0));
		if (day > 29 || (day==29 && !isleap)) {
			//alert("February " + year + " doesn`t have " + day + " days!");
			return false;
		}
	}
	return true; // date is valid
}

function formeDate(valeur) {
	if (valeur != "") {
		if (uneDate.test(valeur)) {
			var LeTab = uneDate.exec(valeur);
			jour = LeTab[1];
			mois = LeTab[2];
			an = LeTab[3];
			jour = eval(jour);
			mois = eval(mois) - 1;
			if (an.length == 2) {
				an = "20" + an;
			}
			an = eval(an);
			var unedate = new Date(an,mois,jour);
			var annee = unedate.getYear();
	   		if ((Math.abs(annee)+"").length < 4) {
	   			annee = annee + 1900;
	   		}
	   		return ((unedate.getDate() == jour) && (unedate.getMonth() == mois && (annee == an)));
	   		//return true;
		}
		else {
			return false;
		}
	}
	else {
		return true;
	}
}

function confirmer() {
	return confirm(lang_cartoconfirm);
}

function typepointInit(formulaire) {
	if (formulaire == null) {
		return true;
	}
	if (formulaire.istext == null || formulaire.isbordure == null) {
		return true;
	}
	
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenuBout = document.all["menupict"];
		var objCouleurBout = document.all["pick1101735855"];
		var objCouleurBordure = document.all["pick1101735856"];
	}
	else {
		var objMenuBout = document.getElementById("menupict");
		var objCouleurBout = document.getElementById("pick1101735855");
		var objCouleurBordure = document.getElementById("pick1101735856");
	}
	
	if (formulaire.istext.checked || formulaire.isbordure.checked) {
		//d�sactivation icone
		formulaire.icone.value="";
		formulaire.imgicone.src=init_chemin_icones+"/icns/empty.gif";
		objMenuBout.style.color="#CCCCCC";
	}
	if (!formulaire.istext.checked) {
		objCouleurBout.style.backgroundColor="#FFFFFF";
		formulaire.pick1101735855field.value="#FFFFFF";
	}
	if (!formulaire.isbordure.checked) {
		objCouleurBordure.style.backgroundColor="#FFFFFF";
		formulaire.pick1101735856field.value="#FFFFFF";
	}
}

function typepoint(formulaire) {
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenuBout = document.all["menupict"];
		var objCouleurBout = document.all["pick1101735855"];
		var objCouleurBordure = document.all["pick1101735856"];
	}
	else {
		var objMenuBout = document.getElementById("menupict");
		var objCouleurBout = document.getElementById("pick1101735855");
		var objCouleurBordure = document.getElementById("pick1101735856");
	}
	
	if (formulaire.istext.checked) {
		//activation texte
		formulaire.angle.disabled = false;
		formulaire.taille.disabled = false;
		formulaire.police.disabled = false;
		formulaire.police.value = "fonts/arial.ttf";
		objCouleurBout.style.backgroundColor="#FF0000";
		formulaire.pick1101735855field.value="#FF0000";
		istextEdit = "1";
	}
	else {
		//d�sactivation texte
		formulaire.angle.disabled = true;
		formulaire.angle.value="0";
		formulaire.taille.disabled = true;
		formulaire.taille.value="8";
		formulaire.police.disabled = true;
		formulaire.police.value = "";
		objCouleurBout.style.backgroundColor="#FFFFFF";
		formulaire.pick1101735855field.value="#FFFFFF";
		istextEdit = "0";
	}
	if (formulaire.isbordure.checked) {
		//activation polygone
		formulaire.b_epaisseur.disabled = false;
		formulaire.b_opacite.disabled = false;
		formulaire.bordure.disabled = false;
		formulaire.b_visibilite.disabled = false;
		//formulaire.latitude.disabled = true;
		//formulaire.longitude.disabled = true;
		formulaire.newpoly.disabled = false;
		objCouleurBordure.style.backgroundColor="#FF0000";
		formulaire.pick1101735856field.value="#FF0000";
		isbordureEdit = "1";
	}
	else {
		//d�sactivation polygone
		formulaire.b_epaisseur.disabled = true;
		formulaire.b_epaisseur.value="3";
		formulaire.b_opacite.disabled = true;
		formulaire.b_opacite.value="1";
		formulaire.bordure.disabled = true;
		formulaire.bordure.value = "";
		formulaire.b_visibilite.disabled = true;
		formulaire.b_visibilite.value = "";
		//formulaire.latitude.disabled = false;
		//formulaire.longitude.disabled = false;
		formulaire.newpoly.disabled = true;
		objCouleurBordure.style.backgroundColor="#FFFFFF";
		formulaire.pick1101735856field.value="#FFFFFF";
		isbordureEdit = "0";
	}
	if (!formulaire.istext.checked && !formulaire.isbordure.checked) {
		//activation icone
		objMenuBout.style.color="#0E18A3";
	}
	else {
		//d�sactivation icone
		formulaire.icone.value="";
		formulaire.imgicone.src=init_chemin_icones+"/icns/empty.gif";
		objMenuBout.style.color="#CCCCCC";
	}
	return true;
}

function fixPicto(picto) {
	document.images["imgicone"].src = picto;
	document.formfiche.icone.value = picto;
	hidePopUpZPop();
	return false;
}

function showPictos(id) {
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all["listic"+id];
		objMenu.style.display='block';
		var headerMenu = document.all["headeric"+id];
		headerMenu.style.backgroundImage='url(init_chemin_icones+"/icns/open2.gif")';
	}
	else {
		var objMenu = document.getElementById("listic"+id);
		objMenu.style.display='table-row';
		var headerMenu = document.getElementById("headeric"+id);
		headerMenu.style.backgroundImage='url(init_chemin_icones+"/icns/open2.gif")';
	}
}

function hidePictos(id) {
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all[id];
	}
	else {
		var objMenu = document.getElementById(id);
	}
	objMenu.style.visibility='hidden';
}

function hideAllPictos() {
	var compteur = 1;
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all["listic"+compteur];
		var headerMenu = document.all["headeric"+compteur];
	}
	else {
		var objMenu = document.getElementById("listic"+compteur);
		var headerMenu = document.getElementById("headeric"+compteur);
	}
	while (objMenu != null && headerMenu != null) {
		objMenu.style.display='none';
		headerMenu.style.backgroundImage='url(init_chemin_icones+"/icns/open.gif")';
		compteur++;
		if (ie) {
			objMenu = document.all["listic"+compteur];
			headerMenu = document.all["headeric"+compteur];
		}
		else {
			objMenu = document.getElementById("listic"+compteur);
			headerMenu = document.getElementById("headeric"+compteur);
		}
	}
}

function validForm2(formulaire) {
	if (formulaire.designation.value == "") {
		alert(lang_cartoverifnom);
		return false;
	}
	if (formulaire.latitude.value == "") {
		alert(lang_cartoveriflat);
		return false;
	}
	if (formulaire.longitude.value == "") {
		alert(lang_cartoveriflong);
		return false;
	}
	if (formulaire.zoominit.value == "") {
		alert(lang_cartoverifzoominit);
		return false;
	}
	/*if (formulaire.zoomclic.value == "") {
		alert("lang_cartoverifzoomclic");
		return false;
	}*/
	return true;
}

function open_new_poly() {
	window.open(init_chemin_icones+"/newpoly_carte.php","Polygone","menubar=no,status=no,scrollbars=no,menubar=no,resizable=no,height=480,width=640");
}