	//<![CDATA[
	
	//Decode points
	function decodeLine(encoded) {
		var len = encoded.length;
		var index = 0;
		var array = [];
		var lat = 0;
		var lng = 0;
		try
		{
			while (index < len) {
				var b;
				var shift = 0;
				var result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lat += dlat;
	
				shift = 0;
				result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lng += dlng;
	
				array.push(new GLatLng((lat * 1e-5), (lng * 1e-5)));
			}
		} catch(ex)
		{
			//error in encoding.
		}
		return array;
	}
	
	function theMapType(letype) {
		var type_carte = google.maps.MapTypeId.HYBRID;
		if (letype == "P") {
			type_carte = google.maps.MapTypeId.ROADMAP;
		}
		if (letype == "S") {
			type_carte = google.maps.MapTypeId.SATELLITE;
		}
		if (letype == "R") {
			type_carte = google.maps.MapTypeId.TERRAIN;
		}
		if (letype == "3D") {
			//type_carte = G_SATELLITE_3D_MAP;
			type_carte = google.maps.MapTypeId.TERRAIN;
		}
		return type_carte;
	}
	
	function is3D(letype) {
		return false;
		/*if (letype == G_SATELLITE_3D_MAP) {
			return true;
		}
		else {
			return false;
		}*/
	}
	
	function test3D(letype) {
		if (is3D(letype)) {
			type3D = true;
		}
		return type3D
	}
	
	function clearOverlays() {
		for (var i = 0; i < markers.length; i++) {
		   markers[i].setMap(null);
		}
		markers = [];
	}
	
	function GetMap(id,tailleforcee) {
		if (window.JSON) {
			if (cartes == null) {
		 		cartes = GetXMLSymbols(id);
		 	}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");
			var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
			var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
			latitudeinit = (options["latitudeinit"] && options["latitudeinit"] != "") ? options["latitudeinit"] : latitudeinit;
			longitudeinit = (options["longitudeinit"] && options["longitudeinit"] != "") ? options["longitudeinit"] : longitudeinit;
			options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
			options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
			options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
			options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
			options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
			options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
			options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
			options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
			options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
			options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
			options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
			options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
			taille_hv = getXMLvalue(racine_carte,"option_taille");
			if (tailleforcee) {
				taille_hv = tailleforcee;
			}
			var sep_taille=new RegExp("[/]+", "g");
			var map_hv = String(taille_hv).split(sep_taille);
			options["map_h"] = String(map_hv[0]) + "px";
			options["map_v"] = String(map_hv[1]) + "px";
			options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
			options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
			
			leDiv = document.getElementById("map");
			if (leDiv == null) {
				return false;
			}
			var reg_taille=new RegExp("([0-9]+)([/]+)([0-9])+", "g");
			if (String(taille_hv).match(reg_taille)) {
				leDiv.style.width = options["map_h"];
				leDiv.style.height = options["map_v"];
			}
			
			var type_map = theMapType(options["type_map"]);
			var centre = new google.maps.LatLng(latitudeinit, longitudeinit);
			var mapOptions = {
				center: centre,
		        zoom: zoominit,
		        mapTypeId: type_map,
		        panControl: false,
    			zoomControl: false,
    			scaleControl: true,
    			streetViewControl: true,
    			streetViewControlOptions: {
			        position: google.maps.ControlPosition.TOP_RIGHT
			    }
    			 
		    };
			map = new google.maps.Map(leDiv, mapOptions);
			map.setTilt(45);
			
			//ajout boutons zoom
			function ZoomPlusControl(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginBottom = "10px";
				container.style.marginLeft = "10px";
				var containerDiv = document.createElement("div");
				containerDiv.style.cursor = "pointer";
				container.appendChild(containerDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoomplus.png";
				image.title = "Augmenter le zoom de la carte";
				containerDiv.appendChild(image);
				google.maps.event.addDomListener(containerDiv, "click", function() {
			   		map.setZoom(map.getZoom()+1);
				});
				return container;
			}
			var ZoomPlusControlDiv = new ZoomPlusControl(map);
			ZoomPlusControlDiv.index = 1;
			map.controls[google.maps.ControlPosition.TOP_LEFT].push(ZoomPlusControlDiv);
			
			function ZoomMoinsControl(map) {
				var container = document.createElement("div");
				container.style.marginTop = "10px";
				container.style.marginBottom = "10px";
				container.style.marginLeft = "10px";
				var containerDiv = document.createElement("div");
				containerDiv.style.cursor = "pointer";
				container.appendChild(containerDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoommoins.png";
				image.title = "Augmenter le zoom de la carte";
				containerDiv.appendChild(image);
				google.maps.event.addDomListener(containerDiv, "click", function() {
			   		map.setZoom(map.getZoom()-1);
				});
				return container;
			}
			var ZoomMoinsControlDiv = new ZoomMoinsControl(map);
			ZoomMoinsControlDiv.index = 2;
			map.controls[google.maps.ControlPosition.TOP_LEFT].push(ZoomMoinsControlDiv);
			//fin boutons zoom
		
			//afficher les points du fonds de carte
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var cont_mess = "";
				if (fiche != "") {
					if (message != "") {
						var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
					}
				}
				else {
					if (message != "") {
						var link_mess = "";
					}
				}
				cont_mess = "<div style=\"overflow:hidden\"><div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div></div>";
				var infowindow = new google.maps.InfoWindow({
				      content: cont_mess,
				      maxWidth: 250
				});
				
				var echelle = map.getZoom();
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				
				largeur = (options["width_picto"] && options["width_picto"] != "") ? options["width_picto"] : taille;
				hauteur = (options["height_picto"] && options["height_picto"] != "") ? options["height_picto"] : taille;
				
				var anchor_picto;
				switch(options["anchor_picto"]) {
					case "top":
						anchor_picto = new google.maps.Point(largeur/2, hauteur);
						break;
					case "top_left":
						anchor_picto = new google.maps.Point(largeur, hauteur);
						break;
					case "top_right":
						anchor_picto = new google.maps.Point(0, hauteur);
						break;
					case "bottom":
						anchor_picto = new google.maps.Point(largeur/2, 0);
						break;
					case "bottom_left":
						anchor_picto = new google.maps.Point(largeur, 0);
						break;
					case "bottom_right":
						anchor_picto = new google.maps.Point(0, 0);
						break;
					case "left":
						anchor_picto = new google.maps.Point(largeur, hauteur/2);
						break;
					case "right":
						anchor_picto = new google.maps.Point(0, hauteur/2);
						break;
					case "center":
					default:
						anchor_picto = new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2));
						break;
				}
				
				var image = {
				    url: chemicone,
				    scaledSize: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: anchor_picto
				    //anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon: image
				});
				google.maps.event.addListener(marker, 'click', function() {
				    infowindow.open(map,marker);
				});
				return marker;
			}
			
			function afficheLieux() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						if (options["nolink"] == true) {
							fiche = "";
						}
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point,message,commentaire,chemicone,fiche,target);
						if (tempMark != null) {
							markers.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//afficher les textes du fonds de carte
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {
				if (test3D(map.getMapTypeId())) {
					return null;
				}
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				var image = {
				    url: racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte,
				    scaledSize: new google.maps.Size(largeur,hauteur),
				    origin: new google.maps.Point(0,0),
				    anchor: new google.maps.Point(Math.ceil(largeur/2), Math.ceil(hauteur/2))
				};
				var marker = new google.maps.Marker({
				      position: point,
				      map: map,
				      title: message,
				      icon: image
				});
				if (fiche != "") {
					google.maps.event.addListener(marker, 'click', function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			function afficheTextes() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"textes");
				if (points != null) {
					var point_courant = getXMLchild(points,"texte");
					while (point_courant) {
						var point = new google.maps.LatLng(eval(getXMLvalue(point_courant,"latitude_texte")), eval(getXMLvalue(point_courant,"longitude_texte")));
						var fiche = getXMLvalue(point_courant,"lien_texte");
						if (options["nolink"] == true) {
							fiche = "";
						}
						var target = getXMLvalue(point_courant,"cible_texte");
						var message = getXMLvalue(point_courant,"lieu_texte");
						var commentaire = getXMLvalue(point_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(point_courant,"dim_texte");
						var angletxt = getXMLvalue(point_courant,"angle_texte");
						var couleurtxt = getXMLvalue(point_courant,"couleur_texte");
						var typotxt = getXMLvalue(point_courant,"police_texte");
						var tailletxt = getXMLvalue(point_courant,"taille_texte");
						var tempMark = createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							markers.push(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//afficher polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				if (plein == "1") {
					var polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: 1,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: opacite
					  });
				}
				else {
					var polygone = new google.maps.Polygon({
					    paths: decodeLine(points),
					    strokeColor: couleur,
					    strokeOpacity: opacite,
					    strokeWeight: epaisseur,
					    fillColor: couleur,
					    fillOpacity: 0
					  });
				}
				if (fiche != "" && plein == "1") {
					google.maps.event.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				polygone.setMap(map);
				
				return polygone;
			}
			
			function afficherPolygones() {
				var polygones = getXMLchild(racine_carte,"polygones");
				if (polygones != null) {
					var point_courant = getXMLchild(polygones,"polygone");
					while (point_courant) {
						var couleur = getXMLvalue(point_courant,"couleur");
						var epaisseur = eval(getXMLvalue(point_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(point_courant,"opacite"));
						var points = getXMLvalue(point_courant,"polyencode");
						var visibilite = getXMLvalue(point_courant,"polyvisibilite");
						var fiche = getXMLvalue(point_courant,"lien_polygone");
						if (options["nolink"] == true) {
							fiche = "";
						}
						var target = getXMLvalue(point_courant,"cible_polygone");
						var plein = getXMLvalue(point_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							markers.push(tempZone);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}	
			
			//limites de commune
			function afficherCBordure() {
				return true; //pour neutraliser la fonction
				/*var bordure = new GPolyline.fromEncoded({
					color: getXMLvalue(racine_carte,"points_couleur"),
					weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
					opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
					points: getXMLvalue(racine_carte,"points_bordure"),
					levels: getXMLvalue(racine_carte,"points_visibilite"),
					numLevels: 3,
					zoomFactor: 12
				});
				map.addOverlay(bordure);*/
			}
			
			//action sur la carte
			/*GEvent.addListener(map, "click", function(marker, point) {
				if (marker == null) {
					map.panTo(point);
				}
			});*/
			
			
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			if (options["titre"]) {
				titrer(id,'titre')
			}
			if (options ["obs"]) {
				listLieux(id,'obs');
			}
			if (options["commentaire"]) {
				commenter(id,'commentaire');
			}
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre � jour.");
		}
	}
	
	function listLieux(id,zone_id) {
		if (options["obs"]) {
			if (cartes == null) {
				cartes = GetXMLSymbols(id);
			}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");	
			var points = getXMLchild(racine_carte,"points");
			if (points != null) {
				var point_courant = getXMLchild(points,"point");
				var observations = "";
				observations += "<table border=\"0\" cellpadding=\"0\" celspacing=\"0\" class=\"observations\">";
				observations += "<tr><th colspan=\"4\">D&eacute;tails</th></tr>";
				while (point_courant) {
					var message = getXMLvalue(point_courant,"lieu");
					var chemicone = getXMLvalue(point_courant,"picto");
					var commentaire = getXMLvalue(point_courant,"commentaire_point");
					var fiche = getXMLvalue(point_courant,"lien");
					var target = getXMLvalue(point_courant,"cible");
					
					observations += "<tr>";
					observations += "<td>";
					observations += "<img src=\""+chemicone+"\" />";
					observations += "</td><td>";
					observations += message;
					observations += "</td><td>";
					observations += commentaire;
					observations += "</td><td>";
					if (fiche != "") {
						observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
					}
					observations += "</td>";
					observations += "<tr>";
					
					point_courant = next_sibling(point_courant);
				}
			}
			var polygones = getXMLchild(racine_carte,"polygones");
			if (polygones != null) {
				var polygone_courant = getXMLchild(polygones,"polygone");
				while (polygone_courant) {
					var nom =  getXMLvalue(polygone_courant,"nom");
					var details =  getXMLvalue(polygone_courant,"details");
					var couleur = getXMLvalue(polygone_courant,"couleur");
					var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
					var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
					var points = getXMLvalue(polygone_courant,"polyencode");
					var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
					var plein = getXMLvalue(polygone_courant,"plein");
					var fiche = getXMLvalue(polygone_courant,"lien_polygone");
					var target = getXMLvalue(polygone_courant,"cible_polygone");
					
					observations += "<tr>";
						observations += "<td>";
						observations += "<div style=\"display: block; line-height: 1px; width: 30px; height: "+epaisseur+"; background-color: "+couleur+"; filter: alpha(opacity="+eval(opacite*100)+"); -moz-opacity: "+opacite+"; opacity: "+opacite+" \"></div>";
						observations += "</td><td>";
						observations += nom;
						observations += "</td><td>";
						observations += details;
						observations += "</td><td>";
						if (fiche != "") {
							observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
						}
						observations += "</td>";
						observations += "<tr>";
					polygone_courant = next_sibling(polygone_courant);
				}
			}
			observations += "</table>";
			
	  		var ie = false;
			if (document.all) {
				ie = true;
			}
			if (ie) {
				 var leDiv = document.all[zone_id];
			}
			else {
				var leDiv =  document.getElementById(zone_id);
			}
			if (leDiv == null) {
				return false;
			}
			leDiv.innerHTML = observations;
		}
	}
	
	function titrer(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var titre = getXMLvalue(racine_carte,"titre");
		
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = titre;
		document.title = document.title + " - " + titre;
	}
	
	function commenter(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var commentaire = getXMLvalue(racine_carte,"page_carte");
		if (commentaire == "") {
			commentaire = getXMLvalue(racine_carte,"commentaire");
		}
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = commentaire;
	}
	
	function GetXMLSymbols(id) {
		var sortie = "";
		if (id != "") {
			var idcarte = "&Idc="+id;
		}
		else {
			var idcarte = "";
		}
		var sources_cartes = "modules.php?name=SimpleCarto&sop=mapsXML"+idcarte;
		var cartes = GetAJAXData(sources_cartes);
		return cartes;
	}
	
	function calculeX(r){
	  return calculeOffset(r,"offsetLeft");
	}
	
	function calculeH(r){
	  return r["offsetHeight"];
	}
	
	function calculeL(r){
	  return r["offsetWidth"];
	}
	
	function calculeY(r){
	  return calculeOffset(r,"offsetTop")
	}
	function calculeOffset(element,attr){
	  var offset=0;
	  while(element){
	    offset+=element[attr];
	    element=element.offsetParent;
	  }
	  return offset;
	}
	
	var map = null;
	var markers = [];
	var cartes = null;
	var latitudeinit = 0;
	var longitudeinit = 0;
	var type3D = false;
	//]]>