//drag calendrier
document.onmousemove = mouseMove;
document.onmouseup   = mouseUp;

var dragObject  = null;
var mouseOffset = null;

function mouseCoords(ev){
	if(ev.pageX || ev.pageY){
		return {x:ev.pageX, y:ev.pageY};
	}
	return {
		x:ev.clientX + document.body.scrollLeft - document.body.clientLeft,
		y:ev.clientY + document.body.scrollTop  - document.body.clientTop
	};
}

function getMouseOffset(target, ev){
	ev = ev || window.event;

	var docPos    = getPosition(target);
	var mousePos  = mouseCoords(ev);
	return {x:mousePos.x - docPos.x, y:mousePos.y - docPos.y};
}

function getPosition(e){
	var left = 0;
	var top  = 0;

	while (e.offsetParent){
		left += e.offsetLeft;
		top  += e.offsetTop;
		e     = e.offsetParent;
	}

	left += e.offsetLeft;
	top  += e.offsetTop;

	return {x:left, y:top};
}

function mouseMove(ev){
	ev           = ev || window.event;
	var mousePos = mouseCoords(ev);

	if(dragObject){
		dragObject.style.position = 'absolute';
		dragObject.style.top      = mousePos.y - mouseOffset.y;
		dragObject.style.left     = mousePos.x - mouseOffset.x;
		
		fixed_position = true;
		
		return false;
	}
}
function mouseUp(){
	dragObject = null;
}

function makeDraggable(item){
	if(!item) return;
	item.onmousedown = function(ev){
		dragObject  = this;
		mouseOffset = getMouseOffset(this, ev);
		return false;
	}
}

//fonction de sortie
function writedate(valeur) {
	ztexteCal.value=valeur;
}
//calcul du calendrier
function buildCal(d, m, y) {
	var cM = "mainCal";
	var cH = "month";
	var cDW = "daysofweek";
	var cD = "days";
	var brdr = 1;

	var mn=['Janvier','F&eacute;vrier','Mars','Avril','Mai','Juin','Juillet','Ao&ucirc;t','Septembre','Octobre','Novembre','D&eacute;cembre'];
	var dim=[31,0,31,30,31,30,31,31,30,31,30,31];

	var oD = new Date(y, m-1, 1); //DD replaced line to fix date bug when current day is 31st
	oD.od=oD.getDay()+1; //DD replaced line to fix date bug when current day is 31st

	if (d != 0 && m != 0 && y != 0) {
		var todaydate=new Date(y, eval (m-1), d);
	}
	else {
		var todaydate=new Date();
	}
	var scanfortoday=(y==todaydate.getFullYear() && m==todaydate.getMonth()+1)? todaydate.getDate() : 0 //DD added

	dim[1]=(((oD.getFullYear()%100!=0)&&(oD.getFullYear()%4==0))||(oD.getFullYear()%400==0))?29:28;
	var t='<table class="'+cM+'" cols="7"><tr align="center">';
	t+='<td colspan="7" align="center" class="'+cH+'">';
	//t+= '<a href="#" onclick="hidePopUpCal();return false"><img src="modules/SimpleCatalog/lib/icns/close_cal.gif" hspace="2" vspace="2" border="0"></a>';
	var mm=m-1;
	var my = y;
	if (mm == 0) {
		mm = 12;
		var my = y-1;
	}
	mm = (mm < 10) ? "0"+mm : mm; 
	t+= '<a href="#" onclick="fillPopUpCal(\'0/'+ mm +'/'+ my +'\');return false">&lt;&lt;</a>';
	t+='<span class="mois">'+mn[m-1]+' '+y+'</span>';
	var mm= Math.floor(m) + 1;
	var my = y;
	if (mm == 13) {
		mm = 1;
		var my = Math.floor(y)+1;
	}
	mm = (mm < 10) ? "0"+mm : mm; 
	t+= '<a href="#" onclick="fillPopUpCal(\'0/'+ mm +'/'+ my +'\');return false">&gt;&gt;</a>';
	t+= '<a href="#" onclick="hidePopUpCal();return false"><img src="modules/SimpleCatalog/lib/icns/close_cal.gif" hspace="2" vspace="2" border="0"></a>';
	t+='</td></tr><tr align="center">';
	var s;
	for(s=0;s<7;s++) {
		t+='<td class="'+cDW+'">'+"LMMJVSD".substr(s,1)+'</td>';
	}
	t+='</tr>';
	var i;
	var j;
	var k;
	var ligne;
	var vide;
	for(j=0;j<=6;j++) {
		ligne='<tr align="center">';
		vide=true;
		for(k=1;k<=7;k++) {
			i= (j-1)*7+k;
			var x=((i-oD.od+1>=0)&&(i-oD.od+1<dim[m-1]))? i-oD.od+1+1 : '&nbsp;';
			xtest = x;
			if (x != "&nbsp;") {
				x = '<a href="" onclick="writedate(\''+x+'/'+m+'/'+y+'\');hidePopUpCal();return false">'+x+'</a>';
				vide=false;
			}
			if (xtest==scanfortoday) {
				ligne+='<td class="today">'+x+'</td>';
			}
			else {
				ligne+='<td class="'+cD+'">'+x+'</td>';
			}
		}
		i++;
		ligne+='</tr>';
		if (!vide) {
			t+=ligne;
		}
	}
	/*for(j=0;j<=6;j++) {
		t+='<tr align="center">';
		for(k=1;k<=7;k++) {
			i= (j-1)*7+k;

			var x=((i-oD.od+1>=0)&&(i-oD.od+1<dim[m-1]))? i-oD.od+1+1 : '&nbsp;';
			xtest = x;
			if (x != "&nbsp;") {
				x = '<a href="" onclick="dater(\''+x+'/'+m+'/'+y+'\');hidePopUpCal();return false">'+x+'</a>';
			}
			if (xtest==scanfortoday) {
				t+='<td class="today">'+x+'</td>';
			}
			else {
				t+='<td class="'+cD+'">'+x+'</td>';
			}
			//if(((i)%7==0)&&(i<36))t+='</tr><tr align="center">';
			
		}
		i++;
		if (!((i-oD.od+1>=0)&&(i-oD.od+1<dim[m-1]))) {
			//j=7;
		}
		t+='</tr>';
	}*/
	return t+='</table>';
}

//manipulation des pop-up

function boiteCal(x,y,w,h,bgc,id){
	var v=document.createElement('div');
	v.setAttribute('id',id); 
	v.style.position='absolute';
	v.style.left=x+'px';
	v.style.top=y+'px';
	if (w != "") v.style.width=w+'px';
	if (h != "") v.style.height=h+'px';
	if (bgc != "") v.style.backgroundColor=bgc;
	v.style.visibility='hidden';
	v.style.padding='0px 0px 0px 0px';
	v.style.zIndex=100;
	return v;
}

function popUpCal(x,y,w,h){
	if (x == "") x = 0;
	if (y == "") y = 0;
	var unepopup = new boiteCal(x,y,w,h,"","popupcal");
	document.body.appendChild(unepopup);
	return unepopup;
}

function newPopUpCal(){
	calendrier = popUpCal("","","","");
	makeDraggable(calendrier);
}

function showPopUpCal(champ){
	var x = calculeX(champ);
	var y =  eval(calculeY(champ) + calculeH(champ));
	fillPopUpCal(champ.value);
	if (!fixed_position) {
		calendrier.style.left=x+'px';
		calendrier.style.top=y+'px';
	}
	calendrier.style.visibility='visible';
	ztexteCal = champ;
}

function hidePopUpCal(){
	calendrier.style.visibility='hidden';
}

function fillPopUpCal(valeur){
	
	if (valeur == "") {
		var todaydate=new Date();
		var curday=todaydate.getDate();
		var curmonth=todaydate.getMonth()+1;
		var curyear=todaydate.getFullYear();
	}
	else {
		var tab = valeur.split("/");
		var curday=tab[0];
		var curmonth = tab[1];
		var curyear = tab[2];
	}
	calendrier.innerHTML=buildCal(curday, curmonth, curyear);
}

function calculeX(r){
  return calculeOffset(r,"offsetLeft")
}

function calculeH(r){
  return r["offsetHeight"];
}

function calculeL(r){
  return r["offsetWidth"];
}

function calculeY(r){
  return calculeOffset(r,"offsetTop")
}
function calculeOffset(element,attr){
  var offset=0;
  while(element){
    offset+=element[attr];
    element=element.offsetParent
  }
  return offset
}

var fixed_position = false;
var calendrier;
var ztexteCal;
//window.onload = newPopUpCal;