<?php
/**
 * Interfaage du module avec le Front Office du CMS.
 *
 * Son inclusion dans le Back Office est automatique, et son accs se trouve dans le menu "Modules"
 * @package becmsSimpleClient
 * @version 1.0
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

/**
 * Structure de la tables utilise par ce module
 * --
 * -- Structure de la table `becms_clients`
 * --
 *
 * CREATE TABLE `becms_clients` (
 *   `Id` int(11) NOT NULL auto_increment,
 *   `civilite` int(11) NOT NULL,
 *   `nom` varchar(100) collate latin1_general_ci NOT NULL,
 *   `prenom` varchar(100) collate latin1_general_ci NOT NULL,
 *   `societe` varchar(100) collate latin1_general_ci NOT NULL,
 *   `adresse` text collate latin1_general_ci NOT NULL,
 *   `codepostal` varchar(10) collate latin1_general_ci NOT NULL,
 *   `ville` varchar(100) collate latin1_general_ci NOT NULL,
 *   `pays` varchar(50) collate latin1_general_ci NOT NULL,
 *   `tel` varchar(30) collate latin1_general_ci NOT NULL,
 *   `fax` varchar(30) collate latin1_general_ci NOT NULL,
 *   `portable` varchar(30) collate latin1_general_ci NOT NULL,
 *   `email` varchar(100) collate latin1_general_ci NOT NULL,
 *   `services` text collate latin1_general_ci NOT NULL,
 *   `valide` smallint(6) NOT NULL,
 *   `codeclient` varchar(100) collate latin1_general_ci NOT NULL,
 *   `passwd` varchar(20) collate latin1_general_ci NOT NULL,
 *   `divers` text collate latin1_general_ci NOT NULL,
 *   `datenaissance` date NOT NULL,
 *   PRIMARY KEY  (`Id`),
 *   UNIQUE KEY `codeclient` (`codeclient`),
 *   KEY `nom` (`nom`,`prenom`),
 *   KEY `societe` (`societe`),
 *   KEY `datenaissance` (`datenaissance`)
 * ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='clients pour les services WEB 2.0 offerts par la plateforme' AUTO_INCREMENT=39 ;
 *
 */

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/lib/ba_displayclient.php");
require_once("modules/$module_name/lib/ba_adminclient.php");
require_once("modules/$module_name/lib/g_params.php");

$My_SQL["maBase"] = $db;

/**
 * Affiche la liste des clients enregistrs.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function displayListClient($My_SQL,$vars_mod) {
	$objetClient = new displayClients();
	include ('header.php');
	echo $objetClient->get_list_clients($My_SQL,$vars_mod);
	include ('footer.php');

}

/**
 * Affiche les donnes publiques d'un client.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function displayOneClient($My_SQL,$vars_mod) {
	$objetClient = new displayClients();
	include ('header.php');
	echo $objetClient->get_one_client($My_SQL,$vars_mod);
	include ('footer.php');
}

/**
 * Valide un compte client.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function validOneClient($My_SQL,$vars_mod) {
	$objetClient = new displayClients();
	include ('header.php');
	echo $objetClient->valid_one_client($My_SQL,$vars_mod);
	include ('footer.php');
}

/**
 * Permet de d'ouvrir un compte client.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function setClient($My_SQL,$vars_mod) {
	$objetClient = new displayClients();
	include ('header.php');
	if ($_SESSION["id_client"] != "" && $_SESSION["id_client"]!="-1") {
		$clef = array("Id"=>$_SESSION["id_client"],"codeclient"=>"","passwd"=>"");
		echo $objetClient->affiche_accueil_client($My_SQL,$vars_mod,$clef);
	}
	else {
		echo $objetClient->set_client($My_SQL,$vars_mod,$erreur);
	}
	include ('footer.php');
}



/**
 * Affiche la page d'accueil du compte client.
 *
 * Ce dialogue permet au client d'ouvrir son compte client et de vrifier ses coordonnes ou d'accder  sa page personelle.
 * Cette fonction fixe galement le compte client en cours.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $clef Identifiant du client en cours : Id ou login/password.
 */
function getClient($My_SQL,$vars_mod,$clef) {
	$objetClient = new displayClients();
	include ('header.php');
	if ($objetClient->sgbd->exists_client($My_SQL,$clef)) {
		$clients = $objetClient->sgbd->getClients($My_SQL,$clef);
		$client = $clients[0];
		$clef["Id"] = $client["Id"];
		//echo $objetClient->display_identity_client($vars_mod,$_SESSION["nom_client"]);
		if ($client["valide"] == "1") {
			echo $objetClient->affiche_accueil_client($My_SQL,$vars_mod,$clef);
		}
		else {
			echo $objetClient->set_client($My_SQL,$vars_mod,_CLIENTClIENTDEACTIVATED);
		}
	}
	else {
		echo $objetClient->set_client($My_SQL,$vars_mod,_CLIENTClIENTBADPASS);
	}
	//echo $objetClient->catalog_bar($My_SQL,$vars_mod);
	//$bardef=array("print"=>"modules.php?".$objetClient->getVars("sop")."&sop=print_client",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid","top"=>"#top" );
	//buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Edite le compte client.
 *
 * Affiche le formulaire de modification d'un compte client existant.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $clef Identifiant du client en cours : Id ou login/password.
 */
function editClient($My_SQL,$vars_mod,$clef) {
	$objetClient = new displayClients();
	include ('header.php');
	//echo $objetClient->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	$clef["Id"] = $_SESSION["id_client"];
	$clef["codeclient"] = "";
	$clef["passwd"] = "";
	if ($objetClient->sgbd->exists_client($My_SQL,$clef)) {
		$clients = $objetClient->sgbd->getClients($My_SQL,$clef);
		$new_client =  $clients[0];
		$alertecode = "";
		$erreur = "";
		echo $objetClient->edit_client($My_SQL,$vars_mod,$new_client,$erreur,$alertecode,"save_client");
	}
	else {
		echo "Erreur : client introuvable";
	}
	//echo $objetClient->catalog_bar($My_SQL,$vars_mod);
	//$bardef=array("print"=>"modules.php?".$objetClient->getVars("sop")."&sop=print_client",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid","top"=>"#top" );
	//buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Enregistre le compte client.
 *
 * Si le compte est modifi, les modifications sont enregistres, aucun nouveau compte n'est cr.
 * Un e-mail de confirmation de de modifcation de compte est envoy au client si son adresse e-mail est valide.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $new_client Tableau contenant les informations de la fiche client.
 */
function saveClient($My_SQL,$vars_mod,$new_client) {
	$objetClient = new displayClients();
	include ('header.php');
	//echo $objetClient->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetClient->save_client($My_SQL,$vars_mod,$new_client);
	//echo $objetClient->catalog_bar($My_SQL,$vars_mod);
	//$bardef=array("print"=>"modules.php?".$objetClient->getVars("sop")."&sop=print_client",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	//"top"=>"#top" );
	//buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Ferme le compte client courant.
 *
 * Un e-mail de confirmation de de modifcation de compte est envoy au client si son adresse e-mail est valide.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $new_client Tableau contenant les informations de la fiche client.
 */
function closeClient() {
	$_SESSION["id_client"] = "";
	Header("Location: index.php");
}

/**
 * Permet au client de rcuprer son identifiant et son son password.
 *
 * Ce dialogue permet au client de saisir son e-mail.
 * Si celui -ci est reconnu dans les comptes clients, son identifiant et son son password sont expdis.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function getIds($My_SQL,$vars_mod) {
	$objetClient = new displayClients();
	include ('header.php');
	//echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetClient->get_Ids($My_SQL,$vars_mod);
	//echo $objetClient->catalog_bar($My_SQL,$vars_mod);
	/*$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print",
	 //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	 //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	 "top"=>"#top" );
	 buttonBar($bardef, "align");*/
	include ('footer.php');
}

/**
 * Permet au client de rcuprer son identifiant et son son password.
 *
 * Si les identifiants sont retrouvs, il sont expdis, sinon le formulaire de saisie d'e-mail est  nouveau propos.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function sendIds($My_SQL,$vars_mod) {
	$objetClient = new displayClients();
	include ('header.php');
	//echo $objetClient->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetClient->send_Ids($My_SQL,$vars_mod);
	//echo $objetClient->catalog_bar($My_SQL,$vars_mod);
	/*$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print",
	 //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	 //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	 "top"=>"#top" );
	 buttonBar($bardef, "align");*/
	include ('footer.php');
}

/**
 * Permet de d'afficher une page en vrifiant que le compte est ouvert.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function affiche_page_client($My_SQL,$vars_mod) {
	$objetClient = new displayClients();
	include ('header.php');
	if ($_SESSION["id_client"] != "" && $_SESSION["id_client"]!="-1") {
		echo $objetClient->affiche_page_client($My_SQL,$vars_mod);
	}
	else {
		echo $objetClient->set_client($My_SQL,$vars_mod,$erreur);
	}
	include ('footer.php');
}

/**
 * Affiche les donnes publiques d'un client  destination de l'imprimante.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @todo Cette fonction n'est pas utilisable. Il faut l'crire pour le module client.
 * @todo Il y en a deux  faire : une pour la liste, et une pour la fiche.
 */
function printClient($My_SQL,$vars_mod) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $module_name;

	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}

	if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
		$stylecarto = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
	}
	else {
		$stylecarto = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
	}

	echo "
    <html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\">
    <head>
    <title>$sitename</title>
    <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
    <LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
	".$stylecarto."
	</head>
    <body bgcolor=\"#FFFFFF\" text=\"#000000\">
    <table border=\"0\"><tr><td>
    <table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
    <table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>
    <div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"><span class=\"title\">$title_section</span></div>
    <div class=\"zprint\">
    ";
	$objetCarte = new displayCartos();
	echo $objetCarte->get_map($My_SQL,$vars_mod,$keymap);
	echo "
    </div>
    </td></tr></table></td></tr></table>
    
    <div class=\"printFooter\">
    <div class=\"siteName\">
    "._COMESFROM." $sitename<br>
    <a href=\"$racine\">$racine</a>
    </div>
    <div class=\"pageURL\">
    "._THEURL."<br>
    <a href=\"$racine/modules.php?name=SimpleCarto&sop=printMap&amp;".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."\">$racine/modules.php?name=SimpleCarto&sop=printMap&amp;".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."</a>
    </div>
    </div>
    </td></tr></table>
    </body>
    </html>
    ";
}

/**
 * Affiche la liste des clients sous format texte.
 *
 * @return string Texte contenant la liste de tous les clients
 */
function sendTEXT() {
	//require_once("modules/$module_name/connector_lib.php");
	require_once("connector_lib.php");
	$connectClient = new clientconnector();
	$sortie = $connectClient->getClientsTEXT();
	//header("Content-Type: text/plain; charset=iso-8859-1");
	header("Content-Type: application/x-octet-stream");
	header ('Content-Disposition: attachment; filename="Clients au '.date("d-m-Y").'.xls"');
	echo $sortie;
}

/**
 * Expdie la liste des clients sous format Excel.
 *
 * @return string Texte contenant la liste de tous les clients
 */
function sendEXCEL($typexport, $group="") {
	//require_once("modules/$module_name/connector_lib.php");
	require_once("connector_lib.php");
	$connectClient = new clientconnector();
	$sortie = $connectClient->getClientsEXCEL($typexport,$group);
	header("Content-Type: application/x-msexcel; name=\"example-demo.xls\"");
	header('Content-Disposition: inline; filename="Clients au '.date("d-m-Y").'.xls"');
	$fh=fopen($sortie, "rb");
	fpassthru($fh);
	unlink($sortie);
}

if (is_admin($admin)) {
	/**
	 * Appel des fonctions en fonction du paramtre $sop.
	 */
	switch($sop) {
		case "display":
			displayOneClient($My_SQL,$vars_mod);
			break;
		case "validclient":
			validOneClient($My_SQL,$vars_mod);
			break;
		case "set_client":
			setClient($My_SQL,$vars_mod);
			break;
		case "get_client":
			getClient($My_SQL,$vars_mod,$clef);
			break;
		case "edit_client":
			editClient($My_SQL,$vars_mod,$clef);
			break;
		case "save_client":
			saveClient($My_SQL,$vars_mod,$new_client);
			break;
		case "close_client":
			closeClient();
			break;
		case "get_ids":
			getIds($My_SQL,$vars_mod);
			break;
		case "send_ids":
			sendIds($My_SQL,$vars_mod);
			break;
		case "list":
			displayListClient($My_SQL,$vars_mod);
			break;
		case "display_client_page":
			affiche_page_client($My_SQL,$vars_mod);
			break;
		case "print":
			printClient($My_SQL,$vars_mod);
			break;
		case "sendTXT":
			sendTEXT();
			break;
		case "sendEXCEL":
			sendEXCEL($typexport,$group);
			break;
		default:
			displayListClient($My_SQL,$vars_mod);
			//echo "Aucune opration  effectuer n'a t choisie'";
			break;
	}
}
else {
	switch($sop) {
		case "validclient":
			validOneClient($My_SQL,$vars_mod);
			break;
		case "set_client":
			setClient($My_SQL,$vars_mod);
			break;
		case "get_client":
			getClient($My_SQL,$vars_mod,$clef);
			break;
		case "edit_client":
			editClient($My_SQL,$vars_mod,$clef);
			break;
		case "save_client":
			saveClient($My_SQL,$vars_mod,$new_client);
			break;
		case "close_client":
			closeClient();
			break;
		case "display_client_page":
			affiche_page_client($My_SQL,$vars_mod);
			break;
		case "get_ids":
			getIds($My_SQL,$vars_mod);
			break;
		case "send_ids":
			sendIds($My_SQL,$vars_mod);
			break;
		default:
			include ('header.php');
			echo _CLIENTNOTADMIN;
			include ('footer.php');
			break;
	}
}

session_write_close();

?>