<?php
/**
* Fichier d'initialisation des variables pour le module de gestion des clients.
* 
* @package becmsSimpleClient 
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @version 0.1
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

require_once("g_db.php");

if (!isset($fromBoard)) {
	$fromBoard = false;
}
if (!$fromBoard) {
	$db_session = new BD_Sessions_client(); 
	session_set_save_handler(array(&$db_session,"open"), 
							 array(&$db_session,"close"), 
							 array(&$db_session,"read"), 
							 array(&$db_session,"write"), 
							 array(&$db_session,"destroy"), 
							 array(&$db_session,"gc"));
	session_start();
}

/**
 * $var array $My_SQL Tableau contenant les paramtres d'accs  la base de donnes
 */
if (!isset($My_SQL)) {
	$My_SQL = array();
}
$My_SQL["clients"] = "becms_clients";
$My_SQL["pays"] = "becms_commerce_pays";

/**
 *Quelques variables d'initialisation
 */
$cheminIcones = "modules/$module_name/lib/icns";
$cheminModule = "modules/$module_name/";

/**
 * $var array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
$vars_mod = array(
	"page_en_cours"=>"page_en_cours",
	"action" => "act",
	"id_client" => "Id",
	"cheminIcones" => $cheminIcones,
	"cheminModule" => $cheminModule,
	"confirm" => "ok",
	"tri" => "order",
	"code_confirm"=>"codeconfirm",
	//"vars_mail" => array("from" => "webmaster@arobase.fr", "nom" => "Vincent RUIZ Commercant"),
	"vars_mail" => array("from" => $clientmailadmin, "nom" => $clientmailname),
	"mailclient" => "email",
	"article_client" => "art",
	"lien_inscription" => "modules.php?name=Sections&sop=viewarticle&artid=54"
);

if (!isset($GLOBALS[$vars_mod["action"]])) {
	$vars_mod[$vars_mod["action"]] = "list";
}
else {
	$vars_mod[$vars_mod["action"]] = $GLOBALS[$vars_mod["action"]];
}

if (!isset($GLOBALS[$vars_mod["article_client"]])) {
	$vars_mod[$vars_mod["article_client"]] = "";
}
else {
	$vars_mod[$vars_mod["article_client"]] = $GLOBALS[$vars_mod["article_client"]];
}

if (!isset($GLOBALS[$vars_mod["id_client"]])) {
	$vars_mod[$vars_mod["id_client"]] = -1;
}
else {
	$vars_mod[$vars_mod["id_client"]] = $GLOBALS[$vars_mod["id_client"]];
}

if (!isset($GLOBALS[$vars_mod["confirm"]])) {
	$vars_mod[$vars_mod["confirm"]] = "n";
}
else {
	$vars_mod[$vars_mod["confirm"]] = $GLOBALS[$vars_mod["confirm"]];
}
if (!isset($GLOBALS[$vars_mod["tri"]])) {
	$vars_mod[$vars_mod["tri"]] = "";
}
else {
	$vars_mod[$vars_mod["tri"]] = $GLOBALS[$vars_mod["tri"]];
}
if (!isset($GLOBALS[$vars_mod["code_confirm"]])) {
	$vars_mod[$vars_mod["code_confirm"]] = "";
}
else {
	$vars_mod[$vars_mod["code_confirm"]] = $GLOBALS[$vars_mod["code_confirm"]];
}
if (!isset($GLOBALS[$vars_mod["mailclient"]])) {
	$vars_mod[$vars_mod["mailclient"]] = "";
}
else {
	$vars_mod[$vars_mod["mailclient"]] = $GLOBALS[$vars_mod["mailclient"]];
}

/**
 * Paramtres de recherche par dfaut.
 */
$crit_find_article = array(
"page_en_cours"=>testinit_client($GLOBALS[$vars_mod["page_en_cours"]],"1"),
"articles_par_page"=>testinit_client($GLOBALS["articles_par_page"],"10"),
"groupe"=>testinit_client($GLOBALS["group"],"")
);

function testinit_client(&$valeur,$valeurinit="") {
	if (!isset($valeur)) {
		$valeur = $valeurinit;
	}
	return $valeur;
}

$vars_mod["sortie_action"] = "";
$new_client = array(
"Id"=>testinit_client($GLOBALS["Id"],"-1"),
"civilite"=>testinit_client($GLOBALS["civilite"]),
"nom"=>testinit_client($GLOBALS["nom"]),
"prenom"=>testinit_client($GLOBALS["prenom"]),
"societe"=>testinit_client($GLOBALS["societe"]),
"adresse"=>testinit_client($GLOBALS["adresse"]),
"codepostal"=>testinit_client($GLOBALS["codepostal"]),
"ville"=>testinit_client($GLOBALS["ville"]),
"pays"=>testinit_client($GLOBALS["pays"]),
"tel"=>testinit_client($GLOBALS["tel"]),
"fax"=>testinit_client($GLOBALS["fax"]),
"portable"=>testinit_client($GLOBALS["portable"]),
"email"=>testinit_client($GLOBALS["email"]),
"services"=>testinit_client($GLOBALS["services"]),
"codeclient"=>testinit_client($GLOBALS["codeclient"]),
"passwd"=>testinit_client($GLOBALS["passwd"]),
"valide"=>testinit_client($GLOBALS["valide"],"0"),
"divers"=>testinit_client($GLOBALS["divers"]),
"datenaissance"=>testinit_client(adminClients::date2AMJ($GLOBALS["datenaissance"]),"0000-00-00"),
"categorie"=>testinit_client($GLOBALS["categorie"]),
"codeconfirm"=>testinit_client($GLOBALS["codeconfirm"],md5(time())),
"pageperso"=>testinit_client($GLOBALS["pageperso"]),
"newsletter"=>testinit_client($GLOBALS["newsletter"],"0")
);

$clef = array(
"Id"=>testinit_client($GLOBALS["Id"],"-1"),
"codeclient"=>testinit_client($GLOBALS["codeclient"]),
"passwd"=>testinit_client($GLOBALS["passwd"])
);

?>