<?php 
if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/utils.php");

function rrmdir($dir) {
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                if (is_dir($dir."/".$object))
                    rrmdir($dir."/".$object);
                    else
                        unlink($dir."/".$object);
            }
        }
        rmdir($dir);
    }
}

function view_biblio($options) {
    global $Default_Theme;
    
    $sortie = '';
    
    foreach($options as $key=>$val) {
        $options[$key] = stripslashes($val);
    }
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_biblio_view.php')) {
        $titre = trim($options["titre"],"%?_|*+ \t\n\r\0\x0B");
        $mot_cle = trim($options["mot_clef"],"%?_|*+ \t\n\r\0\x0B");
        $espece = trim($options["espece"],"%?_|*+ \t\n\r\0\x0B");
        $auteur = trim($options["auteur"],"%?_|*+ \t\n\r\0\x0B");
        $espece_nom_scientifique = trim($options["espece_nom_scientifique"],"%?_|*+ \t\n\r\0\x0B");
        $type_doc = trim($options["type_doc"],"%?_|*+ \t\n\r\0\x0B");
        $site_nom = trim($options["site_nom"],"%?_|*+ \t\n\r\0\x0B");
        
        require_once('themes/'.$Default_Theme.'/pattern_biblio_view.php');
    }
    else {
        //  faire...  
        $sortie = "<p>A faire...</p>";
    }
    
    $sortie = utilFuncs_simpleBiblioExt::conditionnerMobile($sortie);
    
    include("header_mobile.php");
    echo $sortie;
    include ('footer_mobile.php');
}

function view_form_obs_aliem() {
    global $Default_Theme;
    global $idtaxon;
    
    $sortie = '';
    
    $nom = "";
    $prenom = "";
    $tel = "";
    $courriel = "";
    $profil = "";
    $espece2 = "";
    $latitude = "";
    $longitude = "";
    if (!isset($idtaxon)) {
        $idtaxon = "";
    }
    
    if (isset($_COOKIE['old_obs_aliem'])) {
        $old_obs = $_COOKIE['old_obs_aliem'];
        $obs = unserialize(stripslashes($old_obs));
    
        $nom = $obs["nom"];
        $prenom = $obs["prenom"];
        $telephone = $obs["tel"];
        $courriel = $obs["courriel"];
        $profil = $obs["profil"];
        /*if ($idtaxon == "") {
            $idtaxon = $obs["espece"];
        }*/
        $espece2 = $obs["espece2"];
        $latitude = $obs["latitude"];
        $longitude = $obs["longitude"];
    }
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_data_ext_form_aliem.php')) {
        $espece = $idtaxon;
        
        
        /*$titre = trim($obs["titre"],"%?_|*+ \t\n\r\0\x0B");
        $mot_cle = trim($obs["mot_clef"],"%?_|*+ \t\n\r\0\x0B");
        $espece = trim($obs["espece"],"%?_|*+ \t\n\r\0\x0B");
        $auteur = trim($obs["auteur"],"%?_|*+ \t\n\r\0\x0B");*/
        require_once('themes/'.$Default_Theme.'/pattern_data_ext_form_aliem.php');
    }
    else {
        //  faire...
        $sortie = "<p>A faire...</p>";
    }
    
    $sortie = utilFuncs_simpleBiblioExt::conditionnerMobile($sortie);
    
    include("header_mobile.php");
    echo $sortie;
    include ('footer_mobile.php');
}

function send_form_obs_aliem($obs) {
    global $Default_Theme;
    
    foreach($obs as $key=>$val) {
        $obs[$key] = stripslashes($val);
    }
    
    $sortie = '';
    /* mmorisation infos rcurrentes */
    $memo = array(
        "nom" => trim($obs["nom"]),
        "prenom" => trim($obs["prenom"]),
        "tel" => trim($obs["tel"]),
        "courriel" => trim($obs["courriel"]),
        "profil" => $obs["profil"],
        //"espece" => $obs["espece"],
        "espece2" => trim($obs["espece2"]),
        "latitude" => trim($obs["latitude"]),
        "longitude" => trim($obs["longitude"])
    );
    $memo = mon_utf8_decode($memo);
    setcookie("old_obs_aliem", serialize($memo), time() + (10 * 365 * 24 * 60 * 60));
    
    $fichiers = json_decode($obs["newfiles"],true);
    $fichiers = mon_utf8_decode($fichiers["files"]);
    
    unset($obs["newfiles"]);
    
    $obs["photos"] = $fichiers;
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_data_ext_send_form_aliem.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_data_ext_send_form_aliem.php');
    }
    else {
        //  faire...
        $sortie = "<p>A faire...</p>";
    }
    
    $sortie = utilFuncs_simpleBiblioExt::conditionnerMobile($sortie);
    
    include("header_mobile.php");
    echo $sortie;
    include ('footer_mobile.php');
}

function send_app_obs_aliem() {
    global $Default_Theme;
    
    $r = new stdClass();
    
    $sortie = false;
    
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == "443") ? "https://" : "http://";
    $nukeurl = $protocol.$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" && $_SERVER["SERVER_PORT"]!="443" ? ":".$_SERVER["SERVER_PORT"] : "");
    
    $photo_url = "";
    $newname = "catalog_repository/app_aliem/".uniqid();
    if (isset($_FILES["file"]) && is_uploaded_file($_FILES["file"]["tmp_name"])) {
        $extension = strtolower(strrchr($_FILES["file"]["name"],'.'));
        if (rename($_FILES["file"]["tmp_name"],$newname.$extension)) {
            chmod($newname.$extension,0777);
            $photo_url = $nukeurl."/".$newname.$extension;
        }
    }
    
    $nom = stripslashes($_POST["nom"]);
    $prenom = stripslashes($_POST["prenom"]);
    $numtel = stripslashes($_POST["numTel"]);
    $email = stripslashes($_POST["mail"]);
    
    
    $espece = stripslashes($_POST["espece"]);
    $longitude = stripslashes($_POST["longitude"]);
    $latitude = stripslashes($_POST["latitude"]);
    $tel_id = stripslashes($_POST["tel_id"]);
    $decription = stripslashes($_POST["description"]);
    $id_data = stripslashes($_POST["uniqueId"]);
    
    $obs = array(
        "nom" => $nom,
        "prenom" => $prenom,
        "tel" => $numtel,
        "courriel" => $email,
        "espece" => $espece,
        "date_debut" => date("Y-m-d"),
//        "nombre" => 1,
        "latitude" => $latitude,
        "longitude" => $longitude,
        "id_tel" => $tel_id,
        "id_data" => $id_data,
        "credits" => $nom.(($nom != "" && $prenom != "")  ? " " : "").$prenom,
//        "status_donnee" => "publique",
        "remarques" => $decription,
        "photos" => array(
                        array(
                            "name" => basename($photo_url),
                            "titre" => "",
                            "url" => $photo_url
                        )
        )
    );
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_data_ext_send_app_aliem.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_data_ext_send_app_aliem.php');
        
        $s = new stdClass();
        
        $s->nom = $nom;
        $s->prenom = $prenom;
        $s->numtel = $numtel;
        $s->email = $email;
        $s->espece = $espece;
        $s->latitude = $latitude;
        $s->longitude = $longitude;
        $s->tel_id = $tel_id;
        $s->unique_id = $id_data;
        $s->description = $decription;
        $s->photo_url = $photo_url;
        
        $t = new stdClass();
        
        if ($sortie) {
            //transfert ok
            $t->ok = true;
            $t->comment = utf8_encode("Tout va bien");
        }
        else {
            //transfert pas ok
            $t->ok = false;
            $t->comment = utf8_encode("Il y a un problme d'envoi au serveur GAA");
        }
        
        $r->error = "";
        $r->input = $s;
        $r->output = $t;
    }
    else {
        //  faire...
        $sortie = "<p>A faire...</p>";
    }
        
    $reponse = json_encode($r);
    
    if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                die();
    }
    
    header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
    echo $reponse;

    die();
}

function get_zones_protec() {
    global $Default_Theme;
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_data_ext_get_zones_protec.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_data_ext_get_zones_protec.php');
    }
    else {
        $sortie = "{}";
    }
    
    if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                die();
    }
    
    header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
    echo $sortie;
    
    die();
}

function get_especes_inv($list) {
    global $Default_Theme;
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_data_ext_get_especes_inv.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_data_ext_get_especes_inv.php');
    }
    else {
        $sortie = "{}";
    }
    
    if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                die();
    }
    
    header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
    echo $sortie;
    
    die();
}

function get_especes($ids_taxon) {
    global $Default_Theme;
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_data_ext_get_especes.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_data_ext_get_especes.php');
    }
    else {
        $sortie = "{}";
    }
    
    if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                die();
    }
    
    header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
    echo $sortie;
    
    die();
}

function get_scores() {
    global $Default_Theme;
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_data_ext_get_scores.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_data_ext_get_scores.php');
    }
    else {
        $sortie = "{}";
    }
    
    if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                die();
    }
    
    header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
    echo $sortie;
    
    die();
}

function get_signs($id_tel) {
    global $Default_Theme;
    
    if (file_exists('themes/'.$Default_Theme.'/pattern_data_ext_get_signs.php')) {
        require_once('themes/'.$Default_Theme.'/pattern_data_ext_get_signs.php');
    }
    else {
        $sortie = "{}";
    }
    
    if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                die();
    }
    
    header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
    echo $sortie;
    
    die();
}

global $options, $obs, $ids_taxon, $id_tel, $list;

switch($op) {
    case "get_zones_protec":
        get_zones_protec();
        break;
    case "get_especes_inv":
        get_especes_inv($list);
        break;
    case "get_especes":
        get_especes($ids_taxon);
        break;
    case "get_scores":
        get_scores();
        break;
    case "get_signs":
        get_signs($id_tel);
        break;
    case "form_obs_aliem":
        view_form_obs_aliem();
        break;
    case "send_obs_aliem":
        send_form_obs_aliem($obs);
        break;
    case "send_app_obs_aliem":
        send_app_obs_aliem();
        break;
    case "get_biblio_ext":
    default:
        view_biblio($options);
        break;
}

?>