<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2006 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (preg_match("#connector_class.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }
require_once("modules/SimpleGlossaire/lib_db.php");
global $Default_Theme;
if (file_exists("themes/".$Default_Theme."/pattern_gloss_insert.php")) {
    require_once("themes/".$Default_Theme."/pattern_gloss_insert.php");
}
else {
    function get_gloss_insert($items) {
        if (count($items) > 0) {
            if (preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
                $script = "mobiles.php";
            }
            else {
                $script = "index.php.php";
            }
            $obj_gloss = new BD_Gloss();
            $glossaire = '<h2>Glossaire</h2>';
            $liste = array();
            foreach ($items as $Id) {
                $item = $obj_gloss->getTerme("files", $Id);
                $liste[] = '<li><a href="'.$script.'.php?name=SimpleGlossaire&gid='.$item[0]["Id"].'#'.$item[0]["Id"].'">'.ucfirst($item[0]["terme"]).'</a></li>';
            }
            //$glossaire .= '<p>'.join(" &bull; ", $liste).'</p>';
            $glossaire .= '<ul>'.join(" &bull; ", $liste).'</ul>';
            return $glossaire;
        }
        else {
            return "";
        }
    }
}

/**
 * connector class to Page module.
 * Provide Page api for over modules
 * @author stephan Acquatella
 */
class glossconnector {

	var $db; // db Object
	var $prefix; // db prefix
	var $itemsFound;

	/**
	 * Constructor
	 */
	function __construct(){
		// get data from framwork
		global $db, $prefix;
		$this->db=$db;
		$this->prefix=$prefix;
		$this->itemsFound = array();
	}

	function checkTermsInText($texte){
	    $termsInText = array();
	    $radicaux = array();
	    $obj_gloss = new BD_Gloss();
	    $termes = $obj_gloss->getTerme();
	    foreach ($termes as $unterme) {
	        $temp = explode(",", $unterme["radical"]);
	        foreach($temp as $radical) {
	            if (trim($radical) != "") {
	               $radicaux[trim($radical)] = $unterme["Id"];
	            }
	        }
	    }
	    foreach($radicaux as $radical=>$Id) {
	        if (preg_match("#".$radical."#im", $texte)) {
	            $termsInText[] = $Id;
	        }
	    }
	    $termsInText = array_unique($termsInText, SORT_NUMERIC);
	    
	    $this->itemsFound = $termsInText;
	    
	    return (count($termsInText) > 0);
	}
	
	function getGlossInsert() {
	    return get_gloss_insert($this->itemsFound);
	}
}

?>