<?php
/**
* Classes d'accs  la base de donnes pour la gestion des petites annonces.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleAnnonce
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

require_once("utils.php");

/**
* Classe d'accs  la base de donnes petites annonces pour isoler les fonctions.
* 
* @package becmsSimpleAnnonce
*/
class BD_Members {
	var $My_SQL = array();
	
	function BD_Members() {
		global $db,$prefix;
		$this->My_SQL["maBase"] = $db;
		$this->My_SQL["members"] = $prefix."_users";
		$this->My_SQL["domain"] = $prefix."_users_domain";
		$this->My_SQL["link"] = $prefix."_users_link";
		$this->My_SQL["membersTemp"] = $prefix."_users_temp";
		$this->My_SQL["linkTemp"] = $prefix."_users_link_temp";
		$this->My_SQL["coords"] = $prefix."_users_geocoords";
	}
	
/**
* Efface la fiche de l'offre d'emploi dsigne
* @param integer $Id Identifiant de l'annonce  supprimer
* @param integer $cat Identifiant de la catgorie dont toutes les annonces doivent tre supprimes
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delMember($Id) {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "";
			if ($Id != "-1" && $Id != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`uid`='".$Id."'";
			}
			$sql = "SELECT adh_logo FROM `".$this->My_SQL["members"]."`".$cond.";";
			$resultat = $db->sql_query($sql);
			if ($db->sql_numrows($resultat) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultat)) {
					if ($ligneCourante["adh_logo"] != "") {
						unlink($ligneCourante["adh_logo"]);
					}
				}
			}
			$sql = "DELETE FROM `".$this->My_SQL["members"]."`".$cond.";";
			return $db->sql_query($sql) && $this->delLinks($Id) && $this->delCoords($Id);
		}
		else {
			return false;
		}
	}
	
/**
* Enregistre une fiche offre d'emploi
* 
* Si l'annonce existe dj, elle est simplement modifie, sinon elle est cre.
* @param array $ads Tableau contenant tous les champs de l'annonce  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveMember($member) {
		$db=$this->My_SQL["maBase"];
		
		$member = array_map(array('utilFuncs_simpleMembers', 'conditionnertodb'), $member);
		$list_champs = "";
		$list_valeurs = "";
		if ($member["uid"] == "-1" || $member["uid"] == "" || $member["uid"] == "0") {
			foreach($member as $key => $value) {
				if ($key != "uid") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["members"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			if ($member["adh_logo"] != "") {
				$sql = "SELECT adh_logo FROM `".$this->My_SQL["members"]."` WHERE `uid` = '".$member["uid"]."';";
				$resultat = $db->sql_query($sql);
				if ($db->sql_numrows($resultat) != 0) {
					if ($ligneCourante = $db->sql_fetchrow($resultat)) {
						if ($ligneCourante["adh_logo"] != $member["adh_logo"] && $ligneCourante["adh_logo"] != "") {
							unlink($ligneCourante["adh_logo"]);
						}
					}
					else {
						die ("problme de db 465");
					}
				}
			}
			foreach($member as $key => $value) {
				if ($key != "uid") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["members"]."` SET ".$list_champs." WHERE `uid` = '".$member["uid"]."';";
		}
		return $db->sql_query($sql);
	}
	
	function saveMemberTemp($member) {
		$db=$this->My_SQL["maBase"];
		$member = array_map(array('utilFuncs_simpleMembers', 'conditionnertodb'), $member);
		$list_champs = "";
		$list_valeurs = "";
		//if ($member["uid"] == "-1" || $member["uid"] == "") {
			foreach($member as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
			$sql = "INSERT INTO `".$this->My_SQL["membersTemp"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		/*}
		else {
			foreach($member as $key => $value) {
				if ($key != "uid") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["membersTemp"]."` SET ".$list_champs." WHERE `uid` = '".$member["uid"]."';";
		}*/
		return $db->sql_query($sql);
	}
	
	function delMemberTemp($Id="",$uid="") {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "" || $uid != "") {
			$cond = "";
			if ($Id != "-1" && $Id != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`user_id`='".$Id."'";
			}
			if ($uid != "-1" && $uid != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`uid`='".$uid."'";
			}
			$sql = "SELECT adh_logo,uid FROM `".$this->My_SQL["membersTemp"]."`".$cond.";";
			$resultat = $db->sql_query($sql);
			if ($db->sql_numrows($resultat) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultat)) {
					if ($ligneCourante["uid"] != "0") {
						$sql2 = "SELECT uid,adh_logo FROM ".$this->My_SQL["members"]." WHERE uid='".$ligneCourante["uid"]."'";
						$resultat2 = $db->sql_query($sql2);
						if ($db->sql_numrows($resultat) != 0) {
							if ($ligneCourante2 = $db->sql_fetchrow($resultat2)) {
								if ($ligneCourante["adh_logo"] != "" && $ligneCourante["adh_logo"] != $ligneCourante2["adh_logo"]) {
									unlink($ligneCourante["adh_logo"]);
								}		
							}
						}
					}
					else {
						if ($ligneCourante["adh_logo"] != "") {
							$sql2 = "SELECT count(uid) as nbre FROM ".$this->My_SQL["members"]." WHERE adh_logo='".$ligneCourante["adh_logo"]."'";
							$resultat2 = $db->sql_query($sql2);
							if ($db->sql_numrows($resultat2) != 0) {
								if ($ligneCourante2 = $db->sql_fetchrow($resultat2)) {
									if ($ligneCourante2["nbre"] == 0) {
										unlink($ligneCourante["adh_logo"]);
									}
								}
							}	
						}
					}
				}
			}
			$sql = "DELETE FROM `".$this->My_SQL["membersTemp"]."`".$cond.";";
			return $db->sql_query($sql) && $this->delLinksTemp($Id,"",$uid);
		}
		else {
			return false;
		}
	}
	
	function getMembersTemp($Id="") {
		$db=$this->My_SQL["maBase"];	
		$members = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["membersTemp"]."`.`user_id`='".$Id."'";
		}
		$oderby = " ORDER BY `".$this->My_SQL["membersTemp"]."`.`user_id` ASC";
		$resultatRecherche = $db->sql_query("SELECT * FROM `".$this->My_SQL["membersTemp"]."` ".$cond.$oderby.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($members, $ligneCourante);
			}
		}
		return $members;
	}
	
	function saveLinkTemp($theLink) {
		$db=$this->My_SQL["maBase"];
		$list_champs = "";
		$list_valeurs = "";
		foreach($theLink as $key => $value) {
			if ($key != "Id") {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
		}
		$sql = "INSERT INTO `".$this->My_SQL["linkTemp"]."` (".$list_champs.")";
		$sql .= " VALUES (".$list_valeurs.");";
		return $db->sql_query($sql);
	}
	
	function delLinksTemp($id_user = "", $id_domain="", $uid="") {
		$db=$this->My_SQL["maBase"];
		
		if ($id_user != "" || $id_domain != "" || $uid != "") {
			if ($id_user != "") {
				$cond = "`id_user` = ".$id_user;
			}
			if ($id_domain != "") {
				$cond = ($cond != "") ? " AND" : "";
				$cond = "`id_domain` = ".$id_domain;
			}
			if ($uid != "") {
				$cond = ($cond != "") ? " AND" : "";
				$cond = "`uid` = ".$uid;
			}
			$sql = "DELETE FROM `".$this->My_SQL["linkTemp"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
	function getLinksTemp($id_user="") {
		$db=$this->My_SQL["maBase"];	
		$links = array();
		$cond = "";
		if ($id_user != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["linkTemp"]."`.`id_user`='".$id_user."'";
		}
		/*if ($id_domain != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["link"]."`.`id_domain`='".$id_domain."'";
		}*/
		$resultatRecherche = $db->sql_query("SELECT * FROM `".$this->My_SQL["linkTemp"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($links, $ligneCourante);
			}
		}
		return $links;
	}
	
	function get_id_new_member() {
		$db=$this->My_SQL["maBase"];
		return $db->sql_nextid();
	}
	
	function delLinks($id_user = "", $id_domain="") {
		$db=$this->My_SQL["maBase"];
		
		if ($id_user != "" || $id_domain != "") {
			if ($id_user != "") {
				$cond = "`id_user` = ".$id_user;
			}
			if ($id_domain != "") {
				$cond = ($cond != "") ? " AND" : "";
				$cond = "`id_domain` = ".$id_domain;
			}
			$sql = "DELETE FROM `".$this->My_SQL["link"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
	function saveLink($theLink) {
		$db=$this->My_SQL["maBase"];
		$list_champs = "";
		$list_valeurs = "";
		//if ($theLink["Id"] == "-1" || $theLink["Id"] == "") {
			foreach($theLink as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["link"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		/*}
		else {
			foreach($theLink as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["link"]."` SET ".$list_champs." WHERE `Id` = '".$theLink["Id"]."';";
		}*/
		return $db->sql_query($sql);
	}
	
	function getLinks($the_type="files", $id_user="", $id_domain="",$tri_par="", $limit="") {
		$db=$this->My_SQL["maBase"];	
		$links = array();
		$cond = "";
		if ($id_user != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["link"]."`.`id_user`='".$id_user."'";
		}
		if ($id_domain != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["link"]."`.`id_domain`='".$id_domain."'";
		}
		if ($the_type == "files") {
			$oderby = "";
			if ($tri_par =="") {
				$oderby = " ORDER BY `".$this->My_SQL["link"]."`.`id_domain` ASC";
			}
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT * FROM `".$this->My_SQL["link"]."` ".$cond.$oderby.$limit.";");
			//$resultatRecherche = $db->sql_query("SELECT ".$this->My_SQL["link"].".*, ".$this->My_SQL["domain"].".code FROM `".$this->My_SQL["link"]."` INNER JOIN `".$this->My_SQL["domain"]."` ON ".$this->My_SQL["domain"].".Id=".$this->My_SQL["link"].".id_domain".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($links, $ligneCourante);
				}
			}
			return $links;
		}
		if ($the_type == "count") {
			$sql = "SELECT count(id_user) AS nbre FROM `".$this->My_SQL["link"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
/**
* Renvoie la liste des offres d'emploi correspondants  la demande
* 
* Un tableau vide est renvoy si aucune annonce n'est trouve. Si tous les critres sont vides,toutes les annonces sont renvoyes.
* @param string $the_type Type de recherche (fiches/nbre de fiches) dont les valeurs sont "files" ou "count"
* @param integer $Id Identifiant de l'annonce  retrouver
* @param integer $categorie Identifiant pour limiter la recherche  cette catgorie.
* @param date $le Date du jour de la recherche.
* @param string $redateur Utilisateur ayant rdig l'annonce.
* @param string $content Texte contenu dans le sujet ou le texte de l'annonce.
* @param string $tri_par Nom de la rubrique servant au tri.
* @param string $limit Indication des enregistrements  retourner (index et nombre).
* @return array Retourne la liste des clients retrouvs
*/	
	function getMembers($the_type="files", $Id="", $initiale="", $domaine="", $libre="", $tri_par="", $limit="") {
		$db=$this->My_SQL["maBase"];	
		$members = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["members"]."`.`uid`='".$Id."'";
		}
		/*if ($categorie != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["members"]."`.`categorie`='".$categorie."'";
		}
		if ($content != "") {
			$content = utilFuncs_simpleJob::conditionnertodb($content);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= " (`".$this->My_SQL["members"]."`.`intitule` LIKE '%".$content."%' OR `".$this->My_SQL["members"]."`.`description` LIKE '%".$content."%')";
		}*/
		if ($the_type == "files") {
			$oderby = "";
			if ($tri_par =="" || $tri_par == "uname") {
				$oderby = " ORDER BY `".$this->My_SQL["members"]."`.`uname` ASC";
			}
			if ($tri_par =="nom") {
				$oderby = " ORDER BY `".$this->My_SQL["members"]."`.`adh_nom1` ASC";
			}
			if ($tri_par =="ville") {
				$oderby = " ORDER BY `".$this->My_SQL["members"]."`.`adh_ville` ASC";
			}
			if ($tri_par =="entreprise") {
				$oderby = " ORDER BY `".$this->My_SQL["members"]."`.`adh_entreprise` ASC";
			}
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT * FROM `".$this->My_SQL["members"]."` ".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($members, $ligneCourante);
				}
			}
			return $members;
		}
		if ($the_type == "count") {
			$sql = "SELECT count(Id) AS nbre FROM `".$this->My_SQL["members"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
	
	function getDoms($Id="",$id_user="",$code="") {
	$db=$this->My_SQL["maBase"];
		$ads = array();
		$cond = "";
		$fromlink = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["domain"]."`.`Id`='".$Id."'";
		}
		if ($code != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["domain"]."`.`code`='".$code."'";
		}
		if ($id_user != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["link"]."`.`id_user`='".$id_user."'";
			$fromlink = " INNER JOIN ".$this->My_SQL["link"]." ON ".$this->My_SQL["link"]."`id_domain`=".$this->My_SQL["domain"]."`Id` ";
		}
		$oderby = " ORDER BY `".$this->My_SQL["domain"]."`.`code` ASC";
		$resultatRecherche = $db->sql_query("SELECT `".$this->My_SQL["domain"]."`.`Id`,`".$this->My_SQL["domain"]."`.`code`,`".$this->My_SQL["domain"]."`.`label`,`".$this->My_SQL["domain"]."`.`description` FROM `".$this->My_SQL["domain"]."` ".$fromlink.$cond.$oderby.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($ads, $ligneCourante);
			}
		}
		return $ads;
	}
		
	function delDom($Id) {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$this->My_SQL["domain"]."` WHERE ".$cond.";";
			//$cond2 = "`id_domain` = ".$Id;
			//$sql2 = "DELETE FROM `".$this->My_SQL["link"]."` WHERE ".$cond2.";";
			//return $db->sql_query($sql) && $db->sql_query($sql2);
			return $db->sql_query($sql) && $this->delLinks("",$Id) && $this->delLinksTemp("",$Id);
		}
		else {
			return false;
		}
	}
	
	function saveDom($dom) {
		$db=$this->My_SQL["maBase"];
		$dom = array_map(array('utilFuncs_simpleMembers', 'conditionnertodb'), $dom);
		$list_champs = "";
		$list_valeurs = "";
		if ($dom["Id"] == "-1") {
			foreach($dom as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["domain"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($dom as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["domain"]."` SET ".$list_champs." WHERE `Id` = '".$dom["Id"]."';";
		}
		return $db->sql_query($sql);
	}

	function delCoords($uid="") {
		$db=$this->My_SQL["maBase"];
		$cond = "";
		if ($uid != "") {
			/*if ($id_user != "") {
				$cond = "`id_user` = ".$id_user;
			}
			if ($id_domain != "") {
				$cond = ($cond != "") ? " AND" : "";
				$cond = "`id_domain` = ".$id_domain;
			}*/
			if ($uid != "") {
				$cond = ($cond != "") ? " AND" : "";
				$cond = "`id_user` = ".$uid;
			}
			$sql = "DELETE FROM `".$this->My_SQL["coords"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
	function saveCoord($theCoord) {
		$db=$this->My_SQL["maBase"];
		$list_champs = "";
		$list_valeurs = "";
		foreach($theCoord as $key => $value) {
			if ($key != "Id") {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
		}
		$sql = "INSERT INTO `".$this->My_SQL["coords"]."` (".$list_champs.")";
		$sql .= " VALUES (".$list_valeurs.");";
		return $db->sql_query($sql);
	}
	
	function getCoords($the_type="files", $id_user="", $tri_par="", $limit="") {
		$db=$this->My_SQL["maBase"];	
		$coords = array();
		$cond = "";
		if ($id_user != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["coords"]."`.`id_user`='".$id_user."'";
		}
		if ($the_type == "files") {
			$oderby = "";
			if ($tri_par =="") {
				$oderby = "";
			}
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT * FROM `".$this->My_SQL["coords"]."` INNER JOIN `".$this->My_SQL["members"]."` ON `".$this->My_SQL["members"]."`.uid=`".$this->My_SQL["coords"]."`.id_user".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($coords, $ligneCourante);
				}
			}
			return $coords;
		}
		if ($the_type == "count") {
			$sql = "SELECT count(Id) AS nbre FROM `".$this->My_SQL["coords"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
}	
?>