<?php

/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
setPath(_TXT_User,0);
setPath(_EDITUSERS,1);

require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function list_index($nbreFiches, $page, $ligne_par_page,$letter) {
		$nboites = 5;
		$letterurl = ($letter != "" ) ? "&letter=".$letter : ""; 
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._SMEMBERSFOUND."\"".$letter."\"";
			$indexPages .= _SMEMBERSPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"system.php?op=members&action=list_members&page=$min".$letterurl."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"system.php?op=members&action=list_members&page=$i".$letterurl."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"system.php?op=members&action=list_members&page=$max".$letterurl."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _SMEMBERSNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}


/*********************************************************/
/* Users Functions                                       */
/*********************************************************/

/**
 * displayUsers()
 *
 *
 *
 */
function edit_member2($letter="A") {
	global $admin,$ongletDef;
	
	$sortie = userlist($letter,$sortby, $page);
	
	$sortie .= "<center><form method=\"post\" action=\"system.php\">"
		."<b>"._NICKNAME.": </b> <input type=\"text\" name=\"chng_uid\" size=\"20\">\n"
		."<select name=\"op\">"
		."<option value=\"modifyUser\">"._MODIFY."</option>\n"
		."<option value=\"delUser\">"._DELETE."</option></select>\n"
		."<input type=\"submit\" value=\""._OK."\"></form></center>";

	$sortie .= "<br>";
	$sortie .= "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	$sortie .= "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+]"._ADDUSER."</a>";
	$sortie .= "<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n";
	$sortie .= "<center><font class=\"option\"><b>"._ADDUSER."</b></font><br><br>"
		."<form action=\"system.php\" method=\"post\">"
		."<table class=systemTab>"
        ."<tr><td width=\"100\">"._NICKNAME."</td>"
        ."<td><input type=\"text\" name=\"add_uname\" size=\"30\" maxlength=\"25\"> <font class=\"tiny\">"._REQUIRED."</font></td></tr>"
        ."<tr><td>"._NAME."</td>"
        ."<td><input type=\"text\" name=\"add_name\" size=\"30\" maxlength=\"50\"></td></tr>"
        ."<tr><td>"._EMAIL."</td>"
        ."<td><input type=\"text\" name=\"add_email\" size=\"30\" maxlength=\"60\"> <font class=\"tiny\">"._REQUIRED."</font></td></tr>"
        ."<tr><td>"._FAKEEMAIL."</td>"
        ."<td><input type=\"text\" name=\"add_femail\" size=\"30\" maxlength=\"60\"></td></tr>"
        ."<tr><td>"._URL."</td>"
        ."<td><input type=\"text\" name=\"add_url\" size=\"30\" maxlength=\"60\"></td></tr>"
        ."<tr><td>"._ICQ."</td>"
        ."<td><input type=\"text\" name=\"add_user_icq\" size=\"20\" maxlength=\"20\"></td></tr>"
        ."<tr><td>"._AIM."</td>"
        ."<td><input type=\"text\" name=\"add_user_aim\" size=\"20\" maxlength=\"20\"></td></tr>"
        ."<tr><td>"._YIM."</td>"
        ."<td><input type=\"text\" name=\"add_user_yim\" size=\"20\" maxlength=\"20\"></td></tr>"
        ."<tr><td>"._MSNM."</td>"
        ."<td><input type=\"text\" name=\"add_user_msnm\" size=\"20\" maxlength=\"20\"></td></tr>"
        ."<tr><td>"._LOCATION."</td>"
        ."<td><input type=\"text\" name=\"add_user_from\" size=\"25\" maxlength=\"60\"></td></tr>"
        ."<tr><td>"._OCCUPATION."</td>"
        ."<td><input type=\"text\" name=\"add_user_occ\" size=\"25\" maxlength=\"60\"></td></tr>"
        ."<tr><td>"._INTERESTS."</td>"
        ."<td><input type=\"text\" name=\"add_user_intrest\" size=\"25\" maxlength=\"255\"></td></tr>"
        ."<tr><td>"._POINT."</td>"
        ."<td><input type=\"text\" name=\"add_user_points\" size=\"4\" maxlength=\"255\"></td></tr>"
		."<tr><td>"._OPTION."</td>"
        ."<td><input type=\"checkbox\" name=\"add_user_viewemail\" VALUE=\"1\"> "._ALLOWUSERS."</td></tr>"
		."<tr><td>"._NEWSLETTER."</td>"
		."<td><input type=\"radio\" name=\"add_newsletter\" value=\"1\">"._YES."<br>"
		."<input type=\"radio\" name=\"add_newsletter\" value=\"0\" checked>"._NO."</td></tr>"
        ."<tr><td>"._SIGNATURE."</td>"
        ."<td><textarea name=\"add_user_sig\" rows=\"6\" cols=\"45\"></textarea></td></tr>"
        ."<tr><td>"._PASSWORD."</td>"
        ."<td><input type=\"password\" name=\"add_pass\" size=\"12\" maxlength=\"12\"> <font class=\"tiny\">"._REQUIRED."</font></td></tr>"
        ."<input type=\"hidden\" name=\"add_avatar\" value=\"blank.gif\">"
        ."<input type=\"hidden\" name=\"op\" value=\"addUser\">"
        ."<tr><td><input type=\"submit\" value=\""._ADDUSERBUT."\"></td></tr>"
        ."</table>"
		."</form></center>";
	$sortie .= "</div>";
	return $sortie;
}
/**
 * modifyUser()
 *
 *
 */
 function modifyUser($chng_user) {
    global $user_prefix, $db, $ongletDef;
    include("system/header_system.php");
    GraphicAdmin();

    OpenOngletTable();
	displayOngletBar("admin",_USERUPDATE.": <i>$chng_user</i>",$ongletDef);
    $result = $db->sql_query("select uid, uname, name, url, email, femail, user_icq, user_aim, user_yim, user_msnm, user_from, user_occ, user_interests, user_viewemail, user_avatar, user_sig, pass, newsletter, points from ".$user_prefix."_users where uid='$chng_user' or uname='$chng_user'");
    if($db->sql_numrows($result) > 0) {
        list($chng_uid, $chng_uname, $chng_name, $chng_url, $chng_email, $chng_femail, $chng_user_icq, $chng_user_aim, $chng_user_yim, $chng_user_msnm, $chng_user_from, $chng_user_occ, $chng_user_intrest, $chng_user_viewemail, $chng_avatar, $chng_user_sig, $chng_pass, $chng_newsletter, $chng_user_points) = $db->sql_fetchrow($result);
	//echo "<center><font class=\"option\"><b>"._USERUPDATE.": <i>$chng_user</i></b></font></center>"
	echo "<center><form action=\"system.php\" method=\"post\">"
	    ."<table class=systemTab>"
	    ."<tr><td>"._USERID."</td>"
	    ."<td><b>$chng_uid</b></td></tr>"
	    ."<tr><td>"._NICKNAME."</td>"
	    ."<td><input type=\"text\" name=\"chng_uname\" value=\"$chng_uname\"> <font class=\"tiny\">"._REQUIRED."</font></td></tr>"
	    ."<tr><td>"._NAME."</td>"
	    ."<td><input type=\"text\" name=\"chng_name\" value=\"$chng_name\"></td></tr>"
	    ."<tr><td>"._URL."</td>"
	    ."<td><input type=\"text\" name=\"chng_url\" value=\"$chng_url\" size=\"30\" maxlength=\"60\"></td></tr>"
	    ."<tr><td>"._EMAIL."</td>"
	    ."<td><input type=\"text\" name=\"chng_email\" value=\"$chng_email\" size=\"30\" maxlength=\"60\"> <font class=\"tiny\">"._REQUIRED."</font></td></tr>"
	    ."<tr><td>"._FAKEEMAIL."</td>"
	    ."<td><input type=\"text\" name=\"chng_femail\" value=\"$chng_femail\" size=\"30\" maxlength=\"60\"></td></tr>"
	    ."<tr><td>"._ICQ."</td>"
	    ."<td><input type=\"text\" name=\"chng_user_icq\" value=\"$chng_user_icq\" size=\"20\" maxlength=\"20\"></td></tr>"
	    ."<tr><td>"._AIM."</td>"
	    ."<td><input type=\"text\" name=\"chng_user_aim\" value=\"$chng_user_aim\" size=\"20\" maxlength=\"20\"></td></tr>"
	    ."<tr><td>"._YIM."</td>"
	    ."<td><input type=\"text\" name=\"chng_user_yim\" value=\"$chng_user_yim\" size=\"20\" maxlength=\"20\"></td></tr>"
	    ."<tr><td>"._MSNM."</td>"
	    ."<td><input type=\"text\" name=\"chng_user_msnm\" value=\"$chng_user_msnm\" size=\"20\" maxlength=\"20\"></td></tr>"
	    ."<tr><td>"._LOCATION."</td>"
	    ."<td><input type=\"text\" name=\"chng_user_from\" value=\"$chng_user_from\" size=\"25\" maxlength=\"60\"></td></tr>"
	    ."<tr><td>"._OCCUPATION."</td>"
	    ."<td><input type=\"text\" name=\"chng_user_occ\" value=\"$chng_user_occ\" size=\"25\" maxlength=\"60\"></td></tr>"
	    ."<tr><td>"._INTERESTS."</td>"	    
	    ."<td><input type=\"text\" name=\"chng_user_intrest\" value=\"$chng_user_intrest\" size=\"25\" maxlength=\"255\"></td></tr>"
	     ."<tr><td>"._POINT."</td>"
        ."<td><input type=\"text\" name=\"chng_user_points\" value=\"$chng_user_points\"size=\"4\" maxlength=\"255\"></td></tr>"
	    ."<tr><td>"._OPTION."</td>";
	if ($chng_user_viewemail ==1) {
	    echo "<td><input type=\"checkbox\" name=\"chng_user_viewemail\" value=\"1\" checked> "._ALLOWUSERS."</td></tr>";
	} else {
	    echo "<td><input type=\"checkbox\" name=\"chng_user_viewemail\" value=\"1\"> "._ALLOWUSERS."</td></tr>";
	}
	if ($chng_newsletter == 1) {
	    echo "<tr><td>"._NEWSLETTER."</td><td><input type=\"radio\" name=\"chng_newsletter\" value=\"1\" checked>"._YES."<br>"
		."<input type=\"radio\" name=\"chng_newsletter\" value=\"0\">"._NO."<br>";
	} elseif ($chng_newsletter == 0) {
	    echo "<tr><td>"._NEWSLETTER."</td><td><input type=\"radio\" name=\"chng_newsletter\" value=\"1\">"._YES."<br>"
		."<input type=\"radio\" name=\"chng_newsletter\" value=\"0\" checked>"._NO."<br>";
	}
	echo "<tr><td>"._SIGNATURE."</td>"
	    ."<td><textarea name=\"chng_user_sig\" rows=\"6\" cols=\"45\">$chng_user_sig</textarea></td></tr>"
	    ."<tr><td>"._PASSWORD."</td>"
	    ."<td><input type=\"password\" name=\"chng_pass\" size=\"12\" maxlength=\"12\"></td></tr>"
	    ."<tr><td>"._RETYPEPASSWD."</td>"
	    ."<td><input type=\"password\" name=\"chng_pass2\" size=\"12\" maxlength=\"12\"> <font class=\"tiny\">"._FORCHANGES."</font></td></tr>"
	    ."<input type=\"hidden\" name=\"chng_avatar\" value=\"$chng_avatar\">"
	    ."<input type=\"hidden\" name=\"chng_uid\" value=\"$chng_uid\">"
	    ."<input type=\"hidden\" name=\"op\" value=\"updateUser\">"
	    ."<tr><td><input type=\"submit\" value=\""._SAVECHANGES."\"></td></tr>"
	    ."</table></form></center>";

    } else {

	echo "<center><b>"._USERNOEXIST."</b><br><br>"
	    .""._GOBACK."</center>";

    }
    CloseOngletTable();
    include("system/footer_system.php");
}
/**
 * updateUser()
 *
 *
 *
 */
function updateUser($chng_uid, $chng_uname, $chng_name, $chng_url, $chng_email, $chng_femail, $chng_user_icq, $chng_user_aim, $chng_user_yim, $chng_user_msnm, $chng_user_from, $chng_user_occ, $chng_user_intrest, $chng_user_viewemail, $chng_avatar, $chng_sig, $chng_pass, $chng_pass2, $chng_newsletter, $chng_user_points) {
    global $user_prefix, $db;
    $tmp = 0;
    if ($chng_pass2 != "") {
        if($chng_pass != $chng_pass2) {
            include("system/header_system.php");
	    GraphicAdmin();
	    OpenSysTable();
	    echo "<center><font class=\"title\"><b>"._USERADMIN."</b></font></center>";
	    CloseSysTable();
	    echo "<br>";
	    OpenSysTable();
            echo "<center>"._PASSWDNOMATCH."<br><br>"
		.""._GOBACK."</center>";
	    CloseSysTable();
            include("system/footer_system.php");
            exit;
        }
        $tmp = 1;
    }
    if ($tmp == 0) {
	$db->sql_query("update ".$user_prefix."_users set uname='$chng_uname', name='$chng_name', email='$chng_email', femail='$chng_femail', url='$chng_url', user_icq='$chng_user_icq', user_aim='$chng_user_aim', user_yim='$chng_user_yim', user_msnm='$chng_user_msnm', user_from='$chng_user_from', user_occ='$chng_user_occ', user_interests='$chng_user_intrest', user_viewemail='$chng_user_viewemail', user_avatar='$chng_avatar', user_sig='$chng_sig', newsletter='$chng_newsletter', points='$chng_user_points' where uid='$chng_uid'");
    }
    if ($tmp == 1) {
    	$cpass = md5($chng_pass);
        $db->sql_query("update ".$user_prefix."_users set uname='$chng_uname', name='$chng_name', email='$chng_email', femail='$chng_femail', url='$chng_url', user_icq='$chng_user_icq', user_aim='$chng_user_aim', user_yim='$chng_user_yim', user_msnm='$chng_user_msnm', user_from='$chng_user_from', user_occ='$chng_user_occ', user_interests='$chng_user_intrest', user_viewemail='$chng_user_viewemail', user_avatar='$chng_avatar', user_sig='$chng_sig', pass='$cpass', newsletter='$chng_newsletter', points='$chng_user_points' where uid='$chng_uid'");
    }
    Header("Location: system.php?op=mod_users");
}

/**
 * userList()
 *
 *
 *
 */
function list_members($letter, $sortby, $page){
	global $user_prefix,$prefix, $db, $ongletDef, $admin, $user;
	
	$pagesize = 20;

	$resultbuff=$db->sql_query("select uid from ".$user_prefix."_users");
	if (!$resultbuff) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	$numrows = $db->sql_numrows($resultbuff);

	$min = $pagesize * ($page - 1); // This is where we start our record set from
	$max = $pagesize; // This is how many rows to select

	$count = "SELECT COUNT(uid) AS total FROM ".$user_prefix."_users"; // Count all the users in the db..
	$select = "SELECT uid, uname, adh_nom1, adh_prenom1, adh_civilite1, adh_email1, adh_entreprise, adh_cp, adh_ville from ".$user_prefix."_users"; //select our data
	$where = " WHERE uname <> 'Anonymous' ";
	if (( $letter != "Other" ) AND ( $letter != "All" ) ) {
		$where .= "AND uname like '".$letter."%'";
	} 
	else if ( ( $letter == "Other" ) AND ( $letter != "All" ) ) {
		$where .= "AND uname REGEXP \"^\[1-9]\"";
	} 
	else {
		$where .= "";
	}
	$sort = " ORDER BY $sortby ASC";
	$limit = " LIMIT ".$min.", ".$max;
	$count_result = $db->sql_query($count.$where);
	if (!$count_result) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	list($num_rows_per_order) = $db->sql_fetchrow($count_result);
	
	$sortie = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
	$sortie .= list_index($num_rows_per_order,$page,$pagesize,$letter);
	$sortie .= '</td><td width="50">&nbsp;</td><td>';
	$sortie .= alpha($sortby,$num_rows_per_order,$letter);
	$sortie .= '</td></tr></table>';
	$result = $db->sql_query($select.$where.$sort.$limit); // Now lets do it !!
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query:');
	}

	$sortie .= "<table class=\"lisTable\"><tr class=\"systemTabHeader\">\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTPSEUDO." ".SortLinks($letter,$sortby,"uname")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTADH." ".SortLinks($letter,$sortby,"nom")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTENTREPRISE." ".SortLinks($letter,$sortby,"entreprise")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTADRESSE." ".SortLinks($letter,$sortby,"ville")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTEMAIL."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._FUNCTIONS."</font></td>\n";
	$sortie .= "</tr>";
	$a = 0;
	$dcolor_A = "$bgcolor2";
	$dcolor_B = "$bgcolor1";

	if (($result)){
		$num_users = $db->sql_numrows($result); 
	} 
	else {
		$num_users=0;
	}

	if ( $num_rows_per_order > 0  ) {
		$pos=0;
		while($user = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0){
				$thestyle="listTableOdd";
			} 
			else {
				$thestyle="listTableNone";
			}
			$dcolor = ($a == 0 ? $dcolor_A : $dcolor_B);
			$sortie .= "<tr class=\"$thestyle\">";
			$sortie .= "<td >&nbsp;&nbsp;&nbsp;&nbsp;<b>$user[uname]</b></td>\n";
			$sortie .= "<td>$user[adh_civilite1] $user[adh_prenom1] $user[adh_nom1]</td>\n";
			$sortie .= "<td>$user[adh_entreprise]</td>\n";
			$sortie .= "<td>$user[adh_cp] $user[adh_ville]</td>\n";
			$sortie .= "<td ><a href=\"mailto:".$user["adh_email1"]."\">$user[adh_email1]</a></td>\n";
			$barDef=array(
				"view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif","url"=>"modules.php?name=Your_Account&amp;op=userinfo&amp;uname=$user[uname]","comment"=> _PREVIEW, "status"=>"ON"),
				"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=members&action=edit_member&Id=$user[uid]&letter=".$letter."&sortby=".$sortby."&page=".$page,"comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=members&action=delete_member&onglet=members&Id=$user[uid]&letter=".$letter."&sortby=".$sortby."&page=".$page,"comment"=>_DELETE,"status"=>"ON"));
			$sortie .= "<td>";
			$sortie .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$sortie .= "</td>";	
			$sortie .= "</tr>";
			$a = ($dcolor == $dcolor_A ? 1 : 0);
			$pos++;
		}
	}
	$sortie .= "\n</table>";
	$sortie .= '<a href="system.php?op=members&action=new_member">'._SMEMBERSLISTEADD.'</a>';
	return $sortie;
}

function list_members_temp(){
	$obj_member = new BD_Members();
	$users = $obj_member->getMembersTemp();

	$sortie .= "<table class=\"lisTable\"><tr class=\"systemTabHeader\">\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTPSEUDO." ".SortLinks($letter,$sortby,"uname")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTADH." ".SortLinks($letter,$sortby,"nom")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTENTREPRISE." ".SortLinks($letter,$sortby,"entreprise")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTADRESSE." ".SortLinks($letter,$sortby,"ville")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSLISTEMAIL."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._FUNCTIONS."</font></td>\n";
	$sortie .= "</tr>";
	$a = 0;
	$dcolor_A = "$bgcolor2";
	$dcolor_B = "$bgcolor1";

	$pos=0;
	foreach ($users as $user) {
		if ($pos % 2 == 0){
			$thestyle="listTableOdd";
		} 
		else {
			$thestyle="listTableNone";
		}
		$dcolor = ($a == 0 ? $dcolor_A : $dcolor_B);
		$sortie .= "<tr class=\"$thestyle\">";
		$sortie .= "<td >&nbsp;&nbsp;&nbsp;&nbsp;<b>$user[username]</b></td>\n";
		$sortie .= "<td>$user[adh_civilite1] $user[adh_prenom1] $user[adh_nom1]</td>\n";
		$sortie .= "<td>$user[adh_entreprise]</td>\n";
		$sortie .= "<td>$user[adh_cp] $user[adh_ville]</td>\n";
		$sortie .= "<td ><a href=\"mailto:".$user["adh_email1"]."\">$user[adh_email1]</a></td>\n";
		$barDef=array(
			"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=members&action=preview_memberno&Id=$user[user_id]&onglet=membersno","comment"=>_EDIT, "status"=>"ON"),
			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=members&action=delete_memberno&onglet=membersno&Id=$user[user_id]","comment"=>_DELETE,"status"=>"ON"));
		$sortie .= "<td>";
		$sortie .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
		$sortie .= "</td>";	
		$sortie .= "</tr>";
		$a = ($dcolor == $dcolor_A ? 1 : 0);
		$pos++;
	}

	$sortie .= "\n</table>";
	return $sortie;
}

function preview_member_temp($Id) {
	$obj_member = new BD_Members();
	$users = $obj_member->getMembersTemp($Id);
	$membre = $users[0];
	$sortie .= '<form name="edit_member" action="system.php?op=members&action=save_memberno&onglet=membersno" method="POST" onsubmit="return verif_ref(this,\''._SMEMBERBLOCREFSMENU.'\')">';
	$sortie .= '<center><div class="fiche_adh">';
	$sortie .= '&nbsp;<br />';
	$sortie .= '<fieldset><legend>'._SMEMBERSADHBLOC.'</legend>';
	$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCNICKNAME;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="username" value="'.$membre["username"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	/*$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCPASSWORD;
	$sortie .= '</td><td>';
	$sortie .= '<input type="password" name="user_password" value="'.$membre["user_password"].'" class="saisie">';
	$sortie .= '</td></tr>';*/
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCCIVILITE;
	$sortie .= '</td><td>';
	$valeurs = explode("/", _SMEMBERSBLOCCIVILITEVALUES);
	$menu = '<select name="adh_civilite1" size="1">';
	foreach ($valeurs as $valeur) {
		$select = ($valeur == $membre["adh_civilite1"]) ? " selected=\"selected\"" : "";
		$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
	}
	$menu .= "</select>";
	$sortie .= $menu;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCNOM;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_nom1" value="'.$membre["adh_nom1"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCPRENOM;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_prenom1" value="'.$membre["adh_prenom1"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCEMAIL;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_email1" value="'.$membre["adh_email1"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCENTREPRISE;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_entreprise" value="'.$membre["adh_entreprise"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	$sortie .= '</fieldset>';
	
	$sortie .= '&nbsp;<br />';
	
	$sortie .= '<fieldset><legend>'._SMEMBERSENTREPRISEBLOC.'</legend>';
	$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCLOGO;
	$sortie .= '</td><td>';
	$sortie .= '<input type="hidden" name="adh_logo" value="'.$membre["adh_logo"].'">';
	if ($membre["adh_logo"] != "") {
		$sortie .= '<img src="'.$membre["adh_logo"].'" border="1">';
	}
	else {
		$sortie .= _SMEMBERSBLOCNOLOGO;
	}
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCRAISON;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_raison" value="'.$membre["adh_raison"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCFORME;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_forme" value="'.$membre["adh_forme"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCSIRET;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_siret" value="'.$membre["adh_siret"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCNAF;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_naf" value="'.$membre["adh_naf"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCDATE;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_date_creation" value="'.utilFuncs_simpleMembers::date2JMA($membre["adh_date_creation"]).'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCCAPITAL;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_capital" value="'.$membre["adh_capital"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCEFFECTIF;
	$sortie .= '</td><td>';
	$valeurs = explode("/", _SMEMBERSBLOCEFFECTIFVALUES);
	$menu = '<select name="adh_effectif" size="1">';
	foreach ($valeurs as $valeur) {
		$select = ($valeur == $membre["adh_effectif"]) ? " selected=\"selected\"" : "";
		$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
	}
	$menu .= "</select>";
	$sortie .= $menu;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCCA;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_ca" value="'.$membre["adh_ca"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCTRANCHECA;
	$sortie .= '</td><td>';
	$valeurs = explode("/", _SMEMBERSBLOCTRANCHECAVALUES);
	$menu = '<select name="adh_tranche_ca" size="1">';
	foreach ($valeurs as $valeur) {
		$select = ($valeur == $membre["adh_tranche_ca"]) ? " selected=\"selected\"" : "";
		$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
	}
	$menu .= "</select>";
	$sortie .= $menu;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCADRESSE;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="adh_adresse" cols="50" rows="3" class="saisie">'.$membre["adh_adresse"].'</textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCCP;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_cp" value="'.$membre["adh_cp"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCVILLE;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_ville" value="'.$membre["adh_ville"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCTEL;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_tel" value="'.$membre["adh_tel"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCFAX;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_fax" value="'.$membre["adh_fax"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCWEB;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_web" value="'.$membre["adh_web"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCLAT;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_latitude" value="'.$membre["adh_latitude"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCLONG;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_longitude" value="'.$membre["adh_longitude"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	$sortie .= '</fieldset>';
	
	$sortie .= '&nbsp;<br />';
	
	$sortie .= '<fieldset><legend>'._SMEMBERSCONTACTSBLOC.'</legend>';
	$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCCIVILITEDIR;
	$sortie .= '</td><td>';
	$valeurs = explode("/", _SMEMBERSBLOCCIVILITEVALUES);
	$menu = '<select name="adh_civilite2" size="1">';
	foreach ($valeurs as $valeur) {
		$select = ($valeur == $membre["adh_civilite2"]) ? " selected=\"selected\"" : "";
		$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
	}
	$menu .= "</select>";
	$sortie .= $menu;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCNOMDIR;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_nom2" value="'.$membre["adh_nom2"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCPRENOMDIR;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_prenom2" value="'.$membre["adh_prenom2"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCETELDIR;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_mobile2" value="'.$membre["adh_mobile2"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCEMAILDIR;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_email2" value="'.$membre["adh_email2"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td colspan="2"><hr></td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCCIVILITECOM;
	$sortie .= '</td><td>';
	$valeurs = explode("/", _SMEMBERSBLOCCIVILITEVALUES);
	$menu = '<select name="adh_civilite3" size="1">';
	foreach ($valeurs as $valeur) {
		$select = ($valeur == $membre["adh_civilite3"]) ? " selected=\"selected\"" : "";
		$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
	}
	$menu .= "</select>";
	$sortie .= $menu;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCNOMCOM;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_nom3" value="'.$membre["adh_nom3"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCPRENOMCOM;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_prenom3" value="'.$membre["adh_prenom3"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCETELCOM;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_tel3" value="'.$membre["adh_tel3"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCEFAXCOM;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_fax3" value="'.$membre["adh_fax3"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCEMAILCOM;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_email3" value="'.$membre["adh_email3"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	$sortie .= '</fieldset>';
	
	$sortie .= '&nbsp;<br />';
	
	$sortie .= '<fieldset><legend>'._SMEMBERSACTIVITEBLOC.'</legend>';
	$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCACTIVITE;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="adh_activites" cols="50" rows="5" class="saisie">'.$membre["adh_activites"].'</textarea>';
	$sortie .= '</td></tr>';
	
	/*$sortie .= '<tr><td class="label">';
	$sortie .= '</td><td>';
	$sortie .= '<a id= "menudom" class="menudom" href="#" onclick="if (is_empty_dom()) { togglePopUpZPop(this,\''.addslashes(str_replace("\n"," ", str_replace("\"","'",$valsJS[0]))).'\',\''._SMEMBERSDOMAINMENU.'\');hideAllDomaines(); } else { JustTogglePopUpZPop(); };return false" title="'._SMEMBERSDOMAINBROWSE.'">'._SMEMBERSDOMAINCHOOSE.'</a>';
	$sortie .= '</td></tr>';*/
	
	if ($membre["adh_metier"] == "0") {
		$rien = $obj_member->getMembers("files",$membre["uid"]);
		$membre["adh_metier"] = $rien[0]["adh_metier"];
	}
	$domaines = $obj_member->getDoms("","",$membre["adh_metier"]);
	$domaine =$domaines[0];
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCJOB;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="zadh_metier" value="'.$membre["adh_metier"]." : ".$domaine["label"].'" class="saisie" readonly="readonly">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCDOMAIN;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="adh_domaine" cols="50" rows="7" class="saisie" readonly="readonly">'.$membre["adh_domaine"].'</textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCREFS;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="adh_refs" cols="50" rows="5" class="saisie">'.$membre["adh_refs"].'</textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCCLUBS;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="adh_clubs" cols="50" rows="5" class="saisie">'.$membre["adh_clubs"].'</textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SMEMBERSBLOCCERTIFS;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="adh_certifs" cols="50" rows="5" class="saisie">'.$membre["adh_certifs"].'</textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	$sortie .= '</fieldset>';
	
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._SMEMBERSSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$membre["uid"].'" name="uid">';
	$sortie .= '<input type="hidden" value="'.$membre["adh_metier"].'" name="adh_metier">';
	$sortie .= '<input type="hidden" value="'.$membre["user_password"].'" name="user_password">';
	$sortie .= '<input type="hidden" value="'.$membre["user_id"].'" name="user_id">';

	$sortie .= '<br />&nbsp;';
	$sortie .= '</div></center>';
	$sortie .= "</form>";
	return $sortie;
}

function save_member_temp($member) {
	$user_id = $member["user_id"];
	$latitude = $member["adh_latitude"];
	$longitude = $member["adh_longitude"];
	unset($member["user_id"]);
	unset($member["adh_latitude"]);
	unset($member["adh_longitude"]);
	if ($member["adh_metier"] == "0") {
		unset($member["adh_metier"]);
	}
	$obj_member = new BD_Members();
	if ($obj_member->saveMember($member)) {
		$links = $obj_member->getLinksTemp($user_id);
		if ($member["uid"] == "" || $member["uid"] == "0") {
			$uid = $obj_member->get_id_new_member();
		}
		else {
			$uid = $member["uid"];
			if (count($links) != 0) {
				if (!$obj_member->delLinks($uid)) {
					die("DB problem 1");
				}
			}
			//dtruire les anciennes coords !
			if (!$obj_member->delCoords($uid)) {
				die("DB problem 5");
			}
		}
		foreach ($links as $link) {
			$lien = array(
			"id_user" => $uid,
			"id_domain" => $link["id_domain"],
			"coef" => $link["coef"],
			"refs" => utilFuncs_simpleMembers::conditionnertodb($link["refs"])
			);
			if (! $obj_member->saveLink($lien)) {
				die("DB Problem 2");
			}
		}
		$latitudes = explode("/",$latitude);
		$longitudes = explode("/",$longitude);
		for ($i=0;$i<count($latitudes);$i++) {
			//ajouter une coord
			$coord = array(
			"id_user" => $uid,
			"latitude" => $latitudes[$i],
			"longitude" => $longitudes[$i]
			);
			if (! $obj_member->saveCoord($coord)) {
				die("DB Problem 6");
			}
		}
		if (! $obj_member->delLinksTemp($user_id) || ! $obj_member->delMemberTemp($user_id)) {
			die("DB Problem 4");
		}
		//expdition d'email au membre inscrit
		if ($member["uid"] == "" || $member["uid"] == "0") {
			$message = _SNEWMEMBERSREGSIRETEREDBODY;
		}
		else {
			$message = _SOLDMEMBERSREGSIRETEREDBODY;
		}
		$message = str_replace("<!--login-->", $member["uname"],$message);
		$message = str_replace("<!--passwd-->", $member["pass"],$message);
		//utilFuncs_simpleMembers::send_email($member["email1"],$adminmail,_SNEWMEMBERSREGSIRETEREDSUB,$message);
		return true;
	}
	else {
		die("DB Problem 3");
	}
}

function delete_member_temp($Id,$confirm="n") {
	if ($Id != "") {
		if ($confirm == "y"){
			$obj_ads = new BD_Members();
			if ($obj_ads->delMemberTemp($Id)) {
				return list_members_temp();
			}
		}
		else {
			$sortie = "<div style=\"text-align: center; font-weight: bold\">";
			$sortie .= "<p>"._SMEMBERSCONFIRMDELETEMEMEMBER."</p>";
			$sortie .= "<p>&nbsp;</p>";
			$sortie .= "<p>";
			$sortie .= '<a href="system.php?op=members&action=delete_memberno&onglet=membersno&Id='.$Id.'&confirm=y">';
			$sortie .= "["._YES."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._NO."]";
			$sortie .= '</a>';
			$sortie .= "</p>";
			$sortie .= "</div>";
			return $sortie;
		}
	}
}

/**
 * alpha()
 * Creates the list of letters and makes them a link
 *
 */
function alpha($sortby) {
   /* Creates the list of letters and makes them a link. */
	$sortie = "";
       $alphabet = array ("All", "A","B","C","D","E","F","G","H","I","J","K","L","M",
                           "N","O","P","Q","R","S","T","U","V","W","X","Y","Z","Other");
       $num = count($alphabet) - 1;
       $sortie .= "<div>";
       $sortie .= _SMEMBERSLISTEFILTER;
       $sortie .= "[ ";
       $counter = 0;
       while (list(, $ltr) = each($alphabet)) {
           $sortie .= "<A HREF=\"system.php?op=members&action=list_members&letter=$ltr&amp;sortby=$sortby\">$ltr</a>";
           if ( $counter == round($num/2) ) {
               $sortie .= " ]\n[ ";
           } elseif ( $counter != $num ) {
               $sortie .= "&nbsp;|&nbsp;\n";
           }
           $counter++;
       }
       $sortie .= " ]\n</div>\n\n";
	return $sortie;
}
/**
 * SortLinks
 * @param char letter
 *
 */
function SortLinks($letter, $sortby, $what) {  // Makes order by links..
	return "";

	global $Default_Skin;
	
	$skinPath="system/skins/$Default_Skin";
       if ($letter == "front") {
		$letter = "All";
	}
	$sorticon="$skinPath/down.png";
	echo "$sortby||$what//";
	if ($sortby != $what || $sortby == "") {
		$sortimg= "<img src=\"$sorticon\" onclick=\"window.location.href = 'system.php?op=members&action=list_members&letter=$letter&sortby=$what'\">";
	}
	else {
		$sortimg= "";
	}
	return $sortimg;       
}

function menu_domaines($Id,$metier) {
	$obj_dom = new BD_Members();
	$domaines = $obj_dom->getDoms();
	$links = $obj_dom->getLinks("files", $Id);
	$premier = true;
	$compteur = 1;
	$tab_dom = "\tvar tab_dom = new Array();\n";
	$legende = '<table border="0" cellspacing="0" cellpadding="0" class="menuDomaines">';
	foreach ($domaines as $domaine) {
		if ($domaine["code"] % 100 == 0) {	
			if (!$premier) {
				$legende .= '</table>';
				$legende .= '</td></tr>';
			}
			//$legende .= '<tr><th class="menuDomainesGroup" id="headerdom'.$compteur.'">'.str_replace("<!--metier-->",$domaine["code"],$radio).'<a href="#" onclick="hideAllDomaines();showDomaine(&quot;'.$compteur.'&quot;);return false">'.$domaine["label"].'</a></th></tr>';
			$checked = "";
			if ($metier == $domaine["code"]) {
				$checked = " checked=\"checked\"";
			}
			$radio = '<input type="radio" name="adh_metier_radio" value="'.$domaine["code"].'" onclick="saisie_metier(this)"'.$checked.'>&nbsp;&nbsp;';
			$legende .= '<tr><th class="menuDomainesGroup" id="headerdom'.$compteur.'">'.str_replace("<!--metier-->",$domaine["code"],$radio).'<a href="#" onclick="toggleDomaine(&quot;'.$compteur.'&quot;);return false">'.$domaine["label"].'</a></th></tr>';
			$legende .= '<tr id="listdom'.$compteur.'"><td>';
			$legende .= '<table border="0" cellspacing="0" cellpadding="0" class="menuDomaines2">';
			$compteur++;
			$tab_dom .= "\ttab_dom[".$domaine["code"]."]=\"".$domaine["label"]."\";\n";
		}
		else {
			$selected = "";
			$valeur = _SMEMBERBLOCREFSMENU;
			$menu = '<select name="coef[]" size="1" onchange="verif_coef(this)"><option value="">'._SMEMBERSDOMAINCOEF.'</option>';
			for ($i = 7; $i >= 1; $i--) {
				$selected = "";
				foreach($links as $link) {
					if ($link["id_domain"] == $domaine["code"] && $i == $link["coef"]) {
						$selected = " selected=\"selected\"";
					}
					if ($link["id_domain"] == $domaine["code"]) {
						$valeur = $link["refs"];
					}
				}
				$menu .= '<option value="'.$i.'|'.$domaine["code"].'"'.$selected.'>'.$i.'</option>';
			}
			$menu .= "</select>";
			$refs = '<textarea rows="2" width="10" name="ref[]" onblur="saisie_ref(this.form);" onfocus="if (this.value==&quot;'.addslashes(_SMEMBERBLOCREFSMENU).'&quot;) {this.value=&quot;&quot;}">'.str_replace("\r", "", nl2br($valeur)).'</textarea>';
			$legende .= '<tr>';
			$legende .= '<td><b>'.$domaine["label"].'</b><br />'.str_replace("\r", "", nl2br($domaine["description"])).'</td>';
			$legende .= '<td width="50">'.$menu.'</td>';
			$legende .= '<td width="100">'.$refs.'</td>';
			$legende .= '</tr>';
			$tab_dom .= "\ttab_dom[".$domaine["code"]."]=\"".$domaine["label"]."\";\n";
		}
		$premier = false;
	}
	$legende .= '</table>';
	$legende .= '</td></tr>';
	$legende .= '</table>';
	return array($legende, $tab_dom);
}

function edit_member($Id, $page="",$letter="", $onglet="") {
		global $module_name;
		
		if ($Id != "" && $Id != "-1") {
			$obj_member = new BD_Members();
			$members = $obj_member->getMembers("files",$Id);
			$membre = $members[0];
		}
		else {
			$membre = array();
		}
		
		$valsJS = menu_domaines($Id,$membre["adh_metier"]);
		
		$sortie = '
<link href="modules/'.$module_name.'/system/stl_pop.css" rel="stylesheet" type="text/css" media="all" />
<script src="modules/'.$module_name.'/system/lib_autostart.js" type="text/javascript"></script>
<script src="modules/'.$module_name.'/system/lib_zpop.js" type="text/javascript"></script>
<script src="modules/'.$module_name.'/system/lib_admin_domaines.js" type="text/javascript"></script>
<script type="text/javascript">
// <![CDATA[
	init_chemin_icones = "modules/'.$module_name.'/system";
'.$valsJS[1].'
	addToStart("newPopUpZPop(document.forms[\'edit_member\'])");
// ]]>
</script>';
		
		$sortie .= '<form name="edit_member" action="system.php?op=members&action=save_member&onglet='.$onglet.'" method="POST" onsubmit="return verif_ref(this,\''._SMEMBERBLOCREFSMENU.'\')" enctype="multipart/form-data">';
		$sortie .= '<center><div class="fiche_adh">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<fieldset><legend>'._SMEMBERSADHBLOC.'</legend>';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCNICKNAME;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="zuname" value="'.$membre["uname"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCPASSWORD;
		$sortie .= '</td><td>';
		$sortie .= '<input type="password" name="zpass" value="" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCCIVILITE;
		$sortie .= '</td><td>';
		$valeurs = explode("/", _SMEMBERSBLOCCIVILITEVALUES);
		$menu = '<select name="adh_civilite1" size="1">';
		foreach ($valeurs as $valeur) {
			$select = ($valeur == $membre["adh_civilite1"]) ? " selected=\"selected\"" : "";
			$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
		}
		$menu .= "</select>";
		$sortie .= $menu;
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCNOM;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_nom1" value="'.$membre["adh_nom1"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCPRENOM;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_prenom1" value="'.$membre["adh_prenom1"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCEMAIL;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_email1" value="'.$membre["adh_email1"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCENTREPRISE;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_entreprise" value="'.$membre["adh_entreprise"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		$sortie .= '</fieldset>';
		
		$sortie .= '&nbsp;<br />';
		
		$sortie .= '<fieldset><legend>'._SMEMBERSENTREPRISEBLOC.'</legend>';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCLOGO;
		$sortie .= '</td><td>';
		$sortie .= '<input type="hidden" name="adh_logo" value="'.$membre["adh_logo"].'">';
		if ($membre["adh_logo"] != "") {
			$sortie .= '<img src="'.$membre["adh_logo"].'" border="1">';
		}
		else {
			$sortie .= _SMEMBERSBLOCNOLOGO;
		}
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCLOGONEW;
		$sortie .= '</td><td>';
		$sortie .= '<input type="file" name="adh_logo_new" value="" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCRAISON;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_raison" value="'.$membre["adh_raison"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCFORME;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_forme" value="'.$membre["adh_forme"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCSIRET;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_siret" value="'.$membre["adh_siret"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCNAF;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_naf" value="'.$membre["adh_naf"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCDATE;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_date_creation" value="'.utilFuncs_simpleMembers::date2JMA($membre["adh_date_creation"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCCAPITAL;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_capital" value="'.$membre["adh_capital"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCEFFECTIF;
		$sortie .= '</td><td>';
		$valeurs = explode("/", _SMEMBERSBLOCEFFECTIFVALUES);
		$menu = '<select name="adh_effectif" size="1">';
		foreach ($valeurs as $valeur) {
			$select = ($valeur == $membre["adh_effectif"]) ? " selected=\"selected\"" : "";
			$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
		}
		$menu .= "</select>";
		$sortie .= $menu;
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCCA;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_ca" value="'.$membre["adh_ca"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCTRANCHECA;
		$sortie .= '</td><td>';
		$valeurs = explode("/", _SMEMBERSBLOCTRANCHECAVALUES);
		$menu = '<select name="adh_tranche_ca" size="1">';
		foreach ($valeurs as $valeur) {
			$select = ($valeur == $membre["adh_tranche_ca"]) ? " selected=\"selected\"" : "";
			$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
		}
		$menu .= "</select>";
		$sortie .= $menu;
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCADRESSE;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="adh_adresse" cols="50" rows="3" class="saisie">'.$membre["adh_adresse"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCCP;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_cp" value="'.$membre["adh_cp"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCVILLE;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_ville" value="'.$membre["adh_ville"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCTEL;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_tel" value="'.$membre["adh_tel"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCFAX;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_fax" value="'.$membre["adh_fax"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCWEB;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_web" value="'.$membre["adh_web"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		$sortie .= '</fieldset>';
		
		$sortie .= '&nbsp;<br />';
		
		$sortie .= '<fieldset><legend>'._SMEMBERSCONTACTSBLOC.'</legend>';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCCIVILITEDIR;
		$sortie .= '</td><td>';
		$valeurs = explode("/", _SMEMBERSBLOCCIVILITEVALUES);
		$menu = '<select name="adh_civilite2" size="1">';
		foreach ($valeurs as $valeur) {
			$select = ($valeur == $membre["adh_civilite2"]) ? " selected=\"selected\"" : "";
			$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
		}
		$menu .= "</select>";
		$sortie .= $menu;
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCNOMDIR;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_nom2" value="'.$membre["adh_nom2"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCPRENOMDIR;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_prenom2" value="'.$membre["adh_prenom2"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCETELDIR;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_mobile2" value="'.$membre["adh_mobile2"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCEMAILDIR;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_email2" value="'.$membre["adh_email2"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td colspan="2"><hr></td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCCIVILITECOM;
		$sortie .= '</td><td>';
		$valeurs = explode("/", _SMEMBERSBLOCCIVILITEVALUES);
		$menu = '<select name="adh_civilite3" size="1">';
		foreach ($valeurs as $valeur) {
			$select = ($valeur == $membre["adh_civilite3"]) ? " selected=\"selected\"" : "";
			$menu .= '<option value="'.$valeur.'"'.$select.'>'.$valeur.'</option>';
		}
		$menu .= "</select>";
		$sortie .= $menu;
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCNOMCOM;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_nom3" value="'.$membre["adh_nom3"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCPRENOMCOM;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_prenom3" value="'.$membre["adh_prenom3"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCETELCOM;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_tel3" value="'.$membre["adh_tel3"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCEFAXCOM;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_fax3" value="'.$membre["adh_fax3"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCEMAILCOM;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_email3" value="'.$membre["adh_email3"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		$sortie .= '</fieldset>';
		
		$sortie .= '&nbsp;<br />';
		
		$sortie .= '<fieldset><legend>'._SMEMBERSACTIVITEBLOC.'</legend>';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCACTIVITE;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="adh_activites" cols="50" rows="5" class="saisie">'.$membre["adh_activites"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= '</td><td>';
		$sortie .= '<a id= "menudom" class="menudom" href="#" onclick="if (is_empty_dom()) { togglePopUpZPop(this,\''.addslashes(str_replace("\n"," ", str_replace("\"","'",$valsJS[0]))).'\',\''._SMEMBERSDOMAINMENU.'\');hideAllDomaines(); } else { JustTogglePopUpZPop(); };return false" title="'._SMEMBERSDOMAINBROWSE.'">'._SMEMBERSDOMAINCHOOSE.'</a>';
		$sortie .= '</td></tr>';
		
		if ($membre["adh_metier"] != "") {
			$domaines = $obj_member->getDoms("","",$membre["adh_metier"]);
			$domaine =$domaines[0];
			$themetier = $membre["adh_metier"]." : ".$domaine["label"];
		}
		else {
			$domaine = array();
			$themetier = "";
		}
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCJOB;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="adh_metier" value="'.$themetier.'" class="saisie" readonly="readonly">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCDOMAIN;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="adh_domaine" cols="50" rows="7" class="saisie" readonly="readonly">'.$membre["adh_domaine"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCREFS;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="adh_refs" cols="50" rows="5" class="saisie">'.$membre["adh_refs"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCCLUBS;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="adh_clubs" cols="50" rows="5" class="saisie">'.$membre["adh_clubs"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td class="label">';
		$sortie .= _SMEMBERSBLOCCERTIFS;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="adh_certifs" cols="50" rows="5" class="saisie">'.$membre["adh_certifs"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		$sortie .= '</fieldset>';
		
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._SMEMBERSSAVEBTN.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$membre["uid"].'" name="uid">';
		$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		$sortie .= '<input type="hidden" value="'.$letter.'" name="letter">';
		
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div></center>';
		$sortie .= "</form>";
		
		return $sortie;
	}

function save_member($member) {
	global $adminmail;
	$coefs = false;
	if (isset($member["coef"])) {
		$coefs = $member["coef"];
	}
	if (isset($member["ref"])) {
		$refs = $member["ref"];
	}
	unset($member["coef"]);
	unset($member["ref"]);
	$obj_member = new BD_Members();
	
	if ($_FILES["adh_logo_new"]["name"] != "") {
		//upload logo
		$chemin="catalog_repository/simple_members";
		$compteur = 0;
		do {
			$nomDestination = (time() + $compteur).strrchr($_FILES["adh_logo_new"]["name"],'.');
			$compteur++;
		} while (file_exists($chemin."/".$nomDestination));
		if (!file_exists($chemin)) {
			if (mkdir("$chemin", 0777)) {
				chmod("$chemin",0777);
			}
			else {
				die("Dossier $chemin non cr&eacute;&eacute; - V&eacute;rifiez les droits");
			}	
		}
		if (is_uploaded_file($_FILES["adh_logo_new"]["tmp_name"])) {
			$logo = $chemin."/".$nomDestination;
			if (rename($_FILES["adh_logo_new"]["tmp_name"],$logo)) { 
				chmod($logo,0777);
			}
			else {
				die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
			}          
		}
		else {
			die("Le fichier n'a pas t upload (trop gros ? droits ?)");
		}
		$member["adh_logo"] = $logo;
		//redim
		$width_max=150;
		$height_max=150;
		$qualite=70;
		$extension = strrchr($logo,'.');
		$size_o = getimagesize($logo);
		if (($size_o[0] > $width_max) || ($size_o[1] > $height_max)) {
			if ($extension == ".jpg" || $extension == ".jpeg") {
				$img_source=imagecreatefromjpeg($logo);
			}
			if ($extension == ".gif") {
				$img_source=imagecreatefromgif($logo);
			}
			if ($extension == ".png") {
				$img_source=imagecreatefrompng($logo);
			}
			$xjpg = ImageSX($img_source);
			$yjpg = ImageSY($img_source);
			if ($xjpg > $yjpg) {
				$xnew = $width_max;
				$ynew = ($yjpg * $width_max) / $xjpg;
			}
			else {
				$xnew = ($xjpg * $height_max) / $yjpg;
				$ynew = $height_max;
			}
			if ($extension == ".jpg" || $extension == ".jpeg") {
				$new = ImageCreateTrueColor($xnew,$ynew);
				ImageCopyResampled($new,$img_source,0,0,0,0,$xnew,$ynew,$xjpg,$yjpg);
				imagejpeg($new,$img,$qualite);
			}
			if ($extension == ".gif") {
				$new = ImageCreateTrueColor($xnew,$ynew);
				$trans = imagecolorallocate($new,255,255,255);
				imagefilledrectangle($new,0,0,$xnew,$ynew,$trans);
				imagecolortransparent($new,$trans);
				ImageCopyResampled($new,$img_source,0,0,0,0,$xnew,$ynew,$xjpg,$yjpg);
				imagetruecolortopalette($new, true, 256);
				imageinterlace($new);
				imagegif($new,$logo);
			}
			if ($extension == ".png") {
				$new = ImageCreateTrueColor($xnew,$ynew);
				imagealphablending($new, false);
				ImageCopyResampled($new,$img_source,0,0,0,0,$xnew,$ynew,$xjpg,$yjpg);
				imagesavealpha($new, true);
				imagepng($new,$logo);
			}
			imagedestroy($img_source);
			imagedestroy($new);
		}
		//fin de l'upload
	}
	
	
	if ($obj_member->saveMember($member)) {
		if ($member["uid"] == "") {
			$uid = $obj_member->get_id_new_member();
		}
		else {
			$uid = $member["uid"];
			if ($coefs) {
				if (!$obj_member->delLinks($uid)) {
					die("DB problem 1");
				}
			}
		}
		if ($coefs) {
			/*foreach($coefs as $coef) {
				list($poids,$code) = explode("|",$coef);
				if ($poids) {
					$lien = array(
					"id_user" => $uid,
					"id_domain" => $code,
					"coef" => $poids
					);
					if (! $obj_member->saveLink($lien)) {
						die("DB Problem 2");
					}
				}
			}*/
			for ($i=0; $i<count($coefs);$i++) {
				list($poids,$code) = explode("|",$coefs[$i]);
				if ($poids) {
					$lien = array(
					"id_user" => $uid,
					"id_domain" => $code,
					"coef" => $poids,
					"refs" => $refs[$i]
					);
					if (! $obj_member->saveLink($lien)) {
						die("DB Problem 2");
					}
				}
			}
		}
		//expdition d'email au membre inscrit
		$message = _SNEWMEMBERSREGSIRETEREDBODY;
		$message = str_replace("<!--login-->", $member["uname"],$message);
		$message = str_replace("<!--passwd-->", $member["pass"],$message);
		//utilFuncs_simpleMembers::send_email($member["email1"],$adminmail,_SNEWMEMBERSREGSIRETEREDSUB,$message);
		return true;
	}
	else {
		die("DB Problem 3");
	}
}

function delete_member($Id,$confirm="n",$letter,$sortby,$page) {
	if ($Id != "") {
		if ($confirm == "y"){
			$obj_ads = new BD_Members();
			if ($obj_ads->delMember($Id)) {
				return list_members($letter,$sortby,$page);
			}
		}
		else {
			$sortie = "<div style=\"text-align: center; font-weight: bold\">";
			$sortie .= "<p>"._SMEMBERSCONFIRMDELETEMEMEMBER."</p>";
			$sortie .= "<p>&nbsp;</p>";
			$sortie .= "<p>";
			$sortie .= '<a href="system.php?op=members&action=delete_member&onglet=members&Id='.$Id.'&letter='.$letter.'&sortby='.$sortby.'&page='.$page.'&confirm=y">';
			$sortie .= "["._YES."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._NO."]";
			$sortie .= '</a>';
			$sortie .= "</p>";
			$sortie .= "</div>";
			return $sortie;
		}
	}
}

function list_domains() {
	$obj_dom = new BD_Members();
	$results = $obj_dom->getDoms();
	$liste = '<table  class="lisTable">
		<tr class="systemTabHeader">
			<th class="systemTabHeader" style="text-align: left" nowrap=\"nowrap\">'._SMEMBERSDOMCODE.'</th>
			<th class="systemTabHeader" style="text-align: left">'._SMEMBERSDOMNAME.'</th>
			<th class="systemTabHeader" style="text-align: left">'._SMEMBERSDOMDESC.'</th>
   			<th class="systemTabHeader">'._SMEMBERSACTION.'</th>
    		</tr>';
	foreach($results as $result) {
		list($Id, $code,$label,$description) = $result;
		$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=members&action=edit_dom&onglet=doms&Id=".$Id,"comment"=>_EDIT, "status"=>"ON"),
 			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=members&action=delete_dom&onglet=doms&Id=".$Id,"comment"=>_DELETE,"status"=>"ON"));
		if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
		$pos++;
		$debstyle = ($code % 100 ==0) ? "<span style=\"font-weight: bold; font-size: 110%\">" : "";
		$finstyle = ($code % 100 ==0) ? "</span>" : "";
		
		$liste .= '<tr class="'.$thestyle.'">';
		$liste .= '<td>';
		$liste .= $debstyle.$code.$finstyle;
		$liste .= '</td><td>';
		//$liste .= '<a href="system.php?op=jobs&action=list_jobs&onglet=jobs&cat='.$Id.'">';
		$liste .= $debstyle.utilFuncs_simpleMembers::conditionnerHTML($label).$finstyle;
		//$liste .= '</a>';
		$liste .= '</td><td>';
		$liste .= $debstyle.utilFuncs_simpleMembers::conditionnerHTML($description).$finstyle;
		$liste .= '</td><td align="center">';
		$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
		$liste .= '</td>';
		$liste .= '</tr>';
	}
	$liste .= '</table>';
	$liste .= '<div><a href="system.php?op=members&action=add_dom&onglet=doms">'._SMEMBERSADDDOM.'</a></div>';
	return $liste;
}

function edit_domain($Id) {
	$code = "";
	$label = "";
	$description = "";
	if ($Id == "") {
		$Id = "-1";
	}
	if ($Id != "-1") {
		$obj_dom = new BD_Members();
		$results = $obj_dom->getDoms($Id);
		list($Id, $code,$label,$description) = $results[0];
	}
	$sortie = '<form name="editdom" action="system.php?op=members&action=save_dom&onglet=doms" method="POST">';
	$sortie .= '<div align="center">';
	$sortie .= '&nbsp;<br />';
	$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
	$sortie .= '<tr><td>';
	$sortie .= _SMEMBERSDOMCODE;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="code" value="'.$code.'" class="saisie">';
	$sortie .= '</td></tr>';
	$sortie .= '<tr><td>';
	$sortie .= _SMEMBERSDOMNAME;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="label" value="'.$label.'" class="saisie">';
	$sortie .= '</td></tr>';
	$sortie .= '<tr><td>';
	$sortie .= _SMEMBERSDOMDESC;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="description" cols="50" rows="3" class="saisie">'.$description.'</textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._SMEMBERSSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</div>';
	$sortie.= "</form>";
	return $sortie;
}

function save_domain($Id,$code,$label,$description) {
	$dom = array("Id"=>$Id,"code"=>$code,"label"=>$label,"description"=>$description);
	$obj_dom = new BD_Members();
	if (!$obj_dom->saveDom($dom)) {
		die("DB problem");
	}
	return true;
}

function delete_domain($Id,$confirm="n") {
	if ($Id != "") {
		if ($confirm == "y"){
			$obj_ads = new BD_Members();
			if($obj_ads->delDom($Id)) {
				return list_domains();
			}
			else {
				die("DB problem");
			}
		}
		else {
			$sortie = "<div style=\"text-align: center; font-weight: bold\">";
			$sortie .= "<p>"._SMEMBERSCONFIRMDELETEDOM."</p>";
			$sortie .= "<p>&nbsp;</p>";
			$sortie .= "<p>";
			$sortie .= '<a href="system.php?op=members&action=delete_dom&onglet=doms&Id='.$Id.'&confirm=y">';
			$sortie .= "["._YES."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._NO."]";
			$sortie .= '</a>';
			$sortie .= "</p>";
			$sortie .= "</div>";
			return $sortie;
		}
	}
	return list_domains();
}
	
function process_members(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$confirm,$valid,$letter,$sortby;
		global $Id, $code, $label, $description;
		global $uid,$adh_nom1, $adh_prenom1, $adh_civilite1, $adh_email1, $adh_entreprise, $adh_raison, $adh_forme, $adh_siret, $adh_naf, $adh_date_creation;
		global $adh_capital, $adh_effectif, $adh_ca, $adh_adresse, $adh_cp, $adh_ville, $adh_tel, $adh_fax, $adh_web, $adh_nom2, $adh_prenom2, $adh_civilite2, $adh_mobile2;
		global $adh_email2, $adh_nom3, $adh_prenom3, $adh_civilite3, $adh_tel3, $adh_fax3, $adh_email3, $adh_activites, $adh_refs, $adh_clubs, $adh_certifs, $adh_metier, $adh_logo,$adh_logo_new;
		global $adh_metier_radio,$coef, $ref, $adh_domaine, $adh_tranche_ca, $zuname, $zpass; 
		global $user_id,$username,$user_password, $adh_latitude, $adh_longitude;
		global $typestat,$debstat,$finstat;

		include("system/header_system.php");
		if (!isset($action) || (action == "")) {
			$action = "list_members";
		}
		if (!isset($letter) || ($letter == "")) {
			$letter = "All"; 
		}
		if (!isset($sortby)) {
			$sortby = "uname";
		}
		if (!isset($page) || $page == "") {
			$page = 1;
		}
	
		$sortie = "";
		$operationOnglet = "";
		switch ($action) {
			case "list_dom" :
				$sortie = list_domains();
				$operationOnglet = _SMEMBERSLISTDOM;
				break;
			case "edit_dom" :
				$sortie = edit_domain($Id);
				$operationOnglet = _SMEMBERSEDITDOM;
				break;
			case "save_dom" :
				if (save_domain($Id,$code,$label,$description)) {
					$sortie = list_domains();
				}
				$operationOnglet = _SMEMBERSLISTDOM;
				break;
			case "add_dom" :
				$sortie = edit_domain($Id);
				$operationOnglet = _SMEMBERSNEWDOM;
				break;
			case "delete_dom" :
				$sortie = delete_domain($Id,$confirm);
				$operationOnglet = _SMEMBERSLISTDOM;
				break;
				
			case "list_members" :
				$sortie = list_members($letter,$sortby,$page);
				$operationOnglet = _SMEMBERSLIST;
				break;
			case "new_member" :
				$sortie = edit_member("-1");
				$operationOnglet = _SMEMBERSNEW;
				break;
			case "edit_member" :
				$sortie = edit_member($Id);
				$operationOnglet = _SMEMBERSEDIT;
				break;
			case "save_member" :
				$the_member = array(
				"uid" => $uid,
				"uname" => $zuname,
				"adh_nom1" => $adh_nom1,
				"adh_prenom1" => $adh_prenom1,
				"adh_civilite1" => $adh_civilite1,
				"adh_email1" => $adh_email1,
				"adh_entreprise" => $adh_entreprise,
				"adh_raison" => $adh_raison,
				"adh_forme" => $adh_forme,
				"adh_siret" => $adh_siret,
				"adh_naf" => $adh_naf,
				"adh_date_creation" => utilFuncs_simpleMembers::date2AMJ($adh_date_creation),
				"adh_capital" => $adh_capital,
				"adh_effectif" => $adh_effectif,
				"adh_ca" => $adh_ca,
				"adh_adresse" => $adh_adresse,
				"adh_cp" => $adh_cp,
				"adh_ville" => $adh_ville,
				"adh_tel" => $adh_tel,
				"adh_fax" => $adh_fax,
				"adh_web" => $adh_web,
				"adh_nom2" => $adh_nom2,
				"adh_prenom2" => $adh_prenom2,
				"adh_civilite2" => $adh_civilite2,
				"adh_mobile2" => $adh_mobile2,
				"adh_email2" => $adh_email2,
				"adh_nom3" => $adh_nom3,
				"adh_prenom3" => $adh_prenom3,
				"adh_civilite3" => $adh_civilite3,
				"adh_tel3" => $adh_tel3,
				"adh_fax3" => $adh_fax3,
				"adh_email3" => $adh_email3,
				"adh_activites" => $adh_activites,
				"adh_refs" => $adh_refs,
				"adh_clubs" => $adh_clubs,
				"adh_certifs" => $adh_certifs,
				"adh_domaine" => $adh_domaine,
				"adh_tranche_ca" => $adh_tranche_ca,
				"adh_logo" => $adh_logo
				);
				if (isset($adh_metier_radio)) {
					$the_member["adh_metier"] = $adh_metier_radio;
				}
				if (isset($coef)) {
					$the_member["coef"] = $coef;
					$the_member["ref"] = $ref;
				}
				if ($zpass != "") {
					$zpass = htmlspecialchars(stripslashes($zpass,ENT_QUOTES,'ISO-8859-1',true));
					$zpass = md5($zpass);
					$the_member["pass"] = $zpass;
				}
				//print_r ($the_member);
				if (save_member($the_member)) {
					$sortie = list_members($letter,$sortby,$page);
					$operationOnglet = _SMEMBERSLIST;
				}
				break;
			case "delete_member"	 :
				$sortie = delete_member($Id,$confirm,$letter,$sortby,$page);
				$operationOnglet = _SMEMBERSLIST;
				break;
			case "list_membersno" :
				$sortie = list_members_temp();
				$operationOnglet = _SMEMBERSLISTTEMP;
				break;
			case "preview_memberno" :
				$sortie = preview_member_temp($Id);
				$operationOnglet = _SMEMBERSNOEDIT;
				break;
			case "save_memberno" :
				$the_member = array(
				"user_id" => $user_id,
				"uid" => $uid,
				"uname" => $username,
				"adh_nom1" => $adh_nom1,
				"adh_prenom1" => $adh_prenom1,
				"adh_civilite1" => $adh_civilite1,
				"adh_email1" => $adh_email1,
				"adh_entreprise" => $adh_entreprise,
				"adh_raison" => $adh_raison,
				"adh_forme" => $adh_forme,
				"adh_siret" => $adh_siret,
				"adh_naf" => $adh_naf,
				"adh_date_creation" => utilFuncs_simpleMembers::date2AMJ($adh_date_creation),
				"adh_capital" => $adh_capital,
				"adh_effectif" => $adh_effectif,
				"adh_ca" => $adh_ca,
				"adh_adresse" => $adh_adresse,
				"adh_cp" => $adh_cp,
				"adh_ville" => $adh_ville,
				"adh_tel" => $adh_tel,
				"adh_fax" => $adh_fax,
				"adh_web" => $adh_web,
				"adh_latitude" => $adh_latitude,
				"adh_longitude" => $adh_longitude,
				"adh_nom2" => $adh_nom2,
				"adh_prenom2" => $adh_prenom2,
				"adh_civilite2" => $adh_civilite2,
				"adh_mobile2" => $adh_mobile2,
				"adh_email2" => $adh_email2,
				"adh_nom3" => $adh_nom3,
				"adh_prenom3" => $adh_prenom3,
				"adh_civilite3" => $adh_civilite3,
				"adh_tel3" => $adh_tel3,
				"adh_fax3" => $adh_fax3,
				"adh_email3" => $adh_email3,
				"adh_activites" => $adh_activites,
				"adh_refs" => $adh_refs,
				"adh_clubs" => $adh_clubs,
				"adh_certifs" => $adh_certifs,
				"adh_metier" => $adh_metier,
				"adh_domaine" => $adh_domaine,
				"adh_tranche_ca" => $adh_tranche_ca,
				"adh_logo" => $adh_logo
				);
				//print_r ($the_member);
				if ($user_password != "") {
					$the_member["pass"] = $user_password;
				}
				if (save_member_temp($the_member)) {
					$sortie = list_members_temp();
					$operationOnglet = _SMEMBERSLISTTEMP;
				}
				break;
			case "delete_memberno"	 :
				$sortie = delete_member_temp($Id, $confirm);
				$operationOnglet = _SMEMBERSLISTTEMP;
				break;
		}
		
		switch ($action) {
			case "list_stats" :
				require("stats.php");
				$sortie = home_stats();
				$operationOnglet = _SMEMBERSTHESTATS;
			break;
			case "do_stats" :
				require("stats.php");
				$sortie = do_stats($typestat,$debstat,$finstat);
				$operationOnglet = _SMEMBERSTHESTATS;
			break;
		}

		if (!isset($onglet) || $onglet == "") {
			$onglet = "members";
		}
		$ongletDef=array("members"=> array( "text"=>_SMEMBERSLIST, "url"=>"system.php?action=list_members&op=members&onglet=members"),
						"doms"=> array( "text"=>_SMEMBERSDOMAIN, "url"=>"system.php?action=list_dom&op=members&onglet=doms"),
						"membersno"=> array( "text"=>_SMEMBERSTOVALID, "url"=>"system.php?action=list_membersno&op=members&onglet=membersno"),
						"stats"=> array( "text"=>_SMEMBERSSTATS, "url"=>"system.php?action=list_stats&op=members&onglet=stats")
						);

		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_members.css\">";
		GraphicAdmin(_SMEMBERSMODULE);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		//OpenSysTable();
		echo $sortie;
		//CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}
	
//--------------------------------------------------
//            Switch part
//--------------------------------------------------
	switch($op) {
	    case "members":
			process_members();
			break;
	}
}
else {
    display_denied();
}

?>