<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
require_once("images/filetypes/filetypes.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function format_nuke_url_2($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function array_implode( $glue, $separator, $array ) {
    if ( ! is_array( $array ) ) return $array;
    $string = array();
    foreach ( $array as $key => $val ) {
        if ( is_array( $val ) )
            $val = implode( ',', $val );
        $string[] = "{$key}{$glue}{$val}";
       
    }
    return implode( $separator, $string );
   
}

function array_explode( $glue, $separator, $string ) {
	$groupes = explode($separator, $string);
	$sortie = array();
	foreach($groupes as $groupe) {
		list($key, $value) = explode ($glue,$groupe);
		$sortie[$key]=$value;
	}
	return $sortie;
}

function new_comment($id_publi, $id_comment = "", $id="") {
	global $_headerContent, $group, $user,$module_name, $db, $user_prefix, $downloadprivspacecat, $admin;
	global $formatdateprivspacepub;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
    		$userdata[11] = array_explode_2( "@",";", $userdata[11]);
		
		$group_data_bloc = base64_decode($group);
	    	$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
	    $current_group_name = $groupdata[1];
	    //pour affichge de la publi
	    $lignepubli = array();
	    if ($id_publi != "") {
		    $result = $db->sql_query("SELECT id, user_id , id_group , id_news , id_evt , id_topic , id_cat_files , date , titre , description FROM ".$user_prefix."_publi WHERE id='".$id_publi."';");
		    if ($db->sql_numrows($result) > 0) {
		    		$lignepubli = $db->sql_fetchrow($result);
		    		if ($lignepubli["id_group"] != $current_group && !is_admin($admin)) {
		    			die("Accs non autoris !");	
		    		}
		    }
		    else {
		    		die("Publication inexistante !");	
		    }
	    }
	    else {
	    		die("Publication inexistante !");	
	    }
	    	$lignecomment = array();
		$lignecomment["subject"] = "Re: ".$lignepubli["titre"];
		$thecomment = "";
	    //pour rponse  un commentaire
		if ($id_comment != "") {
	    		$result = $db->sql_query("SELECT id, subject, comment, user, date FROM ".$user_prefix."_publi_comments WHERE id='".$id_comment."';");
		    if ($db->sql_numrows($result) > 0) {
		    		$lignecomment = $db->sql_fetchrow($result);
		    		if ($lignepubli["id_group"] != $current_group && !is_admin($admin)) {
		    			die("Accs non autoris !");	
		    		}
		    		$subject = $lignecomment["subject"];
				$comment = $lignecomment["comment"];
		    		$lignecomment["subject"] = "Re: ".$lignecomment["subject"];
		    		$lignecomment["comment"] = "";

		    		$thecomment .= "<br /><div class=\"publi\">";
		    		$thecomment .= "<div class=\"comment\">";
				$thecomment .= "<span class=\"titre\">".$subject."</span>";
				$thecomment .= "<span class= \"auteur\">Post le ".utilFuncs_simpleSpace::date2JMA($lignecomment["date"],$formatdateprivspacepub)." par ".$lignecomment["user"]."</span>";
				$thecomment .= "<div class=\"commentbody\">".$comment."</div>";
				$thecomment .= "</div>";
				$thecomment .= "</div>";
		    }
		    else {
		    		die("Commentaire inexistant !");	
		    }
	    }
	    //pour dition du commentaire
	    if ($id != "") {
	    		$result = $db->sql_query("SELECT id, subject , comment, id_user FROM ".$user_prefix."_publi_comments WHERE id='".$id."';");
		    if ($db->sql_numrows($result) > 0) {
		    		$lignecomment = $db->sql_fetchrow($result);
		    		if ($lignecomment["id_user"] != $userdata[0] && !is_admin($admin)) {
		    			die("Accs non autoris !");	
		    		}
		    }
		    else {
		    		die("Commentaire inexistant !");	
		    }
	    }
	    
	    	$_headerContent ='
<script language="Javascript" src="javascripts/control_form.js"></script>
<script language="JavaScript" src="javascripts/lang/lang-french.js"></script>
<script type="text/javascript" src="javascripts/fckeditor/fckeditor.js"></script>
<script type="text/javascript" src="javascripts/initfck.js"></script>
';
	
		setHeader($_headerContent);
		
		$sortie = "";
		$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
		$sortie .= "<form action=\"modules.php?name=".$module_name."\" method=\"post\" onsubmit=\"return submit_form(this)\">";
	    	$sortie .= '<input type="hidden" name="op" value="savecomment">';
	    	$sortie .= '<input type="hidden" name="file" value="comments">';
	    	$sortie .= '<input type="hidden" name="data[id]" value="'.$id.'">';
	    	$sortie .= '<input type="hidden" name="data[id_publi]" value="'.$id_publi.'">';
	    	$sortie .= '<input type="hidden" name="data[id_comment]" value="'.$id_comment.'">';
	
	    	if ($id == "") {
	    		$sortie .= '<h2>'._COMSPACE_NEWCOMM.'</h2>';
	    	}
	    	else {
	    		$sortie .= '<h2>'._COMSPACE_EDITCOMM.'</h2>';
	    	}
		$sortie .= '
		<fieldset class="newpub"><legend>'._COMSPACE_THEPUBLI.'</legend>
			<h2>'.$lignepubli["titre"].'</h2>
			'.$lignepubli["description"].'
			'.$thecomment.'
		</fieldset>
		<br />
		<fieldset class="newpub"><legend>'._COMSPACE_THECOMM.'</legend>
	    <table cellspacing="5" cellpadding="0" border="0" align="center" summary="">
		    <tr>
		        <td class="label">
		        <p>'._COMSPACE_COMMSUBJECT.'</p>
		        </td>
		        <td class="content"><champ lib="'._COMSPACE_TITLE_VERIF.'" nom="data[subject]" lim="1,100"></champ><input type="text" name="data[subject]" value="'.$lignecomment["subject"].'" class="saisiepub" /></td>
		    </tr>
		    <tr>
		        <td class="label">
		        <p>'._COMSPACE_COMMBODY.'</p>
		        </td class="content">
		        <td><!--<champ lib="'._COMSPACE_BODY_VERIF.'" nom="data[comment]" lim="1,4000"></champ>-->
<div class="dimztexte"><div class="encadreedit">
<textarea id="data[comment]" cols="70" rows="30" name="data[comment]">'.$lignecomment["comment"].'</textarea>
<script type="text/javascript">editSix("data[comment]");</script></div></div></td>
		    </tr>
		</table>
		</fieldset>
	';
		$sortie .= "<div align=\"center\"><input type=\"submit\" value=\""._COMSPACE_NEWCOMM_SAVE."\"></div>";
	    	
	    	$sortie .= "</form>";
		
	    include("header.php");	
	    	echo $sortie;
	    	$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" );
		buttonBar($bardef, "align");
		include("footer.php");
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function save_comment($data) {
	global $module_name, $user_prefix, $db,$user, $group;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
	    	$userdata = explode(":", $user_data_bloc);
		
	    	$group_data_bloc = base64_decode($group);
    		$groupdata = explode(":", $group_data_bloc);
	    $current_group = $groupdata[0];
	    $current_group_name = $groupdata[1];	
	    	
//print_r($data);
		

		$sql = "SELECT `id`, `user_id` , `id_group` , `id_news` , `id_evt` , `id_topic` , `id_cat_files` , `date` , `titre` , `description` FROM `".$user_prefix."_publi` WHERE `id`=".$data["id_publi"].";";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			$lignepubli = $db->sql_fetchrow($result);
	    		if ($lignepubli["id_group"] != $current_group && !is_admin($admin)) {
	    			die("Accs non autoris !");	
	    		}
		}
		else {
			die("Publication inexistante !");
		}
		
		//enregistrement commentaire
		$data = array_map(array('utilFuncs_simpleSpace', 'conditionnertodb'), $data);
		if ($data["id"] != "") {
			$sql = "UPDATE ".$user_prefix."_publi_comments SET subject='".$data["subject"]."', comment='".$data["comment"]."' WHERE id='".$data["id"]."'";
			$ok = $db->sql_query($sql);
		}
		else {
			$date = date("Y-m-d H:i:s");
			$ip = $_SERVER['REMOTE_ADDR'];
			$sql = "INSERT INTO ".$user_prefix."_publi_comments (`id_comment` , `id_publi` , `date` , `id_user` , `user` , `host_name` , `subject` , `comment`)";
			$sql .= " VALUES ('".$data["id_comment"]."', '".$data["id_publi"]."','".$date."','".$userdata[0]."', '".$userdata[1]."', '".$ip."', '".$data["subject"]."', '".$data["comment"]."')";
			$ok = $db->sql_query($sql);
		}

	//expdition des e-mail
		if ($ok) {
			$data = array_map(array('utilFuncs_simpleSpace', 'anti_conditionnertodb'), $data);
			global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
			$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
			require_once("system/modules/becmsNewsletter/class.html2text.inc");
			$h2t = new html2text($data["comment"],false,70);
	  		$comment_text = $h2t->get_text();
			//suppression & commercial
			$comment_text = str_replace("&amp;","&",$comment_text);
			//fin suppression
			$nukeurl = format_nuke_url_2($nukeurl);
			//$publink = "$nukeurl/modules.php?name=$module_name&op=showpub&id=".$id_publi;
			$publink = "$nukeurl/workspace_".$data["id_publi"].".htm";
			$saut = "\n";
			$sep = "--------------------------------------------------\n";
			
			$sujet = "Commentaire dans le groupe \"".$current_group_name."\" par ".$userdata[1];
			$message = "";
			$message .= "Commentaire de ".$userdata[1]." pour la publication \"".$lignepubli["titre"]."\" dans le groupe \"".$current_group_name."\" sur l'espace collaboratif de \"".$sitename."\" : ".$saut.$saut;
			$message .= $data["subject"].$saut;
			$message .= $comment_text.$saut.$saut;
			
			$message .= $sep;
			$message .= "Date du commentaire : ".date("d/m/Y H:i").$saut;
			$message .= "Voir la publication : ".$publink.$saut;
			$obj_pub = new utilFuncs_simpleSpace();
			$okmail = true;
			$sql = "SELECT uname, email, user_name, user_firstname FROM ".$user_prefix."_users INNER JOIN ".$user_prefix."_users_groups on user_id=uid WHERE group_id ='".$current_group."'";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while ($leusers = $db->sql_fetchrow($result)) {
					$okmail = $ok && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message,$mailadminprivspacepub);
				}
			}
			if (!$okmail) {
				die("Erreur d'expdition de mail !");
			}
		}
		if (!$ok) {
			die("Erreur d'enregistrement dans la base de donnes !");
		}
		header("Location: workspace_".$data["id_publi"].".htm");
		die();
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function displayComment($lignecomment, $userdata) {
	global $formatdateprivspacepub, $module_name, $db, $user_prefix, $admin;
	
	$sortie = "";
	$sortie .= "<div class=\"comment\">";
	$sortie .= "<a name=\"".$lignecomment["id"]."\"></a>";
	$sortie .= "<span class=\"titre\">".$lignecomment["subject"]."</span>";
	$sortie .= "<span class= \"auteur\">Post le ".utilFuncs_simpleSpace::date2JMA($lignecomment["date"],$formatdateprivspacepub)." par ".$lignecomment["user"]."</span>";
	$sortie .= "<div class=\"commentbody\">".$lignecomment["comment"]."</div>";
	$sortie .= "<div class=\"actcomment\">";
	$sortie .= "<a href=\"modules.php?name=".$module_name."&op=newcomment&file=comments&id_comm=".$lignecomment["id"]."&id_publi=".$lignecomment["id_publi"]."\">[ Rpondre ]</a>";
	if ($lignecomment["id_user"] == $userdata[0] || is_admin($admin)) {
		$sortie .= "&nbsp;&nbsp;";
		$sortie .= "<a href=\"modules.php?name=".$module_name."&op=editcomment&file=comments&id_publi=".$lignecomment["id_publi"]."&id=".$lignecomment["id"]."\">[ Modifier ]</a>";
	}
	$sortie .= "</div>";
	$sortie .= "</div>";
	$sql = "SELECT `id`, `id_comment` , `id_publi` , `date` , `id_user` , `user` , `host_name` , `subject` , `comment`";
	$sql .= " FROM `".$user_prefix."_publi_comments`";
	$sql .= " WHERE id_comment='".$lignecomment["id"]."' ORDER BY date ASC;";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		while ($lignecomment = $db->sql_fetchrow($result)) {
			$sortie .= "<div class=\"nested\">";
			$sortie .= displayComment($lignecomment,$userdata);
			$sortie .= "</div>";
		}
	}
	return $sortie;
}

function show_comments($id) {
	global $db, $user_prefix, $user;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
    		$userdata[11] = array_explode( "@",";", $userdata[11]);
	}
	else {
		die("Accs non autoris !");
	}
	
	$sortie = "";
	$sql = "SELECT `id`, `id_comment` , `id_publi` , `date` , `id_user` , `user` , `host_name` , `subject` , `comment`";
	$sql .= " FROM `".$user_prefix."_publi_comments`";
	$sql .= " WHERE id_publi='".$id."' AND id_comment='0' ORDER BY date ASC;";	
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		while ($lignecomment = $db->sql_fetchrow($result)) {
			$sortie .= displayComment($lignecomment, $userdata);
		}
	}
	else {
		$sortie .= "<div class=\"comment\">";
		$sortie .= "Aucun commentaire pour cette publication.";
		$sortie .= "</div>";
	}
	return $sortie;
}

function delfile($id_file, $id, $ok="n") {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub, $nukeurl;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
    		$userdata = explode(":", $user_data_bloc);
    		
    		$group_data_bloc = base64_decode($group);
    		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
    		$current_group_name = $groupdata[1];
    		
    		$sql = "SELECT `title`, `titre` FROM ".$user_prefix."_downloads_downloads";
		$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid";
		$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi_lien_download.id_publi=".$user_prefix."_publi.id";
		$sql .= " WHERE ".$user_prefix."_publi_lien_download.id_publi='".$id."' AND lid='".$id_file."';";

		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
		}
		else {
			die("Autorisation refuse !");
		}
    		if ($ok=="y") {
    			$go = true;
    			$result = $db->sql_query("SELECT `title`,`url` FROM ".$user_prefix."_downloads_downloads WHERE lid='".$id_file."';");
			list($title, $url) = $db->sql_fetchrow($result);
    			$go = $go && $db->sql_query("DELETE FROM ".$user_prefix."_publi_lien_download WHERE id_download='".$id_file."';");
    			$go = $go && $db->sql_query("DELETE FROM ".$user_prefix."_downloads_downloads WHERE lid=".$id_file.";");
			$go = $go && unlink($url);
			
	    		//expdition des e-mail
			if ($go) {
				global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
				$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
				$nukeurl = format_nuke_url_2($nukeurl);
				//$publink = "$nukeurl/modules.php?name=$module_name&op=showpub&id=".$id_publi;
				$publink = "$nukeurl/workspace_".$id.".htm";

				$saut = "\n";
				$sep = "--------------------------------------------------\n";
				
				$sujet = "Modification de publication dans le groupe \"".$current_group_name."\" par ".$userdata[1];
				$message = "";
				$message .= "Modifications de la publication \"".$ligne["titre"]."\" de ".$userdata[1]." dans le groupe \"".$current_group_name."\" sur l'espace collaboratif de \"".$sitename."\" : ".$saut.$saut;
				$message .= $sep;
				$message .= "Suppression du fichier \"".$ligne["title"]."\"".$saut.$saut;
				$message .= $sep;
				$message .= "Date de la suppression : ".date("d/m/Y H:i").$saut;
				$message .= "Voir la publication : ".$publink.$saut;
				$obj_pub = new utilFuncs_simpleSpace();
				$okmail = true;
				$sql = "SELECT uname, email, user_name, user_firstname FROM ".$user_prefix."_users INNER JOIN ".$user_prefix."_users_groups on user_id=uid WHERE group_id ='".$current_group."'";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while ($leusers = $db->sql_fetchrow($result)) {
						$okmail = $ok && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message, $mailadminprivspacepub);
					}
				}
				if (!$okmail) {
					die("Erreur d'expdition de mail !");
				}
			}
			
    			header("Location: modules.php?name=$module_name&op=editpub&id=$id");
    			die();	
    		}
    		else {
  			$titre_group = "";
			if ($current_group_name != "") {
				$titre_group = '<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span>';
			}
		
			$sortie = "<h1>"._COMSPACE.$titre_group."</h1>";
			$sortie .= "<p style=\"text-align: center; font-weight: bold\"><br />".$ligne["title"]."</p>";
			$sortie .= "<p style=\"text-align: center\"><br />"._COMSPACE_DELFILE_CONF."</p>";
			$sortie .= "<p style=\"text-align: center\"><br /><a href=\"modules.php?name=".$module_name."&op=delfile&file=files&id=".$id."&id_file=".$id_file."&ok=y\">[ "._YES." ]</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:window.history.back()\">[ "._NO." ]</a></p>";
			
			include("header.php");
			//Accueil de l'espace collaboratif !!!!!
		    	echo $sortie;
			include("footer.php");	
    		}
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function swap_files($id_publi,$id_file) {
		global $tabsortie,$module_name,$Default_Theme, $user_prefix, $db;
		global $group, $user;
		
		if (is_user($user)) {
			$user_data_bloc = base64_decode($user);
	    		$userdata = explode(":", $user_data_bloc);
	    		$userdata[11] = array_explode( "@",";", $userdata[11]);
			
			$group_data_bloc = base64_decode($group);
		    	$groupdata = explode(":", $group_data_bloc);
			$current_group = $groupdata[0];
		    $current_group_name = $groupdata[1];
		    
			$lignepubli = array();
		    if ($id != "") {
			    $result = $db->sql_query("SELECT user_id FROM ".$user_prefix."_publi WHERE id='".$id_publi."';");
			    if ($db->sql_numrows($result) > 0) {
			    		$lignepubli = $db->sql_fetchrow($result);
			    		if ($lignepubli["user_id"] != $userdata[0] && !is_admin($admin)) {
			    			die("Accs non autoris !");	
			    		}
			    }
			    else {
			    		die("Publication inexistante !");	
			    }
		    }
			
			$list_fichiers = "";
	 		$sql = "SELECT `lid`, `title`, `url`, `filesize` FROM ".$user_prefix."_downloads_downloads";
	    		$sql .= " WHERE lid='".$id_file."';";
	 		$result = $db->sql_query($sql);
	    		if ($db->sql_numrows($result) == 1) {
	    			$ligne = $db->sql_fetchrow($result);
	    			$lapubli ="<p>&nbsp;</p>";
	    			$lapubli .= "<h2>Fichier  remplacer</h2>";
	 			$lapubli .= '<p><span style="width: 30px;display: block; float: left"><img src="'.get_icon_for_file($ligne["url"]).'"></span>'.$ligne["title"]." ".utilFuncs_simpleSpace::coolSize($ligne["filesize"])."<br />&nbsp;</p>";
	 			$lapubli .="<p>&nbsp;</p>";
	 			$lapubli .= "<h2>Nouveau fichier</h2>";
	    			$lapubli .= '<input type="hidden" name="op" value="savenewfile">';
	    			$lapubli .= '<input type="hidden" name="name" value="'.$module_name.'">';
	    			$lapubli .= '<input type="hidden" name="thefile[id_publi]" value="'.$id_publi.'">';
	    			$lapubli .= '<input type="hidden" name="thefile[id_file]" value="'.$id_file.'">';
	    			$lapubli .= '<input type="hidden" name="file" value="files">';
	    			$lapubli .= '<input type="hidden" name="thefile[url][]" value="'.$ligne["url"].'">';
	    			$lapubli .= '<p><input type="file" name="newfiles[]" value="" size="50" class="fichier"></p>
							<p>'._COMSPACE_NEWPUB_FILENAME.'<input type="text" name="thefile[nomfichier][]" value="'.$ligne["title"].'" size="50" maxlength="100" class="credit"></p>';
	    		}
	    		else {
	    			$lapubli .= "";
	    		}
		
			echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
		<title>change de fichier</title>
		<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/style.css" media="screen, handheld" type="text/css">
		<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/'.$module_name.'.css" media="screen, handheld" type="text/css">
	</head>

	<body style="background-color: transparent">';
			echo "<form action=\"modules.php\" method=\"post\" enctype=\"multipart/form-data\">";;
			echo $lapubli;
			echo '<p style="text-align: center;"><br>&nbsp;<br><input type="submit" value="'._COMSPACE_NEWFILE_REPLACE.'" onclick="validonecat(this);parent.win.close()"></p>';
			echo '</form>';
			echo '</body></html>';
		}
		else {
			die();
		}
	}
	
	function closeWindow() {
		global $module_name, $db, $user_prefix, $aid, $admin,$admincontroltypos,$header_system;
		global $letter, $selectuser;
		
		$sortie = '
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
		<title>change de fichier</title>
<script type="text/javascript">	
	function fermerWin() {
		parent.location.reload();
		parent.win.destroy();
	}
</script>
	</head>
	<body onload="fermerWin()">
	</body>
</html>';
		return $sortie; 
		
	}
	
	function saveNewFile ($thefile) {
		global $publisizemaxphoto, $user_prefix, $db,$user,$group;
		$ok = false;
		if (count($_FILES["newfiles"]) > 0) {
			$ok = true;
			$idfichiers = array();
			global $publisizemaxphoto;
			list($width,$height) = explode("/",$publisizemaxphoto);
			$filesSaved = uploadFiles($_FILES["newfiles"], "", $width, $height, $thefile["url"]);
			if (count($filesSaved) > 0) {
				$sql = "SELECT `title`, `titre` FROM ".$user_prefix."_downloads_downloads";
				$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid";
				$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi_lien_download.id_publi=".$user_prefix."_publi.id";
				$sql .= " WHERE ".$user_prefix."_publi_lien_download.id_publi='".$thefile["id_publi"]."' AND lid='".$thefile["id_file"]."';";
		
				$result = $db->sql_query($sql);
				$ligne = array();
				if ($db->sql_numrows($result) > 0) {
					$ligne = $db->sql_fetchrow($result);
				}
				else {
					die("Autorisation refuse !");
				}
			}
			for($i=0 ; $i < count($filesSaved) ; $i++) {
				$fileSavedName = $filesSaved[$i]["nom"];
				$fileSavedWeight = $filesSaved[$i]["poids"];
				$nomfichier = utilFuncs_simpleSpace::conditionnertodb($thefile["nomfichier"][$i]);
				//$filesize = filesize($fileSaved); //bug : ne fonctionne pas chez OVH !
	    			$date = date("Y-m-d H:i:s");
	    			$sql = "UPDATE ".$user_prefix."_downloads_downloads SET url='".$fileSavedName."', title='".$nomfichier."', `date`='".$date."', filesize='".$fileSavedWeight."' WHERE lid='".$thefile["id_file"]."'";
	    			$ok =  $ok && $db->sql_query($sql);
			}
		//expdition des e-mail
			if ($ok) {
				$user_data_bloc = base64_decode($user);
		    		$userdata = explode(":", $user_data_bloc);
		    		
		    		$group_data_bloc = base64_decode($group);
		    		$groupdata = explode(":", $group_data_bloc);
				$current_group = $groupdata[0];
		    		$current_group_name = $groupdata[1];
				
				global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
				$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
				$nukeurl = format_nuke_url_2($nukeurl);
				//$publink = "$nukeurl/modules.php?name=$module_name&op=showpub&id=".$id_publi;
				$publink = "$nukeurl/workspace_".$thefile["id_publi"].".htm";
				//$downloadlink = "$nukeurl/modules.php?name=Downloads&d_op=getit&lid=";
				//$postfixe = "";
				$downloadlink = "$nukeurl/file_";
				$postfixe = ".htm";

				$saut = "\n";
				$sep = "--------------------------------------------------\n";
				
				$sujet = "Modification de publication dans le groupe \"".$current_group_name."\" par ".$userdata[1];
				$message = "";
				$message .= "Modifications de la publication \"".$ligne["titre"]."\" de ".$userdata[1]." dans le groupe \"".$current_group_name."\" sur l'espace collaboratif de \"".$sitename."\" : ".$saut.$saut;
				$message .= $sep;
				$message .= "Remplacement du fichier \"".$ligne["title"]."\" par le fichier "."\"".$thefile["nomfichier"][0]."\"".$saut.$saut;
				$message .= "Tlchargez le fichier : ".$downloadlink.$thefile["id_file"].$postfixe.$saut.$saut;
				$message .= $sep;
				$message .= "Date du remplacement : ".date("d/m/Y H:i").$saut;
				$message .= "Voir la publication : ".$publink.$saut;
				$obj_pub = new utilFuncs_simpleSpace();
				$okmail = true;
				$sql = "SELECT uname, email, user_name, user_firstname FROM ".$user_prefix."_users INNER JOIN ".$user_prefix."_users_groups on user_id=uid WHERE group_id ='".$current_group."'";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while ($leusers = $db->sql_fetchrow($result)) {
						$okmail = $ok && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message, $mailadminprivspacepub);
					}
				}
				if (!$okmail) {
					die("Erreur d'expdition de mail !");
				}
			}
		}
		return $ok;
	}
	
	function uploadFiles($fichiersUpload, $chemin="", $maxWith = 0, $maxHeight = 0, $url=array()) {
		if (count($url) == 0){
			$chemin = rtrim($chemin, "/");
			
			if (!file_exists($chemin)) {
				//$old = umask(0);
				if (!mkdir($chemin,0777,true)) {
					 die("Impossible de crer le dossier de destination de l'upload !");
				}
				touch($chemin."/index.htm");
				//chmod($chemin, "0777");
				//umask($old);
			}
		}
		
		$fichier = array();
		
		for ($i=0; $i<count($fichiersUpload["name"]); $i++) {
			if ($fichiersUpload["name"][$i] != "") {
				if (count($url) > 0) {
					$nomDestination = basename($url[$i]);
					$nomDestination = substr($nomDestination,0,strrpos($nomDestination,".")).strrchr($fichiersUpload["name"][$i],'.');
					$chemin = dirname($url[$i]);
					if (!file_exists($chemin)) {
						if (!mkdir($chemin,0777,true)) {
							 die("Impossible de crer le dossier de destination de l'upload !");
						}
						touch($chemin."/index.htm");
					}
				}
				else {
					$nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
					while (file_exists($chemin."/".$nomDestination)) {
						$nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
					}
				}
				if (is_uploaded_file($fichiersUpload["tmp_name"][$i])) {
					//$fichier[$i] = strtolower($chemin."/".$nomDestination);
					//$fichier[$i] = str_replace($_SERVER['DOCUMENT_ROOT'],'',realpath($chemin)."/".$nomDestination);
					$fichier[$i] = str_replace(realpath("."),'',realpath($chemin)."/".$nomDestination);
					$fichier[$i] = array("nom"=>trim($fichier[$i], "/"),"poids"=>filesize($fichiersUpload["tmp_name"][$i]));
					if (count($$url) > 0) {
						unlink($url[$i]);
					}
					if (rename($fichiersUpload["tmp_name"][$i],$fichier[$i]["nom"])) {
						chmod($fichier[$i]["nom"],0777);
						
						$extension = strtolower(strrchr($fichier[$i]["nom"],'.'));
						
						if ($extension == '.jpg' || $extension == '.jpeg' || $extension == '.gif' || $extension == '.png') {
							$size = getimagesize($fichier[$i]["nom"]);
							$width = $size[0];
							$height = $size[1];
						}
						else {
							$width = 0;
							$height = 0;
						}
						//test si les dimensions de l'image sont correctes et sinon applique le redimensionnement
						if ($width >= $maxWith || $height >= $maxHeight) {
							//calcul nouvelle taille
							if (($width/$maxWith) > ($height/$maxHeight)) {
								if ($maxWith != 0) {
									$newwidth = $maxWith;
									$newheight = ($height * $maxWith) / $width;
								}
								else {
									$newwidth = ($width * $maxHeight) / $height;
									$newheight = $maxHeight;
								}
							}
							else {
								if ($maxHeight != 0) {
									$newwidth = ($width * $maxHeight) / $height;
									$newheight = $maxHeight;
								}
								else {
									$newwidth = $maxWith;
									$newheight = ($height * $maxWith) / $width;
								}
							}
							//pour les cas des jpg
							if($extension == '.jpg' || $extension == '.jpeg') {
								$src = imagecreatefromjpeg($fichier[$i]["nom"]);
								$tmp=imagecreatetruecolor($newwidth,$newheight);
								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
								imagejpeg($tmp,$fichier[$i]["nom"],70);
								imagedestroy($src);
								imagedestroy($tmp);
							}
							//pour les cas des gif
							if($extension == '.gif') {
								$src = imagecreatefromgif($fichier[$i]["nom"]);
								$tmp=imagecreatetruecolor($newwidth,$newheight);
								$trans = imagecolorallocate($tmp,255,255,255);
								imagefilledrectangle($tmp,0,0,$newwidth,$newheight,$trans);
								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
								imageinterlace($tmp);
								imagegif($tmp,$fichier[$i]["nom"]);
								imagedestroy($src);
								imagedestroy($tmp);
							}
							//pour les cas des png
							if($extension == '.png') {
								$src = imagecreatefrompng($fichier[$i]["nom"]);
								$tmp=imagecreatetruecolor($newwidth,$newheight);
								imagealphablending($tmp, false);
								imagesavealpha($tmp, true);
								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
								$fond_noir = imagecolorallocate($destination, 0, 0, 0);
								imagecolortransparent($destination, $fond_noir);
								imagepng($tmp,$fichier[$i]["nom"]);
								imagedestroy($src);
								imagedestroy($tmp);
							}
						}
					}
					else {
						die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
					}          
				}
				else {
					die("Le fichier n'a pas t upload (trop gros ? droits ?)");
				}
			}
		}
		return $fichier;
	}

// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "swapfiles":
		swap_files($id_publi,$id_file);
		break;
	case "savenewfile":
		if (saveNewFile($thefile)) {
			$sortie = closeWindow();
		}
		else {
			$sortie = swap_files($thefile["id_publi"],$thefile["id_file"]);
		}
		echo $sortie;
		break;
	case "delfile":
		delfile($id_file, $id, $ok);
		break;
	case "savecomment":
		save_comment($data);
		break;
	case "editcomment":
		new_comment($id_publi,"",$id);
		break;
	default:
		$sortie .= show_comments($id,$user_data);//$id est l'identifiant de la publication !!!
		break;
}

?>