<?php
if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
require_once("images/filetypes/filetypes.php");
require_once("modules/$module_name/utils.php");

if (file_exists("modules/SimpleUsersStats/stats.php")) {
	require_once("modules/SimpleUsersStats/stats.php");
	$stat_membre = new membersStats();
}
function ajoutStat($action) {
	global $stat_membre;
	if (isset($stat_membre)) {
		$stat_membre->add_action($action);
	}
}

function array_explode( $glue, $separator, $string ) {
	$groupes = explode($separator, $string);
	$sortie = array();
	foreach($groupes as $groupe) {
		list($key, $value) = explode ($glue,$groupe);
		$sortie[$key]=$value;
	}
	return $sortie;
}

function docookiegroup($id,$groupe) {
	undocookiegroup();
	$info = base64_encode("$id:$groupe");
	setcookie("group","$info",time()+604800);
	//ajout vince pour prise en compte immdiate
	global $group;
	$group = $info;
}

function undocookiegroup(){
	setcookie ("group", "", time() - 3600);
}

function verif_user_group($groupfix) {
	global $user, $module_name, $db, $user_prefix;

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
	}
	else {
		return false;
	}
	$sql = "SELECT id from ".$user_prefix."_users_groups WHERE user_id='".$userdata[0]."' AND group_id='$groupfix';";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		return true;
	}
	else {
		return false;
	}
}

function main($user) {
	global $module_name;

	if(!is_user($user)) {
		header("Location: mobiles.php?name=$module_name&op=login");
	}
	elseif (is_user($user)) {
		header("Location: mobiles.php?name=$module_name&op=space");
		die();
	}
}

function space($groupfix="") {
	global $user, $group, $module_name, $db, $user_prefix, $Default_Theme;
	global $scripts_extra;

	if ($groupfix != "") {
		if (!verif_user_group($groupfix)) die("Vous n'tes pas autoris  participer  ce groupe !");
	}

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$user_data_bloc = stripslashes($user_data_bloc);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		if (isset($groupfix) && $groupfix != "") {
			$sql = "SELECT name from ".$user_prefix."_groups WHERE id='".$groupfix."'";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 1) {
				$ligne = $db->sql_fetchrow($result);
				docookiegroup($groupfix,$ligne["name"]);
				$current_group = $groupfix;
				$current_group_name = $ligne["name"];
			}
		}
		else {
			$group_data_bloc = base64_decode($group);
			$groupdata = explode(":", $group_data_bloc);
			if (is_array($groupdata) && in_array($groupdata[1], $userdata[11])) {
				$current_group = $groupdata[0];
				$current_group_name = $groupdata[1];
			}
			else {
				$current_group = key($userdata[11]);
				$current_group_name = $userdata[11][key($userdata[11])];
				docookiegroup($current_group,$current_group_name);
			}
		}
		
		if (file_exists('themes/'.$Default_Theme.'/pattern_space_main.php')) {
			//rcup 15 derniers posts
			$publis = array();
			$sql = "SELECT ".$user_prefix."_publi.id, user_id, id_group, id_news, id_evt, id_topic, id_cat_files, ".$user_prefix."_publi.date, titre, description, uname, user_name, user_firstname, COUNT(".$user_prefix."_publi_comments.id) AS nbrecomment";
			$sql .= " FROM ".$user_prefix."_publi";
			$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
			$sql .= " LEFT JOIN ".$user_prefix."_publi_comments on ".$user_prefix."_publi_comments.id_publi=".$user_prefix."_publi.id";
			$sql .= " WHERE id_group='".$current_group."' AND a_voir='0'";
			$sql .= " GROUP BY ".$user_prefix."_publi.id";
			$sql .= " ORDER BY date DESC LIMIT 15";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$publis[] = $ligne; 
				}
			}
			//rcup 15 derniers fichiers
			$fichiers = array();
			$sql = "SELECT `lid`, `title`, ".$user_prefix."_downloads_downloads.`url` ,`submitter`, ".$user_prefix."_downloads_downloads.`date`, `filesize` , titre, ".$user_prefix."_publi.id, user_name, user_firstname FROM ((".$user_prefix."_downloads_downloads";
			$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id=".$user_prefix."_publi_lien_download.id_publi)";
			$sql .= " LEFT JOIN ".$user_prefix."_users on uname=submitter";
			$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."' ORDER BY ".$user_prefix."_downloads_downloads.date DESC LIMIT 15";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$fichiers[] = $ligne;
				}
			}
			//rcup 15 derniers vnements
			$evts = array();
			$sql = "SELECT `eid`, `aid`, `title`, `informant`, `eventDate`, `endDate`, `startTime`, `endTime`, `alldayevent`, `withregistration`, ".$user_prefix."_publi.id, ".$user_prefix."_publi.date, ".$user_prefix."_publi.titre, user_name, user_firstname FROM ".$user_prefix."_events ";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id_evt=".$user_prefix."_events.eid";
			$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
			$sql .= " WHERE ".$user_prefix."_events.eventDate >= CURDATE() AND ".$user_prefix."_publi.id_group='".$current_group."' ORDER BY ".$user_prefix."_events.eventDate DESC, ".$user_prefix."_events.startTime DESC;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 0) {
				$sql = "SELECT `eid`, `aid`, `title`, `informant`, `eventDate`, `endDate`, `startTime`, `endTime`, `alldayevent`, `withregistration`, ".$user_prefix."_publi.id, ".$user_prefix."_publi.date,".$user_prefix."_publi.titre, user_name, user_firstname FROM ".$user_prefix."_events ";
				$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id_evt=".$user_prefix."_events.eid";
				$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
				$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."' ORDER BY ".$user_prefix."_events.eventDate DESC, ".$user_prefix."_events.startTime DESC LIMIT 15;";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while($ligne = $db->sql_fetchrow($result)) {
						$evts[] = $ligne;
					}
				}
			}
			else {
				$nbrefiches  = $db->sql_numrows($result);
				while($ligne = $db->sql_fetchrow($result)) {
					$evts[] = $ligne;
				}
				for ($i = 0; $i < ($nbrefiches - 15); $i++) {
					array_shift($evts);
				}
				$evts = array_reverse($evts);
			}
			//rcup 15 derniers messages perso
			$messin = array();
			$sql = "SELECT `msg_id`, `subject`,`msg_text`, `msg_time`, `from_userid`, `uname`, `read_msg`, user_name, user_firstname FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE to_userid = '".$userdata[0]."' AND `valid`='1' ORDER BY msg_time DESC LIMIT 15;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$messin[] = $ligne;
				}
			}
			
			//rcup 15 derniers messages perso envoys
			$messout = array();
			$sql = "SELECT `msg_id`, `subject`, `msg_text`, `msg_time`, `from_userid`, `uname`, `read_msg`,  user_name, user_firstname FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.to_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE from_userid = '".$userdata[0]."' ORDER BY msg_time DESC LIMIT 15;";

			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$messout[] = $ligne;
				}
			}
			//rcup posts prioritaires
			$publis_first = array();
			$sql = "SELECT ".$user_prefix."_publi.id, user_id, id_group, id_news, id_evt, id_topic, id_cat_files, ".$user_prefix."_publi.date, titre, description, uname, user_name, user_firstname, COUNT(".$user_prefix."_publi_comments.id) AS nbrecomment";
			$sql .= " FROM ".$user_prefix."_publi";
			$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
			$sql .= " LEFT JOIN ".$user_prefix."_publi_comments on ".$user_prefix."_publi_comments.id_publi=".$user_prefix."_publi.id";
			$sql .= " WHERE id_group='".$current_group."' AND a_voir='1'";
			$sql .= " GROUP BY ".$user_prefix."_publi.id";
			$sql .= " ORDER BY date DESC;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$publis_first[] = $ligne;
				}
			}
			
			$obj_utils = new utilFuncs_simpleSpace();
			
			require_once('themes/'.$Default_Theme.'/pattern_space_main.php');
		}
		else {
			$titre_group = "";
			if ($current_group_name != "") {
				$titre_group = '<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span>';
			}
	
			if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
				$icn = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
			}
			else {
				$icn = 'images/deletesmall.gif';
			}
			if (file_exists('themes/'.$Default_Theme.'/images/edit.gif')) {
				$icn2 = 'themes/'.$Default_Theme.'/images/edit.gif';
			}
			else {
				$icn2 = 'images/edit22.gif';
			}
	
			
			//Accueil de l'espace collaboratif !!!!!
			$sortie = "";
			$sortie .= "<h1>"._COMSPACE.$titre_group."</h1>";
	
			$sql = "SELECT COUNT(id) as nbre FROM ".$user_prefix."_publi WHERE id_group='".$current_group."';";
			$result = $db->sql_query($sql);
			$ligne = $db->sql_fetchrow($result);
			$sql = "SELECT COUNT(id) as nbre FROM ".$user_prefix."_publi WHERE id_group='".$current_group."' AND user_id='".$userdata[0]."';";
			$result = $db->sql_query($sql);
			$ligne2 = $db->sql_fetchrow($result);
			$sql = "SELECT COUNT(id) as nbre FROM ".$user_prefix."_users_groups WHERE group_id='".$current_group."';";
			$result = $db->sql_query($sql);
			$ligne3 = $db->sql_fetchrow($result);
			$sql = "SELECT COUNT(msg_id) as nbre FROM ".$user_prefix."_priv_msgs WHERE to_userid='".$userdata[0]."';";
			$result = $db->sql_query($sql);
			$ligne4 = $db->sql_fetchrow($result);
			$sql = "SELECT COUNT(msg_id) as nbre FROM ".$user_prefix."_priv_msgs WHERE from_userid='".$userdata[0]."';";
			$result = $db->sql_query($sql);
			$ligne5 = $db->sql_fetchrow($result);
	
			$statshead = _COMSPACE_COUNTPUB.$ligne["nbre"];
			$statshead .= " - ";
			$statshead .= _COMSPACE_YOURCOUNTPUB.$ligne2["nbre"];
			$statshead .= "<br />";
			$statshead .= _COMSPACE_NBREMEMBERSGROUP.$ligne3["nbre"];
			$statshead .= "<br />";
			$statshead .= _COMSPACE_NBREMESSRECU.$ligne4["nbre"];
			$statshead .= " - ";
			$statshead .= _COMSPACE_NBREMESSEXP.$ligne5["nbre"];
	
			/*$menu_group = '<select name="groupfix" size="1" class="menupop" onchange="this.form.submit()">';
			 foreach ($userdata[11] as $key=>$value) {
			if ($current_group == $key) {
			$selected = ' selected="selected"';
			}
			else {
			$selected = "";
			}
			$menu_group .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
			}
			$menu_group .= '</select>';*/
	
			$sortie .= '<table border="0" celpadding="0" cellspacing="0" class="ministat"><tr><td>';
			$sortie .= "<form action=\"mobiles.php?name=".$module_name."&op=space\" method=\"post\">";
			//$sortie .= $menu_group;
			$sortie .= "</form>";
			$sortie .= "<form action=\"mobiles.php?name=".$module_name."&op=new_pub\" method=\"post\">";
			$sortie .= '<input type="submit" name="newpub" value="'._COMSPACE_NEWPUB.'">';
			$sortie .= "</form>";
			$sortie .= '</td><td width="20"></td><td>';
			$sortie .= $statshead;
			$sortie .= '</td></tr></table>';
	
	
	
	
			global $formatdateprivspacepub, $cookie;
			$nbrepubs = 15;
			$nbrecommentaires = 10;
			$nbreevenements = 5;
			$nbrefichiers = 5;
			$nbremessages = 5;
	
			$sortie .= '<table border="0" celpadding="0" cellspacing="0" width="100%">';
	
			//affichage des publis  voir en priorit
			$sortiepub = "";
			$sortieliste = "";
			$sql = "SELECT id, user_id, id_group, id_news, id_evt, id_topic, id_cat_files, date, titre, description, uname FROM ".$user_prefix."_publi LEFT JOIN ".$user_prefix."_users on user_id=uid WHERE id_group='".$current_group."' AND a_voir='1' order by date desc limit $nbrepubs";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpub&id=".$ligne["id"]."\">";
					$actions = "";
					$sortieliste .= '<li><span class="titre">'.$actions.$story_link.$ligne["titre"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
				//$sortiepub .= '<div class="allelts"><a href="mobiles.php?name='.$module_name.'&op=allpub">'._COMSPACE_ALLELEMENTS.'</a></div>';
				$sortie .= '<tr><td colspan="3">';
				$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_MUSTSEE.'</legend><div class="allelts" style="text-align: left">'.$sortiepub.'</div></fieldset>';
				$sortie .= '</td></tr>';
		   
			}
	
	
			$sortie .= '<tr><td width="49%" valign="top" class="colspacerightleft">';
			//affichage des publis
			$sortiepub = "";
			$sortieliste = "";
			$sql = "SELECT id, user_id, id_group, id_news, id_evt, id_topic, id_cat_files, date, titre, description, uname FROM ".$user_prefix."_publi LEFT JOIN ".$user_prefix."_users on user_id=uid WHERE id_group='".$current_group."' AND a_voir='0' order by date desc limit $nbrepubs";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					//$lapubli = "";
					//$lapubli .= utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub)." - ".$ligne["uname"]." - ".$ligne["titre"];
					/*$r_options = "";
					 if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "&mode=$cookie[4]"; }
					if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "&order=$cookie[5]"; }
					if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "&thold=$cookie[6]"; }
					$story_link = "<a href=\"mobiles.php?name=News&file=article&fromspace=1&sid=".$ligne["id_news"].$r_options."\">";*/
					$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpub&id=".$ligne["id"]."\">";
					/*if ($ligne["user_id"] == $userdata[0]) {
						$deletebutton = '<a href="mobiles.php?name='.$module_name.'&op=delpub&id='.$ligne["id"].'" title="'._COMSPACE_DELPUB.'"><img src="'.$icn.'" border="0"></a>';
					$editbutton = '<a href="mobiles.php?name='.$module_name.'&op=editpub&id='.$ligne["id"].'" title="'._COMSPACE_EDITPUB.'"><img src="'.$icn2.'" border="0"></a>';
					$actions = '<span class="actions">&nbsp;'.$editbutton.'&nbsp;'.$deletebutton.'</span>';
					}
					else {
					$actions = "";
					}*/
					$actions = "";
					$sortieliste .= '<li><span class="titre">'.$actions.$story_link.$ligne["titre"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
				$sortiepub .= '<div class="allelts"><a href="mobiles.php?name='.$module_name.'&op=allpub">'._COMSPACE_ALLELEMENTS.'</a></div>';
			}
			else {
				$sortiepub .= _COMSPACE_MESSPART29;
			}
			$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_PUBLIS.'</legend>'.$sortiepub.'</fieldset>';
	
			//affichage des messages perso
	
			if (file_exists('themes/'.$Default_Theme.'/images/messaging.png')) {
				$icnmsg = 'themes/'.$Default_Theme.'/images/messaging.png';
			}
			else {
				$icnmsg = 'images/smallicone/messaging.png';
			}
	
			$sortiecom = "";
			$sortieliste = "";
			$sortiepub = "";
			$sql = "SELECT `msg_id`, `subject`, `msg_time`, `from_userid`, `uname`, `read_msg` FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE to_userid = '".$userdata[0]."' and `valid`='1' order by msg_time desc limit $nbremessages;";
			//echo $sql;
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$lignes =array();
				$nbrefiches  = $db->sql_numrows($result);
				while($ligne = $db->sql_fetchrow($result)) {
					$lignes[] = $ligne;
					//$lapubli = "";
					//$lapubli .= utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],$formatdateprivspacepub)." - ".$ligne["informant"]." - ".$ligne["title"];
					//$story_link = "<a href=\"mobiles.php?name=Calendrier&op=modload&file=index&type=month&Date=".utilFuncs_simpleSpace::date2JMA($ligne["eventDate"],"m/d/Y")."\">";
					//$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpubagenda&dateencours=".utilFuncs_simpleSpace::date2JMA($ligne["eventDate"],"m/d/Y")."\">";
					if ($ligne["read_msg"] == "0") {
						$pict_new = '<img src="'.$icnmsg.'" align="bottom" border="0">';
					}
					else {
						$pict_new = "";
					}
					//$story_link = "<a href=\"mobiles.php?name=Private_Messages&file=showmsg&id=".$ligne["msg_id"]."\">";
					$story_link = "<a href=\"mobiles.php?name=".$module_name."&file=messages&op=viewmessage&id=".$ligne["msg_id"]."\">";
					$sortieliste .= '<li><span class="titre">'.$pict_new." ".$story_link.$ligne["subject"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"].":00",$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
				$sortiepub .= '<div class="allelts"><a href="mobiles.php?name='.$module_name.'&file=messages">'._COMSPACE_ALLELEMENTS.'</a></div>';
			}
			else {
				$sortiepub .= _COMSPACE_MESSPART100;
			}
			$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_MSGPERSO.'</legend>'.$sortiepub.'</fieldset>';
	
			//affichage des messages perso envoys
	
			if (file_exists('themes/'.$Default_Theme.'/images/messaging.png')) {
				$icnmsg = 'themes/'.$Default_Theme.'/images/messaging.png';
			}
			else {
				$icnmsg = 'images/smallicone/messaging.png';
			}
	
			$sortiecom = "";
			$sortieliste = "";
			$sortiepub = "";
			$sql = "SELECT `msg_id`, `subject`, `msg_time`, `from_userid`, `uname`, `read_msg` FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.to_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE from_userid = '".$userdata[0]."' order by msg_time desc limit $nbremessages;";
			//echo $sql;
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$lignes =array();
				$nbrefiches  = $db->sql_numrows($result);
				while($ligne = $db->sql_fetchrow($result)) {
					$lignes[] = $ligne;
					//$lapubli = "";
					//$lapubli .= utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],$formatdateprivspacepub)." - ".$ligne["informant"]." - ".$ligne["title"];
					//$story_link = "<a href=\"mobiles.php?name=Calendrier&op=modload&file=index&type=month&Date=".utilFuncs_simpleSpace::date2JMA($ligne["eventDate"],"m/d/Y")."\">";
					//$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpubagenda&dateencours=".utilFuncs_simpleSpace::date2JMA($ligne["eventDate"],"m/d/Y")."\">";
					if ($ligne["read_msg"] == "0") {
						$pict_new = '<img src="'.$icnmsg.'" align="bottom" border="0">';
					}
					else {
						$pict_new = "";
					}
					//$story_link = "<a href=\"mobiles.php?name=Private_Messages&file=showmsg&id=".$ligne["msg_id"]."\">";
					$story_link = "<a href=\"mobiles.php?name=".$module_name."&file=messages&op=viewmessagesent&id=".$ligne["msg_id"]."\">";
					$sortieliste .= '<li><span class="titre">'.$pict_new." ".$story_link.$ligne["subject"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"].":00",$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
				$sortiepub .= '<div class="allelts"><a href="mobiles.php?name='.$module_name.'&file=messages&op=allmsgsent">'._COMSPACE_ALLELEMENTS.'</a></div>';
			}
			else {
				$sortiepub .= _COMSPACE_MESSPART100;
			}
			$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_MSGPERSOSENT.'</legend>'.$sortiepub.'</fieldset>';
	
	
			$sortie .= '</td><td width="2%" class="colspacecenter"></td><td width="49%" valign="top" class="colspacerightleft">';
			//affichage des vnements
			$sortiecom = "";
			$sortieliste = "";
			$sortiepub = "";
			$sql = "SELECT `eid`, `aid`, `title`, `informant`, `eventDate`, `endDate`, `startTime`, `endTime`, `alldayevent`, `withregistration`, ".$user_prefix."_publi.id, ".$user_prefix."_publi.date FROM ".$user_prefix."_events ";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id_evt=".$user_prefix."_events.eid";
			$sql .= " WHERE ".$user_prefix."_events.eventDate >= CURDATE() AND ".$user_prefix."_publi.id_group='".$current_group."' order by ".$user_prefix."_events.eventDate desc, ".$user_prefix."_events.startTime desc;";
			//echo $sql;
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$lignes =array();
				$nbrefiches  = $db->sql_numrows($result);
				while($ligne = $db->sql_fetchrow($result)) {
					$lignes[] = $ligne;
					//$lapubli = "";
					//$lapubli .= utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],$formatdateprivspacepub)." - ".$ligne["informant"]." - ".$ligne["title"];
					//$story_link = "<a href=\"mobiles.php?name=Calendrier&op=modload&file=index&type=month&Date=".utilFuncs_simpleSpace::date2JMA($ligne["eventDate"],"m/d/Y")."\">";
					//$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpubagenda&dateencours=".utilFuncs_simpleSpace::date2JMA($ligne["eventDate"],"m/d/Y")."\">";
					//$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpubevt&id=".$ligne["id"]."\">";
					//$sortieliste .= '<li>'.$story_link.$lapubli.'</a>'.'</li>';
					//$sortieliste .= '<li><span class="titre">'.$story_link.utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],$formatdateprivspacepub)." - ".$ligne["title"].'</a></span><span class="auteur">'.$ligne["informant"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';
				}
				for ($i = 0; $i < ($nbrefiches - $nbreevenements); $i++) {
					array_shift($lignes);
				}
				$lignes = array_reverse($lignes);
				foreach ($lignes as $ligne) {
					//$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpubevt&id=".$ligne["id"]."\">";
					$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpub&id=".$ligne["id"]."#evts\">";
					//$sortieliste .= '<li><span class="titre">'.$story_link.utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],$formatdateprivspacepub)." - ".$ligne["title"].'</a></span><span class="auteur">'.$ligne["informant"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';
					$sortieliste .= '<li><span class="titre">'.$story_link.utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],$formatdateprivspacepub)." - ".$ligne["title"].'</a></span><span class="auteur">'.$ligne["informant"].'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
			}
			else {
				$sortiepub .= _COMSPACE_MESSPART26;
			}
			$sortiepub .= '<div class="allelts"><a href="mobiles.php?name='.$module_name.'&op=allevt">'._COMSPACE_ALLELEMENTS.'</a></div>';
			$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_EVENTS.'</legend>'.$sortiepub.'</fieldset>';
			//affichage des fichiers
			$sortiecom = "";
			$sortieliste = "";
			$sortiepub = "";
			$sql = "SELECT `lid`, `title`, `url` ,`submitter`, ".$user_prefix."_downloads_downloads.`date`, `filesize` , titre, ".$user_prefix."_publi.id FROM ((".$user_prefix."_downloads_downloads";
			$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id=".$user_prefix."_publi_lien_download.id_publi)";
			$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."' order by ".$user_prefix."_downloads_downloads.date desc limit $nbrefichiers";
			//echo $sql;
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					//$lapubli = "";
					//$lapubli .= utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub)." - ".$ligne["submitter"]." - ".$ligne["title"]." - ".$ligne["titre"];
					//$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpubfiles&id=".$ligne["id"]."\">";
					$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpub&id=".$ligne["id"]."#files\">";
					//$sortieliste .= '<li>'.$story_link.$lapubli.'</a>'.'</li>';
					$sortieliste .= '<li><span class="titre">'.$story_link.$ligne["title"]."<span class=\"sstitle\">".$ligne["titre"].'</span></a></span><span class="auteur">'.$ligne["submitter"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
			}
			else {
				$sortiepub .= _COMSPACE_MESSPART27;
			}
			$sortiepub .= '<div class="allelts"><a href="mobiles.php?name='.$module_name.'&op=allfile">'._COMSPACE_ALLELEMENTS.'</a></div>';
			$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_LASTFILES.'</legend>'.$sortiepub.'</fieldset>';
			//affichage des commentaires
			$sortiecom = "";
			$sortieliste = "";
			$sortiepub = "";
			/*$sql = "SELECT sid, tid, name, ".$user_prefix."_comments.date, subject FROM ".$user_prefix."_comments";
			 $sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id_news=".$user_prefix."_comments.sid";
			$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."' order by ".$user_prefix."_comments.date desc limit $nbrecommentaires";*/
				
			$sql = "SELECT ".$user_prefix."_publi_comments.id, ".$user_prefix."_publi_comments.id_publi,".$user_prefix."_publi_comments.user, ".$user_prefix."_publi_comments.subject, ".$user_prefix."_publi_comments.date FROM ".$user_prefix."_publi_comments";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id=".$user_prefix."_publi_comments.id_publi";
			$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."' order by ".$user_prefix."_publi_comments.date desc limit $nbrecommentaires";
				
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					/*$r_options = "";
					 if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "&mode=$cookie[4]"; }
					if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "&order=$cookie[5]"; }
					if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "&thold=$cookie[6]"; }
					$story_link = "<a href=\"mobiles.php?name=News&fromspace=1&file=article&sid=".$ligne["sid"].$r_options."#".$ligne["tid"]."\">";
					$sortieliste .= '<li><span class="titre">'.$story_link.$ligne["subject"].'</a></span><span class="auteur">'.$ligne["name"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';*/
					$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=showpub&id=".$ligne["id_publi"]."#".$ligne["id"]."#comments\">";
					$sortieliste .= '<li><span class="titre">'.$story_link.$ligne["subject"].'</a></span><span class="auteur">'.$ligne["user"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
				$sortiepub .= '<div class="allelts"><a href="mobiles.php?name='.$module_name.'&op=allcom">'._COMSPACE_ALLELEMENTS.'</a></div>';
			}
			else {
				$sortiepub .= _COMSPACE_MESSPART28;
			}
			$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_COMMENTS.'</legend>'.$sortiepub.'</fieldset>';
	
			$sortie .= '</td></tr></table>';
			
			$bardef=array("back"=>"javascript:window.history.back()",
					/*"print"=>"mobiles.php?name=News&amp;file=print&amp;sid=$sid",*/
					"mailto"=>"#",
					"top"=>"#top" );
			$sortie .= buttonBar($bardef, "align",false,true);
		}

		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");
		
		ajoutStat("500 : consultation accueil espace collaboratif");
	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function getparent($parentid,$title) {
	global $user_prefix,$db;
	$result= $db->sql_query("select cid, title, parentid from ".$user_prefix."_downloads_categories where cid=$parentid");
	list($cid, $ptitle, $pparentid) = $db->sql_fetchrow($result);
	if ($ptitle!="") $title=$ptitle."/".$title;
	if ($pparentid!=0) {
		$title=getparent($pparentid,$title);
	}
	return $title;
}

function new_pub($id="") {
	global $_headerContent, $group, $user,$module_name, $db, $user_prefix, $downloadprivspacecat, $admin;
	global $useInternationalDates, $time24Hour;
	global $Default_Theme, $page, $topic, $currentlang;

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		if (file_exists('themes/'.$Default_Theme.'/pattern_space_new_pub.php')) {
			/*rcup la publi si elle existe : $publi*/
			$publi = array();
			if ($id != "") {
				$result = $db->sql_query("SELECT id, user_id , id_group , id_news , id_evt , id_topic , id_cat_files , date , titre , description FROM ".$user_prefix."_publi WHERE id='".$id."';");
				if ($db->sql_numrows($result) > 0) {
					$publi = $db->sql_fetchrow($result);
					if ($publi["user_id"] != $userdata[0] && !is_admin($admin)) {
						die("Accs non autoris !");
					}
				}
				else {
					die("Publication inexistante !");
				}
			}
			
			/*rcup les catgories des fichiers : $catfiles*/
			$result3 = $db->sql_query("select title from ".$user_prefix."_downloads_categories where cid=$downloadprivspacecat");
			list($theCat) = $db->sql_fetchrow($result3);
			$result2 = $db->sql_query("select cid, title, parentid from ".$user_prefix."_downloads_categories order by title");
			$catfiles = array();
			$lignetitre = array();
			$ligneid = array();
			while(list($cid2, $ctitle2, $parentid2) = $db->sql_fetchrow($result2)) {
				if ($parentid2!=0) $ctitle2=getparent($parentid2,$ctitle2);
				//if (preg_match("#^$theCat/#", $ctitle2) || $theCat == $ctitle2) {
				if (preg_match("#^$theCat/#", $ctitle2)) {
					$ctitle2 = preg_replace("#^$theCat/#","",$ctitle2);
					array_push($catfiles,array("cid2"=>$cid2,"ctitle2"=>$ctitle2));
				}
			}
			foreach ($catfiles as $key => $row) {
				$ligneid[$key]  = $row['cid2'];
				$lignetitre[$key] = $row['ctitle2'];
			}
			array_multisort($lignetitre, SORT_ASC, $ligneid, SORT_ASC, $catfiles);
			
			/*rcup catgories des publis : $catpublis*/
			$catpublis = array();
			$sql = "SELECT topicid, topicname FROM ".$user_prefix."_topics";
			$sql .= " LEFT JOIN ".$user_prefix."_topics_groups ON topic_id=topicid";
			$sql .= " WHERE group_id='".$current_group."' ORDER BY topicname ASC";
			$toplist = $db->sql_query($sql);
			if ($db->sql_numrows($toplist) == 0) {
				$toplist = $db->sql_query("select topicid, topicname from $user_prefix"._topics." order by topicname");
			}
			while(list($topicid, $topicname) = $db->sql_fetchrow($toplist)) {
				array_push($catpublis,array("topicid"=>$topicid,"topicname"=>$topicname));
			}
			
			/*rcup de l'vnement associ s'il existe : $evenement*/
			if ($id != "" && $publi["id_evt"] != 0) {
				$sql = "SELECT `eventDate` , `endDate` , `startTime` , `endTime` , `alldayevent` , `barcolor` , `withregistration`  FROM ".$user_prefix."_events WHERE eid='".$publi["id_evt"]."';";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					$evenement = $db->sql_fetchrow($result);
				}
			}
			
			/*recup liste de tous les mots clefs : $mcs*/
			$mcs = array();
			$sql = "select mot from ".$user_prefix."_publi_motsclef order by mot asc;";
			$result =  $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while (list($mc) = $db->sql_fetchrow($result)) {
					if (!preg_match("/^(\s+)$/", $mc)) {
						$mcs[] = trim($mc);
					}
				}
			}
			
			/*rcup liste des mots clefs de la publi en cours : $mcs_publi*/
			$mcs_publi = array();
			if ($id != "") {
				$sql = "select mot from ".$user_prefix."_publi_motsclef inner join ".$user_prefix."_publi_lien_motsclef on ".$user_prefix."_publi_motsclef.id=id_mot where id_publi='$id'";
				$result =  $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while (list($mc) = $db->sql_fetchrow($result)) {
						$mcs_publi[] = trim($mc);
					}
				}
			}
			
			/*recup de la liste des fichiers : $fichiers_publi*/
			$fichiers_publi = array();
			if ($id != "") {
				$sql = "SELECT `lid`, `title`, `url`, `filesize` FROM (".$user_prefix."_downloads_downloads";
				$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
				$sql .= " WHERE ".$user_prefix."_publi_lien_download.id_publi='".$id."' order by ".$user_prefix."_downloads_downloads.title asc;";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while($ligne = $db->sql_fetchrow($result)) {
						$fichiers_publi[] = $ligne;
					}
				}
			}
			
			require_once('themes/'.$Default_Theme.'/pattern_space_new_pub.php');
		}
	  	else {
			$lignepubli = array();
			if ($id != "") {
				$result = $db->sql_query("SELECT id, user_id , id_group , id_news , id_evt , id_topic , id_cat_files , date , titre , description FROM ".$user_prefix."_publi WHERE id='".$id."';");
				if ($db->sql_numrows($result) > 0) {
					$lignepubli = $db->sql_fetchrow($result);
					if ($lignepubli["user_id"] != $userdata[0] && !is_admin($admin)) {
						die("Accs non autoris !");
					}
				}
				else {
					die("Publication inexistante !");
				}
			}
		  
			$_headerContent ='
			<script type="text/javascript" src="modules/'.$module_name.'/system/lib_AJAX.js"> </script>
			<script type="text/javascript" src="modules/'.$module_name.'/system/lib_interface.js"></script>
			<script type="text/javascript" src="modules/'.$module_name.'/system/lib_space_'.$currentlang.'.js"></script>
			<script type="text/javascript" src="modules/'.$module_name.'/system/lib_space.js"></script>
			<script language="Javascript" src="javascripts/control_form.js"></script>
			<script language="JavaScript" src="javascripts/lang/lang-french.js"></script>
			<script type="text/javascript" src="javascripts/fckeditor/fckeditor.js"></script>
			<script type="text/javascript" src="javascripts/initfck.js"></script>
			<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
			<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
			<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
			<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
			<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
			<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
			<link href="javascripts/windows_js/themes/becms_alphacube.css" rel="stylesheet" type="text/css" />
			<script type="text/javascript">
			var win=null;
			function ouvre_dialogue(titre,url,width) {
			win = new Window({className: "becms_alphacube", title: titre, width:width, height:300, destroyOnClose: true, recenterAuto:true, url: url, minimizable: false, maximizable: false});
			win.showCenter(true);
		}
		</script>
		<script type="text/javascript">
		function test_date(formulaire) {
		var datedeb = new Date();
		datedeb.setFullYear(formulaire.elements["data[year]"].value);
		datedeb.setMonth(eval(formulaire.elements["data[month]"].value-1));
		datedeb.setDate(formulaire.elements["data[day]"].value);
		datedeb.setHours(formulaire.elements["data[startHour]"].value);
		datedeb.setMinutes(formulaire.elements["data[startMin]"].value);
		var datefin = new Date();
		datefin.setFullYear(formulaire.elements["data[endyear]"].value);
		datefin.setMonth(eval(formulaire.elements["data[endmonth]"].value-1));
		datefin.setDate(formulaire.elements["data[endday]"].value);
		datefin.setHours(formulaire.elements["data[endHour]"].value);
		datefin.setMinutes(formulaire.elements["data[endMin]"].value);
		if (datedeb.getTime() > datefin.getTime()) {
		alert("La date de fin doit tre suprieure ou gale  la date de dbut.");
		return false;
		}
		else {
		hideContent("btnsubmit");
		showContent("alerttransfert");
		return true;
		}
		}
		</script>
		';
	
			setHeader($_headerContent);
	
			$result3 = $db->sql_query("select title from ".$user_prefix."_downloads_categories where cid=$downloadprivspacecat");
			list($theCat) = $db->sql_fetchrow($result3);
			$result2 = $db->sql_query("select cid, title, parentid from ".$user_prefix."_downloads_categories order by title");
			$lignes = array();
			$lignetitre = array();
			$ligneid = array();
			while(list($cid2, $ctitle2, $parentid2) = $db->sql_fetchrow($result2)) {
				if ($parentid2!=0) $ctitle2=getparent($parentid2,$ctitle2);
				//if (preg_match("#^$theCat/#", $ctitle2) || $theCat == $ctitle2) {
				if (preg_match("#^$theCat/#", $ctitle2)) {
					$ctitle2 = preg_replace("#^$theCat/#","",$ctitle2);
					array_push($lignes,array("cid2"=>$cid2,"ctitle2"=>$ctitle2));
				}
			}
			foreach ($lignes as $key => $row) {
				$ligneid[$key]  = $row['cid2'];
				$lignetitre[$key] = $row['ctitle2'];
			}
			array_multisort($lignetitre, SORT_ASC, $ligneid, SORT_ASC, $lignes);
			$menu_cat_files = "<select name=\"data[catfichier]\">";
			$menu_cat_files .= "<option value=\"\">"._COMSPACE_CATPUB_CHOOSE."</option>";
			$default_cat_files = "";
			foreach ($lignes as $ligne) {
				$sel = "";
				if ($lignepubli["id_cat_files"] == $ligne["cid2"]) {
					$sel = ' selected="selected"';
				}
				$menu_cat_files .= "<option value=\"".$ligne["cid2"]."\"".$sel.">".$ligne["ctitle2"]."</option>";
				if ($default_cat_files == "") {
					$default_cat_files = $ligne["cid2"];
				}
			}
			$menu_cat_files .= "</select>";
	
			$sql = "SELECT topicid, topicname FROM ".$user_prefix."_topics";
			$sql .= " LEFT JOIN ".$user_prefix."_topics_groups ON topic_id=topicid";
			$sql .= " WHERE group_id='".$current_group."' ORDER BY topicname ASC";
			$toplist = $db->sql_query($sql);
			if ($db->sql_numrows($toplist) == 0) {
				$toplist = $db->sql_query("select topicid, topicname from $user_prefix"._topics." order by topicname");
			}
			$menu_cat_news = "<select name=\"data[topic]\">";
			$menu_cat_news .= "<option value=\"\">"._COMSPACE_CATPUB_CHOOSE."</option>\n";
			while(list($topicid, $topics) = $db->sql_fetchrow($toplist)) {
				if ($topicid==$lignepubli["id_topic"]) {
					$sel = "selected=\"selected\"";
				}
				$menu_cat_news .= "<option $sel value=\"$topicid\">$topics</option>\n";
				$sel = "";
			}
			$menu_cat_news .= "</select>";
	
			if ($id != "" && $lignepubli["id_evt"] != 0) {
				$sql = "SELECT `eventDate` , `endDate` , `startTime` , `endTime` , `alldayevent` , `barcolor` , `withregistration`  FROM ".$user_prefix."_events WHERE eid='".$lignepubli["id_evt"]."';";
				$result = $db->sql_query($sql);
				$ligne_evt = $db->sql_fetchrow($result);
				list($d1, $d2, $d3) = explode ("-", $ligne_evt["eventDate"]);
				$Date_Array = array($d2,$d3,$d1);
				list($heure, $minute) = explode (":", $ligne_evt["startTime"]);
		   
				list($d1, $d2, $d3) = explode ("-", $ligne_evt["endDate"]);
				$DateEnd_Array = array($d2,$d3,$d1);
				list($heureEnd, $minuteEnd) = explode (":", $ligne_evt["endTime"]);
				$disabled = "";
				$withevt = " checked=\"checked\"";
				if ($ligne_evt["alldayevent"]=="1") {
					$alldayevent = " checked=\"checked\"";
				}
				else {
					$alldayevent = "";
				}
				if ($ligne_evt["withregistration"]=="1") {
					$withregistration = " checked=\"checked\"";
				}
				else {
					$withregistration = "";
				}
				switch ($ligne_evt["barcolor"]) {
					case "r":
						$barcolor = array("r"=>" checked=\"checked\"", "g"=>"", "b"=>"", "w"=>"", "y"=>"");
						break;
					case "g":
						$barcolor = array("r"=>"", "g"=>" checked=\"checked\"", "b"=>"", "w"=>"", "y"=>"");
						break;
					case "b":
						$barcolor = array("r"=>"", "g"=>"", "b"=>" checked=\"checked\"", "w"=>"", "y"=>"");
						break;
					case "w":
						$barcolor = array("r"=>"", "g"=>"", "b"=>"", "w"=>" checked=\"checked\"", "y"=>"");
						break;
					case "y":
						$barcolor = array("r"=>"", "g"=>"", "b"=>"", "w"=>"", "y"=>" checked=\"checked\"");
						break;
				}
		   
			}
			else {
				$Date = Date("m/d/Y");
				$Date_Array = explode("/", $Date);
				$DateEnd_Array = $Date_Array;
				$heure = 9;
				$minute = 0;
				$heureEnd = 9;
				$minuteEnd = 0;
				$disabled = " disabled=\"disabled\"";
				$withevt = "";
				$alldayevent = "";
				$withregistration = "";
				$barcolor = array("r"=>" checked=\"checked\"", "g"=>"", "b"=>"", "w"=>"", "y"=>"");
			}
			$jourdebut = "";
			if ($useInternationalDates) {
				$jourdebut .= "<select name=\"data[day]\" class=\"evt\"$disabled>";
				$jourdebut .= buildDaySelect($Date_Array[1]);
				$jourdebut .= "</select>
				<select name=\"data[month]\" class=\"evt\"$disabled>";
				$jourdebut .= buildMonthSelect($Date_Array[0]);
				$jourdebut .= "</select>";
			}
			else {
				$jourdebut .= "<select name=\"data[month]\" class=\"evt\"$disabled>";
				$jourdebut .= buildMonthSelect($Date_Array[0]);
				$jourdebut .= "</select>
				<select name=\"data[day]\" class=\"evt\"$disabled>";
				$jourdebut .= buildDaySelect($Date_Array[1]);
				$jourdebut .= "</select>";
			}
			$jourdebut .= " <select name=\"data[year]\" class=\"evt\"$disabled>";
			$jourdebut .= buildYearSelect($Date_Array[2]);
			$jourdebut .= "</select></td></tr>";
	
			$jourfin = "";
			if ($useInternationalDates) {
				$jourfin .= "<select name=\"data[endday]\" class=\"evt\"$disabled>";
				$jourfin .= buildDaySelect($DateEnd_Array[1]);
				$jourfin .= "</select>
				<select name=\"data[endmonth]\" class=\"evt\"$disabled>";
				$jourfin .= buildMonthSelect($DateEnd_Array[0]);
				$jourfin .= "</select>";
			}
			else {
				$jourfin .= "<select name=\"data[endmonth]\" class=\"evt\"$disabled>";
				$jourfin .= buildMonthSelect($DateEnd_Array[0]);
				$jourfin .= "</select>
				<select name=\"data[endday]\" class=\"evt\"$disabled>";
				$jourfin .= buildDaySelect($DateEnd_Array[1]);
				$jourfin .= "</select>";
			}
			$jourfin .= " <select name=\"data[endyear]\" class=\"evt\"$disabled>";
			$jourfin .= buildYearSelect($DateEnd_Array[2]);
			$jourfin .= "</select></td></tr>";
	
			$heuredebut = "";
			$heuredebut .= "<select name=\"data[startHour]\" class=\"evt\"$disabled>";
			$heuredebut .=buildHourSelect($heure);
			$heuredebut .= "</select>
			<select name=\"data[startMin]\" class=\"evt\"$disabled>";
			$heuredebut .= buildMinSelect($minute);
			$heuredebut .= "</select>";
			if (!($time24Hour)) {
				$heuredebut .= "<select name=\"data[startampm]\" class=\"evt\"$disabled>";
				$heuredebut .=buildAMPMSelect("AM");
				$heuredebut .= "</select>";
			}
	
			$heurefin = "";
			$heurefin .= "<select name=\"data[endHour]\" class=\"evt\"$disabled>";
			$heurefin .=buildHourSelect($heureEnd);
			$heurefin .= "</select>
			<select name=\"data[endMin]\" class=\"evt\"$disabled>";
			$heurefin .= buildMinSelect($minuteEnd);
			$heurefin .= "</select>";
			if (!($time24Hour)) {
				$heurefin .= "<select name=\"data[endampm]\" class=\"evt\"$disabled>";
				$heurefin .=buildAMPMSelect("AM");
				$heurefin .= "</select>";
			}
	
			$withevt = "<input name=\"data[withevt]\" type=\"checkbox\" value=\"1\" id=\"withevt\" onclick=\"activeEvt(this.checked)\"$withevt>&nbsp;<b><label for=\"withevt\">"._COMSPACE_WITHEVT."</label></b><br>("._COMSPACE_WITHEVTPLUS.")";
			$allday = "<input name=\"data[alldayevent]\" type=\"checkbox\" value=\"1\" id=\"alldayevent\" class=\"evt\" $disabled$alldayevent>&nbsp;<b><label for=\"alldayevent\">"._COMSPACE_ALLDAYEVENT."</label></b><br>("._COMSPACE_TIMEIGNORED.")";
			$withsubs = "<input name=\"data[withregistration]\" type=\"checkbox\" value=\"1\" id=\"withregistration\" class=\"evt\" $disabled$withregistration>&nbsp;<b><label for=\"withregistration\">"._COMSPACE_WITHSUBCRIPTION."</label></b><br>("._COMSPACE_WITHSUBCRIPTIONPLUS.")";
			$colors = "
			<input type=\"radio\" name=\"data[barcolor]\" value=\"r\" id=\"coul1\" class=\"evt\" $disabled".$barcolor["r"]."><label for=\"coul1\"><img src=\"modules/Calendrier/images/ballr.gif\">"._COMSPACE_ROUGE."</label>
			<input type=\"radio\" name=\"data[barcolor]\" value=\"g\" id=\"coul2\" class=\"evt\" $disabled".$barcolor["g"]."><label for=\"coul2\"><img src=\"modules/Calendrier/images/ballg.gif\">"._COMSPACE_VERT."</label>
			<input type=\"radio\" name=\"data[barcolor]\" value=\"b\" id=\"coul3\" class=\"evt\" $disabled".$barcolor["b"]."><label for=\"coul3\"><img src=\"modules/Calendrier/images/ballb.gif\">"._COMSPACE_BLEU."</label>
			<input type=\"radio\" name=\"data[barcolor]\" value=\"w\" id=\"coul4\" class=\"evt\" $disabled".$barcolor["w"]."><label for=\"coul4\"><img src=\"modules/Calendrier/images/ballw.gif\">"._COMSPACE_BLANC."</label>
			<input type=\"radio\" name=\"data[barcolor]\" value=\"y\" id=\"coul5\" class=\"evt\" $disabled".$barcolor["y"]."><label for=\"coul5\"><img src=\"modules/Calendrier/images/bally.gif\">"._COMSPACE_JAUNE."</label>";
	
			//mots clef
			$list_mcs = "<select name=\"choix\" multiple size=10 class=\"demi_mc\" onchange=\"ajoutMC(this, this.form.elements['data[keywords]']);\">\n";
			$sql = "select mot from ".$user_prefix."_publi_motsclef order by mot asc;";
			$result =  $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while (list($mc) = $db->sql_fetchrow($result)) {
					if (!preg_match("/^(\s+)$/", $mc)) {
						$list_mcs .= "<option value=\"$mc\">$mc</option>\n";
					}
				}
			}
			$list_mcs .= "</select>\n";
	
			$my_mcs = "<textarea name=\"data[keywords]\" rows=\"15\" cols=\"25\" wrap=\"virtual\" class=\"demi_mc\">";
			$sql = "select mot from ".$user_prefix."_publi_motsclef inner join ".$user_prefix."_publi_lien_motsclef on ".$user_prefix."_publi_motsclef.id=id_mot where id_publi='$id'";
			$result =  $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$tmp_mcs = "";
				while (list($mc) = $db->sql_fetchrow($result)) {
					if ($tmp_mcs !="") {
						$tmp_mcs .= "\n";
					}
					$tmp_mcs .= $mc;
				}
			}
			$my_mcs .= $tmp_mcs."</textarea>\n";
			//fichiers
			$list_fichiers = "";
			if ($id != "") {
				if (file_exists('themes/'.$Default_Theme.'/images/icon_eye.gif')) {
					$icneye = 'themes/'.$Default_Theme.'/images/icon_eye.gif';
				}
				else {
					$icneye = 'images/icon_eye.gif';
				}
				if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
					$icn = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
				}
				else {
					$icn = 'images/deletesmall.gif';
				}
				if (file_exists('themes/'.$Default_Theme.'/images/recycle.gif')) {
					$icnswap = 'themes/'.$Default_Theme.'/images/recycle.gif';
				}
				else {
					$icnswap = 'images/smallicone/recycle.gif';
				}
					
					
				$sortiepub = "";
				$sql = "SELECT `lid`, `title`, `url`, `filesize` FROM (".$user_prefix."_downloads_downloads";
				$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
				$sql .= " WHERE ".$user_prefix."_publi_lien_download.id_publi='".$id."' order by ".$user_prefix."_downloads_downloads.title asc;";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while($ligne = $db->sql_fetchrow($result)) {
						$lapubli = "";
						$lapubli .= '<input type="text" name="data[newnomfichier]['.$ligne["lid"].']" value="'.$ligne["title"].'" size="50" maxlength="100" class="credit2">'." ".utilFuncs_simpleSpace::coolSize($ligne["filesize"]);
						$btnview = "<a href=\"mobiles.php?name=Downloads&d_op=getit&lid=".$ligne["lid"]."\" target=\"_blank\" title=\""._COMSPACE_BTN_PREVIEW."\">";
						$btnview .= "<img src=\"$icneye\" border=\"0\" align=\"top\">";
						$btnview .= "</a>";
						 
						$btndel = "<a href=\"mobiles.php?name=".$module_name."&op=delfile&file=files&id_file=".$ligne["lid"]."&id=".$lignepubli["id"]."\" title=\""._COMSPACE_BTN_SUPPR."\">";
						$btndel .= "<img src=\"$icn\" border=\"0\" align=\"top\">";
						$btndel .= "</a>";
						 
						$btnswap = "<a href=\"javascript:ouvre_dialogue('Fichiers','mobiles.php?name=".$module_name."&op=swapfiles&file=files&id_publi=".$id."&id_file=".$ligne["lid"]."',600)\" title=\""._COMSPACE_BTN_REPLACE."\">";
						$btnswap .= "<img src=\"$icnswap\" border=\"0\" align=\"top\">";
						$btnswap .= "</a>";
						 
						$sortieliste .= '<li style="clear: both;"><span style="float: right">'.$btnview." ".$btnswap." ".$btndel.'</span><span style="width: 30px;display: block; float: left"><img src="'.get_icon_for_file($ligne["url"]).'"></span> '.$lapubli.''.'</li>';
					}
					$list_fichiers .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
				}
				else {
					$list_fichiers .= "";
				}
			}
	
			$sortie = "";
			$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
			$sortie .= "<form action=\"mobiles.php?name=".$module_name."\" method=\"post\" enctype=\"multipart/form-data\" onsubmit=\"if (submit_form(this)) {return test_date(this)} else {return false}\">";
			$sortie .= '<input type="hidden" name="op" value="savepub">';
			$sortie .= '<input type="hidden" name="data[id]" value="'.$id.'">';
			$sortie .= '<input type="hidden" name="page" value="'.$page.'">';
			$sortie .= '<input type="hidden" name="topic" value="'.$topic.'">';
	
			if ($id == "") {
				$sortie .= '<h2>'._COMSPACE_NEWPUB.'</h2>';
			}
			else {
				$sortie .= '<h2>'._COMSPACE_EDITPUB.'</h2>';
			}
			$sortie .= '
			<fieldset class="newpub"><legend>'._COMSPACE_NEWPUB_SUBJECT.'</legend>
			<table cellspacing="5" cellpadding="0" border="0" align="center" summary="">
			<tr>
			<td class="label">
			<p>'._COMSPACE_TITLE.'</p>
			</td>
			<td class="content"><champ lib="'._COMSPACE_TITLE_VERIF.'" nom="data[titre]" lim="1,100"></champ><input type="text" name="data[titre]" value="'.$lignepubli["titre"].'" class="saisiepub" /></td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_CATPUB.'</p>
			</td class="content">
			<td><champ lib="'._COMSPACE_CATPUB_VERIF.'" nom="data[topic]"></champ>'.$menu_cat_news.'</td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_BODY.'</p>
			</td class="content">
			<td><!--<champ lib="'._COMSPACE_BODY_VERIF.'" nom="data[description]" lim="1,4000"></champ>-->
			<div class="dimztexte"><div class="encadreedit">
			<textarea id="data[description]" cols="70" rows="30" name="data[description]">'.$lignepubli["description"].'</textarea>
			<script type="text/javascript">editSix("data[description]");</script></div></div></td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_KEYWORDS.'</p>
			</td>
			<td class="content"><table border="0" cellspacing="0" cellpadding="0">
			<tr>
			<td align="center">'._COMSPACE_KEYWORDS_CHOOSEN.'</td>
			<td width="20"></td>
			<td align="center">'._COMSPACE_KEYWORDS_EXIST.'</td>
			</tr>
			<tr>
			<td>'.$my_mcs.'</td>
			<td width="20"></td>
			<td>'.$list_mcs.'</td>
			</tr>
			</table></td>
			</tr>
			</table>
			</fieldset>
			<fieldset class="newpub"><legend>'._COMSPACE_NEWPUB_EVENT.'</legend>
			<table cellspacing="5" cellpadding="0" border="0" align="center" summary="">
			<tr>
			<td class="label">
			</td>
			<td class="content">'.$withevt.'</td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_DATE.'</p>
			</td>
			<td class="content">'.$jourdebut.'</td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_DATE_END.'</p>
			</td>
			<td class="content">'.$jourfin.'</td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_HOUR.'</p>
			</td>
			<td class="content">'.$heuredebut.'</td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_HOUR_END.'</p>
			</td>
			<td class="content">'.$heurefin.'</td>
			</tr>
			<tr>
			<td class="label">
			</td>
			<td class="content">'.$allday.'</td>
			</tr>
			<tr>
			<td class="label">
			</td>
			<td class="content">'.$withsubs.'</td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_COLOR_EVT.'</p>
			</td>
			<td class="content">'.$colors.'</td>
			</tr>
			</table>
			</fieldset>
			<fieldset class="newpub"><legend>'._COMSPACE_NEWPUB_FILE.'</legend>
			<table cellspacing="5" cellpadding="0" border="0" align="center" summary="">
			<tr>
			<td class="label">
			<p>'._COMSPACE_CATFILE.'</p>
			</td>
			<td class="content">'.$menu_cat_files.'<input type="hidden" value="'.$default_cat_files.'" name="data[catfichierdefault]"></td>
			</tr>
			<tr>
			<td colspan="2">'.$list_fichiers.'</td>
			</tr>
			<tr>
			<td class="label">
			<p>'._COMSPACE_FILES.'</p>
			</td>
			<td id="allfiles"  class="content"><input type="file" name="fichiers[]" value="" size="50" class="fichier" onchange="handle_inputs_file(this)"><br />
			'._COMSPACE_NEWPUB_FILENAME.'<input type="text" name="data[nomfichier][]" value="" size="50" maxlength="100" class="credit"></td>
			</tr>
			</table>
			</fieldset>
			';
			$sortie .= "<div align=\"center\"><input id=\"btnsubmit\" type=\"submit\" value=\""._COMSPACE_NEWPUB_SAVE."\"><p style=\"display: none; text-align: center; font-weight: bold\" id=\"alerttransfert\">Transfert en cours...</p></div>";
	
			$sortie .= "</form>";
	  	}
	  	
		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");
	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function save_pub($data) {
	global $module_name, $user_prefix, $db,$user, $group, $currentlang,$newsprivspaceadmin,$newsprivspacecat,$time24Hour, $locale;
	global $page, $topic;
	global $Default_Theme;

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == "443") ? "https://" : "http://";
		$nukeurl = $protocol.$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" && $_SERVER["SERVER_PORT"]!="443" ? ":".$_SERVER["SERVER_PORT"] : "");
		//$downloadlink = "$nukeurl/modules.php?name=Downloads&d_op=getit&lid=";
		//$postfixe = "";
		$downloadlink = "$nukeurl/mfile_";
		$postfixe = ".htm";
		$saut = "\n";
		$sep = "--------------------------------------------------\n";

		if (file_exists('themes/'.$Default_Theme.'/pattern_space_save_pub.php')) {
			require_once('themes/'.$Default_Theme.'/pattern_space_save_pub.php');
		}
		else {
			//print_r($data);
	
			if ($data["catfichier"] == "") {
				$data["catfichier"] = $data["catfichierdefault"];
			}
	
			$ligneold = array();
			if ($data["id"] != "") {
				$sql = "SELECT `id`, `user_id` , `id_group` , `id_news` , `id_evt` , `id_topic` , `id_cat_files` , `date` , `titre` , `description` FROM `".$user_prefix."_publi` WHERE `id`=".$data["id"].";";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					$ligneold = $db->sql_fetchrow($result);
				}
				else {
					die("erreur sur modification de pub");
				}
			}
			$ok = true;
	
			if (!isset($data["newnomfichier"])) {
				$data["newnomfichier"] = array();
			}
	
			$nomsf = $data["nomfichier"];
			$newnomsf = $data["newnomfichier"];
			$data = array_map(array('utilFuncs_simpleSpace', 'conditionnertodb'), $data);
			//print_r($nomsf);
			$data["nomfichier"] = array_map(array('utilFuncs_simpleSpace', 'conditionnertodb'), $nomsf);
			$data["newnomfichier"] = array_map(array('utilFuncs_simpleSpace', 'conditionnertodb'), $newnomsf);
	
			//enregistrement evt
			//suppression des images de la description - effectu ici pour rutilisation dans envoi messages
			$hometext = $data["description"];
			preg_match_all("/(<img [^>]+>)/mi",$hometext,$tabimages);
			$tabimages=$tabimages[1];
			for ($i = 0; $i<count($tabimages);$i++) {
				$oneimage = $tabimages[$i];
				$hometext = str_replace($oneimage,"",$hometext);
			}
			//fin suppression
			$messageModifEvt = "";
			$id_evt = 0;
			if ($data["withevt"] == 1) {
				setlocale(LC_TIME, "$locale");
				$newDate = $data["year"]."-".$data["month"]."-".$data["day"];
				$endDate = $data["endyear"]."-".$data["endmonth"]."-".$data["endday"];
				if ($time24Hour) {
					$startTime = $data["startHour"].":".$data["startMin"].":00";
					$endTime = $data["endHour"].":".$data["endMin"].":00";
				}
				else {
					$startTime = getTimeFormat($data["startHour"],$data["startMin"],$data["startampm"]);
					$endTime = getTimeFormat($data["endHour"],$data["endMin"],$data["endampm"]);
				}
				if ($data["id"] == "" || $ligneold["id_evt"] == 0) {
					$ok = $ok && $db->sql_query("insert into ".$user_prefix."_events values('', '".$newsprivspaceadmin."', '".$data["titre"]."', NOW(), '$hometext', '0', '0', '".$data["topic"]."','".$userdata[1]."','".$newDate."','".$endDate."','".$startTime."','".$endTime."', '".$data["alldayevent"]."', '".$data["barcolor"]."', '".$data["withregistration"]."');");
					$id_evt = $db->sql_nextid();
					if ($data["id"] != "") {
						$messageModifEvt .= _COMSPACE_MESSPART1.$saut;
						$messageModifEvt .= _COMSPACE_MESSPART2.strftime("%A %e %B %Y"._COMSPACE_TO_HOUR."%H:%M",mktime($data["startHour"], $data["startMin"], 0,$data["month"], $data["day"], $data["year"])).$saut;
						if ($data["withregistration"] == "1") {
							$messageModifEvt .= _COMSPACE_MESSPART3."\$subscribelink".$saut;
						}
					}
				}
				else {
					$sql = "SELECT eventDate, endDate, startTime, endTime, withregistration, alldayevent FROM `".$user_prefix."_events` WHERE `eid`=".$ligneold["id_evt"].";";
					$result = $db->sql_query($sql);
					if ($db->sql_numrows($result) > 0) {
						$evtold = $db->sql_fetchrow($result);
					}
					else {
						die("erreur sur modification d'evt");
					}
					$id_evt = $ligneold["id_evt"];
					if ($data["alldayevent"] == "") {
						$data["alldayevent"] = "0";
					}
					if ($data["withregistration"] == "") {
						$data["withregistration"] = "0";
					}
					if ($newDate != $evtold["eventDate"] || $endDate != $evtold["endDate"] || $startTime != $evtold["startTime"] || $endTime != $evtold["endTime"] || $data["alldayevent"] != $evtold["alldayevent"] || $data["withregistration"] != $evtold["withregistration"]) {
						$sql = "UPDATE ".$user_prefix."_events SET `title`='".$data["titre"]."', `hometext`='".$hometext."' , `topic`='".$data["topic"]."' ,`eventDate`='".$newDate."' , `endDate`='".$endDate."' , `startTime`='".$startTime."' , `endTime`='".$endTime."' , `alldayevent`='".$data["alldayevent"]."' , `barcolor`='".$data["barcolor"]."' , `withregistration`='".$data["withregistration"]."' WHERE `eid` ='".$ligneold["id_evt"]."'";
						$ok = $ok && $db->sql_query($sql);
						$messageModifEvt .= _COMSPACE_MESSPART4.$saut;
						$messageModifEvt .= _COMSPACE_MESSPART2.strftime("%A %e %B %Y"._COMSPACE_TO_HOUR."%H:%M",mktime($data["startHour"], $data["startMin"], 0,$data["month"], $data["day"], $data["year"])).$saut;
						//si on autorise plus les enregistrements, on les supprime s'il y en avait dj
						if (($data["withregistration"] == 0) || ($data["withregistration"] == "") && $evtold["withregistration"] == "1") {
							$sql = "DELETE FROM ".$user_prefix."_events_registered WHERE er_eid='".$ligneold["id_evt"]."'";
							$ok = $ok && $db->sql_query($sql);
							$messageModifEvt .= _COMSPACE_MESSPART5.$saut;
						}
						if ($data["withregistration"] == "1") {
							$messageModifEvt .= _COMSPACE_MESSPART3."\$subscribelink".$saut;
						}
					}
				}
			}
			else {
				//si pas d'vnement, suppresion de l'evt prcdemment enregistr et des inscriptions !
				if ($ligneold["id_evt"] != 0) {
					$sql = "DELETE FROM ".$user_prefix."_events WHERE eid='".$ligneold["id_evt"]."'";
					$ok = $ok && $db->sql_query($sql);
					$sql = "DELETE FROM ".$user_prefix."_events_registered WHERE er_eid='".$ligneold["id_evt"]."'";
					$ok = $ok && $db->sql_query($sql);
					$messageModifEvt .= _COMSPACE_MESSPART6.$saut;
				}
			}
	
			//enregistrement publication
			$messageModifPubli = "";
			if ($data["id"] == "") {
				$sql = ("insert into ".$user_prefix."_publi (user_id, id_group, id_news, id_evt, id_topic, id_cat_files, date, titre, description)");
				$sql .= (" values('".$userdata[0]."','".$current_group."','$id_news','$id_evt','".$data["topic"]."','".$data["catfichier"]."',NOW(),'".$data["titre"]."','".$data["description"]."');");
				$ok = $ok && $db->sql_query($sql);
				$id_publi = $db->sql_nextid();
			}
			else {
				$sql = "UPDATE ".$user_prefix."_publi SET `id_evt`='".$id_evt."', `id_topic`='".$data["topic"]."' , `id_cat_files`='".$data["catfichier"]."' , `titre`='".$data["titre"]."' , `description`='".$data["description"]."' WHERE `id` ='".$data["id"]."';";
				$ok = $ok && $db->sql_query($sql);
				$id_publi = $data["id"];
				if (utilFuncs_simpleSpace::anti_conditionnertodb($data["titre"]) != $ligneold["titre"] || utilFuncs_simpleSpace::anti_conditionnertodb($data["description"]) != $ligneold["description"]) {
					//$messageModifPubli .= "Le titre et/ou la description de la publication ont t modifis :".$saut.$saut;
					require_once("system/modules/becmsNewsletter/class.html2text.inc");
					$h2t = new html2text($hometext,false,70);
					$content_text = $h2t->get_text();
					$content_text = str_replace("&amp;","&",$content_text);
					$content_text = str_replace("''","'",$content_text);
					$messageModifPubli .= str_replace("''","'",$data["titre"]).$saut;
					$messageModifPubli .= $content_text.$saut;
				}
			}
			//enregistrement mot clef
			$keywords = $data["keywords"];
			if (isset($keywords) && $keywords != "") {
				$keywords = str_replace("\r", "", $keywords);
				$keywords = explode("\n",$keywords);
				$keywords = array_unique($keywords);
			}
			else {
				$keywords = array();
			}
			//if ($ok && $id_publi != "" && count($keywords) > 0) {
			if ($ok && $id_publi != "") {
				$sql = "DELETE FROM ".$user_prefix."_publi_lien_motsclef WHERE `id_publi`='$id_publi'";
				$ok = ($ok && $db->sql_query($sql));
				foreach ($keywords as $keyword) {
					if ($keyword != "") {
						$sql = "select id from ".$user_prefix."_publi_motsclef where mot='".$keyword."';";
						$result = $db->sql_query($sql);
						if ($db->sql_numrows($result) >0) {
							list($id_mc) = $db->sql_fetchrow($result);
						}
						else {
							$sql = "INSERT INTO ".$user_prefix."_publi_motsclef (mot) VALUES ('".$keyword."');";
							$ok = ($ok && $db->sql_query($sql));
							$id_mc = $db->sql_nextid();
						}
						$sql = "INSERT INTO ".$user_prefix."_publi_lien_motsclef (id_publi, id_mot) VALUES ('$id_publi','$id_mc');";
						$ok = ($ok && $db->sql_query($sql));
					}
				}
			}
			//modification du nom des fichiers
			$messageModifFile = "";
			if (count($data["newnomfichier"]) > 0) {
				foreach($data["newnomfichier"] as $key=>$value) {
					$sql = "SELECT `title` FROM ".$user_prefix."_downloads_downloads WHERE `lid` ='".$key."';";
					$result = $db->sql_query($sql);
					if ($db->sql_numrows($result) >0) {
						$fileold = $db->sql_fetchrow($result);
					}
					else {
						die("Erreur rcup fichier");
					}
					if ($fileold["title"] != utilFuncs_simpleSpace::anti_conditionnertodb($value)) {
						$sql = "UPDATE ".$user_prefix."_downloads_downloads SET `title`='".$value."', `cid`='".$data["catfichier"]."' WHERE `lid` ='".$key."';";
						$ok = $ok && $db->sql_query($sql);
						$messageModifFile .= _COMSPACE_MESSPART7."\"".$fileold["title"]."\""._COMSPACE_MESSPART8."\"".$value."\"".$saut;
					}
				}
			}
			//enregistrement fichiers
			//print_r($_FILES);
			if (count($_FILES["fichiers"]) > 0) {
				$idfichiers = array();
				global $publisizemaxphoto;
				list($width,$height) = explode("/",$publisizemaxphoto);
				include("core/conf/uploadconfig.php");
				$chemin = $uploadFolder."/".$data["catfichier"];
				$filesSaved = uploadFiles($_FILES["fichiers"], $chemin, $width, $height);
				$messageModifFileTemp = "";
				for($i=0 ; $i < count($filesSaved) ; $i++) {
					$fileSaved = $filesSaved[$i];
					$nomfichier = $data["nomfichier"][$i];
					$filesize = filesize($fileSaved);
					$date = date("Y-m-d H:i:s");
					//$sql ="insert into ".$user_prefix."_downloads_downloads values (NULL, '".$data["catfichier"]."', '0', '".$nomfichier."', '$fileSaved', '"."<p>".$data["titre"]."</p>".$data["description"]."', '$date', '', '', '0','".$userdata[1]."',0,0,0, '$filesize', '', '')";
					$sql ="insert into ".$user_prefix."_downloads_downloads (lid, cid, sid, title, url, description, date, name, email, hits, submitter, downloadratingsummary, totalvotes, totalcomments, filesize, version, homepage,view) values (NULL, '".$data["catfichier"]."', '0', '".$nomfichier."', '$fileSaved', '"."<p>".$data["titre"]."</p>".$data["description"]."', '$date', '', '', '0','".$userdata[1]."',0,0,0, '$filesize', '', '',$current_group)";
					$ok = $ok && $db->sql_query($sql);
					$id_download = $db->sql_nextid();
					$ok = $ok && $db->sql_query("insert into ".$user_prefix."_publi_lien_download (id_publi, id_download) values ('$id_publi','$id_download')");
					$idfichiers[] = array("nom"=>$nomfichier, "id"=>$id_download);
					if ($data["id"] != "") {
						$messageModifFileTemp .= " - ".$nomfichier." : ".$downloadlink.$id_download.$postfixe.$saut;
					}
				}
				if ($messageModifFileTemp != "") {
					$messageModifFile .= _COMSPACE_MESSPART9.$saut.$messageModifFileTemp;
				}
			}
			//expdition des e-mail
			if ($ok) {
				global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
				//$publink = "$nukeurl/modules.php?name=$module_name&op=showpub&id=".$id_publi;
				$publink = "$nukeurl/mworkspace_".$id_publi.".htm";
				//$subscribelink = "$nukeurl/modules.php?name=$module_name&op=showpubevt&id=".$id_publi;
				$subscribelink = "$nukeurl/mworkspace_".$id_publi.".htm";
					
				if ($data["id"] != "") {
					if ($messageModifPubli.$messageModifEvt.$messageModifFile != "") {
						$sujet = _COMSPACE_MESSPART10."\"".$current_group_name."\""._COMSPACE_PUBBY.$userdata[1];
						$message = "";
						$message .= _COMSPACE_MESSPART11."\"".utilFuncs_simpleSpace::anti_conditionnertodb($data["titre"])."\""._COMSPACE_MESSPART12.$userdata[1]._COMSPACE_MESSPART13."\"".$current_group_name."\""._COMSPACE_MESSPART14."\"".$sitename."\" : ".$saut;
						$message .= ($messageModifPubli != "") ? $saut.$sep : "";
						$message .= $messageModifPubli;
						$message .= ($messageModifEvt != "") ? $saut.$sep : "";
						$message .= $messageModifEvt;
						$message .= ($messageModifFile != "") ? $saut.$sep : "";
						$message .= $messageModifFile;
						$themessage = addslashes($message);
						$themessage = "\$themessage=\"".$themessage."\";";
						eval($themessage);
						$message = stripslashes($themessage);
						$message .= $saut.$sep;
						$message .= _COMSPACE_MESSPART15.date("d/m/Y H:i").$saut;
						$sendTheMessage = true;
					}
					else {
						$sendTheMessage = false;
					}
				}
				else {
					$data = array_map(array('utilFuncs_simpleSpace', 'anti_conditionnertodb'), $data);
					require_once("system/modules/becmsNewsletter/class.html2text.inc");
					$h2t = new html2text($hometext,false,70);
					$content_text = $h2t->get_text();
					//suppression & commercial
					$content_text = str_replace("&amp;","&",$content_text);
					$content_text = str_replace("''","'",$content_text);
					//fin suppression
					$sujet = _COMSPACE_MESSPART16."\"".$current_group_name."\""._COMSPACE_PUBBY.$userdata[1];
					$message = "";
					$message .= _COMSPACE_MESSPART17.$userdata[1]._COMSPACE_MESSPART13."\"".$current_group_name."\""._COMSPACE_MESSPART14."\"".$sitename."\" : ".$saut.$saut;
					$message .= $data["titre"].$saut;
					$message .= $content_text.$saut.$saut;
					if ($data["withevt"] == "1") {
						$message .= $sep;
						setlocale(LC_TIME, "$locale");
						$message .= _COMSPACE_MESSPART2.strftime("%A %e %B %Y"._COMSPACE_TO_HOUR."%H:%M",mktime($data["startHour"], $data["startMin"], 0,$data["month"], $data["day"], $data["year"])).$saut;
						if ($data["withregistration"] == "1") {
							$message .= _COMSPACE_MESSPART3.$subscribelink.$saut.$saut;
						}
					}
					if (count($idfichiers) > 0) {
						$message .= $sep;
						$message .= _COMSPACE_MESSPART18.$saut;
						foreach($idfichiers as $idfichier) {
							$message .= " - ".$idfichier["nom"]." : ".$downloadlink.$idfichier["id"].$postfixe.$saut;
						}
						$message .= $saut;
					}
					$message .= $sep;
					$message .= _COMSPACE_MESSPART19.date("d/m/Y H:i").$saut;
					$sendTheMessage = true;
				}
				$message .= _COMSPACE_MESSPART20.$publink.$saut;
					
				$obj_pub = new utilFuncs_simpleSpace();
				$okmail = true;
				$sql = "SELECT uname, email, user_name, user_firstname FROM ".$user_prefix."_users INNER JOIN ".$user_prefix."_users_groups on user_id=uid WHERE group_id ='".$current_group."'";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0 && $sendTheMessage) {
					while ($leusers = $db->sql_fetchrow($result)) {
						$okmail = $ok && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message, $mailadminprivspacepub);
						//echo $leusers["email"]."\n".$mailadminprivspacepub."\n".$sujet."\n".$message."\n"."\n******************************************************************\n";
					}
				}
				if (!$okmail) {
					die("Erreur d'expdition de mail !");
				}
			}
			//die();
			if (!$ok) {
				die("Erreur d'enregistrement dans la base de donnes !");
			}
		}
		$dests_ok = "";
		if (is_array($destmailpub) && count($destmailpub) > 0) {
			$dests_ok = " - mail  ".join(", ",$destmailpub)."";
		}
		$dests_no = "";
		if (is_array($destmailpub_no) && count($destmailpub_no) > 0) {
			$dests_no = " - pas de mail  ".join(", ",$destmailpub)."";
		}
		if ($data["id"] != "") {
			ajoutStat("508 : modification du post id=".$data["id"]." dans l'espace collaboratif".$dests_ok.$dests_no);
		}
		else {
			ajoutStat("501 : publication d'un nouveau post id=".$id_publi." dans l'espace collaboratif".$dests_ok.$dests_no);
		}
		header("Location: mobiles.php?name=$module_name&op=space");
		die();
	}
	else {
		header("Location: mobilesles.php?name=$module_name");
		die();
	}
}

function delfile($id_file, $id) {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub, $nukeurl;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];

		$sql = "SELECT `title`, `titre` FROM ".$user_prefix."_downloads_downloads";
		$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid";
		$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi_lien_download.id_publi=".$user_prefix."_publi.id";
		$sql .= " WHERE ".$user_prefix."_publi_lien_download.id_publi='".$id."' AND lid='".$id_file."' AND user_id='".$userdata[0]."';";
		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
		}
		else {
			die("Autorisation refuse !");
		}
		
		$go = true;
		$result = $db->sql_query("SELECT `title`,`url` FROM ".$user_prefix."_downloads_downloads WHERE lid='".$id_file."';");
		list($title, $url) = $db->sql_fetchrow($result);
		$go = $go && $db->sql_query("DELETE FROM ".$user_prefix."_publi_lien_download WHERE id_download='".$id_file."';");
		$go = $go && $db->sql_query("DELETE FROM ".$user_prefix."_downloads_downloads WHERE lid=".$id_file.";");
		$go = $go && unlink($url);
			
		//expdition des e-mail
		if ($go) {
			global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub,$withuserabt;
			$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
			$nukeurl = $protocol.$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
			//$publink = "$nukeurl/modules.php?name=$module_name&op=showpub&id=".$id_publi;
			$publink = "$nukeurl/mworkspace_".$id.".htm";

			$saut = "\n";
			$sep = "--------------------------------------------------\n";
			$auteurencours = $userdata[14].(($userdata[14] != "" && $userdata[13] != "") ? " " : "").$userdata[13];

			$sujet = "Modification de publication dans le groupe \"".$current_group_name."\" par ".$auteurencours;
			$message = "";
			$message .= "Modifications de la publication \"".$ligne["titre"]."\" de ".$auteurencours." dans le groupe \"".$current_group_name."\" sur l'espace collaboratif de \"".$sitename."\" : ".$saut.$saut;
			$message .= $sep;
			$message .= "Suppression du fichier \"".$ligne["title"]."\"".$saut.$saut;
			$message .= $sep;
			$message .= "Date de la suppression : ".date("d/m/Y H:i").$saut;
			$message .= "Voir la publication : ".$publink.$saut;
			$obj_pub = new utilFuncs_simpleSpace();
			$okmail = true;
			$destmailpub = array();
			$maintenant = date("Y-m-d");
			$sql = "SELECT DISTINCT uname, email, user_name, user_firstname";
			$sql .= " FROM ".$user_prefix."_users";
			$sql .= " INNER JOIN ".$user_prefix."_users_groups on user_id=uid";
			if ($withuserabt == 1) {
				$sql .= " INNER JOIN ".$user_prefix."_users_abt on id_user=uid";
				$sql .= " WHERE group_id ='".$current_group."' AND `du` <= '".$maintenant."' AND `au` >= '".$maintenant."'";
			}
			else {
				$sql .= " WHERE group_id ='".$current_group."'";
			}
			
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while ($leusers = $db->sql_fetchrow($result)) {
					if ($obj_pub->check_email($leusers["email"])){
						//$okmail = $okmail && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message, $mailadminprivspacepub);
						$destmailpub[] = $leusers["email"];
					}
				}
				if (count($destmailpub) > 0) {
					$destmailpub = array_unique($destmailpub);
					$okmail = $obj_pub->send_email_cci(join(",",$destmailpub), $mailsenderprivspacepub,$sujet,$message, $mailadminprivspacepub);
				}
			}
			if (!$okmail) {
				echo utf8_encode("erreur d'expdition de mail");
			}
			else {
				echo utf8_encode("ok");
			}
		}	
	}
	else {
		echo utf8_encode("vous n'tes pas un membre du site");
	}
	die();
}

function showpub($id) {
	global $user, $group, $module_name, $db, $user_prefix, $admin;
	global $textEvents, $eventsopeninnewwindow;
	global $time24Hour, $locale, $_headerContent, $Default_Theme, $formatdateprivspacepub;

	if (is_user($user) && $id!="") {
		$user_data_bloc = base64_decode($user);
		$user_data_bloc = stripslashes($user_data_bloc);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		//vrif de l'inscription de l'utilisateur au groupe de la publi et changement si pas groupe en cours
		$sql = "SELECT id_group FROM ".$user_prefix."_publi WHERE id='".$id."';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			list($id_group) = $db->sql_fetchrow($result);
		}
		else {
			header("Location: mobiles.php?name=$module_name");
			die();
		}
		if (!verif_user_group($id_group)) die("Autorisation rfuse !");
		if (isset ($group)) {
			$group_data_bloc = base64_decode($group);
			$groupdata = explode(":", $group_data_bloc);
			if ($id_group != $groupdata[0]) {
				$groupfix = $id_group;
			}
		}
		else {
			$groupfix = $id_group;
		}

		if (isset($groupfix) && $groupfix != "") {
			$sql = "SELECT name from ".$user_prefix."_groups WHERE id='".$groupfix."'";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 1) {
				$ligne = $db->sql_fetchrow($result);
				docookiegroup($groupfix,$ligne["name"]);
				$current_group = $groupfix;
				$current_group_name = $ligne["name"];
			}
		}
		else {
			$group_data_bloc = base64_decode($group);
			$groupdata = explode(":", $group_data_bloc);
			if (is_array($groupdata) && in_array($groupdata[1], $userdata[11])) {
				$current_group = $groupdata[0];
				$current_group_name = $groupdata[1];
			}
			else {
				$current_group = key($userdata[11]);
				$current_group_name = $userdata[11][key($userdata[11])];
				docookiegroup($current_group,$current_group_name);
			}
		}
		//fin verif et fixation du groupe
		
		if (file_exists('themes/'.$Default_Theme.'/pattern_space_show_pub.php')) {
			/*rcup la publi si elle existe : $publi*/
			$publi = array();
			if ($id != "") {
				$sql = "SELECT id, user_id , id_group , id_news , id_evt , id_topic , id_cat_files , date , titre , description, user_name, user_firstname";
				$sql .= " FROM ".$user_prefix."_publi";
				$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
				$sql .= " WHERE id='".$id."';";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					$publi = $db->sql_fetchrow($result);
					/*if ($publi["user_id"] != $userdata[0] && !is_admin($admin)) {
						die("Accs non autoris !");
					}*/
				}
				else {
					die("Publication inexistante !");
				}
			}
				
			/*rcup les catgories des fichiers : $catfiles*/
			$result3 = $db->sql_query("select title from ".$user_prefix."_downloads_categories where cid=$downloadprivspacecat");
			list($theCat) = $db->sql_fetchrow($result3);
			$result2 = $db->sql_query("select cid, title, parentid from ".$user_prefix."_downloads_categories order by title");
			$catfiles = array();
			$lignetitre = array();
			$ligneid = array();
			while(list($cid2, $ctitle2, $parentid2) = $db->sql_fetchrow($result2)) {
				if ($parentid2!=0) $ctitle2=getparent($parentid2,$ctitle2);
				//if (preg_match("#^$theCat/#", $ctitle2) || $theCat == $ctitle2) {
				if (preg_match("#^$theCat/#", $ctitle2)) {
					$ctitle2 = preg_replace("#^$theCat/#","",$ctitle2);
					array_push($catfiles,array("cid2"=>$cid2,"ctitle2"=>$ctitle2));
				}
			}
			foreach ($catfiles as $key => $row) {
				$ligneid[$key]  = $row['cid2'];
				$lignetitre[$key] = $row['ctitle2'];
			}
			array_multisort($lignetitre, SORT_ASC, $ligneid, SORT_ASC, $catfiles);
				
			/*rcup catgories des publis : $catpublis*/
			$catpublis = array();
			$sql = "SELECT topicid, topicname FROM ".$user_prefix."_topics";
			$sql .= " LEFT JOIN ".$user_prefix."_topics_groups ON topic_id=topicid";
			$sql .= " WHERE group_id='".$current_group."' ORDER BY topicname ASC";
			$toplist = $db->sql_query($sql);
			if ($db->sql_numrows($toplist) == 0) {
				$toplist = $db->sql_query("select topicid, topicname from $user_prefix"._topics." order by topicname");
			}
			while(list($topicid, $topicname) = $db->sql_fetchrow($toplist)) {
				array_push($catpublis,array("topicid"=>$topicid,"topicname"=>$topicname));
			}
				
			/*rcup de l'vnement associ s'il existe : $evenement*/
			if ($id != "" && $publi["id_evt"] != 0) {
				$sql = "SELECT `eventDate` , `endDate` , `startTime` , `endTime` , `alldayevent` , `barcolor` , `withregistration`  FROM ".$user_prefix."_events WHERE eid='".$publi["id_evt"]."';";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					$evenement = $db->sql_fetchrow($result);
				}
			}
			
			/*rcup des membres inscrits  l'vnement (ou indisponibles) s'il y en a : $evenement_incrits */
			$evenement_incrits = array();
			if ($evenement["withregistration"] == 1) {
				$sql = "SELECT er_uid, er_uname, er_eid, er_kind, user_name, user_firstname FROM ".$user_prefix."_events_registered";
				$sql .= " INNER JOIN ".$user_prefix."_users ON ".$user_prefix."_users.uid=".$user_prefix."_events_registered.er_uid";
				$sql .= " WHERE er_eid='".$publi["id_evt"]."';";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while ($ligne = $db->sql_fetchrow($result)) {
						$evenement_incrits[] = $ligne;
					}
				}
			}
				
			/*recup liste de tous les mots clefs : $mcs*/
			$mcs = array();
			$sql = "select mot from ".$user_prefix."_publi_motsclef order by mot asc;";
			$result =  $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while (list($mc) = $db->sql_fetchrow($result)) {
					if (!preg_match("/^(\s+)$/", $mc)) {
						$mcs[] = trim($mc);
					}
				}
			}
				
			/*rcup liste des mots clefs de la publi en cours : $mcs_publi*/
			$mcs_publi = array();
			if ($id != "") {
				$sql = "select mot from ".$user_prefix."_publi_motsclef inner join ".$user_prefix."_publi_lien_motsclef on ".$user_prefix."_publi_motsclef.id=id_mot where id_publi='$id'";
				$result =  $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while (list($mc) = $db->sql_fetchrow($result)) {
						$mcs_publi[] = trim($mc);
					}
				}
			}
				
			/*recup de la liste des fichiers : $fichiers_publi*/
			$fichiers_publi = array();
			if ($id != "") {
				$sql = "SELECT `lid`, `title`, `url`, `filesize` FROM (".$user_prefix."_downloads_downloads";
				$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
				$sql .= " WHERE ".$user_prefix."_publi_lien_download.id_publi='".$id."' order by ".$user_prefix."_downloads_downloads.title asc;";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while($ligne = $db->sql_fetchrow($result)) {
						$fichiers_publi[] = $ligne;
					}
				}
			}
			
			/* rcup de la liste des commentaires : $comments_publi */
			$comments_publi =array();
			function getSubComments($lignecomment, $userdata, $niveau = 0) {
				global $formatdateprivspacepub, $module_name, $db, $user_prefix, $admin;
			
				$sortie = array();
				$lignecomment["niveau"] = $niveau;
				$sortie[] = $lignecomment;
				
				$sql = "SELECT `id`, `id_comment` , `id_publi` , `date` , `id_user` , `user` , `host_name` , `subject` , `comment`, user_name, user_firstname";
				$sql .= " FROM `".$user_prefix."_publi_comments`";
				$sql .= " LEFT JOIN ".$user_prefix."_users on id_user=uid";
				$sql .= " WHERE id_comment='".$lignecomment["id"]."' ORDER BY date ASC;";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					$niveau++;
					while ($lignecomment = $db->sql_fetchrow($result)) {
						$sortie = array_merge($sortie, getSubComments($lignecomment,$userdata, $niveau));
				
					}
				}
				return $sortie;
			}
			$sql = "SELECT `id`, `id_comment` , `id_publi` , `date` , `id_user` , `user` , `host_name` , `subject` , `comment`, user_name, user_firstname";
			$sql .= " FROM `".$user_prefix."_publi_comments`";
			$sql .= " LEFT JOIN ".$user_prefix."_users on id_user=uid";
			$sql .= " WHERE id_publi='".$id."' AND id_comment='0' ORDER BY date ASC;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while ($lignecomment = $db->sql_fetchrow($result)) {
					$comments_publi = array_merge($comments_publi, getSubComments($lignecomment,$userdata));
				}
			}
				
			require_once('themes/'.$Default_Theme.'/pattern_space_show_pub.php');
		
		}
		else {
			$sql = "SELECT id, user_id, id_group, id_news, id_evt, id_topic, id_cat_files, date, titre, description, uname, topicname FROM ".$user_prefix."_publi";
			$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
			$sql .= " lEFT JOIN ".$user_prefix."_topics on topicid=id_topic";
			$sql .= " WHERE id='".$id."';";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$ligne = $db->sql_fetchrow($result);
			
				$_headerContent = "";
				$sortie = "";
				 
				$titre_group = "";
				if ($current_group_name != "") {
					$titre_group = '<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span>';
				}
			
					
				$sortie .= "<h1>"._COMSPACE.$titre_group."</h1>";
			
				$user_id = $ligne["user_id"];
				$id_news = $ligne["id_news"];
				$id_evt = $ligne["id_evt"];
				$titre = $ligne["titre"];
				$description = $ligne["description"];
				//$aboutpub = "Publi le ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub)." par ".$ligne["uname"];
				$aboutpub = _COMSPACE_PUBTHE.utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub)._COMSPACE_PUBBY.$ligne["uname"];
				$topic = $ligne["topicname"];
				$sortie .= '<div class="publi"><h2>'.$titre.'</h2><span class="auteur">'.$aboutpub.'</span>'.$description.'</div>';
					
					
				//affichage vnement
				if ($ligne["id_evt"] != 0) {
					if (file_exists("themes/$Default_Theme/style/Calendrier.css")) {
						$fichiercss = "themes/$Default_Theme/style/Calendrier.css";
					}
					else {
						$fichiercss = "modules/Calendrier/css/default.css";
					}
					$_headerContent .='
					<LINK REL="StyleSheet" HREF="'.$fichiercss.'" TYPE="text/css">
					';
			
					$sortiepub = "";
					$sql = "SELECT `eid`, `title` , `time` , `hometext` , `counter` , `topic` , `informant` , `eventDate` , `endDate` , `startTime` , `endTime` , `alldayevent` , `barcolor` , `withregistration`  FROM ".$user_prefix."_events";
					$sql .= " WHERE eid='".$id_evt."';";
					//echo $sql;
					$result = $db->sql_query($sql);
					if ($db->sql_numrows($result) > 0) {
						$ligne = $db->sql_fetchrow($result);
						if ($dateencours == "") {
							$Date = $ligne["eventDate"];
						}
						else {
							$Date = $dateencours;
						}
						$horaire = "";
						if ($ligne["eventDate"] != $ligne["endDate"]) {
							$datedebut = utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],$formatdateprivspacepub);
							$datefin = utilFuncs_simpleSpace::date2JMA($ligne["endDate"]." ".$ligne["endTime"],$formatdateprivspacepub);
							$horaire .= _COMSPACE_FROM.$datedebut._COMSPACE_TO.$datefin;
						}
						else {
							$horaire .= _COMSPACE_THE.utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],"d/m/Y");
							if ($ligne["startTime"] != $ligne["endTime"]) {
								$horaire .= _COMSPACE_FROM_HOUR.utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],"H:i")._COMSPACE_TO_HOUR.utilFuncs_simpleSpace::date2JMA($ligne["endDate"]." ".$ligne["endTime"],"H:i");
							}
							else {
								$horaire .= _COMSPACE_TO_HOUR.utilFuncs_simpleSpace::date2JMA($ligne["eventDate"]." ".$ligne["startTime"],"H:i");
							}
						}
						if ($ligne["alldayevent"] == "1") {
							$horaire .= " - "._COM_ALLDAY;
						}
						$registration = "";
						if ($ligne["withregistration"] == "1") {
							$sql = "SELECT er_uid, er_uname, er_eid FROM ".$user_prefix."_events_registered";
							$sql .= " WHERE er_eid='".$id_evt."' AND er_uid='".$userdata[0]."';";
							$result = $db->sql_query($sql);
							if ($db->sql_numrows($result) > 0) {
								$register = '<a href="modules.php?name='.$module_name.'&id='.$id_evt.'&op=registerpubevt">[ '._COMSPACE_EVT_REGISTERED.' ]</a>';
							}
							else {
								$register = '<a href="modules.php?name='.$module_name.'&id='.$id_evt.'&op=registerpubevt">[ '._COMSPACE_EVT_REGISTER.' ]</a>';
							}
							$sql = "SELECT er_uid, er_uname, er_eid, er_kind FROM ".$user_prefix."_events_registered";
							$sql .= " WHERE er_eid='".$id_evt."';";
							$result = $db->sql_query($sql);
							$numreg = $db->sql_numrows($result);
							if ($numreg > 0) {
								$registered = '<h4>'._COMSPACE_EVT_REGISTEREDUSERS.'</h4>';
								$notregistered = '<h4>'._COMSPACE_EVT_NOTREGISTEREDUSERS.'</h4>';
								$lesmembresok = "";
								$lesmembrespasok = "";
								while ($ligne = $db->sql_fetchrow($result)) {
									if ($ligne["er_kind"] == "y") {
										$lesmembresok .= "<li>".$ligne["er_uname"]."</li>";
									}
									if ($ligne["er_kind"] == "n") {
										$lesmembrespasok .= "<li>".$ligne["er_uname"]."</li>";
									}
								}
								$registered .= $lesmembresok == "" ? '<ul><li>'._COMSPACE_NONE.'</li></ul>' : "<ul>".$lesmembresok."</ul>";
								$notregistered .= $lesmembrespasok == "" ? '<ul><li>'._COMSPACE_NONE.'</li></ul>' : "<ul>".$lesmembrespasok."</ul>";
							}
							else {
								$registered = '<span class="noreguser">'._COMSPACE_EVT_REGISTEREDUSERSNO."</span>";
							}
							$registration = '<h3><a name="evts"></a>'._COMSPACE_EVT_WITHREGISTER.'</h3>';
							if ($numreg > 0) {
								$registration .= '<div align="center"><table cellpadding="0" cellspacing="4" border="0" class="usersregistered"><tr><td>'.$registered.'</td><td>'.$notregistered.'</td></tr></table></div>';
							}
							else {
								$registration .= $registered;
							}
							$registration .= '<div align="center">'.$register.'</div>';
						}
						 
						$sortie .= "<div class=\"publi\"><div class=\"elts\">";
						$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="nospace"><tr><td><br /><h3>'._COMSPACE_CATEVT.'</h3></td><td width="10"></td><td><br />'.$topic.'</td></tr></table>';
						$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="nospace"><tr><td><h3>'._COMSPACE_DATEEVT.'</h3></td><td width="10"></td><td>'.ucfirst($horaire).'</td></tr></table>';
						$sortie .= $registration.'</div></div>';
					}
					else {
						die("Je ne trouve pas l'vnement de la publi !!!");
					}
				}
				else {
					$sortie .= "<div class=\"publi\"><div class=\"elts\">";
					$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="nospace"><tr><td><br /><h3>'._COMSPACE_CATFILES.'</h3><br /></td><td width="10"></td><td>'.$topic.'</td></tr></table>';
					$sortie .= '</div></div>';
				}
				// affichage des fichiers
				$sql = "SELECT id FROM ".$user_prefix."_publi_lien_download WHERE id_publi='".$id."'";
				if ($db->sql_numrows($db->sql_query($sql)) > 0) {
					$sortiepub = "";
					$sql = "SELECT `lid`, `title`, `url` ,`submitter`, ".$user_prefix."_downloads_downloads.`date`, `filesize` FROM (".$user_prefix."_downloads_downloads";
					$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
					$sql .= " WHERE ".$user_prefix."_publi_lien_download.id_publi='".$id."' order by ".$user_prefix."_downloads_downloads.title asc;";
					//echo $sql;
					$result = $db->sql_query($sql);
					if ($db->sql_numrows($result) > 0) {
						while($ligne = $db->sql_fetchrow($result)) {
							$lapubli = "";
							$lapubli .= $ligne["title"]." - ".utilFuncs_simpleSpace::coolSize($ligne["filesize"]);
							$story_link = "<a href=\"modules.php?name=Downloads&d_op=getit&lid=".$ligne["lid"]."\" target=\"_blank\">";
							$sortieliste .= '<li style="clear: both;"><span style="width: 30px;display: block; float: left"><img src="'.get_icon_for_file($ligne["url"]).'"></span> '.$story_link.$lapubli.'</a>'.'</li>';
						}
						$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
					}
					else {
						$sortiepub .= "Pas de fichiers pour cette publication !!";
					}
			
					//$sortie .= '<div class="publi"><div class="elts"><h3>'._COMSPACE_THEFILES.'</h3>'.$sortiepub.'</div></div>';
					$sortie .= "<div class=\"publi\"><div class=\"elts\"><br />";
					$sortie .= '<h3><a name="files"></a>'._COMSPACE_THEFILES.'</h3>';
					$sortie .= '<div align="center"><div class="files"><table cellpadding="10" cellspacing="4" border="0" class="files"><tr><td>'.$sortiepub.'</td></tr></table></div></div>';
					$sortie .= '</div></div>';
				}
				//voir et poster un commentaire
				$sortie .= "<div class=\"publi\"><div class=\"elts\"><br />";
				$sortie .= '<h3><a name="comments"></a>'._COMSPACE_COMMENTS2.'</h3>';
					
				$sql = "SELECT tid FROM ".$user_prefix."_comments WHERE sid='".$id_news."'";
				$result = $db->sql_query($sql);
				$sortie .= '<div align="center"><a href="modules.php?name=SimpleSpace&op=newcomment&file=comments&id_publi='.$id.'">'._COMSPACE_COMMENTS_NEW."</a></div>";
				//affichage des commentaires
				$sortie .= '<br />';
				include("modules/$module_name/comments.php");
					
				$sortie .= '</div></div>';
				//modifier ou dtruire
				if ($user_id == $userdata[0] || is_admin($admin)) {
					$sortie .= '<div class="publi"><div class="elts"><form name="change"><div align="center"><p>&nbsp;</p>
					<input type="button" value="'._COMSPACE_PUBMODIF.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&op=editpub&id='.$id.'\'">
					<input type="button" value="'._COMSPACE_PUBDEL.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&op=delpub&id='.$id.'\'">
					</div></form></div></div>';
				}
				setHeader($_headerContent);	
			}
			else {
				die ("problme lecture pubblication");
			}
		}
		
		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");
		
		ajoutStat("502 : consultation du post id=$id de l'espace collaboratif");
	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function registerpubevt($id,$ok) {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$sql = "SELECT id, email, titre FROM ".$user_prefix."_publi ";
		$sql .= " LEFT JOIN ".$user_prefix."_users ON user_id=uid";
		$sql .= " WHERE id_evt='$id'";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
		}

		if ($ok=="y" || $ok=="n") {
			$sql = "DELETE FROM ".$user_prefix."_events_registered WHERE er_uid='".$userdata[0]."' AND er_eid='".$id."';";
			$db->sql_query($sql);
			$sql = "INSERT INTO ".$user_prefix."_events_registered (er_uid, er_uname, er_eid, er_kind) VALUES ('".$userdata[0]."', '".$userdata[1]."', '".$id."', '".$ok."');";
			if ($db->sql_query($sql)) {
				//mail  l'auteur de l'evt !
				$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
				$nukeurl = $protocol.$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
				//$evtlink = $nukeurl."/modules.php?name=SimpleSpace&op=showpubevt&id=".$id;
				$evtlink = $nukeurl."/mworkspace_".$ligne["id"].".htm";
				$saut = "\n";
				$message = _COMSPACE_MESS_SUBEVT;
				$message .= $saut.$saut._COMSPACE_MESSPART21.$evtlink.$saut;
				if (utilFuncs_simpleSpace::check_email($ligne["email"])){
					utilFuncs_simpleSpace::send_email($ligne["email"], $mailsenderprivspacepub,_COMSPACE_SUB_SUBEVT,$message,$mailadminprivspacepub);
				}
				echo utf8_encode("ok");
				
				if ($ok == "y") {
					ajoutStat("507 : incription  l'vnement du post id=".$ligne["id"]." dans l'espace collaboratif");
				}
				else {
					ajoutStat("507 : absence  l'vnement du post id=".$ligne["id"]." dans l'espace collaboratif");
				}
			}
			else {
				echo utf8_encode("erreur d'enregistrement  un vnement !");
			}
		}
		else {
			echo utf8_encode("pas de valeur de prsence");
		}
		die();
	}
	else {
		echo utf8_encode("vous n'tes pas identifi comme membre de cet espace priv");
		die();
	}
}

function getJSONcomment($id) {
	global $user_prefix,$db;
	$sql = "SELECT `id`, `id_comment`, `subject` , `comment`";
	$sql .= " FROM `".$user_prefix."_publi_comments`";
	$sql .= " WHERE id='".$id."';";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		$lignecomment = $db->sql_fetchrow($result);
		$objutil = new utilFuncs_simpleSpace();
		$sortie = json_encode($objutil->mon_utf8_encode($lignecomment));
		header("Content-Type: application/json; charset=UTF-8");
		echo $sortie;
	}
	else {
		$sortie = json_encode(array());
		header("Content-Type: application/json; charset=UTF-8");
		echo $sortie;
	}
}

function savecomment($data) {
	global $module_name, $user_prefix, $db,$user, $group, $withuserabt,$admin;
	
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
	
		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		/* vrification existence publi et autorisation */
		$sql = "SELECT `id`, `user_id` , `id_group` , `id_news` , `id_evt` , `id_topic` , `id_cat_files` , `date` , `titre` , `description` FROM `".$user_prefix."_publi` WHERE `id`=".$data["id_publi"].";";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			$lignepubli = $db->sql_fetchrow($result);
			if ($lignepubli["id_group"] != $current_group && !is_admin($admin)) {
				die("Accs non autoris !");
			}
		}
		else {
			die("Publication inexistante !");
		}
		
		/* enregistrement commentaires */
		$data = array_map("utf8_decode", $data);
		$data = array_map(array('utilFuncs_simpleSpace', 'conditionnertodb'), $data);
		if ($data["id"] != "" && $data["id"] != "0" && $data["id"] != "-1") {
			$sql = "UPDATE ".$user_prefix."_publi_comments SET subject='".$data["subject"]."', comment='".$data["comment"]."' WHERE id='".$data["id"]."'";
			$ok = $db->sql_query($sql);
		}
		else {
			$date = date("Y-m-d H:i:s");
			$ip = $_SERVER['REMOTE_ADDR'];
			$sql = "INSERT INTO ".$user_prefix."_publi_comments (`id_comment` , `id_publi` , `date` , `id_user` , `user` , `host_name` , `subject` , `comment`)";
			$sql .= " VALUES ('".$data["id_comment"]."', '".$data["id_publi"]."','".$date."','".$userdata[0]."', '".$userdata[1]."', '".$ip."', '".$data["subject"]."', '".$data["comment"]."')";
			$ok = $db->sql_query($sql);
		}	
		if (!$ok) {
			die("Erreur d'enregistrement dans la base de donnes !");
		}
		
		/* expdition des e-mails */
		
		if ($ok) {
			$data = array_map(array('utilFuncs_simpleSpace', 'anti_conditionnertodb'), $data);
			global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
			
			$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
			$nukeurl = $protocol.$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
			
			require_once("system/modules/becmsNewsletter/class.html2text.inc");
			$h2t = new html2text($data["comment"],false,70);
			$comment_text = $h2t->get_text();
			//suppression & commercial
			$comment_text = str_replace("&amp;","&",$comment_text);
			//fin suppression
			/*$nukeurl = format_nuke_url_2($nukeurl);
			//$publink = "$nukeurl/modules.php?name=$module_name&op=showpub&id=".$id_publi;
			$publink = "$nukeurl/workspace_".$data["id_publi"].".htm";*/
			$publink = "$nukeurl/mworkspace_".$data["id_publi"].".htm";
			$saut = "\n";
			$sep = "--------------------------------------------------\n";
			$auteurencours = $userdata[14].(($userdata[14] != "" && $userdata[13] != "") ? " " : "").$userdata[13];
				
			$sujet = _COMSPACE_MESSPART22."\"".$current_group_name."\" par ".$auteurencours;
			$message = "";
			$message .= _COMSPACE_MESSPART23.$auteurencours._COMSPACE_MESSPART24."\"".$lignepubli["titre"]."\""._COMSPACE_MESSPART13."\"".$current_group_name."\""._COMSPACE_MESSPART14."\"".$sitename."\" : ".$saut.$saut;
			$message .= $data["subject"].$saut;
			$message .= $comment_text.$saut.$saut;
				
			$message .= $sep;
			$message .= _COMSPACE_MESSPART25.date("d/m/Y H:i").$saut;
			$message .= _COMSPACE_MESSPART20.$publink.$saut;
			$obj_pub = new utilFuncs_simpleSpace();
			$okmail = true;
			$destmailpub = array();
			$destmailpub_no = array();
			$maintenant = date("Y-m-d");
			$sql = "SELECT DISTINCT uname, email, user_name, user_firstname";
			$sql .= " FROM ".$user_prefix."_users";
			$sql .= " INNER JOIN ".$user_prefix."_users_groups on user_id=uid";
			if ($withuserabt == 1) {
				$sql .= " INNER JOIN ".$user_prefix."_users_abt on id_user=uid";
				$sql .= " WHERE group_id ='".$current_group."' AND `du` <= '".$maintenant."' AND `au` >= '".$maintenant."'";
			}
			else {
				$sql .= " WHERE group_id ='".$current_group."'";
			}
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while ($leusers = $db->sql_fetchrow($result)) {
					if ($obj_pub->check_email($leusers["email"])){
						//$okmail = $ok && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message,$mailadminprivspacepub);
						$destmailpub[] = $leusers["email"];
					}
					else {
						$destmailpub_no[] = $leusers["email"];
					}
				}
				if (count($destmailpub) > 0) {
					$destmailpub = array_unique($destmailpub);
					$okmail = $obj_pub->send_email_cci(join(",",$destmailpub), $mailsenderprivspacepub,$sujet,$message, $mailadminprivspacepub);
				}
			}
			if (!$okmail) {
				die("Erreur d'expdition de mail !");
			}
		}
		
		$dests_ok = "";
		if (is_array($destmailpub) && count($destmailpub) > 0) {
			$dests_ok = " - mail  ".join(", ",$destmailpub)."";
		}
		$dests_no = "";
		if (is_array($destmailpub_no) && count($destmailpub_no) > 0) {
			$dests_no = " - pas de mail  ".join(", ",$destmailpub)."";
		}
		
		ajoutStat("506 : envoi d'un commentaire sur le post id = ".$data["id_publi"]." dans l'espace collaboratif".$dests_ok.$dests_no);
		
		//header("Location: workspace_".$data["id_publi"].".htm");
		header("Location: mobiles.php?name=$module_name");
		die();
	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}


function list_index($nbreFiches, $page, $ligne_par_page) {
	global $module_name;

	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);


	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._COMSPACE_MEMBERS_FOUND;
		$indexPages .= _COMSPACE_MEMBERS_PAGES;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&op=show_users&page=$min\">$min</a>";
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&op=show_users&page=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?name=".$module_name."&op=show_users&page=$max\">$max</a>";
				$indexPages .= "</div>";
			}

		}
	}
	else {
		$indexPages .= _COMSPACE_MEMBERS_NOTFOUND;
	}
	$indexPages .= "</div>";
	return $indexPages;
}
function show_users($page) {
	global $db, $user_prefix, $user,$group, $module_name, $simpleuserscontact,$Default_Theme;

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$user_data_bloc = stripslashes($user_data_bloc);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);
	}
	else {
		die("Accs non autoris !");
	}
	$group_data_bloc = base64_decode($group);
	$groupdata = explode(":", $group_data_bloc);
	$current_group = $groupdata[0];
	$current_group_name = $groupdata[1];

	if (!verif_user_group($current_group)) die("Autorisation rfuse !");
	
	if (file_exists('themes/'.$Default_Theme.'/pattern_space_users.php')) {
		global $withuserabt;
		$maintenant = date("Y-m-d");
		if ($withuserabt == 1) {
		    $sql = "SELECT `uid`, `uname` , `email` , `adh_entreprise` , `adh_adresse`, `adh_cp`, `adh_ville`, `adh_tel` , `user_name` , `user_firstname`, `user_func`, `du`, `au`, `montant` ";
		    $sql .= " FROM `".$user_prefix."_users`";
		    $sql .= " INNER JOIN ".$user_prefix."_users_abt on id_user=uid";
			$sql .= " WHERE uid='".$userdata[0]."' AND `du` <= '".$maintenant."' AND `au` >= '".$maintenant."';";
		}
		else {
		    $sql = "SELECT `uid`, `uname` , `email` , `adh_entreprise` , `adh_adresse`, `adh_cp`, `adh_ville`, `adh_tel` , `user_name` , `user_firstname`, `user_func` ";
		    $sql .= " FROM `".$user_prefix."_users`";
		    $sql .= " WHERE uid='".$userdata[0]."';";
		}
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 1) {
			$votre_compte = $db->sql_fetchrow($result);
		}
		else {
			setcookie("group"," ");
			setcookie("user"," ");
			die("Votre compte n'existe plus !");
		}
		$votre_compte["groupes"] = $userdata[11];
		
		if ($withuserabt == 1) {
			$sql = "SELECT MAX(au) as aumax ";
			$sql .= " FROM `".$user_prefix."_users`";
			$sql .= " INNER JOIN ".$user_prefix."_users_abt on id_user=uid";
			$sql .= " WHERE uid='".$userdata[0]."' AND `au` >= '".$maintenant."';";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 1) {
				$votre_abt_max = $db->sql_fetchrow($result);
				$votre_compte["au"] = $votre_abt_max["aumax"];
			}
		}
		
		$autrescomptes = array();
		$sql = "SELECT `uid`, `uname` , `email` , `adh_entreprise` , `adh_adresse`, `adh_tel` , `user_name` , `user_firstname`, `user_func`";
		$sql .= " FROM `".$user_prefix."_users`";
		$sql .= " INNER JOIN `".$user_prefix."_users_groups` ON uid=user_id";
		if ($withuserabt == 1) {
			$sql .= " INNER JOIN ".$user_prefix."_users_abt on id_user=uid";
			$sql .= " WHERE group_id='".$current_group."' AND uid<>'".$userdata[0]."' AND `du` <= '".$maintenant."' AND `au` >= '".$maintenant."' ORDER BY uname ASC;";
		}
		else {
			$sql .= " WHERE group_id='".$current_group."' AND uid<>'".$userdata[0]."' ORDER BY uname ASC;";
		}
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			while ($ligneuser = $db->sql_fetchrow($result)) {
				$autrescomptes[] = $ligneuser;
			}
		}
		
		require_once('themes/'.$Default_Theme.'/pattern_space_users.php');
	}
	else {
		$sql = "SELECT `uid`, `uname` , `email` , `adh_entreprise` , `adh_tel` , `user_name` , `user_firstname`";
		$sql .= " FROM `".$user_prefix."_users`";
		$sql .= " WHERE uid='".$userdata[0]."';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 1) {
			$ligneuser = $db->sql_fetchrow($result);
		}
		else {
			setcookie("group"," ");
			setcookie("user"," ");
			die("Votre compte n'existe plus !");
		}
	
		$ligne_par_page = 20;
	
		//Accueil de l'espace collaboratif !!!!!
		$sortie = "";
		$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
		$sortie .= "<h2>"._COMSPACE_ALLUSERS."</h2>";
		$sortieliste = "";
		//$sortie .= "<p>&nbsp;</p>";
		//$sortie .= '<table border="0" celpadding="0" cellspacing="0" width="100%"><tr><td width="49%" valign="top">';
	
		$sortiepub = '<table border="0" cellpadding="0" cellspacing = "0" class="coords">';
	
		$sortiepub .= '<tr><td>';
		$sortiepub .= _COMSPACE_PEUDO;
		$sortiepub .= '</td><td width= "20"></td><td class="coords">';
		$sortiepub .= $ligneuser["uname"];
		$sortiepub .= '</td></tr>';
	
		$sortiepub .= '<tr><td>';
		$sortiepub .= _COMSPACE_NOM;
		$sortiepub .= '</td><td width= "20"></td><td class="coords">';
		$sortiepub .= $ligneuser["user_firstname"]." ".$ligneuser["user_name"];
		$sortiepub .= '</td></tr>';
	
		$sortiepub .= '<tr><td>';
		$sortiepub .= _COMSPACE_ORG;
		$sortiepub .= '</td><td width= "20"></td><td class="coords">';
		$sortiepub .= $ligneuser["adh_entreprise"];
		$sortiepub .= '</td></tr>';
	
		$sortiepub .= '<tr><td>';
		$sortiepub .= _COMSPACE_TEL;
		$sortiepub .= '</td><td width= "20"></td><td class="coords">';
		$sortiepub .= $ligneuser["adh_tel"];
		$sortiepub .= '</td></tr>';
	
		$sortiepub .= '<tr><td>';
		$sortiepub .= _COMSPACE_EMAIL;
		$sortiepub .= '</td><td width= "20"></td><td class="coords">';
		$sortiepub .= $ligneuser["email"];
		$sortiepub .= '</td></tr>';
	
		$sortiepub .= '</table>';
	
		$sortiepub .= '<br /><div class="allelts"><a href="modules.php?name=Sections&sop=viewarticle&artid='.$simpleuserscontact.'">'._COMSPACE_CHANGE_YOUR_ACCOUNT.'</a></div>';
	
		$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_YOUR_ACCOUNT.'</legend>'.$sortiepub.'</fieldset>';
	
		//$sortie .= '</td><td width="2%"></td><td width="49%" valign="top">';
	
		if (file_exists('themes/'.$Default_Theme.'/images/messaging.png')) {
			$icnmsg = 'themes/'.$Default_Theme.'/images/send_mail.png';
		}
		else {
			$icnmsg = 'images/smallicone/send_mail.png';
		}
	
		$sql = "SELECT COUNT(`uid`) AS nbre ";
		$sql .= " FROM `".$user_prefix."_users`";
		$sql .= " INNER JOIN `".$user_prefix."_users_groups` ON uid=user_id";
		$sql .= " WHERE group_id='".$current_group."';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 0) {
			die("Problme base de donnes !!");
		}
		$ligneuser = $db->sql_fetchrow($result);
	
		$theindex = list_index($ligneuser["nbre"], $page, $ligne_par_page);
		$limite = " LIMIT ".($page-1)*$ligne_par_page.",".$ligne_par_page;
	
		$sql = "SELECT `uid`, `uname` , `email` , `adh_entreprise` , `adh_tel` , `user_name` , `user_firstname`";
		$sql .= " FROM `".$user_prefix."_users`";
		$sql .= " INNER JOIN `".$user_prefix."_users_groups` ON uid=user_id";
		$sql .= " WHERE group_id='".$current_group."' ORDER BY uname ASC".$limite.";";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			while ($ligneuser = $db->sql_fetchrow($result)) {
				$story_link = '<a href="modules.php?name='.$module_name.'&file=messages&op=newmessage&id_user='.$ligneuser["uid"].'">';
				$mailbutton = '<a href="modules.php?name='.$module_name.'&file=messages&op=newmessage&id_user='.$ligneuser["uid"].'" title="'.'Expdier un message'.'"><img src="'.$icnmsg.'" border="0"></a>';
				$actions = '<span class="actions">&nbsp;'.$mailbutton.'</span>';
				$sortieliste .= '<li><span class="titre">'.$actions.$story_link.$ligneuser["user_firstname"]." ".$ligneuser["user_name"].'</a>';
				$sortieliste .= ' - '.ucfirst($ligneuser["adh_entreprise"]).'</span>';
				$sortieliste .= '<span class="auteur">'.$ligneuser["uname"].'</span>'.'</li>';
			}
			$sortiepub = "<ul class=\"listpubli\" style=\"margin-top: 8px\">".$sortieliste."</ul>";
			//$sortiepub .= '<div class="allelts"><a href="modules.php?name='.$module_name.'&op=allpub">'._COMSPACE_ALLELEMENTS.'</a></div>';
			$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_USERS.'</legend>'.$theindex.$sortiepub.$theindex.'</fieldset>';
		}
		else {
			$sortie .= "<div class=\"comment\">";
			$sortie .= "Aucun membre pour ce groupe.";
			$sortie .= "</div>";
		}
	}



	$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
	include("header_mobile.php");
	echo $sortie;
	include("footer_mobile.php");
	
	ajoutStat("503 : consultation liste des membres du groupe \"$current_group_name\" de l'espace collaboratif");
}

function save_message($data) {
	global $user, $group, $module_name, $db, $user_prefix, $admin;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);
		 
		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		$data = array_map("utf8_decode", $data);
		$data = array_map(array('utilFuncs_simpleSpace', 'conditionnertodb'), $data);
		 
		if ($data["to_userid"] != "") {
			global $withuserabt;
			$maintenant = date("Y-m-d");
			
			$sql = "SELECT uname, email, user_name, user_firstname FROM ".$user_prefix."_users";
			if ($withuserabt == 1) {
				$sql .= " INNER JOIN ".$user_prefix."_users_abt on id_user=uid";
				$sql .= " WHERE uid='".$data["to_userid"]."' AND `du` <= '".$maintenant."' AND `au` >= '".$maintenant."';";
			}
			else {
				$sql .= " WHERE uid='".$data["to_userid"]."';";
			}
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$leusers = $db->sql_fetchrow($result);
			}
			else {
				$sortie = array("message_sent"=>"false","error"=>"Membre destinataire du message inexistant ou inscription non encore renouvele !");
				$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
				header("Content-type: application/json");
				echo json_encode($sortie);
				die();
			}
		}

		$date = date("Y-m-d H:i");
		
		$sql = "INSERT INTO ".$user_prefix."_priv_msgs (`subject`, `from_userid`, `to_userid`, `msg_time`, `msg_text`, `read_msg`, `valid`)";
		$sql .= " VALUES ('".$data["subject"]."', '".$userdata[0]."', '".$data["to_userid"]."', '".$date."','".$data["msg_text"]."', '0', '1')";
		$ok = $db->sql_query($sql);

		if (!$ok) {
			$sortie = array("message_sent"=>"false","error"=>"Erreur d'enregistrement dans la base de donnes.");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
		$id_mess = $db->sql_nextid();

		global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
		$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
		$nukeurl = $protocol.$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
		
		$messlinklink = "$nukeurl/mobiles.php?name=$module_name&op=viewmessage&id=".$id_mess;
		$saut = "\n";
		$sep = "--------------------------------------------------\n";
		$auteurencours = $userdata[14].(($userdata[14] != "" && $userdata[13] != "") ? " " : "").$userdata[13];

		$sujet = "Nouveau message personnel de ".$auteurencours;
		$message = "";
		$message .= "Un nouveau message personnel vous a t envoy par ".$auteurencours." sur l'espace collaboratif de \"".$sitename."\" : ".$saut.$saut;
			
		$message .= $sep;
		$message .= "Date du message : ".date("d/m/Y H:i").$saut;
		$message .= "Voir le message : ".$messlinklink.$saut;

		$obj_pub = new utilFuncs_simpleSpace();
		if ($obj_pub->check_email($leusers["email"])){
			$okmail = $ok && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message,$mailadminprivspacepub);
		}
		if (!$okmail) {
			$sortie = array("message_sent"=>"false","error"=>"Erreur expdition mail.");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
		
		ajoutStat("504 : envoi message personnel  ".$leusers["uname"]." dans l'espace collaboratif");
		
		$sortie = array("message_sent"=>"true","error"=>"");
		$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
		header("Content-type: application/json");
		echo json_encode($sortie);
		die();
	}
	else {
		$sortie = array("message_sent"=>"false","error"=>"Vous n'tes pas identifi comme membre. Connectez-vous  votre compte !");
		$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
		header("Content-type: application/json");
		echo json_encode($sortie);
		die();
	}
}

function show_messages($page) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $Default_Theme;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		if (file_exists('themes/'.$Default_Theme.'/pattern_space_msgs.php')) {
			$messin = array();
			$sql = "SELECT `msg_id`, `subject`,`msg_text`, `msg_time`, `from_userid`, `uname`, `read_msg`, user_name, user_firstname FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE to_userid = '".$userdata[0]."' AND `valid`='1' ORDER BY msg_time DESC;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$messin[] = $ligne;
				}
			}
			
			$obj_utils = new utilFuncs_simpleSpace();
			
			require_once('themes/'.$Default_Theme.'/pattern_space_msgs.php');
		}
		else {
			$sortie = "";
			$sortie .= "<h1>"._COMSPACE.$titre_group."</h1>";
			$sortie .= "<h2>"._COMSPACE_ALLMSGPERSO."</h2>";
	
	
			if (file_exists('themes/'.$Default_Theme.'/images/messaging.png')) {
				$icnmsg = 'themes/'.$Default_Theme.'/images/messaging.png';
			}
			else {
				$icnmsg = 'images/smallicone/messaging.png';
			}
			if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
				$icndelmsg = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
			}
			else {
				$icndelmsg = 'images/deletesmall.gif';
			}
			 
			$sortiecom = "";
			$sortieliste = "";
			$sortiepub = "";
			$sql = "SELECT `to_userid`,`msg_id`, `subject`, `msg_time`, `from_userid`, `uname`, `read_msg` FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE to_userid = '".$userdata[0]."' and valid='1' order by msg_time desc;";
	
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				//$lignes =array();
				$nbrefiches  = $db->sql_numrows($result);
				while($ligne = $db->sql_fetchrow($result)) {
					//$lignes[] = $ligne;
					if ($ligne["read_msg"] == "0") {
						$pict_new = '<img src="'.$icnmsg.'" align="bottom" border="0">';
					}
					else {
						$pict_new = "";
					}
					if ($ligne["to_userid"] == $userdata[0] || is_admin($admin)) {
						$deletebutton = '<a href="modules.php?name='.$module_name.'&op=delmessage&file=messages&id='.$ligne["msg_id"].'" title="'._COMSPACE_DELMSG.'"><img src="'.$icndelmsg.'" border="0"></a>';
						$actions = '<span class="actions">'.$deletebutton.'</span>';
					}
					else {
						$deletebutton = "";
						$actions = '<span class="actions">'.$deletebutton.'</span>';
					}
						
					$story_link = "<a href=\"modules.php?name=".$module_name."&file=messages&op=viewmessage&id=".$ligne["msg_id"]."\">";
					$sortieliste .= '<li><span class="titre">'.$actions.$pict_new." ".$story_link.$ligne["subject"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"].":00",$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
			}
			else {
				$sortiepub .= "Pas de messages personnels !!";
			}
			//$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_MSGPERSO.'</legend>'.$sortiepub.'</fieldset>';
			$sortie .= $sortiepub;
		}

		
		
		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");

	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function view_message($id) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $Default_Theme;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		if (file_exists('themes/'.$Default_Theme.'/pattern_space_show_msg.php')) {
			$unmessin = array();
			
			$sql = "SELECT `msg_id`, `subject`,`msg_text`, `msg_time`, `from_userid`, `uname`, `read_msg`, user_name, user_firstname FROM ".$user_prefix."_priv_msgs";
			$sql .= " INNER JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE msg_id = '".$id."' AND to_userid='".$userdata[0]."';";
			
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				if($ligne = $db->sql_fetchrow($result)) {
					$unmessin = $ligne;
					$sql = "UPDATE ".$user_prefix."_priv_msgs SET read_msg='1' WHERE msg_id='".$ligne["msg_id"]."'";
					$db->sql_query($sql);
				}
			}
			else {
				die ("Aucun message correspondant !!");
			}
				
			$obj_utils = new utilFuncs_simpleSpace();
				
			require_once('themes/'.$Default_Theme.'/pattern_space_show_msg.php');
			
		}
		else {
			$sql = "SELECT `msg_id`, `subject`, `msg_text`,`msg_time`, `from_userid`, `uname` FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.from_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE msg_id = '".$id."';";
	
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 1) {
				$ligne = $db->sql_fetchrow($result);
				$sql = "UPDATE ".$user_prefix."_priv_msgs SET read_msg='1' WHERE msg_id='$id'";
				$db->sql_query($sql);
			}
			else {
				die ("Problme base de donnes !!");
			}
	
			$aboutmsg = "Expdi le ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"],$formatdateprivspacepub)." par ".$ligne["uname"];
	
			include("header.php");
			$sortie = "";
			$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
			$sortie .= '<div class="publi"><h2>'.$ligne["subject"].'</h2><span class="auteur">'.$aboutmsg.'</span>'.$ligne["msg_text"].'</div>';
	
			$sortie .= '<div class="actmsg"><a href="modules.php?name='.$module_name.'&file=messages&op=newmessage&id_user='.$ligne["from_userid"].'&id_message='.$id.'">[ '._COMSPACE_ANSWERMSG.' ]</a></div>';
		}


		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");
		
		ajoutStat("505 : lecture message personnel de ".$ligne["uname"]." id=$id dans l'espace collaboratif");

	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function del_message($id) {
	global $user, $group, $module_name, $user_prefix, $db,$admin;

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];

		$sql = "SELECT `to_userid`, `subject` FROM ".$user_prefix."_priv_msgs";
		$sql .= " WHERE `msg_id` = '".$id."';";
			
		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
			if (($ligne["to_userid"] != $userdata[0]) && !is_admin($admin)) {
				$sortie = array("message_sent"=>"false","error"=>"Vous n'avez pas l'autorisation de supprimer ce message !");
				$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
				header("Content-type: application/json");
				echo json_encode($sortie);
				die();
			}
		}
		else {
			$sortie = array("message_sent"=>"false","error"=>"Ce message n'existe pas !");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}

		//suppression messages
		if ($db->sql_query("UPDATE ".$user_prefix."_priv_msgs SET valid='0' WHERE msg_id='$id'")){
			$sortie = array("message_sent"=>"true","error"=>"");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
		else {
			$sortie = array("message_sent"=>"false","error"=>"Erreur sur supression de message !");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
	}
	else {
		$sortie = array("message_sent"=>"false","error"=>"Vous n'tes pas identifi comme membre. Connectez-vous  votre compte !");
		$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
		header("Content-type: application/json");
		echo json_encode($sortie);
		die();
	}
}

function show_messages_sent($page) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $Default_Theme;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];

		if (file_exists('themes/'.$Default_Theme.'/pattern_space_msgs_sent.php')) {
			$messout = array();
			$sql = "SELECT `msg_id`, `subject`,`msg_text`, `msg_time`, `from_userid`, `uname`, `read_msg`, user_name, user_firstname FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.to_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE from_userid = '".$userdata[0]."' AND `valid`='1' ORDER BY msg_time DESC;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$messout[] = $ligne;
				}
			}
				
			$obj_utils = new utilFuncs_simpleSpace();
				
			require_once('themes/'.$Default_Theme.'/pattern_space_msgs_sent.php');
		}
		else {
			$sortie = "";
			$sortie .= "<h1>"._COMSPACE.$titre_group."</h1>";
			$sortie .= "<h2>"._COMSPACE_ALLMSGPERSOSENT."</h2>";
		
		
			if (file_exists('themes/'.$Default_Theme.'/images/messaging.png')) {
	    		$icnmsg = 'themes/'.$Default_Theme.'/images/messaging.png';
	    	}
	    	else {
	    		$icnmsg = 'images/smallicone/messaging.png';
	    	}
			if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
				$icndelmsg = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
			}
			else {
				$icndelmsg = 'images/deletesmall.gif';
			}
	    	
			$sortiecom = "";
	 		$sortieliste = "";
	 		$sortiepub = "";
	 		$sql = "SELECT `msg_id`, `subject`, `msg_time`, `from_userid`, `uname`, `read_msg` FROM ".$user_prefix."_priv_msgs";
	    	$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.to_userid=".$user_prefix."_users.uid";
	 		$sql .= " WHERE from_userid = '".$userdata[0]."' order by msg_time desc;";
	
	 		$result = $db->sql_query($sql);
    		if ($db->sql_numrows($result) > 0) {
    			//$lignes =array();
    			$nbrefiches  = $db->sql_numrows($result);
    			while($ligne = $db->sql_fetchrow($result)) {
    				//$lignes[] = $ligne;
					if ($ligne["read_msg"] == "0") {
						$pict_new = '<img src="'.$icnmsg.'" align="bottom" border="0">';
					}
					else {
						$pict_new = "";
					}
					/*if ($ligne["to_userid"] == $userdata[0] || is_admin($admin)) {
						$deletebutton = '<a href="modules.php?name='.$module_name.'&op=delmessage&file=messages&id='.$ligne["msg_id"].'" title="'._COMSPACE_DELMSG.'"><img src="'.$icndelmsg.'" border="0"></a>'; 
						$actions = '<span class="actions">'.$deletebutton.'</span>';
					}
					else {
						$deletebutton = "";
						$actions = '<span class="actions">'.$deletebutton.'</span>';
					}*/
					$actions = "";
					
	    			$story_link = "<a href=\"mobiles.php?name=".$module_name."&op=viewmessagesent&id=".$ligne["msg_id"]."\">";	
    				$sortieliste .= '<li><span class="titre">'.$actions.$pict_new." ".$story_link.$ligne["subject"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"].":00",$formatdateprivspacepub).'</span>'.'</li>';
    			}
    			$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
    		}
    		else {
    			$sortiepub .= "Pas de messages expdis !!";
    		}
    		//$sortie .= '<fieldset class="publi"><legend>'._COMSPACE_MSGPERSO.'</legend>'.$sortiepub.'</fieldset>';
			$sortie .= $sortiepub;
		}



		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);

		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");

	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function view_message_sent($id) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $Default_Theme;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		if (file_exists('themes/'.$Default_Theme.'/pattern_space_show_msg_sent.php')) {
			$unmessout = array();
				
			$sql = "SELECT `msg_id`, `subject`,`msg_text`, `msg_time`, `to_userid`, `uname`, `read_msg`, user_name, user_firstname FROM ".$user_prefix."_priv_msgs";
			$sql .= " INNER JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.to_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE msg_id = '".$id."' AND from_userid='".$userdata[0]."';";
				
			$result = $db->sql_query($sql);
			if (!$db->sql_numrows($result) > 0) {
				die ("Aucun message correspondant !!");
			}
			$unmessout = $db->sql_fetchrow($result);
			
			$obj_utils = new utilFuncs_simpleSpace();
		
			require_once('themes/'.$Default_Theme.'/pattern_space_show_msg_sent.php');
				
		}
		else {
			$sql = "SELECT `msg_id`, `subject`, `msg_text`,`msg_time`, `from_userid`, `uname` FROM ".$user_prefix."_priv_msgs";
			$sql .= " LEFT JOIN ".$user_prefix."_users on ".$user_prefix."_priv_msgs.to_userid=".$user_prefix."_users.uid";
			$sql .= " WHERE msg_id = '".$id."';";
				
			$result = $db->sql_query($sql);
	
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 1) {
				$ligne = $db->sql_fetchrow($result);
			}
			else {
				die ("Problme base de donnes !!");
			}
	
			$aboutmsg = "Expdi le ".utilFuncs_simpleSpace::date2JMA($ligne["msg_time"],$formatdateprivspacepub)."  ".$ligne["uname"];
	
			include("header.php");
			$sortie = "";
			$sortie .= '<h1>'._COMSPACE.'<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span></h1>';
			$sortie .= '<div class="publi"><h2>'.$ligne["subject"].'</h2><span class="auteur">'.$aboutmsg.'</span>'.$ligne["msg_text"].'</div>';
	
			//$sortie .= '<div class="actmsg"><a href="modules.php?name='.$module_name.'&file=messages&op=newmessage&id_user='.$ligne["from_userid"].'&id_message='.$id.'">[ '._COMSPACE_ANSWERMSG.' ]</a></div>';
		}


		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");

	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function resend_message($id) {
	global $user, $group, $module_name, $user_prefix, $db,$admin;

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		
		$sql = "SELECT `subject`, `from_userid`, `to_userid`, `msg_text` FROM ".$user_prefix."_priv_msgs";
		$sql .= " WHERE `msg_id` = '".$id."';";
		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
			if (($ligne["from_userid"] != $userdata[0]) && !is_admin($admin)) {
				$sortie = array("message_sent"=>"false","error"=>"Vous n'avez pas l'autorisation de renvoyer ce message !");
				$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
				header("Content-type: application/json");
				echo json_encode($sortie);
				die();
			}
			else {
				if ($ligne["to_userid"] != "") {
					global $withuserabt;
					$maintenant = date("Y-m-d");
						
					$sql = "SELECT uname, email, user_name, user_firstname FROM ".$user_prefix."_users";
					if ($withuserabt == 1) {
						$sql .= " INNER JOIN ".$user_prefix."_users_abt on id_user=uid";
						$sql .= " WHERE uid='".$ligne["to_userid"]."' AND `du` <= '".$maintenant."' AND `au` >= '".$maintenant."';";
					}
					else {
						$sql .= " WHERE uid='".$ligne["to_userid"]."';";
					}
					$result = $db->sql_query($sql);
					if ($db->sql_numrows($result) > 0) {
						$leusers = $db->sql_fetchrow($result);
					}
					else {
						$sortie = array("message_sent"=>"false","error"=>"Membre destinataire du message inexistant ou inscription non encore renouvele !");
						$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
						header("Content-type: application/json");
						echo json_encode($sortie);
						die();
					}
				}
				
				$ligne = array_map(array('utilFuncs_simpleSpace', 'conditionnertodb'), $ligne);
				$date = date("Y-m-d H:i");
					
				$sql = "INSERT INTO ".$user_prefix."_priv_msgs (`subject`, `from_userid`, `to_userid`, `msg_time`, `msg_text`, `read_msg`, `valid`)";
				$sql .= " VALUES ('".$ligne["subject"]."', '".$userdata[0]."', '".$ligne["to_userid"]."', '".$date."','".$ligne["msg_text"]."', '0', '1')";
				if ($db->sql_query($sql)) {
					$id_mess = $db->sql_nextid();
					
					global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
					$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
					$nukeurl = $protocol.$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
					
					$messlinklink = "$nukeurl/mobiles.php?name=$module_name&op=viewmessage&id=".$id_mess;
					$saut = "\n";
					$sep = "--------------------------------------------------\n";
					$auteurencours = $userdata[14].(($userdata[14] != "" && $userdata[13] != "") ? " " : "").$userdata[13];
					
					$sujet = "Nouveau message personnel de ".$auteurencours;
					$message = "";
					$message .= "Un nouveau message personnel vous a t envoy par ".$auteurencours." sur l'espace collaboratif de \"".$sitename."\" : ".$saut.$saut;
						
					$message .= $sep;
					$message .= "Date du message : ".date("d/m/Y H:i").$saut;
					$message .= "Voir le message : ".$messlinklink.$saut;
					
					$obj_pub = new utilFuncs_simpleSpace();
					if ($obj_pub->check_email($leusers["email"])){
						$okmail = $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message,$mailadminprivspacepub);
					}
					if (!$okmail) {
						$sortie = array("message_sent"=>"false","error"=>"Erreur r-expdition mail.");
						$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
						header("Content-type: application/json");
						echo json_encode($sortie);
						die();
					}
					
					$sortie = array("message_sent"=>"true","error"=>"");
					$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
					header("Content-type: application/json");
					echo json_encode($sortie);
					die();
				}
				else {
					$sortie = array("message_sent"=>"false","error"=>"Erreur sur duplication de message !");
					$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
					header("Content-type: application/json");
					echo json_encode($sortie);
					die();
				}
			}
		}
		else {
			$sortie = array("message_sent"=>"false","error"=>"Ce message n'existe pas !");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
	}
	else {
		$sortie = array("message_sent"=>"false","error"=>"Vous n'tes pas identifi comme membre. Connectez-vous  votre compte !");
		$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
		header("Content-type: application/json");
		echo json_encode($sortie);
		die();
	}
}

function showallpub() {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $page, $topic, $Default_Theme;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
		
		if (file_exists('themes/'.$Default_Theme.'/pattern_space_pubs.php')) {
			/* rcup catgories des publications de ce groupe */
			$toplist = array();
			$sql = "SELECT topicid, topicname FROM ".$user_prefix."_topics";
			$sql .= " LEFT JOIN ".$user_prefix."_topics_groups ON topic_id=topicid";
			$sql .= " WHERE group_id='".$current_group."' ORDER BY topicname ASC";
			$toplist = $db->sql_query($sql);
			if ($db->sql_numrows($toplist) == 0) {
				$toplist = $db->sql_query("select topicid, topicname from $user_prefix"._topics." order by topicname");
			}
			
			/* rcup publications */
			$publis = array();
			
			$wheretopic = "";
			if ($topic != "") {
				$wheretopic = " AND id_topic='$topic'";
			}
			
			$sql = "SELECT becms_publi.id, user_id, id_group, id_news, id_evt, id_topic, id_cat_files, becms_publi.date, becms_publi.titre, becms_publi.description, uname, topiccolor, topicname, user_name, user_firstname, COUNT(".$user_prefix."_publi_comments.id) AS nbrecomment, withregistration, COUNT(".$user_prefix."_publi_lien_download.id) AS nbrefichiers ";
			$sql .= " FROM ".$user_prefix."_publi";
			$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
			$sql .= " LEFT JOIN ".$user_prefix."_topics on id_topic=topicid";
			$sql .= " LEFT JOIN ".$user_prefix."_publi_comments on ".$user_prefix."_publi_comments.id_publi=".$user_prefix."_publi.id";
			$sql .= " LEFT JOIN ".$user_prefix."_events on ".$user_prefix."_events.eid=".$user_prefix."_publi.id_evt";
			$sql .= " LEFT JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_publi=".$user_prefix."_publi.id";
			$sql .= " WHERE id_group='".$current_group."'".$wheretopic;
			$sql .= " GROUP BY ".$user_prefix."_publi.id";
			$sql .= " ORDER BY date DESC".$limit;
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$publis[] = $ligne;
				}	
			}
				
			$obj_utils = new utilFuncs_simpleSpace();
		
			require_once('themes/'.$Default_Theme.'/pattern_space_pubs.php');
		
		}
		else {
			
			$titre_group = "";
			if ($current_group_name != "") {
				$titre_group = '<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span>';
			}
	
			//catgories publications
			$topicname = "";
			$sql = "SELECT topicid, topicname FROM ".$user_prefix."_topics";
			$sql .= " LEFT JOIN ".$user_prefix."_topics_groups ON topic_id=topicid";
			$sql .= " WHERE group_id='".$current_group."' ORDER BY topicname ASC";
			$toplist = $db->sql_query($sql);
			if ($db->sql_numrows($toplist) == 0) {
				$toplist = $db->sql_query("select topicid, topicname from $user_prefix"._topics." order by topicname");
			}
			$numtopics = $db->sql_numrows($toplist);
			$numcols = 3;
			$demi = ceil($numtopics/$numcols);
			$cols = array();
			$compteur=1;
			while(list($topicid, $topics) = $db->sql_fetchrow($toplist)) {
				$numcol = ceil($compteur/$demi);
				$compteur++;
				$cols[$numcol] .= '<li><a href="modules.php?name='.$module_name.'&op=allpub&topic='.$topicid.'">'.$topics.' ('.get_num_pub($current_group, $topicid).')</a></li>';
				if ($topic == $topicid) {
					$topicname = $topics;
				}
			}
			if ($catfichier != "") {
				$menu_cat_news = "";
			}
			else {
				$menu_cat_news = '<fieldset  class="catfile"><legend>'._COMSPACE_CATSPUBS.'</legend>';
				$menu_cat_news .= '<table border="0" cellpadding="0" cellspacing="0"><tr>';
				foreach($cols as $col) {
					$menu_cat_news .= '<td valign="top"><ul>'.$col.'</ul></td>';
				}
				$menu_cat_news .= '</tr></table>';
				$menu_cat_news .= '</fieldset>';
			}
	
			if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
				$icn = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
			}
			else {
				$icn = 'images/deletesmall.gif';
			}
			if (file_exists('themes/'.$Default_Theme.'/images/edit.gif')) {
				$icn2 = 'themes/'.$Default_Theme.'/images/edit.gif';
			}
			else {
				$icn2 = 'images/edit22.gif';
			}
	
			include("header.php");
			$sortie = "";
			$sortie .= "<h1>"._COMSPACE.$titre_group."</h1>";
	
			$sortie .= "<h2>"._COMSPACE_PUBS."</h2>";
	
			$sortie .= $menu_cat_news;
	
			$sortie .= "<fieldset class=\"catfile\"><legend>";
			if ($topic != "") {
				$sortie .= "<a href=\"modules.php?name=".$module_name."&op=allpub\">Espace collaboratif</a> / ";
				$sortie .= $topicname;
			}
			else {
				$sortie .= _COMSPACE_ALLPUBLIS;
			}
			$sortie .= "</legend>";
	
	
			//$sortie .= "<h2>"._COMSPACE_ALLPUBLIS."</h2>";
	
			//pagination
			if (!isset($page) || $page == "") {
				$page = 1;
			}
			$pagesize = 30;
			$min = $pagesize * ($page - 1);
			$max = $pagesize;
			$limit = " LIMIT ".$min.", ".$max;
	
			$wheretopic = "";
			if ($topic != "") {
				$wheretopic = " AND id_topic='$topic'";
			}
	
			$sql = "SELECT COUNT(id) as nbre";
			$sql .= " FROM ".$user_prefix."_publi";
			$sql .= " WHERE id_group='".$current_group."'".$wheretopic;
			$result = $db->sql_query($sql);
			list($nbre) = $db->sql_fetchrow($result);
	
			$indexpages = list_index($nbre, $page, $pagesize, "modules.php?name=".$module_name."&op=allpub&topic=".$topic, _COMSPACE_PUBLIS_FOUND, _COMSPACE_PUBLIS_NOTFOUND, _COMSPACE_PUBLIS_PAGES);
	
			//affichage des publis
			$sortiepub = $indexpages;
			//$sortiepub = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\"><tr><td><div class=\"pages\">".$menu_cat_news."</div></td><td width=\"20\"></td><td>".$indexpages."</td></tr></table>";
			$sortieliste = "";
			$sql = "SELECT id, user_id, id_group, id_news, id_evt, id_topic, id_cat_files, date, titre, description, uname, topiccolor, topicname";
			$sql .= " FROM ".$user_prefix."_publi";
			$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
			$sql .= " LEFT JOIN ".$user_prefix."_topics on id_topic=topicid";
			$sql .= " WHERE id_group='".$current_group."'".$wheretopic." ORDER BY date DESC".$limit;
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					//$lapubli = "";
					//$lapubli .= utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub)." - ".$ligne["uname"]." - ".$ligne["titre"];
					/*$r_options = "";
					 if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "&mode=$cookie[4]"; }
					if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "&order=$cookie[5]"; }
					if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "&thold=$cookie[6]"; }
					$story_link = "<a href=\"modules.php?name=News&file=article&fromspace=1&sid=".$ligne["id_news"].$r_options."\">";*/
					if ($ligne["user_id"] == $userdata[0] || is_admin($admin)) {
						$deletebutton = '<a href="modules.php?name='.$module_name.'&op=delpub&id='.$ligne["id"].'&page='.$page.'&topic='.$topic.'" title="'._COMSPACE_DELPUB.'"><img src="'.$icn.'" border="0"></a>';
						$editbutton = '<a href="modules.php?name='.$module_name.'&op=editpub&id='.$ligne["id"].'&page='.$page.'&topic='.$topic.'" title="'._COMSPACE_EDITPUB.'"><img src="'.$icn2.'" border="0"></a>';
						$actions = '<span class="actions">&nbsp;'.$editbutton.'&nbsp;'.$deletebutton.'</span>';
					}
					else {
						$actions = "";
					}
					$stlplus = "";
					if ($ligne["topiccolor"] != "") {
						$stlplus = ' style="color:'.$ligne["topiccolor"].'"';
					}
					$story_link = "<a href=\"modules.php?name=".$module_name."&op=showpub&id=".$ligne["id"]."\"$stlplus>";
					$catpub = '<span class="catpub">'.$ligne["topicname"].'</span>';
					$sortieliste .= '<li><span class="titre">'.$actions.$catpub.$story_link.$ligne["titre"].'</a></span><span class="auteur">'.$ligne["uname"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
			}
			else {
				$sortiepub .= _COMSPACE_NOPUBS;
			}
	
			$sortiepub .= $indexpages;
	
			$sortie .= $sortiepub;
	
			$sortie .= "</fieldset>";
		}
		
		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");

	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function showallfile() {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $page, $topic, $catfile, $Default_Theme,$downloadprivspacecat;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];

		if (file_exists('themes/'.$Default_Theme.'/pattern_space_files.php')) {
			/* rcup catgories des publications de ce groupe */
			$toplist = array();
			$sql = "SELECT topicid, topicname FROM ".$user_prefix."_topics";
			$sql .= " LEFT JOIN ".$user_prefix."_topics_groups ON topic_id=topicid";
			$sql .= " WHERE group_id='".$current_group."' ORDER BY topicname ASC";
			$toplist = $db->sql_query($sql);
			if ($db->sql_numrows($toplist) == 0) {
				$toplist = $db->sql_query("select topicid, topicname from $user_prefix"._topics." order by topicname");
			}
			
			/*rcup les catgories des fichiers : $catfiles*/
			$result3 = $db->sql_query("select title from ".$user_prefix."_downloads_categories where cid=$downloadprivspacecat");
			list($theCat) = $db->sql_fetchrow($result3);
			$result2 = $db->sql_query("select cid, title, parentid from ".$user_prefix."_downloads_categories order by title");
			$catfiles = array();
			$lignetitre = array();
			$ligneid = array();
			while(list($cid2, $ctitle2, $parentid2) = $db->sql_fetchrow($result2)) {
				if ($parentid2!=0) $ctitle2=getparent($parentid2,$ctitle2);
				//if (preg_match("#^$theCat/#", $ctitle2) || $theCat == $ctitle2) {
				if (preg_match("#^$theCat/#", $ctitle2)) {
					$ctitle2 = preg_replace("#^$theCat/#","",$ctitle2);
					array_push($catfiles,array("cid2"=>$cid2,"ctitle2"=>$ctitle2));
				}
			}
			foreach ($catfiles as $key => $row) {
				$ligneid[$key]  = $row['cid2'];
				$lignetitre[$key] = $row['ctitle2'];
			}
			array_multisort($lignetitre, SORT_ASC, $ligneid, SORT_ASC, $catfiles);
			
			/* rcup de la liste des fichiers */
			$wherecatfile = "";
			if ($catfile != "") {
				$wherecatfile = " AND cid='$catfile'";
			}
			
			$fichiers = array();
			$sql = "SELECT `lid`, `title`, ".$user_prefix."_downloads_downloads.`url` ,`submitter`, ".$user_prefix."_downloads_downloads.`date`, `filesize` , titre, ".$user_prefix."_publi.id, user_name, user_firstname FROM ((".$user_prefix."_downloads_downloads";
			$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id=".$user_prefix."_publi_lien_download.id_publi)";
			$sql .= " LEFT JOIN ".$user_prefix."_users on uname=submitter";
			$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."'".$wherecatfile." ORDER BY ".$user_prefix."_downloads_downloads.date DESC;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$fichiers[] = $ligne;
				}
			}
			
			$obj_utils = new utilFuncs_simpleSpace();
			
			require_once('themes/'.$Default_Theme.'/pattern_space_files.php');
		}
		else {
			$titre_group = "";
			if ($current_group_name != "") {
				$titre_group = '<span class="subh1">'._COMSPACE_FOR_GROUP.'"'.$current_group_name.'"</span>';
			}
			
			//catgories publications
			$topicname = "";
			$sql = "SELECT topicid, topicname FROM ".$user_prefix."_topics";
			$sql .= " LEFT JOIN ".$user_prefix."_topics_groups ON topic_id=topicid";
			$sql .= " WHERE group_id='".$current_group."' ORDER BY topicname ASC";
			$toplist = $db->sql_query($sql);
			if ($db->sql_numrows($toplist) == 0) {
				$toplist = $db->sql_query("select topicid, topicname from $user_prefix"._topics." order by topicname");
			}
			$numtopics = $db->sql_numrows($toplist);
			$numcols = 2;
			$demi = ceil($numtopics/$numcols);
			$cols = array();
			$compteur=1;
			while(list($topicid, $topics) = $db->sql_fetchrow($toplist)) {
				$numcol = ceil($compteur/$demi);
				$compteur++;
				$cols[$numcol] .= '<li><a href="modules.php?name='.$module_name.'&op=allfile&topic='.$topicid.'">'.$topics.' ('.get_num_files($current_group, $topicid).')</a></li>';
				if ($topic == $topicid) {
					$topicname = $topics;
				}
			}
			if ($catfichier != "") {
				$menu_cat_news = "";
			}
			else {
				$menu_cat_news = '<fieldset  class="catfile"><legend>'._COMSPACE_CATSPUBS.'</legend>';
				$menu_cat_news .= '<table border="0" cellpadding="0" cellspacing="0"><tr>';
				foreach($cols as $col) {
					$menu_cat_news .= '<td valign="top"><ul>'.$col.'</ul></td>';
				}
				$menu_cat_news .= '</tr></table>';
				$menu_cat_news .= '</fieldset>';
			}
			
			//catgories fichiers
			$result3 = $db->sql_query("select title from ".$user_prefix."_downloads_categories where cid=$downloadprivspacecat");
			list($theCat) = $db->sql_fetchrow($result3);
			$result2 = $db->sql_query("select cid, title, parentid from ".$user_prefix."_downloads_categories order by title");
			$lignes = array();
			$lignetitre = array();
			$ligneid = array();
			while(list($cid2, $ctitle2, $parentid2) = $db->sql_fetchrow($result2)) {
				if ($parentid2!=0) $ctitle2=getparent($parentid2,$ctitle2);
				//if (preg_match("#^$theCat/#", $ctitle2) || $theCat == $ctitle2) {
				if (preg_match("#^$theCat/#", $ctitle2)) {
					$ctitle2 = preg_replace("#^$theCat/#","",$ctitle2);
					array_push($lignes,array("cid2"=>$cid2,"ctitle2"=>$ctitle2));
				}
			}
			foreach ($lignes as $key => $row) {
				$ligneid[$key]  = $row['cid2'];
				$lignetitre[$key] = $row['ctitle2'];
			}
			array_multisort($lignetitre, SORT_ASC, $ligneid, SORT_ASC, $lignes);
			$numcats = count($lignes);
			$demi = ceil($numcats/$numcols);
			$cols = array();
			$compteur=1;
			foreach ($lignes as $ligne) {
				$numcol = ceil($compteur/$demi);
				$compteur++;
				$cols[$numcol] .= '<li><a href="modules.php?name='.$module_name.'&op=allfile&topic='.$topic.'&catfichier='.$ligne["cid2"].'">'.$ligne["ctitle2"].' ('.get_num_files($current_group, $topic, $ligne["cid2"]).')</a></li>';
				if ($catfichier == $ligne["cid2"]) {
					$catfilename = $ligne["ctitle2"];
				}
			}
			if ($topic == "") {
				$menu_cat_files = "";
			}
			else {
				//$menu_cat_files = $menu_cat_news != "" ? "<br>": "";
				$menu_cat_files = '<fieldset class="catfile"><legend>'._COMSPACE_CATFILES2.'</legend>';
				$menu_cat_files .= '<table border="0" cellpadding="0" cellspacing="0"><tr>';
				foreach($cols as $col) {
					$menu_cat_files .= '<td valign="top"><ul>'.$col.'</ul></td>';
				}
				$menu_cat_files .= '</tr></table>';
				$menu_cat_files .= '</fieldset>';
			}
			
			
			//pagination
			if (!isset($page) || $page == "") {
				$page = 1;
			}
			$pagesize = 20;
			$min = $pagesize * ($page - 1);
			$max = $pagesize;
			$limit = " LIMIT ".$min.", ".$max;
			
			$wheretopicfile = "";
			if ($topic != "") {
				$wheretopicfile = " AND id_topic='$topic'";
			}
			
			$wherecatfile = "";
			if ($catfichier != "") {
				$wherecatfile = " AND id_cat_files='$catfichier'";
			}
			
			$sql = "SELECT COUNT(`lid`) as nbre FROM ((".$user_prefix."_downloads_downloads";
			$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id=".$user_prefix."_publi_lien_download.id_publi)";
			$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."'".$wherecatfile.$wheretopicfile.";";
			$result = $db->sql_query($sql);
			list($nbre) = $db->sql_fetchrow($result);
			
			$indexpages = list_index($nbre, $page, $pagesize, "modules.php?name=".$module_name."&op=allfile&topic=".$topic."&catfichier=".$catfichier, _COMSPACE_FILES_FOUND, _COMSPACE_FILES_NOTFOUND, _COMSPACE_FILES_PAGES);
			
			include("header.php");
			$sortie = "";
			$sortie .= "<h1>"._COMSPACE.$titre_group."</h1>";
			
			$sortie .= "<h2>"._COMSPACE_FILES2."</h2>";
			
			$sortie .= $menu_cat_news;
			$sortie .= $menu_cat_files;
			
			$sortie .= "<fieldset class=\"catfile\"><legend>";
			if ($topic != "") {
				$sortie .= "<a href=\"modules.php?name=".$module_name."&op=allfile\">"._COMSPACE."</a> / ";
				if ($catfichier != "") {
					$sortie .= "<a href=\"modules.php?name=".$module_name."&op=allfile&topic=".$topic."\">".$topicname."</a> / ".$catfilename;
				}
				else {
					$sortie .= $topicname;
				}
			}
			else {
				$sortie .= _COMSPACE_ALLFILES;
			}
			$sortie .= "</legend>";
			
			//affichage des fichiers
			$sortieliste = "";
			$sortiepub = $indexpages;
			//$sortiepub = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\"><tr><td><div class=\"pages\">".$menu_cat_news.$menu_cat_files."</div></td><td width=\"20\"></td><td>".$indexpages."</td></tr></table>";
			$sql = "SELECT `lid`, `title`, `url` ,`submitter`, ".$user_prefix."_downloads_downloads.`date`, `filesize` , titre, ".$user_prefix."_publi.id, topicname FROM ((".$user_prefix."_downloads_downloads";
			$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid)";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id=".$user_prefix."_publi_lien_download.id_publi)";
			$sql .= " LEFT JOIN ".$user_prefix."_topics on id_topic=topicid";
			$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."'".$wherecatfile.$wheretopicfile." order by ".$user_prefix."_downloads_downloads.date desc".$limit;
			//echo $sql;
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					//$lapubli = "";
					//$lapubli .= utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub)." - ".$ligne["submitter"]." - ".$ligne["title"]." - ".$ligne["titre"];
					//$story_link = "<a href=\"modules.php?name=".$module_name."&op=showpubfiles&id=".$ligne["id"]."\">";
					$story_link = "<a href=\"modules.php?name=".$module_name."&op=showpub&id=".$ligne["id"]."\">";
					//$sortieliste .= '<li>'.$story_link.$lapubli.'</a>'.'</li>';
					$catpub = '<span class="catpub">'.$ligne["topicname"].'</span>';
					$sortieliste .= '<li><span class="titre">'.$story_link.$ligne["title"].$catpub."<span class=\"sstitle\">".$ligne["titre"].'</span></a></span><span class="auteur">'.$ligne["submitter"]." - ".utilFuncs_simpleSpace::date2JMA($ligne["date"],$formatdateprivspacepub).'</span>'.'</li>';
				}
				$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
			}
			else {
				$sortiepub .= _COMSPACE_MESSPART30;
			}
			$sortiepub .= $indexpages;
			$sortie .= $sortiepub;
			
			$sortie .= "</fieldset>";
		}
		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");
		
	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function showallevt($dateencours) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdateprivspacepub, $admin, $page, $Default_Theme;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);
	
		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
	
		if (file_exists('themes/'.$Default_Theme.'/pattern_space_evts.php')) {
			$evts = array();
			$sql = "SELECT `eid`, `aid`, `title`, `informant`, `eventDate`, `endDate`, `startTime`, `endTime`, `alldayevent`, `withregistration`, ".$user_prefix."_publi.id, ".$user_prefix."_publi.date, ".$user_prefix."_publi.titre, user_name, user_firstname FROM ".$user_prefix."_events ";
			$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi.id_evt=".$user_prefix."_events.eid";
			$sql .= " LEFT JOIN ".$user_prefix."_users on user_id=uid";
			$sql .= " WHERE ".$user_prefix."_publi.id_group='".$current_group."' ORDER BY ".$user_prefix."_events.eventDate DESC, ".$user_prefix."_events.startTime DESC;";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$evts[] = $ligne;
				}
			}
			
			$obj_utils = new utilFuncs_simpleSpace();
				
			require_once('themes/'.$Default_Theme.'/pattern_space_evts.php');
		}
		else {
			/* cer un code par dfaut ou rcuprr celui dj cr */
		}
	
		$sortie = utilFuncs_simpleSpace::conditionnerMobile($sortie);
		
		include("header_mobile.php");
		echo $sortie;
		include("footer_mobile.php");
	
	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function getfile($id_file, $id) {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub, $nukeurl;
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];

		$sql = "SELECT `title`, `url` FROM ".$user_prefix."_downloads_downloads";
		$sql .= " INNER JOIN ".$user_prefix."_publi_lien_download on ".$user_prefix."_publi_lien_download.id_download=".$user_prefix."_downloads_downloads.lid";
		$sql .= " INNER JOIN ".$user_prefix."_publi on ".$user_prefix."_publi_lien_download.id_publi=".$user_prefix."_publi.id";
		$sql .= " WHERE ".$user_prefix."_publi_lien_download.id_publi='".$id."' AND lid='".$id_file."' AND id_group='".$current_group."';";
		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
		}
		else {
			die("Autorisation refuse !");
		}

		$file = $ligne["url"];
		$extension = strtolower(substr(strrchr($ligne["url"], '.'), 1));
		
		$limit_taille = 32 * 1024 *1024;
		if (filesize($file) < $limit_taille) {
			header('Content-Description: File Transfer');
			header('Content-Type: application/octet-stream');
			header('Content-Disposition: attachment; filename="'.utilFuncs_simpleSpace::normaliser($ligne["title"].'.'.$extension).'"');
			header('Expires: 0');
			header('Cache-Control: must-revalidate');
			header('Pragma: public');
			header('Content-Length: ' . filesize($file));
			readfile($file);
			die();
		}
		else {
			header("Location: ".$file);
			die();
		}
	}
	else {
		header("Location: mobiles.php?name=$module_name");
		die();
	}
}

function del_pub($id) {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub,$nukeurl,$admin;
	global $page, $topic;

	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		$sql = "SELECT titre, user_id, id_news, id_evt FROM ".$user_prefix."_publi ";
		//$sql .= " WHERE id='$id' AND user_id='".$userdata[0]."';";
		$sql .= " WHERE id='$id';";
		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
			if (($ligne["user_id"] != $userdata[0]) && !is_admin($admin)) {
				$sortie = array("message_sent"=>"false","error"=>"Vous n'avez pas l'autorisation de supprimer ce post !");
				$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
				header("Content-type: application/json");
				echo json_encode($sortie);
				die();
			}
		}
		else {
			$sortie = array("message_sent"=>"false","error"=>"Ce post n'existe pas !");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}

		//suppression fichiers
		$result2 = $db->sql_query("SELECT id_download FROM ".$user_prefix."_publi_lien_download WHERE id_publi='".$id."';");
		if ($db->sql_numrows($result2) > 0) {
			while($ligne2 = $db->sql_fetchrow($result2)) {
				//effacer fiche id_download et fichier correspondant !
				$result3 = $db->sql_query("SELECT `url` FROM ".$user_prefix."_downloads_downloads WHERE lid='".$ligne2["id_download"]."';");
				if (list($url) = $db->sql_fetchrow($result3)) {
					if (!$db->sql_query("DELETE FROM ".$user_prefix."_downloads_downloads WHERE lid=".$ligne2["id_download"].";")) {
						$sortie = array("message_sent"=>"false","error"=>"Erreur sur suppression de fiche fichier ".$url." !");
						$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
						header("Content-type: application/json");
						echo json_encode($sortie);
						die();
					}
					unlink($url);
				}
			}
		}
		if (!$db->sql_query("DELETE FROM ".$user_prefix."_publi_lien_download WHERE id_publi='".$id."';")) {
			$sortie = array("message_sent"=>"false","error"=>"Erreur sur suppression des liens post-fichier !");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
		//suppression evt et enregistrements utilisateurs
		if ($ligne["id_evt"] != 0) {
			if (!$db->sql_query("DELETE FROM ".$user_prefix."_events_registered  WHERE er_eid='".$ligne["id_evt"]."';")){
				$sortie = array("message_sent"=>"false","error"=>"Erreur sur suppresion des membres incrits  l'vnement !");
				$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
				header("Content-type: application/json");
				echo json_encode($sortie);
				die();
			}
			if (!$db->sql_query("DELETE FROM ".$user_prefix."_events  WHERE eid='".$ligne["id_evt"]."';")) {
				$sortie = array("message_sent"=>"false","error"=>"Erreur sur supression de l'vnement !");
				$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
				header("Content-type: application/json");
				echo json_encode($sortie);
				die();
			}
		}
		//suppresion commentaires
		if ($ligne["id_news"] != 0) {
			if (!$db->sql_query("DELETE FROM ".$user_prefix."_publi_comments  WHERE id_publi='".$id."';")){
				$sortie = array("message_sent"=>"false","error"=>"Erreur sur suppression des commentaires !");
				$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
				header("Content-type: application/json");
				echo json_encode($sortie);
				die();
			}
		}
		//suppression liens mots clefs
		if (!$db->sql_query("DELETE FROM ".$user_prefix."_publi_lien_motsclef WHERE id_publi='".$id."';")){
			$sortie = array("message_sent"=>"false","error"=>"Erreur sur suppression des mots clefs !");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
		//suppresion publi
		if ($db->sql_query("DELETE FROM ".$user_prefix."_publi WHERE id='".$id."';")){
			ajoutStat("509 : supression du post id=".$id." dans l'espace collaboratif");
			$sortie = array("message_sent"=>"true","error"=>"");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
		else {
			$sortie = array("message_sent"=>"false","error"=>"Erreur sur suppression du post !");
			$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
			header("Content-type: application/json");
			echo json_encode($sortie);
			die();
		}
	}
	else {
		$sortie = array("message_sent"=>"false","error"=>"Vous n'tes pas identifi comme membre. Connectez-vous  votre compte !");
		$sortie = array_map(array('utilFuncs_simpleSpace', 'conditionnerMobile'), $sortie);
		header("Content-type: application/json");
		echo json_encode($sortie);
		die();
	}
}

switch($op) {
	case "login":
		//on laise le module SimpleUsers s'occuper du login : il fait a trs bien !
		header("Location: mobiles.php?name=SimpleUsers&groupstrict=1");
		die();
		break;
	case "logout":
		//on laisse le module SimpleUsers s'occuper du logout : il fait a trs bien !
		header("Location: mobiles.php?name=SimpleUsers&op=logout");
		break;
	case "space":
		space($groupfix);
		break;
	case "new_pub":
		new_pub();
		break;
	case "editpub":
		new_pub($id);
		break;
	case "delfile":
		delfile($id_file, $id);
		break;
	case "savepub":
		save_pub($data);
		break;
	case "showpub":
		showpub($id);
		break;
	case "registerpubevt":
		registerpubevt($id, $ok);
		break;
	case "getJSONcomment":
		getJSONcomment ($id);
		break;
	case "savecomment":
		savecomment($data);
		break;
	case "show_users":
		show_users($page);
		break;
	case "savemessage":
		save_message($data);
		break;
	case "showmessage":
		show_messages($page);
		break;
	case "viewmessage":
		view_message($id);
		break;
	case "delmessage":
		del_message($id);
		break;
	case "allmsgsent":
		show_messages_sent($page);
		break;
	case "send_again_message":
		resend_message($id);
		break;
	case "viewmessagesent":
		view_message_sent($id);
		break;
	case "allpub" :
		showallpub();
		break;
	case "allfile":
		showallfile();
		break;
	case "getfile":
		getfile($id_file, $id);
		break;
	case "allevt" :
		showallevt($dateencours);
		break;
	case "delpub" :
		del_pub($id);
		break;
	default:
		main($user,$force);
		break;
	
		
		
		
		
		
		
		
	
	
	
	case "showpubfiles":
		showpubfiles($id);
		break;
	case "showpubevt":
		showpubevt($id,$dateencours);
		break;
	case "showpubagenda":
		showpubagenda($dateencours);
		break;
	case "searchpub" :
		searchpub($search);
		break;
	case "searchcomplex" :
		searchcomplex($searchcomplex);
		break;
	case "allpub" :
		showallpub();
		break;
	case "allevt" :
		showallevt($dateencours);
		break;
	case "allfile" :
		showallfiles();
		break;
	case "allcom" :
		showallcoms();
		break;
	
}


?>