<?php
/**
* Fonctions publique d'interface entre le CMS et le module de gestion des clients.
* 
* Ces fonctions sont publiques. 
* @package becmsSimpleClient
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

if (preg_match("#connector_lib.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

require_once("lib/g_params.php");
require_once("lib/g_db.php");
require_once("lib/ba_adminsudoku.php");

$My_SQL["maBase"] = $db;

/**
* Classe des fonctions.
* 
* @package becmsSimpleClient
*/
class sudokuconnector {
/**
* Renvoie la liste des sudokus enregistrs.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @return array Tableau contenant la liste des Sudokus.
*/
	function getMySudokus($My_SQL, $vars_mod,$limit="") {
		$sgbd = new BD_Sudoku();
		$parties = $sgbd->getPartiesSudoku($My_SQL,"","",$_SESSION["s_id_client"],"",$limit);
		$sudokuList = array();
		foreach ($parties as $partie) {
			$sudokus = $sgbd->getSudokus($My_SQL,$partie["id_sudoku"]);
    		array_push($sudokuList,array( "id_grille" => $sudokus[0]["Id"],"id_partie" => $partie["Id"],"niveau" => ceil($sudokus[0]["niveau"]*7/1000),"date" => $partie["date"], "grille_utilisateur" => $partie["grille_utilisateur"], "masque_utilisateur" => $partie["masque_utilisateur"],"grille" => $sudokus[0]["grille"], "masque" => $sudokus[0]["masque"],));        	
	    }
		return $sudokuList;
	}
}

?>