<?php
global $prefix, $db, $nukeurl, $currentlang;
global $sql_create_table_temp, $module_name;

require_once ("modules/atlas_accessit/system/params.php");
require_once ("modules/atlas_accessit/system/functions.php");
require_once ("modules/atlas_accessit/system/xmlparser.php");

require_once ("core/becms_mainlib_lib.php");

$tab_sql = explode ( ";", $sql_create_table_temp );
foreach ( $tab_sql as $sql ) {
	if ($sql != "") {
		if (! $db->sql_query ( $sql )) {
			print_r ( $db->sql_error () );
			die ();
		}
	}
}

//alerte ( $sql_create_table_temp );

alerte ( "begin update atlas" );

$monFichier = $dirtemp . $f_atlas . ".xml";
//alerte ( "downloading : " . $url_xml_atlas );
get_data_to_file($url_xml_atlas, $monFichier);

$enable_itineraire = false;
$enable_site = false;
$itineraire = array ();
$site = array ();
$ids_itineraires = array ();
$compteur_itineraire = 0;
$contentTag = "";
$nbItineraire = 0;
$nbSite = 0;

if (file_exists ( $monFichier )) {
	alerte ( "begin parsing : " . $f_atlas );
	$i = 0;
	while ( ! empty_data_file ( $monFichier ) && $i < 2 ) {
		if ($i == 0) {
			parse_file ( $monFichier, "openTagItineraire", "closeTagItineraire", "contentTagItineraire" );
		} else {
			parse_file ( $monFichier, "openTagSite", "closeTagSite", "contentTagSite" );
		}
		$i ++;
	}
	alerte ( "end parsing : " . $f_atlas );
	if (verifDonneesTables ()) {
		$datetime = date("Y-m-d-H-i-s");
		$newNomFichier = $dirtemp . $f_atlas . "_" . $datetime;
		// Si la classe ZipArchive posse probleme on peut lancer une commande systeme gZip a la place
		$zip = new ZipArchive();
		if($zip->open($newNomFichier . '.zip', ZipArchive::CREATE) === true) {
			$zip->addFile($monFichier, $f_atlas . "_" . $datetime . ".xml");
			$zip->close();
		} else {
			alerte("Impossible de creer l'archive");
			if( !rename($monFichier, $newNomFichier . ".xml") ) {
				alerte ( "Une erreur lors du renommage du fichier xml" );
			}
		}
		if (! movedatabase ()) {
			alerte ( "Une erreur lors du renommage des tables" );
		}
	}
}

/**
 * Permet de grer lors de l'ouverture de la balise pour la recuperation des itineraires
 * 
 * @param unknown $parseur
 *        	le parseur
 * @param unknown $nomBalise
 *        	le nom de la balise
 * @param unknown $tableauAttributs
 *        	le tableau d'attribute
 */
function openTagItineraire($parseur, $nomBalise, $tableauAttributs) {
	global $enable_itineraire;
	global $contentTag;
	if ($nomBalise == strtoupper ( "Itinerario" )) {
		$enable_itineraire = true;
	} else if ($nomBalise == strtoupper ( "Siti" )) {
		$enable_itineraire = false;
	} else if ($enable_itineraire) {
		$contentTag = "";
	}
}

/**
 * Permet de grer la fermeture d'une balise pour la recuperation des itineraires
 * 
 * @param unknown $parseur
 *        	le parseur
 * @param unknown $nomBalise
 *        	le nom de la balise
 */
function closeTagItineraire($parseur, $nomBalise) {
	global $it_fr_itineraire, $dirImg, $pathRacine, $separatorImageAlbum;
	global $itineraire, $enable_itineraire;
	global $ids_itineraires;
	global $contentTag;
	global $nbItineraire;
	if ($nomBalise == strtoupper ( "Siti" )) {
		$enable_itineraire = true;
	} else if ($nomBalise == strtoupper ( "Itinerario" )) {
		$enable_itineraire = false;
		$itineraire ["id"] = "";
		if (count ( $itineraire ) > 1) {
			//print_r ( $itineraire );
			$nbItineraire ++;
			$result = saveDbItineraire ( $itineraire );
			if ($result === false) {
				echo "\n\n\n";
				print_r($itineraire);
				echo "\n\n\n";
				die ( "Erreur dans l'enregistrement d'un itineraire dans la base de donnees\n" );
			} else {
				$ids_itineraires [] = $result;
			}
		}
		array_splice ( $itineraire, 0, count ( $itineraire ) );
	} else if ($enable_itineraire) {
		if ($contentTag != "" && isset ( $it_fr_itineraire [$nomBalise] )) {
			if ($it_fr_itineraire [$nomBalise] == "Site_web" || $it_fr_itineraire [$nomBalise] == "Pieces_jointes" || $it_fr_itineraire [$nomBalise] == "Album") {
				$contentTag = preg_replace ( "#^http://#", "", $contentTag );
				$contentTag = "http://" . $contentTag;
				if ($it_fr_itineraire [$nomBalise] == "Album") {
					$albums = explode ( $separatorImageAlbum, $contentTag );
					$contentTag = "";
					foreach ( $albums as $album ) {
						$path_parts = pathinfo($album);
						$imageName = md5($album).".".$path_parts['extension'];
						if (file_exists ( $dirImg . $imageName ) ) {
							$album = realpath ( $dirImg . $imageName );
							//$album = str_replace ( $pathRacine . "\\", "", $album );
							$album = str_replace($pathRacine, "", $album);
							$album = preg_replace("#^\\\\#", "", $album);
							$album = preg_replace("#^/#", "", $album);
							$album = str_replace ( "\\", "/", $album );
						}
						$contentTag .= $album.";";
					}
					$contentTag = preg_replace ( "#;$#", "", $contentTag );
				}
				$itineraire [$it_fr_itineraire [$nomBalise]] = $contentTag;
			} else {
				$itineraire [$it_fr_itineraire [$nomBalise]] = convertToDB ( $contentTag );
			}
		}
	}
}

/**
 * Permet de grer le contenu de la balise pour la recuperation des itineraires
 * 
 * @param unknown $parseur
 *        	le parseur
 * @param unknown $texte
 *        	le texte
 */
function contentTagItineraire($parseur, $texte) {
	global $enable_itineraire;
	global $contentTag;
	if ($enable_itineraire) {
		$contentTag .= $texte;
	}
}

/**
 * Permet de grer lors de l'ouverture de la balise pour la recuperation des sites
 * 
 * @param unknown $parseur
 *        	le parseur
 * @param unknown $nomBalise
 *        	le nom de la balise
 * @param unknown $tableauAttributs
 *        	le tableau d'attribute
 */
function openTagSite($parseur, $nomBalise, $tableauAttributs) {
	global $enable_site;
	global $contentTag;
	if ($nomBalise == strtoupper ( "Sito" )) {
		$enable_site = true;
	} else if ($enable_site) {
		$contentTag = "";
	}
}

/**
 * Permet de grer la fermeture d'une balise pour la recuperation des sites
 * 
 * @param unknown $parseur
 *        	le parseur
 * @param unknown $nomBalise
 *        	le nom de la balise
 */
function closeTagSite($parseur, $nomBalise) {
	global $it_fr_site, $dirImg, $pathRacine, $separatorImageAlbum;
	global $site, $enable_site;
	global $ids_itineraires, $compteur_itineraire;
	global $contentTag;
	global $nbSite;
	if ($nomBalise == strtoupper ( "Itinerario" )) {
		$compteur_itineraire ++;
	} else if ($nomBalise == strtoupper ( "Sito" )) {
		$enable_site = false;
		$site ["id_itineraire"] = $ids_itineraires [$compteur_itineraire];
		$site ["id"] = "";
		if ($site > 1) {
			//print_r ( $site );
			$nbSite ++;
			if (saveDbSite ( $site ) === false) {
				echo "\n\n\n";
				print_r($site);
				echo "\n\n\n";
				die ( "Erreur dans l'enregistrement d'un site dans la base de donnees\n" );
			}
		}
		array_splice ( $site, 0, count ( $site ) );
	} else if ($enable_site) {
		if ($contentTag != "" && isset ( $it_fr_site [$nomBalise] )) {
			if ($it_fr_site [$nomBalise] == "Site_web" || $it_fr_site [$nomBalise] == "Pieces_jointes" || $it_fr_site [$nomBalise] == "Album" || $it_fr_site [$nomBalise] == "Info_supplementaires") {
				$contentTag = preg_replace ( "#^http://#", "", $contentTag );
				$contentTag = "http://" . $contentTag;
				if ($it_fr_site [$nomBalise] == "Album") {
					$albums = explode ( $separatorImageAlbum, $contentTag );
					$contentTag = "";
					foreach ( $albums as $album ) {
						$path_parts = pathinfo($album);
						$imageName = md5($album).".".$path_parts['extension'];
						if (file_exists ( $dirImg . $imageName )) {
							$album = realpath ( $dirImg . $imageName );
							//$album = str_replace ( $pathRacine . "\\", "", $album );
							$album = str_replace($pathRacine, "", $album);
							$album = preg_replace("#^\\\\#", "", $album);
							$album = preg_replace("#^/#", "", $album);
							$album = str_replace ( "\\", "/", $album );
						}
						$contentTag .= $album.";";
					}
					$contentTag = preg_replace ( "#;$#", "", $contentTag );
				}
				$site [$it_fr_site [$nomBalise]] = $contentTag;
			} else {
				$site [$it_fr_site [$nomBalise]] = convertToDB ( $contentTag );
			}	
		} 
	}
}
	
	/**
	 * Permet de grer le contenu de la balise pour la recuperation des sites
	 * @param unknown $parseur le parseur
	 * @param unknown $texte le texte
	 */
	function contentTagSite($parseur, $texte) {
		global $enable_site;
		global $contentTag;	
		if( $enable_site ) {
			$contentTag .= $texte;
		}
	}
	
	alerte("end update atlas");
?>