<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */                                           
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


define('FPDF_FONTPATH','modules/balisteEcmspdf/font/');
require('modules/balisteEcmspdf/lib/fpdf.php');

/*
* Class PDF
* extend DFDF
* 
*/ 
class PDF extends FPDF
{
//Current column
var $col=0;
//Ordinate of column start
var $y0;
var $yImg;
var $x0;
var $templatePath; // template path

/*
* CONTRUCTOR
* @param full template path
* 
*/
function PDF($templatePath){
$this->templatePath=$templatePath;
parent::FPDF('P','mm','A4');
}
/*
* Header
* PDF header, generate pdf header
*/ 
function Header()
{
    //Logo
    //$this->Image($this->templatePath."/images/BalisteCom_Sans_Texte_fb.png",10,8,33);
   
	//Arial bold 15
    //$this->SetFont('Arial','B',8);
    //Move to the right
    //$this->Cell(80);
    //Title
    //$this->Cell(0,0,'ANNUAIRE DES ACTEURS DE L ENVIRONNEMENT DE LA CORSE',0,0,'C');
    //Line break
    $this->Ln(1);
}
/*
* Footer()
* PDF Footer, Generate pdf footer
*/ 
function Footer()
{
    //Page footer
    $this->SetY(-15);
    $this->SetFont('Arial','I',8);
    $this->SetTextColor(128);
    $this->Cell(0,10,'Observatoire de l Environnement de la Corse',0,0,'L');
    $this->Ln(4);
    $this->Cell(0,10,'Annuaire des acteurs '.date("Y"),0,0,'L');
    $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'R');
}

/*
* Unit
* Generate, Unit information part of the pdf document
* 
*/
function printActeur($actid, $nom_acteur, $adresse_acteur, $ville_acteur, $codepostal_acteur, $sigle_acteur, $telephone_acteur, $fax_acteur, $email_acteur, $web_acteur, $nom_president_acteur, $nom_directeur_acteur, $status_acteur, $mission_acteur, $carte_acteur)
{
	
	$this->SetFont('Arial','B',14);
	$this->SetY(12);
	$this->Cell(0,0,strtoupper($nom_acteur),0,0,'C');
	$this->Ln(4);
	$this->SetX(170);
	$this->SetY(20);
	$this->SetFont('Arial','',12);
	$this->Cell(0,0,strtoupper($sigle_acteur),0,0,'R');
	if ($carte_acteur=="") { $carte_acteur="images/annuaire_acteur/carte_corse_ba.jpg"; }
    $posx=20;
    $posxImg=80;
    $posxMission=120;
    //Title
    $this->SetFont('Arial','B',12);
    $this->SetFillColor(0,0,0);
    $this->SetTextColor(255,255,255);
    $this->SetY(25);
    $this->Cell(0,7,'Identit',0,1,'C',1);
    $this->SetTextColor(0,0,0);
     $this->Ln(4);
     $this->yImg=$this->GetY(); 
    //$this->Cell(0,0,"   ",0,0,'LT',1);
    $this->Ln(4);
	$this->SetFont('Arial','',9);
	$this->SetX($posx);
	$this->Cell(0,0,"Statut : $status_acteur",0,1,'L',0);
	$this->y0=$this->GetY(); 
	$this->Ln(8);
	//$this->Image($carte_acteur,20,$this->y0, 30);
	$this->SetX($posx);
	$this->Cell(0,0,"Adresse :",0,0,'L',0);
	$this->Ln(-2);
	$this->SetX($posx+15);
	$this->MultiCell(45,3,"$adresse_acteur",0,'L',0);
	$this->Ln(4);
	$this->SetX($posx+15);
	$this->Cell(0,0,"$ville_acteur $codepostal_acteur",0,1,'L',0);
	$this->Ln(12);
	$this->SetX($posx);
	$this->Cell(0,0,"Tlphone : $telephone_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->SetX($posx);
	$this->Cell(0,0,"Tlcopie : $fax_acteur",0,1,'L',0);
	$this->Ln(8);
	$this->SetX($posx);
	if (trim($email_acteur)!="") $this->Cell(0,0,"Courriel : $email_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->SetX($posx);
	if (trim($web_acteur)!="") $this->Cell(0,0,"Site Internet : $web_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->Ln(4);
	$this->SetY(95);
	$this->SetX($posx);
	$this->SetFont('Arial','BU',9);
	$this->Cell(0,0,"Responsables :",0,1,'L',0);
	if (trim($nom_president_acteur)!=""){
	$this->Ln(4);
	$this->SetX($posx);
	$this->SetFont('Arial','',9);
	$this->Cell(0,0,"Prsident : $nom_president_acteur",0,1,'L',0);
	}
	if (trim($nom_directeur_acteur)!=""){
	$this->Ln(4);
	$this->SetX($posx);
	$this->Cell(0,0,"Directeur : $nom_directeur_acteur",0,1,'L',0);
	}
	$this->SetY(110);
	if (file_exists($carte_acteur)){
	$this->Image($carte_acteur,80,$this->yImg, 30);
	}
	$this->Rect(10,25,190,93);
	$this->Ln(4);
	$this->Ln(4);
	$this->Ln(4);
	$this->Ln(4);
	$this->Ln(4);
	// saut de ligne
    $this->Ln(1);
    //Save ordinate
    //$this->y0=$this->GetY();
}
/*
* role
* Geenrate role information part of the document
* 
*/ 
function printMission($mission_acteur)
{
    //Font
    $this->SetY(34);
    $this->SetX(120);
    $this->SetFont('Arial','B',9);
    $this->Cell(0,0,"MISSIONS",0,1,'C',0);    
	$this->Ln(4);
	$this->SetFont('Arial','',9);
	$this->SetX(120);
	$this->MultiCell(0,4,"$mission_acteur",0,1,'L',0);
	$this->Ln(4); 
	$this->Ln(4);
	$this->Ln(4); 
    
}

/*
* person
* Generate person part of the document
* 
*/ 
function printActiviteDomaine($domaineArray, $activityArray)
{
	$posx=90;
	$this->SetY(110);
	$this->SetDrawColor(0,0,0);
	$this->Ln(4);
	$this->Ln(4); 
	$this->SetFont('Arial','B',9);
	$this->SetFillColor(0,0,0);
    $this->SetTextColor(255,255,255);
    $this->Cell(89,7,"Domaines de comptence",0,1,'C',1);
    $this->y0=$this->GetY();
    $this->SetFont('Arial','',9);
    $this->SetTextColor(0,0,0);
    $this->Ln(4);
    for ($i=0;$i<count($domaineArray);$i++) {
    $this->Cell(10,0," ".$domaineArray[$i],'L',1,'L',0);
    $this->Ln(5);
    }
	$this->Ln(4); 
	$this->Ln(4);
	$this->Ln(4); 

	$this->SetY($this->y0-7);
	$this->SetX($posx);
	$this->SetFont('Arial','B',9);
	$this->SetFillColor(0,0,0);
    $this->SetTextColor(255,255,255);
	$this->Cell(0,7,"Activits",0,1,'C',1);
	$this->SetTextColor(0,0,0);
	$this->Ln(4);
	$this->SetX(120);
	$this->SetFont('Arial','',9);
	for ($i=0;$i<count($activityArray);$i++) {
    $this->SetX(104);
    //$this->Cell(10,0,"".$activityArray[$i],0,1,'L',0);
    $this->MultiCell(90,5,"".$activityArray[$i],0,'L',0);
    //$this->Ln(5);
    }
	$this->Ln(4); 
	$this->Ln(4);
	$this->Ln(4); 
	$this->Rect(10,118,190,110);
	$this->Rect(100,118,100,110);
}
/*
* person
* Generate person part of the document
* 
*/ 
function printContact($contactArray) {

	
	$posx=0;
	$this->SetY(227);
    $this->SetFont('Arial','B',9);
    $this->SetFillColor(0,0,0);
    $this->SetTextColor(255,255,255);
    $this->Cell(0,7,"CONTACTS",0,1,'C',1); 
    $this->SetTextColor(0,0,0);   
	$this->Ln(4);
	$this->SetFont('Arial','',9);
	for ($i=0;$i<count($contactArray);$i++) {
		$this->SetFont('Arial','B',9);
    	$this->Cell(25,0,"".$contactArray[$i]['nom_contact'],0,0,'L',0);
    	$this->Cell(25,0,"".$contactArray[$i]['prenom_contact'],0,0,'L',0);
    	$this->SetFont('Arial','',9);
    	$this->Cell(60,0," ".$contactArray[$i]['domaine_contact'],0,0,'L',0);
    	if ($contactArray[$i]['telephone_contact']!=""){
    	$this->SetFont('zapfdingbats','','20');
    	$this->Cell(5,0,'%',0,0,'L',0);
    	$this->SetFont('Arial','',9);
    	$this->Cell(25,0," ".$contactArray[$i]['telephone_contact'],0,0,'L',0);
    	}
    	if ($contactArray[$i]['email_contact']!=""){
    	$this->SetFont('zapfdingbats','','20');
    	$this->Cell(5,0,')',0,0,'L',0);
    	$this->SetFont('Arial','',9);
    	$this->Cell(40,0," ".$contactArray[$i]['email_contact'],0,1,'L',0);
    	}
    	$this->Ln(4);
    }
    $this->Rect(10,227,190,50);
}
}// End Class
?>