<?php
if (! preg_match ( "#modules.php#i", $_SERVER ['PHP_SELF'] )) {
	die ( "You can't access this file directly..." );
}

$module_name = basename ( dirname ( __FILE__ ) );
// get_lang($module_name);

require_once ("core/becms_mainlib_lib.php");
include_once("core/becms_image_lib.php");
require_once ("modules/" . $module_name . "/system/params.php");
require_once ("modules/" . $module_name . "/system/functions.php");

/**
 * Si la page n'existe pas
 */
function display_menu() {
	echo "Pas accs. Mauvais paramtre";
}

/**
 * Cration du menu theme pour itineraire
 * @param unknown $value la valeur par defaut
 * @param string $extrajs si des evenement son rajoute
 * @return string le menu
 */

/*
 * LE menu n'est plus affich mais il reste fonctionnel 
 * (voir aussi la fonction initMenu de params.js)
 * */
function menuThemeItineraire($value, $extrajs = "") {
	/*global $prefix, $db, $name_table_itineraire, $module_name;
	$query = "select distinct Theme from " . $prefix . $name_table_itineraire;
	$result = $db->sql_query ( $query );
	if ($db->sql_numrows ( $result ) != 0) {
		$mycontent = '<select id="themeItineraire" name="themeItineraire" size="1" ' . $extrajs . ' style="display: none">';
		$mycontent .= '<option value="">Choisissez une valeur</option>';
		while ( list ( $theme ) = $db->sql_fetchrow ( $result ) ) {
			$select = ($value == $theme) ? ' selected="selected"' : "";
			$mycontent .= '<option value="' . $theme . '" ' . $select . '>' . $theme . '</option>';
		}
		$mycontent .= '</select>';
	} else {
		$mycontent = "";
	}*/
	$mycontent = '<input type="hidden" name="themeItineraire" value= "'.$value.'" >';
	return $mycontent;
}

/**
 * Cration du menu circuit pour itineraire
 * @param unknown $value la valeur par defaut
 * @param string $extrajs si des evenement son rajoute
 * @return string le menu
 */
function menuCircuitItineraire($value, $extrajs = "", $theme = "") {
	global $prefix, $db, $name_table_itineraire, $module_name;
	
	$where = "";
	if($theme != "" ) {
		$where .= ($where == "") ? " WHERE " : " AND ";
		//$where .= " Theme='".conditionnertodb(stripslashes($theme))."'";
		$where .= "Theme COLLATE latin1_swedish_ci LIKE '".str_replace("'", "''", $theme)."'";
	}
	
	$query = "select distinct Circuits from " . $prefix . $name_table_itineraire . $where . ";";
	$result = $db->sql_query ( $query );
	if ($db->sql_numrows ( $result ) != 0) {
		$mycontent = '<select id="circuitItineraire" name="circuitItineraire" size="1" ' . $extrajs . '>';
		$mycontent .= '<option value="">Choisissez une valeur</option>';
		while ( list ( $circuit ) = $db->sql_fetchrow ( $result ) ) {
			if( $circuit != "" ) {
				$select = ($value == $circuit) ? ' selected="selected"' : "";
				$mycontent .= '<option value="' . $circuit . '" ' . $select . '>' . $circuit . '</option>';
			}
		}
		$mycontent .= '</select>';
	} else {
		$mycontent = "";
	}
	return $mycontent;
}

/**
 * Pages parmettant d'afficher tous les itineraires sur une Google Maps
 * @param unknown $theme le theme 
 * @param unknown $circuit le circuit
 */
function display_map_symbol_itineraires($theme="") {
	global $module_name, $_headerContent, $currentlang, $Default_Theme;
	global $rep, $expression, $icon_plus_infos;
	global $My_SQL, $vars_mod, $carteAtlas;
	global $withrewriting, $lienFicheItineraire, $lienCourtFicheItineraire;
	global $code_memo_carto;
	require_once ("modules/SimpleCarto/lib/g_params.php");
	
	if( $withrewriting ) {
		$lienItineraire = $lienCourtFicheItineraire;
	} else {
		$lienItineraire = $lienFicheItineraire;
	}
	
	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = $code_memo_carto.'
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/params.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_itineraires.js" charset="UTF-8"></script>
		<script type="text/javascript">
		//<![CDATA[
			//var detruirCookie = false;
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["icon_plus_infos"] = "'.$icon_plus_infos.'";
			options["detruirCookie"] = false;
			options["rewrite"] = '.$withrewriting.'
			options["lienItineraire"] = "'.$lienItineraire.'"
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart(recupParamsItineraires);	
			addToStart(initMenu);
			addToStart("GetMap('.$carteAtlas.', \''.$theme.'\', circuit, recherche)");
			addToStart(recupParamsMap);	
			addToStop(memoParamsMap);
			addToStop(memoParamsItineraires);
			addToStop(GUnload);
		// ]]>
		</script>';

	setHeader ( $_headerContent );

	$stylecrit = '';
	if ($theme == "") {
		$stylecrit = ' style="display: none"';
	}
	
	if ($theme == "") {
		$pictarcheo = 'archeo_archeo.gif';
		$pictculture = 'culture_culture.gif';
		$pictidentite = 'identite_identite.gif';
	}
	else {
		$pictarcheo = ($theme == 'Archeologia') ? 'archeo_archeo.gif' : 'archeo.gif';
		$pictculture = ($theme == 'Cultura del Mare') ? 'culture_culture.gif' : 'culture.gif';
		$pictidentite = ($theme == 'Identita del Territorio') ? 'identite_identite.gif' : 'identite.gif';
	}
	
	$sortie = '
		<div class="atlas">
			<table border="0" cellpadding="0" cellspacing="0" align="center" width="880">
				<tr>
					<td width="430" valign="top" class="casetexte">Percorrendo questo Grande Itinerario, potrete scoprire tutti gli luoghi che sono stati valorizzati nell\'ambito del progetto ACCESSIT.<br />Potete selezionare i percorsi del mapa scegliendo uno dei temi qui sotto. Fate clic su gli punti per aprire la scheda detagliata.</td>
					<td width="20"></td>
					<td width="430" valign="top" class="casetexte">Parcourez ce Grand Itinraire Tyrrhnien qui vous permettra de dcouvrir les lieux mis en valeur au cours du projet ACCESSIT.<br />Vous pouvez slectionner les parcours affichs sur la carte en choississant un des thmes ci-dessous. Cliquez sur les points pour accder  une fiche dtaille.</td>
				</tr>
			</table>
			<h1 id="titre"></h1>
			<div id="commentaire"></div>
			<form method="" action="" onsubmit="reloadsymboles('.$carteAtlas.', this.elements[\'themeItineraire\'].value, this.elements[\'circuitItineraire\'].value, this.elements[\'recherche\'].value);return false;">
			<div class="sepcaseatlas"></div>
			<table border="0" cellpadding="0" cellspacing="0" align="center">
				<tr>
					<td><a href="atlas_theme_Archeologia.htm"><img src="themes/'.$Default_Theme.'/images/'.$pictarcheo.'" border="0" onmouseover="this.src=\'themes/'.$Default_Theme.'/images/archeo_archeo.gif\'" onmouseout="this.src=\'themes/'.$Default_Theme.'/images/'.$pictarcheo.'\'" /></a></td>
					<td width="13"></td>
					<td><a href="atlas_theme_Cultura%20del%20Mare.htm"><img src="themes/'.$Default_Theme.'/images/'.$pictculture.'" border="0" onmouseover="this.src=\'themes/'.$Default_Theme.'/images/culture_culture.gif\'" onmouseout="this.src=\'themes/'.$Default_Theme.'/images/'.$pictculture.'\'" /></a></td>
					<td width="13"></td>
					<td><a href="atlas_theme_Identita%20del%20Territorio.htm"><img src="themes/'.$Default_Theme.'/images/'.$pictidentite.'" border="0" onmouseover="this.src=\'themes/'.$Default_Theme.'/images/identite_identite.gif\'" onmouseout="this.src=\'themes/'.$Default_Theme.'/images/'.$pictidentite.'\'" /></a></td>
				</tr>
			</table>
			<div class="sepcaseatlas"></div>
			
			<table border="0" cellpadding="0" cellspacing="0" align="center"'.$stylecrit.'>
				<tr>
					<td width="291" class="casetexte">Potete migliorare la vostra selezione adesso, sia scegliendo un circuito, sia facendo una ricerca con parola chiave.<br />Vous pouvez maintenant amliorer votre slection, soit en choisissant un circuit, soit en faisant une recherche avec mot-cl.
					'.menuThemeItineraire ( $theme, 'onchange="reloadsymboles('.$carteAtlas.', this.value, this.form.elements[\'circuitItineraire\'].value, this.form.elements[\'recherche\'].value);"' ).'</td>
					<td width="13"></td>
					<td width="291" class="casecrit">Circuito / Circuit :<br />'.menuCircuitItineraire ( $circuit, 'onchange="reloadsymboles('.$carteAtlas.', this.form.elements[\'themeItineraire\'].value, this.value, this.form.elements[\'recherche\'].value);"', $theme ) .'</td>
					<td width="13"></td>
					<td width="291" class="casecrit">Parola chiave / Mot-cl :<br /><input type="text" id="recherche" name="recherche" value="" /><input type="button" value="Go" name="Go" onclick="reloadsymboles('.$carteAtlas.', this.form.elements[\'themeItineraire\'].value, this.form.elements[\'circuitItineraire\'].value, this.form.elements[\'recherche\'].value);" /></td>
				</tr>
			</table>
			<!--<table border="0" cellpadding="0" cellspacing="0" align="center"'.$stylecrit.'>
			<tr><td>
			<p>Thme des itinraires</p>
			</td><td>
			<p>Recherche</p>
			</td><td>
			<p>Circuit des itinraires</p>
			</td></tr>
			<tr><td>
			<p>' . menuThemeItineraire ( $theme, 'onchange="reloadsymboles('.$carteAtlas.', this.value, this.form.elements[\'circuitItineraire\'].value, this.form.elements[\'recherche\'].value);"' ) . '</p>
			</td><td>
			<p><input type="text" id="recherche" name="recherche" value="" /><input type="button" value="Go" name="Go" onclick="reloadsymboles('.$carteAtlas.', this.form.elements[\'themeItineraire\'].value, this.form.elements[\'circuitItineraire\'].value, this.form.elements[\'recherche\'].value);" /></p>
			</td><td>
			<p>' . menuCircuitItineraire ( $circuit, 'onchange="reloadsymboles('.$carteAtlas.', this.form.elements[\'themeItineraire\'].value, this.value, this.form.elements[\'recherche\'].value);"', $theme ) . '</p>
			</td></tr>
			</table>-->
			<p id="message_itineraire"></p>
			<div id="map"></div>
			</form>
			<p>&nbsp;</p>
			<div id="obs"></div>
		</div>
		<div align="center"><img src="themes/'.$Default_Theme.'/images/accessit.jpg"></div>';
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Permet de retourner et d'afficher la carte en fonction du xml
 * @param unknown $theme le theme
 * @param unknown $circuit le circuit
 * @param unknown $rech la recherche
 */
function get_map_pict_XML_itineraires($theme, $circuit, $rech) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_itineraires.php");
	$sortie = getXMLcarto ( $Idc, $theme, $circuit, $rech );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

/**
 * Permet de crer l'album photo a partir d'un lien
 * 
 * @param unknown $url
 *        	le lien
 * @return string l'album
 */
function createAlbum($album) {
	global $module_name, $separatorImageAlbum;
	$album_photos = '<div class="diaporamazoom"><div class="highslide-gallery">';
	$count = 1;
	$urls = explode($separatorImageAlbum, $album);
	foreach ($urls as $url) {
		
		/*
		 * $resizedImg = "modules.php?name=becmsGallery&sop=Resizer&imgfile=$laphoto&max_width=800&max_height=800"; $tumbImg = "modules.php?name=becmsGallery&sop=Resizer&imgfile=$laphoto&max_width=100&max_height=100";
		 */
		/*
		 * modules/'.$module_name.'/resizer_small.php?imgfile=../../'.$laphoto.'&max_width=900&max_height=600
		 * */
		/*
			$resizedImg = $url;
			$tumbImg = $url;
			$album_photos .= '
			<table border="0" cellpadding="0" cellspacing="0" class="diapo">
			<tr><td>
			<a id="thumb' . $count . '" href="' . $resizedImg . '" class="highslide" onclick="return hs.expand(this)"><img src="' . $tumbImg . '" alt="' . $nom . '" title="Click to enlarge" style="max-width: 260px; max-height: 200px;" /></a>
			<div class="highslide-heading">
				' . $nom . '
			</div>';*/
		$resizedImg = $url;
		$tumbImg =  'modules/'.$module_name.'/resizer_small.php?imgfile=../../'.$url.'&max_width=260&max_height=200';
		$album_photos .= '
			<table border="0" cellpadding="0" cellspacing="0" class="diapo">
			<tr><td>
			<a id="thumb' . $count . '" href="' . $resizedImg . '" class="highslide" onclick="return hs.expand(this)"><img src="' . $tumbImg . '" alt="' . $nom . '" title="Click to enlarge" /></a>
			<div class="highslide-heading">
				' . $nom . '
			</div>';
		
		$photo_comments = $credit;
		if ($photo_comments != "") {
			$album_photos .= '
				<div class="highslide-caption">
					' . $photo_comments . '
				</div>';
		}
		$album_photos .= '</td></tr></table>';
		$count ++;
	}
	$album_photos .= '</div></div>';
	return $album_photos;
}

function liste($valeur, $classe="nopuce") {
	$sortie = "";
	if (count($valeur) > 0) {
		$sortie .= "<ul";
		if ($classe != "" ) {
			$sortie .= ' class="'.$classe.'"';
		}
		$sortie .= ">";
		foreach ($valeur as $elt) {
			$sortie .= "<li>".$elt."</li>";
		}
		$sortie .= "</ul>";
	}
	return $sortie;
}

function colonnes($valeurs = array(), $nbcols = 1,$largeur = "", $equicols = false, $senslecture = "v", $classe = "") {
	$nbrevals = count($valeurs);
	if ($nbrevals > 0) {
		$largeurscols = array();
		if ($equicols) { //calcul des largeurs de colonnes si elles doivent tre gales
			$largeurcol = floor(100/$nbcols);
			$total = 0;
			for ($i=0;$i<$nbcols-1;$i++) {
				$largeurscols[] = ' width="'.$largeurcol.'%"';
				$total += $largeurcol;
			}
			$largeurscols[] = $largeurscols[] = ' width="'.(100 - $total).'%"';
		}
		$lignesMax = ceil(count($valeurs)/$nbcols); //nbre de lignes maximal
		$classe = ($classe != "") ? ' class="'.$classe.'"' : "";

		$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"".$classe;
		if ($largeur != "") {
			$sortie .= " width=\"".$largeur."\"";
		}
		$sortie .= ">";
		$contenus = array();
		if ($senslecture == "v") {
			for ($c=0;$c<$nbcols;$c++) {
				$contenus[$c] = '<td'.$largeurscols[$c].'>';
				$contenus[$c] .= liste(array_slice($valeurs,$lignesMax*$c,$lignesMax));
				$contenus[$c] .= '</td>';
			}
		}
		if ($senslecture == "h") {
			for ($c=0;$c<$nbcols;$c++) {
				$cvaleurs = array();
				for ($i=0;$i<$lignesMax;$i++) {
					$indice = $i*$nbcols+$c;
					if (isset($valeurs[$indice])) {
						$cvaleurs[] = $valeurs[$indice];
					}
				}
				$contenus[$c] = '<td'.$largeurscols[$c].'>';
				$contenus[$c] .= liste($cvaleurs);
				$contenus[$c] .= '</td>';
			}
		}
		$sortie .= '<tr>';
		foreach($contenus as $contenu) {
			$sortie .= $contenu;
		}
		$sortie .= '</tr>';
		$sortie .= "</table>";
	}
	else {
		$sortie = "";
	}
	return $sortie;
}

function casefiche($titre, $contenu, $contenugras="") {
	$contenu = trim($contenu);
	if ($contenu == "" && $contenugras == "") {
		return "";
	}
	else {
		if ($titre != "") {
			if ($contenugras == "") {
				return '<div class="sepcaseatlas"></div><div class="caseinfo"><div class="caseinfotitre">'.$titre.'</div><div class="caseinfocontent">'.$contenu.'</div></div>';
			}
			else {
				return '<div class="sepcaseatlas"></div><div class="caseinfo"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td><div class="caseinfotitre">'.$titre.'</div></td><td class="caseinfocontentgras">'.$contenugras.'</td></table><div class="caseinfocontent">'.$contenu.'</div></div>';
			}
		}
		else {
			return '<div class="sepcaseatlas"></div><div class="caseinfo"><div class="caseinfocontent">'.$contenu.'</div></div>';
		}
	}
}

function casefichetab($valeurs) {
	if (!is_array($valeurs)) {
		return "";
	}
	else {
		$contenu = "";
		foreach ($valeurs as $valeur) {
			if ($valeur["contenu"] != "") {
				$contenu .= '<div class="caseinfotitre">'.$valeur["titre"].'</div><div class="caseinfocontent">'.$valeur["contenu"].'</div>';
			}
		}	
		if ($contenu !="") {
			$contenu = '<div class="sepcaseatlas"></div><div class="caseinfo">'.$contenu.'</div>';
		}
		return $contenu;
	}
}

/**
 * Page d'affichage de la description d'un itineraire avec les site associe
 * @param unknown $idItineraire l'id de l'itineraire
 */
function display_map_symbol_fiche_itineraire($idItineraire) {
	global $module_name, $_headerContent, $currentlang, $Default_Theme;
	global $prefix, $db, $name_table_itineraire, $icon_plus_infos;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteAtlas;
	global $withrewriting, $lienFicheSite, $lienCourtFicheSite;
	global $code_memo_carto, $dicotheme;
	require_once ("modules/SimpleCarto/lib/g_params.php");
	
	if( $withrewriting ) {
		$lienSite = $lienCourtFicheSite;
	} else {
		$lienSite = $lienFicheSite;
	}
	
	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = $code_memo_carto.'
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/params.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_fiche_itineraire.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/zoom_gallery/highslide/highslide-with-gallery.js"></script>
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/highslide/highslide.css" />
		<!--<link rel="stylesheet" href="themes/' . $Default_Theme . '/style/becmsGallery.css" type="text/css">-->
		<script type="text/javascript">
			hs.lang = { 
			   loadingText :     \'Chargement...\', 
			   loadingTitle :    \'Cliquer pour annuler\', 
			   focusTitle :      \'Cliquer pour amener au premier plan\', 
			   fullExpandTitle : \'Afficher en taille relle\', 
			   fullExpandText :  \'Taille relle\', 
			   creditsText :     \'Dvelopp sur <i>Highslide JS</i>\', 
			   creditsTitle :    \'Site Web de Highslide JS\', 
			   previousText :    \'Prcdent\', 
			   previousTitle :   \'Prcdent (flche gauche)\', 
			   nextText :        \'Suivant\', 
			   nextTitle :       \'Suivant (flche droite)\', 
			   moveTitle :       \'Dplacer\', 
			   moveText :        \'Dplacer\', 
			   closeText :       \'Fermer\', 
			   closeTitle :      \'Fermer (esc ou Echap)\', 
			   resizeTitle :     \'Redimensionner\', 
			   playText :        \'Lancer\', 
			   playTitle :       \'Lancer le diaporama (barre d\\\'espace)\', 
			   pauseText :       \'Pause\', 
			   pauseTitle :      \'Suspendre le diaporama (barre d\\\'espace)\', 
			   restoreTitle :    \'Cliquer pour fermer l\\\'image, cliquer et faire glisser pour dplacer, utiliser les touches flches droite et gauche pour suivant et prcdent.\' 
			};
			hs.graphicsDir = \'modules/becmsGallery/type/zoom_gallery/highslide/graphics/\';
			hs.align = \'center\';
			hs.transitions = [\'expand\', \'crossfade\'];
			hs.outlineType = \'rounded-white\';
			hs.wrapperClassName = \'controls-in-heading\';
			hs.fadeInOut = true;
			//hs.numberPosition = \'caption\';
			hs.dimmingOpacity = 0.5;
			hs.showCredits = false;
			// Add the controlbar
			if (hs.addSlideshow) hs.addSlideshow({
				//slideshowGroup: \'group1\',
				interval: 5000,
				repeat: false,
				useControls: true,
				fixedControls: false,
				overlayOptions: {
					opacity: 1,
					position: \'top right\',
					hideOnMouseOut: false
				}
			});
		</script>
		<script type="text/javascript">
		//<![CDATA[
			//var detruirCookie = false;
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["icon_plus_infos"] = "'.$icon_plus_infos.'";
			options["detruirCookie"] = false;
			options["rewrite"] = '.$withrewriting.'
			options["lienSite"] = "'.$lienSite.'"
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart(setParamsCookiesItineraire);
			addToStart("GetMap('.$carteAtlas.', '.$idItineraire.')");	
			addToStop(GUnload);
		// ]]>
		</script>';
	setHeader ( $_headerContent );
	
	$sortie = "";
	
	// Lecture de la table itineraire et recuperation des infos le concernent
	$sql = "SELECT * FROM `" . $prefix . $name_table_itineraire . "` WHERE `id`=" . $idItineraire;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );
		
		$desc = nl2br(trim($donnees ['Description']));
		$nom = $donnees ['Nom_itineraire'];
		$circuit = (isset($dicotheme[$donnees['Circuits']])) ? $dicotheme[$donnees ['Circuits']] : $donnees ['Circuits'];
		$theme = (isset($dicotheme[$donnees['Theme']])) ? $dicotheme[$donnees ['Theme']] : $donnees ['Theme'];
		$commune = $donnees ['Commune'];
		$tel = $donnees ['Telephone'];
		$messagerie = $donnees ['Messagerie'];
		$siteWeb = $donnees ['Site_web'];
		$caract = nl2br(trim($donnees ['Caracteristique_itineraire']));
		$services = nl2br(trim($donnees ['Services']));
		$activ_event = nl2br(trim($donnees ['Activite_event_territoire']));
		$pieceJointe = $donnees ['Pieces_jointes'];
		$album = $donnees ['Album'];
		$infosSupplement = $donnees['Infos_supplementaires'];
		$autresInfos = nl2br(trim($donnees['Autres_infos']));
		
		$classstyle = "";
		if ($theme != "") {
			if (preg_match("#^Archeologia#", $theme)) $classstyle="archeo";
			if (preg_match("#^Identit#", $theme)) $classstyle="identite";
			if (preg_match("#^Cultura#", $theme)) $classstyle="culture";
		} 
		
		if ($desc != "") {
			$desc = casefiche('Descrizione /<br />Description : ', $desc);
		} else {
			$desc = "";
		}
		
		$infolieu = "";
		if ($commune != "" || $services != "") {
			$infolieu .= '<div class="sepcaseatlas"></div>';
			$infolieu .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$infolieu .= ($commune != "") ? '<tr><td class="caseinfotitre" valign="top">Comuni / Commune : </td><td class="caseinfocontent2">'.$commune.'</td></tr>' : '';
			$infolieu .= ($services != "") ? '<tr><td class="caseinfotitre" valign="top">Servizi / Services :</td><td class="caseinfocontent2">'.$services.'</td></tr>' : '';
			$infolieu .= '</table>';
		}
		
		$coords = "";
		if ($siteWeb != "" || $messagerie != "" || $tel != "") {
			$coords .= '<div class="sepcaseatlas"></div>';
			$coords .= '<table border="0" cellpadding="0" cellspacing= "0" width="244" >';
			//$coords .= ($siteWeb != "" || $messagerie != "") ? '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'.gif">' : '';
			$coords .= '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'.gif">';
			$coords .= ($siteWeb != "") ? '<a href="' . $siteWeb . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/webatlas.png" border="0">'.'</a>' :'';
			$coords .= ($siteWeb != "" && $messagerie != "") ? '<span style="width: 50px; display: inline-block;"></span>' : '';
			$coords .= ($messagerie != "") ? '<a href="mailto:' . $messagerie . '">'.'<img src="themes/'.$Default_Theme.'/images/mailatlas.png" border="0">'.'</a>' :'';
			//$coords .= ($siteWeb != "" || $messagerie != "") ? '</td></tr>' : '';
			$coords .=  '</td></tr>';
			//$coords .= (($siteWeb != "" || $messagerie != "") && $tel != "") ? '<tr><td height="18"></td></tr>' : '';
			$coords .= ($tel != "") ? '<tr><td height="18"></td></tr>' : '';
			$coords .= ($tel != "") ? '<tr><td align="center"><table border="0" cellpaddind="0" cellspacing="0"><tr><td><img src="themes/'.$Default_Theme.'/images/tel'.$classstyle.'.gif"></td><td width="10"></td><td class="caseinfocontent">'.$tel.'</td></tr></table></td></tr>' : '';
			$coords .= '</table>';
		}
		else {
			$coords .= '<div class="sepcaseatlas"></div>';
			$coords .= '<table border="0" cellpadding="0" cellspacing= "0" width="244" >';
			$coords .= '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'.gif">';
			$coords .= '&nbsp;';
			$coords .= '</td></tr>';
			$coords .= '</table>';
		}
		
		if ($caract != "") {
			$caract = casefiche('Caratteristiche dell\'intinerario /<br />Caractristiques de l\'itinraire : ', $caract);
		} else {
			$caract = "";
		}
		if ($desc == "" && $caract != "") {
			$desc = $caract;
			$caract = "";
		} 
		
		if ($activ_event != "") {
			$activ_event = casefiche('Attivit ed eventi sul territorio /<br />Activits sur le territoire : ', $activ_event);
		} else {
			$activ_event = "";
		}
		
		if( $autresInfos != "" ) {
			$autresInfos = casefiche('Altre informazioni  /<br />Autres informations : ', $autresInfos);
		} else {
			$autresInfos = "";
		}

		$infopluspj = "";
		if ($infosSupplement != "" || $pieceJointe != "") {
			$infopluspj .= '<div class="sepcaseatlas"></div>';
			$infopluspj .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$infopluspj .= ($infosSupplement != "") ? '<tr><td class="caseinfotitre">Ulteriori materiali  / Informations supplmentaires : </td><td class="caseinfocontent2">'.'<a href="' . $infosSupplement . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= ($pieceJointe != "") ? '<tr><td class="caseinfotitre">Allegati Itinerario / Pices jointes :</td><td class="caseinfocontent2">'.'<a href="' . $pieceJointe . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= '</table>';
		}
		
		if ($album != "") {
			$album = createAlbum ( $album );
		} else {
			$album = "";
		}
		
		$sortie .= '
		<div class="atlas"><div class="'.$classstyle.'">
		<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td valign="top"><h1 id="titre">'.$nom /*strtoupper($nom)*/.'</h1></td><td width="15"></td><td valign="top" align="right"><table border="0" cellpadding="0" cellspacing="0"><tr><td nowrap="nowrap" align="right"><h1 class="theme">'.$theme.'</h1></td></tr>'.(($circuit != "") ? '<tr><td align="right"><h2 class="circuit">'.$circuit.'</h2></td></tr>' : '').'</table></td></tr></table>
		<div id="commentaire"></div>
		<div class="sepcaseatlas"></div>
		<div id="map"></div>
		<table border="0" cellpadding="0" cellspacing="0" width=880 align="center">
		<tr>
		<td width="608" height="1"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="608"></td>
		<td width="28"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="28"></td>
		<td width="244"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="244"></td>
		</tr>
		<tr>
		<td colspan="3">'.$desc.'</td>
		</tr>
		<tr>
		<td width="608" valign="top">'.$infolieu.$caract.$activ_event.$infopluspj.'</td>
		<td width="28">&nbsp;</td>
		<td width="244"  valign="top">'.$coords.$autresInfos.'</td>
		</tr>
		</table>
		' . $album . '
		</div></div>
		';
	}
	else {
		$sortie = "<p>Erreur : pas de fiche correspondante</p>";
	}
	
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
	                  // "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top" 
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Retourne et affiche la carte des sites en fonction de l'id d'un itineraire
 * @param unknown $idItineraire l'id de l'itineraire
 */
function get_map_pict_XML_fiche_itineraire($idItineraire) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_fiche_itineraire.php");
	$sortie = getXMLcarto ( $Idc, $idItineraire );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

/**
 * Page permettant d'afficher la description d'un site
 * @param unknown $idSite l'id du site
 */
function display_map_symbol_fiche_site($idSite) {
	global $module_name, $_headerContent, $currentlang, $Default_Theme;
	global $prefix, $db, $name_table_site;
	global $fr_boolean_site_access_physique, $fr_boolean_site_access_culture, $fr_boolean_site_access_virtuelle, $fr_boolean_site_infos_generales;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $miniCarteAtlas;
	global $code_memo_carto, $dicotheme;
	require_once ("modules/SimpleCarto/lib/g_params.php");
	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = $code_memo_carto.'
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_fiche_site.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/params.js"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/zoom_gallery/highslide/highslide-with-gallery.js"></script>
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/highslide/highslide.css" />
		<!--<link rel="stylesheet" href="themes/' . $Default_Theme . '/style/becmsGallery.css" type="text/css">-->
		<script type="text/javascript">
			hs.lang = { 
			   loadingText :     \'Chargement...\', 
			   loadingTitle :    \'Cliquer pour annuler\', 
			   focusTitle :      \'Cliquer pour amener au premier plan\', 
			   fullExpandTitle : \'Afficher en taille relle\', 
			   fullExpandText :  \'Taille relle\', 
			   creditsText :     \'Dvelopp sur <i>Highslide JS</i>\', 
			   creditsTitle :    \'Site Web de Highslide JS\', 
			   previousText :    \'Prcdent\', 
			   previousTitle :   \'Prcdent (flche gauche)\', 
			   nextText :        \'Suivant\', 
			   nextTitle :       \'Suivant (flche droite)\', 
			   moveTitle :       \'Dplacer\', 
			   moveText :        \'Dplacer\', 
			   closeText :       \'Fermer\', 
			   closeTitle :      \'Fermer (esc ou Echap)\', 
			   resizeTitle :     \'Redimensionner\', 
			   playText :        \'Lancer\', 
			   playTitle :       \'Lancer le diaporama (barre d\\\'espace)\', 
			   pauseText :       \'Pause\', 
			   pauseTitle :      \'Suspendre le diaporama (barre d\\\'espace)\', 
			   restoreTitle :    \'Cliquer pour fermer l\\\'image, cliquer et faire glisser pour dplacer, utiliser les touches flches droite et gauche pour suivant et prcdent.\' 
			};
			hs.graphicsDir = \'modules/becmsGallery/type/zoom_gallery/highslide/graphics/\';
			hs.align = \'center\';
			hs.transitions = [\'expand\', \'crossfade\'];
			hs.outlineType = \'rounded-white\';
			hs.wrapperClassName = \'controls-in-heading\';
			hs.fadeInOut = true;
			//hs.numberPosition = \'caption\';
			hs.dimmingOpacity = 0.5;
			hs.showCredits = false;
			// Add the controlbar
			if (hs.addSlideshow) hs.addSlideshow({
				//slideshowGroup: \'group1\',
				interval: 5000,
				repeat: false,
				useControls: true,
				fixedControls: false,
				overlayOptions: {
					opacity: 1,
					position: \'top right\',
					hideOnMouseOut: false
				}
			});
		</script>
		<script type="text/javascript">
		//<![CDATA[
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart("GetMap('.$miniCarteAtlas.', '.$idSite.')");
			addToStop(GUnload);
		// ]]>
		</script>';
	setHeader ( $_headerContent );
	
	// Lecture et recuperation des infos concernent le site
	$sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE `id`=". $idSite;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );
		$nom = $donnees['Nom'];
		$circuits = (isset($dicotheme[$donnees['Circuits']])) ? $dicotheme[$donnees ['Circuits']] : $donnees ['Circuits'];
		$theme = (isset($dicotheme[$donnees['Theme']])) ? $dicotheme[$donnees ['Theme']] : $donnees ['Theme'];
		$categorie = $donnees['Categorie'];
		$commune = $donnees['Commune'];
		$localite = $donnees['Localite'];
		$latitude = $donnees['Latitude'];
		$longitude = $donnees['Longitude'];
		$adresse = nl2br(trim($donnees['Adresse']));
		$horairesOuverture = nl2br(trim($donnees['Horaires_ouverture']));
		$entree = nl2br(trim($donnees['Entree']));
		$tel = $donnees['Telephone'];
		$siteWeb = $donnees['Site_web'];
		$services = nl2br(trim($donnees['Services']));
		$servicesSpe = nl2br(trim($donnees['Services_specifiques']));
		$album = $donnees['Album'];
		$piecesJointes = $donnees['Pieces_jointes'];
		$desc = nl2br(trim($donnees['Description']));
		$infosSupplement = $donnees['Info_supplementaires'];
		$activiteEvent = $donnees['Activite_event'];
		$divers = $donnees['Divers'];
		$autresInfos = nl2br(trim($donnees['Altre_informazioni_e_progetti_collegati']));
		$noteAccessibilite = nl2br(trim($donnees['Note_accessibilita']));
		$siteAccessit = $donnees['Site_accessit'];
		
		$messagerie = "";
		
		
		$arrayAccessPhysique = array();
		foreach ($fr_boolean_site_access_physique as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessPhysique[$champ] = $arrayAccess;
			}
		}

		$arrayAccessCulture = array();
		foreach ($fr_boolean_site_access_culture as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessCulture[$champ] = $arrayAccess;
			}
		}
		
		$arrayAccessVirtuelle = array();
		foreach ($fr_boolean_site_access_virtuelle as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessVirtuelle[$champ] = $arrayAccess;
			}
		}

		
		
		
		
		$classstyle = "";
		if ($theme != "") {
			if (preg_match("#^Archeologia#", $theme)) $classstyle="archeo";
			if (preg_match("#^Identit#", $theme)) $classstyle="identite";
			if (preg_match("#^Cultura#", $theme)) $classstyle="culture";
		}
		$classstylecase = ($classstyle == "") ? "rien" : $classstyle;
		
		if ($desc != "") {
			$desc = casefiche('Descrizione /<br />Description : ', $desc);
		} else {
			$desc = "";
		}
		
		$infocat = "";
		if ($categorie) {
			$infocat .= '<div class="sepcaseatlas"></div>';
			$infocat .= '<div class="sepcaseatlas"></div>';
			$infocat .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$infocat .= ($categorie != "") ? '<tr><td class="caseinfotitre" valign="top">Categorie / Catgorie : </td><td class="caseinfocontent2"><b>'.$categorie.'</b></td></tr>' : '';
			$infocat .= '</table>';
		}
		
		$infolieu = "";
		if ($commune != "" || $localite != "" || $latitude != "" || $longitude != "") {
			$infolieu .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$infolieu .= ($commune != "") ? '<tr><td class="caseinfotitre" valign="top">Comuni / Commune : </td><td class="caseinfocontent2"><b>'.$commune.'</b></td></tr>' : '';
			$infolieu .= ($localite != "") ? '<tr><td class="caseinfotitre" valign="top">Localit / Localit :</td><td class="caseinfocontent2"><b>'.$localite.'</b></td></tr>' : '';
			$infolieu .= ($latitude != "") ? '<tr><td class="caseinfotitre" valign="top">Latitudine / Latitude :</td><td class="caseinfocontent2"><b>'.$latitude.'</b></td></tr>' : '';
			$infolieu .= ($longitude != "") ? '<tr><td class="caseinfotitre" valign="top">Longitudine / Longitude :</td><td class="caseinfocontent2"><b>'.$longitude.'</b></td></tr>' : '';
			$infolieu .= '</table>';
			$infolieu = casefiche("", $infolieu);
		}
		
		$servs = "";
		if ($services != "" || $servicesSpe != "") {
			$servs = casefiche('Servizi&nbsp;/<br />Services&nbsp;: ', $servicesSpe, $services);
		} 
		else {
			$servs = "";
		}
		
		if ($activiteEvent != "") {
			$activiteEvent = casefiche('Attivit e eventi sul territorio /<br>Activits sur le territoire : ', $activiteEvent);
		} 
		else {
			$activiteEvent = "";
		}
		
		if( $autresInfos != "" ) {
			$autresInfos = casefiche('Altre informazioni e progetti collegati /<br />Autres informations et projets : ', $autresInfos);
		} 
		else {
			$autresInfos = "";
		}
		
		$infopluspj = "";
		if ($siteAccessit != "" || $infosSupplement != "" || $pieceJointe != "") {
			$infopluspj .= '<div class="sepcaseatlas"></div>';
			$infopluspj .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$siteAccessit = ($siteAccessit != "") ? $fr_boolean_site_infos_generales["Site_accessit"]["label_french"][$siteAccessit] . " / " . $fr_boolean_site_infos_generales["Site_accessit"]["label_italian"][$siteAccessit] : "";
			$infopluspj .= ($siteAccessit != "") ? '<tr><td class="caseinfotitre" valign="top">Appartenenza Accessit / Inclus dans le projet Accessit : </td><td class="caseinfocontent2">'.$siteAccessit.'</td></tr>' : '';
			$infopluspj .= ($infosSupplement != "") ? '<tr><td class="caseinfotitre">Ulteriori materiali  / Informations supplmentaires : </td><td class="caseinfocontent2">'.'<a href="' . $infosSupplement . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= ($pieceJointe != "") ? '<tr><td class="caseinfotitre">Allegati Itinerario / Pices jointes :</td><td class="caseinfocontent2">'.'<a href="' . $pieceJointe . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= ($divers != "") ? '<tr><td class="caseinfotitre">Diverso / Divers :</td><td class="caseinfocontent2">'.'<a href="' . $divers . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= '</table>';
		}
		
		$adhorent = "";
		if ($adresse != "" || $horairesOuverture != "" || $entree != "") {
			$adhorent = casefichetab(array(
						array("titre"=>"Indirizzo  /<br />Adresse : " ,"contenu"=>'<div align="center"><i>'.$adresse."</i></div>"),
						array("titre"=>"Orario di apertura  /<br/>Horaires d'ouverture :" ,"contenu"=>$horairesOuverture),
						array("titre"=>"Ingresso /<br />Entre :" ,"contenu"=>$entree)
			));
		}		
		
		$coords = "";
		if ($siteWeb != "" || $messagerie != "" || $tel != "") {
			$coords .= '<div class="sepcaseatlas"></div>';
			$coords .= '<table border="0" cellpadding="0" cellspacing= "0" width="302" >';
			$coords .= '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'2.gif">';
			$coords .= ($siteWeb != "") ? '<a href="' . $siteWeb . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/webatlas.png" border="0">'.'</a>' :'';
			$coords .= ($siteWeb != "" && $messagerie != "") ? '<span style="width: 50px; display: inline-block;"></span>' : '';
			$coords .= ($messagerie != "") ? '<a href="mailto:' . $messagerie . '">'.'<img src="themes/'.$Default_Theme.'/images/mailatlas.png" border="0">'.'</a>' :'';
			$coords .= '</td></tr>';
			$coords .= ($tel != "") ? '<tr><td height="18"></td></tr>' : '';
			$coords .= ($tel != "") ? '<tr><td align="center"><table border="0" cellpaddind="0" cellspacing="0"><tr><td><img src="themes/'.$Default_Theme.'/images/tel'.$classstyle.'.gif"></td><td width="10"></td><td class="caseinfocontent">'.$tel.'</td></tr></table></td></tr>' : '';
			$coords .= '</table>';
		}
		/*else {
			$coords .= '<div class="sepcaseatlas"></div>';
			$coords .= '<table border="0" cellpadding="0" cellspacing= "0" width="302" >';
			$coords .= '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'2.gif">';
			$coords .= '&nbsp;';
			$coords .= '</td></tr>';
			$coords .= '</table>';
		}*/
		
		$htmlPicto1 = "";
		$accessPhy = array();
		foreach ($arrayAccessPhysique as $champ => $arrayAccess) {
			if( file_exists($arrayAccess["picto"]) ) {
				$htmlPicto1 .= '<img src="'.$arrayAccess["picto"].'" width="20" alt="'.$arrayAccess["label_".$currentlang].'" /> ';
			} else {
				$accessPhy[] = $arrayAccess["label_french"] . " / " . $arrayAccess["label_italian"];
			}
		}
		
		if( $htmlPicto1 != "" || count($accessPhy) > 0 ) {
			$htmlPicto1 = "<p>Accessibilit physique : ".$htmlPicto1."</p>";
		}
		
		$htmlPicto2 = "";
		$accessCult = array();
		foreach ($arrayAccessCulture as $champ => $arrayAccess) {
			if( file_exists($arrayAccess["picto"]) ) {
				$htmlPicto2 .= '<img src="'.$arrayAccess["picto"].'" width="20" alt="'.$arrayAccess["label_".$currentlang].'" /> ';
			} else {
				$accessCult[] = $arrayAccess["label_french"] . " / " . $arrayAccess["label_italian"];
			}
		}
		
		if( $htmlPicto2 != "" || count($accessCult) > 0 ) {
			$htmlPicto2 = "<p>Accessibilit culturelle : ".$htmlPicto2."</p>";
		}
		
		$htmlPicto3 = "";
		$accessVirtu = array();
		foreach ($arrayAccessVirtuelle as $champ => $arrayAccess) {
			if( file_exists($arrayAccess["picto"]) ) {
				$htmlPicto3 .= '<img src="'.$arrayAccess["picto"].'" width="20" alt="'.$arrayAccess["label_".$currentlang].'" /> ';
			} else {
				$accessVirtu[] = $arrayAccess["label_french"] . " / " . $arrayAccess["label_italian"];
			}
		}
		
		if( $htmlPicto3 != "" || count($accessVirtu) > 0 ) {
			$htmlPicto3 = "<p>Accessibilit virtuelle : ".$htmlPicto3."</p>";
		}
		 /* htmlPicto pas utilis pour l'instant */
		$accessibilite = "";
		if (count($accessPhy) > 0) {
			$accessibilite.= ($accessibilite != "") ? '<td width="20"></td>' : '';
			$accessibilite .= '<td valign="top">'.'<div class="caseinfotitre2">Accessibilit Fisica /<br />Accessibilit Physique : </div>'.liste($accessPhy,"caseacces").'</td>';
		}
		if (count($accessCult) > 0) {
			$accessibilite.= ($accessibilite != "") ? '<td width="20"></td>' : '';
			$accessibilite .= '<td valign="top">'.'<div class="caseinfotitre2">Accessibilit Culturale /<br />Accessibilit Culturelle : </div>'.liste($accessCult,"caseacces").'</td>';
		}
		if (count($accessVirtu) > 0) {
			$accessibilite.= ($accessibilite != "") ? '<td width="20"></td>' : '';
			$accessibilite .= '<td valign="top">'.'<div class="caseinfotitre2">Accessibilit Virtuale /<br />Accessibilit Virtuelle : </div>'.liste($accessVirtu,"caseacces").'</td>';
		}
		$accessibilite = '<div class="sepcaseatlas"></div><table border="0" cellpadding="0" cellspacing="0" width="880" align="center"><tr>'.$accessibilite.'</tr></table>';
		
		$noteaccess = "";
		if ($noteAccessibilite != "") {
			$noteaccess .= '<div class="sepcaseatlas"></div>';
			$noteaccess .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$noteaccess .= ($noteAccessibilite != "") ? '<tr><td class="caseinfotitre" valign="top">Note accessibilit /<br />Autres informations sur l\'accessibilit : </td><td class="caseinfocontent2">'.$noteAccessibilite.'</td></tr>' : '';
			$noteaccess .= '</table>';
		}
		

		if( $album != "" ) {
			$album = createAlbum ( $album );
		} 
		else {
			$album = "";
		}
	}
	
	/*$sortie = '
		<div class="atlas">
			<h1 id="titre"></h1>
			<div id="commentaire"></div>
			<table border="0" cellpadding="0" cellspacing="0">
			<tr><td align="center" valign="top">
			<div class="desc_itineraire">
				' .$nom .$desc .$theme .$circuits .$commune .$tel 
				.$siteWeb .$services .$infosSupplement .$noteAccessibilite
				.$autresInfos .$categorie .$adresse .$horairesOuverture .$entree 
				.$servicesSpe .$piecesJointes .$activiteEvent .$divers .$siteAccessit
				.$htmlPicto1 .colonnes($accessPhy, 2, "700", true, "v", "picto")
				.$htmlPicto2 .colonnes($accessCult, 2, "700", true, "v", "picto")
				.$htmlPicto3 .colonnes($accessVirtu, 2, "700", true, "v", "picto")
				.'</div>
			</td></tr>
			<tr><td valign="top">
			<div id="mini_map"></div>
			</td><td width="20"></td><td valign="top">
			<div id="leg"></div>
			</td></tr></table>
			<p>&nbsp;</p>
			<div id="obs"></div>
			<div class="desc_itineraire">
				' . $album . '
			</div>
		</div>';*/
	
	$sortie .= '
	<div class="atlas"><div class="'.$classstylecase.'">
	<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td valign="top"><h1 id="titre">'.$nom /*strtoupper($nom)*/.'</h1></td><td width="15"></td><td valign="top" align="right"><table border="0" cellpadding="0" cellspacing="0"><tr><td nowrap="nowrap" align="right"><h1 class="theme">'.$theme.'</h1></td></tr>'.(($circuits != "") ? '<tr><td align="right"><h2 class="circuit">'.$circuits.'</h2></td></tr>' : '').'</table></td></tr></table>
	<div id="commentaire"></div>
	<table border="0" cellpadding="0" cellspacing="0" width=880 align="center">
	<tr>
	<td width="550" height="1"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="550"></td>
	<td width="28"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="28"></td>
	<td width="302"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="302"></td>
	</tr>
	<tr>
	<td colspan="3">'.$desc.'</td>
	</tr>
	<tr>
	<td width="608" valign="top">'.$infocat.$infolieu.$servs.$activiteEvent.$autresInfos.$infopluspj.'</td>
	<td width="28">&nbsp;</td>
	<td width="244"  valign="top"><div class="sepcaseatlas"></div><div id="mini_map"></div>'.$adhorent.$coords.'</td>
	</tr>
	</table>
	'.$accessibilite.'
	'.$noteaccess.'
	'.$album .'
	</div></div>
	';
	
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Permet d'afficher la carte en fonction du xml et de l'id du site choisi
 * @param unknown $idSite l'id du site
 */
function get_map_pict_XML_fiche_site($idSite) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_fiche_site.php");
	$sortie = getXMLcarto ( $Idc, $idSite );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

$code_memo_carto = '
		<script type="text/javascript">
			if( typeof(options) != "undefined" && typeof(options["detruirCookie"]) == "undefined" ) {
				if( \'function\' == typeof(setCookie) ){
					setCookie("activeParam", "false");
				}
			}
		</script>';





function get_kml() {
	global $prefix, $db, $uploadFolder;
	
	$dir_docs_pdf = $uploadFolder."/../cbnc_3D/";
	
	header ( "Content-Type: text/xml; charset=UTF-8" );
	//header('Content-type: application/vnd.google-earth.kml+xml');
	echo '<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xsi:schemaLocation="http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd http://www.google.com/kml/ext/2.2 http://code.google.com/apis/kml/schema/kml22gx.xsd">
<Document id="CBNC3D">
  <name>CBNC3D</name>
  <Camera>
	<longitude>8.885291655229542</longitude>
	<latitude>42.374383359824904</latitude>
	<altitude>23124.236158860764</altitude>
	<heading>4.6070186443307275</heading>
	<tilt>37.53844474669251</tilt>
  </Camera>
  <Snippet></Snippet>
  <Folder id="FeatureLayer0">
    <name>Balagne</name>
    <Snippet></Snippet>
    ';
	// recherche des series
	$where = "";
	
	/**************************
	 * A supprimer en production !  Ce n'est l que pour limiter les dgats en dveloppement !
	 **************************/
	$limit = " LIMIT 0,100";
	$sql = "SELECT id_fiche, nom, nom_serie, statut_natura, commune, formation_vegetale, geometrie, pdf_a, pdf_b, id_style FROM ".$prefix."_cbnc_serie_vegetation".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$statut_natura = "";
			if ($ligne["statut_natura"] != "") {
				$statut_natura = '<tr><td class="label" valign="top">Natura 2000 : </td><td valign="top">'.$ligne["statut_natura"].'</td></tr>';
			}
			$commune = "";
			if ($ligne["commune"] != "") {
				$commune = '<tr><td class="label" valign="top">Commune : </td><td valign="top">'.$ligne["commune"].'</td></tr>';
			}
			$pdf_a = "";
			if ($ligne["pdf_a"] != "") {
				$fichiers = explode(",", $ligne["pdf_a"]);
				foreach ($fichiers as $fichier) {
					$pdf_a = '<tr><td class="label" valign="top">Plus d\'infos : </td><td valign="top"><a href="'.$dir_docs_pdf.$fichier.'" target="_blank">Cliquez ici</a></td></tr>';
				}
			}
			$pdf_b = "";
			if ($ligne["pdf_b"] != "") {
				$fichiers = explode(",", $ligne["pdf_b"]);
				foreach ($fichiers as $fichier) {
					$pdf_b = '<tr><td class="label" valign="top">Plus d\'infos : </td><td valign="top"><a href="'.$dir_docs_pdf.$fichier.'" target="_blank">Cliquez ici</a></td></tr>';
				}
			}
			$laserie = '<Placemark id="'.$ligne["id_fiche"].'">
      <name>'.$ligne["nom"].'</name>
      <Snippet></Snippet>
      <description><![CDATA[<html xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
<head>
<META http-equiv="Content-Type" content="text/html">
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
</head>
<body style="margin:0px 0px 0px 0px;overflow:auto;background:#FFFFFF;">
<table border="0" cellpadding="0" cellspacing="0">
<tr><td colspan="2" class="titre">'.$ligne["nom_serie"].'</td></tr>
<tr><td colspan="2" >'.$ligne["formation_vegetale"].'</td></tr>
'.$statut_natura.'
'.$commune.'
'.$pdf_a.'
'.$pdf_b.'
</table>
</body>

</html>
]]></description>
      <styleUrl>#'.$ligne["id_style"].'</styleUrl>
      <MultiGeometry>
       '.$ligne["geometrie"].'
      </MultiGeometry>
    </Placemark>';
			echo $laserie;
		}
	}
	
	echo  '</Folder>
	';
	// recherche des styles
	$sql = "SELECT id_style, content FROM ".$prefix."_cbnc_serie_vegetation_styles;";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes2");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$lestyle = '<Style id="'.$ligne["id_style"].'">
    '.$ligne["content"].'
  </Style>';
			echo $lestyle;
		}
	}
	
	echo '</Document>
</kml>';
}

function get_kmz($opacite=1, $serie="", $commune="") {
	global $prefix, $db, $uploadFolder;
	
	/*print_r($_SERVER);
	die($serie."**********".$commune);*/
	
	$dir_docs_pdf = $uploadFolder."/../cbnc_3D/";
	
	$dir_docs_zip = $uploadFolder."/../";
	
	$nom_fichier_source = $dir_docs_zip.md5(date("YmdHis").rand(0, 1000)).".kml";
	$fichier_source = fopen($nom_fichier_source, "w");
	
	fwrite($fichier_source, '<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xsi:schemaLocation="http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd http://www.google.com/kml/ext/2.2 http://code.google.com/apis/kml/schema/kml22gx.xsd">
<Document id="CBNC3D">
  <name>CBNC3D</name>
  <Camera>
	<longitude>8.885291655229542</longitude>
	<latitude>42.374383359824904</latitude>
	<altitude>23124.236158860764</altitude>
	<heading>4.6070186443307275</heading>
	<tilt>37.53844474669251</tilt>
  </Camera>
  <Snippet></Snippet>
  <Folder id="FeatureLayer0">
    <name>Balagne</name>
    <Snippet></Snippet>
    ');
	
	
	
	// recherche des series
	$where = "";
	
	$commune = stripslashes($commune);
	if ($commune != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "commune='".conditionnertodb($commune)."'";
	}
	$serie = stripslashes($serie);
	if ($serie != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "nom_serie='".conditionnertodb($serie)."'";
	}
	
	
	/**************************
	 * A supprimer en production !  Ce n'est l que pour limiter les dgats en dveloppement !
	 **************************/
	//$limit = " LIMIT 0,100";
	
	$sql = "SELECT id_fiche, nom, nom_serie, statut_natura, commune, formation_vegetale,geometrie, pdf_a, pdf_b, id_style FROM ".$prefix."_cbnc_serie_vegetation".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$statut_natura = "";
			if ($ligne["statut_natura"] != "") {
				$statut_natura = '<tr><td class="label" valign="top">Natura 2000 : </td><td valign="top">'.$ligne["statut_natura"].'</td></tr>';
			}
			$commune = "";
			if ($ligne["commune"] != "") {
				$commune = '<tr><td class="label" valign="top">Commune : </td><td valign="top">'.$ligne["commune"].'</td></tr>';
			}
			$pdf_a = "";
			if ($ligne["pdf_a"] != "") {
				$fichiers = explode(",", $ligne["pdf_a"]);
				foreach ($fichiers as $fichier) {
					$pdf_a .= '<tr><td class="label" valign="top">Plus d\'infos : </td><td valign="top"><a href="'.$dir_docs_pdf.$fichier.'" target="_blank">Cliquez ici</a></td></tr>';
				}
			}
			$pdf_b = "";
			if ($ligne["pdf_b"] != "") {
				$fichiers = explode(",", $ligne["pdf_b"]);
				foreach ($fichiers as $fichier) {
					$pdf_b .= '<tr><td class="label" valign="top">Plus d\'infos : </td><td valign="top"><a href="'.$dir_docs_pdf.$fichier.'" target="_blank">Cliquez ici</a></td></tr>';
				}
			}
			$laserie = '<Placemark id="'.$ligne["id_fiche"].'">
      <name>'.$ligne["nom"].'</name>
      <Snippet></Snippet>
      <description><![CDATA[<html xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
<head>
<META http-equiv="Content-Type" content="text/html">
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
</head>
<body style="margin:0px 0px 0px 0px;overflow:auto;background:#FFFFFF;">
<table border="0" cellpadding="0" cellspacing="0">
<tr><td colspan="2" class="titre">'.$ligne["nom_serie"].'</td></tr>
<tr><td colspan="2" >'.$ligne["formation_vegetale"].'</td></tr>
'.$statut_natura.'
'.$commune.'
'.$pdf_a.'
'.$pdf_b.'
</table>
</body>

</html>
]]></description>
      <styleUrl>#'.$ligne["id_style"].'</styleUrl>
      <MultiGeometry>
        '.$ligne["geometrie"].'
      </MultiGeometry>
    </Placemark>';
			fwrite($fichier_source, $laserie);
		}
	}
	
	fwrite($fichier_source, '</Folder>
	');
	//conversion opacite
	$opacite = ($opacite=="") ? $opacite=1 : $opacite;
	$opacite = str_pad(dechex($opacite*255),2,"0",STR_PAD_LEFT);
	
	// recherche des styles
	$sql = "SELECT id_style, content FROM ".$prefix."_cbnc_serie_vegetation_styles;";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes2");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			
			$ligne["content"] = str_replace("<color>ff", "<color>".$opacite, $ligne["content"]);
			
			$lestyle = '<Style id="'.$ligne["id_style"].'">
    '.$ligne["content"].'
  </Style>';
			fwrite($fichier_source, $lestyle);
		}
	}
	
	fwrite($fichier_source, '</Document>
</kml>');
	
	fclose($fichier_source);
	
	
	$nom_fichier_dest = $dir_docs_zip.md5(date("YmdHis").rand(0, 1000)).".kmz";
	$zip = new ZipArchive();
	if ($zip->open($nom_fichier_dest, ZipArchive::CREATE) === true) {
		$zip->addFile($nom_fichier_source, "CBNC_3D.kml");
		$zip->close();
	}
	else {
		die("erreur compression");
	}
	header('Content-type: application/vnd.google-earth.kmz');
	
    header('Expires: 0');
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
    header('Cache-Control: no-cache, must-revalidate');
    header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');
	
	readfile($nom_fichier_dest);
	unlink($nom_fichier_source);
	unlink($nom_fichier_dest);
}

function get_kmz2($scale="", $espece="", $commune="", $code_statut="") {
	global $prefix, $db, $uploadFolder;
	
	$dir_docs_pdf = $uploadFolder."/../cbnc_3D/";
	
	$dir_docs_zip = $uploadFolder."/../";
	
	
	$nom_fichier_source = $dir_docs_zip.md5(date("YmdHis").rand(0, 1000))."_points.kml";
	$fichier_source = fopen($nom_fichier_source, "w");
	
	fwrite($fichier_source, '<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xsi:schemaLocation="http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd http://www.google.com/kml/ext/2.2 http://code.google.com/apis/kml/schema/kml22gx.xsd">
<Document id="CBNC3DPOINTS">
  <name>CBNC3DPOINTS</name>
  <Camera>
	<longitude>8.885291655229542</longitude>
	<latitude>42.374383359824904</latitude>
	<altitude>23124.236158860764</altitude>
	<heading>4.6070186443307275</heading>
	<tilt>37.53844474669251</tilt>
  </Camera>
  <Snippet></Snippet>
  <Folder id="FeatureLayer0">
    <name>Balagne_Points</name>
    <Snippet></Snippet>
    ');
	
	
	
	// recherche des series
	$where = "";
	
	$commune = stripslashes($commune);
	if ($commune != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "commune='".conditionnertodb($commune)."'";
	}
	$espece = stripslashes($espece);
	if ($espece != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "espece='".conditionnertodb($espece)."'";
	}
	$code_statut = stripslashes($code_statut);
	if ($code_statut != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "code_statut='".conditionnertodb($code_statut)."'";
	}
	
	
	/**************************
	 * A supprimer en production !  Ce n'est l que pour limiter les dgats en dveloppement !
	 **************************/
	//$limit = " LIMIT 0,1000";
	
	$sql = "SELECT id_fiche, nom, date_obs, obs1, obs2, obs3, commune, espece, latitude, longitude, protection, frequence ,endemique, famille, nom_vernaculaire, photo, credits_photos, pdf, statut, id_style, geometrie FROM ".$prefix."_cbnc_serie_observations".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$ligne["date_obs"] = date2JMA($ligne["date_obs"]);
			$espece = "";
			if ($ligne["espece"] != "") {
				$espece = '<tr><td colspan="2" class="titre">'.$ligne["espece"].'</td></tr>';
			}
			$nom_vernaculaire= "";
			if ($ligne["nom_vernaculaire"] != "") {
				$nom_vernaculaire = '<tr><td colspan="2" >'.$ligne["nom_vernaculaire"].'</td></tr>';
			}
			$famille = "";
			if ($ligne["famille"] != "") {
				$famille = '<tr><td class="label" valign="top">Famille : </td><td valign="top">'.$ligne["famille"].'</td></tr>';
			}
			$frequence = "";
			if ($ligne["frequence"] != "") {
				$frequence = '<tr><td class="label" valign="top">'.utf8_encode('Frquence').' : </td><td valign="top">'.$ligne["frequence"].'</td></tr>';
			}
			$endemique = "";
			if ($ligne["endemique"] != "") {
				$endemique = '<tr><td class="label" valign="top">'.utf8_encode('Endmisme').' : </td><td valign="top">'.$ligne["endemique"].'</td></tr>';
			}
			$observateurs = "";
			if (trim($ligne["obs1"].$ligne["obs2"].$ligne["obs3"]) != "") {
				$observateurs = '<tr><td class="label" valign="top">Observateur(s) : </td><td valign="top">';
				$observateurs .= trim($ligne["obs1"]);
				$observateurs .= (trim($ligne["obs1"].$ligne["obs2"]) != "") ?  "<br />" : "";
				$observateurs .= trim($ligne["obs2"]);
				$observateurs .= (trim($ligne["obs2"].$ligne["obs3"]) != "") ?  "<br />" : "";
				$observateurs .= trim($ligne["obs3"]);
				$observateurs .= '</td></tr>';
			}
			$date = "";
			if ($ligne["date_obs"] != "") {
				$date = '<tr><td class="label" valign="top">Date de l\'observation : </td><td valign="top">'.$ligne["date_obs"].'</td></tr>';
			}
			$commune = "";
			if ($ligne["commune"] != "") {
				$commune = '<tr><td class="label" valign="top">Commune : </td><td valign="top">'.$ligne["commune"].'</td></tr>';
			}
			$statut = "";
			if ($ligne["statut"] != "") {
				$statut = '<tr><td class="label" valign="top">Protection : </td><td valign="top">'.$ligne["statut"].'</td></tr>';
			}
			$pdf = "";
			if ($ligne["pdf"] != "") {
				$fichiers = explode(",", $ligne["pdf"]);
				foreach ($fichiers as $fichier) {
					$pdf .= '<tr><td class="label" valign="top">Plus d\'infos : </td><td valign="top"><a href="'.$dir_docs_pdf.$fichier.'" target="_blank">Cliquez ici</a></td></tr>';
				}
			}
			$prephoto = "";
			$postphoto = "";
			if ($ligne["photo"] != "") {
				$prephoto .= '<table border="0" cellpadding="0" cellspacing="0"><tr><td valign="top">';
				$postphoto .= '</td><td valign="top">';
				$postphoto .= '<table border="0" cellpadding="0" cellspacing="0">';
				$postphoto .= '<tr><td><img src="'.$dir_docs_pdf.$ligne["photo"].'" width="200"></td></tr>';
				if ($ligne["credits_photos"] != "") {
					//$postphoto .= '<tr><td>&nbsp;</td></tr>';
					$postphoto .= '<tr><td class="credits">'.$ligne["credits_photos"].'</td></tr>';
				}
				$postphoto .= '</table>';
				$postphoto .= '</td></tr></table>';
			}

			$laserie = '<Placemark id="'.$ligne["id_fiche"].'">
      <name>'.$ligne["nom"].'</name>
      <Snippet></Snippet>
      <description><![CDATA[<html xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
<head>
<META http-equiv="Content-Type" content="text/html">
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
</head>
<body style="margin:0px 0px 0px 0px;overflow:auto;background:#FFFFFF;">
'.$prephoto.'
<table border="0" cellpadding="0" cellspacing="0" class="infos">
'.$espece.'
'.$nom_vernaculaire.'
'.$famille.'
'.$frequence.'
'.$endemique.'
'.$observateurs.'
'.$date.'
'.$commune.'
'.$statut.'
'.$pdf.'
</table>
'.$postphoto.'
</body>

</html>
]]></description>
      <styleUrl>#'.$ligne["id_style"].'</styleUrl>
      <Point>
        '.$ligne["geometrie"].'
      </Point>
    </Placemark>';
			fwrite($fichier_source, $laserie);
		}
	}
	
	fwrite($fichier_source, '</Folder>
	');

	
	// recherche des styles
	$sql = "SELECT id_style, content FROM ".$prefix."_cbnc_serie_observation_styles;";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes2");
	}
	if ($db->sql_numrows($result) > 0) {
		$fichiers = array();
		while ($ligne = $db->sql_fetchrow($result)) {
			if (preg_match_all("#<href>(.*)</href>#im", $ligne["content"], $matches)) {
				foreach($matches[1] as $fichier) {
					$fichiers[] = $fichier;				}
			}
			if ($scale != "") {
				$valscale = $scale*0.12+0.25;
				$ligne["content"] = str_replace("<scale>0.25", "<scale>".$valscale, $ligne["content"]);
			}
			$lestyle = '<Style id="'.$ligne["id_style"].'">
    '.$ligne["content"].'
  </Style>';
			fwrite($fichier_source, $lestyle);
		}
	}
	fwrite($fichier_source, '</Document>
</kml>');
	fclose($fichier_source);
	
	$fichiers_uniques = array_unique($fichiers);
	//$fichiers_uniques contient la liste des fichiers  ajouter  l'achive kmz pour que les styles soient compris -> les png dans les cas prsent
	$nom_fichier_dest = $dir_docs_zip.md5(date("YmdHis").rand(0, 1000)).".kmz";
	$zip = new ZipArchive();
	if ($zip->open($nom_fichier_dest, ZipArchive::CREATE) === true) {
		foreach ($fichiers_uniques as $lasource) {
			if (file_exists($dir_docs_pdf.$lasource)) {
				$zip->addFile($dir_docs_pdf.$lasource, $lasource);
			}
		}
		$zip->addFile($nom_fichier_source, "CBNC_3D_OBS.kml");
		$zip->close();
	}
	else {
		die("erreur compression");
	}
	header('Content-type: application/vnd.google-earth.kmz');
	
    header('Expires: 0');
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
    header('Cache-Control: no-cache, must-revalidate');
    header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');
	
	readfile($nom_fichier_dest);
	unlink($nom_fichier_source);
	unlink($nom_fichier_dest);
}

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;
}

function get_map_3D() {
	global $user_prefix, $db, $module_name, $Default_Theme;
	
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	$nukeurl = format_nuke_url($nukeurl);
	
	require_once("modules/SimpleCarto/lib/g_params.php");
	
	header('Expires: 0');
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
    header('Cache-Control: no-cache, must-revalidate');
    header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');
	
	/*$sql = "SELECT DISTINCT nom_serie FROM ".$user_prefix."_cbnc_serie_vegetation WHERE nom_serie<>'' ORDER BY nom_serie ASC";
	$result = $db->sql_query($sql);
	$menu_serie = "";
	if ($db->sql_numrows ( $result ) != 0) {
		$menu_serie = '<select name="serie" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.value,this.form.elements[\'commune\'].value);" style="width: 370px">';
		$menu_serie .= '<option value="">Choisissez une srie</option>';
		while (list($nom_serie) = $db->sql_fetchrow ($result)) {
			$nom_serie = str_replace("\"", "&quote;", $nom_serie);
			$menu_serie .= '<option value="'.$nom_serie.'"'.$select.'>'.$nom_serie.'</option>';
		}
		$menu_serie .= '</select>';
	}
	$sql = "SELECT DISTINCT commune FROM ".$user_prefix."_cbnc_serie_vegetation WHERE commune<>'' ORDER BY commune ASC";
	$result = $db->sql_query($sql);
	$menu_commmune = "";
	if ($db->sql_numrows ( $result ) != 0) {
		$menu_commmune = '<select name="commune" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.form.elements[\'serie\'].value,this.value);" style="width: 370px">';
		$menu_commmune .= '<option value="">Choisissez une commune</option>';
		while (list($commune) = $db->sql_fetchrow ($result)) {
			$commune = str_replace("\"", "&quote;", $commune);
			$menu_commmune .= '<option value="'.$commune.'"'.$select.'>'.$commune.'</option>';
		}
		$menu_commmune .= '</select>';
	}
	
	$menu_opacite = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
	<td>Opacit : </td>
	<td align="center"><img src="images/waitno16.gif" name="wait" /></td>
	<td align="right" width="290"><input type="range" name="opacite" value="5" max="5" min="0" style="width: 280px" onchange="parent.reload(document,this.value/this.max,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value)"></td>
	</tr></table>';*/
	
	echo '<!DOCTYPE html>
<html>
	<head>
<title>Cartographiqe 3D intreractive -  arobase.fr</title>
';
	echo '
		<link href="themes/'.$Default_Theme.'/style/style.css" rel="stylesheet" type="text/css" media="all"/>
		<link href="themes/'.$Default_Theme.'/style/cbnc_carto3D.css" rel="stylesheet" type="text/css" media="all"/>
		
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script type="text/javascript">
			var matempo = new Image();
			matempo.src = "images/wait16.gif";
			var matempono = new Image();
			matempono.src = "images/waitno16.gif";
			
			var ge;
			var kmlObjectOld;
			// Le flux kml
			/*var kmlString = ""
              + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
              + "<kml xmlns=\"http://www.opengis.net/kml/2.2\">"

              + "<Document>"
              + "  <Camera>"
              + "    <longitude>-122.444633</longitude>"
              + "    <latitude>37.801899</latitude>"
              + "    <altitude>139.629438</altitude>"
              + "    <heading>-70.0</heading>"
              + "    <tilt>75</tilt>"
              + "  </Camera>"

              + "  <Placemark>"
              + "    <name>Placemark from KML string</name>"
              + "    <Point>"
              + "      <coordinates>-122.448425,37.802907,0</coordinates>"
              + "    </Point>"
              + "  </Placemark>"

              + "</Document>"
              + "</kml>";*/
			
			google.load("earth", "1", {"other_params":"sensor=false"});
			function init() {
				google.earth.createInstance("map3d", initCB, failureCB);
			}
			function initCB(instance) {
				ge = instance;
				ge.getWindow().setVisibility(true);
				ge.getNavigationControl().setVisibility(ge.VISIBILITY_AUTO);
				/* // ne pas oublier de bien fixer une image pour cer le bouton - btn360 n\'existe pas
				createScreenOverlayButton(ge, 20, 20, 50, 50, \'btn360\', refresh);
				*/
				
				/*
				var kmlObject = ge.parseKml(kmlString);
				kmlObjectOld = kmlObject;
				ge.getFeatures().appendChild(kmlObject);
				if (kmlObject.getAbstractView()) {
					ge.getView().setAbstractView(kmlObject.getAbstractView());
				}
				*/
				
				//var hrefKml = \'http://webservices.localhost/modules.php?name=cbnc_carto3D&sop=getkml\';
				//var hrefKml = \'http://webservices.localhost/cbnc_carto3D.kml\';
				//var hrefKml = \'http://code.google.com/apis/earth/documentation/samples/kml_example.kml\';
				var hrefKml = \''.$nukeurl.'/cbnc_carto3D.kmz?newflux=1\';

				// Permet de charger le mkl ou kmz
				google.earth.fetchKml(ge, hrefKml, function(kmlObject) {
					kmlObjectOld = kmlObject;
					if (kmlObject) {
						ge.getFeatures().appendChild(kmlObject);
						var options = {
							boundsFallback: true
						};
						if (kmlObject.getAbstractView()) {
							ge.getView().setAbstractView(kmlObject.getAbstractView());
						}
					}
				});
				
				create_formulaire()
			}
			function failureCB(errorCode) {
				create_formulaire()
			}
			google.setOnLoadCallback(init);
			
			// fonctions pour rechercher les donees si celles-ci ont chang mais que l\'adresse est toujours la mme (problme du cache Goggle Earth) -> cration du bouton refresh
			function refresh() {
				ge.kill_();
				location.reload();
			}
			
			function createScreenOverlayButton(ge, x, y, width, height, img, callback) {
				var _addOverlayForState = function(suffix, drawOrder, visible) {
					// Create the loading overlay.
					var icon = ge.createIcon(\'\');
					icon.setHref(appPath + img + suffix + \'.png\');

					var overlay = ge.createScreenOverlay(\'\');
					overlay.setDrawOrder(drawOrder || 0);
					overlay.setVisibility(visible || false);
					overlay.setIcon(icon);
					overlay.getOverlayXY().set(x, ge.UNITS_PIXELS, y, ge.UNITS_INSET_PIXELS);
					overlay.getScreenXY().set(0, ge.UNITS_FRACTION, 1, ge.UNITS_FRACTION);
					overlay.getSize().set(width, ge.UNITS_PIXELS, height, ge.UNITS_PIXELS);
					ge.getFeatures().appendChild(overlay);
					
					return overlay;
				};
				
				var overlayReg = _addOverlayForState(\'\', 1, true);
				
				var _isMouseOnButton = function(mx, my) {
					return x <= mx && mx <= x + width &&
						y <= my && my <= y + height;
				};
				
				google.earth.addEventListener(ge.getWindow(), \'click\', function(evt) {
					if (evt.getButton() === 0 && _isMouseOnButton(evt.getClientX(), evt.getClientY())) {
						callback();
					}
				});
			}
			
			// fonction pour rechercher les donnes si les paramtres ont chang 
			function reload(ledocument, opacite, serie, commune) {
				ledocument.images["wait"].src = matempo.src;
				
				//alert(opacite + "********" + serie + "********" + commune);
				//var hrefKmz = \'http://webservices.localhost/cbnc_carto3D.kmz?serie=\'+escape(serie)+\'&commune=\'+escape(commune);
				var hrefKmz = \''.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getkmz&opacite=\'+escape(opacite)+\'&serie=\'+escape(serie)+\'&commune=\'+escape(commune)+\'&newflux=1\';
				//var hrefKmz = \'http://webservices.localhost/cbnc_carto3D.kmz\';
				google.earth.fetchKml(ge, hrefKmz, function(kmlObject) {
					if(kmlObjectOld) {
						ge.getFeatures().replaceChild(kmlObject, kmlObjectOld);
						//ge.getFeatures().removeChild(kmlObjectOld);
						
					}
					else {
						if (kmlObject) {
							ge.getFeatures().appendChild(kmlObject);
							if (kmlObject.getAbstractView()) {
								ge.getView().setAbstractView(kmlObject.getAbstractView());
							}
						}
					}
					kmlObjectOld = kmlObject;
					
					ledocument.images["wait"].src = matempono.src;
				});
			}
			
			function create_formulaire() {
				var ifr = document.createElement("iframe");
				ifr.src= "'.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getcrits3d";
				//le mthode ci dessous fonctionne partout sauf sous IE
				/*ifr.srcdoc= \'<html><body style="padding: 0; margin:0;">\'
							+\'<link href="themes/'.$Default_Theme.'/style/style.css" rel="stylesheet" type="text/css" media="all"/>\'
							+\'<link href="themes/'.$Default_Theme.'/style/cbnc_carto3D.css" rel="stylesheet" type="text/css" media="all"/>\'
							+\'<div style="position: absolute; top: 0; left: 0; width: 400px; background-color: #eee;">\'
							+ \'<div style="background-color: #666;color: #fff; text-align: center; padding: 5px 10px; font-weight: bold;">Critres de slection</div>\'
							+ \'<div style="padding: 5px 10px"><form style="margin: 0; padding: 0;">'.str_replace("\r","",str_replace("\n","",str_replace("'", "\\'", $menu_serie))).'<br />'.str_replace("\r","",str_replace("\n","",str_replace("'", "\\'", $menu_commmune))).'<br />'.str_replace("\r","",str_replace("\n","",str_replace("'", "\\'", $menu_opacite))).'</form></div>\'
							+ \'</div>\'
							+\'</body></html>\';*/
				//document.body.scroll = "no";
				ifr.style.position = "absolute";
				ifr.style.top="10px";
				ifr.style.left="10px";
				//ifr.style.backgroundColor="#eee";
				ifr.style.border="1px solid #666";
				ifr.style.width = "400px";
				ifr.style.height = "150px";
				ifr.border="1px solid #f00";
				ifr.frameBorder="0";
				ifr.frameSpacing="0";
				ifr.marginHeight="0";
				ifr.marginWidth="0";
				ifr.style.margin="0";
				ifr.style.padding="0";
				document.body.appendChild(ifr);
			}
		</script>
';
	
	echo'
</head>
<body style="margin: 0; padding: 0;">
';
	
	echo '
<div style="position: absolute; width: 100%; height: 100%; padding: 0; margin:0;"><div id="map3d" style="width: 100%; height: 100%;"></div></div>
<!--la mthode ci-dessous ne fonctionne que sous firefox-->
<!--<div style="position: absolute; top: 10px; left: 10px; width: 400px; background-color: #eee; border: 1px solid #666;">
<div style="background-color: #666;color: #fff; text-align: center; padding: 5px 10px">Critres de slection</div>
<div style="padding: 5px 10px"><form style="margin: 0; padding: 0;">'.$menu_serie.'<br />'.$menu_commmune.'<br />'.$menu_opacite.'</form></div>
</div>-->

';
	echo '
</body>
</html>';
}

function isIE(){
	$isIE = preg_match("/MSIE ([0-9]{1,}[\.0-9]{0,})/",$_SERVER['HTTP_USER_AGENT'],$version);
	if($isIE){
		return $version[1];
	}
	return $isIE;
}

function get_crits_3D() {
	global $user_prefix, $db, $module_name, $Default_Theme;

	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	$nukeurl = format_nuke_url($nukeurl);

	require_once("modules/SimpleCarto/lib/g_params.php");

	header('Expires: 0');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: no-cache, must-revalidate');
	header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');

	$sql = "SELECT DISTINCT nom_serie FROM ".$user_prefix."_cbnc_serie_vegetation WHERE nom_serie<>'' ORDER BY nom_serie ASC";
	$result = $db->sql_query($sql);
	$menu_serie = "";
	if ($db->sql_numrows ( $result ) != 0) {
		if (isIE()) {
			$menu_serie = '<select name="serie" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value,this.value,this.form.elements[\'commune\'].value);" style="width: 370px">';
		}
		else {
			$menu_serie = '<select name="serie" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.value,this.form.elements[\'commune\'].value);" style="width: 370px">';
		}
		$menu_serie .= '<option value="">Choisissez une srie</option>';
		while (list($nom_serie) = $db->sql_fetchrow ($result)) {
			$nom_serie = str_replace("\"", "&quote;", $nom_serie);
			$menu_serie .= '<option value="'.$nom_serie.'"'.$select.'>'.$nom_serie.'</option>';
		}
		$menu_serie .= '</select>';
	}
	$sql = "SELECT DISTINCT commune FROM ".$user_prefix."_cbnc_serie_vegetation WHERE commune<>'' ORDER BY commune ASC";
	$result = $db->sql_query($sql);
	$menu_commmune = "";
	if ($db->sql_numrows ( $result ) != 0) {
		if (isIE()) {
			$menu_commmune = '<select name="commune" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value,this.form.elements[\'serie\'].value,this.value);" style="width: 370px">';
		}
		else {
			$menu_commmune = '<select name="commune" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.form.elements[\'serie\'].value,this.value);" style="width: 370px">';
		}
		$menu_commmune .= '<option value="">Choisissez une commune</option>';
		while (list($commune) = $db->sql_fetchrow ($result)) {
			$commune = str_replace("\"", "&quote;", $commune);
			$menu_commmune .= '<option value="'.$commune.'"'.$select.'>'.$commune.'</option>';
		}
		$menu_commmune .= '</select>';
	}

	if (isIE()) {
		$menu_opacite = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
		<td>Opacit : </td>
		<td align="center"><img src="images/waitno16.gif" name="wait" /></td>
		<td align="right" width="290"><select name="opacite" size="1" style="width: 280px" onchange="parent.reload(document,this.value,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value)">
		<option value="1.0">opaque</option>
		<option value="0.75">75 %</option>
		<option value="0.5">50 %</option>
		<option value="0.25">25 %</option>
		<option value="0.0">transparent</option>
		</select></td>
		</tr></table>';
	}
	else {
		$menu_opacite = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
		<td>Opacit : </td>
		<td align="center"><img src="images/waitno16.gif" name="wait" /></td>
		<td align="right" width="290"><input type="range" name="opacite" value="5" max="5" min="0" style="width: 280px" onchange="parent.reload(document,this.value/this.max,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value)"></td>
		</tr></table>';
	}
	
	echo '<html>
		<head>
			<link href="themes/'.$Default_Theme.'/style/style.css" rel="stylesheet" type="text/css" media="all"/>
			<link href="themes/'.$Default_Theme.'/style/cbnc_carto3D.css" rel="stylesheet" type="text/css" media="all"/>
		</head>
		<body style="padding: 0; margin:0; background-color: #eee;">
		<div style="position: absolute; top: 0; left: 0; width: 400px; background-color: #eee;">
		<div style="background-color: #666;color: #fff; text-align: center; padding: 5px 10px; font-weight: bold;">Critres de slection</div>
		<div style="padding: 5px 10px"><form style="margin: 0; padding: 0;">'.$menu_serie.'<br />'.$menu_commmune.'<br />'.$menu_opacite.'</form></div>
		</div>
		</body></html>';
}

function get_map_obs_3D() {
	global $user_prefix, $db, $module_name, $Default_Theme;
	
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	$nukeurl = format_nuke_url($nukeurl);
	
	require_once("modules/SimpleCarto/lib/g_params.php");
	
	header('Expires: 0');
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
    header('Cache-Control: no-cache, must-revalidate');
    header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');
	
	echo '<!DOCTYPE html>
<html>
	<head>
<title>Cartographiqe 3D intreractive -  arobase.fr</title>
';
	echo '
		<link href="themes/'.$Default_Theme.'/style/style.css" rel="stylesheet" type="text/css" media="all"/>
		<link href="themes/'.$Default_Theme.'/style/cbnc_carto3D.css" rel="stylesheet" type="text/css" media="all"/>
		<script type="text/javascript" src="modules/'.$module_name.'/system/lib_AJAX.js"></script>
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script type="text/javascript">
			var matempo = new Image();
			matempo.src = "images/wait16.gif";
			var matempono = new Image();
			matempono.src = "images/waitno16.gif";
			
			var ge;
			var kmlObjectOld;
			
			google.load("earth", "1", {"other_params":"sensor=false"});
			function init() {
				google.earth.createInstance("map3d", initCB, failureCB);
			}
			function initCB(instance) {
				ge = instance;
				ge.getWindow().setVisibility(true);
				ge.getNavigationControl().setVisibility(ge.VISIBILITY_AUTO);
				
				var hrefKml = \''.$nukeurl.'/cbnc_carto3D_obs.kmz?newflux=10\';

				// Permet de charger le mkl ou kmz
				google.earth.fetchKml(ge, hrefKml, function(kmlObject) {
					kmlObjectOld = kmlObject;
					if (kmlObject) {
						ge.getFeatures().appendChild(kmlObject);
						var options = {
							boundsFallback: true
						};
						if (kmlObject.getAbstractView()) {
							ge.getView().setAbstractView(kmlObject.getAbstractView());
						}
					}
				});
				
				create_formulaire()
			}
			function failureCB(errorCode) {
				create_formulaire()
			}
			google.setOnLoadCallback(init);
			
			// fonction pour rechercher les donnes si les paramtres ont chang 
			function reload(ledocument, scale, espece, commune, code_statut) {
				ledocument.images["wait"].src = matempo.src;
				var source_nbre = \'modules.php?name=cbnc_carto3D&sop=getkmz2nbre&espece=\'+escape(espece)+\'&commune=\'+escape(commune)+\'&code_statut=\'+escape(code_statut);
				var nbre_content = GetAJAXData(source_nbre);
				ledocument.getElementById("nbre").innerHTML="Observations affiches : "+nbre_content+"&nbsp;&nbsp;&nbsp;";
				
				var hrefKmz = \''.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getkmz2&espece=\'+escape(espece)+\'&commune=\'+escape(commune)+\'&code_statut=\'+escape(code_statut)+\'&scale=\'+escape(scale)+\'&newflux=10\';
				google.earth.fetchKml(ge, hrefKmz, function(kmlObject) {
					if(kmlObjectOld) {
						ge.getFeatures().replaceChild(kmlObject, kmlObjectOld);
						//ge.getFeatures().removeChild(kmlObjectOld);
						
					}
					else {
						if (kmlObject) {
							ge.getFeatures().appendChild(kmlObject);
							if (kmlObject.getAbstractView()) {
								ge.getView().setAbstractView(kmlObject.getAbstractView());
							}
						}
					}
					kmlObjectOld = kmlObject;
					
					ledocument.images["wait"].src = matempono.src;
				});
			}
			
			function create_formulaire() {
				var ifr = document.createElement("iframe");
				ifr.src= "'.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getcritsobs3d";
				//document.body.scroll = "no";
				ifr.style.position = "absolute";
				ifr.style.top="10px";
				ifr.style.left="10px";
				//ifr.style.backgroundColor="#eee";
				ifr.style.border="1px solid #666";
				ifr.style.width = "400px";
				ifr.style.height = "190px";
				ifr.border="1px solid #f00";
				ifr.frameBorder="0";
				ifr.frameSpacing="0";
				ifr.marginHeight="0";
				ifr.marginWidth="0";
				ifr.style.margin="0";
				ifr.style.padding="0";
				document.body.appendChild(ifr);
			}
		</script>
';
	
	echo'
</head>
<body style="margin: 0; padding: 0;">
';
	
	echo '
<div style="position: absolute; width: 100%; height: 100%; padding: 0; margin:0;"><div id="map3d" style="width: 100%; height: 100%;"></div></div>
';
	echo '
</body>
</html>';
}

function get_crits_obs_3D() {
	global $user_prefix, $db, $module_name, $Default_Theme;
	global $code_status_list, $scale_list;

	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	$nukeurl = format_nuke_url($nukeurl);

	require_once("modules/SimpleCarto/lib/g_params.php");

	header('Expires: 0');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: no-cache, must-revalidate');
	header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');

	$sql = "SELECT DISTINCT espece FROM ".$user_prefix."_cbnc_serie_observations WHERE espece<>'' ORDER BY espece ASC";
	$result = $db->sql_query($sql);
	$menu_espece = "";
	if ($db->sql_numrows ( $result ) != 0) {
		$menu_espece = '<select name="espece" size="1" onchange="parent.reload(document, this.form.elements[\'scale\'].value,this.value,this.form.elements[\'commune\'].value,this.form.elements[\'code_statut\'].value);" style="width: 370px">';
		$menu_espece .= '<option value="">Choisissez une espce</option>';
		while (list($espece) = $db->sql_fetchrow ($result)) {
			$espece = str_replace("\"", "&quote;", $espece);
			$menu_espece .= '<option value="'.$espece.'"'.$select.'>'.$espece.'</option>';
		}
		$menu_espece .= '</select>';
	}
	$sql = "SELECT DISTINCT commune FROM ".$user_prefix."_cbnc_serie_observations WHERE commune<>'' ORDER BY commune ASC";
	$result = $db->sql_query($sql);
	$menu_commmune = "";
	if ($db->sql_numrows ( $result ) != 0) {
		$menu_commmune = '<select name="commune" size="1" onchange="parent.reload(document, this.form.elements[\'scale\'].value, this.form.elements[\'espece\'].value, this.value, this.form.elements[\'code_statut\'].value);" style="width: 370px">';
		$menu_commmune .= '<option value="">Choisissez une commune</option>';
		while (list($commune) = $db->sql_fetchrow ($result)) {
			$commune = str_replace("\"", "&quote;", $commune);
			$menu_commmune .= '<option value="'.$commune.'"'.$select.'>'.$commune.'</option>';
		}
		$menu_commmune .= '</select>';
	}
	
	$menu_statut = '<select name="code_statut" size="1" onchange="parent.reload(document, this.form.elements[\'scale\'].value, this.form.elements[\'espece\'].value, form.elements[\'commune\'].value, this.value);" style="width: 370px">';
	$menu_statut .= '<option value="">Choisissez un statut</option>';
	foreach ($code_status_list as $code=>$un_statut) {
		$menu_statut .= '<option value="'.$code.'"'.$select.'>'.$un_statut.'</option>';
	}
	$menu_statut .= '</select>';
	
	if (isIE()) {	
		$menu_scale = '<select name="scale" size="1" onchange="parent.reload(document, this.value, this.form.elements[\'espece\'].value, form.elements[\'commune\'].value, this.form.elements[\'code_statut\'].value);" style="width: 370px">';
		$menu_scale .= '<option value="">Choisissez une taille de point</option>';
		foreach ($scale_list as $code=>$un_scale) {
			$menu_scale .= '<option value="'.$code.'"'.$select.'>'.$un_scale.'</option>';
		}
		$menu_scale .= '</select>';
	}
	else {
		$menu_scale = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
		<td>Taille de points : </td>
		<td align="right"><input type="range" name="scale" value="0" max="2" min="0" style="width: 280px" onchange="parent.reload(document, this.value, this.form.elements[\'espece\'].value, form.elements[\'commune\'].value, this.form.elements[\'code_statut\'].value)"></td>
		</tr></table>';
	}
	
	echo '<html>
		<head>
			<link href="themes/'.$Default_Theme.'/style/style.css" rel="stylesheet" type="text/css" media="all"/>
			<link href="themes/'.$Default_Theme.'/style/cbnc_carto3D.css" rel="stylesheet" type="text/css" media="all"/>
		</head>
		<body style="padding: 0; margin:0; background-color: #eee;">
		<div style="position: absolute; top: 0; left: 0; width: 400px;">
		<div style="background-color: #666;color: #fff; text-align: center; padding: 5px 10px; font-weight: bold;">Critres de slection</div>
		<div style="padding: 5px 10px">
			<form style="margin: 0; padding: 0;">'.$menu_espece.'<br />'.$menu_commmune.'<br />'.$menu_statut.'<br />'.$menu_scale.'</form>
			<!--<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
				<td>Observations affiches : '.'en cours de dev'.'&nbsp;&nbsp;&nbsp;</td>
				<td align="center"><img src="images/waitno16.gif" name="wait" /></td>
				</tr>
			</table>-->
			<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td><p style="text-align: center"><span id="nbre">Observations affiches : '.get_kmz2_nbre().'&nbsp;&nbsp;&nbsp;</span></p></td><td><img src="images/waitno16.gif" name="wait" /></td></tr></table>
		</div>
		</div>
		</body></html>';
}

function get_map_all_3D() {
	global $user_prefix, $db, $module_name, $Default_Theme;
	global $url_data_communes, $newflux;
	
	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	$nukeurl = format_nuke_url($nukeurl);
	
	require_once("modules/SimpleCarto/lib/g_params.php");
	
	header('Expires: 0');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: no-cache, must-revalidate');
	header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');
	
	/*$sql = "SELECT DISTINCT nom_serie FROM ".$user_prefix."_cbnc_serie_vegetation WHERE nom_serie<>'' ORDER BY nom_serie ASC";
	 $result = $db->sql_query($sql);
	$menu_serie = "";
	if ($db->sql_numrows ( $result ) != 0) {
	$menu_serie = '<select name="serie" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.value,this.form.elements[\'commune\'].value);" style="width: 370px">';
	$menu_serie .= '<option value="">Choisissez une srie</option>';
	while (list($nom_serie) = $db->sql_fetchrow ($result)) {
	$nom_serie = str_replace("\"", "&quote;", $nom_serie);
	$menu_serie .= '<option value="'.$nom_serie.'"'.$select.'>'.$nom_serie.'</option>';
	}
	$menu_serie .= '</select>';
	}
	$sql = "SELECT DISTINCT commune FROM ".$user_prefix."_cbnc_serie_vegetation WHERE commune<>'' ORDER BY commune ASC";
	$result = $db->sql_query($sql);
	$menu_commmune = "";
	if ($db->sql_numrows ( $result ) != 0) {
	$menu_commmune = '<select name="commune" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.form.elements[\'serie\'].value,this.value);" style="width: 370px">';
	$menu_commmune .= '<option value="">Choisissez une commune</option>';
	while (list($commune) = $db->sql_fetchrow ($result)) {
	$commune = str_replace("\"", "&quote;", $commune);
	$menu_commmune .= '<option value="'.$commune.'"'.$select.'>'.$commune.'</option>';
	}
	$menu_commmune .= '</select>';
	}
	
	$menu_opacite = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
	<td>Opacit : </td>
	<td align="center"><img src="images/waitno16.gif" name="wait" /></td>
	<td align="right" width="290"><input type="range" name="opacite" value="5" max="5" min="0" style="width: 280px" onchange="parent.reload(document,this.value/this.max,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value)"></td>
	</tr></table>';*/
	
	echo '<!DOCTYPE html>
	<html>
		<head>
			<title>Cartographiqe 3D intreractive -  arobase.fr</title>
			';
	echo '
		<link href="themes/'.$Default_Theme.'/style/style.css" rel="stylesheet" type="text/css" media="all"/>
		<link href="themes/'.$Default_Theme.'/style/cbnc_carto3D.css" rel="stylesheet" type="text/css" media="all"/>
		<script type="text/javascript" src="modules/'.$module_name.'/system/lib_AJAX.js"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/system/lib_XML_parser.js"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/system/extensions-0.2.1.pack.js"></script>
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script type="text/javascript">
			var matempo = new Image();
			matempo.src = "images/wait16.gif";
			var matempono = new Image();
			matempono.src = "images/waitno16.gif";
		
			var ge;
			var gex;
			var placemark_max_max;
			var placemark_max_min;
			var placemark_min_max;
			var placemark_min_min;
			var kmlObjectOld;
			var kmlObjectCommune;
			// Le flux kml
			/*var kmlString = ""
              + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
              + "<kml xmlns=\"http://www.opengis.net/kml/2.2\">"
	
              + "<Document>"
              + "  <Camera>"
              + "    <longitude>-122.444633</longitude>"
              + "    <latitude>37.801899</latitude>"
              + "    <altitude>139.629438</altitude>"
              + "    <heading>-70.0</heading>"
              + "    <tilt>75</tilt>"
              + "  </Camera>"
	
              + "  <Placemark>"
              + "    <name>Placemark from KML string</name>"
              + "    <Point>"
              + "      <coordinates>-122.448425,37.802907,0</coordinates>"
              + "    </Point>"
              + "  </Placemark>"
	
              + "</Document>"
              + "</kml>";*/
		
			google.load("earth", "1", {"other_params":"sensor=false"});
			function init() {
				google.earth.createInstance("map3d", initCB, failureCB);
			}
			function initCB(instance) {
				ge = instance;
				ge.getWindow().setVisibility(true);
				ge.getNavigationControl().setVisibility(ge.VISIBILITY_AUTO);
				/* // ne pas oublier de bien fixer une image pour cer le bouton - btn360 n\'existe pas
				createScreenOverlayButton(ge, 20, 20, 50, 50, \'btn360\', refresh);
				*/
				gex = new GEarthExtensions(ge);
				/*
				var kmlObject = ge.parseKml(kmlString);
				kmlObjectOld = kmlObject;
				ge.getFeatures().appendChild(kmlObject);
				if (kmlObject.getAbstractView()) {
					ge.getView().setAbstractView(kmlObject.getAbstractView());
				}
				*/
	
				//var hrefKml = \'http://webservices.localhost/modules.php?name=cbnc_carto3D&sop=getkml\';
				//var hrefKml = \'http://webservices.localhost/cbnc_carto3D.kml\';
				//var hrefKml = \'http://code.google.com/apis/earth/documentation/samples/kml_example.kml\';
				/*var hrefKml = \''.$nukeurl.'/cbnc_carto3D.kmz?newflux='.$newflux.'\';
	
				// Permet de charger le mkl ou kmz
				google.earth.fetchKml(ge, hrefKml, function(kmlObject) {
					kmlObjectOld = kmlObject;
					if (kmlObject) {
						ge.getFeatures().appendChild(kmlObject);
						var options = {
							boundsFallback: true
						};
						if (kmlObject.getAbstractView()) {
							ge.getView().setAbstractView(kmlObject.getAbstractView());
						}
					}
				});*/
	
				create_formulaire()
			}
			function failureCB(errorCode) {
				create_formulaire()
			}
			google.setOnLoadCallback(init);
		
			// fonctions pour rechercher les donees si celles-ci ont chang mais que l\'adresse est toujours la mme (problme du cache Goggle Earth) -> cration du bouton refresh
			function refresh() {
				ge.kill_();
				location.reload();
			}
		
			function createScreenOverlayButton(ge, x, y, width, height, img, callback) {
				var _addOverlayForState = function(suffix, drawOrder, visible) {
					// Create the loading overlay.
					var icon = ge.createIcon(\'\');
					icon.setHref(appPath + img + suffix + \'.png\');
	
					var overlay = ge.createScreenOverlay(\'\');
					overlay.setDrawOrder(drawOrder || 0);
					overlay.setVisibility(visible || false);
					overlay.setIcon(icon);
					overlay.getOverlayXY().set(x, ge.UNITS_PIXELS, y, ge.UNITS_INSET_PIXELS);
					overlay.getScreenXY().set(0, ge.UNITS_FRACTION, 1, ge.UNITS_FRACTION);
					overlay.getSize().set(width, ge.UNITS_PIXELS, height, ge.UNITS_PIXELS);
					ge.getFeatures().appendChild(overlay);
			
					return overlay;
				};
	
				var overlayReg = _addOverlayForState(\'\', 1, true);
	
				var _isMouseOnButton = function(mx, my) {
					return x <= mx && mx <= x + width &&
						y <= my && my <= y + height;
				};
	
				google.earth.addEventListener(ge.getWindow(), \'click\', function(evt) {
					if (evt.getButton() === 0 && _isMouseOnButton(evt.getClientX(), evt.getClientY())) {
						callback();
					}
				});
			}
		
			// fonction pour rechercher les donnes si les paramtres ont chang
			function reload(ledocument, opacite, serie, commune, formation_vegetale, move_camera) {
				ledocument.images["waitSerie"].src = matempo.src;
				var source_nbre = \'modules.php?name=cbnc_carto3D&sop=getkmznbre&serie=\'+escape(serie)+\'&commune=\'+escape(commune)+\'&formation_vegetale=\'+escape(formation_vegetale);
				var nbre_content = GetAJAXData(source_nbre);
				ledocument.getElementById("nbre_s").innerHTML="Sries affiches : "+nbre_content+"&nbsp;&nbsp;&nbsp;";
	
				//alert(opacite + "********" + serie + "********" + commune);
				//var hrefKmz = \'http://webservices.localhost/cbnc_carto3D.kmz?serie=\'+escape(serie)+\'&commune=\'+escape(commune);
				var hrefKmz = \''.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getkmzall&opacite=\'+escape(opacite)+\'&serie=\'+escape(serie)+\'&commune=\'+escape(commune)+\'&formation_vegetale=\'+escape(formation_vegetale)+\'&newflux='.$newflux.'\';
				//var hrefKmz = \'http://webservices.localhost/cbnc_carto3D.kmz\';
				google.earth.fetchKml(ge, hrefKmz, function(kmlObject) {
					if(kmlObjectOld) {
						ge.getFeatures().replaceChild(kmlObject, kmlObjectOld);
						//ge.getFeatures().removeChild(kmlObjectOld);
						/*if (kmlObject.getAbstractView() && move_camera) {
							ge.getView().setAbstractView(kmlObject.getAbstractView());
						}*/
					}
					else {
						if (kmlObject) {
							ge.getFeatures().appendChild(kmlObject);
							if (kmlObject.getAbstractView()) {
								ge.getView().setAbstractView(kmlObject.getAbstractView());
							}
							showNameCommune(true);
						}
					}
					kmlObjectOld = kmlObject;
			
					/* faire test si camra bouge*/
					if (move_camera) {
						var hrefXmlMinMax = \''.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getxmlminmaxall&opacite=\'+escape(opacite)+\'&serie=\'+escape(serie)+\'&commune=\'+escape(commune)+\'&formation_vegetale=\'+escape(formation_vegetale)+\'&newflux='.$newflux.'\';
						var xml = GetAJAXData(hrefXmlMinMax);
									
						var root = getXMLroot(xml);
						var carto_options = getXMLchild(root, "carto_options");
						var lat_max = getXMLvalue(carto_options, "lat_max");
						var lat_min = getXMLvalue(carto_options, "lat_min");
						var lng_max = getXMLvalue(carto_options, "lng_max");
						var lng_min = getXMLvalue(carto_options, "lng_min");
												
						if( lat_max != "" && lat_min != "" && lng_max != "" && lng_min != "" ) {
							if( placemark_max_max ) {
								gex.dom.removeObject(placemark_max_max);
							}
							placemark_max_max = gex.dom.buildPointPlacemark([parseFloat(lat_max), parseFloat(lng_max)]);
									
							if( placemark_max_min ) {
								gex.dom.removeObject(placemark_max_min);
							}
							placemark_max_min = gex.dom.buildPointPlacemark([parseFloat(lat_max), parseFloat(lng_min)]);
									
							if( placemark_min_max ) {
								gex.dom.removeObject(placemark_min_max);
							}
							placemark_min_max = gex.dom.buildPointPlacemark([parseFloat(lat_min), parseFloat(lng_max)]);
									
							if( placemark_min_min ) {
								gex.dom.removeObject(placemark_min_min);
							}
							placemark_min_min = gex.dom.buildPointPlacemark([parseFloat(lat_min), parseFloat(lng_min)]);
									
							placemark_max_max.setVisibility(false);
							placemark_max_min.setVisibility(false);
							placemark_min_max.setVisibility(false);
							placemark_min_min.setVisibility(false);
									
							var folder = gex.dom.addFolder([
									placemark_max_max, 
									placemark_max_min, 
									placemark_min_max,
									placemark_min_min
							]);
							var bounds = gex.dom.computeBounds(folder);
							gex.view.setToBoundsView(bounds, { aspectRatio: 1.0 });		
						}
					}
					ledocument.images["waitSerie"].src = matempono.src;
				});
			}
						
			// fonction pour rechercher les donnes si les paramtres ont chang 
			function reloadObs(ledocument, scale, espece, commune, code_statut, move_camera) {
				ledocument.images["waitObs"].src = matempo.src;
				var source_nbre = \'modules.php?name=cbnc_carto3D&sop=getkmz2nbre&espece=\'+escape(espece)+\'&commune=\'+escape(commune)+\'&code_statut=\'+escape(code_statut);
				var nbre_content = GetAJAXData(source_nbre);
				ledocument.getElementById("nbre_o").innerHTML="Observations affiches : "+nbre_content+"&nbsp;&nbsp;&nbsp;";
				
				var hrefKmz = \''.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getkmz2all&espece=\'+escape(espece)+\'&commune=\'+escape(commune)+\'&code_statut=\'+escape(code_statut)+\'&scale=\'+escape(scale)+\'&newflux='.$newflux.'\';
				google.earth.fetchKml(ge, hrefKmz, function(kmlObject) {
					if(kmlObjectOld) {
						ge.getFeatures().replaceChild(kmlObject, kmlObjectOld);
						//ge.getFeatures().removeChild(kmlObjectOld);
						/*if (kmlObject.getAbstractView() && move_camera) {
							ge.getView().setAbstractView(kmlObject.getAbstractView());
						}*/
					}
					else {
						if (kmlObject) {
							ge.getFeatures().appendChild(kmlObject);
							if (kmlObject.getAbstractView()) {
								ge.getView().setAbstractView(kmlObject.getAbstractView());
							}
						}
					}
					kmlObjectOld = kmlObject;
					
					if (move_camera) {
						var hrefXmlMinMax = \''.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getxmlobsminmax&espece=\'+escape(espece)+\'&commune=\'+escape(commune)+\'&code_statut=\'+escape(code_statut)+\'&scale=\'+escape(scale)+\'&newflux='.$newflux.'\';
						var xml = GetAJAXData(hrefXmlMinMax);
					
						var root = getXMLroot(xml);
						var carto_options = getXMLchild(root, "carto_options");
						var lat_max = getXMLvalue(carto_options, "lat_max");
						var lat_min = getXMLvalue(carto_options, "lat_min");
						var lng_max = getXMLvalue(carto_options, "lng_max");
						var lng_min = getXMLvalue(carto_options, "lng_min");
								
						if( lat_max != "" && lat_min != "" && lng_max != "" && lng_min != "" ) {
							if( placemark_max_max ) {
								gex.dom.removeObject(placemark_max_max);
							}
							placemark_max_max = gex.dom.buildPointPlacemark([parseFloat(lat_max), parseFloat(lng_max)]);
									
							if( placemark_max_min ) {
								gex.dom.removeObject(placemark_max_min);
							}
							placemark_max_min = gex.dom.buildPointPlacemark([parseFloat(lat_max), parseFloat(lng_min)]);
									
							if( placemark_min_max ) {
								gex.dom.removeObject(placemark_min_max);
							}
							placemark_min_max = gex.dom.buildPointPlacemark([parseFloat(lat_min), parseFloat(lng_max)]);
									
							if( placemark_min_min ) {
								gex.dom.removeObject(placemark_min_min);
							}
							placemark_min_min = gex.dom.buildPointPlacemark([parseFloat(lat_min), parseFloat(lng_min)]);
									
							placemark_max_max.setVisibility(false);
							placemark_max_min.setVisibility(false);
							placemark_min_max.setVisibility(false);
							placemark_min_min.setVisibility(false);
									
							var folder = gex.dom.addFolder([
									placemark_max_max, 
									placemark_max_min, 
									placemark_min_max,
									placemark_min_min
							]);
							var bounds = gex.dom.computeBounds(folder);
							gex.view.setToBoundsView(bounds, { aspectRatio: 1.0 });
						}
					}
					
					ledocument.images["waitObs"].src = matempono.src;
				});
			}
						
			function checkMenuCarto(ledocument, value, move_camera) {
				var serie = ledocument.getElementById(\'serie\');
				var commune = ledocument.getElementById(\'commune\');
				var formationVegetale = ledocument.getElementById(\'formationVegetale\');
				var opacite = ledocument.getElementById(\'opacite\');
					
				var espece = ledocument.getElementById(\'espece\');
				var communeObs = ledocument.getElementById(\'communeObs\');
				var code_statut = ledocument.getElementById(\'code_statut\');
				var scale = ledocument.getElementById(\'scale\');
					
				if(value == "typeVegetale") {
					serie.disabled = false;
					commune.disabled = false;
					formationVegetale.disabled = false;
					opacite.disabled = false;
						
					espece.disabled = true;
					communeObs.disabled = true;
					code_statut.disabled = true;
					scale.disabled = true;
						
					espece.value = "";
					communeObs.value = "";
					code_statut.value = "";
					scale.value = "0";
						
					ledocument.getElementById(\'nbre_o\').textContent = "Observations affiches : 0";
						
					reload(ledocument, "", serie.value, commune.value, formationVegetale.value, move_camera);
				}
				else if (value == "typeObservation") {
					serie.disabled = true;
					commune.disabled = true;
					formationVegetale.disabled = true;
					opacite.disabled = true;
						
					espece.disabled = false;
					communeObs.disabled = false;
					code_statut.disabled = false;
					scale.disabled = false;
						
					serie.value = "";
					commune.value = "";
					formationVegetale.value = "";
					opacite.value = 5;
					
					ledocument.getElementById(\'nbre_s\').textContent = "Sries affiches : 0";
						
					reloadObs(ledocument, scale.value, espece.value, communeObs.value, code_statut.value, move_camera);
				}
				else if (value == "typeVide") {
					serie.disabled = true;
					commune.disabled = true;
					formationVegetale.disabled = true;
					opacite.disabled = true;
						
					espece.disabled = true;
					communeObs.disabled = true;
					code_statut.disabled = true;
					scale.disabled = true;
					
					ledocument.getElementById(\'nbre_o\').textContent = "Observations affiches : 0";
					ledocument.getElementById(\'nbre_s\').textContent = "Sries affiches : 0";
				}
			}
						
			var ifrMenuCartoHeight;
						
			function toggleMenuCarto(ledocument, targetImg) {
				var titleMenuCarto = ledocument.getElementById(\'title-menu-carto\');
				var ifr = document.getElementById(\'menu-carto\');
				if( ifr.style.height == titleMenuCarto["offsetHeight"] + "px" ) {
					ifr.style.height = ifrMenuCartoHeight;
					targetImg.src = "themes/'.$Default_Theme.'/images/toggle_menu_carto_moins.png";
				}
				else {
					ifrMenuCartoHeight = ifr.style.height;
					ifr.style.height = titleMenuCarto["offsetHeight"] + "px";
					targetImg.src = "themes/'.$Default_Theme.'/images/toggle_menu_carto_plus.png";
				}
			}
							
			function showLimiteCommune(checked) {
				if ( checked ) {
					//montrer les communes
					var hrefKmz = \''.$nukeurl.'/'.$url_data_communes.'\';
					google.earth.fetchKml(ge, hrefKmz, function(kmlObject) {
						if(kmlObjectCommune) {
							//ceci n\'est pas sens arriver
							ge.getFeatures().replaceChild(kmlObject, kmlObjectCommune);
						}
						else {
							if (kmlObject) {
								ge.getFeatures().appendChild(kmlObject);
								/*
								var placemark = ge.getElementById("example_placemark");
								KmlEvent.preventDefault 	( 		)
								*/
								/*ge.addEventListener(kmlObject, "click", function(event) {
								    event.preventDefault();
								    var kmlPlacemark = event.getTarget();
								    alert(kmlPlacemark.getName());
								});*/
							}
						}
						kmlObjectCommune = kmlObject;
					});
				} else {
					//cacher les communes
					ge.getFeatures().removeChild(kmlObjectCommune);
					kmlObjectCommune = null;
				}
			}
							
			function showNameCommune(checked) {
				if ( checked ) {
					ge.getLayerRoot().enableLayerById(ge.LAYER_BORDERS , true);
				}
				else {
					ge.getLayerRoot().enableLayerById(ge.LAYER_BORDERS , false);
				}
			}
		
			function create_formulaire() {
				var ifr = document.createElement("iframe");
				ifr.src= "'.$nukeurl.'/modules.php?name=cbnc_carto3D&sop=getcritsall3d";
				ifr.id = "menu-carto";
				//le mthode ci dessous fonctionne partout sauf sous IE
				/*ifr.srcdoc= \'<html><body style="padding: 0; margin:0;">\'
							+\'<link href="themes/'.$Default_Theme.'/style/style.css" rel="stylesheet" type="text/css" media="all"/>\'
							+\'<link href="themes/'.$Default_Theme.'/style/cbnc_carto3D.css" rel="stylesheet" type="text/css" media="all"/>\'
							+\'<div style="position: absolute; top: 0; left: 0; width: 400px; background-color: #eee;">\'
							+ \'<div style="background-color: #666;color: #fff; text-align: center; padding: 5px 10px; font-weight: bold;">Critres de slection</div>\'
							+ \'<div style="padding: 5px 10px"><form style="margin: 0; padding: 0;">'.str_replace("\r","",str_replace("\n","",str_replace("'", "\\'", $menu_serie))).'<br />'.str_replace("\r","",str_replace("\n","",str_replace("'", "\\'", $menu_commmune))).'<br />'.str_replace("\r","",str_replace("\n","",str_replace("'", "\\'", $menu_opacite))).'</form></div>\'
							+ \'</div>\'
							+\'</body></html>\';*/
				//document.body.scroll = "no";
				ifr.style.position = "absolute";
				ifr.style.top="10px";
				ifr.style.left="10px";
				//ifr.style.backgroundColor="#eee";
				ifr.style.border="1px solid #666";
				ifr.style.width = "425px";
				ifr.style.height = "490px";
				ifr.border="1px solid #f00";
				ifr.frameBorder="0";
				ifr.frameSpacing="0";
				ifr.marginHeight="0";
				ifr.marginWidth="0";
				ifr.style.margin="0";
				ifr.style.padding="0";
				ifr.scrolling="no";
				document.body.appendChild(ifr);
			}
		</script>
		';
	
	echo'
	</head>
	<body style="margin: 0; padding: 0;">
	';
	
	echo '
		<div style="position: absolute; width: 100%; height: 100%; padding: 0; margin:0;"><div id="map3d" style="width: 100%; height: 100%;"></div></div>
		<!--la mthode ci-dessous ne fonctionne que sous firefox-->
		<!--<div style="position: absolute; top: 10px; left: 10px; width: 400px; background-color: #eee; border: 1px solid #666;">
		<div style="background-color: #666;color: #fff; text-align: center; padding: 5px 10px">Critres de slection</div>
		<div style="padding: 5px 10px"><form style="margin: 0; padding: 0;">'.$menu_serie.'<br />'.$menu_commmune.'<br />'.$menu_opacite.'</form></div>
		</div>-->
	';
	echo '
	</body>
</html>';
}

function get_crits_all_3D() {
	global $user_prefix, $db, $module_name, $Default_Theme;
	global $code_status_list, $scale_list;

	$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	$nukeurl = format_nuke_url($nukeurl);

	require_once("modules/SimpleCarto/lib/g_params.php");

	header('Expires: 0');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: no-cache, must-revalidate');
	header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');

	// Vgtale
	$sql = "SELECT DISTINCT nom_serie FROM ".$user_prefix."_cbnc_serie_vegetation WHERE nom_serie<>'' ORDER BY nom_serie ASC";
	$result = $db->sql_query($sql);
	$menu_serie = "";
	if ($db->sql_numrows ( $result ) != 0) {
		if (isIE()) {
			$menu_serie = '<select name="serie" id="serie" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value,this.value,this.form.elements[\'commune\'].value,this.form.elements[\'formationVegetale\'].value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		}
		else {
			$menu_serie = '<select name="serie" id="serie" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.value,this.form.elements[\'commune\'].value,this.form.elements[\'formationVegetale\'].value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		}
		$menu_serie .= '<option value="">Choisissez une srie de vgtation (vgtation potentielle)</option>';
		while (list($nom_serie) = $db->sql_fetchrow ($result)) {
			$nom_serie = str_replace("\"", "&quote;", $nom_serie);
			$menu_serie .= '<option value="'.$nom_serie.'"'.$select.'>'.$nom_serie.'</option>';
		}
		$menu_serie .= '</select>';
	}
	$sql = "SELECT DISTINCT commune FROM ".$user_prefix."_cbnc_serie_vegetation WHERE commune<>'' ORDER BY commune ASC";
	$result = $db->sql_query($sql);
	$menu_commmune = "";
	if ($db->sql_numrows ( $result ) != 0) {
		if (isIE()) {
			$menu_commmune = '<select name="commune" id="commune" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value,this.form.elements[\'serie\'].value,this.value,this.form.elements[\'formationVegetale\'].value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		}
		else {
			$menu_commmune = '<select name="commune" id="commune" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.form.elements[\'serie\'].value,this.value,this.form.elements[\'formationVegetale\'].value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		}
		$menu_commmune .= '<option value="">Choisissez une commune</option>';
		while (list($commune) = $db->sql_fetchrow ($result)) {
			$commune = str_replace("\"", "&quote;", $commune);
			$menu_commmune .= '<option value="'.$commune.'"'.$select.'>'.$commune.'</option>';
		}
		$menu_commmune .= '</select>';
	}
	$sql = "SELECT DISTINCT formation_vegetale FROM ".$user_prefix."_cbnc_serie_vegetation WHERE formation_vegetale<>'' ORDER BY formation_vegetale ASC";
	$result = $db->sql_query($sql);
	$menu_FormationVegetale = "";
	if ($db->sql_numrows ( $result ) != 0) {
		if (isIE()) {
			$menu_FormationVegetale = '<select name="formationVegetale" id="formationVegetale" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value,this.value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		}
		else {
			$menu_FormationVegetale = '<select name="formationVegetale" id="formationVegetale" size="1" onchange="parent.reload(document,this.form.elements[\'opacite\'].value/this.form.elements[\'opacite\'].max,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value,this.value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		}
		$menu_FormationVegetale .= '<option value="">Choisissez une formation vgtale (vgtation actuelle )</option>';
		while (list($formationVegetale) = $db->sql_fetchrow ($result)) {
			$formationVegetale = str_replace("\"", "&quote;", $formationVegetale);
			$menu_FormationVegetale .= '<option value="'.$formationVegetale.'"'.$select.'>'.$formationVegetale.'</option>';
		}
		$menu_FormationVegetale .= '</select>';
	}
	// Observation
	$sql = "SELECT DISTINCT espece FROM ".$user_prefix."_cbnc_serie_observations WHERE espece<>'' ORDER BY espece ASC";
	$result = $db->sql_query($sql);
	$menu_espece = "";
	if ($db->sql_numrows ( $result ) != 0) {
		$menu_espece = '<select name="espece" id="espece" size="1" onchange="parent.reloadObs(document, this.form.elements[\'scale\'].value,this.value,this.form.elements[\'communeObs\'].value,this.form.elements[\'code_statut\'].value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		$menu_espece .= '<option value="">Choisissez une espce</option>';
		while (list($espece) = $db->sql_fetchrow ($result)) {
			$espece = str_replace("\"", "&quote;", $espece);
			$menu_espece .= '<option value="'.$espece.'"'.$select.'>'.$espece.'</option>';
		}
		$menu_espece .= '</select>';
	}
	$sql = "SELECT DISTINCT commune FROM ".$user_prefix."_cbnc_serie_observations WHERE commune<>'' ORDER BY commune ASC";
	$result = $db->sql_query($sql);
	$menu_commmune_obs = "";
	if ($db->sql_numrows ( $result ) != 0) {
		$menu_commmune_obs = '<select name="communeObs" id="communeObs" size="1" onchange="parent.reloadObs(document, this.form.elements[\'scale\'].value, this.form.elements[\'espece\'].value, this.value, this.form.elements[\'code_statut\'].value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		$menu_commmune_obs .= '<option value="">Choisissez une commune</option>';
		while (list($commune) = $db->sql_fetchrow ($result)) {
			$commune = str_replace("\"", "&quote;", $commune);
			$menu_commmune_obs .= '<option value="'.$commune.'"'.$select.'>'.$commune.'</option>';
		}
		$menu_commmune_obs .= '</select>';
	}
	
	$menu_statut = '<select name="code_statut" id="code_statut" size="1" onchange="parent.reloadObs(document, this.form.elements[\'scale\'].value, this.form.elements[\'espece\'].value, form.elements[\'communeObs\'].value, this.value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
	$menu_statut .= '<option value="">Choisissez une catgorie</option>';
	foreach ($code_status_list as $code=>$un_statut) {
		$menu_statut .= '<option value="'.$code.'"'.$select.'>'.$un_statut.'</option>';
	}
	$menu_statut .= '</select>';
	
	// ***************

	if (isIE()) {
		$menu_opacite = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
		<td>Opacit : </td>
		<!--<td align="center"><img src="images/waitno16.gif" name="wait" /></td>-->
		<td align="right" width="290"><select name="opacite" id="opacite" size="1" style="width: 280px" onchange="parent.reload(document,this.value,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value,this.form.elements[\'formationVegetale\'].value, this.form.elements[\'move_camera\'].checked)">
		<option value="1.0">opaque</option>
		<option value="0.75">75 %</option>
		<option value="0.5">50 %</option>
		<option value="0.25">25 %</option>
		<option value="0.0">transparent</option>
		</select></td>
		</tr></table>';
		
		$menu_scale = '<select name="scale" id="scale" size="1" onchange="parent.reloadObs(document, this.value, this.form.elements[\'espece\'].value, form.elements[\'communeObs\'].value, this.form.elements[\'code_statut\'].value, this.form.elements[\'move_camera\'].checked);" style="width: 370px">';
		$menu_scale .= '<option value="">Choisissez une taille de point</option>';
		foreach ($scale_list as $code=>$un_scale) {
			$menu_scale .= '<option value="'.$code.'"'.$select.'>'.$un_scale.'</option>';
		}
		$menu_scale .= '</select>';
	}
	else {
		/*$menu_opacite = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
		<td>Opacit : </td>
		<td align="center"><img src="images/waitno16.gif" name="waitSerie" /></td>
		<td align="right" width="290"><input type="range" id="opacite" name="opacite" value="5" max="5" min="0" style="width: 280px" onchange="parent.reload(document,this.value/this.max,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value,this.form.elements[\'formationVegetale\'].value, this.form.elements[\'move_camera\'].checked)"></td>
		</tr></table>';*/
		
		$menu_opacite = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
		<td>Opacit : </td>
		<td align="right" width="290"><input type="range" id="opacite" name="opacite" value="5" max="5" min="0" style="width: 280px" onchange="parent.reload(document,this.value/this.max,this.form.elements[\'serie\'].value,this.form.elements[\'commune\'].value,this.form.elements[\'formationVegetale\'].value, this.form.elements[\'move_camera\'].checked)"></td>
		</tr></table>';
		
		$menu_scale = '<table border="0" cellpadding="0" cellspacing="0" width="380"><tr>
		<td>Taille de points : </td>
		<td align="right"><input type="range" name="scale" id="scale" value="0" max="2" min="0" style="width: 280px" onchange="parent.reloadObs(document, this.value, this.form.elements[\'espece\'].value, form.elements[\'communeObs\'].value, this.form.elements[\'code_statut\'].value, this.form.elements[\'move_camera\'].checked)"></td>
		</tr></table>';
	}

	echo '<html>
		<head>
			<link href="themes/'.$Default_Theme.'/style/style.css" rel="stylesheet" type="text/css" media="all"/>
			<link href="themes/'.$Default_Theme.'/style/cbnc_carto3D.css" rel="stylesheet" type="text/css" media="all"/>
		</head>
		<body style="padding: 0; margin:0; background-color: #eee;" onload="parent.checkMenuCarto(document, \'typeVide\', false);">
		<div style="position: absolute; top: 0; left: 0; width: 425px; background-color: #eee;">
		<div id="title-menu-carto" style="background-color: #666;color: #fff; text-align: center; padding: 5px 10px; font-weight: bold;font-family:Arial, Helvetica, sans-serif;" >
		Critres de slection
		<img src="themes/'.$Default_Theme.'/images/toggle_menu_carto_moins.png" style="float: right;" onclick="parent.toggleMenuCarto(document, this);" />
		</div>
		<div style="padding: 5px 10px">
		
		<form style="margin: 0; padding: 0;">
		<fieldset><legend><input type="radio" name="typeSelect" value="typeVegetale" id="type-vegetale" onchange="parent.checkMenuCarto(document,this.value, this.form.elements[\'move_camera\'].checked);"><label for="type-vegetale">Vgtation</label></legend>
		'.$menu_serie.'<br />'.$menu_FormationVegetale.'<br />'.$menu_commmune.'<br />'.$menu_opacite.'
		<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td><p style="text-align: center"><span id="nbre_s">Sries affiches : '.get_kmz_nbre().'&nbsp;&nbsp;&nbsp;</span></p></td><td><img src="images/waitno16.gif" name="waitSerie" /></td></tr></table>
		</fieldset>
		
		<fieldset><legend><input type="radio" name="typeSelect" value="typeObservation" id="type-observation" onchange="parent.checkMenuCarto(document,this.value, this.form.elements[\'move_camera\'].checked);"><label for="type-observation">Espce</label></legend>
		'.$menu_espece.'<br />'.$menu_commmune_obs.'<br />'.$menu_statut.'<br />'.$menu_scale.'
		<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td><p style="text-align: center"><span id="nbre_o">Observations affiches : '.get_kmz2_nbre().'&nbsp;&nbsp;&nbsp;</span></p></td><td><img src="images/waitno16.gif" name="waitObs" /></td></tr></table>
		</fieldset>
		
		<div id="optcarto3D">
		<img src="themes/'.$Default_Theme.'/images/LogoCBNCCarto3D.png" align="right" height="70" />
		<input type="checkbox" name="limte_commune" id="limite-commune" onchange="parent.showLimiteCommune(this.checked);" /><label for="limite-commune">Afficher les limites de communes</label><br />
		<input type="checkbox" checked="checked" name="show_name_commune" id="show-name-commune" onchange="parent.showNameCommune(this.checked);" /><label for="show-name-commune">Afficher le nom des zones habites</label><br />
		<input type="checkbox" name="move_camera" id="move_camera" value="1" /><label for="move_camera">Dplacer la camra sur les lieux slectionns</label>
		</div>
		</form>
		
		</div>
		</div>
		</body></html>';
}

function get_kmz_all($opacite=1, $serie="", $commune="", $formationVegetale = "") {
	global $prefix, $db, $uploadFolder, $Default_Theme;

	/*print_r($_SERVER);
	 die($serie."**********".$commune);*/

	$dir_docs_pdf = $uploadFolder."/../cbnc_3D/";

	$dir_docs_zip = $uploadFolder."/../";

	$nom_fichier_source = $dir_docs_zip.md5(date("YmdHis").rand(0, 1000)).".kml";
	$fichier_source = fopen($nom_fichier_source, "w");

	/*fwrite($fichier_source, '<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xsi:schemaLocation="http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd http://www.google.com/kml/ext/2.2 http://code.google.com/apis/kml/schema/kml22gx.xsd">
<Document id="CBNC3D">
  <name>CBNC3D</name>
  <Camera>
	<longitude>8.885291655229542</longitude>
	<latitude>42.374383359824904</latitude>
	<altitude>23124.236158860764</altitude>
	<heading>4.6070186443307275</heading>
	<tilt>37.53844474669251</tilt>
  </Camera>
  <Snippet></Snippet>
  <Folder id="FeatureLayer0">
    <name>Balagne</name>
    <Snippet></Snippet>
    ');*/

	// recherche des series
	$where = "";

	$commune = stripslashes($commune);
	if ($commune != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "commune='".conditionnertodb($commune)."'";
	}
	$serie = stripslashes($serie);
	if ($serie != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "nom_serie='".conditionnertodb($serie)."'";
	}
	$formationVegetale = stripslashes($formationVegetale);
	if ($formationVegetale != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "formation_vegetale='".conditionnertodb($formationVegetale)."'";
	}
	
	//************************ Rcupration du min max ********************************
	//****************************************************************************************************************
	
	$lngMax = "";
	$lngMin = "";
	$latMax = "";
	$latMin = "";
	
	$sql = "SELECT geometrie FROM ".$prefix."_cbnc_serie_vegetation".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$geometrie = $ligne['geometrie'];
			$pattern = '#<coordinates>(.+)</coordinates>#mi';
			if( preg_match_all($pattern, $geometrie, $matches) ) {
				foreach($matches[1] as $matche) {
					$arrayCoordPolygon = explode(" ", $matche);
					foreach($arrayCoordPolygon as $array) {
						$arrayCoord = explode(",", $array);
						if(count($arrayCoord) == 3) {
							if( $lngMax == "" && $lngMin == "" && $latMax == "" && $latMin == "" ) {
								$lngMax = $arrayCoord[0];
								$lngMin = $arrayCoord[0];
								$latMax = $arrayCoord[1];
								$latMin = $arrayCoord[1];
							} else {
								if( $arrayCoord[0] > $lngMax ) {
									$lngMax = $arrayCoord[0];
								} else if( $arrayCoord[0] < $lngMin ) {
									$lngMin = $arrayCoord[0];
								}
								if( $arrayCoord[1] > $latMax ) {
									$latMax = $arrayCoord[1];
								} else if( $arrayCoord[1] < $latMin ) {
									$latMin = $arrayCoord[1];
								}
							}
						}
					}
				}
			}
		}
	}
	
	$lngMoy = ($lngMax+$lngMin)/2;
	$latMoy = ($latMax+$latMin)/2;
	
	$lng = "8.885291655229542";
	$lat = "42.374383359824904";
	$tilt = "37.53844474669251";
	$altitude = "23124.236158860764";
	
	$diffVegetationX = $_COOKIE["diffVegetationX"];
	$diffVegetationY = $_COOKIE["diffVegetationY"];
	
	if( $diffVegetationX == "" && $diffVegetationY == "" ) {
		$diffVegetationX = $lngMoy - $lng;
		$diffVegetationY = $latMoy - $lat;
		setcookie("diffVegetationX", $diffVegetationX);
		setcookie("diffVegetationY", $diffVegetationY);
	}

	if( $lngMoy != 0 && $latMoy != 0 ) {
		$lng = $lngMoy - $diffVegetationX;
		$lat = $latMoy - $diffVegetationY;
		
		$camera = '
  <Camera>
	<longitude>'.$lng.'</longitude>
	<latitude>'.$lat.'</latitude>
	<altitude>'.$altitude.'</altitude>
	<heading>4.6070186443307275</heading>
	<tilt>'.$tilt.'</tilt>
  </Camera>';
	} else {
		$camera = '';
	}
	
	/*
	 * <longitude>8.885291655229542</longitude>
	<latitude>42.374383359824904</latitude>
	 */
	
	/*$dist = $altitude*tan(deg2rad($tilt));
	die();*/
	
	fwrite($fichier_source, '<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xsi:schemaLocation="http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd http://www.google.com/kml/ext/2.2 http://code.google.com/apis/kml/schema/kml22gx.xsd">
<Document id="CBNC3D">
  <name>CBNC3D</name>
  '.$camera.'
  <Snippet></Snippet>
  <Folder id="FeatureLayer0">
    <name>Balagne</name>
    <Snippet></Snippet>
    ');
	
	//****************************************************************************************************************
	

	/**************************
	 * A supprimer en production !  Ce n'est l que pour limiter les dgats en dveloppement !
	**************************/
	//$limit = " LIMIT 0,100";

	$sql = "SELECT id_fiche, nom, nom_serie, statut_natura, commune, formation_vegetale,geometrie, pdf_a, pdf_b, id_style FROM ".$prefix."_cbnc_serie_vegetation".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$statut_natura = "";
			if ($ligne["statut_natura"] != "") {
				$statut_natura = '<tr><td class="label" valign="top">Natura 2000 : </td><td valign="top">'.$ligne["statut_natura"].'</td></tr>';
			}
			$commune = "";
			if ($ligne["commune"] != "") {
				$commune = '<tr><td class="label" valign="top">Commune : </td><td valign="top">'.$ligne["commune"].'</td></tr>';
			}
			$pdf_a = "";
			if ($ligne["pdf_a"] != "") {
				$fichiers = explode(",", $ligne["pdf_a"]);
				if( count($fichiers) > 0 ) {
					if( count($fichiers) > 1 ) {
						$pdf_a .= '<tr><td colspan="2" class="docs" valign="top">Fiches descriptives : ';
					} else {
						$pdf_a .= '<tr><td colspan="2" class="docs" valign="top">Fiche descriptive : ';
					}
					foreach ($fichiers as $fichier) {
						$pdf_a .= '<a href="'.$dir_docs_pdf.$fichier.'" target="_blank"><img src="themes/'.$Default_Theme.'/images/icon_pdf.png" alt="pdf" height="16" align="absmiddle" /></a>';
					}
					$pdf_a .= '</td></tr>';
				}
				/*foreach ($fichiers as $fichier) {
					$pdf_a .= '<tr><td valign="top">Fiche descriptive : </td><td valign="top"><a href="'.$dir_docs_pdf.$fichier.'" target="_blank">Cliquez ici</a></td></tr>';
				}*/
			}
			$pdf_b = "";
			if ($ligne["pdf_b"] != "") {
				$fichiers = explode(",", $ligne["pdf_b"]);
				if( count($fichiers) > 0 ) {
					if( count($fichiers) > 1 ) {
						$pdf_b .= '<tr><td colspan="2" class="docs" valign="top">Fiches descriptives : ';
					} else {
						$pdf_b .= '<tr><td colspan="2" class="docs" valign="top">Fiche descriptive : ';
					}
					foreach ($fichiers as $fichier) {
						$pdf_b .= '<a href="'.$dir_docs_pdf.$fichier.'" target="_blank"><img src="themes/'.$Default_Theme.'/images/icon_pdf.png" alt="pdf" height="16" align="absmiddle" /></a>';
					}
					$pdf_b .= '</td></tr>';
				}
				/*foreach ($fichiers as $fichier) {
					$pdf_b .= '<tr><td valign="top">Fiche descriptive : </td><td valign="top"><a href="'.$dir_docs_pdf.$fichier.'" target="_blank">Cliquez ici</a></td></tr>';
				}*/
			}
			$laserie = '<Placemark id="'.$ligne["id_fiche"].'">
      <name>'.$ligne["nom"].'</name>
      <Snippet></Snippet>
      <description><![CDATA[<html xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head>
<body style="margin:0px 0px 0px 0px;overflow:auto;background:#FFFFFF;">
<table border="0" cellpadding="0" cellspacing="0" class="bulle">
<tr><td colspan="2" class="titre">'.$ligne["nom_serie"].'</td></tr>
'.$pdf_a.'
<tr><td colspan="2" class="titre">'.$ligne["formation_vegetale"].'</td></tr>
'.$pdf_b.'
'.$statut_natura.'
'.$commune.'
</table>
</body>

</html>
]]></description>
      <styleUrl>#'.$ligne["id_style"].'</styleUrl>
      <MultiGeometry>
        '.$ligne["geometrie"].'
      </MultiGeometry>
    </Placemark>';
			fwrite($fichier_source, $laserie);
		}
	}

	fwrite($fichier_source, '</Folder>
	');
	//conversion opacite
	$opacite = ($opacite=="") ? $opacite=1 : $opacite;
	$opacite = str_pad(dechex($opacite*255),2,"0",STR_PAD_LEFT);

	// recherche des styles
	$sql = "SELECT id_style, content FROM ".$prefix."_cbnc_serie_vegetation_styles;";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes2");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
				
			$ligne["content"] = str_replace("<color>ff", "<color>".$opacite, $ligne["content"]);
				
			$lestyle = '<Style id="'.$ligne["id_style"].'">
    '.$ligne["content"].'
  </Style>';
			fwrite($fichier_source, $lestyle);
		}
	}

	fwrite($fichier_source, '</Document>
</kml>');

	fclose($fichier_source);


	$nom_fichier_dest = $dir_docs_zip.md5(date("YmdHis").rand(0, 1000)).".kmz";
	$zip = new ZipArchive();
	if ($zip->open($nom_fichier_dest, ZipArchive::CREATE) === true) {
		$zip->addFile($nom_fichier_source, "CBNC_3D.kml");
		$zip->close();
	}
	else {
		die("erreur compression");
	}
	header('Content-type: application/vnd.google-earth.kmz');

	header('Expires: 0');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: no-cache, must-revalidate');
	header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');

	readfile($nom_fichier_dest);
	unlink($nom_fichier_source);
	unlink($nom_fichier_dest);
}

function get_kmz2_all($scale="", $espece="", $commune="", $code_statut="") {
	global $prefix, $db, $uploadFolder;
	global $code_status_list;

	$dir_docs_pdf = $uploadFolder."/../cbnc_3D/";

	$dir_docs_zip = $uploadFolder."/../";


	$nom_fichier_source = $dir_docs_zip.md5(date("YmdHis").rand(0, 1000))."_points.kml";
	$fichier_source = fopen($nom_fichier_source, "w");

	/*fwrite($fichier_source, '<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xsi:schemaLocation="http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd http://www.google.com/kml/ext/2.2 http://code.google.com/apis/kml/schema/kml22gx.xsd">
<Document id="CBNC3DPOINTS">
  <name>CBNC3DPOINTS</name>
  <Camera>
	<longitude>8.885291655229542</longitude>
	<latitude>42.374383359824904</latitude>
	<altitude>23124.236158860764</altitude>
	<heading>4.6070186443307275</heading>
	<tilt>37.53844474669251</tilt>
  </Camera>
  <Snippet></Snippet>
  <Folder id="FeatureLayer0">
    <name>Balagne_Points</name>
    <Snippet></Snippet>
    ');*/

	// recherche des series
	$where = "";

	$commune = stripslashes($commune);
	if ($commune != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "commune='".conditionnertodb($commune)."'";
	}
	$espece = stripslashes($espece);
	if ($espece != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "espece='".conditionnertodb($espece)."'";
	}
	$code_statut = stripslashes($code_statut);
	if ($code_statut != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "code_statut='".conditionnertodb($code_statut)."'";
	}

	//************************ Rcupration du min max ********************************
	//****************************************************************************************************************
	
	$lngMax = ""; 
	$lngMin = "";
	$latMax = "";
	$latMin = "";

	$sql = "SELECT geometrie FROM ".$prefix."_cbnc_serie_observations".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$geometrie = $ligne['geometrie'];
			$pattern = '#<coordinates>(.+)</coordinates>#mi';
			if( preg_match($pattern, $geometrie, $matches) ) {
				//$xml .= '<coordinates>'.$matches[0].'</coordinates>';
				$coordinate = array();
				$arrayCoord = explode(",", $matches[1]);
				if(count($arrayCoord) == 3) {
					/*echo "lng : " . $arrayCoord[0] ."<br />";
					echo "lat : " . $arrayCoord[1] ."<br />";
					echo "alt : " . $arrayCoord[2] ."<br />";*/
					if( $lngMax == "" && $lngMin == "" && $latMax == "" && $latMin == "" ) {
						$lngMax = $arrayCoord[0];
						$lngMin = $arrayCoord[0];
						$latMax = $arrayCoord[1];
						$latMin = $arrayCoord[1];
					} else {
						if( $arrayCoord[0] > $lngMax ) {
							$lngMax = $arrayCoord[0];
						} else if( $arrayCoord[0] < $lngMin ) {
							$lngMin = $arrayCoord[0];
						}
						if( $arrayCoord[1] > $latMax ) {
							$latMax = $arrayCoord[1];
						} else if( $arrayCoord[1] < $latMin ) {
							$latMin = $arrayCoord[1];
						}
					}
					/*$coordinate["lng"] = $arrayCoord[0];
					$coordinate["lat"] = $arrayCoord[1];
					$coordinate["alt"] = $arrayCoord[2];
					array_push($coordinates, $coordinate);*/
				}
			}
		}
	}
	
	$lngMoy = ($lngMax+$lngMin)/2;
	$latMoy = ($latMax+$latMin)/2;
	
	$lng = "8.885291655229542";
	$lat = "42.374383359824904";
	$tilt = "37.53844474669251";
	$altitude = "23124.236158860764";
	
	$diffObsX = $_COOKIE["diffObsX"];
	$diffObsY = $_COOKIE["diffObsY"];
	
	if( $diffObsX == "" && $diffObsY == "" ) {
		$diffObsX = $lngMoy - $lng;
		$diffObsY = $latMoy - $lat;
		setcookie("diffObsX", $diffObsX);
		setcookie("diffObsY", $diffObsY);
	}
	
	if( $lngMoy != 0 && $latMoy != 0 ) {
		$lng = $lngMoy - $diffObsX;
		$lat = $latMoy - $diffObsY;
		$camera = '
  <Camera>
	<longitude>'.$lng.'</longitude>
	<latitude>'.$lat.'</latitude>
	<altitude>'.$altitude.'</altitude>
	<heading>4.6070186443307275</heading>
	<tilt>'.$tilt.'</tilt>
  </Camera>';
	} else {
		$camera = '';
	}
	
	/*
	 * <longitude>8.885291655229542</longitude>
	<latitude>42.374383359824904</latitude>
	*/
	
	/*$dist = $altitude*tan(deg2rad($tilt));
	die();*/
	
	fwrite($fichier_source, '<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xsi:schemaLocation="http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd http://www.google.com/kml/ext/2.2 http://code.google.com/apis/kml/schema/kml22gx.xsd">
<Document id="CBNC3D">
  <name>CBNC3D</name>
  '.$camera.'
  <Snippet></Snippet>
  <Folder id="FeatureLayer0">
    <name>Balagne</name>
    <Snippet></Snippet>
    ');
	
	//****************************************************************************************************************

	/**************************
	 * A supprimer en production !  Ce n'est l que pour limiter les dgats en dveloppement !
	**************************/
	//$limit = " LIMIT 0,1000";

	$sql = "SELECT id,id_fiche, nom, date_obs, obs1, obs2, obs3, commune, espece, latitude, longitude, protection, frequence ,endemique, famille, nom_vernaculaire, photo, credits_photos, pdf, code_statut, statut, id_style, geometrie FROM ".$prefix."_cbnc_serie_observations".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$ligne["date_obs"] = date2JMA($ligne["date_obs"]);
			$espece = "";
			if ($ligne["espece"] != "") {
				$espece = '<tr><td colspan="2" class="titre titreObs">'.$ligne["espece"].'</td></tr>';
			}
			$nom_vernaculaire= "";
			if ($ligne["nom_vernaculaire"] != "") {
				$nom_vernaculaire = '<tr><td colspan="2" class="vernaculaire" ><div>'.$ligne["nom_vernaculaire"].'</div></td></tr>';
			}
			$famille = "";
			if ($ligne["famille"] != "") {
				$famille = '<tr><td class="label" valign="top">Famille : </td><td valign="top">'.$ligne["famille"].'</td></tr>';
			}
			$frequence = "";
			if ($ligne["frequence"] != "") {
				$frequence = '<tr><td class="label" valign="top">'.utf8_encode('Frquence en Corse').' : </td><td valign="top">'.$ligne["frequence"].'</td></tr>';
			}
			$endemique = "";
			if ($ligne["endemique"] != "") {
				$endemique = '<tr><td class="label" valign="top">'.utf8_encode('Endmisme').' : </td><td valign="top">'.$ligne["endemique"].'</td></tr>';
			}
			$observateurs = "";
			if (trim($ligne["obs1"].$ligne["obs2"].$ligne["obs3"]) != "") {
				$observateurs = '<tr><td class="label" valign="top">Observateur(s) : </td><td valign="top">';
				$observateurs .= ((trim($ligne["obs1"] != "") ? "&bull; ":"" )).trim($ligne["obs1"]);
				$observateurs .= (trim($ligne["obs1"].$ligne["obs2"]) != "") ?  "<br>" : "";
				$observateurs .= ((trim($ligne["obs2"] != "") ? "&bull; ":"" )).trim($ligne["obs2"]);
				$observateurs .= (trim($ligne["obs2"].$ligne["obs3"]) != "") ?  "<br>" : "";
				$observateurs .= ((trim($ligne["obs3"] != "") ? "&bull; ":"" )).trim($ligne["obs3"]);
				$observateurs .= '</td></tr>';
			}
			$date = "";
			if ($ligne["date_obs"] != "") {
				$date = '<tr><td class="label" valign="top">Date d\'observation : </td><td valign="top">'.$ligne["date_obs"].'</td></tr>';
			}
			$commune = "";
			if ($ligne["commune"] != "") {
				$commune = '<tr><td class="label" valign="top">Commune : </td><td valign="top">'.$ligne["commune"].'</td></tr>';
			}
			$statut = "";
			if ($ligne["code_statut"] != "") {
				$statut = '<tr><td class="label" valign="top">'.utf8_encode('Catgorie').' : </td><td valign="top">'.utf8_encode($code_status_list[$ligne["code_statut"]]).'</td></tr>';
			}
			$pdf = "";
			if ($ligne["pdf"] != "") {
				$fichiers = explode(",", $ligne["pdf"]);
				foreach ($fichiers as $fichier) {
					$pdf .= '<tr><td class="label" valign="top">Plus d\'infos : </td><td valign="top"><a href="'.$dir_docs_pdf.$fichier.'" target="_blank">Cliquez ici</a></td></tr>';
				}
			}
			$prephoto = "";
			$postphoto = "";
			if ($ligne["photo"] != "") {
				$prephoto .= '<table border="0" cellpadding="0" cellspacing="0">'.$espece.'<tr><td valign="top">';
				$espece = '';
				$postphoto .= '</td><td valign="top">';
				$postphoto .= '<table border="0" cellpadding="0" cellspacing="0">';
				/*
				if (strtolower(substr(strrchr($ligne["photo"], '.'), 1)) == "") {
					$ligne["photo"] .= ".jpg";
				}
				$postphoto .= '<tr><td><a href="'.$dir_docs_pdf.$ligne["photo"].'" target="_blank"><img src="'.$dir_docs_pdf.$ligne["photo"].'" width="200"></a></td></tr>';
				*/
				$postphoto .= '<tr><td><a href="modules.php?name=cbnc_carto3D&sop=photowatermark&id='.$ligne["id"].'8&size=2000" target="_blank"><img src="modules.php?name=cbnc_carto3D&sop=photowatermark&id='.$ligne["id"].'8&size=200" width="200"></a></td></tr>';
				if ($ligne["credits_photos"] != "") {
					//$postphoto .= '<tr><td>&nbsp;</td></tr>';
					$postphoto .= '<tr><td class="credits">'.$ligne["credits_photos"].'</td></tr>';
				}
				$postphoto .= '</table>';
				$postphoto .= '</td></tr></table>';
			}

			$laserie = '<Placemark id="'.$ligne["id_fiche"].'">
      <name>'.$ligne["nom"].'</name>
      <Snippet></Snippet>
      <description><![CDATA[<html xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head>
<body style="margin:0px 0px 0px 0px;overflow:auto;background:#FFFFFF;">
'.$prephoto.'
<table border="0" cellpadding="0" cellspacing="0" class="infos">
'.$espece.'
'.$nom_vernaculaire.'
'.$famille.'
'.$observateurs.'
'.$date.'
'.$commune.'
'.$frequence.'
'.$endemique.'
'.$statut.'
'.$pdf.'
</table>
'.$postphoto.'
</body>

</html>
]]></description>
      <styleUrl>#'.$ligne["id_style"].'</styleUrl>
      <Point>
        '.$ligne["geometrie"].'
      </Point>
    </Placemark>';
			fwrite($fichier_source, $laserie);
		}
	}

	fwrite($fichier_source, '</Folder>
	');


	// recherche des styles
	$sql = "SELECT id_style, content FROM ".$prefix."_cbnc_serie_observation_styles;";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes2");
	}
	if ($db->sql_numrows($result) > 0) {
		$fichiers = array();
		while ($ligne = $db->sql_fetchrow($result)) {
			if (preg_match_all("#<href>(.*)</href>#im", $ligne["content"], $matches)) {
				foreach($matches[1] as $fichier) {
					$fichiers[] = $fichier;				}
			}
			if ($scale != "") {
				$valscale = $scale*0.12+0.25;
				$ligne["content"] = str_replace("<scale>0.25", "<scale>".$valscale, $ligne["content"]);
			}
			$lestyle = '<Style id="'.$ligne["id_style"].'">
    '.$ligne["content"].'
  </Style>';
			fwrite($fichier_source, $lestyle);
		}
	}
	fwrite($fichier_source, '</Document>
</kml>');
	fclose($fichier_source);

	$fichiers_uniques = array_unique($fichiers);
	//$fichiers_uniques contient la liste des fichiers  ajouter  l'achive kmz pour que les styles soient compris -> les png dans les cas prsent
	$nom_fichier_dest = $dir_docs_zip.md5(date("YmdHis").rand(0, 1000)).".kmz";
	$zip = new ZipArchive();
	if ($zip->open($nom_fichier_dest, ZipArchive::CREATE) === true) {
		foreach ($fichiers_uniques as $lasource) {
			if (file_exists($dir_docs_pdf.$lasource)) {
				$zip->addFile($dir_docs_pdf.$lasource, $lasource);
			}
		}
		$zip->addFile($nom_fichier_source, "CBNC_3D_OBS.kml");
		$zip->close();
	}
	else {
		die("erreur compression");
	}
	header('Content-type: application/vnd.google-earth.kmz');

	header('Expires: 0');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: no-cache, must-revalidate');
	header("Cache-Control: post-check=0,pre-check=0");
	header("Cache-Control: max-age=0");
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Pragma: no-cache');

	readfile($nom_fichier_dest);
	unlink($nom_fichier_source);
	unlink($nom_fichier_dest);
}

/**
 * Fonction permettant de retourner un xml contenant le min et max de la latitude et longitude des poloygones (NON UTILISE)
 * @param number $opacite
 * @param string $serie
 * @param string $commune
 * @param string $formationVegetale
 */
function get_xml_min_max_all($opacite=1, $serie="", $commune="", $formationVegetale = "") {
	global $prefix, $db;
	
	$xml = '<?xml version="1.0" encoding="UTF-8"?>';

	// recherche des series
	$where = "";

	$commune = stripslashes($commune);
	if ($commune != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "commune='".conditionnertodb($commune)."'";
	}
	$serie = stripslashes($serie);
	if ($serie != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "nom_serie='".conditionnertodb($serie)."'";
	}
	$formationVegetale = stripslashes($formationVegetale);
	if ($formationVegetale != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "formation_vegetale='".conditionnertodb($formationVegetale)."'";
	}


	/**************************
	 * A supprimer en production !  Ce n'est l que pour limiter les dgats en dveloppement !
	**************************/
	//$limit = " LIMIT 0,100";
	
	$lngMax = "";
	$lngMin = "";
	$latMax = "";
	$latMin = "";
	
	$xml .= '<carto_options>';

	$sql = "SELECT geometrie FROM ".$prefix."_cbnc_serie_vegetation".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$geometrie = $ligne['geometrie'];
			$pattern = '#<coordinates>(.+)</coordinates>#mi';
			if( preg_match_all($pattern, $geometrie, $matches) ) {
				foreach($matches[1] as $matche) {
					$arrayCoordPolygon = explode(" ", $matche);
					foreach($arrayCoordPolygon as $array) {
						$arrayCoord = explode(",", $array);
						if(count($arrayCoord) == 3) {
							if( $lngMax == "" && $lngMin == "" && $latMax == "" && $latMin == "" ) {
								$lngMax = $arrayCoord[0];
								$lngMin = $arrayCoord[0];
								$latMax = $arrayCoord[1];
								$latMin = $arrayCoord[1];
							} else {
								if( $arrayCoord[0] > $lngMax ) {
									$lngMax = $arrayCoord[0];
								} else if( $arrayCoord[0] < $lngMin ) {
									$lngMin = $arrayCoord[0];
								}
								if( $arrayCoord[1] > $latMax ) {
									$latMax = $arrayCoord[1];
								} else if( $arrayCoord[1] < $latMin ) {
									$latMin = $arrayCoord[1];
								}
							}
						}
					}
				}
			}
		}
	}
	
	$xml .= '<lat_max>'.$latMax.'</lat_max>';
	$xml .= '<lat_min>'.$latMin.'</lat_min>';
	$xml .= '<lng_max>'.$lngMax.'</lng_max>';
	$xml .= '<lng_min>'.$lngMin.'</lng_min>';
	$xml .= '</carto_options>';
	echo $xml;
}

/**
 * Fonction permettant de retourner un xml contenant le min et max de la latitude et longitude des points (NON UTILISE)
 * @param string $scale
 * @param string $espece
 * @param string $commune
 * @param string $code_statut
 */
function get_xml_obs_min_max($scale="", $espece="", $commune="", $code_statut="") {
	global $prefix, $db;
	
	$xml = '<?xml version="1.0" encoding="UTF-8"?>';

	// recherche des series
	$where = "";

	$commune = stripslashes($commune);
	if ($commune != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "commune='".conditionnertodb($commune)."'";
	}
	$espece = stripslashes($espece);
	if ($espece != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "espece='".conditionnertodb($espece)."'";
	}
	$code_statut = stripslashes($code_statut);
	if ($code_statut != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "code_statut='".conditionnertodb($code_statut)."'";
	}


	/**************************
	 * A supprimer en production !  Ce n'est l que pour limiter les dgats en dveloppement !
	**************************/
	//$limit = " LIMIT 0,1000";
	
	//$coordinates = array();
	$lngMax = ""; 
	$lngMin = "";
	$latMax = "";
	$latMin = "";
	
	$xml .= '<carto_options>';

	$sql = "SELECT geometrie FROM ".$prefix."_cbnc_serie_observations".$where.$limit.";";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		while ($ligne = $db->sql_fetchrow($result)) {
			$ligne = array_map('utf8_encode', $ligne);
			$geometrie = $ligne['geometrie'];
			$pattern = '#<coordinates>(.+)</coordinates>#mi';
			if( preg_match($pattern, $geometrie, $matches) ) {
				//$xml .= '<coordinates>'.$matches[0].'</coordinates>';
				$coordinate = array();
				$arrayCoord = explode(",", $matches[1]);
				if(count($arrayCoord) == 3) {
					/*echo "lng : " . $arrayCoord[0] ."<br />";
					echo "lat : " . $arrayCoord[1] ."<br />";
					echo "alt : " . $arrayCoord[2] ."<br />";*/
					if( $lngMax == "" && $lngMin == "" && $latMax == "" && $latMin == "" ) {
						$lngMax = $arrayCoord[0];
						$lngMin = $arrayCoord[0];
						$latMax = $arrayCoord[1];
						$latMin = $arrayCoord[1];
					} else {
						if( $arrayCoord[0] > $lngMax ) {
							$lngMax = $arrayCoord[0];
						} else if( $arrayCoord[0] < $lngMin ) {
							$lngMin = $arrayCoord[0];
						}
						if( $arrayCoord[1] > $latMax ) {
							$latMax = $arrayCoord[1];
						} else if( $arrayCoord[1] < $latMin ) {
							$latMin = $arrayCoord[1];
						}
					}
					/*$coordinate["lng"] = $arrayCoord[0];
					$coordinate["lat"] = $arrayCoord[1];
					$coordinate["alt"] = $arrayCoord[2];
					array_push($coordinates, $coordinate);*/
				}
			}
		}
	}
	
	$xml .= '<lat_max>'.$latMax.'</lat_max>';
	$xml .= '<lat_min>'.$latMin.'</lat_min>';
	$xml .= '<lng_max>'.$lngMax.'</lng_max>';
	$xml .= '<lng_min>'.$lngMin.'</lng_min>';
	$xml .= '</carto_options>';
	echo $xml;
}

function show_carto() {
	global $sitename, $user_prefix, $db, $admin, $module_name, $_headerContent, $Default_Theme;
	global $currentlang;
	global $cbnccarto3Dpageaccueil;
	
	//require_once("modules/SimpleCarto/lib/g_params.php");
	//require_once("modules/$module_name/system/utils.php");
	
	$_headerContent .= '
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/alphacube.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_dialogue(titre,url) {
	
		var largeur = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
		var hauteur = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
	
		win = new Window({className: "alphacube", title: titre, width:Math.floor(largeur*0.9), height:Math.floor(hauteur*0.9), destroyOnClose: true, recenterAuto:true, url: url, minimizable: false, maximizable: false, zIndex: 10000});
		win.showCenter(true);
	}
</script>
	
';

	if($cbnccarto3Dpageaccueil == "") {
		$sortie .= '<h1>Atlas de la flore remarquable de Balagne</h1>
<p>Dans le cadre du SCOT de Balagne, de l\'Agenda 21 et du programme national de cartographie des habitats, le Conservatoire Botanique National de Corse a fourni un effort particulirement important de prospection de la flore et de la vgtation.
Ce travail, toujours en cours, sera enrichi chaque anne par des donnes complmentaires. Nous avons le plaisir de le mettre ds aujourd\'hui  disposition du public.</p>
<p>Cet Atlas est prsent sous la forme d\'une cartographie en 3D qui utilise le plug-in Google Earth.
Si celui-ci n\'est pas encore install sur votre poste de travail, n\'hsitez pas  autoriser son installation au dbut de la consultation.
<h2>Sries de vgtation</h2>
<p>En cliquant sur les zones colories, un petit dialogue apparatra.
Il affichera quelques informations sur la zone choisie, et vous donnera accs  des documents plus dtaills</p>
<p>&nbsp;</p>';
		$sortie .= '<p style="text-align: center"><a href="javascript:ouvre_dialogue(\'Cartographie 3D : cliquez sur les lments pour obtenir des dtails\',\'modules.php?name='.$module_name.'&sop=getmap3d\')" title="Voir l\'Atlas">Dmarrer la consultation de l\'Atlas</a></p>';
		
		$sortie .= '<p>&nbsp;</p>';
		
		$sortie .= '<h2>Observation d\'espces</h2>
<p>En cliquant sur les points, un petit dialogue apparatra.
Il affichera quelques informations sur l\'observation choisie, et vous donnera accs  des documents plus dtaills</p>
<p>&nbsp;</p>';
		$sortie .= '<p style="text-align: center"><a href="javascript:ouvre_dialogue(\'Cartographie 3D : cliquez sur les points pour obtenir des dtails\',\'modules.php?name='.$module_name.'&sop=getmapobs3d\')" title="Voir l\'Atlas">Dmarrer la consultation de l\'Atlas</a></p>';
		$sortie .= '<p style="text-align: center"><a href="javascript:ouvre_dialogue(\'Cartographie 3D\',\'modules.php?name='.$module_name.'&sop=getmapall3d\')" title="Voir l\'Atlas">Dmarrer la consultation de l\'Atlas</a></p>';
	} else {
		require_once("modules/Sections/connector_class.php");
		$sectmodule = new pageconnector();
		$sortie .= $sectmodule->getPageContent($cbnccarto3Dpageaccueil,"", true);
	}
	
    include ('header.php');
    echo $sortie;
    $bardef=array(//"print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back"=>"javascript:window.history.back();",
            "top"=>"#top" );
	buttonBar($bardef, "align");
    include ('footer.php');
}

function get_kmz_nbre($serie="", $commune="", $formationVegetale = "") {
	global $prefix, $db;
	
	$where = "";

	$commune = stripslashes($commune);
	if ($commune != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "commune='".conditionnertodb($commune)."'";
	}
	$serie = stripslashes($serie);
	if ($serie != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "nom_serie='".conditionnertodb($serie)."'";
	}
	$formationVegetale = stripslashes($formationVegetale);
	if ($formationVegetale != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "formation_vegetale='".conditionnertodb($formationVegetale)."'";
	}
	
	$sql = "SELECT COUNT(id) as nbre FROM ".$prefix."_cbnc_serie_vegetation".$where.";";
	$result = $db->sql_query($sql);
	list($nbre) = $db->sql_fetchrow($result);
	return number_format($nbre, 0, ",", " ");
}

function get_kmz2_nbre($espece="", $commune="", $code_statut="") {
	global $prefix, $db;
	
	$where = "";
	
	$commune = stripslashes($commune);
	if ($commune != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "commune='".conditionnertodb($commune)."'";
	}
	$espece = stripslashes($espece);
	if ($espece != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "espece='".conditionnertodb($espece)."'";
	}
	$code_statut = stripslashes($code_statut);
	if ($code_statut != "") {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "code_statut='".conditionnertodb($code_statut)."'";
	}
	
	$sql = "SELECT COUNT(id) as nbre FROM ".$prefix."_cbnc_serie_observations".$where.";";
	$result = $db->sql_query($sql);
	list($nbre) = $db->sql_fetchrow($result);
	return number_format($nbre, 0, ",", " ");
}

function showphotowatermak($id,$size="") {
	global $prefix, $db, $uploadFolder, $Default_Theme;
	global $galleryfilewatermak;

	$dir_docs_pdf = $uploadFolder."/../cbnc_3D/";

	$sql = "SELECT photo FROM ".$prefix."_cbnc_serie_observations WHERE id='".$id."';";
	$result = $db->sql_query($sql);
	if (!$result) {
		die("Erreur de base de donnes");
	}
	if ($db->sql_numrows($result) > 0) {
		if (list($photo) = $db->sql_fetchrow($result)) {
			if (strtolower(substr(strrchr($photo, '.'), 1)) == "") {
				$photo .= ".jpg";
			}
			$photo = $dir_docs_pdf.$photo;
			if (!isset($size)) {
				$size = getimagesize($photo);
				$width = $size[0];
				$height = $size[1];
			}
			else {
				$width = $size;
				$height = 2 * $width;
			}
			$galleryfilewatermak = "themes/".$Default_Theme."/images/watermark.png";
			imgResizerWatermark($photo,$width, $height);
		}
	}
}

switch ($sop) {
	case "getkmz2nbre":
		echo get_kmz2_nbre($espece,$commune,$code_statut);
		break;
	case "getkmz2" :
		get_kmz2($scale,$espece,$commune,$code_statut);
		break;
	case "getxmlobsminmax" :
		get_xml_obs_min_max($scale,$espece,$commune,$code_statut);
		break;
	case "getmapobs3d":
		get_map_obs_3D();
		break;
	case "getcritsobs3d":
		get_crits_obs_3D();
		break;
	
	case "getkml" :
		get_kml();
		break;
	case "getkmz" :
		get_kmz($opacite,$serie,$commune);
		break;
	case "getkmz2all" :
		get_kmz2_all($scale,$espece,$commune,$code_statut);
		break;
	case "getmap3d":
		get_map_3D();
		break;
	case "getcrits3d":
		get_crits_3D();
		break;
	case "getxmlminmaxall" :
		get_xml_min_max_all($opacite,$serie,$commune);
		break;
	case "getmapall3d":
		get_map_all_3D();
		break;
	case "getcritsall3d":
		get_crits_all_3D();
		break;
	case "getkmznbre":
		echo get_kmz_nbre($serie,$commune,$formation_vegetale);
		break;
	case "getkmzall" :
		get_kmz_all($opacite,$serie,$commune,$formation_vegetale);
		break;
		
	case "showcarto":
		show_carto();
		break;
	
	case "photowatermark":
		showphotowatermak($id,$size);
		break;
		
	case "map_itineraires" :
		display_map_symbol_itineraires ($theme);
		break;
	case "map_pict_XML_itineraires" :
		get_map_pict_XML_itineraires ( $theme, $circuit, $rech );
		break;
	case "map_fiche_itineraire" :
		display_map_symbol_fiche_itineraire ( $idItineraire );
		break;
	case "map_pict_XML_fiche_itineraire" :
		get_map_pict_XML_fiche_itineraire ( $idItineraire );
		break;
	case "fiche_site":
		display_map_symbol_fiche_site($idSite);
		break;
	case "map_pict_XML_fiche_site" :
		get_map_pict_XML_fiche_site ( $idSite );
		break;
	default :
		display_menu ();
		break;
}
?>