<?php 
if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/" . $module_name . "/system/params.php");
require_once("modules/$module_name/utils.php");

function get_map_itineraires($typeItineraire="fini") {
    global $db, $prefix;
	global $name_table_itineraire;
	
	if ($typeItineraire == "fini") {
	   $entravaux = "0";   
	}
	else {
	   $entravaux = "1";   
	}
	    
	
	$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];
    $serveur = $protocol.$domainName.'/';
	
	$r = new stdClass();
	
	$r->error = "";
	$r->result = "";
	
	/*{"type":"FeatureCollection","features":[{"type":"Feature","properties":{},"geometry":{"type":"Point","coordinates":[8.929124999999999,42.064005]}}]}*/
	
	$tab_features = array();
	
	$sql = "SELECT * FROM `".$prefix.$name_table_itineraire."` WHERE en_travaux='".$entravaux."' AND geom_centre <> '';";
	$results = $db->sql_query ($sql);
	if ($db->sql_numrows ($results) != 0) {
	    while ($ligne = $db->sql_fetchrow ($results)) {
	        if ($ligne["geom_centre"] != "") {
    	        $feature = new stdClass();
    	        
    	        $geojson = json_decode($ligne["geom_centre"],false);
    	        
    	        $feature->type = "Feature";
    	        $feature->geometry = $geojson->features[0]->geometry;
    	        
    	        $properties = new stdClass();
    	        
    	        $properties->id = $ligne["id"];
    	        
    	        $nom_sent = new stdClass();
    	        $nom_sent->fr = utf8_encode($ligne["nom_french"]);
    	        $nom_sent->co = utf8_encode($ligne["nom_corsican"]);
    	        $nom_sent->it = utf8_encode($ligne["nom_italian"]);
    	        $nom_sent->uk = utf8_encode($ligne["nom_english"]);
    	        $properties->nom_sentier = $nom_sent;
    	        
    	        if ($ligne["id_album"] > 0) {
    	            $sql = "SELECT photo_file FROM ".$prefix."_gallery_photo WHERE photo_albumid='".$ligne["id_album"]."' ORDER BY photo_album DESC;";
    	            $results2 = $db->sql_query($sql);
                    if ($db->sql_numrows($results2) != 0) {
                        if ($ligne2 = $db->sql_fetchrow($results2)) {
                            $properties->vignette = utf8_encode($serveur.$ligne2["photo_file"]);
                        }
                    }
                    else {
                        $properties->vignette = "";
                    }
    	        }
    	        else {
    	            $properties->vignette = "";
    	        }
    	        
    	        $feature->properties = $properties;
    	        
    	        $tab_features[] = $feature;
	        }
	    }
	}
    
	$feature_collection = new stdClass();
	
	$feature_collection->type = "FeatureCollection";
	$feature_collection->features = $tab_features;
	
	$r->result = $feature_collection;
	
	$tab_features;
	
	$sortie = json_encode($r); 
	
	header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
	echo $sortie;	
}

function display_itineraires($typeItineraire = '') {
	global $module_name, $_headerContent, $currentlang;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $lienFicheItineraire, $icon_plus_infos;
	global $Default_Theme_mobile;
	global $Default_Theme, $btn_retour;
	
	if (file_exists('themes/'.$Default_Theme_mobile.'/btn_retour.php')) {
	    require_once('themes/'.$Default_Theme_mobile.'/btn_retour.php');
	}
	
	$_headerContent = '
        <link rel="stylesheet" href="javascripts/leaflet/leaflet.css" />
        <link rel="stylesheet" href="javascripts/leaflet.fullscreen/leaflet.fullscreen.css" />
        <script src="javascripts/leaflet/leaflet.js"></script>
        <script src="javascripts/leaflet.fullscreen/Leaflet.fullscreen.js"></script>';

	setHeader($_headerContent);
	
	$btn_langues = '
            <div id="block_selectlang">
				<img src="themes/sdpweb/images/btn_francais.png" alt="Franais" id="btn_french" style="display: none">
                <img src="themes/sdpweb/images/btn_corse.png" alt="Corse" id="btn_corsican" style="display: none">
                <img src="themes/sdpweb/images/btn_italien.png" alt="Italien" id="btn_italian" style="display: none">
                <img src="themes/sdpweb/images/btn_anglais.png" alt="Anglais" id="btn_english" style="display: none">
			</div>'
	
	;
	
	if ($typeItineraire == "trav") {
		$sortie = '
			<h1 id="titre">Les sentiers en travaux<br/><span style="font-size: smaller; font-style: italic">I sentieri in lavori</span></h1>
			<p> &nbsp;</p>
			<p style="text-align: center;" class="block_french">Cette carte prsente les itinraires en phase de ralisation.<br />Vous pourrez accder aux informations disponibles et  l\'tat d\'avancement de ces sentiers en cliquant sur les pictogrammes disposs sur la carte.</p>
			<p style="text-align: center;font-style: italic;" class="block_italian">Questa carta presenta gli itinerari in fase di realizzazione.<br />Potrete accedere alle informazioni disponibili ed ai progressi di questi sentieri premendo sui pittogrammi disposti sulla carta.</p>
			<p> &nbsp;</p>
			<div class="sdp">
				<div id="map"></div>
				<p>&nbsp;</p>
				<div id="obs"></div>
			</div>';
	}
	else {
	    require_once ("modules/Sections/connector_class.php");
	    $pages = new pageconnector ();
	    $sortie .= $pages->getPageContent(190, "", true);
	    $sortie = addslashes($sortie);
		$sortie = "\$sortie=\"".$sortie."\";";
		eval($sortie);
		$sortie = stripslashes($sortie);
	}
	
	if (file_exists('themes/'.$Default_Theme.'/btn_retour.php')) {
	    require_once('themes/'.$Default_Theme.'/btn_retour.php');
	    $sortie .= $btn_retour;
	}
	
	$sortie .= '<script src="modules/sdp/lib/lib_carto_itineraires.js"></script>';
	
	include ('header_mobile.php');
	echo utilFuncs_sdp::conditionnerMobile($sortie);

	include ('footer_mobile.php');
}

function get_map_itineraire($id) {
    global $db, $prefix;
	global $name_table_itineraire, $name_table_site;
	
	$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];
    $serveur = $protocol.$domainName.'/';
	
	$r = new stdClass();
	
	$r->error = "";
	$r->result = "";
	
	/*{"type":"FeatureCollection","features":[{"type":"Feature","properties":{},"geometry":{"type":"Point","coordinates":[8.929124999999999,42.064005]}}]}*/
	
	$tab_features = array();
	
	$sql = "SELECT * FROM `".$prefix.$name_table_itineraire."` WHERE id='".$id."';";
	$results = $db->sql_query ($sql);
	if ($db->sql_numrows ($results) != 0) {
	    while ($itineraire = $db->sql_fetchrow ($results)) {
	        if ($itineraire["geom"] != "") {
    	        $geojson = json_decode($itineraire["geom"],false);
    	        foreach($geojson->features as $lafeature) {
    	        
        	        $feature = new stdClass();
        	        
        	        $feature->type = "Feature";
        	        $feature->geometry = $lafeature->geometry;
        	        
        	        $properties = new stdClass();
        	        
        	        $properties->id = $itineraire["id"];
        	        
        	        $nom_sent = new stdClass();
        	        $nom_sent->fr = utf8_encode($itineraire["nom_french"]);
        	        $nom_sent->co = utf8_encode($itineraire["nom_corsican"]);
        	        $nom_sent->it = utf8_encode($itineraire["nom_italian"]);
        	        $nom_sent->uk = utf8_encode($itineraire["nom_english"]);
        	        $properties->nom_sentier = $nom_sent;
        	        
        	        if ($itineraire["id_album"] > 0) {
        	            $sql = "SELECT photo_file FROM ".$prefix."_gallery_photo WHERE photo_albumid='".$itineraire["id_album"]."' ORDER BY photo_album DESC;";
        	            $results2 = $db->sql_query($sql);
                        if ($db->sql_numrows($results2) != 0) {
                            if ($ligne2 = $db->sql_fetchrow($results2)) {
                                $properties->vignette = utf8_encode($serveur.$ligne2["photo_file"]);
                            }
                        }
                        else {
                            $properties->vignette = "";
                        }
        	        }
        	        else {
        	            $properties->vignette = "";
        	        }
        	        
        	        $feature->properties = $properties;
        	        
        	        $tab_features[] = $feature;
    	        }
	        }
	        
	        $sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE id_itineraire='".$id."';";
        	$results3 = $db->sql_query ($sql);
        	if ($db->sql_numrows ($results3) != 0) {
        	    while ($site = $db->sql_fetchrow ($results3)) {
        	        if ($site["geom_centre"] != "") {
            	        $feature = new stdClass();
            	        
            	        $geojson = json_decode($site["geom_centre"],false);
    	        
            	        $feature->type = "Feature";
            	        $feature->geometry = $geojson->features[0]->geometry;
            	        
            	        $properties = new stdClass();
    	        
            	        $properties->id = $site["id"];
            	        
            	        $nom_site = new stdClass();
            	        $nom_site->fr = utf8_encode($site["nom_french"]);
            	        $nom_site->co = utf8_encode($site["nom_corsican"]);
            	        $nom_site->it = utf8_encode($site["nom_italian"]);
            	        $nom_site->uk = utf8_encode($site["nom_english"]);
            	        $properties->nom_site = $nom_site;
            	        
            	        if ($site["id_album"] > 0) {
            	            $sql = "SELECT photo_file FROM ".$prefix."_gallery_photo WHERE photo_albumid='".$site["id_album"]."' ORDER BY photo_album DESC;";
            	            $results4 = $db->sql_query($sql);
                            if ($db->sql_numrows($results4) != 0) {
                                if ($ligne2 = $db->sql_fetchrow($results4)) {
                                    $properties->vignette = utf8_encode($serveur.$ligne2["photo_file"]);
                                }
                            }
                            else {
                                $properties->vignette = "";
                            }
            	        }
            	        else {
            	            $properties->vignette = "";
            	        }
            	       
            	        $feature->properties = $properties;
            	        
            	        $tab_features[] = $feature;
        	        }
        	    }
        	}
	    }
	}
    
	$feature_collection = new stdClass();
	
	$feature_collection->type = "FeatureCollection";
	$feature_collection->features = $tab_features;
	
	$r->result = $feature_collection;
	
	$tab_features;
	
	$sortie = json_encode($r); 
	
	header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
	echo $sortie;	
}

function display_itineraire($id_itineraire) {
	global $db, $prefix, $module_name, $_headerContent;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $lienFicheItineraire, $icon_plus_infos;
	global $Default_Theme_mobile, $name_table_itineraire;
	global $gallerywithwatermak;
	global $Default_Theme, $btn_retour;
	
	$_headerContent = '
        <link rel="stylesheet" href="javascripts/leaflet/leaflet.css" />
        <link rel="stylesheet" href="javascripts/leaflet.fullscreen/leaflet.fullscreen.css" />
        <script src="javascripts/leaflet/leaflet.js"></script>
        <script src="javascripts/leaflet.fullscreen/Leaflet.fullscreen.js"></script>
        <script>
            var map_options = {
                id_itineraire: '.$id_itineraire.'
            }
        </script>
        <link rel="stylesheet" href="themes/sdpweb/style/jquery.fancybox.min.css" />
        <link rel="stylesheet" href="themes/sdpweb/style/becmsGallery.css" />
';

	setHeader($_headerContent);
	
	$btn_langues = '
            <div id="block_selectlang">
				<img src="themes/sdpweb/images/btn_francais.png" alt="Franais" id="btn_french" style="display: none">
                <img src="themes/sdpweb/images/btn_corse.png" alt="Corse" id="btn_corsican" style="display: none">
                <img src="themes/sdpweb/images/btn_italien.png" alt="Italien" id="btn_italian" style="display: none">
                <img src="themes/sdpweb/images/btn_anglais.png" alt="Anglais" id="btn_english" style="display: none">
			</div>'
	
	;
	
	$sql = "SELECT * FROM `".$prefix.$name_table_itineraire."` WHERE `id`=".$id_itineraire;
	$search = $db->sql_query($sql);
	if ($db->sql_numrows($search) != 0) {
	    $itineraire = $db->sql_fetchrow($search);
	    
	    /* test langues prsentes */
	    $tab_langues_test = array("french", "corsican", "italian", "english");
	    $tab_rubriques_test = array("nom_","description_", "difficulte_", "etat_");
	    
	    $tab_text_langue = array();
	    
	    $tab_langues = array();
	    
	    foreach($tab_rubriques_test as $rubrique) {
	        foreach($tab_langues_test as $langue) {
	            $tab_text_langue[$langue] .= $itineraire[$rubrique.$langue];
	        }
	    }
	    
	    foreach ($tab_text_langue as $langue => $valeur) {
	        if (!utilFuncs_sdp::test_texte_vide($valeur)) {
	            $tab_langues[] = $langue;
	        }
	    }
	    
	    $blocs = array();
	    
	    $dico = array(
	        "french" => array(
	            "commune" => "COMMUNE : ",
	            "longueur" => "LONGUEUR DU PARCOURS : ",
	            "difficulte" => "NIVEAU DE DIFFICULT : ",
	            "etat" => "TAT DU SENTIER : ",
	            "visite" => "VISITE VIRTUELLE 360",
	            "avis" => "AVIS D'EXPERT : ",
	            "album" => "ALBUM PHOTO DU SENTIER : "
	        ),
	        "corsican" => array(
	            "commune" => "MUNICIPALIT : ",
	            "longueur" => "DURATA DI CORSU : ",
	            "difficulte" => "NIVELLU DI DIFFICULT : ",
	            "etat" => "CUNDIZIONE DI TRAIL : ",
	            "visite" => "VISITA VIRTUALE 360",
	            "avis" => "CUNSIGLIU DI SPERI : ",
	            "album" => "FOTO ALBUM DI A PISTA : "
	        ),
	        "italian" => array(
	            "commune" => "COMUNE: ",
	            "longueur" => "LUNGHEZZA DEL CORSO: ",
	            "difficulte" => "LIVELLO DI DIFFICOLT: ",
	            "etat" => "CONDIZIONE DEL SENTIERO: ",
	            "visite" => "VISITA VIRTUALE A 360",
	            "avis" => "PARERE DELL'ESPERTO: ",
	            "album" => "ALBUM FOTOGRAFICO DEL PERCORSO: "
	        ),
	        "english" => array(
	            "commune" => "MUNICIPALITY: ",
	            "longueur" => "LENGTH OF THE COURSE: ",
	            "difficulte" => "LEVEL OF DIFFICULTY: ",
	            "etat" => "STATE OF THE PATH: ",
	            "visite" => "360 VIRTUAL VISIT",
	            "avis" => "EXPERT'S OPINION: ",
	            "album" => "PHOTO ALBUM OF THE TRAIL: "
	        ),
	    );
	    
	    foreach($tab_langues as $langue) {
	        $blocs[0][$langue] = '<div class="block_'.$langue.'">';
	        $blocs[0][$langue] .= '<h2>'.get_text_langue($itineraire, "nom_", $langue).'</h2>';
	        $blocs[0][$langue] .= '<hr>';
	        $blocs[0][$langue] .= '</div>';
	        
	        $blocs[1][$langue] .= '<div class="block_'.$langue.'">';
	        $blocs[1][$langue] .= '<span class="inline">';
	        $blocs[1][$langue] .= ($itineraire["commune"] != "") ? '<span class="titre_rubrique">'.$dico[$langue]["commune"].'</span>'.$itineraire["commune"].'<br />' : '';
	        $blocs[1][$langue] .= ($itineraire["longueur"] != "") ? '<span class="titre_rubrique">'.$dico[$langue]["longueur"].'</span>'.$itineraire["longueur"].'<br />' : '';
	        $blocs[1][$langue] .= (get_text_langue($itineraire, "difficulte_", $langue) != "") ? '<span class="titre_rubrique">'.$dico[$langue]["difficulte"].'</span>'.get_text_langue($itineraire, "difficulte_", $langue).'<br />' : '';
	        $blocs[1][$langue] .= (get_text_langue($itineraire, "etat_", $langue) != "") ? '<span class="titre_rubrique">'.$dico[$langue]["etat"].'</span>'.get_text_langue($itineraire, "etat_", $langue) : '';
	        $blocs[1][$langue] .= '</span>';
	        $blocs[1][$langue] .= '</div>';
	        
	        $blocs[2][$langue] .= '<div class="block_'.$langue.'">';
	        $blocs[2][$langue] .= get_text_langue($itineraire, "description_", $langue);
	        $blocs[2][$langue] .= '</div>';
	        
	        $blocs[3][$langue] .= '<div id="btn_visite" class="block_'.$langue.'">';
	        $blocs[3][$langue] .= $dico[$langue]["visite"];
	        $blocs[3][$langue] .= '</div>';
	        
	        $blocs[4][$langue] .= '<div class="block_'.$langue.'">';
	        $blocs[4][$langue] .= (!utilFuncs_sdp::test_texte_vide($itineraire["commentaire"]) ? '<div class="marges_bloc ta__center"><span class="inline"><span class="titre_rubrique">'.$dico[$langue]["avis"].'</span>'.$itineraire["commentaire"].'</span></div>' : "");
	        $blocs[4][$langue] .= '</div>';
	    }

	    $btn_visite = "";
	    if ($itineraire["visite"] != "") {
	        $btn_visite = '<div class="marges_bloc ta__center"><a href="'.$itineraire["visite"].'" target="_blank">'.join("", $blocs[3]).'</a></div>';
	    }
	    
	    if ($itineraire["id_album"] != 0) {
	
        	$result = $db->sql_query("select albumid, album_name, album_desc, album_city, album_address, album_postalcode, album_communeid, album_theme_id, album_place, album_lat_wgs84, album_long_wgs84, album_withwm, album_public from ".$prefix."_gallery_album where albumid='".$itineraire["id_album"]."'");
        	if (!$result) {
        		$my_message= $db->sql_error();
        		die('Invalid query:'.$my_message['message']);
        	}
        	list($albumid, $album_name, $album_desc, $album_city, $album_address, $album_postalcode, $album_communeid, $album_theme_id, $album_place, $album_lat_wgs84, $album_long_wgs84, $album_withwm, $album_public)= $db->sql_fetchrow($result);
        	
        	$resultph = $db->sql_query("select photo_id, photo_name, photo_comments, photo_date_year, photo_file, photo_owner from ".$prefix."_gallery_photo where photo_albumid='$albumid' order by photo_album DESC, photo_name ASC;");
        	$sortie_list = "";
        	$auteurs = array();
        	$albumsizeonephoto = 1024;
        	while(list( $photo_id, $photo_name, $photo_comments, $photo_date_year, $photo_file, $photo_owner) = $db->sql_fetchrow($resultph)) {
        		if ($gallerywithwatermak == "1" || $album_withwm=="1") {
        			$idpict = '$imgfile="'.$photo_file.'";$max_width='.$albumsizeonephoto.';$max_height='.$albumsizeonephoto.";";
        			$chiffre = str_chiffrer($idpict);
        			$chiffre = rawurlencode($chiffre);
        			$resizedImg="modules.php?name=becmsGallery&sop=ResizerWatermark&idpict=$chiffre";
        			$photopouralbum = '<a href="'.$resizedImg.'"  data-fancybox="images" data-caption="'.str_replace('"', '&quot;', $photo_name).'" style="background-image: url(\''.$resizedImg.'\'); background-size: cover; background-position: center center; cursor: zoom-in"> </a>';
        			/*$idpict = '$imgfile="../../'.$photo_file.'";$max_width=110;$max_height=110;';
        			$chiffre = str_chiffrer($idpict);
        			$chiffre = rawurlencode($chiffre);
        			$tumbImg="modules/$module_name/resizer_big.php?idpict=$chiffre";*/
        		}
        		else {
        			
        			$vignette = 'modules.php?name=becmsGallery&sop=Cropper&imgfile='.$photo_file.'&max_width=584&max_height=390';
        			//$vignette = 'modules/'.$module_name.'&sop=Cropper&imgfile='.$photo_file.'&max_width=584&max_height=390';
        			//$photopouralbum = '<a href="'.$photo_file.'" title="'.str_replace('"', '&quot;', $photo_name).'" data-gallery style="background-image: url(\''.$photo_file.'\'); background-size: cover; background-position: center center; cursor: zoom-in"> <img src="'.$photo_file.'" style="display: none"></a>';
        			$idpict = '$imgfile="'.$photo_file.'";$max_width='.$albumsizeonephoto.';$max_height='.$albumsizeonephoto.";";
        			$chiffre = str_chiffrer($idpict);
        			$chiffre = rawurlencode($chiffre);
        			$resizedImg="modules.php?name=becmsGallery&sop=Resizer&idpict=$chiffre";
        			$photopouralbum = '<a href="'.$resizedImg.'"  data-fancybox="images" data-caption="'.str_replace('"', '&quot;', $photo_name).'" style="background-image: url(\''.$vignette.'\'); background-size: cover; background-position: center center; background-repeat: no-repeat; cursor: zoom-in"> </a>';
        		}
        		$sortie_list .= '<li style="background-color: #ccc">'.$photopouralbum.'</li>';
        		if ($photo_owner != "" && !in_array($photo_owner, $auteurs)) {
        			$auteurs[] = $photo_owner;
        		}
        	}
        	if ($sortie_list != "") {
        		$sortie_list = '<ul id="galerie_photo">'.$sortie_list.'</ul>';
        	}
        	
        	$les_photos = $sortie_list;
	    }
	    else {
	        $les_photos = "";
	    }
	    
	    /*$sortie = '
		<div class="corps flexAround">
            <div style="flex-direction:column;" class="containerCorps flex center">
                '.join("", $blocs[0]).'
                <div style="background-color: #ccc">
                    <div class="container">
                        <div class="row">
                            <div class="grid_6">
                                '.join("", $blocs[1]).'
                            </div>
                            <div class="grid_6">
                                '.join("", $blocs[2]).'
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-container">
                    <div class="Bloc">
                    '.join("", $blocs[1]).'
                    </div>
                    <div class="Bloc">
                    '.join("", $blocs[2]).'
                    </div>
                </div>
                <div id="map"></div>
            </div>
        </div>';*/
	    
	    $sortie = '
		<div class="container">
            <div class="row">
                <div class="grid_12">
                <div class="marges_h">'.join("", $blocs[0]).'</div>
                '.$btn_langues.'
                </div>
            </div>
            <div class="row fond_gris_clair"> 
                <div class="grid_6">
                    <div class="marges_bloc">
                        <div class="bloc_infos_plus espace_v_lines">
                            '.join("", $blocs[1]).'
                        </div>
                    </div>
                </div>
                <div class="grid_6 nospace">
                    <div class="marges_bloc">
                        '.join("", $blocs[2]).'
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="grid_12">
                        '.$btn_visite.'
                    <div id="map"></div>
                    '.join("", $blocs[4]).'
                    '.$les_photos.'
                </div>
            </div>
        </div>';
	}
		
	if (file_exists('themes/'.$Default_Theme.'/btn_retour.php')) {
	    require_once('themes/'.$Default_Theme.'/btn_retour.php');
	    $sortie .= $btn_retour;
	}
	
	$sortie .= '<script src="modules/sdp/lib/lib_carto_itineraire.js"></script>
                <script src="themes/sdpweb/js/jquery.fancybox.min.js"></script>';
	
	include ('header_mobile.php');
	echo utilFuncs_sdp::conditionnerMobile($sortie);
	include ('footer_mobile.php');
}

function get_map_site($id) {
    global $db, $prefix;
	global $name_table_itineraire, $name_table_site;
	
	$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];
    $serveur = $protocol.$domainName.'/';
	
	$r = new stdClass();
	
	$r->error = "";
	$r->result = "";
	
	/*{"type":"FeatureCollection","features":[{"type":"Feature","properties":{},"geometry":{"type":"Point","coordinates":[8.929124999999999,42.064005]}}]}*/
	
	$tab_features = array();
	        
    $sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE id='".$id."';";
	$results3 = $db->sql_query ($sql);
	if ($db->sql_numrows ($results3) != 0) {
	    while ($site = $db->sql_fetchrow ($results3)) {
	        if ($site["geom_centre"] != "") {
    	        $feature = new stdClass();
    	        
    	        $geojson = json_decode($site["geom_centre"],false);
        
    	        $feature->type = "Feature";
    	        $feature->geometry = $geojson->features[0]->geometry;
    	        
    	        $properties = new stdClass();
               
    	        $feature->properties = $properties;
    	        
    	        $tab_features[] = $feature;
    	        
    	        $sql = "SELECT * FROM `".$prefix.$name_table_itineraire."` WHERE id='".$site["id_itineraire"]."';";
            	$results = $db->sql_query ($sql);
            	if ($db->sql_numrows ($results) != 0) {
            	    while ($itineraire = $db->sql_fetchrow ($results)) {
            	        if ($itineraire["geom"] != "") {
                	        $geojson = json_decode($itineraire["geom"],false);
                	        
                	        foreach($geojson->features as $lafeature) {
                    	        $feature = new stdClass();
                    	        
                    	        $feature->type = "Feature";
                    	        $feature->geometry = $lafeature->geometry;
                    	        
                    	        $properties = new stdClass();
                    	        
                    	        $feature->properties = $properties;
                    	        
                    	        $tab_features[] = $feature;
                	        }
            	        }
            	    }
            	}
	        }
	    }	    
	}
    
	$feature_collection = new stdClass();
	
	$feature_collection->type = "FeatureCollection";
	$feature_collection->features = $tab_features;
	
	$r->result = $feature_collection;
	
	$tab_features;
	
	$sortie = json_encode($r); 
	
	header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
	echo $sortie;	
}

function display_site($id_site) {
	global $db, $prefix, $module_name, $_headerContent;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $lienFicheItineraire, $icon_plus_infos;
	global $Default_Theme_mobile, $name_table_itineraire, $name_table_site;
	global $gallerywithwatermak;
	global $Default_Theme, $btn_retour;
	
	$_headerContent = '
        <link rel="stylesheet" href="javascripts/leaflet/leaflet.css" />
        <link rel="stylesheet" href="javascripts/leaflet.fullscreen/leaflet.fullscreen.css" />
        <script src="javascripts/leaflet/leaflet.js"></script>
        <script src="javascripts/leaflet.fullscreen/Leaflet.fullscreen.js"></script>
        <script>
            var map_options = {
                id_site: '.$id_site.'
            }
        </script>
        <link rel="stylesheet" href="themes/sdpweb/style/jquery.fancybox.min.css" />
        <link rel="stylesheet" href="themes/sdpweb/style/becmsGallery-.css" />
';

	setHeader($_headerContent);
	    
	
	$btn_langues = '
            <div id="block_selectlang">
				<img src="themes/sdpweb/images/btn_francais.png" alt="Franais" id="btn_french" style="display: none">
                <img src="themes/sdpweb/images/btn_corse.png" alt="Corse" id="btn_corsican" style="display: none">
                <img src="themes/sdpweb/images/btn_italien.png" alt="Italien" id="btn_italian" style="display: none">
                <img src="themes/sdpweb/images/btn_anglais.png" alt="Anglais" id="btn_english" style="display: none">
			</div>'
	
	;
	
	$sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE `id`=".$id_site;
	$search = $db->sql_query($sql);
	if ($db->sql_numrows($search) != 0) {
	    $site = $db->sql_fetchrow($search);
	    
	    $geom_centre = json_decode($site["geom_centre"], true);
	    $tab_coords = $geom_centre["features"][0]["geometry"]["coordinates"];
	    
	    /* test langues prsentes */
	    $tab_langues_test = array("french", "corsican", "italian", "english");
	    $tab_rubriques_test = array("nom_","description_", "difficulte_", "etat_");
	    
	    $tab_text_langue = array();
	    
	    $tab_langues = array();
	    
	    foreach($tab_rubriques_test as $rubrique) {
	        foreach($tab_langues_test as $langue) {
	            $tab_text_langue[$langue] .= $site[$rubrique.$langue];
	        }
	    }
	    
	    foreach ($tab_text_langue as $langue => $valeur) {
	        if (!utilFuncs_sdp::test_texte_vide($valeur)) {
	            $tab_langues[] = $langue;
	        }
	    }
	    
	    $blocs = array();
	    
	    $dico = array(
	        "french" => array(
	            "latitude" => "LATITUDE : ",
	            "longitude" => "LONGITUDE : ",
	            "album" => "ALBUM PHOTO DU SITE : "
	        ),
	        "corsican" => array(
	            "latitude" => "LATITUDINE : ",
                "longitude" => "LONGITUDINE : ",
                "album" => "ALBUM FOTOGRAFICU DI U SITU :"
	        ),
	        "italian" => array(
	            "latitudine" => "LATITUDINE: ",
	            "longitudine" => "LONGITUDINE: ",
	            "album" => "LOCATION PHOTO ALBUM: "
	        ),
	        "english" => array(
	            "latitude" => "LATITUDE: ",
	            "longitude" => "LONGITUDE: ",
	            "album" => "LOCATION PHOTO ALBUM: "
	        ),
	    );
	    
	    
	    foreach($tab_langues as $langue) {
	        $blocs[0][$langue] = '<div class="block_'.$langue.'">';
	        $blocs[0][$langue] .= '<h2>'.get_text_langue($site, "nom_", $langue).'</h2>';
	        $blocs[0][$langue] .= '<hr>';
	        $blocs[0][$langue] .= '</div>';
	        
	        $blocs[1][$langue] .= '<div class="block_'.$langue.'">';
	        $blocs[1][$langue] .= '<span class="inline">';
	        $blocs[1][$langue] .= '<span class="titre_rubrique">'.$dico[$langue]["latitude"].'</span>'.$tab_coords[1].'<br />';
	        $blocs[1][$langue] .= '<span class="titre_rubrique">'.$dico[$langue]["longitude"].'</span>'.$tab_coords[0];
	        $blocs[1][$langue] .= '</span>';
	        $blocs[1][$langue] .= '</div>';
	        
	        $blocs[2][$langue] .= '<div class="block_'.$langue.'">';
	        $blocs[2][$langue] .= get_text_langue($site, "description_", $langue);
	        $blocs[2][$langue] .= '</div>';
	    }
	    
	    $album = "";
	    
	    $tab_photos = array();
	    
	    if ($site["id_album"] != 0) {
	
        	$result = $db->sql_query("select albumid, album_name, album_desc, album_city, album_address, album_postalcode, album_communeid, album_theme_id, album_place, album_lat_wgs84, album_long_wgs84, album_withwm, album_public from ".$prefix."_gallery_album where albumid='".$site["id_album"]."'");
        	if (!$result) {
        		$my_message= $db->sql_error();
        		die('Invalid query:'.$my_message['message']);
        	}
        	list($albumid, $album_name, $album_desc, $album_city, $album_address, $album_postalcode, $album_communeid, $album_theme_id, $album_place, $album_lat_wgs84, $album_long_wgs84, $album_withwm, $album_public)= $db->sql_fetchrow($result);
        	
        	$resultph = $db->sql_query("select photo_id, photo_name, photo_comments, photo_date_year, photo_file, photo_owner from ".$prefix."_gallery_photo where photo_albumid='$albumid' order by photo_album DESC, photo_name ASC;");
        	$albumsizeonephoto = 1024;
        	while(list( $photo_id, $photo_name, $photo_comments, $photo_date_year, $photo_file, $photo_owner) = $db->sql_fetchrow($resultph)) {
        		if ($gallerywithwatermak == "1" || $album_withwm=="1") {
        			$idpict = '$imgfile="'.$photo_file.'";$max_width='.$albumsizeonephoto.';$max_height='.$albumsizeonephoto.";";
        			$chiffre = str_chiffrer($idpict);
        			$chiffre = rawurlencode($chiffre);
        			$resizedImg="modules.php?name=becmsGallery&sop=ResizerWatermark&idpict=$chiffre";
        			/*$photopouralbum = '<a href="'.$resizedImg.'"  data-fancybox="images" data-caption="'.str_replace('"', '&quot;', $photo_name).'" style="background-image: url(\''.$resizedImg.'\'); background-size: cover; background-position: center center; cursor: zoom-in"> </a>';
        			$idpict = '$imgfile="../../'.$photo_file.'";$max_width=110;$max_height=110;';
        			$chiffre = str_chiffrer($idpict);
        			$chiffre = rawurlencode($chiffre);
        			$tumbImg="modules/$module_name/resizer_big.php?idpict=$chiffre";*/
        		}
        		else {
        			$vignette = 'modules.php?name=becmsGallery&sop=Cropper&imgfile='.$photo_file.'&max_width=584&max_height=390';
        			//$vignette = 'modules/'.$module_name.'&sop=Cropper&imgfile='.$photo_file.'&max_width=584&max_height=390';
        			//$photopouralbum = '<a href="'.$photo_file.'" title="'.str_replace('"', '&quot;', $photo_name).'" data-gallery style="background-image: url(\''.$photo_file.'\'); background-size: cover; background-position: center center; cursor: zoom-in"> <img src="'.$photo_file.'" style="display: none"></a>';
        			$idpict = '$imgfile="'.$photo_file.'";$max_width='.$albumsizeonephoto.';$max_height='.$albumsizeonephoto.";";
        			$chiffre = str_chiffrer($idpict);
        			$chiffre = rawurlencode($chiffre);
        			$resizedImg="modules.php?name=becmsGallery&sop=Resizer&idpict=$chiffre";
        			//$photopouralbum = '<a href="'.$resizedImg.'"  data-fancybox="images" data-caption="'.str_replace('"', '&quot;', $photo_name).'" style="background-image: url(\''.$vignette.'\'); background-size: cover; background-position: center center; background-repeat: no-repeat; cursor: zoom-in"> </a>';
        		}
        		$tab_photos[] = array(
        		    "url" => $resizedImg,
        		    "legende" => $photo_name
        		);
        	}
	    }
	    if (count($tab_photos) > 0 ) {
            $album = '<div class="gal-bigone">
                    <a href="'.$tab_photos[0]['url'].'" data-fancybox="images" data-caption="'.$tab_photos[0]['legende'].'" style="background-image:url(\''.$tab_photos[0]['url'].'\');">
                    </a>
                </div>';
            
            array_splice($tab_photos,0,1);
            
            if (count($tab_photos) > 0 ) {
            //images suivantes
                $album .='<ul id="galerie_photo">';
                foreach($tab_photos as $imageData){
                    $album .='<li style="background-color: #ccc;">
                                <a href="'.$imageData['url'].'"
                                    data-fancybox="images"
                                    data-caption="'.str_replace('"', '&quot;', utf8_decode($imageData['legende'])).'"
                                    style="background-image:url(\''.$imageData['url'].'\')">
                                </a></li>';            
                }
                $album .='</ul>';
            }
        }
	    
        $sortie = '
		<div class="container">
            <div class="row">
                <div class="grid_12">
                <div class="marges_h">'.join("", $blocs[0]).'</div>
                '.$btn_langues.'
                
                <div class="marges_h">'.join("", $blocs[2]).'</div>
                </div>
            </div>
            <div class="row fond_gris_clair"> 
                <div class="grid_6 first_nospace">
                    <div id="mini_map"></div>
                    <div class="marges_bloc">
                        <div class="bloc_infos_plus espace_v_lines">
                            '.join("", $blocs[1]).'
                        </div>
                    </div>
                </div>
                <div class="grid_6" style="margin-left: 0">
                    '.$album.'
                </div>
            </div>
        </div>';  
	}
		
	$sortie .= '<script src="modules/sdp/lib/lib_carto_site.js"></script>
                <script src="themes/sdpweb/js/jquery.fancybox.min.js"></script>';
	
	if (file_exists('themes/'.$Default_Theme.'/btn_retour.php')) {
	    require_once('themes/'.$Default_Theme.'/btn_retour.php');
	    $sortie .= $btn_retour;
	}
	
	include ('header_mobile.php');
	echo utilFuncs_sdp::conditionnerMobile($sortie);
	include ('footer_mobile.php');
}

function get_text_langue($fiche, $rubrique, $langue) {
    $retour = "";
    if (utilFuncs_sdp::test_texte_vide($fiche[$rubrique.$langue])) {
        $retour = $fiche[$rubrique."french"];
    }
    else {
        $retour = $fiche[$rubrique.$langue];
    }
    return $retour;
}

switch($sop) {
    case "get_map_itineraires" :
        get_map_itineraires($ti);
        break;
    case "get_map_itineraire" :
        get_map_itineraire($idItineraire);
        break;
    case "get_map_site" :
        get_map_site($idSite);
        break;
    case "map_fiche_site":
        display_site($idSite);
        break;
    case "map_fiche_itineraire":
        display_itineraire($idItineraire);
        break;
    case "map_itineraires":
    default:
        display_itineraires($ti);
        break;
}

?>