<?php
/**
 * Classes des fonctions utiles.
 *
 * Elles sont dans une classe pour les isoler des autres fonctions.
 * @package becmsSimpleAnnonce
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

/**
 * Classe des fonctions.
 *
 * Cette clase contient galement les fonctions utiles (conversion de date, ...).
 * @package becmsSimpleAnnonce
 */
class utilFuncs_sdp {
	/**
	 * Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}
	function anti_conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("''","'",stripslashes($texte)));
	}
	
	function trimtodb($texte) {
		//$texte = utf8_encode($texte);
		return trim($texte);
	}
	function majusUn($texte) {
		//$texte = utf8_encode($texte);
		return ucfirst($texte);
	}

	/**
	 * Prpare les donnes  tre affiches en HTML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}

	/**
	 * Prpare les donnes  tre envoyes aux procdures Javascript.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}

	/**
	 * Prpare les donnes  tre incluses dans les formulaires.
	 * @param string $texte Texte  prparer
	 * @return string texte encod.
	 */
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',stripslashes($texte)));
	}

	/**
	 * Remplace une donne nulle ou vide par zero.
	 * @param string $valeur Valeur  tester.
	 * @return integer Valeur ou zero.
	 */
	function notVide($valeur) {
		if ($valeur == "") {
			return 0;
		}
		else {
			return $valeur;
		}
	}
	/**
	 * Prpare les donnes  tre exportes en XML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerXML($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		$texte = utf8_encode($texte);
		return $texte;
	}
	
	function conditionnerMobile($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		//$texte = html_entity_decode($texte,ENT_QUOTES,"ISO-8859-1");
		$texte = utf8_encode($texte);
		return $texte;
	}

	/**
	 * Convertit une date du format Anne-Mois-Jour (SQL) au format Jour/Mois/Anne (Franais).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2JMA($ladate, $formatdate="d/m/Y H:i:s"){
		if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($lejour,$lemoment) = explode(" ",$ladate);
			list($an,$mois,$jour) = explode("-",$lejour);
			if ($lemoment != "") {
				list($heure, $minute,$seconde) = explode(":", $lemoment);
			}
			else {
				list($heure, $minute,$seconde) = array(0,0,0);
			}
			$ladate = date($formatdate, mktime($heure, $minute,$seconde, $mois,$jour,$an));
			return $ladate;
			//return preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#i","\\3/\\2/\\1",$ladate);
		}
	}

	/**
	 * Convertit une date du format Jour/Mois/Anne (Franais) au format Anne-Mois-Jour (SQL).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00 00:00:00";
		}
		else {
			list ($ladate,$lheure) = explode(" ",$ladate);
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		if ($lheure != "") {
			$lheure = " ".$lheure;
		}
		return "$annee-$mois-$jour$lheure";
	}
	
	function send_email($email, $from, $subject, $message, $return=""){
		global $vars_mail;
		// En-ttes
		$headers = "From: ".$from."\n";
		$headers .= "X-Sender: ".$from."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".($return == "" ? $from : $return)."\n";
		$headers .= "Reply-To: ".($return == "" ? $from : $return)."\n";
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
		return mail($email, $subject, $message, $headers);
	}
	
	function normaliser($chaine) {
		$from = ' ';
		$to = 'aaaaaaaaaaaaaacceeeeeeeeiiiiiiiinnoooooooooouuuuuuuuy_';
		return strtr($chaine, $from, $to);
	}
	function coolSize($size) {
	    $mb = 1024*1024;
	    if ( $size > $mb ) {
	        $mysize = sprintf ("%01.2f",$size/$mb) . " MB";
	    } elseif ( $size >= 1024 ) {
	        $mysize = sprintf ("%01.2f",$size/1024) . " Kb";
	    } else {
	        $mysize = $size . " bytes";
	    }
	    return $mysize;
	}
	function couleur_inverse($c_orig) {
		$prefix = "";
		if (substr($c_orig,0,1) == "#") {
			$c_orig = ltrim($c_orig,"#");
			$prefix = "#";
		}
		$a = substr($c_orig,0,1);
		$b = substr($c_orig,1,1);
		$c = substr($c_orig,2,1);
		if (strlen($c_orig) == 6) {
			$d = substr($c_orig,3,1);
			$e = substr($c_orig,4,1);
			$f = substr($c_orig,5,1);
		}
		
		$ai = DecHex(15-HexDec($a));
		$bi = DecHex(15-HexDec($b));
		$ci = DecHex(15-HexDec($c));
		if (strlen($c_orig) == 6) {
			$di = DecHex(15-HexDec($d));
			$ei = DecHex(15-HexDec($e));
			$fi = DecHex(15-HexDec($f));
		}
		$c_inv = $prefix.$ai.$bi.$ci;
		if (strlen($c_orig) == 6) {
			$c_inv .= $di.$ei.$fi;
		} 
		return $c_inv;
	}
	function uploadFiles($fichiersUpload, $chemin="", $maxWith = 0, $maxHeight = 0) {
		$chemin = rtrim($chemin, "/");
		
		if (!file_exists($chemin)) {
			//$old = umask(0);
			if (!mkdir($chemin,0777,true)) {
				 die("Impossible de crer le dossier de destination de l'upload !");
			}
			touch($chemin."/index.htm");
			//chmod($chemin, "0777");
			//umask($old);
		}

		$fichier = array();		
		for ($i=0; $i<count($fichiersUpload["name"]); $i++) {
			if ($fichiersUpload["name"][$i] != "") {
				$nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
				while (file_exists($chemin."/".$nomDestination)) {
					$nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
				}
				if (is_uploaded_file($fichiersUpload["tmp_name"][$i])) {
					//$fichier[$i] = strtolower($chemin."/".$nomDestination);
					//$fichier[$i] = str_replace($_SERVER['DOCUMENT_ROOT']."/",'',realpath($chemin)."/".$nomDestination);
					
					$fichier[$i] = str_replace(str_replace('\\', '/', realpath("."))."/",'',str_replace('\\', '/', realpath($chemin))."/".$nomDestination);
					
					if (rename($fichiersUpload["tmp_name"][$i],$fichier[$i])) {
						chmod($fichier[$i],0777);
						
						$extension = strtolower(strrchr($fichier[$i],'.'));
						
						if ($extension == '.jpg' || $extension == '.jpeg' || $extension == '.gif' || $extension == '.png') {						
    						$size = getimagesize($fichier[$i]);
    						$width = $size[0];
    						$height = $size[1];
    						
    						//test si les dimensions de l'image sont correctes et sinon applique le redimensionnement
    						if ($width >= $maxWith || $height >= $maxHeight) {
    							//calcul nouvelle taille
    							if (($width/$maxWith) > ($height/$maxHeight)) {
    								if ($maxWith != 0) {
    									$newwidth = $maxWith;
    									$newheight = ($height * $maxWith) / $width;
    								}
    								else {
    									$newwidth = ($width * $maxHeight) / $height;
    									$newheight = $maxHeight;
    								}
    							}
    							else {
    								if ($maxHeight != 0) {
    									$newwidth = ($width * $maxHeight) / $height;
    									$newheight = $maxHeight;
    								}
    								else {
    									$newwidth = $maxWith;
    									$newheight = ($height * $maxWith) / $width;
    								}
    							}
    							//pour les cas des jpg
    							if($extension == '.jpg' || $extension == '.jpeg') {
    								$src = imagecreatefromjpeg($fichier[$i]);
    								$tmp=imagecreatetruecolor($newwidth,$newheight);
    								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
    								imagejpeg($tmp,$fichier[$i],70);
    								imagedestroy($src);
    								imagedestroy($tmp);
    							}
    							//pour les cas des gif
    							if($extension == '.gif') {
    								$src = imagecreatefromgif($fichier[$i]);
    								$tmp=imagecreatetruecolor($newwidth,$newheight);
    								$trans = imagecolorallocate($tmp,255,255,255);
    								imagefilledrectangle($tmp,0,0,$newwidth,$newheight,$trans);
    								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
    								imageinterlace($tmp);
    								imagegif($tmp,$fichier[$i]);
    								imagedestroy($src);
    								imagedestroy($tmp);
    							}
    							//pour les cas des png
    							if($extension == '.png') {
    								$src = imagecreatefrompng($fichier[$i]);
    								$tmp=imagecreatetruecolor($newwidth,$newheight);
    								imagealphablending($tmp, false);
    								imagesavealpha($tmp, true);
    								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
    								$fond_noir = imagecolorallocate($destination, 0, 0, 0);
    								imagecolortransparent($destination, $fond_noir);
    								imagepng($tmp,$fichier[$i]);
    								imagedestroy($src);
    								imagedestroy($tmp);
    							}
    						}
						}
					}
					else {
						die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
					}          
				}
				else {
					die("Le fichier n'a pas t upload (trop gros ? droits ?)");
				}
			}
		}
		return $fichier;
	}
	
	function test_texte_vide($texte) {
	    $texte = strip_tags($texte);
	    $texte = str_replace("&nbsp;", "", $texte);
	    $texte = html_entity_decode($texte, ENT_QUOTES, "ISO-8859-1");
	    $texte = trim($texte);
	    return  $texte == "";   
	}
}
?>