<?php
    global $scripts_extra, $_headerContent, $recaptcha_public;
    global $currentlang;
    
    function getIDH($idh){
        global $module_name;
        require_once("modules/Sections/connector_class.php");
        if ($idh) {
            $pages = new pageconnector();
            $contentIdh = "";
            $contentIdh .= $pages->getPageContent($idh,"", true);
            return $contentIdh;
        }
        else{
            return "";
        }
    }
    
    function conv2iso($texte) {
        $sortie = $texte;
        $sortie = str_replace("\\u2019", "'", $sortie);
        return $sortie;
    }
    
    if (!isset($_COOKIE['folder_transit'])) {
        $nom_dossier = uniqid ("",true);
        setcookie("folder_transit", $nom_dossier, time() + (10 * 365 * 24 * 60 * 60)); // cookie dossier dest fichiers qui dure 10 ans
    }
    
    if ($currentlang == "french") {
        $espece = 'Espce* : ';
        $oespece = 'Autre espce';
        $voscoords = 'Vos coordonnes';
        $vnom = 'Nom :';
        $vprenom = 'Prnom :';
        $vtele = 'Tlphone :';
        $vlibemail = 'Courriel';
        $vemail = 'Courriel* :';
        $vlibprofil = 'Votre profil';
        $vobs = 'Votre observation';
        $vlibespece = 'Espce';
        $voespece = 'Autre espce (absente de la liste) :';
        $vlibeffectif = 'Effectif';
        $veffectif = 'Effectif* :';
        $vlibdatedeb = 'Date';
        $vdatedeb = 'Date de dbut* :';
        $vdatefin = 'Date de fin :';
        $vliblat = 'Latitude';
        $vlat = 'Latitude* :';
        $vliblong = 'Longitude';
        $vlong = 'Longitude* :';
        $vtloc = 'Reprer le lieu sur une carte interactive';
        $vloc = 'Assistant de localisation';
        $vcredit = 'Crdits photos :';
        $vtaddphoto = 'Joindre des photos  ce signalement';
        $vaddphoto = 'Ajouter des photos';
        $vtdiff = 'Diffusion publique des donnes :';
        $voui = 'Oui';
        $vnon = 'Non';
        $vtrq = 'Remarques :';
        $vsend = 'Envoyer';
        $vphotoadded = 'Photos jointes au signalement';
        $vphotoaddtext = 'Pour ajouter de nouvelles photos  ce signalement, utilisez les boutons ci-dessous.';
        $vtaddphotonew = 'Ajouter une photo';
        $vbaddphotonew = 'Ajouter';
        $vtsendphotonew = 'Uploader les photos';
        $vsendphotonew = 'Envoyer';
        $vtcancelphotonew = 'Annuler les photos';
        $vcancelphotosnew = 'Annuler';
        $vtdelphotosnew = 'Effacer les photos slectionnes';
        $vdelphotos = 'Supprimer';
        $vselphotos = 'Tout slectionner';
        $verreur = 'Erreur';
        $vphotononsend = 'Toutes vos photos n\'ont pas t envoys.<br />Envoyez-les toutes avant d\'expdier le signalement.';
        $vnocontrol = 'Cliquez sur la case &quot; Je ne suis pas un robot &quot;';
        $vlegphotonew = 'Lgende de la photo* :';
        $vencours = 'En cours...';
        $vdownphotonew = 'Tlcharger la photo';
        $vdelphotonew = 'Supprimer la photo';
    }
    if ($currentlang == "italian") {
        $espece = 'Specie*: ';
        $oespece = 'Altre specie';
        $voscoords = 'I vostri dati';
        $vnom = 'Nome:';
        $vprenom = 'Conome:';
        $vtele = 'Telefono:';
        $vlibemail = 'E-mail';
        $vemail = 'E-mail*:';
        $vlibprofil = 'Il tuo profilo';
        $vobs = 'La vostra osservazione';
        $vlibespece = 'Specie';
        $voespece = 'Altre specie (non presenti nella lista):';
        $vlibeffectif = 'Effettivo';
        $veffectif = 'Effettivo*:';
        $vlibdatedeb = 'Data';
        $vdatedeb = 'Data di inizio*:';
        $vdatefin = 'Data di fine:';
        $vliblat = 'Latitudine';
        $vlat = 'Latitudine* :';
        $vliblong = 'Longitudine';
        $vlong = 'Longitudine*:';
        $vtloc = 'Localizzare il luogo su una mappa interattiva';
        $vloc = 'Assistente di localizzazione';
        $vcredit = 'Crediti foto:';
        $vtaddphoto = 'Allegare foto a questa segnalazione';
        $vaddphoto = 'Aggiungere foto';
        $vtdiff = 'Diffusione pubblica dei dati:';
        $voui = 'Si';
        $vnon = 'No';
        $vtrq = 'Note:';
        $vsend = 'Inviare';
        $vphotoadded = 'Foto allegate alla segnalazione';
        $vphotoaddtext = 'Per aggiungere nuove foto a questa segnalazione, utilizzare i tasti qui sotto.';
        $vtaddphotonew = 'Aggiungere una foto';
        $vbaddphotonew = 'Aggiungere';
        $vtsendphotonew = 'Caricare le foto';
        $vsendphotonew = 'Inviare';
        $vtcancelphotonew = 'Cancellare le foto';
        $vcancelphotosnew = 'Cancellare';
        $vtdelphotosnew = 'Eliminare le foto selezionate';
        $vdelphotos = 'Sopprimere';
        $vselphotos = 'Seleziona tutto';
        $verreur = 'Sbaglio';
        $vphotononsend = 'Non tutte le tue foto sono state inviate; ti preghiamo di inviarle tutte prima di inviare il rapporto.';
        $vnocontrol = 'Fai clic sulla casella &quot;Non sono un robot&quot;';
        $vlegphotonew = 'Didascalia della foto*:';
        $vencours = 'In corso...';
        $vdownphotonew = 'Scarica la foto';
        $vdelphotonew = 'Elimina foto';
    }
    
    /* Espces invasives */
    $taxons =  json_decode(conv2iso(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_especes_inv&key=fea9a667df9db40499ebf94e5b6a07f6")), true)["result"]["data"];
    $menu_espece = '<select size= "1" name="obs[espece]" onchange="autre_espece(this.value)">
			<option value="" data-default>'.$espece.'</option>';
    foreach($taxons as $taxon) {
        $selected = '';
        if ($idtaxon == $taxon["id_taxon"]) {
            $selected = ' selected="selected"';
        }
        $nomvern = "";
        if ($taxon["nom_vernaculaire"] != "") {
            $nomvern = ' - '.utf8_decode($taxon["nom_vernaculaire"]);
        }
        $menu_espece .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($taxon["id_taxon"]).'"'.$selected.'>'.utf8_decode($taxon["nom_scientifique"]).$nomvern.'</option>';
    }
    $selected = '';
    if ($idtaxon == "-1") {
        $selected = ' selected="selected"';
    }
    $menu_espece .= '<option value="-1"'.$selected.'>'.$oespece.'</option>';
    $menu_espece .= '</select>';
    
    /* profil observateur */
    if ($currentlang == "french") {
        $tab_profils = array(
            "particulier"=>"Particulier",
            "association"=>"Association",
            "institutionnel"=>"Institutionnel"
        );
        $menu_profil = '<select size= "1" name="obs[profil]">
                        <option value="" data-default>Votre profil* : </option>';
        foreach($tab_profils as $val_profil => $label_profil){
            $selected = "";
            if ($profil == $val_profil) {
                $selected = ' selected="selected"';
            }
            $menu_profil .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($val_profil).'"'.$selected.'>'.$label_profil.'</option>';
        }
        $menu_profil .= '</select>';
    }
    if ($currentlang == "italian") {
        $tab_profils = array(
            "particulier"=>"Privato",
            "association"=>"Associazione",
            "institutionnel"=>"Istituzioni "
        );
        $menu_profil = '<select size= "1" name="obs[profil]">
                        <option value="" data-default>Il tuo profilo*: </option>';
        foreach($tab_profils as $val_profil => $label_profil){
            $selected = "";
            if ($profil == $val_profil) {
                $selected = ' selected="selected"';
            }
            $menu_profil .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($val_profil).'"'.$selected.'>'.$label_profil.'</option>';
        }
        $menu_profil .= '</select>';
    }
    
    /* stades de dveloppement */
    if ($currentlang == "french") {
        $tab_dev_faune = array(
            "1"=>"&oelig;uf",
            "9"=>"larve",
            "6"=>"adulte"
        );
        $tab_dev_flore = array(
            "22"=>"plantule",
            "18"=>"en feuille",
            "20"=>"en fleur",
            "23"=>"en graine"
        );
        $menu_stade_dev = '<select size= "1" name="obs[stade_dev]">
                        <option value="" data-default>Stade de dveloppement : </option>
                        <optgroup label="Faune">';
        foreach($tab_dev_faune as $val_dev => $label_dev){
            $selected = "";
            if ($stade_dev == $val_dev) {
                $selected = ' selected="selected"';
            }
            $menu_stade_dev .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($val_dev).'"'.$selected.'>'.$label_dev.'</option>';
        }
        $menu_stade_dev .= '</optgroup>
                            <optgroup label="Flore">';
        foreach($tab_dev_flore as $val_dev => $label_dev){
            $selected = "";
            if ($stade_dev == $val_dev) {
                $selected = ' selected="selected"';
            }
            $menu_stade_dev .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($val_dev).'"'.$selected.'>'.$label_dev.'</option>';
        }
        $menu_stade_dev .= '</optgroup>
                        </select>';
    }
    if ($currentlang == "italian") {
        $tab_dev_faune = array(
            "1"=>"uovo",
            "9"=>"larva",
            "6"=>"adulto"
        );
        $tab_dev_flore = array(
            "22"=>"plantula",
            "18"=>"in foglia",
            "20"=>"in fiore",
            "23"=>"in seme"
        );
        $menu_stade_dev = '<select size= "1" name="obs[stade_dev]">
                        <option value="" data-default>Stadio di sviluppo: </option>
                        <optgroup label="Fauna">';
        foreach($tab_dev_faune as $val_dev => $label_dev){
            $selected = "";
            if ($stade_dev == $val_dev) {
                $selected = ' selected="selected"';
            }
            $menu_stade_dev .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($val_dev).'"'.$selected.'>'.$label_dev.'</option>';
        }
        $menu_stade_dev .= '</optgroup>
                            <optgroup label="Flora">';
        foreach($tab_dev_flore as $val_dev => $label_dev){
            $selected = "";
            if ($stade_dev == $val_dev) {
                $selected = ' selected="selected"';
            }
            $menu_stade_dev .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($val_dev).'"'.$selected.'>'.$label_dev.'</option>';
        }
        $menu_stade_dev .= '</optgroup>
                        </select>';
    }
    /* date observation */
    $datavalue_debut = '';
    if (isset($date_debut) && $date_debut != "0000-00-00" && $date_debut != "") {
        $datavalue_debut = ' data-value="'.$date_debut.'"';
    }
    $datavalue_fin = '';
    if (isset($date_fin) && $date_fin != "0000-00-00" && $date_debut != "") {
        $datavalue_fin = ' data-value="'.$date_fin.'"';
    }
    
    /* formulaire de recherche */
    $formulaire = '
            <form id="contact-form" action="mobiles.php" method="post">
			    <div class="contact-form-loader"></div>
			    <fieldset>
                    <div id="zpicker"></div>
                    <div class="text2 mb20">'.$voscoords.'</div>
			    	<div>
                        <label class="twocols">
    						<input type="text" name="obs[nom]" placeholder="'.$vnom.'" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($nom).'">
    					</label>
    					<label class="twocols">
    						<input type="text" name="obs[prenom]" placeholder="'.$vprenom.'" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($prenom).'">
    					</label>
                    </div>
					<div>
			    		<label class="twocols">
			    			<input name="obs[tel]" placeholder="'.$vtele.'" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($telephone).'" type="text">
			    		</label>
			    		<label class="twocols">
                            <champ nom="obs[courriel]" lib="'.$vlibemail.'"  ctl="email"></champ>
			    			<input name="obs[courriel]" placeholder="'.$vemail.'" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($courriel).'" type="text" >
			    		</label>
			    	</div>
                    <div>
			    		<label class="twocols">
                            <champ nom="obs[profil]" lib="'.$vlibprofil.'"></champ>
			    			'.$menu_profil.'
			    		</label>
			    	</div>
                    <div class="clear"></div>
                    <div class="text2 mb20">'.$vobs.'</div>
                    <div>
                        <label class="twocols">
                            <champ nom="obs[espece]" lib="'.$vlibespece.'"></champ>
    		    			'.$menu_espece.'
    		    		</label>
                        <label class="twocols">
    		    			<input id="espece2" name="obs[espece2]" placeholder="'.$voespece.'" value="" type="text" disabled="">
    		    		</label>
                    </div>
                    <div>
                        <label class="twocols">
    		    			'.$menu_stade_dev.'
    		    		</label>
                        <label class="twocols">
                            <champ nom="obs[nombre]" lib="'.$vlibeffectif.'" ctl="nombre"></champ>
    		    			<input name="obs[nombre]" placeholder="'.$veffectif.'" value="" type="text" >
    		    		</label>
                    </div>
                    <div>
                        <label class="twocols">
                            <div class="evt_pick">
                                <champ nom="obs[date_debut]" lib="'.$vlibdatedeb.'" ctl="date-sql"></champ>
								<input id="date_debut" type="text" name="date_debut" placeholder="'.$vdatedeb.'" value="'.$date_debut.'"'.$datavalue_debut.'>
							</div>
    		    		</label>
                        <label class="twocols">
                            <div class="evt_pick">
								<input id="date_fin" type="text" name="date_fin" placeholder="'.$vdatefin.'" value="'.$date_fin.'"'.$datavalue_fin.'>
							</div>
    		    		</label>
                    </div>
                    <div>
                        <label class="twocols">
                            <champ nom="obs[latitude]" lib="'.$vliblat.'" ctl="latitude"></champ>
    						<input id="latitude" type="text" name="obs[latitude]" placeholder="'.$vlat.'" value="'.$latitude.'">
    					</label>
    					<label class="twocols">
                            <champ nom="obs[longitude]" lib="'.$vliblong.'" ctl="longitude"></champ>
    						<input id="longitude" type="text" name="obs[longitude]" placeholder="'.$vlong.'" value="'.$longitude.'">
    					</label>
                    </div>
                    <div class="clear"></div>
                    <growbox_map>
                        <div id="map" class="mb20"></div>
                    </growbox_map>
                    <div class="clear"></div>
                    <div>
                        <label class="onecol">
						  <a href="#" class="btn nf m0" data-type="growbox_map"><i class="fa fa-map-marker fa-fw fa-lg" aria-hidden="true" title="'.$vtloc.'"></i> '.$vloc.'</a>
                        </label>
					</div>
                    <div class="clear"></div>
                    <div>
                        <div class="twocols">
                            <label class="twocols">
        						<input type="text" name="obs[credits]" placeholder="'.$vcredit.'" value="'.$credits.'">
        					</label>
                        </div>
                        <div class="twocols">
            				<label class="onecol">
    						  <a href="#" class="btn nf m0" data-type="growbox_photo"><i class="fa fa-picture-o fa-fw fa-lg" aria-hidden="true" title="'.$vtaddphoto.'"></i> '.$vaddphoto.'</a>
                            </label>
                        </div>
                    </div>
                    <div class="clear"></div>
                    <div>
                        <div class="onecol">
            				<label class="onecol" style=" width: 40%;">
            		    		<span class="fwn">'.$vtdiff.'</span>
            		    	</label>
            		    	<label class="onecol" style="width: 30%; clear: none">
            					<input type="radio" name="obs[status_donnee]" value="publique"'.(($status_donnee == "publique" || $status_donnee == "") ? ' checked="checked"' : '').' /> '.$voui.'
            				</label>
                            <label class="onecol" style=" width: 30%; clear: none">
            					<input type="radio" name="obs[status_donnee]" value="prive"'.(($status_donnee == "prive") ? ' checked="checked"' : '').' /> '.$vnon.'
            				</label>
                        </div>
                    </div>
                    <div class="clear"></div>
                    <label class="message">
                        <textarea name="obs[remarques]" placeholder="'.$vtrq.'" style="height: 75px;"></textarea>
                    </label>
                    <div class="clear"></div>
			    	<div id="brecaptcha">
        				<div class="g-recaptcha" data-size="compact" data-sitekey="'.$recaptcha_public.'"></div>
        				<a href="#" class="btn" data-type="submit_obs"><i class="fa fa-floppy-o fa-fw fa-lg" aria-hidden="true">&nbsp;</i>'.$vsend.'</a>
        			</div>
			    </fieldset>
                <input type="hidden" name="name" value="SimpleDataExt">
                <input type="hidden" name="op" value="send_obs_aliem">
                <input type="hidden" value="" name="obs[newfiles]" id="newfiles" />
				<input type="hidden" value="" name="filesstate" id="filesstate" data-type="filesstate" />
			</form>
';
    
    $formulaireupload ='
    <growbox_photo>
	<div>
		<h4>'.$vphotoadded.'</h4>
		<div class="row">
			<div class="grid_12">
				<p class="nomb">'.$vphotoaddtext.'</p>
			</div>
		</div>
		<form id="fileupload" action="" method="POST" enctype="multipart/form-data">
			<fieldset>
		        <noscript><input type="hidden" name="redirect" value="index.php"></noscript>
		        <div class="fileupload-buttonbar">
					<div class="row">
						<div class="grid_3 center_fileinput-button">
							<div class="btn_alternate clear fileinput-button"><div class="count"><i class="fa fa-plus-circle" aria-hidden="true" title="'.$vtaddphotonew.'"></i></div><div class="label">'.''.$vbaddphotonew.''.'</div>
							<input type="file" name="files[]" multiple>
							</div>
						</div>
						<div class="grid_3">
							<div class="btn_alternate clear start"><div class="count"><i class="fa fa-arrow-circle-o-up" aria-hidden="true" title="'.$vtsendphotonew.'"></i></div><div class="label">'.''.$vsendphotonew.''.'</div></div>
						</div>
						<div class="grid_3">
							<div class="btn_alternate clear cancel"><div class="count"><i class="fa fa-ban" aria-hidden="true" title="'.$vtcancelphotonew.'"></i></div><div class="label">'.''.$vcancelphotosnew.''.'</div></div>
						</div>
						<div class="grid_3 hide_small">
							<div class="table center">
								<div class="table_cell">
									<div class="btn_alternate clear delete"><div class="count"><i class="fa fa-trash-o" aria-hidden="true" title="'.$vtdelphotosnew.'"></i></div><div class="label">'.''.$vdelphotos.''.'</div></div>
								</div>
								<div  class="table_cell">
									<div class="top_20 left_16"><input type="checkbox" class="toggle" title="'.$vselphotos.'"></div>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="grid_12">
							<span class="fileupload-process"></span>
						</div>
					</div>
					<div class="row">
						<div class="grid_12 fileupload-progress fade">
							<div class="progress progress-striped active eltleft demi top_bottom_8" role="progressbar" aria-valuemin="0" aria-valuemax="100">
			                    <div class="progress-bar progress-bar-success" style="width:0%;"></div>
			                </div>
			                <div class="progress-extended eltleft left_16 top_bottom_8">&nbsp;</div>
						</div>
					</div>
				</div>
		        <div class="row">
					<div class="grid_12">
						<table role="presentation" class="table table-striped"><tbody class="files"></tbody></table>
					</div>
				</div>
	    	</fieldset>
	    </form>
		<div id="blueimp-gallery" class="blueimp-gallery blueimp-gallery-controls" data-filter=":even">
		    <div class="slides"></div>
		    <h3 class="title"></h3>
		    <a class="prev"><</a>
		    <a class="next">></a>
		    <a class="close"></a>
		    <a class="play-pause"></a>
		    <ol class="indicator"></ol>
		</div>
	</div>
    </growbox_photo>
	';
    
    global $idh;
    
    if (isset($idh) && $idh != "") {
        $sortie = getIDH($idh);
        
        $sortie_eval = "\$sortie = \"".addslashes($sortie)."\";";
        eval($sortie_eval);
        $sortie = stripslashes($sortie);
    }
    else {
        if ($currentlang == "french") {
            $sortie = '<div class="container">
                    <div class="row">
                		<div class="grid_12">
                            <h3>Signalement d\'une espce</h3>
                            <p>Vous pourrez signaler ici les espces que vous avez remarques.</p>
                			'.$formulaire.'
                		</div>
                	</div>
                    '.$formulaireupload.'
                </div>';
        }
        if ($currentlang == "italian") {
            $sortie = '<div class="container">
                    <div class="row">
                		<div class="grid_12">
                            <h3>Segnalazione di specie</h3>
                            <p>Puoi segnalare qui le specie che hai notato.</p>
                			'.$formulaire.'
                		</div>
                	</div>
                    '.$formulaireupload.'
                </div>';
        }
    }
	
	require_once('themes/'.$Default_Theme.'/btn_retour.php');

	$_headerContent .= '
<script>
	var nosmoothscroll = true;
</script>
	';	
	
	$scripts_extra .= '
<script type="text/javascript" src="javascripts/lang/lang-french.js" charset="ISO-8859-1"></script>
<script type="text/javascript" src="javascripts/control_form.js" charset="ISO-8859-1"></script>
<script type="text/javascript" src="themes/aliem/js/jquery.growl.js"></script>
<link rel="stylesheet" href="themes/aliem/style/jquery.growl.css">
<link rel="stylesheet" href="themes/aliem/style/contact-form.css">
<script src="https://www.google.com/recaptcha/api.js"></script>
<script>
    function autre_espece(id) {
        if (id==-1) {
            $("#espece2").attr("disabled", false).focus();
        }
        else {
            $("#espece2").val("").attr("disabled", true);
        }
    }

	function expedier_post(form) {
	    form.trigger("submit");
	}
	
	jQuery(function () {
		/* validation du post */
		if (jQuery("form [data-type=submit_obs]").length > 0) {
			jQuery("form [data-type=submit_obs]").click(function(){
				var form = jQuery(this).parents("form");
                if (submit_form(form.get(0))) {
					if (jQuery("form [data-type=filesstate]").length > 0 && jQuery("form [data-type=filesstate]")[0].value == "") {
						alerte_erreur("'.$verreur.'","'.$vphotononsend.'", 5000);
					    return false;
					}
					else {
                        if (grecaptcha.getResponse() == ""){
                			alerte_erreur("'.$verreur.'","'.$vnocontrol.'");
                            return false;
                		}
                		else {
                		    expedier_post(form);
                		}
					}
				}
				return false;
			});
		}
	});

	/*jQuery(function () {
		jQuery("#contact-form").on("keyup keypress", function(e) {
			var keyCode = e.keyCode || e.which;
			if (keyCode === 13) { 
				console.log("submit formulaire neutralis");
				e.preventDefault();
				return false;
			}
		});
	});*/


    /* pour faire apparatre la carte */
    jQuery(function () {
		jQuery("growbox_map").hide();
		jQuery("[data-type=growbox_map]").on("click",function(event){
			event.preventDefault();
			jQuery("growbox_map").slideToggle(2000,function() {
				top_page("growbox_map");
			});
		});
    });

    /* pour faire apparatre les photos */
    jQuery(function () {
		jQuery("growbox_photo").hide();
		jQuery("[data-type=growbox_photo]").on("click",function(event){
			event.preventDefault();
			jQuery("growbox_photo").slideToggle(2000,function() {
				top_page("growbox_photo");
			});
		});
    });	
</script>
';
	$scripts_extra .= '
<link rel="stylesheet" href="javascripts/pickadate.js/lib/themes/default.css">
<link rel="stylesheet" href="javascripts/pickadate.js/lib/themes/default.date.css">
<link rel="stylesheet" href="javascripts/pickadate.js/lib/themes/default.time.css">
<script src="javascripts/pickadate.js/lib/picker.js"></script>
<script src="javascripts/pickadate.js/lib/picker.date.js"></script>
<script src="javascripts/pickadate.js/lib/picker.time.js"></script>
<script src="javascripts/pickadate.js/lib/translations/fr_FR.js"></script>
<script>
	jQuery(function() {
		var debDate = jQuery("#date_debut").pickadate({
			formatSubmit: "yyyy-mm-dd",
  			hiddenPrefix: "obs[",
  			hiddenSuffix: "]",
  			container: "#zpicker",
  			onSet: function(context) {
				/*if (finPicker.get("select") == null || finPicker.get("select").pick < context.select) {
					finPicker.set("select", context.select);
				}*/
                if (finPicker.get("select") != null && finPicker.get("select").pick < context.select) {
					finPicker.set("select", context.select);
                    alerte_erreur("Attention","Vrifiez vos dates d\'observation.", 5000);
				}
			}
		});
		var debPicker = debDate.pickadate("picker");

        var finDate = jQuery("#date_fin").pickadate({
			formatSubmit: "yyyy-mm-dd",
  			hiddenPrefix: "obs[",
  			hiddenSuffix: "]",
  			container: "#zpicker",
            onSet: function(context) {
				if (debPicker.get("select")!= null && debPicker.get("select").pick > context.select) {
					debPicker.set("select", context.select);
                    alerte_erreur("Attention","Vrifiez vos dates d\'observation.", 5000);
				}
			}
		});
		var finPicker = finDate.pickadate("picker");
    });
</script>
<style>
	.picker__button--clear.closepick::before {
	    content: "\\\\D7";
	    vertical-align: top;
	    font-size: 1.6em;
	    margin-right: .35em;
	    color: #777777;
	    border-top: none;
	    width: auto;
	}
</style>';
	
	$scripts_extra .= '
    <link rel="stylesheet" href="themes/aliem/style/map.css">
    <link rel="stylesheet" href="themes/aliem/js/map_arob/leaflet/leaflet.css" />
    <link rel="stylesheet" href="themes/aliem/js/map_arob/Leaflet.EasyButton/easy-button.css" />
    <link rel="stylesheet" href="themes/aliem/js/map_arob/Leaflet.fullscreen/leaflet.fullscreen.css" />
    <link rel="stylesheet" href="themes/aliem/js/map_arob/map_arob-UImap_arob/map_arob.editmap/editmap.css" />
    <link rel="stylesheet" href="themes/aliem/js/map_arob/map_arob-UImap_arob/map_arob.screenshot/screenshot.css" />
    <link rel="stylesheet" href="themes/aliem/js/map_arob/map_arob-UImap_arob/UImap_arob.proj/UImap_arob.proj.css">
    <link rel="stylesheet" href="themes/aliem/js/Leaflet.markercluster/dist/MarkerCluster.css">
    <link rel="stylesheet" href="themes/aliem/js/Leaflet.markercluster/dist/MarkerCluster.Default.css">
    <link rel="stylesheet" href="themes/aliem/js/map_arob/map_arob-UImap_arob/map_arob.editLayerProperties/editLayerProperties.css">
<style>
#contact-form #map label {
    float: none;
    position: initial;
    display: block;
    width: auto;
    min-height: auto;
    height: auto;
    margin-left: 0;
}
</style>
';
	$sortie .= '
    <script src="themes/aliem/js/wkx/dist/wkx.min.js"></script>
	    
    <script src="themes/aliem/js/map_arob/leaflet/leaflet.js"></script>
    <script src="themes/aliem/js/map_arob/Editable/Leaflet.Editable.js"></script>
    <script src="themes/aliem/js/map_arob/leaflet.filelayer/togeojson.js"></script>
    <script src="themes/aliem/js/map_arob/leaflet.filelayer/leaflet.filelayer.js"></script>
    <script src="themes/aliem/js/map_arob/Leaflet.EasyButton/easy-button.js"></script>
    <script src="themes/aliem/js/map_arob/Leaflet.leaflet-image/leaflet-image.js"></script>
    <script src="themes/aliem/js/map_arob/Leaflet.fullscreen/Leaflet.fullscreen.min.js"></script>
    <script src="themes/aliem/js/map_arob/Leaflet.TileLayer.Fallback/leaflet.tilelayer.fallback.js"></script>
    <script src="themes/aliem/js/map_arob/map_arob-UImap_arob/UImap_arob.proj/proj4js-2.5.0/dist/proj4-src.js"></script>
    <script src="themes/aliem/js/map_arob/map_arob-UImap_arob/map_arob.map-only.full.js"></script>
    <script src="themes/aliem/js/map_arob/lang_fr.js"></script>
	    
    <script src="themes/aliem/js/Leaflet.markercluster/dist/leaflet.markercluster.js"></script>
	    
<script>
    $(function() {
        /* init proprits de la map */
        map_arob.layer_tile.init({
            // obligatoire
            "mburl" : "https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg",
            // optionnel, par dfault tous les tuiles suivantes sont integres
            "tiles" : [
            	{
	                "id" : "vincent2b/ckacgndr602if1iloq3zpxoif",
	                "nom" : "Outdoors",
	                "url_zxy" : "mapbox_zxy"
				},
				{
	                "id" : "opentopomap",
	                "nom" : "opentopomap",
	                "url_zxy" : "https://c.tile.opentopomap.org/{z}/{x}/{y}.png",
	                "attribution" : " OpenStreetMap contributors, SRTM | map style:  OpenTopoMap (CC-BY-SA)"
	            },
	            {
	                "id" : "vincent2b/ckadls8ql0l7k1ilo0lps4swq",
	                "nom" : "Satellite monde",
	                "url_zxy" : "mapbox_zxy"
				},
	            {
	                "id" : "vincent2b/ckadl6ni406ou1irtli71fwll",
	                "nom" : "Light",
	                "url_zxy" : "mapbox_zxy"
				}
			]
        });
    
        map_arob.CustomIconMarker.setCustomRootPath("themes/aliem/js/map_arob/");
        (map_arob.editmap = new editmap(true)).init({
            stylePolygonDefault: {
                color: "#111111",
                weight: 2,
                fillColor: "#111111",
                fillOpacity: 0.2
            },
            styleBackgroundPolygonDefault : {
                color: "#2e6da4",
                weight: 2,
                fillColor: "#049fff",
                fillOpacity: 0.4
            },
            styleLineStringDefault : {
                color: "#FF2600",
                weight: 5
            },
            buttonsEdition : [],
            displayControlBackground : false
        });
        map_arob.editLayerProperties.init({
            "disable" : true,  //masque les boutons d\'dition de donnes
            "allowStyleJsonEdit" :  true
        });

        map_arob.map.panTo(new L.latLng(43.5,7));
        map_arob.map.setZoom(6);
        map_arob.map.setMinZoom(3);
    
        /* personnalisation des icones */
        /*map_arob.map.eachLayer(function (layer) {
            var icon_file = "themes/aliem/js/map_arob/map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-green.png"
            if (typeof layer.feature != "undefined") {
                if (typeof layer.feature.properties != "undefined") {
                    var taille_icone = tailleIcone(layer.feature.properties);
                    var new_icon = L.Icon.extend({
                                                   options :{
                                                              iconUrl: icon_file,
                                                              iconSize: taille_icone,
                                                              iconAnchor: ancre_icone(taille_icone)
                                                            }
                                                });
                    layer.setIcon(new new_icon);
                }
            }
        });*/

        /*  gestion du marker draggable */
        var marker = null;

        map_arob.map.on("click", function(e) {
            if (marker == null) {
                //cration du marker
                curLocation = [e.latlng.lat, e.latlng.lng];
                marker = new L.marker(curLocation, {
                    draggable: "true"
                });
                marker.on("dragend", function(event) {
                    var position = marker.getLatLng();
                    marker.setLatLng(position, {
                      draggable: "true"
                    }).update();
                    $("#latitude").val(position.lat);
                    $("#longitude").val(position.lng).keyup();
                });
                map_arob.map.addLayer(marker);
            }
            else {
                var position = [e.latlng.lat, e.latlng.lng];
                marker.setLatLng(position, {
                  draggable: "true"
                }).update();
            }
            $("#latitude").val(e.latlng.lat);
            $("#longitude").val(e.latlng.lng).keyup();
        });

        $("#latitude, #longitude").change(function() {
            if ($("#latitude").val() != "" && $("#longitude").val() != "") {
                if (marker == null) {
                    //cration du marker
                    curLocation = [parseFloat($("#latitude").val()), parseFloat($("#longitude").val())];
                    marker = new L.marker(curLocation, {
                        draggable: "true"
                    });
                    marker.on("dragend", function(event) {
                        var position = marker.getLatLng();
                        marker.setLatLng(position, {
                          draggable: "true"
                        }).update();
                        $("#latitude").val(position.lat);
                        $("#longitude").val(position.lng).keyup();
                    });
                    map_arob.map.addLayer(marker);
                }
                else {
                    var position = [parseFloat($("#latitude").val()), parseFloat($("#longitude").val())];
                    marker.setLatLng(position, {
                      draggable: "true"
                    }).update();
                    map_arob.map.panTo(position);
                }
            }
        });

        if ($("#latitude").val() != "" && $("#longitude").val() != "") {
            if (marker == null) {
                //cration du marker
                curLocation = [parseFloat($("#latitude").val()), parseFloat($("#longitude").val())];
                marker = new L.marker(curLocation, {
                    draggable: "true"
                });
                marker.on("dragend", function(event) {
                    var position = marker.getLatLng();
                    marker.setLatLng(position, {
                      draggable: "true"
                    }).update();
                    $("#latitude").val(position.lat);
                    $("#longitude").val(position.lng).keyup();
                });
                map_arob.map.addLayer(marker);
            }
            else {
                var position = [parseFloat($("#latitude").val()), parseFloat($("#longitude").val())];
                marker.setLatLng(position, {
                  draggable: "true"
                }).update();
                map_arob.map.panTo(position);
            }
        }

    });
    function ancre_icone(taille_icone) {
        var y = taille_icone[1];
        var x = Math.floor(taille_icone[0]/2);
        return [x,y];
    }
    function tailleIcone(properties) {
        return [20, 33];
    }
</script>
';
	
	$scripts_extra .='
<link rel="stylesheet" href="themes/aliem/style/becmsGallery.css">
<link rel="stylesheet" href="javascripts/jQuery-File-Upload/css/blueimp-gallery.min.css">
<link rel="stylesheet" href="javascripts/jQuery-File-Upload/css/jquery.fileupload.css">
<link rel="stylesheet" href="javascripts/jQuery-File-Upload/css/jquery.fileupload-ui.css">
<noscript><link rel="stylesheet" href="javascripts/jQuery-File-Upload/css/jquery.fileupload-noscript.css"></noscript>
<noscript><link rel="stylesheet" href="javascripts/jQuery-File-Upload/css/jquery.fileupload-ui-noscript.css"></noscript>
<script>
    function pictofiletype(letype) {
		var picto_af = "fa-file-o";
		if (letype == "xls" || letype == "xlsx" || letype == "xlsm" || letype == "ods" || letype == "csv") {
			var picto_af = "fa-file-excel-o";
		}
		if (letype == "doc" || letype == "docx" || letype == "docm" || letype == "odt" || letype == "rtf") {
			var picto_af = "fa-file-word-o";
		}
		if (letype == "pdf") {
			var picto_af = "fa-file-pdf-o";
		}
		if (letype == "zip" || letype == "rar" || letype == "tar" || letype == "tgz" || letype == "tgz" || letype == "bz2" || letype == "7z") {
			var picto_af = "fa-file-archive-o";
		}
		if (letype == "jpg" || letype == "jpeg" || letype == "gif" || letype == "png" || letype == "raw" || letype == "psd" || letype == "tif" || letype == "tiff" || letype == "xcf" || letype == "eps" || letype == "ai" || letype == "svg" || letype == "bmp") {
			var picto_af = "fa-file-image-o";
		}
		if (letype == "mp4" || letype == "mov" || letype == "flv" || letype == "f4v" || letype == "avi" || letype == "mkv" || letype == "divx") {
			var picto_af = "fa-file-video-o";
		}
		if (letype == "aif" || letype == "aiff" || letype == "wav" || letype == "mp3" || letype == "m4a" || letype == "aac") {
			var picto_af = "fa-file-audio-o";
		}
		if (letype == "txt" || letype == "text") {
			var picto_af = "fa-file-text-o";
		}
		if (letype == "htm" || letype == "html" || letype == "php" || letype == "pl" || letype == "sh" || letype == "sql" || letype == "css") {
			var picto_af = "fa-file-code-o";
		}
		if (letype == "ppt" || letype == "pptx" || letype == "pps" || letype == "ppts" || letype == "odp") {
			var picto_af = "fa-file-powerpoint-o";
		}
		return picto_af;
	}
</script>	    
<!-- The template to display files available for upload -->
<script id="template-upload" type="text/x-tmpl">
{% for (var i=0, file; file=o.files[i]; i++) { %}
    <tr class="template-upload fade">
		<td style="padding: 0">
			<div class="cell_table-stripped">
				<div class="margeeltfile">
					<div class="previewb marginmedium">
						<span class="preview"><a class="previewpicto"><i class="fa {%=pictofiletype(file.extension)%}" aria-hidden="true"></i></a></span>
					</div>
					<div style="display:inline-block">
						<div>
							<input name="title[]" placeholder="'.$vlegphotonew.'" class="saisiet" required /><br />
							{%=file.name%}
							<strong class="error text-danger"></strong>
						</div>
        			</div>
        		</div>
        	</div>
        	<div class="cell_table-stripped fright">
				<div class="table top_bottom_8 eltright">
					<div class="infosb">
						<span class="size">'.$vencours.'</span><br />
            			<div class="progress progress-striped active" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0"><div class="progress-bar progress-bar-success" style="width:0%;"></div></div>
            		</div>
            		{% if (!i && !o.options.autoUpload) { %}
		            	<div class="actionb">
							<div class="btn_alternate inlineb start" disabled><div class="count"><i class="fa fa-arrow-circle-o-up" aria-hidden="true" title="'.$vsendphotonew.'"></i></div></div>
		                </div>
		            {% } %}
            		{% if (!i) { %}
		            	<div class="actionb">
							<div class="btn_alternate inlineb cancel"><div class="count"><i class="fa fa-ban" aria-hidden="true" title="'.$vcancelphotosnew.'"></i></div></div>
		                </div>
		            {% } %}
				</div>
			</div>
        </td>
    </tr>
{% } %}
</script>
<!-- The template to display files available for download -->
<script id="template-download" type="text/x-tmpl">
{% for (var i=0, file; file=o.files[i]; i++) { %}
    <tr class="template-download fade">
		<td style="padding: 0">
			<div class="cell_table-stripped">
				<div class="margeeltfile">
					<div class="previewb"><span class="preview">
	                	{% if (file.thumbnailUrl) { %}
	                    	<a href="{%=file.url%}" title="{%=file.titre%}" download="{%=file.name%}" data-gallery><img src="{%=file.thumbnailUrl%}" style="vertical-align: bottom"></a>
	                	{% } else { %}
							{% if (file.url) { %}
	                    		<a href="{%=file.url%}" title="{%=file.name%}" download="{%=file.name%}" class="previewpicto"><i class="fa {%=pictofiletype(file.extension)%}" aria-hidden="true" title="'.$vdownphotonew.'"></i></a>
	                		{% } else { %}
	                    		<span>{%=file.extension%}</span>
	                		{% } %}
						{% } %}
            		</span></div>
					<div style="display:inline-block">
						<div>
							{% if (file.titre) { %}
								<span class="fwn">{%=file.titre%}</span><br />
							{% } %}
	                		{% if (file.url) { %}
	                    		<a href="{%=file.url%}" title="{%=file.name%}" download="{%=file.name%}" {%=file.thumbnailUrl?\'data-gallery\':\'\'%}>{%=file.name%}</a>
	                		{% } else { %}
	                    		<span>{%=file.name%}</span>
	                		{% } %}
            			</div>
						{% if (file.error) { %}
                			<div><span class="label label-danger">'.$verreur.'</span> {%=file.error%}</div>
            			{% } %}
            		</div>
				</div>
			</div>
			<div class="cell_table-stripped fright">
				<div class="table top_bottom_8 eltright">
					<div class="infosb"><span class="size">{%=o.formatFileSize(file.size)%}</span></div>
					{% if (file.deleteUrl) { %}
						<div class="actionb">
							<div class="btn_alternate inlineb delete" data-type="{%=file.deleteType%}" data-url="{%=file.deleteUrl%}"{% if (file.deleteWithCredentials) { %} data-xhr-fields=\'{"withCredentials":true}\'{% } %}><div class="count"><i class="fa fa-trash-o" aria-hidden="true" title="'.$vdelphotonew.'"></i></div></div>
                		</div>
                		<div class="actionb hide_small">
                			<input type="checkbox" name="delete" value="1" class="toggle">
                		</div>
            		{% } else { %}
                		<button class="btn btn-warning cancel">
                    		<i class="glyphicon glyphicon-ban-circle"></i>
                    		<span>'.$vcancelphotosnew.'</span>
                		</button>
            		{% } %}
				</div>
			</div>
		</td>
	</tr>
{% } %}
</script>
<script src="javascripts/jQuery-File-Upload/js/vendor/jquery.ui.widget.js"></script>
<script src="javascripts/jQuery-File-Upload/js/tmpl.min.js"></script>
<script src="javascripts/jQuery-File-Upload/js/load-image.all.min.js"></script>
<script src="javascripts/jQuery-File-Upload/js/canvas-to-blob.min.js"></script>
<script src="javascripts/jQuery-File-Upload/js/bootstrap.min.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.blueimp-gallery.min.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.iframe-transport.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.fileupload.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.fileupload-process.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.fileupload-image.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.fileupload-audio.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.fileupload-video.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.fileupload-validate.js"></script>
<script src="javascripts/jQuery-File-Upload/js/jquery.fileupload-ui.js"></script>
<script src="javascripts/jQuery-File-Upload/js/main_photos.js"></script>
<script>
function enable_form() {
	this.etat_file = 0;
	this.fileplus = function () {
		this.etat_file++;
		console.log("etat : " + this.etat_file);
		this.enable_form_submit();
	}
	this.filemoins = function () {
		this.etat_file--;
		console.log("etat : " + this.etat_file);
		this.enable_form_submit();
	}
	this.enable_form_submit = function () {
		if (this.etat_file <= 0) {
			console.log("Formulaire OK");
			jQuery("#filesstate").val("OK");
			var list_files = $.ajax( "javascripts/jQuery-File-Upload/server/php/" )
				.done(function() {
					var fichiers = JSON.parse(list_files.responseText);
					//console.log(list_files.responseText);
					jQuery("#newfiles").val(list_files.responseText);
                    if (list_files.responseText != "" && list_files.responseText != \'{"files":[]}\') {
                        jQuery("growbox_photo").show();
                    }
				})
				.fail(function() {
					console.log("Erreur !!!");
				});
		}
		else {
			console.log("Formulaire dsactiv");
			jQuery("#filesstate").val("");
		}
	}
}
var callback_form = new enable_form;
</script>
<!-- The XDomainRequest Transport is included for cross-domain file deletion for IE 8 and IE 9 -->
<!--[if (gte IE 8)&(lt IE 10)]>
<script src="js/cors/jquery.xdr-transport.js"></script>
<![endif]-->
	';
	$scripts_extra .='
	<link type="text/css" rel="stylesheet" href="themes/aliem/style/toggle_btn.css" />
	<script type="text/javascript" src="themes/aliem/js/toggle_btn.js"></script>
	';
	 
	$sortie .= $btn_retour;
	
?>