MAP_arob.js
=================

CHANGLOG
=======

## Nouveautés v1.0.31
- Gestion des fonds carto 

Les tuiles des fonds de cartes sont maintenant à paramètrer avant tout autres scripts map_arob.
```javascript
map_arob.layer_tile.init(option);
```
Options de layer_tile : 
```json
{
    // obligatoire
    "mburl" : "https://api.tiles.mapbox.com/v4/{id}/{z}/{x}/{y}.png?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", 
    // optionnel, par défault tous les tuiles suivantes sont integrées
    "tiles" : [
      {
        "id" : "arobase_BDORTHOR",
        "nom" : "BD-ORTHOR corse",
        "url_zxy" : "http://maparob/Corsica/{z}/{x}/{y}.jpg",
        "attribution" : "Carte BD-ORTHOR _ arobase.fr"
      },{
        "id" : "opentopomap",
        "nom" : "opentopomap",
        "url_zxy" : "https://c.tile.opentopomap.org/{z}/{x}/{y}.png",
        "attribution" : "© OpenStreetMap contributors, SRTM | map style: © OpenTopoMap (CC-BY-SA)"
      },
      {
        "id" : "mapbox.light",
        "nom" : "Light",
        "url_zxy" : "mapbox_zxy"
      },
      {
        "id" : "mapbox.satellite",
        "nom" : "Satellite monde",
        "url_zxy" : "mapbox_zxy"
      },
      {
        "id" : "mapbox.outdoors",
        "nom" : "Outdoors",
        "url_zxy" : "mapbox_zxy"
      }
    ],
    // optionnel (1ere source de "tiles" par default)
    "tileDefault" : "opentopomap"
}
```


## Nouveautés v1.0.30

- Correction de bugs bloquant sur l'affichage de certains layer.
- Éditon des données attributaires
- Builds des dists

### Gérer l'édition des données attributaires de chaque layer editable
```javascript
// A besoin de son css
// map_arob.editLayerProperties/editLayerProperties.css

map_arob.editLayerProperties.init({
    "disable" : true,  //masque les boutons d'édition de données 
    "allowStyleJsonEdit" :  true
});
```
Les données attributaires ont besoin de redéfinir l'event de changement global
```javascript
// (old) Redéfinition des events
map_arob.editmap.isEditingTheLayers = function(e){mDisplaySaveFiche.map = e;mDisplaySaveFiche._event();}
UImap_arob.Editmap.isEditingTheLayers = function(e){mDisplaySaveFiche.UI = e;mDisplaySaveFiche._event();}
// (new) Ajouter l'event d'édition des données attributaires
map_arob.editLayerProperties.isEditingTheLayers = function(e){mDisplaySaveFiche.prop = e;mDisplaySaveFiche._event();}
```

### Build des distribuables
Les builds des ?.full.js passe maintenant par le fichier package.json


Exemples :
==========

Initialisation : 
```javascript
(map_arob.editmap = new editmap(true)).init({
        //optionnel
        stylePolygonDefault: {
            color: "#111111",
            weight: 2,
            fillColor: "#111111",
            fillOpacity: 0.2
        },
        //optionnel
        styleBackgroundPolygonDefault : {
            color: "#2e6da4",
            weight: 2,
            fillColor: "#049fff",
            fillOpacity: 0.4
        },
        //optionnel
        styleLineStringDefault : {
            color: "#FF2600",
            weight: 5
        },
        //optionnel (par defaut les 4, tableau vide pour aucun bouton d'ajout de vecteur)
        buttonsEdition : ["Polygon", "Rectangle", "LineString", "Marker"],
        //optionnel (par defaut true, permet d'afficher ou non le control de couche de fond)
        displayControlBackground : false,
        strings : {
            fr : {
                layerControlCoucheImportee : "élément(s) géometrique(s)",
                labelRectangle : "Aire rectangulaire",
                labelMarker : "Point",
                labelPolygon : "Aire",
                labelLinestring : "Transect",
                title_btn_ajouterUnChemin : "Ajouter un transect",
                title_btn_ajouterUnMarker : "Ajouter un point",
                title_btn_ajouterUnPolygonRectangulaire : "Ajouter une aire rectangulaire (clicker-glisser le curseur)",
                title_btn_ajouterUnPolygon : "Ajouter une aire",
                labelLayerControl_editables : "Obersations"
            }
        }
    });

    //OBLIGATOIREMENT APRES map_arob.editmap
     UImap_arob.Editmap.init(
            {
                strings : {
                    fr: {
                        labelMarker : "Point",
                        labelPolygon : "Aire",
                        labelLinestring : "Transect",
                        erreurConversionCheminEnPolygon : "Un transect doit possèder au moins 3 sommets"
                    }
                }
            }
        )
```

Centrer la caméra : 
```javascript
map_arob.map.panTo(new L.latLng(43,9));
```

Définir le zoom: 
```javascript
map_arob.map.setZoom(7);
```

Redefinir le nom de la capture du screenshot 
```javascript
map_arob.screenshot.setNameFile("capture.jpg")
```

Pour que le screenshot n'apparaisse pas dans la page
```javascript
map_arob.screenshot.imgToDom = function(img){download(img.src, map_arob.screenshot._nameFile );}
```


Ajout de la couche des features editable dans le menu en haut à droite + son nom
```javascript
map_arob.layerControl.addOverlay( map_arob.editmap.theLayers, "Observation", {collapsed: false,autoZIndex: true});
```

Ajout d'un geojson editable
```javascript
map_arob.editmap.SET_EditableGeojson(JSON.parse(data), "newLayers");
```

Ajout d'un geojson de fond
```javascript
//{"type":"FeatureCollection","name" : "La bouche de fond"... 
//champ name pour le nom du fond dans le menu en haut à droite
map_arob.editmap.SET_backgroundGeojson(JSON.parse(data));
//focus sur ce dernier
map_arob.editmap.focusWithIndex("BGLayers", -1)
```

Focus sur une feature 
```javascript
// focusWithIndex(featureGroup ("theLayers", "BGLayers"), index (-1 pour le dernier))
//focus sur la derniere feature des couches de fond
map_arob.editmap.focusWithIndex("BGLayers", -1)
//focus sur la feature à l'index 3  des couches de fond
map_arob.editmap.focusWithIndex("BGLayers", 3)
//focus sur la feature à l'index 3  des couches éditables
map_arob.editmap.focusWithIndex("theLayers", 6)
```
Suppression de toutes les couches editables
```javascript
map_arob.editmap.DELETE_allEditableLayers();
```

Suppression de toutes les couches de fond
```javascript
map_arob.editmap.DELETE_allBackgroundLayers(); 
```

Modifier le chemin des assets du modules customIconMarker
```javascript
map_arob.CustomIconMarker.setCustomRootPath("path/"); 
```

Ajouter le bouton d'import de fichier (geojson, kml, gpx, et zip contenant des shp)
```javascript
//Avant l'instanciation
L.Control.FileLayerLoad.TITLE = "Import  un fichier (GPX, KML, GeoJSON, zip contenant des .shp .dbf)";

var kml = L.Control.fileLayerLoad({
        layer: L.geoJson,
        layerOptions: {style: {color:'red'}},
        addToMap: true,
        fileSizeLimit: 1024,
        formats: [
            '.geojson',
            '.kml',
            '.gpx',
            '.zip'
        ]
        
    }).addTo(map_arob.map);
    kml.loader.on('data:loaded', function(event){
        if(event.format == "zip"){
            var a = event.layer;
        }else{
            var a = event.layer.toGeoJSON();
            map_arob.map.removeLayer(event.layer);
        }        
        map_arob.editmap.SET_EditableGeojson(a, "newLayers");
    })
```

Désactiver le bouton d'import de fichier lorsqu'on est en train d'éditer en mode paramètre 
```javascript
//kml est l'instance de L.Control.fileLayerLoad
map_arob.editmap.setFileLayerLoad(kml);
```




EVENTS
======
Événement lorsqu'une feature est modifiée (terminée de modifier)
```javascript
map_arob.editmap.changed = function () {
    console.info("map_arob.editmap.changed");
    //Récupérer le géojson de toutes les features éditables
    console.log(map_arob.editmap.GET_geoJSON());
}
```

À chaque changement, renvoit si des couches sont en éditions ou non sur la carte
```javascript
map_arob.editmap.isEditingTheLayers = function(e){
    if(e){
        console.log("//des couches sont en édition");
    }else{
        console.log("//aucune couche en édition");
    }
}
```

À chaque changement, renvoit si des couches sont en éditions ou non en mode paramétré
```javascript
UImap_arob.Editmap.isEditingTheLayers = function(e){
    if(e){
        console.log("//des couches sont en édition");
    }else{
        console.log("//aucune couche en édition");
    }
}
```
Lie les deux event "isEditingTheLayers" de map_arob et UImap_arob
```javascript

function displaySaveFiche(){this.map = false;this.UI = false;
    this._event = function(){
        if(!this.map && !this.UI){
            this.event(true);return;
        }
        this.event(false);
    }
    this.event =  function(e){
        if(e){
            console.log("JE PEUX SAUVEGARDER");return; 
        }
        console.log("UNE EDITION EST EN COURS, c'est la map : "+this.map+" c'est l'UI : "+this.UI);
        return;
    }
}
var mDisplaySaveFiche = new displaySaveFiche();

//Redéfinition des events
map_arob.editmap.isEditingTheLayers = function(e){mDisplaySaveFiche.map = e;mDisplaySaveFiche._event();}
UImap_arob.Editmap.isEditingTheLayers = function(e){mDisplaySaveFiche.UI = e;mDisplaySaveFiche._event();}

//Redéfinition l'event des deux events liés
mDisplaySaveFiche.event = function(e){
    //e boolean
}

```
Ecoute le changement du fond de carte
```javascript
map_arob.map.on('baselayerchange', function (e) {
    // retourne l'identifiant du fond
    console.log(e.layer.options.id);
});

```

 

Création geojson
======
Création manuelle d'un geojson
```javascript
//Création d'un geojson
var geoJ = new GeoJSON();

//Création d'un Point
var g = new Geometry("Point");
g.setGeo([42,9]);

//Ajout du point dans le geojson
geoJ.addFeature({}, g)
```

Générer un geojson à partir d'une geometry en objet JS
```javascript
var geoJ = new GeoJSON();
var vinc = {
   "type": "GeometryCollection",
   "geometries": [
       {
           "type": "Point",
           "coordinates": [100.0, 0.0]
       },
       {
           "type": "LineString",
           "coordinates": [
               [101.0, 0.0], [102.0, 1.0]
           ]
       }
   ]
};
geoJ.addFeature({}, GeoJSONParser.validGeometryJson(vinc));

geoJ.export(true);
//'{"type":"Feature","properties":{},"geometry":{"type":"GeometryCollection","geometries":[{"type":"Point","coordinates":[100,0]},{"type":"LineString","coordinates":[[101,0],[102,1]]}]}}'
```

Export d'un geojson
```javascript
//Export du geojson en Objet javascript
geoJ.export();

//Export du geojson en String
geoJ.export(true);
```

STRINGS
======

Editmap
```json
//Option de (map_arob.editmap = new editmap(true)).init(option)
"strings" : {
    "fr" : {
      "alertErreurLineString" : "Un chemin doit cooporter au minimum 2 coordonnées, layer supprimé..",
      "layerCtrlNouveauxLayer" : "Layers ajoutés",
      "labelRectangle" : "Rectangle",
      "labelMarker" : "Marker",
      "labelLinestring" : "Chemin",
      "labelPolygon" : "Polygon",
      "title_btn_edit" : "Editer l'élement",
      "title_btn_focus" : "Zoomer sur l'élement",
      "title_btn_delete" : "Supprimer l'élement",
      "CustomPolygonContour" : "Contour",
      "CustomPolygonLargeurContour" : "Largeur du contour",
      "CustomPolygonCouleurRemplissage" : "Couleur du remplissage",
      "CustomPolygonOpaciteRemplissage" : "Opacité du remplissage",
      "layerControlCoucheAjoute" : "Couches non sauvegardés",
      "layerControlCoucheImportee" : "Couches sauvegardés",
      "title_btn_ajouterUnPolygon" : "Ajouter un polygon",
      "title_btn_ajouterUnPolygonRectangulaire" : "rectangulaire (clicker-glisser le curseur)",
      "title_btn_ajouterUnChemin" : "Ajouter un chemin",
      "title_btn_ajouterUnMarker" : "Ajouter un marker",
      "title_btn_regrouperCouchesAjoutees" : "Sauvegarder les couches",
      "title_btn_regrouperTouteCouchesAjoutees" : "Sauvegarder tout",
      "title_btn_regrouperMarker" : "Regrouper les markers",
      "title_btn_regrouperPolygon" : "Regrouper les polygons",
      "windowsconfirm_suppressionLayer" : "Etes-vous sûr de vouloir supprimer cet élèment ?",
      "labelLayerControl_editables" : "Obersations"
    }
}

UImap_arob.Editmap
```json
//Option de (map_arob.editmap = new editmap(true)).init(option)
"strings" : {
    "fr": {
        "labelMarker" : "Marker",
        "labelPolygon" : "Polygon",
        "labelLinestring" : "Chemin",
        "erreurConversionCheminEnPolygon" : "Un chemin doit possèder au moins 3 sommets pour être converti en polygon"
    }
}
```
screenshot
```json
//Option de map_arob.screenshot.init(option)
"strings" : {
    "fr" : {
        "titlePrendrePhoto" : "Prendre une photo",
        "telecharger" : "Télécharger la capture"
    }
}
```


DEMO
=================

**demo.html** est la carte uniquement

**demo_edition_fiche.js** est la carte + l'editeur manuel de point


DÉPENDANCES
===========

```html
 <!-- https://github.com/Leaflet/Leaflet-->
<script defer  src="leaflet/leaflet.js"></script>
<!-- http://leaflet.github.io/Leaflet.Editable/ -->
<script defer  src="Editable/Leaflet.Editable.js"></script>

<!--https://github.com/calvinmetcalf/shapefile-js-->
<script defer src="shapefile-js/shp.min.js"></script>
<!-- https://github.com/mapbox/togeojson -->
<script defer  src='leaflet.filelayer/togeojson.js'></script>
<!-- ! ! !VERSION MODIFIÉ AROBASE ! ! !
    VOIR GITHUB https://github.com/JimmyBillan/map_arob
    https://github.com/makinacorpus/Leaflet.FileLayer dependence togeojson -->
<script defer  src="leaflet.filelayer/leaflet.filelayer.js"></script>
<!-- https://github.com/CliffCloud/Leaflet.EasyButton -->
<script defer  src="Leaflet.EasyButton/easy-button.js"></script>
<!-- https://www.jsdelivr.com/package/npm/leaflet-image https://github.com/mapbox/leaflet-image -->
<script defer  src='Leaflet.leaflet-image/leaflet-image.js'></script>
<!-- https://github.com/Leaflet/Leaflet.fullscreen utilisé par map_arob.fullscreen/fullscreen.js -->
<script defer  src="Leaflet.fullscreen/Leaflet.fullscreen.min.js"></script>
<!-- https://github.com/ghybs/Leaflet.TileLayer.Fallback -->
<script defer  src="Leaflet.TileLayer.Fallback/leaflet.tilelayer.fallback.js"></script>
<script defer src="map_arob-UImap_arob/UImap_arob.proj/proj4js-2.5.0/dist/proj4-src.js"></script>

<!--Libraries d'arobase.Fr https://github.com/JimmyBillan/map_arob -->
<script defer  src="map_arob-UImap_arob/map_arob.map-only.full.js"></script>
<script defer  src="map_arob-UImap_arob/ui_map_arob.full.js"></script>
```



Library Nécessaires : 
=====================

jquery-3.3.1.min.js (dossier ext)

bootstrap.min.js v3.3.7 (dossier ext)

fontAwesom v4.7.0

Leaflet.js
==========
Version 1.4.0 custom. La customisation déplace les crédits en bas à gauche et définit le max-zoom à 20

https://github.com/Leaflet/Leaflet

Leaflet.Editable
================
Version 1.2.0 
Make geometries editable in Leaflet.

https://github.com/Leaflet/Leaflet.Editable

Leaflet.FileLayer
=================

Loads local files (GeoJSON, JSON, GPX, KML) into the map using the [HTML5 FileReader API](http://caniuse.com/filereader), **without server call** !
Necessite ToGeoJson
https://github.com/makinacorpus/Leaflet.FileLayer

https://github.com/mapbox/togeojson

L.EasyButton
============

The easiest way to add buttons with Leaflet 

https://github.com/CliffCloud/Leaflet.EasyButton

leaflet-image
=============

Export images out of Leaflet maps without a server component, by using Canvas and CORS.

https://www.jsdelivr.com/package/npm/leaflet-image
https://github.com/mapbox/leaflet-image


Leaflet.fullscreen
==================

A HTML5 fullscreen plugin for Leaflet.

https://github.com/Leaflet/Leaflet.fullscreen



Leaflet.TileLayer.Fallback
==========================

Plugin for Leaflet. Replaces missing Tiles (404 error) by scaled lower zoom Tiles.

https://github.com/ghybs/Leaflet.TileLayer.Fallback 