<?php
    global $scripts_extra, $_headerContent;


    function b_icon_file($name, $file, $classplus="") {
        $extension = strrchr($name,'.');
        switch ($extension) {
            case ".gif":
            case ".png":
            case ".jpg":
            case ".jpeg":
            case ".ai":
            case ".dxf":
            case ".tif":
            case ".tiff":
            case ".wmf":
            case ".ps":
            case ".eps":
                $icon = "fa fa-file-image-o fa-fw";
                break;
            case ".json":
            case ".php":
            case ".js":
            case ".css":
            case ".htm":
            case ".html":
                $icon = "fa fa-file-code-o fa-fw";
                break;
            case ".xls":
            case ".xlsx":
            case ".csv":
            case ".dbf":
            case ".ods":
            case ".sql":
                $icon = "fa fa-file-excel-o fa-fw";
                break;
            case ".ppt":
            case ".pptx":
            case ".pps":
            case ".pot":
            case ".potx":
            case ".odp":
                $icon = "fa fa-file-powerpoint-o fa-fw";
                break;
            case ".doc":
            case ".docx":
            case ".rtf":
            case ".odt":
            case ".pages":
                $icon = "fa fa-file-word-o fa-fw";
                break;
            case ".txt":
            case ".md":
                $icon = "fa fa-file-text-o fa-fw";
                break;
            case ".o":
            case ".og":
            case ".mp4":
            case ".webm":
            case ".mg":
            case ".mpg":
            case ".mov":
            case ".3gp":
                $icon = "fa fa-file-video-o fa-fw";
                break;
            case ".mp3":
            case ".wav":
            case ".m4a":
                $icon = "fa fa-file-audio-o fa-fw";
                break;
            case ".pdf":
                $icon = "fa fa-file-pdf-o fa-fw";
                break;
            case ".zip":
            case ".gz":
            case ".7z":
            case ".tar":
            case ".tgz":
            case ".rar":
                $icon = "fa fa-file-archive-o fa-fw";
                break;
            default:
                $icon = "fa fa-file-o fa-fw";;
                break;
        }
        return '<a href="'.$file.'" target="_blank"><i class="'.$icon." ".$classplus.' fa-lg" data-original-title="'.str_replace('"', '\"', $name).'" data-placement="bottom" data-toggle="tooltip"></i></a>';
    }
    
    function add_infos_bib($texte, $sep = ", ", $classe = "") {
        $sortie = "";
        
        if ($texte != "") {
            $sortie = $sep.$texte;
            if ($classe != "") {
                $sortie = '<span class="'.$classe.'">'.$sortie.'</span>';
            }
        }
        
        return $sortie;
    }
    function template_biblio($biblios) {
        $sortie = '';
        if (count($biblios) > 0 ) {
            $sortie .= '<h4>Bibliographie trouve</h4>';
            $sortie .='<ul id="biblio">';
            foreach($biblios as $biblio) {
                $sortie .= '<li>';
                $sortie .= add_infos_bib(utf8_decode($biblio["auteur"]), "");
                $sortie .= add_infos_bib(utf8_decode($biblio["annee"]), ", ");
                $sortie .= add_infos_bib(utf8_decode($biblio["titre"]), " - ", "em");
                $sortie .= add_infos_bib(utf8_decode($biblio["journal"]).((utf8_decode($biblio["journal"]) != "" && utf8_decode($biblio["editeur"]) != "") ? " - " : "" ).utf8_decode($biblio["editeur"]), ". ");
                if ($biblio["tome"] != "" && $biblio["volume"] != "") {
                    $sortie .=  add_infos_bib($biblio["tome"]." (".utf8_decode($biblio["volume"].")"));
                }
                else {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["tome"]));
                    $sortie .=  add_infos_bib(utf8_decode($biblio["volume"]));
                }
                if ($biblio["tome"] != "" || $biblio["volume"] != "") {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["pages"]),":");
                }
                else {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["pages"]));
                }
                if (count($biblio["fichiers"]) > 0) {
                    $sortie .= '&nbsp;';
                    $fichiers = $biblio["fichiers"];
                    foreach ($fichiers as $unficher) {
                        $sortie .= b_icon_file($unficher["nom"], $unficher["url"]);
                    }
                }
                $sortie .= '</li>';
            }
            $sortie .= '</ul>';
        }        
        return $sortie;
    }
    
    function conv2iso($texte) {
        $sortie = $texte;
        $sortie = str_replace("\\u2019", "'", $sortie);
        return $sortie;
    }
    
    /* Espces */
    $taxons =  json_decode(conv2iso(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_list_especes&key=fea9a667df9db40499ebf94e5b6a07f6")), true)["result"]["data"];
    
    $valeurs_taxons = "";
    foreach($taxons as $taxon) {
        $valeurs_taxons .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($taxon["nom_scientifique"]).'"></option>';
    }
    if ($valeurs_taxons != "") {
        $valeurs_taxons = '<datalist id="datalist_espece">'.$valeurs_taxons.'</datalist>';
    }
    
    /* Sites */
    $sites =  json_decode(conv2iso(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_list_sites&key=fea9a667df9db40499ebf94e5b6a07f6")), true)["result"]["data"];
    
    $valeurs_sites= "";
    foreach($sites as $site) {
        $valeurs_sites .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($site["nom"]).'"></option>';
    }
    if ($valeurs_sites != "") {
        $valeurs_sites = '<datalist id="datalist_site">'.$valeurs_sites.'</datalist>';
    }
    
    /* type doc */
    $type_bilio = array(
        "" => "Type de document*",
        "acte" => "Acte",
        "presse" => "Article de presse" ,
        "scientifique" => "Article scientifique",
        "rendu" => "Compte rendu",
        "diapo" => "Diaporama",
        "gestion" => "Document de planification/gestion",
        "guide" => "Guide",
        "livre" => "Livre",
        "memoire" => "Mmoire",
        "communication" => "Outil de communication",
        "pedagogie" => "Outil pdagogique",
        "poster" => "Poster",
        "activite" => "Rapport d'activit",
        "etude" => "Rapport d'tude",
        "juridique" => "Texte juridique",
        "these" => "Thse/HDR"
    );
    
    $menu_type_doc = '<select size= "1" name="options[type_doc]">
    			<option value="" data-default>Type de document : </option>';
    foreach($type_bilio as $code_type=>$label_type) {
        $selected = '';
        if ($type_doc == $code_type) {
            $selected = ' selected="selected"';
        }
        $menu_type_doc .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($code_type).'"'.$selected.'>'.$label_type.'</option>';
    }
    $menu_type_doc .= '</select>';
    
    /* formulaire de recherche */
    $formulaire = '
            <form id="contact-form" action="mobiles.php" method="post">
			    <div class="contact-form-loader"></div>
			    <fieldset>
			    	<label class="twocols">
						<input type="text" name="options[auteur]" placeholder="Auteur :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($auteur).'">
					</label>
					<label class="twocols">
						<input type="text" name="options[titre]" placeholder="Titre :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($titre).'">
					</label>

					<div>
			    		<label class="twocols">
			    			<input name="options[mot_clef]" placeholder="Mot_clef :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($mot_cle).'" type="text">
			    		</label>
			    		<label class="twocols">
			    			<input name="options[espece_nom_scientifique]" placeholder="Espce :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($espece_nom_scientifique).'" type="text" list="datalist_espece">
			    		</label>
			    	</div>
                    
                    <div>
			    		<label class="twocols">
			    			<input name="options[site_nom]" placeholder="Nom du site :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($site_nom).'" type="text" type="text" list="datalist_site">
			    		</label>
			    		<label class="twocols">
    			    			'.$menu_type_doc.'
    			    	</label>
			    	</div>
					<div class="clear"></div>
			    	<div id="brecaptcha">
        				<!-- <div class="g-recaptcha" data-size="compact" data-sitekey="'.$recaptcha_public.'"></div> -->
        				<a href="#" class="btn" data-type="submit_query"><i class="fa fa-user fa-fw fa-lg" aria-hidden="true">&nbsp;</i>Rechercher</a>
        			</div>
			    </fieldset>
                <input type="hidden" name="from_me" value="1">
                <input type="hidden" name="name" value="SimpleDataExt">
                <input type="hidden" name="op" value="get_biblio_ext">
                '.$valeurs_taxons.$valeurs_sites.'
			</form>
';

    /* listing des biblios */
    
    if ($titre.$mot_cle.$espece.$auteur.$espece_nom_scientifique.$site_nom != "") {
        $params = "";
        if ($titre != "") {
            $params .= "&titre=".urlencode($titre);
        }
        if ($mot_cle != "") {
            $params .= "&mot_clef=".urlencode($mot_cle);
        }
        if ($espece != "") {
            $params .= "&espece=".urlencode($espece);
        }
        if ($auteur != "") {
            $params .= "&auteur=".urlencode($auteur);
        }
        if ($espece_nom_scientifique != "") {
            $params .= "&espece_nom_scientifique=".urlencode($espece_nom_scientifique);
        }
        if ($site_nom != "") {
            $params .= "&site_nom=".urlencode($site_nom);
        }
        if ($type_doc != "") {
            $params .= "&type_doc=".urlencode($type_doc);
        }
        $biblios =  json_decode(conv2iso(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_biblio&key=fea9a667df9db40499ebf94e5b6a07f6".$params)), true)["result"]["data"];
        
        if (count($biblios) > 0) {
            $listingb = template_biblio($biblios);
        }
        else {
            $listingb = '<p class="mt20">Aucune fiche bibliographique correspondante n\'a t trouv</p>';
        }
    }
    else {
        global $from_me;
        if ($from_me == "1") {
            $listingb = '<p class="mt20">Il faut un peu plus de critres de recherche que cela...</p>';
        }
        else {
            $listingb = '<p class="mt20">Veuillez saisir un ou plusieurs critres ci-dessus pour effectuer la recherche</p>';
        }
    }
    
    if ($listingb != "") {
        $zoneresult = '<article class="content_gray">
                            <div class="container"><div class="row">
                                <div class="grid_12">
                        			'.$listingb.'
                        		</div>
                            </div></div></div>
                        </article>';    
    }
    else {
        $zoneresult = "";
    }
    
    $sortie = '<div class="container">
            <div class="row">
        		<div class="grid_12">
                    <h3>Recherche bibliographique</h3>
                    <p>Accdez  la base de donnes bibliographiques de l\'OEC via un formulaire pour effectuer des recherches et pouvoir tlcharger les documents publics numriss sur les zones humides.</p>
        			'.$formulaire.'
        		</div>
        	</div>
        </div>'.
        $zoneresult;
	
	require_once('themes/'.$Default_Theme.'/btn_retour.php');

	$_headerContent .= '
<script>
	var nosmoothscroll = true;
</script>
	';	
	
	$scripts_extra .= '
<script type="text/javascript" src="javascripts/lang/lang-french.js" charset="ISO-8859-1"></script>
<script type="text/javascript" src="javascripts/control_form.js" charset="ISO-8859-1"></script>
<script type="text/javascript" src="themes/orzhc/js/jquery.growl.js"></script>
<link rel="stylesheet" href="themes/orzhc/style/jquery.growl.css">
<link rel="stylesheet" href="themes/orzhc/style/contact-form.css">
<script>
	function expedier_post(form) {
	    form.trigger("submit");
	}
	
	jQuery(function () {
		/* validation du post */
		if (jQuery("form [data-type=submit_query]").length > 0) {
			jQuery("form [data-type=submit_query]").click(function(){
				var form = jQuery(this).parents("form");
                expedier_post(form);
				/*if (submit_submit_query(form.get(0))) {
					if (desc_is_empty()) {
						alerte_erreur("Erreur","Veuillez remplir la zone de texte de votre post.", 5000);
					    return false;
					}
					if (jQuery("form [data-type=filesstate]").length > 0 && jQuery("form [data-type=filesstate]")[0].value == "") {
						alerte_erreur("Erreur","Tous vos fichiers n\'ont pas t envoys.<br />Envoyez-les tous ou supprimez-les.", 5000);
					    return false;
					}
					else {
						expedier_post(form);
					}
				}*/
				return false;
			});
		}
	});
	jQuery(function () {
		jQuery("#contact-form").on("keyup keypress", function(e) {
			var keyCode = e.keyCode || e.which;
			if (keyCode === 13) { 
				console.log("submit formulaire neutralis");
				e.preventDefault();
				return false;
			}
		});
	});
</script>
';
	 
	$sortie .= $btn_retour;
	
?>