function SetCookieTheme (name, value) {
	var argv=SetCookieTheme.arguments;
	var argc=SetCookieTheme.arguments.length;
	var expires=(argc > 2) ? argv[2] : null;
	var path=(argc > 3) ? argv[3] : null;
	var domain=(argc > 4) ? argv[4] : null;
	var secure=(argc > 5) ? argv[5] : false;
	document.cookie=name+"="+escape(value)+
		((expires==null) ? "" : ("; expires="+expires.toGMTString()))+
		((path==null) ? "" : ("; path="+path))+
		((domain==null) ? "" : ("; domain="+domain))+
		((secure==true) ? "; secure" : "");
}

function getCookieValTheme(offset) {
	var endstr=document.cookie.indexOf (";", offset);
	if (endstr==-1)
      		endstr=document.cookie.length;
	return unescape(document.cookie.substring(offset, endstr));
}

function GetCookieTheme (name) {
	var arg=name+"=";
	var alen=arg.length;
	var clen=document.cookie.length;
	var i=0;
	while (i<clen) {
		var j=i+alen;
		if (document.cookie.substring(i, j)==arg)
                        return getCookieValTheme (j);
                i=document.cookie.indexOf(" ",i)+1;
                        if (i==0) break;}
	return null;
}

jQuery.fn.extend({
	masquer : function() {
		//jQuery(this).css("display", "none");
		jQuery(this).hide(0);
		//jQuery(this).fadeOut();
	},
	afficher : function() {
		//jQuery(this).css("display", "block");
		jQuery(this).show(0);
		//jQuery(this).fadeIn();
	},
	masquerLent : function() {
		//jQuery(this).css("display", "none").css("transition", "opacity 1s ease-out").css("opacity","0");
		//jQuery(this).hide(2000);
		if (jQuery(this).css("display") != "none") {
			jQuery(this).fadeOut(500);
		}
	},
	afficherLent : function() {
   		//jQuery(this).css("display", "block").css("opacity","1");
   		//jQuery(this).show(2000);
   		if (jQuery(this).css("display") == "none") {
   			jQuery(this).delay(500).fadeIn(500);
   		}
	}
});

function initLangTheme() {
	//init des langues dispos
	var tabLang = new Array("french", "corsican", "italian", "english",);
	//récup langue en cours. Premier élément du tableau si vide
	if (GetCookieTheme("langTheme") == null) {
		var langThemeCurrent = tabLang[0];
	}
	else {
		var langThemeCurrent = GetCookieTheme("langTheme");
	}
	//toutes langues dispos dans la page (drapeaux) et blocs langues masqués
	var tabLangPage = new Array();
	for (var i=0; i<tabLang.length; i++) {
		if (jQuery(".block_"+tabLang[i]).length > 0) {
			tabLangPage.push(tabLang[i]);
			jQuery(".block_"+tabLang[i]).masquer();
		}
	}
	//affichage langue en cours ou première langue tableau des langues non nul
	if (jQuery(".block_"+langThemeCurrent).length > 0) {
		jQuery(".block_"+langThemeCurrent).afficher();
	}
	else {
		if (tabLangPage.length > 0) {
			jQuery(".block_"+tabLangPage[0]).afficher();	
		}
	}
	//affichage barre boutons et boutons langue (s'il y a au moins deux langues)
	if (jQuery("#block_selectlang").length > 0) {
		if (tabLangPage.length > 1) {
			jQuery("#block_selectlang").css("display", "block");
			for (var i=0; i<tabLang.length; i++) {
				if (jQuery("#btn_"+tabLang[i]).length > 0) {
					jQuery("#btn_"+tabLang[i]).masquer();
				}	
			}
			for (var i=0; i<tabLangPage.length; i++) {
				if (jQuery("#btn_"+tabLangPage[i]).length > 0) {
					jQuery("#btn_"+tabLangPage[i]).afficher();
					jQuery("#btn_"+tabLangPage[i]).prop("langue", tabLangPage[i] );
					jQuery("#btn_"+tabLangPage[i]).click(function() {
						var id = tabLangPage[i];
						for (var j=0; j<tabLangPage.length; j++) {
							if (jQuery(this).prop("langue") != tabLangPage[j]) {
								jQuery(".block_"+tabLangPage[j]).masquerLent();
							}
						}
						jQuery(".block_"+jQuery(this).prop("langue")).afficherLent();
						var date_exp = new Date();
						date_exp.setTime(date_exp.getTime()+(365*24*3600*1000)); //cookie valable 1 an
						SetCookieTheme("langTheme",jQuery(this).prop("langue"),date_exp);
					});
					jQuery("#btn_"+tabLangPage[i]).css("cursor","pointer");
				}	
			}
		}
		else {
			jQuery("#block_selectlang").css("display", "none");
		}
	}
}

jQuery(document).ready(function(){
	initLangTheme();
});
jQuery(window).load(function(){
	initLangTheme();
});