package com.jeroenwijering.plugins {


import com.adobe.images.JPGEncoder;
import com.jeroenwijering.events.*;

import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.system.*;
import flash.utils.*;
import flash.text.*


/**
* This plugins renders a JPG snapshot from a video frame.
* It sends the JPG to a serverside script for processing and displays the returning URL.
*
* Alternatively, the player can send just a position variable to the server.
* The server then has to take care of rendering the snapshot.
**/
public class Snapshot extends MovieClip implements PluginInterface {


	/** Background image. **/
	private var back:Sprite;
	/** The bitmap object to use for storing the snapshot contents. **/
	private var bitmap:BitmapData;
	/** List with configuration settings. **/
	public var config:Object = {
		data:true,
		script:undefined
	};
	/** Instance of the object that will encode the snapshot. **/
	private var encoder:JPGEncoder;
	/** The textfield showing all messages. **/
	private var field:TextField;
	/** Loader that sends the jpg data and retrieves the image url. **/
	private var loader:URLLoader;
	/** The current position inside the video. **/
	private var position:Number;
	/** Reference to the snapshot. **/
	private var snapshot:String;
	/** Reference to the View of the player. **/
	private var view:AbstractView;


	/** Constructor; set security directive for the download dialog. **/
	public function Snapshot():void {
		Security.allowDomain("*");
		bitmap = new BitmapData(320,240,false,0x000000);
		encoder = new JPGEncoder(90);
		buildStage();
	};


	/** Build all stage graphics. **/
	private function buildStage():void {
		back = new Sprite();
		back.buttonMode = true;
		back.graphics.beginFill(0x000000,0.5);
		back.graphics.drawRect(0,0,400,20);
		back.graphics.beginFill(0x000000,0.6);
		back.graphics.drawRect(0,20,400,20);
		addChild(back);
		field = new TextField();
		field.defaultTextFormat = new TextFormat('_sans',13,0xFFFFFF,null,null,null,null,null,TextFormatAlign.CENTER);
		field.mouseEnabled = false;
		field.y = 10;
		addChild(field);
	};


	/** The initialize call is invoked by the player View. **/
	public function initializePlugin(vie:AbstractView):void {
		view = vie;
		view.addControllerListener(ControllerEvent.RESIZE,resizeHandler);
		view.addModelListener(ModelEvent.TIME,timeHandler);
		view.addModelListener(ModelEvent.META,metaHandler);
		back.addEventListener(MouseEvent.CLICK,clickHandler);
		field.htmlText = "<u>Start the video to select a frame</u>";
		resizeHandler();
	};


	/** When metadata is received, build a new bitmap object with the right dimensions. **/
	private function metaHandler(evt:ModelEvent):void {
		if(evt.data.width && evt.data.height) {
			bitmap = new BitmapData(evt.data.width,evt.data.height,false,0x000000);
		}
	};


	/** Handle a resize of the display. **/
	private function resizeHandler(evt:ControllerEvent=null):void {
		if(config['width']) {
			x = config['x'];
			y = config['y'];
			back.width = field.width = config['width'];
		} else {
			back.width = field.width = view.config['width'];
		}
		field.x = 0;
	};


	/** Invoked when the span button is clicked; it'll setup and send the servercall. **/
	private function clickHandler(evt:MouseEvent):void {
		if(view.config['state'] == ModelStates.IDLE) {
			if(snapshot) {
				navigateToURL(new URLRequest(snapshot));
			} else {
				view.sendEvent('PLAY','true');
			}
		} else {
			field.htmlText = 'Rendering snapshot, please wait...';
			sendBitmap();
			view.sendEvent('STOP');
			back.buttonMode = false;
		}
	};


	/** Encode and send a bitmap of the video. **/
	private function sendBitmap():void {
		var req:URLRequest = new URLRequest(view.config['snapshot.script']);
		if(view.config['snapshot.data'] == false) {
			req.method = URLRequestMethod.GET;
			req.data = new URLVariables('position='+position);
		} else {
			bitmap.draw(view.skin.display.media);
			req.requestHeaders.push(new URLRequestHeader("Content-type","application/octet-stream"));
			req.method = URLRequestMethod.POST;
			req.data = encoder.encode(bitmap);
		}
		loader = new URLLoader();
		loader.addEventListener(Event.COMPLETE,loaderHandler);
		loader.load(req);
	};


	/** Save the current position in the video; needed for a snapshot later on. **/
	private function timeHandler(evt:ModelEvent=null):void {
		position = Math.round(evt.data.position*10)/10;
		if (position > 0) {
			var pos:String = position.toString();
			if(pos.indexOf('.') == -1) { pos += '.0'; }
			field.htmlText = "<u>Select frame at "+pos+" seconds</u>";
		}
	};


	/** Reload the video after a timeout. **/
	private function loaderHandler(evt:Event):void {
		var img:String = loader.data as String;
		if(img.length > 6) { 
			view.config['image'] = snapshot = img;
			view.sendEvent('LOAD',view.config);
			field.htmlText = 'Snapshot ready; <u>click to download</u> or retry.';
		} else { 
			field.htmlText = 'Position received; server is rendering snapshot.';
		}
		back.buttonMode = true;
	};


};


}