<?php
/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2010 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * This is the File Manager Connector for PHP.
 */

ob_start() ;

require('./config.php') ;
require('./util.php') ;
require('./io.php') ;
require('./basexml.php') ;
require('./commands.php') ;
require('./phpcompat.php') ;

if ( !$Config['Enabled'] )
	SendError( 1, 'This connector is disabled. Please check the "editor/filemanager/connectors/php/config.php" file' ) ;

DoResponse() ;

function DoResponse()
{
    if (!isset($_GET)) {
        global $_GET;
    }
	if ( !isset( $_GET['Command'] ) || !isset( $_GET['Type'] ) || !isset( $_GET['CurrentFolder'] ) )
		return ;

	// Get the main request informaiton.
	$sCommand		= $_GET['Command'] ;
	$sResourceType	= $_GET['Type'] ;
	$sCurrentFolder	= GetCurrentFolder() ;
	$sSortFiles	= $_GET['SortFiles'] ;
	//die("\ntoto:".$sSortFiles."//");
	
	//Suppression du fichier
	if ( $sCommand == 'DelFile' )
	{
		$file = trim($sCurrentFolder, '/');
		$sCurrentFolder = rtrim($sCurrentFolder, '/');
		$sCurrentFolder = substr($sCurrentFolder, 0, strrpos($sCurrentFolder, '/') + 1);
		$filepath = ServerMapFolder( $sResourceType, $currentFolder ) . $file;
		unlink($filepath);
	
		$sCommand == 'GetFoldersAndFiles';
	}
		
	//Suppression du dossier
	if ( $sCommand == 'DelFolder' )
	{
		$file = trim($sCurrentFolder, '/');
		$sCurrentFolder = rtrim($sCurrentFolder, '/');
		$sCurrentFolder = substr($sCurrentFolder, 0, strrpos($sCurrentFolder, '/') + 1);
		$filepath = ServerMapFolder( $sResourceType, $currentFolder ) . $file;
		deleteDirectory($filepath);
	
		$sCommand == 'GetFoldersAndFiles';
	}
	

	// Check if it is an allowed command
	if ( ! IsAllowedCommand( $sCommand ) )
		SendError( 1, 'The "' . $sCommand . '" command isn\'t allowed' ) ;

	// Check if it is an allowed type.
	if ( !IsAllowedType( $sResourceType ) )
		SendError( 1, 'Invalid type specified' ) ;

	// File Upload doesn't have to Return XML, so it must be intercepted before anything.
	if ( $sCommand == 'FileUpload' )
	{
		FileUpload( $sResourceType, $sCurrentFolder, $sCommand ) ;
		return ;
	}

	CreateXmlHeader( $sCommand, $sResourceType, $sCurrentFolder ) ;

	// Execute the required command.
	switch ( $sCommand )
	{
		case 'GetFolders' :
			GetFolders( $sResourceType, $sCurrentFolder ) ;
			break ;
		case 'GetFoldersAndFiles' :
			GetFoldersAndFiles( $sResourceType, $sCurrentFolder, $sSortFiles) ;
			break ;
		case 'CreateFolder' :
			CreateFolder( $sResourceType, $sCurrentFolder ) ;
			break ;
	}

	CreateXmlFooter() ;

	exit ;
}
?>
