<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */
/*                                                                      */
/*   																	*/
/* Baliste "Data Manager" Module . Stephan ACQUATELLA 2006				*/
/* 												      					*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Init Part
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

//require_once("core/mainfile.php");
require_once("core/becms_sform_class.php");
require_once("core/minixml/minixml.inc.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

/**
 * main
 * display liste by Theme, and Categories
 * @param
 * @return
 * @see
 */
function main() {
	global $sitename, $prefix, $db;
	include ('header.php');
	echo "<h1>"._DATA_TITLE."</h1>";
	echo "<fieldset><legend>"._DATA_THEME_ACCESS."</legend>";
	echo listThemes();
	echo "</fieldset>";
	echo "&nbsp;<br />";
	echo "<fieldset><legend>"._DATA_CATEGORY_ACCES."</legend>";
	echo listCategory();
	echo "</fieldset>";
	include ('footer.php');
}


/**
 * main
 * display liste by Theme, and Categories
 * @param
 * @return
 * @see
 */
function userlist($formid="",$dataid=null) {
	global $sitename,$module_name;
	include ('header.php');
	echo "<h1>"._DATA_USER."</h1>";
	echo "<p>"._DATA_USER_MESS."</p>";

	listData($formid,$dataid);

	$bardef=array(
	"back"=>"modules.php?name=$module_name",
	"top" =>"#top" );
	buttonBar ($bardef);

	include ('footer.php');
}

function listDataContent($formid,$dataid) {
	global $prefix, $db, $ongletDef,$module_name,$page_en_cours;
	$articles_par_page = 25;
	if (!isset($page_en_cours) || $page_en_cours=="") {
		$page_en_cours = 1;
	}
	include ('header.php');
	//	echo "<h1>"._DATA_USER."</h1>";
	//	echo "<p>"._DATA_USER_MESS."</p>";

	$iconeNew = "<img src=\"modules/".$module_name."/images/table_add.gif\" border=\"0\" \>";
	$iconeEdit = "<img src=\"modules/".$module_name."/images/table_edit.gif\" border=\"0\" \>";
	$iconeDelete = "<img src=\"modules/".$module_name."/images/table_delete.gif\" border=\"0\" \>";
	$iconeView = "<img src=\"modules/".$module_name."/images/table.gif\" border=\"0\" \>";

	$result = $db->sql_query("select data_dataid, data_data_author,data_data_content, data_data_date, data_mgr_dataid from ".$prefix."_data_data where data_mgr_dataid='$dataid' order by data_data_date");
	$index_pages = getPagesIndex($page_en_cours,$articles_par_page,$db->sql_numrows($result));
	$limInf = ($page_en_cours-1)*$articles_par_page;
	$limit_fiches = $limInf.",".$articles_par_page;

	$result = $db->sql_query("select data_dataid, data_data_author,data_data_content, data_data_date, data_mgr_dataid from ".$prefix."_data_data where data_mgr_dataid='$dataid' order by data_data_date limit $limit_fiches");
	$xmlDoc = new MiniXMLDoc();
	$tab_data_dataid = array();
	$tab_data_data_author = array();
	$tab_data_data_date = array();
	$tab_data_data_action = array();
	$datas = array();
	while (list($data_dataid, $data_data_author,$data_data_content, $data_data_date,$data_mgr_dataid) = $db->sql_fetchrow($result)) {
		$xmlDoc->fromString($data_data_content);
		$formAsArray=$xmlDoc->toArray();
		$datas=$formAsArray["Form"];
		$tab_data_dataid[]=$data_dataid;
		$tab_data_data_author[] = $data_data_author;
		$tab_data_data_date[] = $data_data_date;
		$linkEdit="<a href=\"modules.php?name=$module_name&sop=displayForm&data_dataid=$data_dataid&formid=$formid&dataid=$data_mgr_dataid\" title=\""._DATAEDIT."\">$iconeEdit</a>";
		$linkView="<a href=\"modules.php?name=$module_name&sop=viewForm&formid=$formid&data_dataid=$data_dataid&dataid=$data_mgr_dataid\" title=\""._DATAVIEW."\">$iconeView</a>";
		$tab_data_data_action[] = $linkView." ".$linkEdit;
	}
	$index_fiche = 0;
	foreach ($tab_data_data_date as $data_data_date) {
		if ($datas[_num]) {
			$datas[$index_fiche]["data_data_date"] = preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#i", "\\3/\\2/\\1", $data_data_date);
			$datas[$index_fiche]["data_data_action"] = $tab_data_data_action[$index_fiche];
		}
		else {
			$datas["data_data_date"] = preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#i", "\\3/\\2/\\1", $data_data_date);
			$datas["data_data_action"] = $tab_data_data_action[$index_fiche];
		}
		$index_fiche++;
	}
	if ($datas[_num]) {
		for ($i=0;$i<$datas[_num];$i++) {
			$datas[$i] = array_map("html_entity_decode",$datas[$i]);
			$datas[$i] = array_map("html_entity_decode",$datas[$i]);
			$datas[$i] = array_map("nl2br",$datas[$i]);
		}
	}
	else {
		if (is_array($datas)) {
			$datas2 = array_map("html_entity_decode", $datas);
			$datas2 = array_map("html_entity_decode",$datas2);
			$datas2 = array_map("nl2br",$datas2);
			$datas = array($datas2);
		}
		else {
			$datas = array();
		}
	}

	if (isset($datas) && count($datas)>0) {
		require_once("modules/Sections/connector_class.php");
		$cc = new pageconnector();
		$fiche = $cc->getPageContent("","list.".$formid);
		preg_match("#(.*)<!--start_repeat-->(.*)<!--end_repeat-->(.*)#i",$fiche,$part_form);

		echo str_replace("<!--index_pages-->",$index_pages,$part_form[1]);

		//		echo "<td class=systemTabHeader><b>"._DATATITLEDATE."</b></td>";
		//		echo "<td class=systemTabHeader><b>"._DATATITLEAUTHOR."</b></td>";
		//		echo "<td class=systemTabHeader align=\"center\">"._FUNCTIONS."</td>";

		foreach($datas as $data) {
			if (is_array($data)) {
				$fiche = $part_form[2];
				$fiche = str_ireplace("data[","\$data[",$fiche);
				$fiche = addslashes($fiche);
				eval("\$fiche = \"".$fiche."\";");
				$fiche = stripslashes($fiche);
				echo $fiche;
			}
		}
		echo str_replace("<!--index_pages-->",$index_pages,$part_form[3]);
	}
	$bardef=array(
	"back"=>"modules.php?name=$module_name",
	"top" =>"#top" );
	buttonBar ($bardef);

	include ('footer.php');
}

/**
 * listPin()
 * display Pin list sorted by Theme or category
 * @param typid :organism type id
 * @param comid :competences domaine id
 * @param sortBy : data sorted by competence or organism type
 * @return
 * @see
 */
function listPin($data_theme, $data_category, $sortBy) {
	global $sitename, $prefix, $db,$module_name;
	include ('header.php');
	if (!is_null($data_theme)) {
		$result = $db->sql_query("select dataid, data_pin, data_description, data_formid, data_theme, data_cat, data_pin_img from ".$prefix."_data_mgr where data_theme='$data_theme' order by data_order");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('listPin :: Invalid query');
		}
		$result2 = $db->sql_query("select data_theme, data_theme_description from ".$prefix."_data_theme where data_themeid='$data_theme'");
		if (!$result2) {
			print_r ( $db->sql_error () );
			die('listPin (2):: Invalid query');
		}
		list($data_theme, $data_theme_description)= $db->sql_fetchrow($result2);

		// ---------------- Title ----------------------------
		echo "<h1>$data_theme</h1>";
		echo "<p>$data_theme_description</p>";
		echo "<p class=\"note\">"._DATA_PIN_MESS."</p>";
		echo "<fieldset><legend>"._DATA_LIST_FORM."</legend>";
		$iconeNew = "<img src=\"modules/".$module_name."/images/table_add.gif\" border=\"0\" \>";
		$iconeList = "<img src=\"modules/".$module_name."/images/table_multiple.gif\" border=\"0\" \>";
		echo "<ul>";
		while(list($dataid, $data_pin, $data_description, $data_formid, $data_them, $data_cat, $data_img) = $db->sql_fetchrow($result)) {
			$linkNew="<a href=\"modules.php?name=$module_name&sop=displayForm&formid=$data_formid&dataid=$dataid\" title=\""._DATAADD."\">$iconeNew</a>";
			$linkDatas="<a href=\"modules.php?name=$module_name&sop=userlist&formid=$data_formid&dataid=$dataid\" title=\""._DATAYOURLIST."\">$iconeList</a>";
			echo "<li><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
			echo $linkNew."</td><td width=\"10\"></td><td>".$linkDatas."</td><td width=\"15\"></td><td>";
			echo "<b>".$data_pin."</b>";
			if ($data_description != "") {
				echo "</td><td>&nbsp;: ";
				echo $data_description;
			}
			echo "</td></tr></table></li>";
		}
		echo "</ul>";
		echo "</fieldset>";
	}
	if (!is_null($data_category)) {
		$result = $db->sql_query("select dataid, data_pin, data_description, data_formid, data_theme, data_cat, data_pin_img  from ".$prefix."_data_mgr where data_cat='$data_category'");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		$result2 = $db->sql_query("select data_category,data_cat_description from ".$prefix."_data_categories where data_catid='$data_category'");
		if (!$result2) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		list($data_category,$data_cat_description)= $db->sql_fetchrow($result2);
		// ---------------- Title ----------------------------
		echo "<h1>$data_category</h1>";
		echo "<p>$data_cat_description</p>";
		echo "<p class=\"note\">"._DATA_PIN_MESS."</p>";
		echo "<fieldset><legend>"._DATA_LIST_FORM."</legend>";
		$iconeNew = "<img src=\"modules/".$module_name."/images/table_add.gif\" border=\"0\" \>";
		$iconeList = "<img src=\"modules/".$module_name."/images/table_multiple.gif\" border=\"0\" \>";
		echo "<ul>";
		while(list($dataid, $data_pin, $data_description, $data_formid, $data_them, $data_cat, $data_img) = $db->sql_fetchrow($result)) {
			$linkNew="<a href=\"modules.php?name=$module_name&sop=displayForm&formid=$data_formid&dataid=$dataid\" title=\""._DATAADD."\">$iconeNew</a>";
			$linkDatas="<a href=\"modules.php?name=$module_name&sop=userlist&formid=$data_formid&dataid=$dataid\" title=\""._DATAYOURLIST."\">$iconeList</a>";
			echo "<li><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
			echo $linkNew."</td><td width=\"10\"></td><td>".$linkDatas."</td><td width=\"15\"></td><td>";
			echo "<b>".$data_pin."</b>";
			if ($data_description != "") {
				echo "</td><td>&nbsp;: ";
				echo $data_description;
			}
			echo "</td></tr></table></li>";
		}
		echo "</ul>";
		echo "</fieldset>";
	}
	if (is_null($data_category) && is_null($data_theme)) {
		echo ""._NOPININCAT ."";
	}
	$bardef=array(
	"back"=>"modules.php?name=$module_name",
	"top" =>"#top" );
	buttonBar ($bardef);
	include ('footer.php');
}
/**
 * listCategory()
 * display list of existing Category
 * @param
 * @return
 * @see
 */
function listCategory() {
	global $sitename, $prefix, $db,$module_name;
	$result = $db->sql_query("select data_catid, data_category from ".$prefix."_data_categories order by data_cat_order");
	$mycontent="<ul>";
	while(list($data_catid, $data_category) = $db->sql_fetchrow($result)) {
		$mycontent.="<li><a href=\"modules.php?name=$module_name&amp;sop=listPin&data_category=$data_catid\">$data_category</a></li>";
	}
	$mycontent.="</ul>";
	return $mycontent;
}
/**
 * listThemes()
 * list existing Themes domaine
 * @param
 * @return
 * @see
 */
function listThemes() {
	global $sitename, $prefix, $db,$module_name;
	$result = $db->sql_query("select data_themeid, data_theme from ".$prefix."_data_theme order by data_theme_order");
	$mycontent="<ul>";
	while(list($data_themeid, $data_theme) = $db->sql_fetchrow($result)) {
		$mycontent.="<li><a href=\"modules.php?name=$module_name&amp;sop=listPin&data_theme=$data_themeid\">$data_theme</a></li>";
	}
	$mycontent.="</ul>";
	return $mycontent;
}
/**
 * listPinByChar()
 *
 * @param
 * @return nothing
 */
function listPinByChar($myfilter){
	global $sitename, $prefix, $db;
	include ('header.php');
	OpenTable();
	if ($myfilter == "") $myfilter="A";
	if ($myfilter!="") 	$thefilter="WHERE nom_acteur LIKE '$myfilter%'";
	$result = $db->sql_query("select actid, nom_acteur, sigle_acteur from ".$prefix."_annuaireacteur_acteur $thefilter order by nom_acteur");


	echo "<P align=center><FONT class=title>Annuaire des Acteurs de l'Environnement de la Corse</FONT></P>";
	echo "<center>"
	."<form action=\"modules.php?name=Search\" method=\"post\">"
	."<input type=\"hidden\" name=\"type\" value=\"acteurs\">"
	.""._SEARCHONACTEUR.": <input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\">"
	."</form>"
	."[ <a href=\"index.php\">"._GOTOHOME."</a> | <a href=\"modules.php?name=Annuaire_Acteurs&sop=displayAccess\">"._THEMECATEGORYACCES."</a> ]</center>";
	echo "<br>";


	echo "<table class=\"tab\" width=\"100%\"><tr>"
	//."<td class=\"titretab\ width=\"75%\"><b>"._ACTEUR_NAME."</b></td>"
	//."<td class=\"titretab\ width=\"25%\"><b>"._ACTEUR_SIGLE."</b></td>"
	."<td class=\"titretab\" colspan=2><b>".displayAlphabet("modules.php?name=Annuaire_Acteurs&sop=listActeurByChar")."</td>"
	."</tr>";

	$pos=0;
	while(list($actid, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
		if ($pos % 2 ==0){$gbcolor="#CCCCCC";} else {$gbcolor="#ccd5d8";}
		$sectionLink="<a href=\"modules.php?name=Annuaire_Acteurs&sop=viewActeur&actid=$actid\" >";
		echo "<tr bgcolor=\"$gbcolor\">"
		."<td align=\"left\">$sectionLink $nom_acteur</a></td>"
		."<td align=\"center\"> $sigle_acteur</td>"
		."</tr>";
		$pos++;
	} // End While
	echo "</table>";

	CloseTable();
	include ('footer.php');
}


/**
 * viewPin()
 * view Pin data form data
 * @param acid :Pin id
 * @return
 * @see
 */
function viewPin($dataid) {
	global $m ,$sitename, $prefix, $db, $admin, $uid,$module_name;
	include ('header.php');

	// get information about Pin
	$result = $db->sql_query("select dataid, data_pin, data_description,  data_formid, data_theme, data_cat, data_pin_img  from ".$prefix."_data_mgr where dataid='$dataid'");
	if (!$result) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	list( $dataid, $data_pin, $data_description, $data_formid, $data_theme, $data_cat, $data_pin_img)= $db->sql_fetchrow($result);

	// get information about Theme
	$result2 = $db->sql_query("select data_theme from ".$prefix."_data_theme where data_themeid='$data_theme'");
	if (!$result2) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	// get Information about Category
	$result3 = $db->sql_query("select data_category from ".$prefix."_data_categories where data_catid='$data_cat'");
	if (!$result3) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}

	// get Form

	$m=new form_handler($db, $prefix);
	$mess=$m->sform_read_form($data_formid);
	$m->add_form_title("$data_pin"); // give a unique name to the form
	$m->add_form_check("true"); // if there is obligatory field, check it
	$m->add_form_method("get");
	$m->add_mess("Formulaire d'acquisition de donn�es'"); // the message for obligatory field
	$m->add_submit_value("ok"); // the var used to manage the return
	$m->add_url("modules.php"); // If submit, the url to go
	$m->add_field("name","","BalisteData",'hidden',false);
	$m->add_field("sop","","viewPin",'hidden',false);
	$m->add_field("dataid","","$dataid",'hidden',false);
	$isnow=$uid.";".date("dmy-H_i_s");
	//echo "$isnow";
	$m->add_field("Time", "Date","$isnow",'hidden',true,50,"",""); // is need to identify data
	//$m->add_field("Time", "Date","$isnow",'text',false,50,"","");
	$m->add_key("Time");
	$m->add_extra("<tr><td align=center colspan=2>");
	$m->add_field("","","Soumettre",'submit',false);





	OpenTable();

	echo "<table class=dataTitle>";
	echo "<tr><td class=dataTitle>$data_pin</td></tr>";
	echo "<tr><td class=dataDesc>$data_description</td></tr>";
	echo "</table>";

	echo "<table class=pinTable>";

	// Manage the <Form>
	if( !isset($GLOBALS["ok"]) ){
		echo "<tr class=pinTR><td class=pinDesc>$data_description</td><td>".$m->print_form("white")."</td></tr>";
	} else {
		$m->make_response();
		echo "<tr class=pinTR><td class=pinDesc>$data_description</td><td>";
		$m->aff_response("class=content");
		echo $m->print_form("white");
		echo "</td></tr>";
	}

	echo "</table>";

	$bardef=array("print"=>"modules.php?name=$module_name&sop=printpage&amp;data_id=$data_id",
	"pdf"=>"modules.php? name=$module_name&sop=printpage&amp;artid=$artid",
	"back"=>"modules.php? name=$module_name&sop=listPin&amp;data_theme=$data_theme",
	"mailto"=>"mailto:stephan@toto.com",
	"top" =>"" );
	buttonBar ($bardef);

	CloseTable();

	adminEditButton("system.php?op=dataEditPin&dataid=$dataid&editForm=1");
	//if (is_admin($admin)) {
	//		    echo "<br><br><center><font class=\"content\">[<a href=\"system.php?op=dataEditPin&dataid=$dataid&editForm=1\">"._EDIT."</a> ]</font></center>";
	//		}
	include ('footer.php');
}


/**
 * displayForm
 * display form for new data or for edit
 * @param data id
 * @param form name must name of a form in forms folder. ocic -> file is form.ocic.html
 * @return nothing
 *
 */
function displayForm($data_dataid, $formid, $dataid=null){
	global $m ,$sitename, $prefix, $db, $admin, $uid, $cookie, $currentlang,$module_name;

	if (is_user($user)) {
		cookiedecode($user);
		$logname = $cookie[1];
	} else {
		$logname="anonymous";
	}

	if ($formid=="") $formid="balistis";

	//	if ($dataid) {$mydataid=$dataid;} else {$mydataid=$data_dataid;}

	// get pin title and descrisption if pin id is provided
	/*	if ($mydataid) {
	$result = $db->sql_query("select data_pin, data_description, data_theme, data_cat, data_pin_img from ".$prefix."_data_mgr where dataid='$mydataid'");
	list($data_pin, $data_description, $data_theme, $data_cat, $data_pin_img ) = $db->sql_fetchrow($result);
	$PinTitle=$data_pin;
	$PinDescription=$data_description;
	} else {
	$PinTitle=_DATA_PIN;
	$PinDescription=__DATA_DESCRIPTION;
	}*/

	// getData
	//echo "//$data_dataid//";
	if ($data_dataid!="") {
		$result = $db->sql_query("select data_data_author, data_data_content  from ".$prefix."_data_data where data_dataid='$data_dataid'", $db);
		list($data_data_authors, $data_data_content ) = $db->sql_fetchrow($result);
		$xmlDoc = new MiniXMLDoc();
		$xmlDoc->fromString($data_data_content);
		$formAsArray=$xmlDoc->toArray();
		$data1=$formAsArray["Form"];
		$data = array_map("html_entity_decode", $data1);
		$dataForm_dataid.="\n<input type=\"hidden\" name=\"data_dataid\" value=\"$data_dataid\" >";
	}

	$db->sql_freeresult($result);
	include ('header.php');
	//------------------Data------------------------------
	if (isset($data) && count($data)>0) {
		echo '<script language="JavaScript">'."\n";
		echo "var data_datas = new Array();"."\n";
		foreach($data as $champ => $valeur) {
			echo 'data_datas["data['.$champ.']"] = "'.str_replace("\r","",str_replace("\n",'\n',html_entity_decode($valeur))).'";'."\n";
		}
		echo '</script>'."\n";
		echo '<script type="text/javascript">
function initFormDatas(formulaire) {
	for (var i in data_datas) {
		if (formulaire.elements[i].length && (formulaire.elements[i][0].type == "radio" || formulaire.elements[i][0].type == "checkbox")) {
			for (var j=0; j<formulaire.elements[i].length;j++) {
				if (formulaire.elements[i][j].value == data_datas[i]) {
					formulaire.elements[i][j].checked = true;
				}
			}
		}
		else {
			switch (formulaire.elements[i].type) {
				case "text":
				case "hidden":
				case "textarea" :
				case "select-one" :
				case "textarea" :
				case "password" :
					formulaire.elements[i].value = data_datas[i];
					break;
				case "radio","checkbox" :
					if (formulaire.elements[i].value == data_datas[i]) {
						formulaire.elements[i].checked = true;
					}
					break;
				case "select-multiple" :
					break;
			}
		}
	}
}
</script>';
	}
	// ---------------- Title ----------------------------
	/*echo "<table class=dataTitle>";
	echo "<tr><td class=dataTitle>$PinTitle</td></tr>";
	echo "<tr><td class=dataDesc>$PinDescription</td></tr>";
	echo "</table>";*/

	// include control form API
	$the_form = "\n<script language=\"Javascript\" src=\"javascripts/control_form.js\"></script>\n";
	$the_form .= "\n<SCRIPT language=\"JavaScript\" src=\"javascripts/lang/lang-$currentlang.js\"></SCRIPT>\n";
	$the_form .= "\n<form name=\"data_form\" action=\"modules.php\" method=\"POST\" onsubmit=\"return submit_form(this)\">";
	$the_form .= "\n<input type=\"hidden\" name=\"sop\" value=\"saveForm\" />";
	$the_form .= "\n<input type=\"hidden\" name=\"name\" value=\"$module_name\" />";
	$the_form .= "\n<input type=\"hidden\" name=\"formid\" value=\"$formid\" />";
	$the_form .= "\n<input type=\"hidden\" name=\"dataid\" value=\"$dataid\" />";
	$the_form .= $dataForm_dataid;
	//	echo "<center>";
	// get form
	//	$tmpl_file = "modules/BalisteDataS/forms/form.$formid.html";
	//	include($tmpl_file);
	require_once("modules/Sections/connector_class.php");
	$cc = new pageconnector();
	$the_formulaire = $cc->getPageContent("","form.".$formid);

	echo preg_replace("#<form([^>]*)>#i",$the_form,$the_formulaire);

	//	echo "</center>";
	//	echo "</form>";

	if (isset($data) && count($data)>0) {
		echo '<script language="Javascript">
initFormDatas(document.forms["data_form"]);
if (typeof(init_the_form) == \'function\') {
	init_the_form(document.forms["data_form"]);
}
</script>';
	}

	$bardef=array(
	"back"=>"modules.php?name=$module_name&sop=userlist",
	"top" =>"#top" );
	buttonBar ($bardef);
	adminEditButton("system.php?op=dataPin");
	include ('footer.php');
}

/**
 * viewForm
 * display data
 * @param data id
 * @param form name must name of a form in forms folder. ocic -> file is view.ocic.html
 * @return nothing
 *
 */
function viewForm($data_dataid, $formid,$dataid=null){
	global $m ,$sitename, $prefix, $db, $admin, $uid,$module_name;
	if (is_user($user)) {
		cookiedecode($user);
		$logname = $cookie[1];
	} else {
		$logname="anonymous";
	}
	// get pin title and descrisption if pin id is provided
	/*if ($data_dataid) {
	$result = $db->sql_query("select data_pin, data_description, data_theme, data_cat, data_pin_img from ".$prefix."_data_mgr where dataid='$data_dataid'");
	list($data_pin, $data_description, $data_theme, $data_cat, $data_pin_img ) = $db->sql_fetchrow($result);
	$PinTitle=$data_pin;
	$PinDescription=$data_description;
	} else {
	$PinTitle=_DATA_PIN;
	$PinDescription=__DATA_DESCRIPTION;
	}*/

	if ($formid=="") $formid="balistis";

	// getData
	if ($data_dataid!="") {
		$result = $db->sql_query("select data_data_author, data_data_content  from ".$prefix."_data_data where data_dataid='$data_dataid'");
		list($data_data_authors, $data_data_content ) = $db->sql_fetchrow($result);
		$xmlDoc = new MiniXMLDoc();
		$xmlDoc->fromString($data_data_content);
		$formAsArray=$xmlDoc->toArray();
		$data1=$formAsArray["Form"];
		$data = array_map("html_entity_decode", $data1);
	}
	$db->sql_freeresult($result);

	include ('header.php');
	// ---------------- Title ----------------------------
	/*echo "<table class=dataTitle>";
	echo "<tr><td class=dataTitle>$PinTitle</td></tr>";
	echo "<tr><td class=dataDesc>$PinDescription</td></tr>";
	echo "</table>";*/

	//	echo "<center>";
	// get pin
	//	$tmpl_file = "modules/$module_name/forms/view.$formid.html";
	//	include($tmpl_file);

	require_once("modules/Sections/connector_class.php");
	$cc = new pageconnector();
	$fiche = $cc->getPageContent("","view.".$formid);
	$fiche = str_ireplace("data[","\$data[",$fiche);
	$fiche = addslashes($fiche);
	eval("\$fiche = \"".$fiche."\";");
	$fiche = stripslashes($fiche);
	echo $fiche;

	//	echo "</center>";

	// ---------------------- Button --------------------

	$bardef=array(
	"back"=>"modules.php?name=$module_name&sop=userlist",
	"top" =>"#top" );
	buttonBar ($bardef);
	include ('footer.php');
}


function eval_buffer($string) {
	ob_start();
	eval("$string[2];");
	$ret = ob_get_contents();
	ob_end_clean();
	return $ret;
}

function eval_html($string) {
	return preg_replace_callback("/(<\?php|<\?)(.*?)\?>/si",
	"eval_buffer",$string);
}


/**
 * Expdition d'un e-mail.
 * @param string $email Adresse d'expdition de l'e-mail.
 * @param string $subject Sujet de l'e-mail.
 * @param string $message Corps du massage  expdier.
 * @return boolean True si le message a t expdi, false sinon.
 */
function send_email($email, $subject, $message, $from){
	// En-ttes
	$headers = "From: ".$from."\n";
	$headers .= "X-Sender: ".$from."\n";
	$headers .= "X-Mailer: PHP\n";
	$headers .= "X-Priority: 1\n";
	$headers .= "Return-Path: ".$from."\n";
	$headers .= "Reply-To: ".$from."\n";
	$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
	return mail($email, $subject, $message, $headers);
}

function send_email_pj($email,$nom,$from,$subject, $message, $nomfichier, &$fichier){
		// En-ttes

		$limite1 = "=_".md5(uniqid(rand()));
				
		$headers = "From: ".$from."\n";
		$headers .= "X-Sender: ".$from."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "MIME-Version: 1.0\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".$from."\n";
		if ($nom != "") {
			$headers .= "Reply-To: ".$nom." <".$from.">\n";
		}
		else {
			$headers .= "Reply-To: ".$from."\n";
		}
		$headers .= "Date: ".date ("r")."\n";
		$headers .= "Content-Type: multipart/mixed; boundary=\"".$limite1."\"\n\n";
		
		$message = "--".$limite1."\n"."Content-Type: text/plain; charset=ISO-8859-1\n\n".$message."\n\n";
		
		$message .= "--".$limite1."\n";
		$message .= "Content-Type: application/octet-stream; name=\"".$nomfichier."\"r\n";
		$message .= "Content-Transfer-Encoding: base64\n";
		$message .= "Content-Disposition: attachment; filename=\"".$nomfichier."\"\n\n";
		
		$message .= str_replace("\r\n","\n",chunk_split(base64_encode($fichier)));
		
		$message .= "--".$limite1."--\n\n";
		
		return mail($email, $subject, $message, $headers);
	}

/**
 * saveForm()
 * @package packagename
 * @param datatype paramname
 * @param datatype paramname
 *
 */
function saveForm($data_dataid, $data, $formid,$dataid,$createuser){
	global $prefix, $db, $user, $cookie,$module_name,$adminmail;
	global $datagroupedefault;

	if (is_user($user)) {
		cookiedecode($user);
		$logname = $cookie[1];
	} else {
		$logname="anonymous";
	}
	// create an xml content
	$xmlDoc = new MiniXMLDoc();
	$formArray=array("Form"=>$data);
	$xmlDoc->fromArray($formArray);
	$stringform=$xmlDoc->toString();

	//rcup infos fiches
	//$data_email_responsable, $data_page_enregistrement
	$result = $db->sql_query("Select data_pin, data_email_responsable, data_page_enregistrement from ".$prefix."_data_mgr where dataid='$dataid';");
	
	list($data_pin,$data_email_responsable, $data_page_enregistrement) = $db->sql_fetchrow($result);
	if ($data_page_enregistrement == "") {
		$retour = "modules.php?name=$module_name&sop=userlist";
	}
	else {
		$retour = $data_page_enregistrement;
	}
	//enregistrement des donnes
	if (isset($data_dataid) && $data_dataid!="") {
		// update
		$result=$db->sql_query("update ".$prefix."_data_data set data_data_content='$stringform' where data_dataid='$data_dataid'");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('Invalid query (dataSaveForm Update)');
		}
		$message = _DATAADDFILEMESSMESS2;
		$sujet = _DATAADDFILEMESSSUB2;
		$idpdf = $data_dataid;
	}
	else{
		// create
		$result=$db->sql_query("INSERT INTO ".$prefix."_data_data VALUES (NULL,'$logname', '$stringform', now(), '$formid','$dataid')");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('Invalid query (dataSaveForm Insert):$formid ');
		}
		$message = _DATAADDFILEMESSMESS;
		$sujet = _DATAADDFILEMESSSUB;
		$idpdf = $db->sql_nextid();
	}
	if ($createuser == "1") {
		require("modules/SimpleClient/connector_lib.php");
		$new_client = array(
			"Id"=>"-1",
			"civilite"=>"0",
			"nom"=>$data[nom],
			"prenom"=>$data[prenom],
			"societe"=>$data[institution],
			"adresse"=>$data[adresse],
			"codepostal"=>"",
			"ville"=>"",
			"pays"=>"",
			"tel"=>$data[tel],
			"fax"=>$data[fax],
			"portable"=>"",
			"email"=>$data[email],
			"services"=>"",
			"codeclient"=>$data[email].date("y"),
			"passwd"=>strtolower(substr($data[nom],0,3)).strtolower(substr($data[prenom],0,3)).date("y"),
			"valide"=>"0",
			"divers"=>"",
			"datenaissance"=>"0000-00-00",
			"categorie"=>$datagroupedefault,
			"codeconfirm"=>"",
			"pageperso"=>"",
			"newsletter"=>0
			);
		$client = new clientconnector();
		$client->createUser($My_SQL, $new_client);
		
		require_once("includes/html2pdf.php");
		$monpdf = new handle_pdf("A5", "P", "fr");
		$monhtml = "";
		
		require_once("core/minixml/minixml.inc.php");
		$result = $db->sql_query("select data_data_author, data_data_content, data_data_form  from ".$prefix."_data_data where data_dataid='".$idpdf."'");
		list($data_data_authors, $data_data_content, $data_data_form ) = $db->sql_fetchrow($result);
		$xmlDoc = new MiniXMLDoc();
		$xmlDoc->fromString($data_data_content);
		$formAsArray=$xmlDoc->toArray();
		$data1=$formAsArray["Form"];
		$data = array_map("html_entity_decode", $data1);
		$monhtml .= '<h1>'._CLIENTFILEPDF.'</h1>';
		$monhtml .= '<hr />';
		$monhtml .= '<table border="0" cellpadding="0" cellspacing="3">';
		$monhtml .= "<tr><td>Identit : </td><td><strong>".$data["nom"]." ".$data["prenom"]."</strong></td></tr>";
		$monhtml .= "<tr><td> </td><td> </td></tr>";
		$monhtml .= ($data["fonction"]!="") ? "<tr><td>Fonction : </td><td>".$data["fonction"]."</td></tr>" : "";
		$monhtml .= ($data["institution"]!="") ? "<tr><td>Institution/organisation : </td><td>".$data["institution"]."</td></tr>" : "";
		$monhtml .= ($data["adresse"]!="") ? "<tr><td>Adresse postale : </td><td>".$data["adresse"]."</td></tr>" : "";
		$monhtml .= "<tr><td> </td><td> </td></tr>";
		$monhtml .= ($data["tel"]!="") ? "<tr><td>Tlphone : </td><td>".$data["tel"]."</td></tr>" : "";
		$monhtml .= ($data["fax"]!="") ? "<tr><td>Fax : </td><td>".$data["fax"]."</td></tr>" : "";
		$monhtml .= ($data["email"]!="") ? "<tr><td>E-mail : </td><td>".$data["email"]."</td></tr>" : "";
		$monhtml .= "<tr><td> </td><td> </td></tr>";
		$monhtml .= ($data["categorie"]!="") ? "<tr><td>Catgorie : </td><td>".$data["categorie"]."</td></tr>" : "";
		$monhtml .= ($data["horaire_arrivee"]!="") ? "<tr><td>Horaires d'arrive : </td><td>".$data["horaire_arrivee"]."</td></tr>" : "";
		$monhtml .= ($data["horaire_depart"]!="") ? "<tr><td>Horaires de dparts : </td><td>".$data["horaire_depart"]."</td></tr>" : "";
		$monhtml .= ($data["placesvoiture"]!="") ? "<tr><td>Places disponibles : </td><td>".$data["placesvoiture"]."</td></tr>" : "";
		$monhtml .= '</table>';
		$monhtml .= '<hr />';
		$monhtml .= '<p align="right"><i>'._CLIENTFILEPDFSENDDATE.date("d/m/Y H:i:s").'</i></p>';

		if ($data_email_responsable != "") {
			$document = $monpdf->get_pdf($monhtml);
			$message = str_replace("<!--nomfiche-->",$data_pin,$message)."\n"._DATANEWACCOUNT;
			send_email_pj($data_email_responsable, "" , $adminmail, $sujet, $message, "Fiche_adhsion.pdf", $document);
			send_email_pj($data["email"], "" , $adminmail, _CLIENTMESSSUB, _CLIENTMESS, "Fiche_adhsion.pdf", $document);
		}
	}
	else {
		if ($data_email_responsable != "") {
			$message = str_replace("<!--nomfiche-->",$data_pin,$message);
			send_email($data_email_responsable, $sujet, $message, $adminmail);
		}
	}
	Header("Location: $retour");
}

/**
 * listData
 *
 *
 *
 */
function listData($formid="",$dataid=null){
	global $prefix, $db, $user, $cookie, $module_name;

	if (is_user($user)) {
		cookiedecode($user);
		$logname= $cookie[1];

	} else {
		$logname="anonymous";
	}

	$closeAnd="";
	//if (!$formid=="") $closeAnd="AND data_data_form='$formid'";
	if ($dataid != "") {
		$closeAnd="and data_mgr_dataid='$dataid'";
	}

	$orderby = " order by data_pin ASC, data_data_date DESC";

	/*$iconeForm="<img src=\"modules/BalisteDataS/images/form.gif\" border=0 alt=\"Form\">";
	 $iconeData="<img src=\"modules/BalisteDataS/images/showdetails.gif\" border=0 alt=\"Form\" onmouseover=\"overlib('Editer les donn�es', STICKY, CENTER);\" onmouseout=\"nd();\">";
	 $iconeSend="<img src=\"modules/BalisteDataS/images/mail.gif\" border=0 alt=\"Send\" onmouseover=\"overlib('Envoyer les donn�es par email', STICKY, CENTER);\" onmouseout=\"nd();\">";
	 $iconeEdit="<img src=\"modules/BalisteDataS/images/edit.gif\" border=0 alt=\"Edit\" onmouseover=\"overlib('Editer les donn�es', STICKY, CENTER);\" onmouseout=\"nd();\">";
	 $iconePrint="<img src=\"images/print.png\" border=0  alt=\"Print\" onmouseover=\"overlib('Editer les donn�es', STICKY, CENTER);\" onmouseout=\"nd();\">";
	 $iconeNew="<img src=\"modules/BalisteDataS/images/showdetails.gif\" border=0 alt=\"New\" onmouseover=\"return overlib('Enter de nouvelles donn�es', STICKY, CENTER);\" onmouseout=\"nd();\">";
	 $iconeView="<img src=\"modules/BalisteDataS/images/preview.gif\" border=0 alt=\"View\" onmouseover=\"overlib('Visualiser les donn�es', STICKY, CENTER);\" >";*/

	$iconeNew = "<img src=\"modules/".$module_name."/images/table_add.gif\" border=\"0\" \>";
	$iconeEdit = "<img src=\"modules/".$module_name."/images/table_edit.gif\" border=\"0\" \>";
	$iconeDelete = "<img src=\"modules/".$module_name."/images/table_delete.gif\" border=\"0\" \>";
	$iconeView = "<img src=\"modules/".$module_name."/images/table.gif\" border=\"0\" \>";

	/*$sendto="$iconeSend";
	 $printit="$iconePrint";*/

	$result = $db->sql_query("select distinct ".$prefix."_data_data.data_data_form, ".$prefix."_data_data.data_mgr_dataid, ".$prefix."_data_mgr.data_pin from ".$prefix."_data_data left join ".$prefix."_data_mgr on ".$prefix."_data_data.data_mgr_dataid = ".$prefix."_data_mgr.dataid where data_data_author='$logname' $closeAnd$orderby");
	$mycontent = "<fieldset><legend>"._DATAFILESCONTENT."</legend>";
	$mycontent .= "<p>"._DATAVIEWCONTENT."</p>";
	$mycontent .= "<ul>";
	while(list($data_data_form, $data_mgr_dataid, $data_data_pin) = $db->sql_fetchrow($result)) {
		$mycontent .= "<li><a href=\"modules.php?name=".$module_name."&sop=listdatacontent&formid=".$data_data_form."&dataid=".$data_mgr_dataid."\">".$data_data_pin."</a></li>";
	}
	$mycontent .= "</ul>";
	$mycontent .= "</fieldset>";
	$mycontent .= "<br />&nbsp;";

	//$result = $db->sql_query("select data_dataid, data_data_content, data_data_date, data_data_form from ".$prefix."_data_data where data_data_author='$logname' $closeAnd");
	$result = $db->sql_query("select ".$prefix."_data_data.data_dataid, ".$prefix."_data_data.data_data_author,".$prefix."_data_data.data_data_content, ".$prefix."_data_data.data_data_date, ".$prefix."_data_data.data_data_form, ".$prefix."_data_data.data_mgr_dataid, ".$prefix."_data_mgr.data_pin from ".$prefix."_data_data left join ".$prefix."_data_mgr on ".$prefix."_data_data.data_mgr_dataid = ".$prefix."_data_mgr.dataid where data_data_author='$logname' $closeAnd$orderby");
	$mycontent .= "<fieldset><legend>"._DATAFILES."</legend>";
	$mycontent .= "<table class=\"datalist\" cellSpacing=\"0\" cellPadding=\"0\" border=\"0\">";
	$mycontent .= "<tr>";
	$mycontent .= "<th style=\"text-align: left\">"._DATALISTFORMPIN."</th>";
	$mycontent .= "<th>"._DATALISTDATE."</th>";
	$mycontent .= "<th>"._DATALISTUSER."</th>";
	$mycontent .= "<td>".""."</td>";
	$mycontent .= "</tr>";
	while(list($data_dataid, $data_data_author, $data_data_content,  $data_data_date, $data_data_form, $data_mgr_dataid, $data_data_pin) = $db->sql_fetchrow($result)) {
		$linkEdit="<a href=\"modules.php?name=$module_name&sop=displayForm&data_dataid=$data_dataid&formid=$data_data_form&dataid=$data_mgr_dataid\" title=\""._DATAEDIT."\">$iconeEdit</a>";
		$linkNew="<a href=\"modules.php?name=$module_name&sop=displayForm&formid=$data_data_form&dataid=$data_mgr_dataid\" title=\""._DATAADD."\">$iconeNew</a>";
		$linkView="<a href=\"modules.php?name=$module_name&sop=viewForm&formid=$data_data_form&data_dataid=$data_dataid&dataid=$data_mgr_dataid\" title=\""._DATAVIEW."\">$iconeView</a>";
		$mycontent .=" <tr>";
		$mycontent .= "<td>$data_data_pin</td>";
		$mycontent .= "<td align=\"center\">".preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})","\\3/\\2/\\1#", $data_data_date)."</td>";
		$mycontent .= "<td align=\"center\"><a href=\"modules.php?name=$module_name&sop=userlist\" title=\""._DATAVIEWFORUSER."\">$data_data_author</a></td>";
		$mycontent .= "<td>$linkView $linkEdit $linkNew </a></td>";
		$mycontent .= "</tr>";
	}
	$mycontent .= "</table>";
	$mycontent .= "</fieldset>";
	echo $mycontent;
}

/**
 * Rcupre les variables envoyes par GET ou POST.
 *
 * Renvoie ces variables sous la forme de paramtres d'URL.
 * @param string $sauf Liste des paramtres  ne pas rcuprer.
 * @return string Liste des variables rcupres.
 */
function getVars($sauf) {
	//global $_GET;

	$elimines = explode("|", $sauf);
	$args = "";
	$elts = array_merge($_GET,$_POST);
	if (count($elts) != 0) {
		while (list ($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key . "=" . stripslashes($val);
			}
		}
	}
	else {
		$args = "";
	}
	return $args;
}

/**
 * Renvoie l'indexation des rsultats  afficher par page.
 *
 * @param array $criteres Tableau contenant les divers paramtres : .
 * @return string Code HTML de l'index des pages  afficher.
 */
function getPagesIndex($page_en_cours,$articles_par_page,$nbreFiches) {
	if (!isset($page_en_cours) || $page_en_cours == "") {
		$page_en_cours = 1;
	}
	$repParPage = $articles_par_page;
	$p = $page_en_cours;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._DATAFOUNDPAGES;
	}
	else {
		$indexPages .= _DATANOTFOUNDPAGES;
	}
	$indexPages .= _DATALISTPAGES;
	for ($i=1;$i<=$nbrepages;$i++) {
		if ($i == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$i";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?"
					.getVars("page_en_cours")
			."&"."page_en_cours"."=$i\">$i</a>";
			$indexPages .= "</div>";
		}
	}
	$indexPages .= "</div>";
	return $indexPages;
}

/**
 * view()
 *
 *
 */
function view(){
}
/**
 * printPin($acid)
 * format Pin page for an HTML print
 * @param acid :acteur id
 * @return
 * @see
 */
function printPin($actid,$ok=1) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db;

	$printPage="<html>"
	."<head>"
	."<title>$sitename</title>"
	."<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n\n\n"
	."</head>"
	."<body bgcolor=\"#FFFFFF\" text=\"#000000\" >"
	."<table border=\"0\"><tr><td>"
	."<table border=\"0\" width=\"640\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>"
	."<table border=\"0\" width=\"640\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>"
	."<center>"
	."<img src=\"images/$site_logo\" border=\"0\" alt=\"\"><br><br>"
	."<font class=\"content\"> ";

	// get information about Acteur
	$result = $db->sql_query("select actid, nom_acteur, adresse_acteur, ville_acteur, codepostal_acteur, sigle_acteur, telephone_acteur, fax_acteur, email_acteur, web_acteur, nom_president_acteur, nom_directeur_acteur, status_acteur, mission_acteur, carte_acteur  from ".$prefix."_annuaireacteur_acteur where actid='$actid'");
	if (!$result) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	// get information about Competences
	$result2 = $db->sql_query("select domaine from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'");
	if (!$result2) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	// get Information about Activities
	$result3 = $db->sql_query("select activite from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid'");
	if (!$result3) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}

	// get Contacts
	$result4 = $db->sql_query("select nom_contact, prenom_contact, telephone_contact, telephone_mobile_contact, fax_contact, email_contact, web_contact, titre_contact, domaine_contact, role_contact from ".$prefix."_annuaireacteur_contact where acteur_actid='$actid' order by position_contact ");
	if (!$result4) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	list($actid, $nom_acteur, $adresse_acteur, $ville_acteur, $codepostal_acteur, $sigle_acteur, $telephone_acteur, $fax_acteur, $email_acteur, $web_acteur, $nom_president_acteur, $nom_directeur_acteur, $status_acteur, $mission_acteur, $carte_acteur)= $db->sql_fetchrow($result);
	// get type
	$myresult = $db->sql_query("select statusname from ".$prefix."_annuaireacteur_liste_status where statusid='$status_acteur'");
	list($statusname) = $db->sql_fetchrow($myresult);
	// Titre
	$printPage.= "<center><FONT class=annuaireTitle>".strtoupper($nom_acteur)."</FONT></center>";
	$printPage.= "<div align=center>$sigle_acteur</div>";
	// Carte & info
	if ($carte_acteur=="") { $carte_acteur="images/annuaire_acteur/carte_corse_ba.jpg"; }
	$printPage.= "<center><br><table width=\"90%\"><tr>"
	."<td height=\"1\" colspan=\"3\" bgcolor=\"#FF0000\"><strong><img src=\"themes/Oec/images/pixel.jpg\" width=\"1\" height=\"1\"></strong></tr>"
	."<tr>"
	."<td align=center valign=center>LOCALISATION<br><img src=\"$carte_acteur\" border=0><td>"
	."<td valign=top>"
	."<br><br><table>"
	."<tr><td class=annuaireAttr>"._STATUS_ACTEUR.": </td><td align=left>$statusname</td></tr>"
	."<tr><td class=annuaireAttr>"._ADRESSE_ACTEUR.": </td><td align=left>$adresse_acteur $codepostal_acteur $ville_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._TELEPHONE_ACTEUR.": </td><td align=left>$telephone_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._FAX_ACTEUR.": </td><td align=left>$fax_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._EMAIL_ACTEUR.": </td><td align=left>$email_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._WEB_ACTEUR.": </td><td align=left>$web_acteur</td></tr>"
	."<tr><td><br><br></td><td></td></tr>"
	."<tr><td><u><B>"._RESPONSABLE."</B></u></td><td align=left></td></tr>"
	."<tr><td class=annuaireAttr>"._PRESIDENT_ACTEUR.":</td><td align=left>$nom_president_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._DIRECTEUR_ACTEUR.":</td><td align=left>$nom_directeur_acteur</td></tr>"
	."</table></td>"
	."</tr></table></center>";
	// mission

	$printPage.= "<br><center><table width=\"90%\"><tr>"
	."<td align=center class=annuaireFormTitle> ".strtoupper(_MISSION)." <td>"
	."</tr>"
	."<tr>"
	."<td>$mission_acteur</td>"
	."</tr></table></center>";
	// Domaine et Activite
	$printPage.= "<br><center><table width=\"90%\"><tr>"
	."<td align=center class=annuaireFormTitle>"._DOMAINE_ACTEUR."</td>"
	."<td align=center class=annuaireFormTitle>"._ACTIVITE_ACTEUR."</td>"
	."</tr>"
	."<tr>"
	."<td><UL>";
	while(list($domaine) = $db->sql_fetchrow($result2)) {
		$printPage.= "<LI> $domaine";
	}
	$printPage.= "</UL></td>"
	."<td><UL>";
	while(list($activite) = $db->sql_fetchrow($result3)) {
		$printPage.= "<LI> $activite";
	}
	$printPage.= "</UL></td>"
	."</tr></table></center>";
	// Contact
	$printPage.= "<br><center><table width=\"90%\"><tr>"
	."<td align=center class=annuaireFormTitle>".strtoupper(_CONTACT)."<td>"
	."</tr>"
	."<tr>"
	."<td><table>";
	while(list($nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $role_contact) = $db->sql_fetchrow($result4)) {
		if (trim($telephone_contact)!="")$TelephoneDisplay="<img src=\"images/annuaire_acteur/attribut/icone_telephonenumber.gif\" border=0> $telephone_contact";
		if (trim($email_contact)!="")$MailDisplay="<img src=\"images/annuaire_acteur/attribut/icone_mail.gif\" border=0> $email_contact";
		$printPage.= "<tr><td colspan=3><b>$nom_contact $prenon_contact</b> </td>"
		."<tr><td style=\" border-bottom: thin dotted darkorange \" width=\"30%\">$domaine_contact</td><td style=\" border-bottom: thin dotted darkorange \" width=\"35%\">$TelephoneDisplay</td><td style=\" border-bottom: thin dotted darkorange \" width=\"35%\">$MailDisplay</td></tr></UL>";
	}
	$printPage.= "</table></td>"
	."</tr></table></center>";

	$printPage.= " <br><center>
    <font class=\"annuairePrintFooter\">
    "._COMESFROM." $sitename :::
	<a href=\"$nukeurl\">$nukeurl</a><br><br>
	</font></center>
	</td></tr></table>
	</body>
	</html>
    ";
	if ($ok) {
		echo $printPage;
	}else{
		return $printPage;
	}
}
/**
 * exportPinAsPdf()
 * export Pin form as a pdf document
 * @param acid :acteur id
 * @return
 * @see
 */
function exportPinAsPdf($acid) {
	require('modules/Annuaire_Acteurs/html2pdf.php');
	$myhtmlPage=printActeurPage($actid,0);

	if (isset($myhtmlPage))
	{
		$pdf = new createPDF(
		$myhtmlPage,   // html � convertir
		$mytitle,  // titre de l'article
		$myurl,    // URL de l'article
		$author, // nom de l'auteur
		time()
		);
		$pdf->run();
	}
}
/**
 * displayAlphabet()
 *
 * @param datatype paramname description
 * @return datatype description
 */
function displayAlphabet($thelink){
	$acteurLink=$thelink."&myfilter=";

	$alpha= "<div align=right>"
	."<a href=\"".$acteurLink."A\">A </a>"
	."<a href=\"".$acteurLink."B\">B </a>"
	."<a href=\"".$acteurLink."C\">C </a>"
	."<a href=\"".$acteurLink."D\">D </a>"
	."<a href=\"".$acteurLink."E\">E </a>"
	."<a href=\"".$acteurLink."F\">F </a>"
	."<a href=\"".$acteurLink."G\">G </a>"
	."<a href=\"".$acteurLink."H\">H </a>"
	."<a href=\"".$acteurLink."I\">I </a>"
	."<a href=\"".$acteurLink."J\">J </a>"
	."<a href=\"".$acteurLink."K\">K </a>"
	."<a href=\"".$acteurLink."L\">L </a>"
	."<a href=\"".$acteurLink."M\">M </a>"
	."<a href=\"".$acteurLink."N\">N </a>"
	."<a href=\"".$acteurLink."O\">O </a>"
	."<a href=\"".$acteurLink."P\">P </a>"
	."<a href=\"".$acteurLink."Q\">Q </a>"
	."<a href=\"".$acteurLink."R\">R </a>"
	."<a href=\"".$acteurLink."S\">S </a>"
	."<a href=\"".$acteurLink."T\">T </a>"
	."<a href=\"".$acteurLink."U\">U </a>"
	."<a href=\"".$acteurLink."V\">V </a>"
	."<a href=\"".$acteurLink."X\">X </a>"
	."<a href=\"".$acteurLink."Y\">Y </a>"
	."<a href=\"".$acteurLink."Z\">Z </a>"
	."</div>";
	return $alpha;
}

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/
if (!isset($createuser)) {
	$createuser = 0;
}
switch($sop) {

	case "displayAccess":
		displayAccess();
		break;

	case "listPin":
		listPin($data_theme, $data_category, $sortBy);
		break;

	case "listOrganismType":
		listOrganismType();
		break;

	case "listCompetence":
		listCompetence();
		break;

	case "viewPin":
		viewPin($dataid);
		break;

	case "printActeurPage":
		printActeurPage($actid);
		break;

	case "listActeurByChar":
		listActeurByChar($myfilter);
		break;

	case "exportActeurAsPdf":
		exportActeurAsPdf($actid);
		break;

	case "displayForm":
		displayForm($data_dataid,$formid,$dataid);
		break;

	case "viewForm":
		viewForm($data_dataid,$formid,$dataid);
		break;

	case "saveForm":
		saveForm($data_dataid, $data, $formid, $dataid, $createuser);
		break;

	case "listData":
		listData($formid);
		break;

	case "userlist":
		userlist($formid,$dataid);
		break;

	case "listdatacontent":
		listDataContent($formid,$dataid);
		break;

	default:
		main();
		break;
}

?>