<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */
/*                                                                      */
/*   																	*/
/* Balistis "Data Manager" Module . Stephan ACQUATELLA 2006				*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

$module_name = "BalisteDataS";

if (checkModuleRight("$module_name")) {

	/************************** Onglet definition ***********************/
	$ongletDef=array("theme"=> array( "text"=>_DATAMGR_THEME,
                                   "url"=>"system.php?op=dataTheme"),
                 "pin"=> array( "text"=>_DATAMGR_PIN,
                                   "url"=>"system.php?op=dataPin"),
                 "data"=> array( "text"=>_DATAMGR_DATA,
                                   "url"=>"system.php?op=dataData"),
                 "category"=> array( "text"=>_DATAMGR_CATEGORY,
                                   "url"=>"system.php?op=dataCategory")
	);
	require_once("core/minixml/minixml.inc.php");
	/**
	 * dataTheme()
	 * List Form Themes
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataTheme($editid, $editForm=1){
		global $prefix, $db, $language, $multilingual,$ongletDef,$Default_Skin;

		include("system/header_system.php");
		GraphicAdmin(_DATAMGRPIN);
		$skinPath="system/skins/$Default_Skin";
		OpenSysTable();
		$result = $db->sql_query("select  data_themeid, data_theme, data_theme_access from ".$prefix."_data_theme order by data_theme_order");

		$barDef=array("edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "comment"=>_EDIT, "status"=>"ON"),
  			          "delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));
			

		OpenOngletTable();
		displayOngletBar("theme",_DATAMGRPIN,$ongletDef);

		echo "<table class=lisTable><tr class=systemTabHeader>"
		."<td align=\"left\" class=systemTabHeader width=80%>"._DATA_THEME_NAME."</td>"
		."<td align=\"center\" class=systemTabHeader width=20%>"._FUNCTIONS."</td>"
		."</tr>";

		$pos=0;
		$myicon="<img src=\"$SkinPath/folder.gif\" height=16 border=0>";
		while(list($data_themeid, $data_theme) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$sectionLink="<a href=\"system.php?op=dataPin&onglet=pin&myfilter=$data_themeid\" >";
			echo "<tr class=\"$thestyle\">"
			."<td align=\"left\" >$myicon $sectionLink $data_theme</a></td>";
			//."<td align=\"center\"><a href=\"system.php?op=dataEditTheme&data_themeid=$data_themeid&editForm=1\">[ "._EDIT."</a> | "
			//."<a href=\"system.php?op=dataDelTheme&amp;typid=$data_themeid&amp;ok=0\">"._DELETE."</a> ] </td></tr>";

			echo "<td align=\"center\">";
			$barDef["edit"]["url"]="system.php?op=dataEditTheme&data_themeid=$data_themeid&editForm=1";
			$barDef["delete"]["url"]="system.php?op=dataDelTheme&amp;typid=$data_themeid&amp;ok=0";
			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";

			$pos++;
		} // End While
		echo "</table>";

		CloseOngletTable();
		CloseSysTable();

		OpenOngletTable();
		echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
		echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+]"._ADD_DATA_THEME."</a>";

		echo dataEditTheme($editid,$editForm,1);
		if ($editForm=="1")
		{
			echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
		}
		CloseOngletTable();
		include("system/footer_system.php");
	}

	/**
	 * dataPin()
	 *  List available Data Pin Form
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataPin($editid, $editForm, $myfilter="",$myfiltertwo=""){
		global $prefix, $db, $language, $multilingual,$ongletDef,$Default_Skin,$module_name;

		include("system/header_system.php");
		GraphicAdmin(_DATAMGRPIN);
		$skinPath="system/skins/$Default_Skin";
		$thefilter="";
		if ($myfilter!="") 		$thefilter="WHERE ".$prefix."_data_mgr.data_theme='$myfilter'";
		if ($myfiltertwo!="") 		$thefilter="WHERE ".$prefix."_data_mgr.data_cat='$myfiltertwo'";
		//if ($myfiltertwo!="") 	$thefilter="WHERE data_pin LIKE '$myfiltertwo%'";
		OpenSysTable();
		$result = $db->sql_query("select dataid, data_pin, data_formid, data_date, data_author, ".$prefix."_data_theme.data_theme, data_access, data_lang, data_status, ".$prefix."_data_categories.data_category from ".$prefix."_data_mgr left join ".$prefix."_data_theme on ".$prefix."_data_theme.data_themeid = ".$prefix."_data_mgr.data_theme left join ".$prefix."_data_categories on ".$prefix."_data_categories.data_catid = ".$prefix."_data_mgr.data_cat  $thefilter order by data_order");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('Invalid query (dataPin)');
		}

		$barDef=array("view"=> array( "text"=>_VIEW,"icon"=>"icon_eye.gif", "comment"=>_VIEW, "status"=>"ON"),
					  "edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "comment"=>_EDIT, "status"=>"ON"),
					  "list"=> array( "text"=>_LISTFICHES,"icon"=>"icon_layers.png", "comment"=>_LISTFICHES, "status"=>"ON"),
  			          "delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));
			
		OpenOngletTable();
		displayOngletBar("pin",_DATAADMIN,$ongletDef);
		//displayAlphabet("system.php?op=annuaireActeur&onglet=acteur");
		echo "<table class=lisTable><tr class=systemTabHeader>"
		."<td align=\"center\" class=systemTabHeader width=\"15%\">"._DATAPIN_NAME."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"10%\">"._DATAPIN_FORM."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"15%\">"._DATAPIN_AUTHOR."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"10%\">"._DATAPIN_LANG."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"10%\">"._DATAPIN_ACCESS."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"10%\">"._DATAPIN_THEME."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"10%\">"._DATAPIN_CAT."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"15%\">"._DATAPIN_DATE."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"15%\">"._FUNCTIONS."</td>"
		."</tr>";

		$myicon="<img src=\"$SkinPath/document.png\" height=16 border=0>";
		$pos=0;
		while(list($dataid, $data_pin, $data_formid, $data_date, $data_author, $data_theme, $data_access, $data_lang, $data_status, $data_cat) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			//$myresult = $db->sql_query("select type_organisme from ".$prefix."_annuaireacteur_liste_type where typid='$type_acteur'");
			//list($type_organisme) = $db->sql_fetchrow($myresult);
			//$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=contact&myfilter=$actid\" >";
			echo "<tr class=\"$thestyle\">"
			."<td align=\"left\">$myicon $data_pin</a></td>"
			."<td align=\"center\">$data_formid</td>"
			."<td align=\"center\">$data_author</td>"
			."<td align=\"center\">$data_lang</td>"
			."<td align=\"center\">$data_access</td>"
			."<td align=\"center\">$data_theme</td>"
			."<td align=\"center\">$data_cat</td>"
			."<td align=\"center\">$data_date</td>";
			//."<td align=\"center\"><a href=\"system.php?op=dataEditPin&amp;dataid=$dataid&editForm=1\">[ "._EDIT."</a> | "
			//."<a href=\"system.php?op=dataDelPin&amp;dataid=$dataid&amp;ok=0\">"._DELETE."</a> ]</td></tr>";

			echo "<td align=\"center\">";
			$barDef["view"]["url"]="modules.php?name=$module_name&sop=displayForm&&formid=$data_formid#top";
			$barDef["edit"]["url"]="system.php?op=dataEditPin&amp;dataid=$dataid&editForm=1";
			$barDef["list"]["url"]="system.php?op=listDataContent&dataid=$dataid";
			$barDef["delete"]["url"]="system.php?op=dataDelPin&amp;dataid=$dataid&amp;ok=0";
			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";

			$pos++;
		} // End While
		echo "</table>";

		CloseOngletTable();
		CloseSysTable();

		OpenSysTable();
		echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
		echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+] "._ADD_NEW_DATAPIN."</a>";

		echo dataEditPin($editid,$editForm,1);

		CloseSysTable();
	}

	/**
	 * dataCategory()
	 * List Data Categories
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataCategory($editid, $editForm){
		global $prefix, $db, $language, $multilingual,$ongletDef,$Default_Skin;

		include("system/header_system.php");
		GraphicAdmin(_DATAMGRPIN);
		$skinPath="system/skins/$Default_Skin";
		OpenSysTable();

		$result = $db->sql_query("select  data_catid, data_category, data_cat_access from ".$prefix."_data_categories order by data_cat_order");

		$barDef=array("edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "comment"=>_EDIT, "status"=>"ON"),
  			          "delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));


		OpenOngletTable();
		displayOngletBar("category",_DATAMGRPIN,$ongletDef);

		echo "<table class=lisTable><tr class=systemTabHeader>"
		."<td align=\"left\" class=systemTabHeader width=\"60%\">"._DATA_CAT_NAME."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"30%\">"._DATA_CAT_ACCESS."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"10%\">"._FUNCTIONS."</td>"
		."</tr>";

		$pos=0;
		$myicon="<img src=\"$SkinPath/attach.png\" height=16 border=0>";
		while(list($data_catid, $data_category, $data_cat_access) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$sectionLink="<a href=\"system.php?op=dataPin&onglet=pin&myfiltertwo=$data_catid\" >";
			echo "<tr class=\"$thestyle\">"
			."<td align=\"left\" >$myicon $sectionLink $data_category</a></td>"
			."<td align=\"center\" >$data_cat_access</td>";
			//."<td align=\"center\"><a href=\"system.php?op=dataEditCategory&data_catid=$data_catid&editForm=1\">[ "._EDIT."</a> | "
			//."<a href=\"system.php?op=dataDelCategory&amp;typid=$data_catid&amp;ok=0\">"._DELETE."</a> ] </td></tr>";

			echo "<td align=\"center\">";
			$barDef["edit"]["url"]="system.php?op=dataEditCategory&data_catid=$data_catid&editForm=1";
			$barDef["delete"]["url"]="system.php?op=dataDelCategory&amp;typid=$data_catid&amp;ok=0";
			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";

			$pos++;
		} // End While
		echo "</table>";

		CloseOngletTable();
		CloseSysTable();

		OpenOngletTable();
		echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
		echo "<a href=\"javascript:switchdisplayIFrame('formframe');\">[+]"._ADD_DATA_CAT."</a>";

		echo dataEditCategory($editid,$editForm,1);
		if ($editForm=="1")
		{
			echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
		}
		CloseOngletTable();
		include("system/footer_system.php");
	}


	/**
	 * dataData()
	 *
	 *
	 *
	 *
	 */
	function dataData(){
		global $prefix, $db, $language, $multilingual,$ongletDef,$Default_Skin,$page_en_cours,$module_name;

		$articles_par_page = 25;
		if (!isset($page_en_cours) || $page_en_cours=="") {
			$page_en_cours = 1;
		}
		
		include("system/header_system.php");
		GraphicAdmin(_DATAMGRPIN);
		$skinPath="system/skins/$Default_Skin";
		OpenSysTable();
		$result = $db->sql_query("select data_dataid, data_data_author,data_data_content, data_data_date, ".$prefix."_data_mgr.data_pin, data_mgr_dataid from ".$prefix."_data_data left join ".$prefix."_data_mgr on ".$prefix."_data_data.data_mgr_dataid = ".$prefix."_data_mgr.dataid order by data_data_date");
		$index_pages = getPagesIndex($page_en_cours,$articles_par_page,$db->sql_numrows($result));
		$limInf = ($page_en_cours-1)*$articles_par_page;
		$limit_fiches = $limInf.",".$articles_par_page;
		$result = $db->sql_query("select data_dataid, data_data_author,data_data_content, data_data_date, ".$prefix."_data_mgr.data_pin, data_mgr_dataid from ".$prefix."_data_data left join ".$prefix."_data_mgr on ".$prefix."_data_data.data_mgr_dataid = ".$prefix."_data_mgr.dataid order by data_data_date limit $limit_fiches");
		
		if (!$result) {
			print_r ( $db->sql_error () );
			die('dataData :: Invalid query (dataData)');
		}
		
		echo '<link href="modules/'.$module_name.'/system/data-edit.css" rel="stylesheet" type="text/css" media="all" />';
		
		$barDef=array("view"=> array( "text"=>_VIEW,"icon"=>"icon_eye.gif", "comment"=>_VIEW, "status"=>"ON"),
						"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "comment"=>_EDIT, "status"=>"ON"),
  			          "delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));


		OpenOngletTable();
		displayOngletBar("data",_DATAMGRPIN,$ongletDef);
		
		echo $index_pages;
		//displayAlphabet("system.php?op=annuaireActeur&onglet=acteur");
		echo "<table class=lisTable><tr class=systemTabHeader>"
		."<td align=\"center\" class=systemTabHeader width=\"15%\">"._DATAPIN_DATA_USER."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"10%\">"._DATAPIN_DATA_FORM."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"15%\">"._DATAPIN_DATE."</td>"
		."<td align=\"center\" class=systemTabHeader width=\"15%\">"._FUNCTIONS."</td>"
		."</tr>";
		$myicon="<img src=\"$SkinPath/data.png\" height=16 border=0>";
		$pos=0;
		while(list($data_dataid, $data_data_author, $data_data_content, $data_data_date, $data_data_form,$dataid) = $db->sql_fetchrow($result)) {
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$myresult = $db->sql_query("select data_theme from ".$prefix."_data_mgr where data_formid='$data_data_form'");
			list($data_theme) = $db->sql_fetchrow($myresult);
			$myresult = $db->sql_query("select data_theme from ".$prefix."_data_theme where data_themeid='$data_theme'");
			list($data_theme) = $db->sql_fetchrow($myresult);
			//$sectionLink="<a href=\"system.php?op=annuaireActeur&onglet=contact&myfilter=$actid\" >";
			echo "<tr class=\"$thestyle\">"
			."<td align=\"left\">$myicon $data_data_author</a></td>"
			."<td align=\"center\">$data_data_form</td>"
			."<td align=\"center\">$data_data_date</td>";
			//."<td align=\"center\">";
			//."<a href=\"system.php?op=dataViewPin&amp;data_dataid=$data_dataid\">[ "._VIEW."</a> | "
			//."<a href=\"system.php?op=dataEditData&amp;data_dataid=$data_dataid\"> "._EDIT."</a> | "
			//."<a href=\"system.php?op=dataDelData&amp;data_dataid=$data_dataid&amp;ok=0\">"._DELETE."</a> ]</td></tr>";


			echo "<td align=\"center\">";
			$barDef["view"]["url"]="system.php?op=dataView&amp;data_dataid=$data_dataid";
			$barDef["edit"]["url"]="system.php?op=dataEditData&amp;data_dataid=$data_dataid&amp;dataid=$dataid";
			$barDef["delete"]["url"]="system.php?op=dataDelData&amp;data_dataid=$data_dataid&amp;ok=0";
			displayActionBar("add","Bar d'action",$barDef,"img");
			echo "</td></tr>";

			$pos++;
		} // End While
		echo "</table>";

		CloseOngletTable();
	 CloseSysTable();
	 include("system/footer_system.php");
	}

	/**
	 * dataSaveCategory()
	 * Save a Data Category
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataSaveCategory($data_catid, $data_category, $data_cat_description, $data_cat_access, $data_cat_order){
		global $prefix, $db;
		$data_catid = stripslashes(FixQuotes($data_catid));
		$data_category = stripslashes(FixQuotes($data_category));
		$data_cat_description = stripslashes(FixQuotes($data_cat_description));
		$data_cat_access = stripslashes(FixQuotes($data_cat_access));
		$cat_order = stripslashes(FixQuotes($cat_order));
		if (isset($data_catid) && $data_catid!="") {
			// update
			$db->sql_query("update ".$prefix."_data_categories set data_category='$data_category', data_cat_description='$data_cat_description', data_cat_access='$data_cat_access', data_cat_order='$data_cat_order' where data_catid=$data_catid");
			Header("Location: system.php?op=dataCategory");
		}else{
			// create
			$db->sql_query("INSERT INTO ".$prefix."_data_categories VALUES (NULL,'$data_category','$data_cat_description','$data_cat_access','$data_cat_order')");
			Header("Location: system.php?op=dataCategory");
		}
	}


	/**
	 * dataSavePin()
	 * Save Pin Data's
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataSavePin($dataid, $data_pin, $data_description, $data_formid, $data_theme, $data_cat, $data_access, $data_lang, $data_status, $data_order, $data_pin_img, $data_email_responsable, $data_page_enregistrement){
		global $prefix, $db, $aid;

		$dataid = stripslashes(FixQuotes($dataid));
		$data_pin = stripslashes(FixQuotes($data_pin));
		$data_description = stripslashes(FixQuotes($data_description));
		$data_formid = stripslashes(FixQuotes($data_formid));
		$data_theme = stripslashes(FixQuotes($data_theme));
		$data_cat = stripslashes(FixQuotes($data_cat));
		$data_access = stripslashes(FixQuotes($data_access));
		$data_lang = stripslashes(FixQuotes($data_lang));
		$data_status = stripslashes(FixQuotes($data_status));
		$data_order = stripslashes(FixQuotes($data_order));
		$data_pin_img = stripslashes(FixQuotes($data_pin_img));
		$data_email_responsable = stripslashes(FixQuotes($data_email_responsable));
		$data_page_enregistrement = stripslashes(FixQuotes($data_page_enregistrement));


		if (isset($dataid) && $dataid!="") {
			// update
			$result=$db->sql_query("update ".$prefix."_data_mgr set data_pin='$data_pin', data_description='$data_description', data_formid='$data_formid', data_date=now(), data_author='$aid', data_theme='$data_theme', data_cat='$data_cat', data_access='$data_access', data_lang='$data_lang', data_status='$data_status', data_order='$data_order', data_pin_img='$data_pin_img', data_email_responsable='$data_email_responsable', data_page_enregistrement='$data_page_enregistrement' where dataid='$dataid'");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('Invalid query (dataSavePin Update)');
			}
			Header("Location: system.php?op=dataPin");
		}
		else{
			// create
			$result=$db->sql_query("INSERT INTO ".$prefix."_data_mgr VALUES (NULL,'$data_pin', '$data_description', '$data_formid', now(), '$aid', '$data_theme', '$data_cat', '$data_access', '$data_lang', '$data_status', '$data_order', '$data_pin_img','$data_email_responsable','$data_page_enregistrement')");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('Invalid query (dataSavePin Insert)');
			}
			Header("Location: system.php?op=dataPin");
		}
	}

	/**
	 * dataSaveTheme()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataSaveTheme($data_themeid, $data_theme, $data_theme_description, $data_theme_access, $data_theme_order, $data_theme_img){
		global $prefix, $db;
		$data_themeid = stripslashes(FixQuotes($data_themeid));
		$data_theme = stripslashes(FixQuotes($data_theme));
		$data_theme_description = stripslashes(FixQuotes($data_theme_description));
		$data_theme_access = stripslashes(FixQuotes($data_theme_access));
		$data_theme_order = stripslashes(FixQuotes($data_theme_order));
		if (isset($data_themeid) && $data_themeid!="") {
			// update
			$result=$db->sql_query("update ".$prefix."_data_theme set data_theme='$data_theme', data_theme_description='$data_theme_description', data_theme_access='$data_theme_access', data_theme_order='$data_theme_order', data_theme_img='$data_theme_img' where data_themeid=$data_themeid");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('dataSaveTheme :: Invalid query');
			}

			Header("Location: system.php?op=dataTheme");
		}else{
			// create
			$result=$db->sql_query("INSERT INTO ".$prefix."_data_theme VALUES (NULL,'$data_theme','$data_theme_description','$data_theme_access','$data_theme_order', '$data_theme_img')");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('dataSaveTheme :: Invalid query');
			}
			Header("Location: system.php?op=dataTheme");
		}
	}

	/**
	 * dataEditCategory()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataEditCategory($data_catid, $editForm=0, $asHtml=0){
		global $prefix, $db, $ongletDef;
		if ($editForm){
			// get information about Categories
			$result = $db->sql_query("select  data_category, data_cat_description, data_cat_access, data_cat_order   from ".$prefix."_data_categories where data_catid='$data_catid'");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('dataEditCategory :: Invalid query');
			}
			list($data_category, $data_cat_description, $data_cat_access, $data_cat_order)= $db->sql_fetchrow($result);
		}
		if ($editForm==0) $typid=""; // force id to null
		$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
		//."<center>"._ADD_NEW_DATA_CAT."</center><br>"
		."<br>"
		."<form action=\"system.php\" method=\"post\">"
		."<input type=\"hidden\" name=\"data_catid\" value=\"$data_catid\">"
		."<input type=\"hidden\" name=\"op\" value=\"dataSaveCategory\">"
		."<div align=center>"
		."<table class=systemTab>"
		."<tr class=systemTabHeader><th colspan=2 class=systemTabHeader>"._ADD_NEW_DATA_CAT."</th></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATACAT_NAME."</td>"
		."<td><input type=\"text\" name=\"data_category\" size=\"50\" maxlength=\"255\" value=\"$data_category\"> ".displayHelp(_HELP_DATACAT_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_CAT_DESCRIPTION."</td>"
		."<td><input type=\"text\" name=\"data_cat_description\" size=\"50\" maxlength=\"255\" value=\"$data_cat_description\"> ".displayHelp(_HELP_DATA_CAT_DESCRIPTION,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_CAT_ORDER."</td>"
		."<td><input type=\"text\" name=\"data_cat_order\" size=\"3\" maxlength=\"3\" value=\"$data_cat_order\"></td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_CAT_ACCESS."</td>"
		."<td><input type=\"text\" name=\"data_cat_access\" size=\"50\" maxlength=\"255\" value=\"$data_cat_access\"> ".displayHelp(_HELP_DATA_CAT_ACCESS,true)."</td></tr>"
		."<tr class=inputFormNone><td colspan=2><input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=dataDelTheme&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]</td></tr>"
		."</table></div>"
		."</form>"
		."</DIV>";
		if ($asHtml) {
			return $formframe;
		}else {
			include("system/header_system.php");
			GraphicAdmin(_DATAMGRPIN);
			OpenOngletTable();
			echo "<div align=\"right\">";
			displayOngletBar("category",_DATAADMIN,$ongletDef);
			echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	 	echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 	CloseOngletTable();
	 	include("system/footer_system.php");
		}// if else
	}
	/**
	 * dataEditPin()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataEditPin($dataid, $editForm=0, $asHtml=0){
		global $prefix, $db,$multilingual, $ongletDef ;
		if ($editForm){
			// get information about Theme
			$result = $db->sql_query("select data_pin, data_description, data_formid, data_date, data_author, data_theme, data_cat, data_access, data_lang, data_status, data_order, data_pin_img,data_email_responsable,data_page_enregistrement from ".$prefix."_data_mgr where dataid='$dataid'");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('Invalid query (dataEditPin) 1');
			}
			list($data_pin, $data_description, $data_formid, $data_date, $data_author, $data_theme, $data_cat, $data_access, $data_lang, $data_status, $data_order, $data_pin_img,$data_email,$data_page)= $db->sql_fetchrow($result);
		}

		// get theme list
		$result_theme = $db->sql_query("select data_themeid, data_theme  from ".$prefix."_data_theme");
		if (!$result_theme) {
			print_r ( $db->sql_error () );
			die('Invalid query (dataEditPin) 1');
		}

		// get cat list
		$result_cat = $db->sql_query("select data_catid,  data_category  from ".$prefix."_data_categories");
		if (!$result_cat) {
			print_r ( $db->sql_error () );
			die('Invalid query (dataEditPin) 1');
		}

		// get form list
		$result_form = $db->sql_query("select dynform_id,  dynform_name  from ".$prefix."_dynform");
		if (!$result_cat) {
			print_r ( $db->sql_error () );
			die('Invalid query (dataEditPin) Form List');
		}

		if ($editForm==0) $typid=""; // force id to null
		$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
		."<center>"._ADD_NEW_DATA_PIN."</center><br>"
		."<form action=\"system.php\" method=\"post\">"
		."<input type=\"hidden\" name=\"dataid\" value=\"$dataid\">"
		."<input type=\"hidden\" name=\"op\" value=\"dataSavePin\">"
		."<div align=center>"
		."<table class=systemTab>"
		."<tr class=systemTabHeader><th colspan=2 class=systemTabHeader>"._ADD_NEW_DATA_PIN."</th></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN."</td>"
		."<td><input type=\"text\" name=\"data_pin\" size=\"50\" maxlength=\"255\" value=\"$data_pin\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_DESCRIPTION."</td>"
		."<td><input type=\"text\" name=\"data_description\" size=\"50\" maxlength=\"255\" value=\"$data_description\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>";
		// ----- List Form ---------

		/*$formslist=getformlist();
		 for ($i=0; $i < sizeof($formslist); $i++) {
			if($formslist[$i]!="") {
			$optionValues = $optionValues."<option value='$formslist[$i]'";
			if($formslist[$i]==$data_formid) $optionValues = $optionValues."selected";
			$optionValues = $optionValues.">".ucfirst($formslist[$i])."</option>";
			}
			}

			$formframe.="<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_FORMID."</td>"
			."<td><select name=\"data_formid\">$optionValues</select> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>";*/
		$formframe.="<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_FORMID."</td>"
		."<td>".makeListPages("data_formid", $data_formid,"").displayHelp(_HELP_LAYER_NAME,true)."</td></tr>";

		// ----- List Theme ---------
		$formframe.="<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_THEME."</td>"
		."<td><select name=\"data_theme\">";
		$isSelected="";
		while(list($data_themeid, $data_them) = $db->sql_fetchrow($result_theme)) {
			if ($data_themeid==$data_theme) $isSelected="selected"; else $isSelected="";
			$formframe.= "<option value=\"$data_themeid\" $isSelected>$data_them</option>";
		}
		$formframe.= "</select> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>";
		// ----- List Categoty ---------
		$formframe.="<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_CATEGORY."</td>"
		."<td><select name=\"data_cat\">";
		$isSelected="";
		while(list($data_catid, $data_category) = $db->sql_fetchrow($result_cat)) {
			if ($data_catid==$data_cat) $isSelected="selected"; else $isSelected="";
			$formframe.= "<option value=\"$data_catid\" $isSelected>$data_category</option>";
		}
		$formframe.= "</select> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>";
		// ----- List Lang --------
		$optionValues="";
		if ($multilingual == 1) {
			$languageslist=getlanglist();
			for ($i=0; $i < sizeof($languageslist); $i++) {
				if($languageslist[$i]!="") {
					$optionValues = $optionValues."<option value='$languageslist[$i]'";
					if($languageslist[$i]==$data_lang) $optionValues = $optionValues."selected";
					$optionValues = $optionValues.">".ucfirst($languageslist[$i])."</option>";
				}
			}
			$formframe.="<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_LANG."</td>"
			."<td><select name=\"data_lang\">$optionValues</select> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>";
		} else {
			$formframe.="<input type=\"hidden\" name=\"data_lang\" value=\"\">";
		}
		
		require_once("modules/Sections/connector_class.php");
		$urlprefix = "modules.php?name=Sections&sop=viewarticle&artid=";
		$cc = new pageconnector();
		$sections = $cc->getSectionList();
		$menupage = "<select name=\"$nomselect\" size=\"1\" class=\"saisie_court\" onchange=\"if (this.value != '') {this.form.data_page_enregistrement.value = '$urlprefix'+this.value; }\" class=\"pages\">";
		$menupage .= "<option value=\"\">" . _DATA_PIN_CHOOSE_PAGE . "</option>";
		foreach ($sections as $section) {
			$menupage .= "<option value=\"\">" . $section[1] . "</option>";
			$articles = $cc->getPageList($section[0], "");
			if ($articles != "") {
				foreach ($articles as $article) {
					if ($urlprefix.$article[0] == $data_page) {
						$selected = "selected=\"selected\"";
					} else {
						$selected = "";
					}
					$menupage .= "<option value=\"" . $article[0] . "\" $selected> -> " . $article[1] . "</option>";
				}
			}
		}
		$menupage .= "</select>";
		
		$formframe.="<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_STATUS."</td>"
		."<td><input type=\"text\" name=\"data_status\" size=\"50\" maxlength=\"255\" value=\"$data_status\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_ORDER."</td>"
		."<td><input type=\"text\" name=\"data_order\" size=\"3\" maxlength=\"3\" value=\"$data_order\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_ACCESS."</td>"
		."<td><input type=\"text\" name=\"data_access\" size=\"50\" maxlength=\"255\" value=\"$data_access\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_MAIL."</td>"
		."<td><input type=\"text\" name=\"data_email_responsable\" size=\"50\" maxlength=\"255\" value=\"$data_email\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_PIN_PAGE."</td>"
		."<td><input type=\"text\" name=\"data_page_enregistrement\" size=\"50\" maxlength=\"255\" value=\"$data_page\"> ".displayHelp(_HELP_LAYER_NAME,true)."<br />$menupage</td></tr>"
		."<tr class=inputFormNone><td colspan=2><input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=dataDelPin&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]</td></tr>"
		."</table></div>"
		."</form>"
		."</DIV>";
		if ($asHtml) {
			return $formframe;
		}else {
			include("system/header_system.php");
			GraphicAdmin(_DATAMGRPIN);
			OpenOngletTable();
			echo "<div align=\"right\">";
			displayOngletBar("pin",_DATAADMIN,$ongletDef);
			echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	 	echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 	CloseOngletTable();
	 	include("system/footer_system.php");
		}// if else
	}
	/**
	 * dataEditTheme()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataEditTheme($data_themeid, $editForm=0, $asHtml=0){
		global $prefix, $db, $ongletDef;
		if ($editForm){
			// get information about Theme
			$result = $db->sql_query("select  data_theme, data_theme_description, data_theme_access, data_theme_order, data_theme_img   from ".$prefix."_data_theme where data_themeid='$data_themeid'");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('Invalid query');
			}
			list($data_theme, $data_theme_description, $data_theme_access, $data_theme_order, $data_theme_img)= $db->sql_fetchrow($result);
		}
		if ($editForm==0) $data_themeid=""; // force id to null
		$formframe="<DIV ID=\"formframe\" CLASS=\"formiframe\" ONCLICK=\"\" >\n"
		//."<center>"._ADD_NEW_DATA_THEME."</center><br>"
		."<br>"
		."<form action=\"system.php\" method=\"post\">"
		."<input type=\"hidden\" name=\"data_themeid\" value=\"$data_themeid\">"
		."<input type=\"hidden\" name=\"op\" value=\"dataSaveTheme\">"
		."<div align=center>"
		."<table class=systemTab>"
		."<tr class=systemTabHeader><th colspan=2 class=systemTabHeader>"._ADD_NEW_DATA_THEME."</th></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._THEME_NAME."</td>"
		."<td><input type=\"text\" name=\"data_theme\" size=\"50\" maxlength=\"255\" value=\"$data_theme\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_THEME_DESCRIPTION."</td>"
		."<td><input type=\"text\" name=\"data_theme_description\" size=\"50\" maxlength=\"255\" value=\"$data_theme_description\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_THEME_ORDER."</td>"
		."<td><input type=\"text\" name=\"data_theme_order\" size=\"3\" maxlength=\"3\" value=\"$data_theme_order\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td class=inputFormR>"._DATA_THEME_ACCESS."</td>"
		."<td><input type=\"text\" name=\"data_theme_access\" size=\"50\" maxlength=\"255\" value=\"$data_theme_access\"> ".displayHelp(_HELP_LAYER_NAME,true)."</td></tr>"
		."<tr class=inputFormNone><td colspan=2><input type=\"submit\" value=\""._SAVECHANGES."\"> [ <a href=\"system.php?op=dataDelTheme&amp;secid=$domid&amp;ok=0\">"._DELETE."</a> ]</td></tr>"
		."</table></div>"
		."</form>"
		."</DIV>";
		if ($asHtml) {
			return $formframe;
		}else {
			include("system/header_system.php");
			GraphicAdmin(_DATAMGRPIN);
			OpenOngletTable();
			echo "<div align=\"right\">";
			displayOngletBar("theme",_DATAMGRPIN,$ongletDef);
			echo "</div>";
	 	echo $formframe;
	 	echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	 	echo "<SCRIPT language=\"JavaScript\">switchdisplayIFrame('formframe');</SCRIPT>\n";
	 	CloseOngletTable();
	 	include("system/footer_system.php");
		}// if else
	}

	/**
	 * dataEditData
	 *
	 *
	 *
	 */
	function dataEditData($data_dataid, $dataid=null){
		global$prefix, $db, $admin, $uid, $ongletDef,$module_name;

		if (is_user($user)) {
			cookiedecode($user);
			$logname = $cookie[1];
		} else {
	  $logname="anonymous";
		}

		// getData
		if ($data_dataid!="") {
			$result = $db->sql_query("select data_data_author, data_data_content, data_data_form  from ".$prefix."_data_data where data_dataid='$data_dataid'");
			list($data_data_authors, $data_data_content, $data_data_form ) = $db->sql_fetchrow($result);
			$xmlDoc = new MiniXMLDoc();
			$xmlDoc->fromString($data_data_content);
			$formAsArray=$xmlDoc->toArray();
			$data1=$formAsArray["Form"];
			$data = array_map("html_entity_decode", $data1);
			$dataForm_dataid.="<input type=\"hidden\" name=\"data_dataid\" value=\"$data_dataid\" >";
			$formid=$data_data_form;
			$db->sql_freeresult($result);
		}

		include("system/header_system.php");
		GraphicAdmin(_DATAMGRPIN);
		OpenOngletTable();

		displayOngletBar("data",_DATAMGRPIN.":$data_data_form ",$ongletDef);

		//		echo "<div align=\"center\" >";
		//		echo "<form action=\"modules.php\" method=\"POST\">";
		//		echo "<input type=\"hidden\" name=\"sop\" value=\"saveForm\" >";
		//		echo "<input type=\"hidden\" name=\"name\" value=\"$module_name\" >";
		//		echo "<input type=\"hidden\" name=\"formid\" value=\"$formid\" >";
		//		echo $dataForm_dataid;
		//		// get form
		//		$tmpl_file = "modules/$module_name/forms/form.$formid.html";
		//		include($tmpl_file);
		//		echo "</form>";
		//		echo "</div>";

		//title
		if ($dataid) {
			$result = $db->sql_query("select data_pin, data_description, data_theme, data_cat, data_pin_img from ".$prefix."_data_mgr where dataid='$dataid'");
			list($data_pin, $data_description, $data_theme, $data_cat, $data_pin_img ) = $db->sql_fetchrow($result);
			$PinTitle=$data_pin;
			$PinDescription=$data_description;
		}
		else {
			$PinTitle="";
			$PinDescription="";
		}
		echo "<div align=\"center\">";
		echo "<p style=\"font-size: larger\"><b>$PinTitle</b></p>";
		echo "<p>$PinDescription</p>";
		echo "</div>";

		//------------------Data------------------------------
		if (isset($data) && count($data)>0) {
			echo '<script language="JavaScript">'."\n";
			echo "var data_datas = new Array();"."\n";
			foreach($data as $champ => $valeur) {
				echo 'data_datas["data['.$champ.']"] = "'.str_replace("\r","",str_replace("\n",'\n',html_entity_decode($valeur))).'";'."\n";
			}
			echo '</script>'."\n";
			echo '<script type="text/javascript">
function initFormDatas(formulaire) {
	for (var i in data_datas) {
		if (formulaire.elements[i].length && (formulaire.elements[i][0].type == "radio" || formulaire.elements[i][0].type == "checkbox")) {
			for (var j=0; j<formulaire.elements[i].length;j++) {
				if (formulaire.elements[i][j].value == data_datas[i]) {
					formulaire.elements[i][j].checked = true;
				}
			}
		}
		else {
			switch (formulaire.elements[i].type) {
				case "text":
				case "hidden":
				case "textarea" :
				case "select-one" :
				case "textarea" :
				case "password" :
					formulaire.elements[i].value = data_datas[i];
					break;
				case "radio","checkbox" :
					if (formulaire.elements[i].value == data_datas[i]) {
						formulaire.elements[i].checked = true;
					}
					break;
				case "select-multiple" :
					break;
			}
		}
	}
}
</script>';
		}
		// ---------------- Title ----------------------------
		/*echo "<table class=dataTitle>";
		echo "<tr><td class=dataTitle>$PinTitle</td></tr>";
		echo "<tr><td class=dataDesc>$PinDescription</td></tr>";
		echo "</table>";*/

		// include control form API
		$the_form = "\n<script language=\"Javascript\" src=\"javascripts/control_form.js\"></script>\n";
		$the_form .= "\n<SCRIPT language=\"JavaScript\" src=\"javascripts/lang/lang-$currentlang.js\"></SCRIPT>\n";
		$the_form .= "\n<form name=\"data_form\" action=\"system.php\" method=\"POST\" onsubmit=\"return submit_form(this)\">";
		$the_form .= "\n<input type=\"hidden\" name=\"op\" value=\"dataSaveData\" />";
		$the_form .= "\n<input type=\"hidden\" name=\"formid\" value=\"$formid\" />";
		$the_form .= "\n<input type=\"hidden\" name=\"dataid\" value=\"$dataid\" />";
		$the_form .= $dataForm_dataid;
		require_once("modules/Sections/connector_class.php");
		$cc = new pageconnector();
		$the_formulaire = $cc->getPageContent("","form.".$formid);
		echo "<center><table border=\"0\" cellpadding=\"0\" cellspacing=\"5\" style=\"border: 1px solid #565366;\"><tr><td>";
		echo preg_replace("#<form([^>]*)>#i",$the_form,$the_formulaire);
		echo "</td></tr></table></center>";
		if (isset($data) && count($data)>0) {
			echo '<script language="Javascript">
initFormDatas(document.forms["data_form"]);
if (typeof(init_the_form) == \'function\') {
	init_the_form(document.forms["data_form"]);
}
</script>';
		}

		CloseOngletTable();
		include ("system/footer_system.php");

	}

	/**
	 * dataDelCategory()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataDelCategory($data_catid, $ok=0){
		global $prefix, $db;
		if ($ok==1) {
			$db->sql_query("delete from ".$prefix."_data_categories where data_catid='$data_catid'");
			Header("Location: system.php?op=dataCategory");
		} else {
			include("system/header_system.php");
			GraphicAdmin(_DATAMGRPIN);
			OpenSysTable();
			echo "<center><font class=\"title\"><b>"._DATACATADMIN_TXT."</b></font></center>";
			CloseSysTable();
			echo "<br>";
			$result=$db->sql_query("select data_category from ".$prefix."_data_categories where data_catid='$data_catid'");
			list($data_category) = $db->sql_fetchrow($result);
			OpenSysTable();
			echo "<center><b>"._DELDATACAT.": $data_category</b><br><br>"
			.""._DELDATACATWARNING." $data_category ?<br>"
			.""._DELDATACATWARNING1."<br><br>"
			."[ <a href=\"system.php?op=dataCategory\">"._NO."</a> | <a href=\"system.php?op=dataDelCategory&data_catid=".$data_catid."&ok=1\">"._YES."</a> ]</center>";
			CloseSysTable();
			include("system/footer_system.php");
		}
	}
	/**
	 * dataDelPin()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataDelPin($dataid, $ok=0){
		global $prefix, $db;
		if ($ok==1) {
			$db->sql_query("delete from ".$prefix."_data_mgr where dataid='$dataid'");
			Header("Location: system.php?op=dataPin");
		}
		else {
			include("system/header_system.php");
			GraphicAdmin(_DATAMGRPIN);
			OpenSysTable();
			echo "<center><font class=\"title\"><b>"._DATAPINADMIN_TXT."</b></font></center>";
			CloseSysTable();
			echo "<br>";
			$result=$db->sql_query("select data_pin from ".$prefix."_data_mgr where dataid='$dataid'");
			list($data_pin) = $db->sql_fetchrow($result);
			OpenSysTable();
			echo "<center><b>"._DELDATAPIN.": $data_pin</b><br><br>"
			.""._DELDATAPINWARNING."<br><br>"
			."[ <a href=\"system.php?op=dataPin\">"._NO."</a> | <a href=\"system.php?op=dataDelPin&dataid=".$dataid."&ok=1\">"._YES."</a> ]</center>";
			CloseSysTable();
			include("system/footer_system.php");
		}
	}
	/**
	 * dataDelTheme()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataDelTheme($data_themeid, $ok=0){
		global $prefix, $db;
		if ($ok==1) {
			$db->sql_query("delete from ".$prefix."_data_theme where data_themeid='$data_themeid'");
			Header("Location: system.php?op=dataTheme");
		} else {
			include("system/header_system.php");
			GraphicAdmin(_DATAMGRPIN);
			OpenSysTable();
			echo "<center><font class=\"title\"><b>"._DATATHEMEADMIN_TXT."</b></font></center>";
			CloseSysTable();
			echo "<br>";
			$result=$db->sql_query("select data_theme from ".$prefix."_data_theme where data_themeid='$data_themeid'");
			list($data_theme) = $db->sql_fetchrow($result);
			OpenSysTable();
			echo "<center><b>"._DELDATATHEME.": $data_theme</b><br><br>"
			.""._DELDATATHEMEWARNING." $data_theme ?<br>"
			.""._DELDATATHEMEWARNING1."<br><br>"
			."[ <a href=\"system.php?op=dataTheme\">"._NO."</a> | <a href=\"system.php?op=dataDelTheme&data_themeid=".$data_themeid."&ok=1\">"._YES."</a> ]</center>";
			CloseSysTable();
			include("system/footer_system.php");
		}
	}

	/**
	 * dataDelData()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function dataDelData($data_dataid, $ok=0){
		global $prefix, $db;
		if ($ok==1) {
			$db->sql_query("delete from ".$prefix."_data_data where data_dataid='$data_dataid'");
			Header("Location: system.php?op=dataData");
		} else {
			include("system/header_system.php");
			GraphicAdmin(_DATAMGRPIN);
			OpenSysTable();
			echo "<center><font class=\"title\"><b>"._DATAPINADMIN_TXT."</b></font></center>";
			CloseSysTable();
			echo "<br>";
			$result=$db->sql_query("select data_pin from ".$prefix."_data_mgr where dataid='$dataid'");
			list($data_pin) = $db->sql_fetchrow($result);
			OpenSysTable();
			echo "<center><b>"._DELDATADATA.": $data_pin</b><br><br>"
			.""._DELDATADATAWARNING." $data_pin ?<br>"
			.""._DELDATADATAWARNING1."<br><br>"
			."[ <a href=\"system.php?op=dataData\">"._NO."</a> | <a href=\"system.php?op=dataDelData&data_dataid=".$data_dataid."&ok=1\">"._YES."</a> ]</center>";
			CloseSysTable();
			include("system/footer_system.php");
		}
	}


	/**
	 * getformlist()
	 * return form liste located in /modules/BalisteData/forms as an array
	 * @return form list array
	 *
	 */
	function getformlist(){
		global $module_name;

		$handle=opendir('modules/'.$module_name.'/forms');
		while ($file = readdir($handle)) {
			if (preg_match("/^form\.(.+)\.html/", $file, $matches)) {
				$formFound = $matches[1];
				$formslist .= "$formFound ";
			}
		}
		closedir($handle);
		$formslist = explode(" ", $formslist);
		sort($formslist);
		return $formslist;
	}

	/**
	 * viewForm
	 * display data
	 * @param data id
	 * @return nothing
	 */
	function dataView($data_dataid){
		global $m ,$sitename, $prefix, $db, $admin, $uid,$ongletDef;

		// getData
		if ($data_dataid!="") {
			$result = $db->sql_query("select data_data_author, data_data_content, data_data_form, data_mgr_dataid  from ".$prefix."_data_data where data_dataid='$data_dataid'");
			list($data_data_authors, $data_data_content, $data_data_form,$data_mgr_dataid ) = $db->sql_fetchrow($result);
			$xmlDoc = new MiniXMLDoc();
			$xmlDoc->fromString($data_data_content);
			$formAsArray=$xmlDoc->toArray();
			$data1=$formAsArray["Form"];
			$data = array_map("html_entity_decode", $data1);
		}
		$db->sql_freeresult($result);

		// get pin title and descrisption if pin id is provided
		if ($data_dataid) {
			$result = $db->sql_query("select data_pin, data_description, data_theme, data_cat, data_pin_img from ".$prefix."_data_mgr where dataid='$data_mgr_dataid'");
			list($data_pin, $data_description, $data_theme, $data_cat, $data_pin_img ) = $db->sql_fetchrow($result);
			$PinTitle=$data_pin;
			$PinDescription=$data_description;
		}
		else {
			$PinTitle="";
			$PinDescription="";
		}

		if ($data_data_form=="") $formid="balistis";

		include("system/header_system.php");
		GraphicAdmin(_DATAMGRPIN);
		displayOngletBar("data",_DATAMGRPIN.":$data_data_form ",$ongletDef);
		//OpenOngletTable();
		// ---------------- Title ----------------------------
		echo "<div align=\"center\">";
		echo "<p style=\"font-size: larger\"><b>$PinTitle</b></p>";
		echo "<p>$PinDescription</p>";
		echo "</div>";

		/*echo "<center>";
		 // get css
		 echo "<LINK REL=\"StyleSheet\" HREF=\"modules/$module_name/forms/css.$data_data_form.css\" media=\"screen, handheld\" TYPE=\"text/css\">\n";
		 // get pin
		 $tmpl_file = "modules/$module_name/forms/view.$data_data_form.html";
		 include($tmpl_file);
		 echo "</center>";*/

		require_once("modules/Sections/connector_class.php");
		$cc = new pageconnector();
		$fiche = $cc->getPageContent("","view.".$data_data_form);
		$fiche = str_ireplace("data[","\$data[",$fiche);
		$fiche = addslashes($fiche);
		eval("\$fiche = \"".$fiche."\";");
		$fiche = stripslashes($fiche);
		echo "<center><table border=\"0\" cellpadding=\"0\" cellspacing=\"5\" style=\"border: 1px solid #565366;\"><tr><td>";
		echo $fiche;
		echo "</td></tr></table></center>";
		include ("system/footer_system.php");
	}
	function dataSaveData($data_dataid, $data, $formid,$dataid){
		global $prefix, $db, $module_name;

		// create an xml content
		$xmlDoc = new MiniXMLDoc();
		$formArray=array("Form"=>$data);
		$xmlDoc->fromArray($formArray);
		$stringform=$xmlDoc->toString();

		if (isset($data_dataid) && $data_dataid!="") {
			// update
			$result=$db->sql_query("update ".$prefix."_data_data set data_data_content='$stringform' where data_dataid='$data_dataid'");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('Invalid query (dataSaveForm Update)');
			}
			Header("Location: system.php?op=dataData");
		}
		else{
			include("system/header_system.php");
			GraphicAdmin(_DATAMGRPIN);
			displayOngletBar("data",_DATAMGRPIN.":$data_data_form ",$ongletDef);
			echo "Erreur : les donnes n'ont pas leurs bonnes valeurs !'";
			include ("system/footer_system.php");
		}

	}

	function listDataContent($dataid) {
		global $prefix, $db, $ongletDef,$module_name,$page_en_cours;
		$articles_par_page = 25;
		if (!isset($page_en_cours) || $page_en_cours=="") {
			$page_en_cours = 1;
		}
		include("system/header_system.php");
		//style
		echo '<link href="modules/'.$module_name.'/system/data-edit.css" rel="stylesheet" type="text/css" media="all" />';
	
		$barDef=array("view"=> array( "text"=>_VIEW,"icon"=>"icon_eye.gif", "comment"=>_VIEW, "status"=>"ON"),
						"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "comment"=>_EDIT, "status"=>"ON"),
  			          "delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));
		GraphicAdmin(_DATAMGRPIN);
		OpenSysTable();
		OpenOngletTable();
		displayOngletBar("data",_DATAMGRPIN.":$data_data_form ",$ongletDef);
		$result = $db->sql_query("select data_dataid, data_data_author,data_data_content, data_data_date, data_mgr_dataid from ".$prefix."_data_data where data_mgr_dataid='$dataid' order by data_data_date");
		$index_pages = getPagesIndex($page_en_cours,$articles_par_page,$db->sql_numrows($result));
		$limInf = ($page_en_cours-1)*$articles_par_page;
		$limit_fiches = $limInf.",".$articles_par_page;
		
		$xmlDoc = new MiniXMLDoc();
		$tab_data_dataid = array();
		$datas = array();
		while (list($data_dataid, $data_data_author,$data_data_content, $data_data_date,$data_mgr_dataid) = $db->sql_fetchrow($result)) {
			$xmlDoc->fromString($data_data_content);
			$formAsArray=$xmlDoc->toArray();
			$datas=$formAsArray["Form"];
			$tab_data_dataid[]=$data_dataid;
		}
		if ($datas[_num]) {
			for ($i=0;$i<$datas[_num];$i++) {
				$datas[$i] = array_map("html_entity_decode",$datas[$i]);
			}
		}
		else {
			if (is_array($datas)) {
				$datas2 = array_map("html_entity_decode", $datas);
				$datas = array($datas2);
			}
			else {
				$datas = array();
			}
		}
		$les_champs = array();
		foreach($datas as $data) {
			if (is_array($data)) {
				foreach($data as $champ => $valeur) {
					$les_champs[] = $champ;
				}
			}
		}
		$les_champs = array_unique($les_champs);
		sort($les_champs, SORT_STRING);
		
		$result = $db->sql_query("select data_dataid, data_data_author,data_data_content, data_data_date, data_mgr_dataid from ".$prefix."_data_data where data_mgr_dataid='$dataid' order by data_data_date limit $limit_fiches");
		
		$xmlDoc = new MiniXMLDoc();
		$tab_data_dataid = array();
		$tab_data_data_author = array();
		$tab_data_data_date = array();
		$datas = array();
		while (list($data_dataid, $data_data_author,$data_data_content, $data_data_date,$data_mgr_dataid) = $db->sql_fetchrow($result)) {
			$xmlDoc->fromString($data_data_content);
			$formAsArray=$xmlDoc->toArray();
			$datas=$formAsArray["Form"];
			$tab_data_dataid[]=$data_dataid;
			$tab_data_data_author[] = $data_data_author;
			$tab_data_data_date[] = $data_data_date;
		}
		if ($datas[_num]) {
			for ($i=0;$i<$datas[_num];$i++) {
				$datas[$i] = array_map("html_entity_decode",$datas[$i]);
			}
		}
		else {
			if (is_array($datas)) {
				$datas2 = array_map("html_entity_decode", $datas);
				$datas = array($datas2);
			}
			else {
				$datas = array();
			}
		}
		if (isset($datas) && count($datas)>0) {
			echo $index_pages;
			echo "<table class=lisTable><tr class=systemTabHeader>";
			echo "<td class=systemTabHeader><b>"._DATATITLEDATE."</b></td>";
			echo "<td class=systemTabHeader><b>"._DATATITLEAUTHOR."</b></td>";
			foreach($les_champs as $champ) {
				echo "<td class=systemTabHeader><b>".$champ."</b></td>";
			}
			echo "<td class=systemTabHeader align=\"center\">"._FUNCTIONS."</td>";
			echo "</tr>";
			$pos = 0;
			foreach($datas as $data) {
				if (is_array($data)) {
					if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
					echo "<tr class=\"$thestyle\">";
					echo "<td>".preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#","\\3/\\2/\\1",$tab_data_data_date[$pos])."</td>";
					echo "<td>".$tab_data_data_author[$pos]."</td>";
					foreach($les_champs as $champ) {
						$valeur = $data[$champ];
						echo "<td>".nl2br(html_entity_decode($valeur))."</td>";
					}
					echo "<td align=\"center\">";
					$data_dataid = $tab_data_dataid[$pos];
					$barDef["view"]["url"]="system.php?op=dataView&amp;data_dataid=$data_dataid";
					$barDef["edit"]["url"]="system.php?op=dataEditData&amp;data_dataid=$data_dataid&amp;dataid=$dataid";
					$barDef["delete"]["url"]="system.php?op=dataDelData&amp;data_dataid=$data_dataid&amp;ok=0";
					displayActionBar("add","Bar d'action",$barDef,"img");
					echo "</td>";
					echo "</tr>";
					$pos++;
				}
			}
			echo "</table>";
			echo "<p><a href=\"system.php?op=listDataContentToExcel&dataid=".$dataid."\">"._CLIENTDOWNLOADLISTING."</a></p>";
		}
		CloseOngletTable();
		CloseSysTable();
		include ("system/footer_system.php");
	}
	
	function listDataContentToExcel($dataid) {
		global $prefix, $db, $module_name;
		
		$result = $db->sql_query("select data_dataid, data_data_author,data_data_content, data_data_date, data_mgr_dataid from ".$prefix."_data_data where data_mgr_dataid='$dataid' order by data_data_date");
		$xmlDoc = new MiniXMLDoc();
		$tab_data_dataid = array();
		$tab_data_data_author = array();
		$tab_data_data_date = array();
		while (list($data_dataid, $data_data_author,$data_data_content, $data_data_date,$data_mgr_dataid) = $db->sql_fetchrow($result)) {
			$xmlDoc->fromString($data_data_content);
			$formAsArray=$xmlDoc->toArray();
			$datas=$formAsArray["Form"];
			$tab_data_dataid[]=$data_dataid;
			$tab_data_data_author[] = $data_data_author;
			$tab_data_data_date[] = $data_data_date;
		}
		if ($datas[_num]) {
			for ($i=0;$i<$datas[_num];$i++) {
				$datas[$i] = array_map("html_entity_decode",$datas[$i]);
			}
		}
		else {
			$datas2 = array_map("html_entity_decode", $datas);
			$datas = array($datas2);
		}

		if (isset($datas) && count($datas)>0) {
			set_time_limit(60);
			require_once "modules/$module_name/php_writeexcel/class.writeexcel_workbook.inc.php";
			require_once "modules/$module_name//php_writeexcel/class.writeexcel_worksheet.inc.php";
			$fname = tempnam("/tmp", "Export.xls");
			$workbook = new writeexcel_workbook($fname);
			$worksheet =& $workbook->addworksheet('Datas');
			
			$les_champs = array(_DATATITLEDATE,_DATATITLEAUTHOR);
			foreach($datas as $data) {
				if (is_array($data)) {
					foreach($data as $champ => $valeur) {
						$les_champs[] = $champ;
					}
				}
			}
			$les_champs = array_unique($les_champs);
			sort($les_champs, SORT_STRING);
			
			/*$worksheet->set_column('A:K', 20);
			$worksheet->set_column('A:B', 32);
			$worksheet->set_column('I:I', 32);*/
			$entete  =& $workbook->addformat(array(
											font		=> 'Arial',
											bg_color	=> 'silver',
	                                        bold    => 1,
	                                        color   => 'black',
	                                        size    => 12,
	                                        merge   => 1,
	                                        bold    => 1
	                                        ));
	        $donnee  =& $workbook->addformat(array(
											font		=> 'Arial',
											bold    => 0,
	                                        color   => 'black',
	                                        size    => 10,
	                                        merge   => 1,
	                                        text_h_align => 0,
	                                        num_format => '@'
	                                        ));
			$worksheet->write_row('A1', $les_champs, $entete);
			
			$compteur = 2;
			foreach($datas as $data) {
				if (is_array($data)) {
					$valeur = array();
					foreach($les_champs as $champ) {
						if ($champ == _DATATITLEAUTHOR) {
							$valeur[] = $tab_data_data_author[($compteur-2)];
						}
						elseif ($champ == _DATATITLEDATE) {
							$valeur[] = preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#","\\3/\\2/\\1",$tab_data_data_date[($compteur-2)]);
						}
						else {
							$valeur[] = str_replace("\r","",html_entity_decode($data[$champ]));
						}
					}
					$worksheet->write_row('A'.$compteur, $valeur, $donnee);
					$compteur++;
				}
			}
			$workbook->close();
			header("Content-Type: application/x-msexcel; name=\"example-demo.xls\"");
			header('Content-Disposition: inline; filename="Datas '.date("d-m-Y").'.xls"');
			$fh=fopen($fname, "rb");
			fpassthru($fh);
			unlink($fname);
		}
	}

	require_once("modules/Sections/connector_class.php");
	/**
	 * Cre un menu pop-up contenant la liste des pages disponibles ordonnes par rubrique.
	 *
	 * Cette fonction s'appuie sur la methode "getSectionList" du module "Sections"'
	 * @param string $nomselect Nom du menu pop-up
	 * @param string $link URL de le ligne de menu en cours
	 * @return string Chaine contenant le code HTML du menu pop-up
	 */
	function makeListPages($nomselect, $link,$langue_en_cours) {
		$cc = new pageconnector();
		$sections = $cc->getSectionList();
		$sortie = "<select name=\"$nomselect\" size=\"1\">";
		$sortie .= "<option value=\"\">"._CHOOSEFORM."</option>";
		foreach ($sections as $section) {
			$sortieSection = "<option value=\"\">" . $section[1] . "</option>";
			$sectionIncluse = false;
			$articles = $cc->getPageList($section[0], $langue_en_cours);
			if ($articles != "") {
				foreach ($articles as $article) {
					if (stripos($article[1], "form.") === 0) {
						$nomForm = substr($article[1],strlen("form."));
						if ($nomForm == $link) {
							$selected = " selected=\"selected\"";
						} else {
							$selected = "";
						}
						if ($sectionIncluse == false) {
							$sortie .= $sortieSection;
							$sectionIncluse = true;
						}
						//$sortie .= "<option value=\"".$article[0]."\" $selected> -> ".$nomForm."</option>";
						$sortie .= "<option value=\"".$nomForm."\"$selected> -> ".$nomForm."</option>";
					}
				}
			}
		}
		$sortie .= "</select>";
		return $sortie;
	}
	
/**
* Rcupre les variables envoyes par GET ou POST.
* 
* Renvoie ces variables sous la forme de paramtres d'URL.
* @param string $sauf Liste des paramtres  ne pas rcuprer.
* @return string Liste des variables rcupres.
*/	
	function getVars($sauf) {
		//global $_GET;

		$elimines = explode("|", $sauf);
		$args = "";
		$elts = array_merge($_GET,$_POST);
		if (count($elts) != 0) {
			while (list ($key, $val) = each($elts)) {
				$ok = true;
				foreach ($elimines as $elimine) {
					if ($elimine == $key) {
						$ok = false;
					}
				}
				if ($ok) {
					if ($args != "") {
						$args .= "&";
					}
					$args .= $key . "=" . stripslashes($val);
				}
			}
		}
		else {
			$args = "";
		}
		return $args;
	}

/**
* Renvoie l'indexation des rsultats  afficher par page.
* 
* @param array $criteres Tableau contenant les divers paramtres : .
* @return string Code HTML de l'index des pages  afficher.
*/	
	function getPagesIndex($page_en_cours,$articles_par_page,$nbreFiches) {
		if (!isset($page_en_cours) || $page_en_cours == "") {
			$page_en_cours = 1;
		}
		$repParPage = $articles_par_page;
		$p = $page_en_cours;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._DATAFOUNDPAGES;
		}
		else {
			$indexPages .= _DATANOTFOUNDPAGES;
		}
		$indexPages .= _DATALISTPAGES;
		for ($i=1;$i<=$nbrepages;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"?"
					.getVars("page_en_cours")
					."&"."page_en_cours"."=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	/*--------------------------------------*/
	/*           start Switch				*/
	/*--------------------------------------*/
	switch ($op) {
		case "dataTheme":
			dataTheme($editid, $editForm);
			break;
		case "dataCategory":
			dataCategory($editid, $editForm);
			break;
		case "dataPin":
			dataPin($editid, $editForm, $myfilter,$myfiltertwo);
			break;
		case "dataEditTheme":
			include_once("core/becms_ui_component.php");
			dataEditTheme($data_themeid, $editForm, $asHtml);
			break;
		case "dataEditPin":
			include_once("core/becms_ui_component.php");
			dataEditPin($dataid, $editForm, $asHtml);
			break;
		case "dataEditCategory":
			include_once("core/becms_ui_component.php");
			dataEditCategory($data_catid, $editForm, $asHtml);
			break;
		case "dataDelTheme":
			dataDelTheme($data_themeid, $ok);
			break;
		case "dataDelPin":
			dataDelPin($dataid, $ok);
			break;
		case "dataDelCategory":
			dataDelCat($data_catid, $ok);
			break;
		case "dataSaveTheme":
			dataSaveTheme($data_themeid, $data_theme, $data_theme_description, $data_theme_access, $data_theme_order, $data_theme_img);
			break;
		case "dataSaveCategory":
			dataSaveCategory($data_catid, $data_category, $data_cat_description, $data_cat_access, $data_cat_order);
			break;
		case "dataSavePin":
			dataSavePin($dataid, $data_pin, $data_description, $data_formid, $data_theme, $data_cat, $data_access, $data_lang, $data_status, $data_order, $data_pin_img, $data_email_responsable, $data_page_enregistrement);
			break;
		case "dataSaveData":
			dataSaveData($data_dataid, $data, $formid, $dataid);
			break;
		case "dataData":
			dataData();
			break;
		case "dataEditData":
			dataEditData($data_dataid, $dataid);
			break;
		case "dataDelData":
			dataDelData($data_dataid, $ok);
			break;
		case "dataView":
			dataView($data_dataid);
			break;
		case "listDataContent":
			listDataContent($dataid);
			break;
		case "listDataContentToExcel":
			listDataContentToExcel($dataid);
			break;
	}
}
else {
	display_denied();
}

?>