<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */
/*                                                                      */
/*   																	*/
/*  "MarchePublic" Module . Stephane CARLES 2006						*/
/* 	(carles@oec.fr)       												*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }


if (checkModuleRight("MarchePublic")) {
	setPath(_TXT_Modules,0);
	setPath(_MARCHES,1);
	/************************** Onglet definition ***********************/
	$ongletDef=array("encours"=> array( "text"=>_ENCOURS,
	"url"=>"system.php?op=marchepublic&onglet=encours"),
	"expire"=> array( "text"=>_EXPIRE,
	"url"=>"system.php?op=marchepublic&onglet=expire"),
	"attribue"=> array( "text"=>_ATTRIBUE,
	"url"=>"system.php?op=marchepublic&onglet=attribue"),
	"infructueux"=> array( "text"=>_INFRUCTUEUX,
	"url"=>"system.php?op=marchepublic&onglet=infructueux"),
	"procedure"=> array( "text"=>_PROCEDURE,
	"url"=>"system.php?op=marchepublic&onglet=procedure"),
	"demandeur"=> array( "text"=>_DEMANDEUR,
	"url"=>"system.php?op=marchepublic&onglet=demandeur")
	//"pdf"=> array( "text"=>_PDF_TITRE,
	//"url"=>"system.php?op=marchepublic&onglet=pdf")
	);

	
	function date2JMA($ladate) {
		if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			//list($an,$mois,$jour) = explode("-",$ladate);
			//return $jour."/".$mois."/".$an;
			return preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})#i","\\3/\\2/\\1 \\4:\\5",$ladate);
		}
	}
	/**
	 * marchepublic()
	 * Display list of exixting element trought tabs
	 * @param onglet need to be displayed
	 * @param acteur id
	 * @return
	 * @see
	 */
	function marchepublic($onglet, $editid, $editForm) {
		global $prefix, $db, $language, $multilingual,$ongletDef,$Default_Skin, $trace;
		include("system/header_system.php");
		GraphicAdmin(_MARCHEADMIN);
		echo "<SCRIPT language=\"JavaScript\" src=\"javascripts/insert.js\"></SCRIPT>\n";

		if (!isset($onglet)) {
			$onglet=encours;
		}


		$skinPath="system/skins/$Default_Skin";
		 
		switch ($onglet) {
			/* -----------------------------------------------------------------*/
			/*              List of All blocks									*/
			/* -----------------------------------------------------------------*/
			// ############################## EN COURS ####################################
	  case "encours":
	  	OpenSysTable();
	  	
	  	$barDef=array("edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "comment"=>_EDIT, "status"=>"ON"),
	  	"move"=> array( "text"=>_CHANGESTATUS,"icon"=>"move_16x16.png","comment"=>_CHANGESTATUS,"status"=>"ON"));
	  	
	  	$barDef2=array("view"=> array( "text"=>_VIEW,"icon"=>"icon_eye.gif", "comment"=>_VIEW, "status"=>"ON"),
	  	"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));
	  	
	  	$result = $db->sql_query("select marcheid, marche_titre, marche_deb, marche_fin , marche_heure, marche_proc_id, marche_etatid, marche_num from ".$prefix."_marche where marche_etatid=1 order by marche_titre");
	  	 
	  	if ($onglet=="") $onglet="sections";
	  	OpenOngletTable();
	  	displayOngletBar("encours",_MARCHEADMIN,$ongletDef);

    echo "<table class=lisTable><tr class=systemTabHeader>"
			."<td align=\"center\" class=systemTabHeader width=\"7%\">N</td>"
	    	."<td align=\"left\" class=systemTabHeader width=\"45%\">"._MARCHE."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"9%\">"._MARCHE_DEB."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"9%\">"._MARCHE_FIN."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"9%\">"._MARCHE_HEURE."</td>"	    	
			."<td align=\"center\" class=systemTabHeader width=\"7%\">"._DCE."</td>"
			."<td align=\"center\" class=systemTabHeader width=\"7%\">"._AAPC."</td>"
			."<td align=\"center\" class=systemTabHeader width=\"7%\">"._FUNCTIONS."</td>"
			."</tr>";		
    $pos=0;
    while(list($marcheid, $marche_titre, $marche_deb, $marche_fin, $marche_heure, $marche_proc_id, $marche_etatid, $marche_num) = $db->sql_fetchrow($result, $db)) {
	    	$theLink="<a href=\"system.php?op=marchepublic&onglet=demandeur&editid=$marcheid\" >";
	    	if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
	    	echo "<tr class=\"$thestyle\">"
	    	."<td align=\"center\">$marche_num</td>"
	    	."<td align=\"left\">$theLink $marche_titre</td>";
	    	list($annee,$mois,$jour) = explode("-",$marche_deb);
	    	list($annee2,$mois2,$jour2) = explode("-",$marche_fin);
	    echo "<td align=\"center\">$jour-$mois-$annee</td>"
	    ."<td align=\"center\">$jour2-$mois2-$annee2</td>"
	    ."<td align=\"center\">$marche_heure</td>";

	    //."<a href=\"system.php?op=Marche_Mouve&marcheid=$marcheid&amp;ok=0\"><img src=\"images/marches/supprimer.png\" border=0 alt=\"Supprimer\"></a>";

	    $result8 = $db->sql_query("select lid, title, url, pdf_marcheid from ".$prefix."_marche_downloads_downloads where pdf_marcheid='$marcheid' and pdf_etatid='5'");
	    if ($db->sql_numrows($result8)!=0) {
		    	list($lid, $title, $url, $pdf_marcheid) = $db->sql_fetchrow($result8);
		    	//echo "<td align=\"center\">[ <a href='$url' target=blank>"._SEE."</a> ]</td>";
		    	echo "<td align=\"center\">";
		    	//	echo "<a href='$url' target=blank><img src=\"$skinPath/icon_eye.gif\" border=0 alt=\"Voir\" title=\"Voir\"></a>";
		    	$barDef2["view"]["url"]="$url";
		    	$barDef2["view"]["target"]="_blank";
		    	$barDef2["delete"]["url"]="system.php?op=PDF_Delete&lid=$lid&url=".urlencode($url)."&ok=0";
		    	displayActionBar("add","Bar d'action",$barDef2,"img");
	
		    	echo "</td>";
	    }
	    else {
		    	$thelink="system.php?op=getUploadFile&test=5&marcheid=$marcheid";
		    	$strAttr = "status=no,resizable=no,scrollbars=no,width=400,height=120";
		    	$uploadlink="onClick=\"balisteOpenwindow('$thelink','Add','$strAttr');\"";
		    	//echo "<td align=\"center\"><a href=\"$myserver$curentScript?op=getUploadFile&test=5&marcheid=$marcheid\"><img src=\"$skinPath/download_16x16.png\" border=0 alt=\"Ajouter\" title=\"Ajouter\"></a></td>";
		    	echo "<td align=\"center\"><img src=\"$skinPath/download_16x16.png\" $uploadlink border=0 alt=\"Ajouter\" title=\"Ajouter\" ></td>";
	    }

	    $result7 = $db->sql_query("select lid, title, url, pdf_marcheid from ".$prefix."_marche_downloads_downloads where pdf_marcheid='$marcheid' and pdf_etatid='1'");
	    if ($db->sql_numrows($result7)!=0){
		    	list($lid, $title, $url, $pdf_marcheid) = $db->sql_fetchrow($result7);
		    	echo "<td align=\"center\">";
		    	//echo "<a href='$url' target=blank><img src=\"$skinPath/icon_eye.gif\" border=0 alt=\"Voir\" title=\"Voir\"></a>";
		    $barDef2["view"]["url"]="$url";
		    	$barDef2["view"]["target"]="_blank";
		    	$barDef2["delete"]["url"]="system.php?op=PDF_Delete&lid=$lid&url=".urlencode($url)."&ok=0";
		    	displayActionBar("add","Bar d'action",$barDef2,"img");	
		    	
		    	echo "</td>";
	    }
	    else {
		    	$thelink="system.php?op=getUploadFile&test=1&marcheid=$marcheid";
		    	$strAttr = "status=no,resizable=no,scrollbars=no,width=400,height=120";
		    	$uploadlink="onClick=\"balisteOpenwindow('$thelink','Add','$strAttr');\"";
		    	//echo "<td align=\"center\"><a href=\"$myserver$curentScript?op=getUploadFile&test=1&marcheid=$marcheid\"><img src=\"$skinPath/download_16x16.png\" border=0 alt=\"Ajouter\" title=\"Ajouter\"></a></td>";
		    	echo "<td align=\"center\"><img src=\"$skinPath/download_16x16.png\" $uploadlink border=0 alt=\"Ajouter\" title=\"Ajouter\" ></td>";
	    }
	    //echo "<td align=\"center\"><a href=\"system.php?op=Encours_Add&marcheid=$marcheid\"><img src=\"images/marches/editer.png\" border=0 alt=\"Editer\"></a> "
	    //	."<a href=\"system.php?op=Marche_Mouve&marcheid=$marcheid&amp;ok=0\"><img src=\"images/marches/deplacer.gif\" border=0 alt=\"Dplacer\"></a></td>";

	    echo "<td align=\"center\">";
	    $barDef["edit"]["url"]="system.php?op=Encours_Add&marcheid=$marcheid";
	    $barDef["move"]["url"]="system.php?op=Marche_Mouve&marcheid=$marcheid&amp;ok=0";
	     
	    displayActionBar("add","Bar d'action",$barDef,"img");


	    echo "</td></tr>";
	    $pos++;
    } // End While
    echo "</table>";
    echo "<br><a href=\"system.php?op=Encours_Add&marcheid=$marcheid\">[+] Ajouter un march</a>";

    CloseOngletTable();
    CloseSysTable();
     
    break;
    // ############################## EXPIRES ####################################
	  case "expire":
	  	setPath(_EXPIRE,2);
	  	OpenSysTable();
	  	$result = $db->sql_query("select marcheid, marche_titre, marche_fin, marche_etatid from ".$prefix."_marche where marche_etatid=2 order by marche_fin");

	  	$barDef=array("move"=> array( "text"=>_CHANGESTATUS,"icon"=>"move_16x16.png","comment"=>_CHANGESTATUS,"status"=>"ON"));
	  	OpenOngletTable();
	  	displayOngletBar("expire",_MARCHEADMIN,$ongletDef);

    echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td align=\"left\" class=systemTabHeader width=\"80%\"><b>"._MARCHE."</b></td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"13%\"><b>"._MARCHE_FIN."</b></td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"7%\"><b>"._FUNCTIONS."</b></td>"
			."</tr>";		
    $pos=0;
    while(list($marcheid, $marche_titre, $marche_fin) = $db->sql_fetchrow($result)) {
    	if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
    	echo "<tr class=\"$thestyle\">"
    	."<td align=\"left\">$marche_titre</td>";
    	list($annee2,$mois2,$jour2) = explode("-",$marche_fin);
    	echo "<td align=\"center\">$jour2-$mois2-$annee2</td>";
    	//."<td align=\"center\"><a href=\"system.php?op=Marche_Mouve&marcheid=$marcheid&amp;ok=0\"><img src=\"images/marches/deplacer.gif\" border=0 alt=\"Dplacer\"></a></td></tr>";

    	echo "<td align=\"center\">";
    	$barDef["move"]["url"]="system.php?op=Marche_Mouve&marcheid=$marcheid&amp;ok=0";
    	displayActionBar("add","Bar d'action",$barDef,"img");
    	echo "</td></tr>";


    	$pos++;
    } // End While
    echo "</table>";

    CloseOngletTable();
    CloseSysTable();
     
    break;
    // ############################## ATTRIBUE ####################################
	  case "attribue":
	  	setPath(_ATTRIBUE,2);
	  	OpenSysTable();
	  	$result = $db->sql_query("select marcheid, marche_titre, marche_etatid, marche_org_id from ".$prefix."_marche where marche_etatid=3 order by marche_titre");

	  	$barDef=array("move"=> array( "text"=>_CHANGESTATUS,"icon"=>"move_16x16.png","comment"=>_CHANGESTATUS,"status"=>"ON"));
	  	
	  	$barDef2=array("view"=> array( "text"=>_VIEW,"icon"=>"icon_eye.gif", "comment"=>_VIEW, "status"=>"ON"),
	  	"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));

	  	OpenOngletTable();
	  	displayOngletBar("attribue",_MARCHEADMIN,$ongletDef);

    echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td align=\"left\" class=systemTabHeader width=\"50%\">"._MARCHE."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"34%\">"._GAGNANT."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"7%\">PDF</td>"	
	    	."<td align=\"center\" class=systemTabHeader width=\"7%\">"._FUNCTIONS."</td>"
			."</tr>";		
    $pos=0;
    while(list($marcheid, $marche_titre, $marche_etatid, $marche_org_id) = $db->sql_fetchrow($result)) {
    	/*$result2 = $db->sql_query("select nom_user from ".$prefix."_marche_liste where marche_id='$marcheid'");
    	 if (!$result2) {
    	 print_r ( $db->sql_error () );
    		die('Invalid query');
    		}
    		list($nom_user) = $db->sql_fetchrow($result2);*/
    	$nom_user = ($marche_org_id == "0") ? "" : $marche_org_id;
    	$trace->trace("Nom=".$nom_user);
    	$trace->trace("Marcheid=".$marcheid);
    	$result7 = $db->sql_query("select lid, title, url, pdf_marcheid from ".$prefix."_marche_downloads_downloads where pdf_marcheid='$marcheid' and pdf_etatid='3'");

    	if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
    	echo "<tr class=\"$thestyle\">"
    	."<td align=\"left\">$marche_titre</td>";
    	echo "<td align=\"center\">$nom_user</td>";
    	if ($db->sql_numrows($result7)!=0){
    		//list($lid, $title, $url, $pdf_marcheid) = $db->sql_fetchrow($result7);
    		//echo "<td align=\"center\"><a href='$url' target=blank><img src=\"$skinPath/icon_eye.gif\" border=0 alt=\"Voir\" title=\"Voir\"></a></td>";
    		
    		list($lid, $title, $url, $pdf_marcheid) = $db->sql_fetchrow($result7);
	    	echo "<td align=\"center\">";
	    	//echo "<a href='$url' target=blank><img src=\"$skinPath/icon_eye.gif\" border=0 alt=\"Voir\" title=\"Voir\"></a>";
	    $barDef2["view"]["url"]="$url";
	    	$barDef2["view"]["target"]="_blank";
	    	$barDef2["delete"]["url"]="system.php?op=PDF_Delete&lid=$lid&url=".urlencode($url)."&ok=0";
	    	displayActionBar("add","Bar d'action",$barDef2,"img");	
	    	
	    	echo "</td>";
    		
    	}
    	else{
    		$thelink="system.php?op=getUploadFile&test=3&marcheid=$marcheid";
    		$strAttr = "status=no,resizable=no,scrollbars=no,width=400,height=120";
    		$uploadlink="onClick=\"balisteOpenwindow('$thelink','Add','$strAttr');\"";
    		echo "<td align=\"center\"><img src=\"$skinPath/download_16x16.png\" $uploadlink border=0 alt=\"Ajouter\" title=\"Ajouter\"></a></td>";
    	}
    	echo "<td align=\"center\">";
    	$barDef["move"]["url"]="system.php?op=Marche_Mouve&marcheid=$marcheid&amp;ok=0";
    	displayActionBar("add","Bar d'action",$barDef,"img");
    	echo "</td></tr>";

    	$pos++;
    } // End While
    echo "</table>";


    CloseOngletTable();
    CloseSysTable();
     
    break;
    // ############################## INFRUCTUEUX ####################################
	  case "infructueux":
	  	setPath(_INFRUCTUEUX,2);
	  	OpenSysTable();
	  	$result = $db->sql_query("select marcheid, marche_titre, marche_fin, marche_etatid from ".$prefix."_marche where marche_etatid=4 order by marche_titre");

 	  $barDef=array("delete"=> array( "text"=>_CHANGESTATUS,"icon"=>"move_16x16.png","comment"=>_CHANGESTATUS,"status"=>"ON"));

 	  OpenOngletTable();
 	  displayOngletBar("infructueux",_MARCHEADMIN,$ongletDef);

    echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td align=\"left\" class=systemTabHeader width=\"76%\">"._MARCHE."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"10%\">"._MARCHE_FIN."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"7%\">PDF</td>"	
	    	."<td align=\"center\" class=systemTabHeader width=\"7%\">"._FUNCTIONS."</td>"	    	
			."</tr>";		
    $pos=0;
    while(list($marcheid, $marche_titre, $marche_fin) = $db->sql_fetchrow($result)) {
    	if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
    	echo "<tr class=\"$thestyle\">"
    	."<td align=\"left\">$marche_titre</td>";
    	list($annee2,$mois2,$jour2) = explode("-",$marche_fin);
    	echo "<td align=\"center\">$jour2-$mois2-$annee2</td>";

    	$result7 = $db->sql_query("select lid, title, url, pdf_marcheid from ".$prefix."_marche_downloads_downloads where pdf_marcheid='$marcheid' and pdf_etatid='4'");
    	if ($db->sql_numrows($result7)!=0){
    		list($lid, $title, $url, $pdf_marcheid) = $db->sql_fetchrow($result7);
    		echo "<td align=\"center\"><a href='$url' target=blank><img src=\"$skinPath/icon_eye.gif\" border=0 alt=\"Voir\" title=\"Voir\"></a></td>";
    	} else {
    		echo "<td align=\"center\"><a href=\"$myserver$curentScript?op=getUploadFile&test=4&marcheid=$marcheid\"><img src=\"$skinPath/download_16x16.png\" border=0 alt=\"Ajouter\" title=\"Ajouter\"></a></td>";
    	}

    	//."<td align=\"center\"><a href=\"system.php?op=Marche_Mouve&marcheid=$marcheid&amp;ok=0\"><img src=\"images/marches/supprimer.png\" border=0 alt=\"Supprimer\"></a></td>";

    	echo "<td align=\"center\">";
    	$barDef["delete"]["url"]="system.php?op=Marche_Mouve&marcheid=$marcheid&amp;ok=0";
    	displayActionBar("add","Bar d'action",$barDef,"img");
    	echo "</td></tr>";

    	$pos++;
    } // End While
    echo "</table>";

    CloseOngletTable();
    CloseSysTable();
     
    break;
    // ############################## PROCEDURES ####################################
	  case "procedure":
	  	OpenSysTable();
	  	setPath(_PROCEDURE,2);
	  	$result = $db->sql_query("select procedureid, procedure_nom, procedure_abrev from ".$prefix."_marche_procedure order by procedure_nom");
	  	 
	  	$barDef=array("edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png", "comment"=>_EDIT, "status"=>"ON"),
	  	"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));
	  	 
	  	OpenOngletTable();
	  	displayOngletBar("procedure",_MARCHEADMIN,$ongletDef);

    echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td align=\"left\" class=systemTabHeader width=\"60%\">"._NOM_PROC."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"30%\">"._NOM_ABREV."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"10%\">"._FUNCTIONS."</td>"
	    	."</tr>";
    $pos=0;
    while(list($procedureid,$procedure_nom,$procedure_abrev) = $db->sql_fetchrow($result)) {
    	if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
    	echo "<tr class=\"$thestyle\">"
    	."<td align=\"left\">$procedure_nom</td>"
    	."<td align=\"center\">$procedure_abrev</td>";
    	//."<td align=\"center\"><a href=\"system.php?op=Procedure_Add&procedureid=$procedureid\"><img src=\"images/marches/editer.png\" border=0 alt=\"Editer\"></a> "
    	//."<a href=\"system.php?op=Procedure_Delete&procedureid=$procedureid&amp;ok=0\"><img src=\"images/marches/supprimer.png\" border=0 alt=\"Supprimer\"></a></td></tr>";

    	echo "<td align=\"center\">";
    	$barDef["edit"]["url"]="system.php?op=Procedure_Add&procedureid=$procedureid";
    	$barDef["delete"]["url"]="system.php?op=Procedure_Delete&procedureid=$procedureid&amp;ok=0";
    	displayActionBar("add","Bar d'action",$barDef,"img");
    	echo "</td></tr>";

    	$pos++;
    } // End While
    echo "</table>";
    echo "<br><a href=\"system.php?op=Procedure_Add&procedureid=$procedureid\">[+] Ajouter une procdure</a>";

    CloseOngletTable();
    CloseSysTable();
    break;
    // ############################## DEMANDEUR ####################################
	  case "demandeur":
	  	setPath(_DEMANDEUR,2);
	  	OpenSysTable();
	  	OpenOngletTable();
	  	displayOngletBar("demandeur",_MARCHEADMIN,$ongletDef);

    echo "<table class=lisTable><tr class=systemTabHeader>"
	    	."<td align=\"left\" class=systemTabHeader><b>"._ORG."</b></td>"
	    	."<td align=\"center\" class=systemTabHeader><b>"._NOM."</b></td>"
			."<td align=\"center\" class=systemTabHeader><b>"._MAIL."</b></td>"
	    	."<td align=\"center\" class=systemTabHeader><b>"._MARCHE."</b></td>"
		."<td align=\"center\" class=systemTabHeader><b>"._INSCRIPTION."</b></td>"
	    //	."<td align=\"center\" bgcolor=\"$bgcolor2\" width=\"12%\"><b>"._FUNCTIONS."</b></td>"
    ."</tr>";
    
    $whereclose="";
	if ($editid!="") $whereclose="WHERE marche_id='$editid'";
	$result = $db->sql_query("select user_id, marche_id, nom_user, date_inscription from ".$prefix."_marche_liste $whereclose order by marche_id DESC, date_inscription DESC");
    
    $pos=0;
    while(list($user_id, $marche_id, $nom_user,$dateInscription) = $db->sql_fetchrow($result)) {
    	if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
    	$var_marche=$marche_id;
    	$result2 = $db->sql_query("select userid, user_nom, user_prenom, email from ".$prefix."_marche_users where userid='$user_id'");
    	list($userid, $user_nom, $user_prenom, $email) = $db->sql_fetchrow($result2);
    	echo "<tr class=\"$thestyle\">"
    	."<td align=\"left\"><a href=\"system.php?op=Org_Visu&userid=$user_id\">$nom_user</a></td>"
    	."<td align=\"center\">$user_nom $user_prenom</td>"
    	."<td align=\"center\">$email</td>";
    	$result22 = $db->sql_query("select marcheid, marche_titre from ".$prefix."_marche where marcheid='$var_marche' ");
    	if (!$result22) {
    		print_r ( $db->sql_error () );
    		die('Invalid query');
    	}
    	list($marcheid, $marche_titre) = $db->sql_fetchrow($result22);
    	echo "<td align=\"center\">$marche_titre</td>";
    	echo "<td align=\"center\">".date2JMA($dateInscription)."</td></tr>";
    	//."<td align=\"center\">[ <a href=\"system.php?op=Org_Delete&userid=$userid&amp;ok=0\">"._DELETE."</a> ]</td></tr>";
    	$pos++;
    } // End While
    echo "</table>";
    //echo "<br><a href=\"system.php?op=Org_Add&userid=$userid\">[+] Ajouter un demandeur</a>";

    CloseOngletTable();
    CloseSysTable();
    break;
     
    // ############################## PDF ####################################
	  case "pdf":
	  	setPath(_PDF,2);
	  	OpenSysTable();
	  	 
	  	$result = $db->sql_query("select lid,cid,title,url,name,pdf_marcheid,pdf_etatid from ".$prefix."_marche_downloads_downloads order by pdf_marcheid desc, pdf_etatid");

	  	$barDef=array("view"=> array( "text"=>_VIEW,"icon"=>"icon_eye.gif", "comment"=>_VIEW, "status"=>"ON"),
	  	"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","comment"=>_DELETE,"status"=>"ON"));
	  	 
	  	OpenOngletTable();
	  	displayOngletBar("pdf",_MARCHEADMIN,$ongletDef);

    echo "<table class=\"lisTable\" border=\"0\"><tr class=systemTabHeader>"
	    	."<td align=\"left\" class=systemTabHeader width=\"50%\">"._PDF_NOM."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"25%\">"._PDF_DEPOSE."</td>"
			."<td align=\"center\" class=systemTabHeader width=\"10%\">"._PDF_TYPE."</td>"
			."<td align=\"center\" class=systemTabHeader width=\"10%\">"._PDF_ETAT."</td>"
	    	."<td align=\"center\" class=systemTabHeader width=\"5%\">"._FUNCTIONS."</td>"
	    	."</tr>";
    $pos=0;
    while(list($lid,$cid,$title,$url,$name,$pdf_marcheid,$pdf_etatid) = $db->sql_fetchrow($result)) {
	    	if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
	    	echo "<tr class=\"$thestyle\">";
	    	$result2 = $db->sql_query("select marcheid, marche_titre, marche_etatid from ".$prefix."_marche where marcheid='$pdf_marcheid'");
	    	list($marcheid, $marche_titre, $marche_etatid) = $db->sql_fetchrow($result2);
	    	echo "<td align=\"left\">$marche_titre</td>"
	    	."<td align=\"center\">".(($name == "") ? " - " : $name)."</td>";
	    	//$result3 = $db->sql_query("select etatid, etat_nom from ".$prefix."_marche_etat where etatid='$pdf_etatid'");
	    	//list($etatid, $etat_nom) = $db->sql_fetchrow($result3);
	    	switch($pdf_etatid){
	    		case 1:
	    			echo "<td align=\"center\">AAPC</td>";
	    			break;
	    		case 5:
	    			echo "<td align=\"center\">DCE</td>";
	    			break;
	    		case 3:
	    			echo "<td align=\"center\">AA</td>";
	    			break;
	    		case 4:
	    			echo "<td align=\"center\">AI</td>";
	    			break;
	    		default:
	    			echo "<td align=\"center\">-</td>";
	    			break;
	    	}
	    //	$result4 = $db->sql_query("select marche_etatid, etat_nom from ".$prefix."_marche where etatid='$marche_etatid'");
	    //	list($etatid, $etat_nom) = $db->sql_fetchrow($result4);
	    	switch($marche_etatid){
	    		case 1:
	    			echo "<td align=\"center\">En cours</td>";
	    			break;
	    		case 5:
	    			echo "<td align=\"center\">En cours</td>";
	    			break;
	    		case 3:
	    			echo "<td align=\"center\">Attribue</td>";
	    			break;
	    		case 4:
	    			echo "<td align=\"center\">Infructueux</td>";
	    			break;
	    		case 2:
	    			echo "<td align=\"center\">Expir</td>";
	    			break;
	    		default:
	    			echo "<td align=\"center\">-</td>";
	    			break;
	    	}
	    	//echo "<td align=\"center\">$etat_nom</td>";
	    	//echo "<td align=\"center\"><a href=\"$url\" target=blank><img src=\"images/marches/voir.gif\" border=0 alt=\"Voir\"></a> "
	    	//."<a href=\"system.php?op=PDF_Delete&lid=$lid&url=$url&amp;ok=0\"><img src=\"images/marches/supprimer.png\" border=0 alt=\"Supprimer\"></a></td></tr>";
	
	    	echo "<td align=\"center\">";
	    	$barDef["view"]["url"]="$url";
	    	$barDef["delete"]["url"]="system.php?op=PDF_Delete&lid=$lid&url=$url&amp;ok=0";
	    	displayActionBar("add","Bar d'action",$barDef,"img");
	    	echo "</td></tr>";
	
	    	$pos++;
    } // End While
    echo "</table>";
    //echo "<br><a href=\"$myserver$curentScript?op=downloads\">[+] Ajouter un pdf</a>";

    CloseOngletTable();
    CloseSysTable();
    break;
     
		}// end switch
		 
		include("system/footer_system.php");
	}
		
	/**
	 * Encours_Add()
	 *
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function Encours_Add($marcheid=0) {
		global $prefix, $db, $language, $multilingual, $ongletDef;
		include("system/header_system.php");
		GraphicAdmin(_MARCHEADMIN);
		displayOngletBar("encours",_MARCHEADMIN,$ongletDef);

		// calendar stylesheet -->
		echo "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"javascripts/calendar/styles/calendar-win2k-cold-1.css\" title=\"win2k-cold-1\" />\n";
		//  main calendar program
		echo "<script type=\"text/javascript\" src=\"javascripts/calendar/calendar.js\"></script>\n";
		// language for the calendar
		echo "<script type=\"text/javascript\" src=\"javascripts/calendar/lang/calendar-fr.js\"></script>\n";
		// the following script defines the Calendar.setup helper function, which makes
		//   adding a calendar a matter of 1 or 2 lines of code
		echo "<script type=\"text/javascript\" src=\"javascripts/calendar/calendar-setup.js\"></script>\n";

		echo "<form method=\"post\" action=\"system.php\">";
		if ($marcheid!=0){
			$result = $db->sql_query("select marcheid, marche_titre, marche_deb, marche_fin, marche_heure, marche_proc_id, marche_etatid,marche_num from ".$prefix."_marche where marcheid='$marcheid' order by marche_fin ");
			list($marcheid, $marche_titre, $marche_deb, $marche_fin, $marche_heure, $marche_proc_id, $marche_etatid, $marche_num)=$db->sql_fetchrow($result);
			echo "<input type=hidden name=\"op\" value=\"Encours_Update\">";
			echo "<input type=hidden name=\"marcheid\" value=\"$marcheid\">";
			echo "<input type=hidden name=\"marche_etatid\" value=\"1\">";
		}
		else {
			echo "<input type=hidden name=\"op\" value=\"Encours_Save\">";
			echo "<input type=hidden name=\"marche_etatid\" value=\"1\">";
		}
		echo "<div align=center><table class=systemTab>"
			."<tr>";
		if ($marcheid!=0){
			echo "<td colspan=2 align=\"center\" class=systemTabHeader><b>Modifier un march en cours</b></td>";
		}
		else {
			echo "<td colspan=2 align=\"center\" class=systemTabHeader><b>Ajouter un march en cours</b></td>";
		}
		echo "</tr>\n"
			."<tr>"
	    	."<td align=\"right\"  width=\"30%\"><b>"._MP_TITLE." : </b></td>"
	    	."<td align=\"left\"  width=\"70%\"><input type=text name=\"marche_titre\" size=70 value=\"$marche_titre\"> ".displayHelp(_MP_TITLE_HELP,true)."</td>"
	    	."</tr>"
			."<tr>"
	    	."<td align=\"right\"  width=\"30%\"><b>"._MP_NUM_MP." : </b></td>"
	    	."<td align=\"left\"  width=\"70%\"><input type=text name=\"marche_num\" size=20 maxlength=15 value=\"$marche_num\"> ".displayHelp(_MP_NUM_MP_HELP,true)."</td>"
	    	."</tr>\n"			
			."<tr>"
	    	."<td align=\"right\"  width=\"30%\"><b>"._MP_STARTDATE." : </b></td>"
	    	."<td align=\"left\"  width=\"70%\">"
	    	."<b><input type=text name=\"marche_deb\" id=\"marche_deb\" readonly=\"1\" size=12 maxlength=10 value=\"$marche_deb\"></b>"
		." <img style=\"vertical-align:middle;\" src=\"images/img.gif\" id=\"f_trigger_c\" style=\"cursor: pointer; border: 1px solid red;\" title=\"Date selector\" "
            ."onmouseover=\"this.style.background='red';\" onmouseout=\"this.style.background=''\" />"
	    	." ".displayHelp(_MP_STARTDATE_HELP,true)."</td></tr>\n"
			."<tr>"
	    	."<td align=\"right\"  width=\"30%\"><b>"._MP_ENDDATE."Date fin (aaaa-mm-jj) : </b></td>"
	    	."<td align=\"left\"  width=\"70%\" valign=middle ><b><input type=text name=\"marche_fin\" id=\"marche_fin\" size=12 maxlength=10 value=\"$marche_fin\"></b>"
		." <img style=\"vertical-align:middle;\" src=\"images/img.gif\" id=\"f_trigger_c2\" style=\"cursor: pointer; border: 1px solid red;\" title=\"Date selector\" "
            ."onmouseover=\"this.style.background='red';\" onmouseout=\"this.style.background=''\" />"
	    	." ".displayHelp(_MP_ENDDATE_HELP,true)."</td></tr>\n"
			."<tr>"
	    	."<td align=\"right\"  width=\"30%\"><b>"._MP_HOUREND." : </b></td>"
	    	."<td align=\"left\"  width=\"70%\"><input type=text name=\"marche_heure\" size=12 maxlength=8 value=\"$marche_heure\"> ".displayHelp(_MP_HOUREND_HELP_,true)."</td>"
	    	."</tr>\n"
			."<tr>"
	    	."<td align=\"right\"  width=\"30%\"><b>"._MP_PROCESS." : </b></td>"
	    	."<td align=\"left\"  width=\"70%\">"
			."<select name=\"marche_proc_id\">\n"
		 	."<option value=0>"._MP_NO_PROCESS."</option>\n";
		$result3 = $db->sql_query("select procedureid, procedure_nom, procedure_abrev  from ".$prefix."_marche_procedure order by procedure_abrev desc");
		if (!$result3) {
			print_r ( $db->sql_error () );
			die('Encours_Add :: Invalid query');
		}
		while(list($procedureid, $procedure_nom, $procedure_abrev) = $db->sql_fetchrow($result3)) {
			if ($procedureid==$marche_proc_id) {$selected="selected";} else {$selected="";}
			echo "<option value=$procedureid $selected>$procedure_nom</option>\n";
		}
		echo "</select>";
		echo " ".displayHelp(_MP_PROCESS_HELP,true)."</td></tr>\n"
			."<tr>"
	    	."<td colspan=2 align=\"center\" width=\"50%\"><input type=submit value=\"Sauver\"></td>"
	       	."</tr>"
			."<tr>"
			."<td colspan=2 class=systemTabFooter>[<a href=\"system.php?op=marchepublic&onglet=encours\">Retour</a>]</td>"
		  	."</tr>"
			."</table></div>";
			
			
		// init calendar
		echo "<script type=\"text/javascript\">\n"
    ."Calendar.setup({\n"
    ."   inputField     :    \"marche_deb\",\n"
    ."	 ifFormat       :    \"%Y-%m-%d %H:%M:%S\",\n"
    ."   showsTime      :    false,\n  "
    ."    button         :    \"f_trigger_c\",\n"
    ."    align          :    \"Tl\",\n"
    ."    singleClick    :    true\n"
    ."});\n"
    ."Calendar.setup({\n"
    ."   inputField     :    \"marche_fin\",\n"
    ."	 ifFormat       :    \"%Y-%m-%d %H:%M:%S\",\n"
    ."   showsTime      :    false,\n  "
    ."    button         :    \"f_trigger_c2\",\n"
    ."    align          :    \"Tl\",\n"
    ."    singleClick    :    true\n"
    ."});\n"
    ."</script>\n";		
		echo "</form>";	
		include("system/footer_system.php");

	}

	/**
	 * Procedure_Add()
	 *
	 *
	 */
	function Procedure_Add($procedureid=0) {
		global $prefix, $db, $language, $multilingual,$ongletDef;
		include("system/header_system.php");
		GraphicAdmin(_MARCHEADMIN);
		displayOngletBar("procedure",_MARCHEADMIN,$ongletDef);
		echo "<form method=post action=\"system.php\">";
		if ($procedureid!=0){
			$result = $db->sql_query("select procedureid, procedure_nom, procedure_abrev from ".$prefix."_marche_procedure where procedureid='$procedureid'");
			list($procedureid, $procedure_nom, $procedure_abrev)=$db->sql_fetchrow($result);
			echo "<input type=hidden name=\"op\" value=\"Procedure_Update\">";
			echo "<input type=hidden name=\"procedureid\" value=\"$procedureid\">";
		}
		else {
			echo "<input type=hidden name=\"op\" value=\"Procedure_Save\">";
		}
		echo "<br><table class=systemTab>"
			."<tr>";
		if ($procedureid!=0){
			echo "<td colspan=2 align=\"center\" class=systemTabHeader><b>Modifier une procdure</b></td>";
		}
		else {
			echo "<td colspan=2 align=\"center\" class=systemTabHeader><b>Ajouter une procdure</b></td>";
		}
		echo "</tr>"
			."<tr>"
	    	."<td align=\"right\"  width=\"30%\"><b>Nom : </b></td>"
	    	."<td align=\"left\"  width=\"70%\"><b><input type=text name=\"procedure_nom\" size=80 value=\"$procedure_nom\"</b></td>"
		."</tr>"
			."<tr>"
	    	."<td align=\"right\"  width=\"30%\"><b>Abrviation : </b></td>"
	    	."<td align=\"left\"  width=\"70%\"><b><input type=text name=\"procedure_abrev\" size=15 value=\"$procedure_abrev\"</b></td>"
		."</tr>"
			."<tr>"
	    	."<td colspan=2 align=\"center\" width=\"50%\"><input type=submit value=\"Sauver\"></td>"
	       	."</tr>"
			."<tr>"
			."<td colspan=2 class=systemTabFooter>[<a href=\"system.php?op=marchepublic&onglet=procedure\">Retour</a>]</td>"
		  	."</tr>"
			."</table>";
		include("system/footer_system.php");

	}

	/**
	 * methodeSave()
	 * Save data in data base
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function Encours_Save($marche_titre,$marche_deb,$marche_fin,$marche_heure,$marche_proc_id,$marche_etatid,$marche_num){
		global $prefix, $db;
		$marche_titre = ucfirst(stripslashes(FixQuotes($marche_titre)));
		$marche_deb = stripslashes(FixQuotes($marche_deb));
		$marche_fin = stripslashes(FixQuotes($marche_fin));
		$marche_heure = stripslashes(FixQuotes($marche_heure));
		$marche_proc_id = stripslashes(FixQuotes($marche_proc_id));
		$marche_etatid = stripslashes(FixQuotes($marche_etatid));
		$result=$db->sql_query("INSERT INTO ".$prefix."_marche VALUES (NULL,'$marche_titre','$marche_deb','$marche_fin','$marche_heure','$marche_proc_id','$marche_etatid','','$marche_num')");
		if (!$result) {
			echo "$marche_etatid, $marche_titre, $marche_deb, $marche_fin, $marche_heure, $marche_proc_id, $marche_etatid >>>";
			print_r($db->sql_error());
			die('Invalid query');
		}
		Header("Location: system.php?op=marchepublic&onglet=encours");
	}

	/**
	 * Procedure_Save()
	 *
	 *
	 */
	function Procedure_Save($procedure_nom,$procedure_abrev){
		global $prefix, $db;
		$procedure_nom = ucfirst(stripslashes(FixQuotes($procedure_nom)));
		$procedure_abrev = strtoupper(stripslashes(FixQuotes($procedure_abrev)));
		$result=$db->sql_query("INSERT INTO ".$prefix."_marche_procedure VALUES (NULL,'$procedure_nom', '$procedure_abrev')");
		if (!$result) {
			print_r($db->sql_error());
			die('Procedure_Save :: Invalid query');
		}
		Header("Location: system.php?op=marchepublic&onglet=procedure");
	}

	/**
	 * methodeUpdate()
	 * Update data in database
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function Encours_Update($marcheid, $marche_titre, $marche_deb, $marche_fin, $marche_heure, $marche_proc_id, $marche_etatid,$marche_num){
		global $prefix, $db;
		$marche_titre = ucfirst(stripslashes(FixQuotes($marche_titre)));
		$marche_deb = stripslashes(FixQuotes($marche_deb));
		$marche_fin = stripslashes(FixQuotes($marche_fin));
		$marche_heure = stripslashes(FixQuotes($marche_heure));
		$marche_proc_id = stripslashes(FixQuotes($marche_proc_id));
		$marche_etatid = stripslashes(FixQuotes($marche_etatid));
		$marche_num = stripslashes(FixQuotes($marche_num));
		$result=$db->sql_query("update ".$prefix."_marche set marche_titre='$marche_titre', marche_deb='$marche_deb', marche_fin='$marche_fin', marche_heure='$marche_heure', marche_proc_id='$marche_proc_id', marche_etatid='1', marche_num='$marche_num' where marcheid=$marcheid");
		if (!$result) {
			print_r($db->sql_error());
			die('Encours_Update :: Invalid query');
		}

		Header("Location: system.php?op=marchepublic&onglet=encours");

	}

	/**
	 * Procedure_Update()
	 *
	 *
	 */
	function Procedure_Update($procedureid,$procedure_nom, $procedure_abrev){
		global $prefix, $db;
		$procedure_nom = ucfirst(stripslashes(FixQuotes($procedure_nom)));
		$procedure_abrev = strtoupper(stripslashes(FixQuotes($procedure_abrev)));
		$result=$db->sql_query("update ".$prefix."_marche_procedure set procedure_nom='$procedure_nom', procedure_abrev='$procedure_abrev' where procedureid=$procedureid");
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query');
		}
		Header("Location: system.php?op=marchepublic&onglet=procedure");

	}
	/**
	 * Marche_Update()
	 *
	 *
	 */
	function Marche_Update($marcheid,$marche_etatid,$marche_org_id,$marche_etat){
		global $prefix, $db;
		$marche_etatid = stripslashes(FixQuotes($marche_etat));
		if($marche_etatid!=3){
			$marche_org_id = '0';
		}else{
			$marche_org_id = stripslashes(FixQuotes($marche_org_id));
		}
		$result=$db->sql_query("update ".$prefix."_marche set marche_etatid='$marche_etatid', marche_org_id='$marche_org_id' where marcheid=$marcheid");
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query');
		}

		Header("Location: system.php?op=marchepublic&onglet=encours");

	}
	/**
	 * methodeDelete()
	 * Delete
	 * @param
	 * @param
	 * @return
	 * @see
	 */
	function Marche_Mouve($marcheid=0){
		global $prefix, $db, $language, $multilingual;
		include("system/header_system.php");
		GraphicAdmin(_MARCHEADMIN);
		echo "<form method=\"post\" action=\"system.php\">";
		if ($marcheid!=0){
			$result = $db->sql_query("select marcheid, marche_etatid, marche_org_id from ".$prefix."_marche where marcheid='$marcheid'");
			list($marcheid, $marche_etatid, $marche_org_id)=$db->sql_fetchrow($result);
			echo "<input type=hidden name=\"op\" value=\"Marche_Update\">";
			echo "<input type=hidden name=\"marcheid\" value=\"$marcheid\">";
		}
		//	OpenSysTable();
		//echo "<center><font class=\"title\"><b>"._DEPLACER."</b></font></center>";
		echo "<br><table class=systemTab width=100%>"
	."<tr class=systemTabHeader>"
	."<td colspan=2 class=systemTabHeader align=\"center\"><b>Modifier l'tat du march $marcheid</b></td>"
		."</tr>";
		$result5 = $db->sql_query("select marcheid, marche_etatid, marche_org_id from ".$prefix."_marche where marcheid='$marcheid'");
		while(list($marcheid,$marche_etatid,$marche_org_id) = $db->sql_fetchrow($result5)){
			echo "<tr>"
	."<td align=\"right\" width=\"30%\"><b>En cours : </b></td>"
	."<td align=\"left\"  width=\"70%\"><b>";
			if ($marche_etatid==1){
				echo "<input type=radio checked name=\"marche_etat\" size=70 value=\"1\"></b></td>";
			} else {
				echo "<input type=radio name=\"marche_etat\" size=70 value=\"1\" ></b></td>";
			}
			echo "</tr>"
	."<tr>"
	."<td align=\"right\" width=\"30%\"><b>Expir : </b></td>"
	."<td align=\"left\"  width=\"70%\"><b>";
			if ($marche_etatid==2){
				echo "<input type=radio checked name=\"marche_etat\" size=70 value=\"2\"></b></td>";
			} else {
				echo "<input type=radio name=\"marche_etat\" size=70 value=\"2\" ></b></td>";
			}
			echo "</tr>"
	."<tr>"
	."<td align=\"right\"  width=\"30%\"><b>Attribu : </b></td>"
	."<td align=\"left\"  width=\"70%\"><b>";
			if ($marche_etatid==3){
				echo "<input type=radio checked name=\"marche_etat\" size=70 value=\"3\"></b></td>";
			} else {
				echo "<input type=radio name=\"marche_etat\" size=70 value=\"3\" ></b></td>";
			}
			echo "</tr>"
	."<tr>"
	."<td align=\"right\"  width=\"30%\"><b></b></td>"
	    	."<td align=\"left\"  width=\"70%\">"
		."<input type=\"text\" value=\"".$marche_org_id."\" size=\"25\" name=\"marche_org_id\"> "
		."<select name=\"marche_org_id_menu\" onchange=\"this.form.elements['marche_org_id'].value = this.value\">"
		."<option value=\"0\">Pas d'attribution</option>";
			$result3 = $db->sql_query("select marche_id, nom_user from ".$prefix."_marche_liste where marche_id='$marcheid' order by nom_user ");
			if (!$result3) {
				print_r($db->sql_error());
				die('Invalid query');
			}
			while(list($marche_id, $nom_user) = $db->sql_fetchrow($result3)) {
				if ($nom_user==$marche_org_id) {$selected=" selected=\"selected\"";} else {$selected="";}
				echo "<option value=\"$nom_user\"$selected>$nom_user</option>";
			}
			echo "</select>";
			echo "</tr>"
	."<tr>"
	."<td align=\"right\"  width=\"30%\"><b>Infructueux : </b></td>"
	."<td align=\"left\"  width=\"70%\"><b>";
			if ($marche_etatid==4){
				echo "<input type=radio checked name=\"marche_etat\" size=70 value=\"4\"></b></td>";
			} else {
				echo "<input type=radio name=\"marche_etat\" size=70 value=\"4\" ></b></td>";
			}
			echo "</tr>";
		}
		echo "<tr>"
	."<td colspan=2 align=\"center\" ><input type=submit value=\"Modifier\"></td>"
	."</tr>"
	."<tr>"
	."<td colspan=2 class=systemTabHeader align=\"center\">[<a href=\"system.php?op=marchepublic&onglet=encours\">Retour</a>]</td>"
	."</tr>"
	."</table>";

		include("system/footer_system.php");

	}

	/**
	 * Org_Visu()
	 *
	 *
	 */
	function Org_Visu($userid) {
		global $prefix, $db, $language, $multilingual;
		include("system/header_system.php");
		GraphicAdmin(_MARCHEADMIN);
		$result = $db->sql_query("select userid, user_soc, user_nom, user_prenom, user_adresse, user_tel, user_fax, password, level, email from ".$prefix."_marche_users where userid='$userid' order by user_soc ");
		list($userid, $user_soc, $user_nom, $user_prenom, $user_adresse, $user_tel, $user_fax, $password, $level, $email)=$db->sql_fetchrow($result);
		echo "<br><table border=\"0\" width=\"100%\" cellspacing=\"2\" bgcolor=\"#ece9d8\">"
			."<tr>";
		echo "<td colspan=2 align=\"center\" bgcolor=\"cccccc\" width=\"100%\"><b>Dtails sur le demandeur</b></td>"
			."</tr>"
			."<tr>"
	    	."<td align=\"right\" bgcolor=\"$bgcolor2\" width=\"30%\"><b>Login : </b></td>"
		."<td align=\"left\" bgcolor=\"$bgcolor2\" width=\"70%\"><b> $userid</b></td>"
		."</tr>"
			."<tr>"
	    	."<td align=\"right\" bgcolor=\"$bgcolor2\" width=\"30%\"><b>Socit : </b></td>"
		."<td align=\"left\" bgcolor=\"$bgcolor2\" width=\"70%\"><b> $user_soc</b></td>"
		."</tr>"
			."<tr>"
	    	."<td align=\"right\" bgcolor=\"$bgcolor2\" width=\"30%\"><b>Contact : </b></td>"
		."<td align=\"left\" bgcolor=\"$bgcolor2\" width=\"70%\"><b> $user_nom $user_prenom</b></td>"
		."</tr>"
			."<tr>"
	    	."<td align=\"right\" bgcolor=\"$bgcolor2\" width=\"30%\"><b>Adresse : </b></td>"
		."<td align=\"left\" bgcolor=\"$bgcolor2\" width=\"70%\"><b> $user_adresse</b></td>"
		."</tr>"
			."<tr>"
	    	."<td align=\"right\" bgcolor=\"$bgcolor2\" width=\"30%\"><b>Tlphone : </b></td>"
		."<td align=\"left\" bgcolor=\"$bgcolor2\" width=\"70%\"><b> $user_tel</b></td>"
		."</tr>"
			."<tr>"
	    	."<td align=\"right\" bgcolor=\"$bgcolor2\" width=\"30%\"><b>Fax : </b></td>"
		."<td align=\"left\" bgcolor=\"$bgcolor2\" width=\"70%\"><b> $user_fax</b></td>"
		."</tr>"
			."<tr>"
	    	."<td align=\"right\" bgcolor=\"$bgcolor2\" width=\"30%\"><b>Courriel : </b></td>"
		."<td align=\"left\" bgcolor=\"$bgcolor2\" width=\"70%\"><b> $email</b></td>"
		."</tr>"
			."<tr>"
			."<tr>"
			."<td colspan=2 bgcolor=\"cccccc\" align=center>[<a href=\"system.php?op=marchepublic&onglet=demandeur\">Retour</a>]</td>"
		  	."</tr>"
			."</table>";
		include("system/footer_system.php");

	}

	/**
	 * Org_Delete()
	 *
	 *
	 */
	function Org_Delete($userid, $ok=0){
		global $prefix, $db;
		if ($ok==1) {
			$db->sql_query("delete from ".$prefix."_marche_users where userid='$userid'");
			Header("Location: system.php?op=marchepublic&onglet=demandeur");
		}//ferme if
		else {
			include("system/header_system.php");
			GraphicAdmin(_MARCHEADMIN);
			OpenSysTable();
			echo "<center><font class=\"title\"><b>"._SUPPR_ORG_TXT."</b></font></center>";
			echo "<br>";
			echo "<center>[ <a href=\"system.php?op=marchepublic&onglet=demandeur\">"._NO."</a> | <a href=\"system.php?op=Org_Delete&userid=".$userid."&ok=1\">"._YES."</a> ]</center>";
			CloseSysTable();
			include("system/footer_system.php");
		}//ferme else
	}//ferme tout


	/**
	 * Procedure_Delete()
	 *
	 */
	function Procedure_Delete($procedureid, $ok=0){
		global $prefix, $db;
		if ($ok==1) {
			$db->sql_query("delete from ".$prefix."_marche_procedure where procedureid='$procedureid'");
			Header("Location: system.php?op=marchepublic&onglet=procedure");
		}//ferme if
		else {
			include("system/header_system.php");
			GraphicAdmin(_MARCHEADMIN);
			OpenSysTable();
			echo "<center><font class=\"title\"><b>"._SUPPR_PROCEDURE_TXT."</b></font></center>";
			echo "<br>";
			$result=$db->sql_query("select marcheid, marche_nom,marche_proc_id from ".$prefix."_marche where marche_proc_id='$procedureid'");
			if ($db->sql_numrows($result)>0){
				echo "<center><b>"._DELPROC_WARNING."</b><br><br>" ;
				while(list($marche_nom) = $db->sql_fetchrow($result)){
					echo "$marche_nom<br><br>";
					echo "[ <a href=\"system.php?op=marchepublic&onglet=procedure\">Retour</a>]</center>";
				}//ferme while
			}//ferme if
			else {
				echo "<center>[ <a href=\"system.php?op=marchepublic&onglet=procedure\">"._NO."</a> | <a href=\"system.php?op=Procedure_Delete&procedureid=".$procedureid."&ok=1\">"._YES."</a> ]</center>";
			}//ferme else
			CloseSysTable();
			include("system/footer_system.php");
		}//ferme else
	}//ferme tout

	/**
	 * PDF_Delete()
	 *
	 */
	function PDF_Delete2($lid,$url, $ok=0){
		global $prefix, $db;
		if ($ok==1) {
			unlink($url);
	    		$db->sql_query("delete from ".$prefix."_marche_downloads_downloads where lid='$lid'");
			Header("Location: system.php?op=marchepublic&onglet=encours");
		}//ferme if
		else {
			include("system/header_system.php");
			GraphicAdmin(_MARCHEADMIN);
			OpenSysTable();
			echo "<center><font class=\"title\"><b>"._SUPPR_PDF."</b></font></center>";
			echo "<br>";
			echo "<center>[ <a href=\"system.php?op=marchepublic&onglet=encours\">"._NO."</a> | <a href=\"system.php?op=PDF_Delete&lid=".$lid."&url=".urlencode($url)."&ok=1\">"._YES."</a> ]</center>";
			CloseSysTable();
			include("system/footer_system.php");
		}//ferme else
	}//ferme tout

	/**
	 * filesave()
	 * upload and save a file
	 * @param $ok if ok is 1 a file has been upload, and the file is copied to tmp folder
	 */
	function getUploadFile($ok=0, $test, $marcheid) {
		global $currentlang, $multilingual, $Default_Skin, $db,$prefix, $name ;


		$pdf_marcheid=$marcheid;
		$pdf_etatid=$test;

		include("core/conf/uploadconfig.php");
		$uploadFolderMarche = "catalog_repository/marche_public/";
		$skinPath="system/skins/$Default_Skin";
		$myheaderpage= "<html><head><meta name=vs_targetSchema content=\"HTML 4.0\">\n"
					."<LINK rel=\"stylesheet\" type=\"text/css\" href=\"includes/styles/dialog.css\">"
	     		//."<LINK rel=\"stylesheet\" type=\"text/css\" href=\"$skinPath/system.css\">\n"
				//."<LINK rel=\"stylesheet\" type=\"text/css\" href=\"$skinPath/dialog.css\">\n"
		."<title>UPLOAD</title>\n"
	 	 		."<SCRIPT language=\"JavaScript\" src=\"javascripts/insert.js\"></SCRIPT>\n"
		 		."</head>\n"
		 		."<body topmargin=\"0\" leftmargin=\"0\" style=\"border: 0; margin: 0;\" scroll=\"no\">\n";
		$myfooterpage="</body></html>\n";
		if ($ok==1){
			list($success,$response) = captureUpload($uploadFolderMarche,false,'uploadfile');
			if ($success) {
				 
				if ($response!=""){
					include("core/conf/uploadconfig.php");
					$copyfile = "$uploadFolderMarche/$response";
					$targetfile = "catalog_repository/marche_public/$response";
					if (rename($copyfile, $targetfile)) {
						$message="TRUE";
						$photo_file=$targetfile;
					}else{
						$message="FALSE";
						$photo_file="";
					}
				}
					
				$result=$db->sql_query("insert into ".$prefix."_marche_downloads_downloads values (NULL, '0', '0', '$response', '$targetfile', 'Marches', now(), '$name', '$email', '$hits','$submitter',0,0,0, '$filesize', '$version', '$homepage', '$pdf_marcheid', '$pdf_etatid')");
					
				echo $myheaderpage;
				echo "<table width=100% height=100% class=dlg border=0><tr><td>"
		            ."<center><font class=\"title\"><b>"._UPLOADADMIN."</b></font>"
		            ."<table class=dlg border=\"0\">";
				echo "<tr><td>"._MARCHE_UPLOAD_OK."</td></tr>";
				echo "<tr class=listTableNone><td align=center><input type=\"button\" onclick=\"opener.window.location.reload();self.close();return false\" value=\""._CLOSE_WINDOWS."\"></td></tr>";
				echo "</table>"
		            ."</form>"
		            ."</center>"
		            ."</td></tr></table>";
				echo $myfooterpage;
				
				/*echo "<table class=lisTable>";
				echo "<tr class=systemTabHeader><td>"._UPLOADADMIN."</td></tr>";
				echo "<tr class=listTableOdd><td>"._MESSAGE_UPLOAD_OK."</td></tr>";
				//echo "<input type=\"button\" onclick=\"javascript:updateImage('myphoto','$uploadFolder/tmp/$response');insertInFormField('update_photo_file','$response')\" value=\""._OK."\">";
				echo "<tr class=listTableNone><td align=center><input type=\"button\" onclick=\"opener.window.location.reload();self.close();return false\" value=\""._CLOSE_WINDOWS."\"></td></tr>";
				echo "</table>";
				echo $myfooterpage;*/
			} else {
				echo $myheaderpage;
				echo "<table width=100% height=100% class=dlg border=0><tr><td>"
		            ."<center><font class=\"title\"><b>"._UPLOADADMIN."</b></font>"
		            ."<table class=dlg border=\"0\">";
				echo "<tr><td>"._MARCHE_UPLOAD_ERROR."</td></tr>";
				echo "<tr><td><div align=right><input type=\"button\" onclick=\"javascript:window.close();\" value=\""._CANCEL."\"></div></td></tr>";
				echo "</table>"
		            ."</form>"
		            ."</center>"
		            ."</td></tr></table>";
				echo $myfooterpage;
				
				/*echo $myheaderpage;
				echo "<table class=lisTable>";
				echo "<tr class=systemTabHeader><td>"._UPLOADADMIN."</td></tr>";
				echo "<tr class=listTableOdd><td>"._MESSAGE_UPLOAD_ERROR."</td></tr>";
				echo "<tr class=listTableNone><td><div align=right><input type=\"button\" onclick=\"javascript:window.close();\" value=\""._CANCEL."\"></div></td></tr>";
				echo "</table>";
				echo $myfooterpage;*/
			}
			//echo "$myheaderpage<br>$success<br>"
			//."$response<br>"
			//."$uploadFolder<br>"
			//."$myfooterpage";
	   
		} else {
			$myform=$myheaderpage
			. "<table width=100% height=100% class=dlg border=0><tr><td>"
            ."<center><font class=\"title\"><b>"._UPLOADADMIN."</b></font>"
            ."<form action=\"system.php\" method=\"post\" ENCTYPE=\"multipart/form-data\">"
            ."<table class=dlg border=\"0\"><tr><td>"
            . "<INPUT TYPE=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".$uploadMaxSize."\">\n"
	         .""._FILENAME.":</td>\n"
	         ."<td><input type=\"file\" size=40 name=\"uploadfile\"></td></tr>\n"
	         ."<tr><td>\n"
	         ."<input type=\"hidden\" name=\"op\" value=\"getUploadFile\">\n"
	         ."<input type=\"hidden\" name=\"ok\" value=\"1\">\n"
	         ."<input type=\"hidden\" name=\"test\" value=\"$test\">\n"
			."<input type=\"hidden\" name=\"marcheid\" value=\"$marcheid\">\n"
			 ."<td class=listTableNone colspan=2 valign=center><input type=\"submit\" value=\"Upload\">\n"
	         ."<input type=\"button\" value=\"Cancel\" OnClick=\"javascript:window.close();\"></td></tr>\n"
		 	."</table>"
            ."</form>"
            ."</center>"
            ."</td></tr></table>"
		 	.$myfooterpage;
			
			
			
			/*echo "<table class=lisTable>"
	     ."<tr class=systemTabHeader><td colspan=2>"._UPLOADADMIN."</td></tr>"              
         ."<form action=\"system.php\" method=\"post\" ENCTYPE=\"multipart/form-data\">\n"
         ."<INPUT TYPE=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".$uploadMaxSize."\">\n"
         ."<tr class=listTableOdd><td>"._FILENAME.":</td>\n"
         ."<td><input type=\"file\" size=40 name=\"uploadfile\"></td></tr>\n"
         ."<tr><td><font class=\"content\">\n"
         ."<tr><td>\n"
         ."<input type=\"hidden\" name=\"op\" value=\"getUploadFile\">\n"
         ."<input type=\"hidden\" name=\"ok\" value=\"1\">\n"
         ."<input type=\"hidden\" name=\"test\" value=\"$test\">\n"
			."<input type=\"hidden\" name=\"marcheid\" value=\"$marcheid\">\n"
		 ."<td class=listTableNone colspan=2 valign=center><input type=\"submit\" value=\"Upload\">\n"
         ."<input type=\"button\" value=\"Cancel\" OnClick=\"javascript:window.close();\"></td></tr>\n"
		 ."</form>\n"
         ."</table>\n"
	     ."<br>\n"
	     .$myfooterpage;*/
		  
	  echo $myform;
		}
	}


	/*--------------------------------------*/
	/*           start Switch				*/
	/*--------------------------------------*/
	switch ($op) {
		case "marchepublic":
			marchepublic($onglet, $editid, $editForm);
			break;

		case "Upload_AAPC":
			Upload_AAPC($marcheid);
			break;

		case "Upload_AAPC_Save":
			Upload_AAPC_Save($pdf_nom,$pdf_type,$url,$pdf_marcheid);
			break;

		case "Marche_Mouve":
			Marche_Mouve($marcheid);
			break;

		case "Marche_Update":
			Marche_Update($marcheid,$marche_etatid,$marche_org_id,$marche_etat);
			break;

		case "Org_Visu":
			Org_Visu($userid);
			break;

		case "Org_Delete":
			Org_Delete($userid, $ok);
			break;

		case "PDF_Delete":
			PDF_Delete2($lid, $url,$ok);
			break;

		case "Procedure_Delete":
			Procedure_Delete($procedureid, $ok);
			break;

		case "Encours_Save":
			Encours_Save($marche_titre, $marche_deb, $marche_fin, $marche_heure, $marche_proc_id, $marche_etatid, $marche_num);
			break;

		case "Procedure_Save":
			Procedure_Save($procedure_nom, $procedure_abrev);
			break;

		case "Encours_Update":
			Encours_Update($marcheid, $marche_titre, $marche_deb, $marche_fin, $marche_heure, $marche_proc_id, $marche_etatid, $marche_num);
			break;

		case "Procedure_Update":
			Procedure_Update($procedureid,$procedure_nom,$procedure_abrev);
			break;

		case "Encours_Add":
			Encours_Add($marcheid);
			break;

		case "Procedure_Add":
			Procedure_Add($procedureid);
			break;

		case "getUploadFile":
			getUploadFile($ok, $test, $marcheid);
			break;

	}

}
else {
	display_denied();
}

?>