<?php

/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2001 by Francisco Burzi (fburzi@ncc.org.ve)            */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/*                                                                      */
/* Php-Quiz Module							*/
/* ===============							*/
/* NyQuist								*/
/* NyQuist@ntlworld.com							*/
/* NyQuist.port5.com							*/
/*									*/
/* Hacked under the rights of the GPL, improved and re-released.        */
/* Please send any comments, bugs and ideas to NyQuist@ntlworld.com     */
/* 			 						*/
/************************************************************************/

$module_name = "Quiz"; //Edit this if you change the module directory
$base_url = "modules.php?op=modload&name=$module_name&file=admin"; # base url for admin script
$release = "1.0";

require_once("mainfile.php");
if (!isset($prefix)) { $prefix= "nuke";}

if (!preg_match("#modules.php#i", $PHP_SELF)) {
    die ("You can't access this file directly...");
}

if (isset($newlang)) {
        include("modules/$module_name/language/lang-$newlang.php");
        $language = $newlang;
} elseif (isset($lang)) {
    include("modules/$module_name/language/lang-$lang.php");
    $language = $lang;
} else {
    include("modules/$module_name/language/lang-$language.php");
}


/*********************************************************/
/* Quiz Functions                                       */
/*********************************************************/

function QuizShow ($qid)
{
        global $db, $module_name, $user, $cookie, $prefix, $admin, $base_url, $bgcolor1, $bgcolor2, $offset;

        # check for  authorization
    $result = $db->sql_query("select quizID, quizTitle, comment, active, restrict_user, log_user, image, contrib, expire, displayscore, nbscore, conditions from $prefix"._quiz_admin." where quizID='$qid'");
    list($quizID, $quizTitle, $comment, $active, $restrict_user, $log_user, $image, $contrib, $expire, $displayscore, $nbscore, $conditions) = $db->sql_fetchrow($result);

        # check if quiz is active
        if ($active == 0 and !is_admin($admin))
        {
            OpenTable();
                print "<center><font class=catdesc>"._QUIZMUSTBEACTIVE."</font></center>";
            CloseTable();
                return;
        }

        # check if the quiz is restrict to registered user
        if ((($restrict_user == 1) and (!isset($user))) and !is_admin($admin))
        {
            OpenTable();
                print "<center><font class=catdesc>"._QUIZMUSTBEUSER."</font></center>";
            CloseTable();
                return;
        }


	# first check if it exists an expiration date (no xx)
	if (!preg_match("#xx#",$expire))
	{
preg_match ("#([0-9x]{4})-([0-9x]{1,2})-([0-9x]{1,2}) ([0-9x]{1,2}):([0-9x]{1,2}):([0-9x]{1,2})#", $expire, $date);

    $today = getdate();
    $day = $today[mday];
    if ($day < 10){ $day = "$day"; }
    $month = $today[mon];
    $year = $today[year];
    $hour = $today[hours];
    $min = $today[minutes];
    $sec = $today[seconds];

		# check for the day
	    if (($date[1] <= $year)
		AND ($date[2] <= $month)
		AND ($date[3] <= $day)
	    AND ($date[4] <= $hour)
		AND ($date[5] <= $min))
		{
			$expired = 1;
            OpenTable();
            echo "<font class=catdesc>$quizTitle: "._QUIZHASEXPIRED."<br></font>";
            CloseTable();
		}

		# show the score if needed
		if ($displayscore == 1 AND $expired == 1)
		{
				OpenTable();
				echo "<font class=catdesc>"._QUIZLISTSCORE."<br></font>";
				$result = $db->sql_query("SELECT username, score FROM $prefix"._quiz_check." WHERE qid='$qid' ORDER BY score DESC,time DESC LIMIT $nbscore ");
				while(list($username,$res) = $db->sql_fetchrow($result))
				{
						print "<font class=catdesc>$username : $res<br></font>";
				}
				CloseTable();

		# bye bye !! :)
		OpenTable();
		echo "<font class=catdesc>"._QUIZTHANKS."</font>";
		CloseTable();
		}
		if ($expired == 1)
		{
		return;
		}
	}
        # get the login infos  for the registered user
    if (is_user($user))
        {
        cookiedecode($user);
                $logname = $cookie[1];
            $result = $db->sql_query("select email from $prefix"._users." where uname='$logname'");
            list($adrs) = $db->sql_fetchrow($result);
    }

        # check if the user is logged (only one vote for the quiz)
        if (($restrict_user == 1) and ($log_user == 1))
        {
                # search in the database for a previous vote
            $result = $db->sql_query("SELECT username FROM $prefix"._quiz_check." WHERE (qid='$qid' AND username='$logname') OR (qid='$qid' AND email='$adrs')");
                if($db->sql_numrows($result) > 0)
                {
                    OpenTable();
                        print "<center><font class=catdesc>"._QUIZALREADYVOTED."</font></center>";
                    CloseTable();
                        return;
                }
        }

        if (!empty($image))
        {
            OpenTable();
            echo "<table width='100%' border=0><tr><td><center><font class=catdesc size=\"3\"><b>$quizTitle</b></font> $menu</center></td><td valign=middle rowspan=2><center><img src='modules/$module_name/images/$image' border=0 alt=''></center></td></font></tr>";
                print "<tr><td><font class=catdesc>$comment</font></td></tr></table>";
            CloseTable();
        }
        else
        {
            OpenTable();
            echo "<table width='100%' border=0><tr><td><font class=catdesc><center><font size=\"3\"><b>$quizTitle</b></font> $menu</center></td></tr>";
                print "<tr><td><font class=catdesc>$comment</font></td></font></tr></table>";
            CloseTable();
        }
            if (!empty($conditions)) {
            OpenTable();
                print "<table width='100%' border=0><tr><td><font class=catdesc>"._QUIZREADCONDITIONS."</font></td></font></tr></table>";
            CloseTable();
			}
                            echo "<br>";

        # print the quiz form
    print "<form action=\"modules.php\" method=\"post\">";
    print "<input type=\"hidden\" name=\"op\" value=\"modload\">";
    print "<input type=\"hidden\" name=\"name\" value=\"$module_name\">";
    print "<input type=\"hidden\" name=\"file\" value=\"index\">";
    print "<input type=\"hidden\" name=\"qid\" value=\"$qid\">";
    print "<input type=\"hidden\" name=\"do\" value=\"vote\">";
        if (isset($user))
        {
            print "<input type=\"hidden\" name=\"logname\" value=\"$logname\">";
            print "<input type=\"hidden\" name=\"adrs\" value=\"$adrs\">";
        }
        else
        {
            OpenTable();
                print "<table width='100%' border=0><tr><td>"._QUIZLOGNAME." : <input type='text' class=textbox name='logname'></td>";
                print "<td>"._QUIZEMAIL." : <input type='text' class=textbox name='adrs'></td></tr></table>";
            CloseTable();
        }
            echo "<br>";

        $num = 1;
                 //Next/Prev Page Code Start
    $limit = 10;
    if (empty($offset)) {
      $offset = 0;
      $page = 1;
    } else {
    $offset = $offset;
    $page = $page;
    }

    $result = $db->sql_query("select pollID, pollTitle, voters, comment, answer, image from $prefix"._quiz_desc." WHERE qid='$qid' limit $offset,$limit");

    $numrows = $db->sql_numrows($result);

    OpenTable();

    if ($offset != 0 || $page != 1) {
    $prevoffset = $offset - 10;
    echo "<a href=\"modules.php?op=modload&name=$module_name&file=index&qid=$qid&offset=$prevoffset\">"._PREVIOUS."</a> &nbsp;";
    }

    $pages = floor($totalRecords/$numrows);
    if ($totalRecords % $numrrows) {
    $pages++;
    }
    $counter = 0;

    for ($i = 1; $i <= $pages; $i++) {
    $newoffset = $numrows * ($i-1);
    if ($page != $i) {
    echo "<a href=\"modules.php?op=modload&name=$module_name&qid=$qid&offset=$newoffset\">$i</a> &nbsp;";
    }
    else {
    echo "$i &nbsp;";
    }
    $counter = $counter + 1;
    }

    if ($numrows < $offset) {
      echo ""._NEXT." &nbsp;";
    }
    else {

    $newoffset=$offset+$numrows;
          echo "<a href=\"modules.php?op=modload&name=$module_name&qid=$qid&offset=$newoffset\">"._NEXT."</a> &nbsp;";
    }
    CloseTable();

    echo "<br>";

    while(list($pollID, $pollTitle, $voters, $comment, $answer, $image) = $db->sql_fetchrow($result)) {
    OpenTable();
    		if (!empty($comment))
		{
            echo "<font class=catdesc size=\"2\"><b>$comment <br></b></font><br>";
		}

		if (!empty($image))
		{
        echo "<table width='100%' border=0><tr>"
		."<td><img src='modules/$module_name/images/$image' border=0 align='absmiddle'></td>"
		."<td><font class=catdesc size=\"2\"><b>"._QUIZQUESTIONTITLE." $num : $pollTitle</b></font></td>"
		."</tr></table>";
		}
		else
		{
//        echo "<font class=catdesc size=\"2\"><b>"._QUIZQUESTIONTITLE." $num : $pollTitle</b></font> ";
// Switch from numbered questions to actual question number: Looks better with paged views
          echo "<font class=catdesc size=\"2\"><b>"._QUIZQUESTIONTITLE." $pollID : $pollTitle</b></font> ";
		}

		print "<table border=0 width='100%'>";
                print "<input type=\"hidden\" name=\"pollID\" value=\"$pollID\">\n";

		# ordered answer needed ?
	    if (preg_match("#,#",$answer))
	    {
            $result1 = $db->sql_query("SELECT optionText, voteID FROM $prefix"._quiz_data." WHERE pollID='$pollID' ORDER BY voteID");
			# compute the list of answer for the combo box
            while(list($optionText,$voteID) = $db->sql_fetchrow($result1))
			{
				$array_text[$voteID] = $optionText;
			}

			for($i = 1; $i <= sizeof($array_text); $i++)
			{
				if (!empty($array_text[$i]))
				{
		    		echo "<tr><td>&nbsp;&nbsp;<input type=\"checkbox\" class=textbox name=\"voteQuiz[$pollID][]\" value=\"$i\" $sel> $array_text[$i]\n";
                              }
			}
		}
		else
		{
        $ok=0;
        for($i = 1; $i <= 10; $i++)
        {
            $result1 = $db->sql_query("SELECT optionText FROM $prefix"._quiz_data." WHERE (pollID='$pollID') AND (voteID='$i')");
            list($optionText) = $db->sql_fetchrow($result1);
            if($optionText != "")
            {
                print "<tr><td><font class=catdesc><input type=\"radio\" class=textbox name=\"voteQuiz[$pollID]\" value=\"$i\"> $optionText<br></font></td></tr>\n";
                $ok++;
			}
        } # end poll question
		}
        $num++;
		print "</table>";
        CloseTable();
            echo "<br>";
    } # end poll loop
    OpenTable();

    if ($offset != 0 || $page != 1) {
    $prevoffset = $offset - 10;
    echo "<a href=\"modules.php?op=modload&name=$module_name&file=index&qid=$qid&offset=$prevoffset\">"._PREVIOUS."</a> &nbsp;";
    }

    $pages = floor($totalRecords/$numrows);
    if ($totalRecords % $numrrows) {
    $pages++;
    }
    $counter = 0;

    for ($i = 1; $i <= $pages; $i++) {
    $newoffset = $numrows * ($i-1);
    if ($page != $i) {
    echo "<a href=\"modules.php?op=modload&name=$module_name&qid=$qid&offset=$newoffset\">$i</a> &nbsp;";
    }
    else {
    echo "$i &nbsp;";
    }
    $counter = $counter + 1;
    }

    if ($numrows < $offset) {
      echo ""._NEXT." &nbsp;";
    }
    else {

    $newoffset=$offset+$numrows;
          echo "<a href=\"modules.php?op=modload&name=$module_name&qid=$qid&offset=$newoffset\">"._NEXT."</a> &nbsp;";
    }
    CloseTable(); //Next/Prev Code end

    if ($numrows < $offset) { //Show submit button only on last page
    echo "<br>";
    OpenTable();
    print "<center><input type=\"submit\" class=button value='"._QUIZSUBMIT."'></center>";
    print "</form>\n\n";
    CloseTable();
    }
    else {
    }
}

/*********************************************************/
/* Quiz Functions                                       */
/*********************************************************/

function QuizVote ($qid,$voteQuiz,$voteText,$logname,$adrs)
{
        global $db, $user,$cookie,$adminmail,$module_name,$prefix,$base_url,$optionSort;

        # check if the mandatory infos aren't empty
        #print "logname = $logname email = $adrs<br>";
        if (empty($logname) or empty($adrs))
        {
            OpenTable();
                print "<center><font class=catdesc>"._QUIZMISSINGINFOS."</font></center>";
            CloseTable();
                return;
        }
        echo "$voteQuiz[$i]";
    $result = $db->sql_query("select quizTitle, nbscore, displayscore, displayresults, emailadmin, active, restrict_user, log_user, image, contrib, admemail from $prefix"._quiz_admin." where qid='$qid'");
    list($quizTitle, $nbscore, $displayscore,$displayresults , $emailadmin, $active, $restrict_user, $log_user, $image, $contrib,$admemail) = $db->sql_fetchrow($result);

        # check if quiz is active
        if ($active == 0)
        {
            OpenTable();
                print "<center><font class=catdesc>"._QUIZMUSTBEACTIVE."</font></center>";
            CloseTable();
                return;
        }
        # check if the quiz is restrict to registered user
        if (($restrict_user == 1) and (!is_user($user)))
        {
            OpenTable();
                print "<center><font class=catdesc>"._QUIZMUSTBEUSER."</font></center>";
            CloseTable();
                return;
        }

        # check if the user is logged (only one vote for the quiz)
        if ($log_user == 1)
        {
                # search in the database for a previous vote
            $result = $db->sql_query("SELECT username FROM $prefix"._quiz_check." WHERE (qid='$qid' AND username='$logname') OR (qid='$qid' AND email='$adrs')");
                list($username) = $db->sql_fetchrow($result);

                # already recorded ?
                if ($username == $logname or $email==$adrs)
                {
                    OpenTable();
                        print "<center><font class=catdesc>"._QUIZALREADYVOTED."</font></center>";
                    CloseTable();
                        return;
                }
        }
echo "<br>";
        # display a header if you have choose to show the score
        if ($displayscore == 1)
        {
                if (!empty($image))
                {
                    OpenTable();
                    echo "<table width='100%' border=0><tr><td><center><font class=catdesc size=\"3\"><b>"._QUIZRESULT." \"$quizTitle\"</b></font></center></td><td valign=middle rowspan=2><center><img src='modules/$module_name/images/$image' border=0 alt=''></center></td></font></tr>";
                        print "<tr><td><font class=catdesc>$comment</font></td></tr></table>";
                    CloseTable();
                }
                else
                {
                    OpenTable();
                    echo "<table width='100%'><tr><td><font class=catdesc><center><font size=\"3\"><b>"._QUIZRESULT." \"$quizTitle\"</b></font></center></td></tr>";
                        print "<tr><td><font class=catdesc>$comment</font></td></font></tr></table>";
                    CloseTable();
                }
        }
echo "<br>";
        # update nb voter for current quiz
    $db->sql_query("UPDATE $prefix"._quiz_admin." SET voters=voters+1 WHERE qid='$qid'");
    $result = $db->sql_query("SELECT pollID, pollTitle, voters, answer, coef, good, bad, comment, image FROM $prefix"._quiz_desc." WHERE qid='$qid'");
        $score = 0;
		$num = 1;
    while(list($pollID, $pollTitle, $voters,$answer,$coef,$good,$bad,$comment,$image) = $db->sql_fetchrow($result))
    {
		# check if ordered answer needed
	    if (preg_match("#,#",$answer))
	    {
		    $array_answer = explode(',',$answer);

		    if (strlen($voteQuiz[$pollID]) >= 2) {
                    $ordered_answer = implode(",",$voteQuiz[$pollID]);
                    $ordered_answer = preg_replace("/,--|--,|--/","",$ordered_answer);
                    }
			foreach (explode(',',$answer) as $val)
			{
        		$db->sql_query("UPDATE $prefix"._quiz_data." SET optionCount=optionCount+1 WHERE (pollID='$pollID') AND (voteID='$val')");
			}
        	# update nb result for current answer (stat purpose)
	    }
		else
		{
		$ordered_answer =  "";

        # update nb result for current answer (stat purpose)
        $db->sql_query("UPDATE $prefix"._quiz_data." SET optionCount=optionCount+1 WHERE (pollID='$pollID') AND (voteID='$voteQuiz[$pollID]')");
		}

        # update nb result for current question (stat purpose)
        $db->sql_query("UPDATE $prefix"._quiz_desc." SET voters=voters+1 WHERE pollID='$pollID'");

        # display results ?
        if ($displayresults == 1)
        {
			# check if ordered answers to display results
			if (!empty($ordered_answer))
			{

            $result1 = $db->sql_query("SELECT optionText, voteID FROM $prefix"._quiz_data." WHERE pollID='$pollID' ORDER BY voteID");
			# compute the list of answer for the combo box
            while(list($optionText,$voteID) = $db->sql_fetchrow($result1))
			{
				$array_text[$voteID] = $optionText;
			}

			# sort of the user answer
			$optionText = "";
			foreach ($voteQuiz[$pollID] as $val)
			{
				$optionText .= "$array_text[$val] ";
			}
			$answerText = "";
			foreach (explode(',',$answer) as $val)
			{
				$answerText .= "$array_text[$val] ";
			}

			}
			else
			{
                $result1 = $db->sql_query("SELECT optionText FROM $prefix"._quiz_data." WHERE (pollID='$pollID') AND (voteID='$voteQuiz[$pollID]')");
                 list($optionText) = $db->sql_fetchrow($result1);
                 $result1 = $db->sql_query("SELECT optionText FROM $prefix"._quiz_data." WHERE (pollID='$pollID') AND (voteID='$answer')");
                 list($answerText) = $db->sql_fetchrow($result1);
			 }

             OpenTable();
             print "<font class=catdesc>$num - "._QUIZFORTHEQUESTION." \"$pollTitle\" </font><br>";
             print "<font class=catdesc>"._QUIZYOUHAVECHOOSE." \"$optionText\" "._QUIZCORRECTANSWER." \"$answerText\" </font>";

             $report .= "$num - "._QUIZFORTHEQUESTION." \"$pollTitle\", ";
             $report .= ""._QUIZYOUHAVECHOOSE." \"$optionText\" "._QUIZCORRECTANSWER." \"$answerText\" \n";

			if ((empty($ordered_answer) and $voteQuiz[$pollID] == $answer) or
				(!empty($ordered_answer) and $ordered_answer == $answer))
             {
                 if (!empty($good)) { print "<br><br><font class=catdesc>"._EXPLANATION.": $good</font>"; }
             }
             else
             {
                 if (!empty ($bad)) {print "<br><br><font class=catdesc>"._EXPLANATION.": $bad</font>"; }
             }
             CloseTable();
        }
echo "<br>";
        # check for the correct answer ?
		if ((empty($ordered_answer) and $voteQuiz[$pollID] == $answer) or
			(!empty($ordered_answer) and $ordered_answer == $answer))
        {
           $score= $score + $coef;
        }

		if (empty($ordered_answer))
		{
		    $answers .= "$voteQuiz[$pollID]|";
		}
		else
		{
		    $answers .= "$ordered_answer|";
		}

		$num++;
    }

    # display the final score ?
    if ($displayscore == 1)
    {
        OpenTable();
            echo "<font class=catdesc>"._QUIZYOURSCORE." : $score</font>";
            echo "<br>";
        }
echo "<br>";
        # store the available infos if needed
        $ctime = time();
        if(!$db->sql_query("INSERT INTO $prefix"._quiz_check." VALUES (NULL,'$ctime','$logname','$adrs','$qid','$score','$answers')"))
        {
        	print_r($db->sql_error());
                echo "<br>";
                return;
        }

        # show the score if needed
        if ($displayscore == 1)
        {

            echo "<font class=catdesc>"._QUIZLISTSCORE."<br></font>";
            $result = $db->sql_query("SELECT username, score FROM $prefix"._quiz_check." WHERE (qid='$qid') AND (username='$logname') ORDER BY score DESC,time DESC LIMIT 5");
                while(list($username,$res) = $db->sql_fetchrow($result))
                {
                        print "<font class=catdesc>$username : $res<br></font>";
                }
            CloseTable();
        }
echo "<br>";


    # send an email if needed
    if ($emailadmin)
    {
		if (empty($admemail)) { $admemail = $adminmail; }
        $subject = "$logname "._QUIZYOUHASVOTED." $quizTitle";
        $message = "$logname "._QUIZYOUHASVOTED." $quizTitle\n";
        $message .= _QUIZLOGNAME." : $logname\n";
        $message .= _QUIZEMAIL." : $adrs\n";
        $message .= _QUIZSCORE." : $score ($answers)\n";
        $message .= "$report\n";


        nuke_mail($admemail, $subject, $message, "From: $from\nX-Mailer: PHP/" . phpversion());
    }
}

/*********************************************************/
/* Quiz Functions                                       */
/*********************************************************/

function QuizList ()
{
        global $db, $module_name,$cid,$prefix,$admin,$user,$base_url,$cookie;

    OpenTable();
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZLIST."</b></font></center>";
    CloseTable();
    echo "<br>";

        if(!isset($cid))
        {

            OpenTable();
            print "<table width='100%'>";
            $result = $db->sql_query("select cid, name, comment, image from $prefix"._quiz_categories."");
            while(list($cid, $name,$comment,$image) = $db->sql_fetchrow($result))
                {

					# compute the number of Quiz by Category
            		$res = $db->sql_query("select COUNT(*) from $prefix"._quiz_admin." where cid='$cid'");
					list($nb) = $db->sql_fetchrow($res);

                        print "<tr><td>";
                    print "<font class=catdesc>";
					if ($nb > 0)
					{
                        print "<a href=\"modules.php?op=modload&name=$module_name&file=index&cid=$cid\">  $name </a>";
					}
					else
					{
                        print " $name ";
					}
                        if (!empty($comment)) { print " : $comment"; }
						print "&nbsp;&nbsp; ($nb "._QUIZ.") ";
                        print "</font>\n";
						# print the admin menu if needed

                        if (!empty($image))
                        {
                                print "</td><td><img src='modules/$module_name/images/$image' border=0 alt='$comment'>";
                        }
                        print "</td></tr>";
                }
                print "</table>";
            CloseTable();
        }
        else
        {

            OpenTable();
            print "<table width='100%' border=0>";
			cookiedecode($user);

            $result = $db->sql_query("select quizID, quizTitle, active, restrict_user, administrator,displayscore,nbscore from $prefix"._quiz_admin." where cid='$cid' order by timeStamp desc");
            while(list($qid, $quizTitle,$active,$restrict_user,$administrator,$displayscore,$nbscore) = $db->sql_fetchrow($result))
            {
				# display the inactive quiz if admin
				if (is_admin($admin)  or ($administrator != "" and $cookie[1] == $administrator))
				{


                    print "<tr><td>";
                    print "<font class=catdesc>";
                    print "<a href=\"modules.php?op=modload&name=$module_name&file=index&qid=$qid\">  $quizTitle </a> <img src='modules/$module_name/images/$img' alt='$alt'>";
					# compute the number of Question in the Quiz
            		$res = $db->sql_query("select COUNT(*) from $prefix"._quiz_desc." where qid='$qid'");
					list($nb) = $db->sql_fetchrow($res);
                    print "&nbsp;&nbsp; ($nb "._QUIZQUESTIONSNB.")</font>\n";

                    print "</td></tr>";
				}
				else if ($active == 1)
				{
                    print "<tr><td>";
                    print "<font class=catdesc>";
					if ($restrict_user == 1 and !is_user($user))
					{
					$rimg = "<img src='modules/$module_name/images/red_dot.gif' alt='"._QUIZONLYREGISTERED."'>";
                    print "$quizTitle $rimg";
					}
					else
					{
                    print "<a href=\"modules.php?op=modload&name=$module_name&file=index&qid=$qid\">  $quizTitle </a>";
					}
					# compute the number of Question in the Quiz
            		$res = $db->sql_query("select COUNT(*) from $prefix"._quiz_desc." where qid='$qid'");
					list($nb) = $db->sql_fetchrow($res);
                    print " ($nb "._QUIZQUESTIONSNB.")</font>\n";

						if ($displayscore)
						{
			    		$ress = $db->sql_query("SELECT username, score FROM $prefix"._quiz_check." WHERE qid='$qid' ORDER BY score DESC,time DESC LIMIT $nbscore ");
						print "<br><br>";
						if ($db->sql_numrows($ress)>0)
						{
						echo "<font class=catdesc>"._QUIZLISTSCORE.":<br></font>";
				    	while(list($username,$res) = $db->sql_fetchrow($ress))
						{
						print "<font class=catdesc>$username : $res<br></font>";
						}
						print "<br>";
						}
						}


                    print "</td></tr>";
				}
            }
            print "</table>";
            CloseTable();
        }
}

/*********************************************************/
/* Mail  Function                                        */
/* Can be customized to meet isp requirement...          */
/*********************************************************/

function nuke_mail($from, $subject, $message, $option)
{
        global $db, $HTTP_HOST;

    if ($HTTP_HOST == "localhost")
    {
            print "mail(<br>$from,<br> $subject,<br> $message,<br> $option<br>)<br>";
    }
    else
    {
        #include("mail.inc");
        mail($from, $subject, $message, $option);
    }
}

/*********************************************************/
/* Quiz Functions                                       */
/*********************************************************/

function ViewConditions ($qid)
{
      global $db, $prefix;
        $result = $db->sql_query("select quizTitle, conditions  from $prefix"._quiz_admin." where qid='$qid'");
        list($quizTitle,$conditions) = $db->sql_fetchrow($result);
	OpenTable();
                echo "<table width='100%' border=0><tr><td><font class=catdesc><center><font size=\"3\"><b>$quizTitle</b></font><br><br><b>"._QUIZCONDITIONS.":<br><br></center></b></td></tr>";
      	        print "<tr><td><font class=catdesc>$conditions</font><br><center>"._GOBACK."</center></td></font></tr></table>";
	CloseTable();
}
/*********************************************************/

    include ('header.php');

if(!isset($qid))
{
  QuizList();
}
else
{

        switch($do)
        {
        case "vote":
              quizVote($qid,$voteQuiz,$voteText,$logname,$adrs);
              break;
        case "viewConditions":
                      ViewConditions($qid);
                      break;
        default:
              QuizShow($qid);
              break;
        }
}
 include ('footer.php');

?>
