	//<![CDATA[
	
	//Decode points
	function decodeLine(encoded) {
		var len = encoded.length;
		var index = 0;
		var array = [];
		var lat = 0;
		var lng = 0;
		try
		{
			while (index < len) {
				var b;
				var shift = 0;
				var result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lat += dlat;
	
				shift = 0;
				result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lng += dlng;
	
				array.push(new GLatLng((lat * 1e-5), (lng * 1e-5)));
			}
		} catch(ex)
		{
			//error in encoding.
		}
		return array;
	}
	
	function theMapType(letype) {
		var type_carte = G_HYBRID_MAP;
		if (letype == "P") {
			type_carte = G_NORMAL_MAP;
		}
		if (letype == "S") {
			type_carte = G_SATELLITE_MAP;
		}
		if (letype == "R") {
			type_carte = G_PHYSICAL_MAP;
		}
		if (letype == "3D") {
			type_carte = G_SATELLITE_3D_MAP;
		}
		return type_carte;
	}
	
	function is3D(letype) {
		if (letype == G_SATELLITE_3D_MAP) {
			return true;
		}
		else {
			return false;
		}
	}
	
	function test3D(letype) {
		if (is3D(letype)) {
			type3D = true;
		}
		return type3D
	}
	
	function GetMap(id,idadh) {
		if (map != null) {
			return true;
		}
		if (GBrowserIsCompatible()) {
			if (cartes == null) {
		 		cartes = GetXMLSymbols(id,idadh);
		 	}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");
			var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
			var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
			options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
			options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
			options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
			options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
			options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
			options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
			options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
			options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
			options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
			options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
			options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
			options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
			taille_hv = getXMLvalue(racine_carte,"option_taille");
			/*if (tailleforcee) {
				taille_hv = tailleforcee;
			}*/
			var sep_taille=new RegExp("[/]+", "g");
			var map_hv = String(taille_hv).split(sep_taille);
			options["map_h"] = String(map_hv[0]) + "px";
			options["map_v"] = String(map_hv[1]) + "px";
			options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
			options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
			
			leDiv = document.getElementById("map");
			if (leDiv == null) {
				return false;
			}
			/*var reg_taille=new RegExp("([0-9]+)([/]+)([0-9])+", "g");
			if (String(taille_hv).match(reg_taille)) {
				leDiv.style.width = options["map_h"];
				leDiv.style.height = options["map_v"];
			}
			*/
			//map = new GMap2(leDiv,{mapTypes: [G_SATELLITE_MAP,G_HYBRID_MAP,G_NORMAL_MAP,G_PHYSICAL_MAP,G_SATELLITE_3D_MAP]});
			map = new GMap2(leDiv,{mapTypes: [G_NORMAL_MAP,G_HYBRID_MAP]});
			//map = new GMap2(leDiv,{mapTypes: options["btnstypes"]});
			//restriction des niveaux de zoom
			if ((! isNaN(options["zoom_min"] + options["zoom_max"]))) {
				var mt = map.getMapTypes();
				for (var i=0; i<mt.length; i++) {
					if (options["zoom_min"] != "") {
						mt[i].getMinimumResolution = function() {
							return options["zoom_min"]; 
						};
					}
					if (options["zoom_max"] != "") {
						mt[i].getMaximumResolution = function() {
							return options["zoom_max"];
						};
					}
				}
				//puisque G_PHYSICAL_MAP n''est pas retourn par getMapTypes()
				if (options["zoom_min"] != "") {
					G_PHYSICAL_MAP.getMinimumResolution = function() {
						return options["zoom_min"]; 
					};
				}
				if (options["zoom_max"] != "") {
					G_PHYSICAL_MAP.getMaximumResolution = function() {
						return options["zoom_max"];
					};
				}
			}
			
			if (options["controles"]) {
				//map.addControl(new GSmallMapControl());mini controle de zoom et de navigation
				map.addControl(new GMapTypeControl());
				//map.addControl(new GLargeMapControl());
				//map.addControl(new GScaleControl()) ;
				//map.addControl(new GOverviewMapControl()) ;
			}
			
			var type_carte = theMapType(options["type_map"]);
			if (options["centermap"].lat() != 0 || options["centermap"].lng() != 0) {
				//map.setCenter(options["centermap"], options["zoominit"], type_carte);//au cas o on ait des zooms diffrents par fiche
				map.setCenter(options["centermap"], zoominit, type_carte);
			}
			else {
				map.setCenter(new GLatLng(latitudeinit, longitudeinit), zoominit, type_carte);
			}
			//ajout boutons zoom
			function ZoomPlusControl() { }
			ZoomPlusControl.prototype = new GControl();
			ZoomPlusControl.prototype.initialize = function(map) {
				var container = document.createElement("div");
			
				var printDiv = document.createElement("div");
				this.setButtonStyle_(printDiv);
				container.appendChild(printDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoomplus.png";
				image.title = "Imprimer carte";
				printDiv.appendChild(image);
				GEvent.addDomListener(printDiv, "click", function() {
			   		//alert(map.getZoom());
			   		map.zoomIn(null,false,true);
				});
			
				map.getContainer().appendChild(container);
				return container;
			};
			ZoomPlusControl.prototype.getDefaultPosition = function() {
			  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(10, 10));
			};		
			// Sets the proper CSS for the given button element.
			ZoomPlusControl.prototype.setButtonStyle_ = function(button) {
			  /*button.style.textDecoration = "none";
			  button.style.lineHeight = "12px";
			  button.style.color = "#0000cc";
			  button.style.backgroundColor = "white";
			  button.style.border = "1px solid black";
			  button.style.padding = "0px";
			  button.style.marginBottom = "3px";
			  button.style.textAlign = "center";*/
			  button.style.cursor = "pointer";
			};
			map.addControl(new ZoomPlusControl());
			
			function ZoomMoinsControl() { }
			ZoomMoinsControl.prototype = new GControl();
			ZoomMoinsControl.prototype.initialize = function(map) {
				var container = document.createElement("div");
			
				var printDiv = document.createElement("div");
				this.setButtonStyle_(printDiv);
				container.appendChild(printDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoommoins.png";
				image.title = "Imprimer carte";
				printDiv.appendChild(image);
				GEvent.addDomListener(printDiv, "click", function() {
			   		//alert(map.getZoom());
			   		map.zoomOut(null,false,true);
				});
			
				map.getContainer().appendChild(container);
				return container;
			};
			ZoomMoinsControl.prototype.getDefaultPosition = function() {
			  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(60, 10));
			};		
			// Sets the proper CSS for the given button element.
			ZoomMoinsControl.prototype.setButtonStyle_ = function(button) {
			  /*button.style.textDecoration = "none";
			  button.style.lineHeight = "12px";
			  button.style.color = "#0000cc";
			  button.style.backgroundColor = "white";
			  button.style.border = "1px solid black";
			  button.style.padding = "0px";
			  button.style.marginBottom = "3px";
			  button.style.textAlign = "center";*/
			  button.style.cursor = "pointer";
			};
			map.addControl(new ZoomMoinsControl());
			//fin boutons zoom
			//ajout de pictos
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var echelle = map.getZoom();
	
				var icone = new GIcon();
				//icone.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
				//icone.image = "http://asso.acmo.free.fr/membres/cible.png";
				//icone.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
				//icone.shadow = null;
				icone.image = chemicone;
				
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				largeur = taille;
				hauteur = taille;
				
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
				//icone.shadowSize = new GSize(22, 20);
				
				icone.infoWindowAnchor = new GPoint(Math.ceil(largeur/2),Math.ceil(hauteur/2));
				//icone.imageMap = [0,0,13,0,13,13,0,13];
				
				var marker = new GMarker(point, icone);
				
				if (options["bulle"] != "") {
					//var saut =new RegExp(String.fromCharCode(13), "g");
					var saut =new RegExp("(\n|\r)", "g");
					commentaire = commentaire.replace(saut,"<br />");
					
					GEvent.addListener(marker, "click", function() {
						var cont_mess = "";
						if (fiche != "") {
							if (message != "") {
								var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
							}
						}
						else {
							if (message != "") {
								var link_mess = "";
							}
						}
						cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
						if (options["bulle"] == "T") {
							marker.openInfoWindowHtml(cont_mess,{ maxWidth:230 });
						}
						if (options["bulle"] == "C") {
							marker.openInfoWindowHtml('<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>',{ maxWidth:230 });
							
							var dMapDiv = document.getElementById("detailmap");
							var detailmap = new GMap2(dMapDiv);
							detailmap.addControl(new GSmallZoomControl());
							detailmap.addControl(new GScaleControl());
							var leZoom = map.getZoom()+2;
							var LeZoomMax = map.getCurrentMapType().getMaximumResolution(point);
							if (map.getZoom(leZoom)+2 > LeZoomMax) {
								leZoom = LeZoomMax;
							};
							detailmap.setCenter(point , leZoom, map.getCurrentMapType());
							
							var CopyrightDiv = dMapDiv.firstChild.nextSibling;
							var CopyrightImg = dMapDiv.firstChild.nextSibling.nextSibling;
							CopyrightDiv.style.display = "none"; 
							CopyrightImg.style.display = "none";
							
							var marker_detail= new GMarker(point, icone);
							detailmap.addOverlay(marker_detail);
						}
						if (options["bulle"] == "TC") {
							if (cont_mess !="") {
								var tab1 = new GInfoWindowTab("Info", cont_mess);
								var tab2 = new GInfoWindowTab("Carte", '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>');
								var infoTabs = [tab1,tab2];
							}
							else {
								var tab2 = new GInfoWindowTab("Carte", '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13;"></div>');
								var infoTabs = [tab2];
							}
							marker.openInfoWindowTabsHtml(infoTabs,{ maxWidth:230 });
							if (detailmap != null) {
								detailmap = null;
								dMapDiv = null;
							}
							var dMapDiv = document.getElementById("detailmap");
							var detailmap = new GMap2(dMapDiv);
							detailmap.addControl(new GSmallZoomControl());
							detailmap.addControl(new GScaleControl());
							var leZoom = map.getZoom()+2;
							var LeZoomMax = map.getCurrentMapType().getMaximumResolution(point);
							if (map.getZoom(leZoom)+2 > LeZoomMax) {
								leZoom = LeZoomMax;
							};
							detailmap.setCenter(point , leZoom, map.getCurrentMapType());
							
							var CopyrightDiv = dMapDiv.firstChild.nextSibling;
							var CopyrightImg = CopyrightDiv.nextSibling;
							CopyrightDiv.style.display = "none"; 
							CopyrightImg.style.display = "none";
							
							var marker_detail= new GMarker(point, icone);
							detailmap.addOverlay(marker_detail);
						}
					});
				}
				return marker;
			}
			
			//ajout de textes 
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {		
				if (test3D(map.getCurrentMapType())) {
					return null;
				}
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getCurrentMapType() == G_NORMAL_MAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				var icone = new GIcon();
				icone.image = racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte;
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
					
				if (fiche == "") {
					var marker = new GMarker(point, icone, {clickable: false, draggable: false});
				}
				else {	
					var marker = new GMarker(point, icone);
					GEvent.addListener(marker, "click", function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			//affiche les textes
			function afficheTextes() {
				var textes = getXMLchild(racine_carte,"textes");
				if (textes != null) {
					var texte_courant = getXMLchild(textes,"texte");
					while (texte_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(texte_courant,"latitude_texte")), eval(getXMLvalue(texte_courant,"longitude_texte")));
						var fiche = getXMLvalue(texte_courant,"lien_texte");
						var target = getXMLvalue(texte_courant,"cible_texte");
						var message = getXMLvalue(texte_courant,"lieu_texte");
						var commentaire = getXMLvalue(texte_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(texte_courant,"dim_texte");
						var angletxt = getXMLvalue(texte_courant,"angle_texte");
						var couleurtxt = getXMLvalue(texte_courant,"couleur_texte");
						var typotxt = getXMLvalue(texte_courant,"police_texte");
						var tailletxt = getXMLvalue(texte_courant,"taille_texte");
						var tempMark = createTextMarker(point2,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						texte_courant = next_sibling(texte_courant);
					}
				}
			}
			
			//affiche les pictos
			function afficheLieux() {
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point2,message,commentaire,chemicone,fiche,target);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
				function afficherCBordure() {
					var bordure = new GPolyline.fromEncoded({
						color: getXMLvalue(racine_carte,"points_couleur"),
						weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
						opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
						points: getXMLvalue(racine_carte,"points_bordure"),
						levels: getXMLvalue(racine_carte,"points_visibilite"),
						numLevels: 3,
						zoomFactor: 12
					});
				map.addOverlay(bordure);
			}
			
			//crer polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				if (plein == "1") {
					var polygone = new GPolygon(decodeLine(points), couleur, epaisseur, 1, couleur, opacite);
				}
				else {
					var polygone = new GPolyline.fromEncoded({
						color: couleur,
						weight: epaisseur,
						opacity : opacite,
						points: points,
						levels: visibilite,
						numLevels: 3,
						zoomFactor: 12
					});
				}
				if (fiche != "" && plein == "1") {
					GEvent.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return polygone;
			}
			//afficher polygones
			function afficherPolygones() {
				var polygones = getXMLchild(racine_carte,"polygones");
				if (polygones != null) {
					var polygone_courant = getXMLchild(polygones,"polygone");
					while (polygone_courant) {
						var couleur = getXMLvalue(polygone_courant,"couleur");
						var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
						var points = getXMLvalue(polygone_courant,"polyencode");
						var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
						var fiche = getXMLvalue(polygone_courant,"lien_polygone");
						var target = getXMLvalue(polygone_courant,"cible_polygone");
						var plein = getXMLvalue(polygone_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							map.addOverlay(tempZone);
						}
						polygone_courant = next_sibling(polygone_courant);
					}
				}
			}
			//ajout de pictos
			function createMarkerSymb(point, chemicone) {
				/*var icone = new GIcon();
				//icone.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
				//icone.image = "http://asso.acmo.free.fr/membres/cible.png";
				//icone.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
				//icone.shadow = null;
				icone.image = chemicone;
				
				largeur = 15;
				hauteur = 30;
				
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
				//icone.shadowSize = new GSize(22, 20);
				
				//icone.infoWindowAnchor = new GPoint(Math.ceil(largeur/2),Math.ceil(hauteur/2));
				//icone.imageMap = [0,0,13,0,13,13,0,13];*/
				var icone = new GIcon();
				//icone.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
		        //icone.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
		        icone.image = chemicone;
		        icone.iconSize = new GSize(26,26);
		        icone.iconAnchor = new GPoint(13, 13);
		        //icone.shadowSize = new GSize(22, 20);
		        //icone.iconAnchor = new GPoint(6, 20);
				
				var marker = new GMarker(point, icone);
				/*GEvent.addListener(marker, "click", function() {
						ouvre_dialogue("Toutes les localisations", "modules.php?name=SimpleTypology&sop=view_carto&id="+idadh);
				});*/
				return marker;
			}
			
			//afficher les symboles
			function afficherSymboles() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"symboles");
				if (points != null) {
					var point_courant = getXMLchild(points,"symbole");
					while (point_courant) {
						var lat = getXMLvalue(point_courant,"latitude_symb");
						var lon = getXMLvalue(point_courant,"longitude_symb");
						if (lat != "" && lon!= "" && eval(lat) <= 360 && eval(lon) < 90) {
							var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
							var chemicone = getXMLvalue(point_courant,"picto_symb");
							var tempMark = createMarkerSymb(point2,chemicone);
							if (tempMark != null) {
								map.addOverlay(tempMark);
							}
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//action sur la carte
			GEvent.addListener(map, "click", function(marker, point) {
				if (marker == null) {
					map.panTo(point);
				}
			});
			
			GEvent.addListener(map, "zoomend", function() {
				map.clearOverlays();
				if (options["polygones"]) {
					afficherPolygones();
				}
				if (options["bordure"]) {
					afficherCBordure();
				}
				if (options["lieux"]) {
					afficheTextes();
					afficheLieux();
				}
				afficherSymboles();
			});
			
			GEvent.addListener(map, "maptypechanged", function() {
				map.clearOverlays();
				if (options["polygones"]) {
					afficherPolygones();
				}
				if (options["bordure"]) {
					afficherCBordure();
				}
				if (options["lieux"]) {
					afficheTextes();
					afficheLieux();
				}
				afficherSymboles();
				synchro_minimap();
			});
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficherSymboles();
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre  jour.");
		}
	}

	
	function GetXMLSymbols(id,idadh) {
		var sortie = "";
		var params = "";
		if (id != "") {
			params += "&Idc="+id;
		}
		if (idadh != "") {
			params += "&id="+idadh;
		}
		var sources_cartes = "modules.php?name=SimpleAdherents&op=map_adh_XML"+params;
		var cartes = GetAJAXData(sources_cartes);
		return cartes;
	}
	
	function calculeX(r){
	  return calculeOffset(r,"offsetLeft");
	}
	
	function calculeH(r){
	  return r["offsetHeight"];
	}
	
	function calculeL(r){
	  return r["offsetWidth"];
	}
	
	function calculeY(r){
	  return calculeOffset(r,"offsetTop")
	}
	function calculeOffset(element,attr){
	  var offset=0;
	  while(element){
	    offset+=element[attr];
	    element=element.offsetParent;
	  }
	  return offset;
	}
	
	var map = null;
	var minimap = null;
	var cartes = null;
	var latitudeinit = 0;
	var longitudeinit = 0;
	var type3D = false;
	//]]>