	//<![CDATA[
	
	//Decode points
	function decodeLine(encoded) {
		var len = encoded.length;
		var index = 0;
		var array = [];
		var lat = 0;
		var lng = 0;
		try
		{
			while (index < len) {
				var b;
				var shift = 0;
				var result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lat += dlat;
	
				shift = 0;
				result = 0;
				do {
					  b = encoded.charCodeAt(index++) - 63;
					  result |= (b & 0x1f) << shift;
					  shift += 5;
				} while (b >= 0x20);
				var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
				lng += dlng;
	
				array.push(new GLatLng((lat * 1e-5), (lng * 1e-5)));
			}
		} catch(ex)
		{
			//error in encoding.
		}
		return array;
	}
	
	function theMapType(letype) {
		var type_carte = G_HYBRID_MAP;
		if (letype == "P") {
			type_carte = G_NORMAL_MAP;
		}
		if (letype == "S") {
			type_carte = G_SATELLITE_MAP;
		}
		if (letype == "R") {
			type_carte = G_PHYSICAL_MAP;
		}
		if (letype == "3D") {
			type_carte = G_SATELLITE_3D_MAP;
		}
		return type_carte;
	}
	
	function is3D(letype) {
		if (letype == G_SATELLITE_3D_MAP) {
			return true;
		}
		else {
			return false;
		}
	}
	
	function test3D(letype) {
		if (is3D(letype)) {
			type3D = true;
		}
		return type3D
	}
	
	function GetMap(id,idmetacat,idcat,village) {
		var latitudeinitauto = 0;
		var longitudeinitauto = 0;
		if (GBrowserIsCompatible()) {
			if (cartes == null) {
		 		cartes = GetXMLSymbols(id, idmetacat, idcat,village);
		 	}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");
			var zoomclic = eval(getXMLvalue(racine_carte,"zoomclic"));
			var zoominit = eval(getXMLvalue(racine_carte,"zoominit"));
			latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinit"));
			longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinit"));
			options["print"] = eval(getXMLvalue(racine_carte,"option_print") == "1");
			options["bulle"] = getXMLvalue(racine_carte,"option_bulles");
			options["bordure"] = eval(getXMLvalue(racine_carte,"option_bordure") == "1");
			options["polygones"] = eval(getXMLvalue(racine_carte,"option_polygones") == "1");
			options["lieux"] = eval(getXMLvalue(racine_carte,"option_pictos") == "1");
			options["obs"] = eval(getXMLvalue(racine_carte,"option_legende") == "1");
			options["type_map"] = getXMLvalue(racine_carte,"option_type_map");
			options["mini_vue"] = eval(getXMLvalue(racine_carte,"option_mini_map") == "1");
			options["titre"] = eval(getXMLvalue(racine_carte,"option_titre") == "1");
			options["commentaire"] = eval(getXMLvalue(racine_carte,"option_commentaire") == "1");
			options["seuil_texte"] = eval(getXMLvalue(racine_carte,"option_seuil_texte"));
			options["controles"] = eval(getXMLvalue(racine_carte,"option_controles") == "1");
			taille_hv = getXMLvalue(racine_carte,"option_taille");
			/*if (tailleforcee) {
				taille_hv = tailleforcee;
			}*/
			var sep_taille=new RegExp("[/]+", "g");
			var map_hv = String(taille_hv).split(sep_taille);
			options["map_h"] = String(map_hv[0]) + "px";
			options["map_v"] = String(map_hv[1]) + "px";
			options["zoom_min"] = eval(getXMLvalue(racine_carte,"option_zoom_min"));
			options["zoom_max"] = eval(getXMLvalue(racine_carte,"option_zoom_max"));
			if (eval(getXMLvalue(racine_carte,"latitudeinitadhs")) != 0 && eval(getXMLvalue(racine_carte,"longitudeinitadhs")) != 0) {
				latitudeinit = eval(getXMLvalue(racine_carte,"latitudeinitadhs"));
				longitudeinit = eval(getXMLvalue(racine_carte,"longitudeinitadhs"));
			}
			leDiv = document.getElementById("map");
			if (leDiv == null) {
				return false;
			}
			/*var reg_taille=new RegExp("([0-9]+)([/]+)([0-9])+", "g");
			if (String(taille_hv).match(reg_taille)) {
				leDiv.style.width = options["map_h"];
				leDiv.style.height = options["map_v"];
			}
			*/
			//map = new GMap2(leDiv,{mapTypes: [G_SATELLITE_MAP,G_HYBRID_MAP,G_NORMAL_MAP,G_PHYSICAL_MAP,G_SATELLITE_3D_MAP]});
			map = new GMap2(leDiv,{mapTypes: [G_NORMAL_MAP,G_HYBRID_MAP]});
			//map = new GMap2(leDiv,{mapTypes: options["btnstypes"]});
			//restriction des niveaux de zoom
			//map.disableDoubleClickZoom();
			//map.disableDragging();
			//map.disablePinchToZoom();
			map.enableContinuousZoom();
			if ((! isNaN(options["zoom_min"] + options["zoom_max"]))) {
				var mt = map.getMapTypes();
				for (var i=0; i<mt.length; i++) {
					if (options["zoom_min"] != "") {
						mt[i].getMinimumResolution = function() {
							return options["zoom_min"]; 
						};
					}
					if (options["zoom_max"] != "") {
						mt[i].getMaximumResolution = function() {
							return options["zoom_max"];
						};
					}
				}
				//puisque G_PHYSICAL_MAP n''est pas retourn par getMapTypes()
				if (options["zoom_min"] != "") {
					G_PHYSICAL_MAP.getMinimumResolution = function() {
						return options["zoom_min"]; 
					};
				}
				if (options["zoom_max"] != "") {
					G_PHYSICAL_MAP.getMaximumResolution = function() {
						return options["zoom_max"];
					};
				}
			}
			if (options["controles"]) {
				//map.addControl(new GSmallMapControl());mini controle de zoom et de navigation
				map.addControl(new GMapTypeControl());
				//map.addControl(new GLargeMapControl());
				//map.addControl(new GSmallMapControl());
				//map.addControl(new GScaleControl()) ;
				//map.addControl(new GOverviewMapControl()) ;
			}		
			var type_carte = theMapType(options["type_map"]);
			if (!isNaN(options["centermap"].lat()) && !isNaN(options["centermap"].lng()) && (options["centermap"].lat() != 0 || options["centermap"].lng() != 0)) { //si on veut forcer le centrage
				//map.setCenter(options["centermap"], options["zoominit"], type_carte);//au cas o on ait des zooms diffrents par fiche
				map.setCenter(options["centermap"], zoominit, type_carte);
			}
			else {
				map.setCenter(new GLatLng(latitudeinit, longitudeinit), zoominit, type_carte);
			}
			//ajout boutons zoom
			function ZoomPlusControl() { }
			ZoomPlusControl.prototype = new GControl();
			ZoomPlusControl.prototype.initialize = function(map) {
				var container = document.createElement("div");
				var printDiv = document.createElement("div");
				this.setButtonStyle_(printDiv);
				container.appendChild(printDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoomplus.png";
				image.title = "Augmenter le zoom de la carte";
				printDiv.appendChild(image);
				GEvent.addDomListener(printDiv, "click", function() {
			   		//alert(map.getZoom());
			   		map.zoomIn(null,false,true);
				});
				map.getContainer().appendChild(container);
				return container;
			};
			ZoomPlusControl.prototype.getDefaultPosition = function() {
			  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(10, 10));
			};		
			// Sets the proper CSS for the given button element.
			ZoomPlusControl.prototype.setButtonStyle_ = function(button) {
			  /*button.style.textDecoration = "none";
			  button.style.lineHeight = "12px";
			  button.style.color = "#0000cc";
			  button.style.backgroundColor = "white";
			  button.style.border = "1px solid black";
			  button.style.padding = "0px";
			  button.style.marginBottom = "3px";
			  button.style.textAlign = "center";*/
			  button.style.cursor = "pointer";
			};
			map.addControl(new ZoomPlusControl());
			function ZoomMoinsControl() { }
			ZoomMoinsControl.prototype = new GControl();
			ZoomMoinsControl.prototype.initialize = function(map) {
				var container = document.createElement("div");
				var printDiv = document.createElement("div");
				this.setButtonStyle_(printDiv);
				container.appendChild(printDiv);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/zoommoins.png";
				image.title = "Diminuer le zoom de la carte";
				printDiv.appendChild(image);
				GEvent.addDomListener(printDiv, "click", function() {
			   		//alert(map.getZoom());
			   		map.zoomOut(null,false,true);
				});
				
				map.getContainer().appendChild(container);
				return container;
			};
			ZoomMoinsControl.prototype.getDefaultPosition = function() {
			  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(60, 10));
			};		
			// Sets the proper CSS for the given button element.
			ZoomMoinsControl.prototype.setButtonStyle_ = function(button) {
			  /*button.style.textDecoration = "none";
			  button.style.lineHeight = "12px";
			  button.style.color = "#0000cc";
			  button.style.backgroundColor = "white";
			  button.style.border = "1px solid black";
			  button.style.padding = "0px";
			  button.style.marginBottom = "3px";
			  button.style.textAlign = "center";*/
			  button.style.cursor = "pointer";
			};
			map.addControl(new ZoomMoinsControl());
			//fin boutons zoom
			// boutons meta-catgories
			
			var metacat1 = "5";//hbergement
			function Meta1Control() { }
			Meta1Control.prototype = new GControl();
			Meta1Control.prototype.initialize = function(map) {
				var container = document.createElement("div");
				this.setButtonStyle_(container);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/hbgt.png";
				image.title = "H&eacute;bergements";
				container.appendChild(image);
				GEvent.addDomListener(container, "click", function() {
			   		var mapDiv = document.getElementById("map");
					if (mapDiv == null) {
						return false;
					}
					if (dialogDiv ==null) {
						dialogDiv=document.createElement('div');
						dialogDiv.setAttribute('id','dialogcats');
						/*dialogDiv.style.width='220px';
						dialogDiv.style.height='200px';
						dialogDiv.style.borderWidth = "1px 1px 1px 1px";
						dialogDiv.style.borderColor = "#666 #666 #666 #666";
						dialogDiv.style.backgroundColor = "#fff";
						dialogDiv.style.borderStyle = "solid";
						dialogDiv.style.overflow = "hidden";
						dialogDiv.style.position='absolute';
						dialogDiv.style.left='40px';
						dialogDiv.style.top='10px';*/
						mapDiv.appendChild(dialogDiv);
					}
					else {
						dialogDiv.style.display = 'block';
					}
					var metacats = getXMLchild(racine_carte,"metacats");
					if (metacats) {
						var metacat_courant = getXMLchild(metacats,"metacat");
						while (metacat_courant && getXMLparam(metacat_courant,"Id") != metacat1) {
							metacat_courant = next_sibling(metacat_courant);
						}
						if (metacat_courant) {
							var cat_courant = getXMLchild(metacat_courant,"cat");
							var listcats = "";
							while (cat_courant) {
								var idcat = getXMLvalue(cat_courant,"idcat");
								var labelcat = getXMLvalue(cat_courant,"labelcat");
								listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','', '"+idcat+"','"+village+"'); return false\">"+labelcat+"</a></li>";
								cat_courant = next_sibling(cat_courant);
							}
							listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','"+metacat1+"', '','"+village+"'); return false\">Tous les h&eacute;bergements</a></li>";
							if (listcats != "") {
								listcats = "<ul>"+listcats+"</ul>";
							}
						}
						else {
							listcats = "<p>Aucune catgorie correspondante</p>";
						}
						dialogDiv.innerHTML =listcats;
						//dialogDiv.innerHTML = "<p><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"', '"+idmetacat+"', '1;10','"+village+"'); return false\">Coucou</a></p>";
					}
				});
				map.getContainer().appendChild(container);
				return container;
			};
			Meta1Control.prototype.getDefaultPosition = function() {
			  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(10, 70));
			};		
			// Sets the proper CSS for the given button element.
			Meta1Control.prototype.setButtonStyle_ = function(button) {
			  /*button.style.textDecoration = "none";
			  button.style.lineHeight = "12px";
			  button.style.color = "#0000cc";
			  button.style.backgroundColor = "white";
			  button.style.border = "1px solid black";
			  button.style.padding = "0px";
			  button.style.marginBottom = "3px";
			  button.style.textAlign = "center";*/
			  button.style.cursor = "pointer";
			};
			map.addControl(new Meta1Control());

			var metacat2 = "4";//restauration
			function Meta2Control() { }
			Meta2Control.prototype = new GControl();
			Meta2Control.prototype.initialize = function(map) {
				var container = document.createElement("div");
				this.setButtonStyle_(container);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/rest.png";
				image.title = "Restauration";
				container.appendChild(image);
				GEvent.addDomListener(container, "click", function() {
			   		var mapDiv = document.getElementById("map");
					if (mapDiv == null) {
						return false;
					}
					if (dialogDiv ==null) {
						dialogDiv=document.createElement('div');
						dialogDiv.setAttribute('id','dialogcats');
						/*dialogDiv.style.width='220px';
						dialogDiv.style.height='200px';
						dialogDiv.style.borderWidth = "1px 1px 1px 1px";
						dialogDiv.style.borderColor = "#666 #666 #666 #666";
						dialogDiv.style.backgroundColor = "#fff";
						dialogDiv.style.borderStyle = "solid";
						dialogDiv.style.overflow = "hidden";
						dialogDiv.style.position='absolute';
						dialogDiv.style.left='40px';
						dialogDiv.style.top='10px';*/
						mapDiv.appendChild(dialogDiv);
					}
					else {
						dialogDiv.style.display = 'block';
					}
					var metacats = getXMLchild(racine_carte,"metacats");
					if (metacats) {
						var metacat_courant = getXMLchild(metacats,"metacat");
						while (metacat_courant && getXMLparam(metacat_courant,"Id") != metacat2) {
							metacat_courant = next_sibling(metacat_courant);
						}
						if (metacat_courant) {
							var cat_courant = getXMLchild(metacat_courant,"cat");
							var listcats = "";
							while (cat_courant) {
								var idcat = getXMLvalue(cat_courant,"idcat");
								var labelcat = getXMLvalue(cat_courant,"labelcat");
								listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','', '"+idcat+"','"+village+"'); return false\">"+labelcat+"</a></li>";
								cat_courant = next_sibling(cat_courant);
							}
							listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','"+metacat2+"', '','"+village+"'); return false\">Toute la restauration</a></li>";
							if (listcats != "") {
								listcats = "<ul>"+listcats+"</ul>";
							}
						}
						else {
							listcats = "<p>Aucune catgorie correspondante</p>";
						}
						dialogDiv.innerHTML =listcats;
						//dialogDiv.innerHTML = "<p><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"', '"+idmetacat+"', '1;10','"+village+"'); return false\">Coucou</a></p>";
					}
				});
		
				map.getContainer().appendChild(container);
				return container;
			};
			Meta2Control.prototype.getDefaultPosition = function() {
			  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(10, 120));
			};		
			// Sets the proper CSS for the given button element.
			Meta2Control.prototype.setButtonStyle_ = function(button) {
			  /*button.style.textDecoration = "none";
			  button.style.lineHeight = "12px";
			  button.style.color = "#0000cc";
			  button.style.backgroundColor = "white";
			  button.style.border = "1px solid black";
			  button.style.padding = "0px";
			  button.style.marginBottom = "3px";
			  button.style.textAlign = "center";*/
			  button.style.cursor = "pointer";
			};
			map.addControl(new Meta2Control());
			
			var metacat3 = "3";//activits
			function Meta3Control() { }
			Meta3Control.prototype = new GControl();
			Meta3Control.prototype.initialize = function(map) {
				var container = document.createElement("div");
				this.setButtonStyle_(container);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/acts.png";
				image.title = "Activites";
				container.appendChild(image);
				GEvent.addDomListener(container, "click", function() {
			   		var mapDiv = document.getElementById("map");
					if (mapDiv == null) {
						return false;
					}
					if (dialogDiv ==null) {
						dialogDiv=document.createElement('div');
						dialogDiv.setAttribute('id','dialogcats');
						/*dialogDiv.style.width='220px';
						dialogDiv.style.height='200px';
						dialogDiv.style.borderWidth = "1px 1px 1px 1px";
						dialogDiv.style.borderColor = "#666 #666 #666 #666";
						dialogDiv.style.backgroundColor = "#fff";
						dialogDiv.style.borderStyle = "solid";
						dialogDiv.style.overflow = "hidden";
						dialogDiv.style.position='absolute';
						dialogDiv.style.left='40px';
						dialogDiv.style.top='10px';*/
						mapDiv.appendChild(dialogDiv);
					}
					else {
						dialogDiv.style.display = 'block';
					}
					var metacats = getXMLchild(racine_carte,"metacats");
					if (metacats) {
						var metacat_courant = getXMLchild(metacats,"metacat");
						while (metacat_courant && getXMLparam(metacat_courant,"Id") != metacat3) {
							metacat_courant = next_sibling(metacat_courant);
						}
						if (metacat_courant) {
							var cat_courant = getXMLchild(metacat_courant,"cat");
							var listcats = "";
							while (cat_courant) {
								var idcat = getXMLvalue(cat_courant,"idcat");
								var labelcat = getXMLvalue(cat_courant,"labelcat");
								listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','', '"+idcat+"','"+village+"'); return false\">"+labelcat+"</a></li>";
								cat_courant = next_sibling(cat_courant);
							}
							listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','"+metacat3+"', '','"+village+"'); return false\">Toutes les activit&eacute;s</a></li>";
							if (listcats != "") {
								listcats = "<ul>"+listcats+"</ul>";
							}
						}
						else {
							listcats = "<p>Aucune catgorie correspondante</p>";
						}
						dialogDiv.innerHTML =listcats;
						//dialogDiv.innerHTML = "<p><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"', '"+idmetacat+"', '1;10','"+village+"'); return false\">Coucou</a></p>";
					}
				});
				map.getContainer().appendChild(container);
				return container;
			};
			Meta3Control.prototype.getDefaultPosition = function() {
			  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(10, 170));
			};
			Meta3Control.prototype.setButtonStyle_ = function(button) {
			  /*button.style.textDecoration = "none";
			  button.style.lineHeight = "12px";
			  button.style.color = "#0000cc";
			  button.style.backgroundColor = "white";
			  button.style.border = "1px solid black";
			  button.style.padding = "0px";
			  button.style.marginBottom = "3px";
			  button.style.textAlign = "center";*/
			  button.style.cursor = "pointer";
			};
			map.addControl(new Meta3Control());
			/*var metacat4 = "6";//infos utiles
			function Meta4Control() { }
			Meta4Control.prototype = new GControl();
			Meta4Control.prototype.initialize = function(map) {
				var container = document.createElement("div");
				this.setButtonStyle_(container);
				image = document.createElement('img');
				image.src = racine_lib_module+"/icns/infos.png";
				image.title = "Informations utiles";
				container.appendChild(image);
				GEvent.addDomListener(container, "click", function() {
			   		var mapDiv = document.getElementById("map");
					if (mapDiv == null) {
						return false;
					}
					if (dialogDiv ==null) {
						dialogDiv=document.createElement('div');
						dialogDiv.setAttribute('id','dialogcats');
						/*dialogDiv.style.width='220px';
						dialogDiv.style.height='200px';
						dialogDiv.style.borderWidth = "1px 1px 1px 1px";
						dialogDiv.style.borderColor = "#666 #666 #666 #666";
						dialogDiv.style.backgroundColor = "#fff";
						dialogDiv.style.borderStyle = "solid";
						dialogDiv.style.overflow = "hidden";
						dialogDiv.style.position='absolute';
						dialogDiv.style.left='40px';
						dialogDiv.style.top='10px';*/
				/*		mapDiv.appendChild(dialogDiv);
					}
					else {
						dialogDiv.style.display = 'block';
					}
					var metacats = getXMLchild(racine_carte,"metacats");
					if (metacats) {
						var metacat_courant = getXMLchild(metacats,"metacat");
						while (metacat_courant && getXMLparam(metacat_courant,"Id") != metacat3) {
							metacat_courant = next_sibling(metacat_courant);
						}
						if (metacat_courant) {
							var cat_courant = getXMLchild(metacat_courant,"cat");
							var listcats = "";
							while (cat_courant) {
								var idcat = getXMLvalue(cat_courant,"idcat");
								var labelcat = getXMLvalue(cat_courant,"labelcat");
								listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','', '"+idcat+"','"+village+"'); return false\">"+labelcat+"</a></li>";
								cat_courant = next_sibling(cat_courant);
							}
							listcats += "<li><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"','"+metacat4+"', '','"+village+"'); return false\">Toutes les infos utiles</a></li>";
							if (listcats != "") {
								listcats = "<ul>"+listcats+"</ul>";
							}
						}
						else {
							listcats = "<p>Aucune catgorie correspondante</p>";
						}
						dialogDiv.innerHTML =listcats;
						//dialogDiv.innerHTML = "<p><a href=\"#\" onclick=\"dialogDiv.style.display='none';reloadsymboles('"+id+"', '"+idmetacat+"', '1;10','"+village+"'); return false\">Coucou</a></p>";
					}
				});
				map.getContainer().appendChild(container);
				return container;
			};
			Meta4Control.prototype.getDefaultPosition = function() {
			  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(10, 195));
			};		
			// Sets the proper CSS for the given button element.
			Meta4Control.prototype.setButtonStyle_ = function(button) {
			  /*button.style.textDecoration = "none";
			  button.style.lineHeight = "12px";
			  button.style.color = "#0000cc";
			  button.style.backgroundColor = "white";
			  button.style.border = "1px solid black";
			  button.style.padding = "0px";
			  button.style.marginBottom = "3px";
			  button.style.textAlign = "center";*/
		/*	  button.style.cursor = "pointer";
			};
			map.addControl(new Meta4Control());
			*/
			
			
			
			//fin boutons mta catgories
			//ajout de pictos
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var echelle = map.getZoom();
	
				var icone = new GIcon();
				//icone.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
				//icone.image = "http://asso.acmo.free.fr/membres/cible.png";
				//icone.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
				//icone.shadow = null;
				icone.image = chemicone;
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				largeur = taille;
				hauteur = taille;
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
				//icone.shadowSize = new GSize(22, 20);
				icone.infoWindowAnchor = new GPoint(Math.ceil(largeur/2),Math.ceil(hauteur/2));
				//icone.imageMap = [0,0,13,0,13,13,0,13];
				var marker = new GMarker(point, icone);
				if (options["bulle"] != "") {
					//var saut =new RegExp(String.fromCharCode(13), "g");
					var saut =new RegExp("(\n|\r)", "g");
					commentaire = commentaire.replace(saut,"<br />");
					GEvent.addListener(marker, "click", function() {
						var cont_mess = "";
						if (fiche != "") {
							if (message != "") {
								var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
							}
						}
						else {
							if (message != "") {
								var link_mess = "";
							}
						}
						cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
						//if (options["bulle"] == "T") {
							marker.openInfoWindowHtml(cont_mess,{ maxWidth:230 });
						//}
						/*if (options["bulle"] == "C") {
							marker.openInfoWindowHtml('<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>',{ maxWidth:230 });
							var dMapDiv = document.getElementById("detailmap");
							var detailmap = new GMap2(dMapDiv);
							detailmap.addControl(new GSmallZoomControl());
							detailmap.addControl(new GScaleControl());
							var leZoom = map.getZoom()+2;
							var LeZoomMax = map.getCurrentMapType().getMaximumResolution(point);
							if (map.getZoom(leZoom)+2 > LeZoomMax) {
								leZoom = LeZoomMax;
							};
							detailmap.setCenter(point , leZoom, map.getCurrentMapType());
							var CopyrightDiv = dMapDiv.firstChild.nextSibling;
							var CopyrightImg = dMapDiv.firstChild.nextSibling.nextSibling;
							CopyrightDiv.style.display = "none"; 
							CopyrightImg.style.display = "none";
							var marker_detail= new GMarker(point, icone);
							detailmap.addOverlay(marker_detail);
						}
						if (options["bulle"] == "TC") {
							if (cont_mess !="") {
								var tab1 = new GInfoWindowTab("Info", cont_mess);
								var tab2 = new GInfoWindowTab("Carte", '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>');
								var infoTabs = [tab1,tab2];
							}
							else {
								var tab2 = new GInfoWindowTab("Carte", '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13;"></div>');
								var infoTabs = [tab2];
							}
							marker.openInfoWindowTabsHtml(infoTabs,{ maxWidth:230 });
							if (detailmap != null) {
								detailmap = null;
								dMapDiv = null;
							}
							var dMapDiv = document.getElementById("detailmap");
							var detailmap = new GMap2(dMapDiv);
							detailmap.addControl(new GSmallZoomControl());
							detailmap.addControl(new GScaleControl());
							var leZoom = map.getZoom()+2;
							var LeZoomMax = map.getCurrentMapType().getMaximumResolution(point);
							if (map.getZoom(leZoom)+2 > LeZoomMax) {
								leZoom = LeZoomMax;
							};
							detailmap.setCenter(point , leZoom, map.getCurrentMapType());
							
							var CopyrightDiv = dMapDiv.firstChild.nextSibling;
							var CopyrightImg = CopyrightDiv.nextSibling;
							CopyrightDiv.style.display = "none"; 
							CopyrightImg.style.display = "none";
							
							var marker_detail= new GMarker(point, icone);
							detailmap.addOverlay(marker_detail);
						}*/
					});
				}
				return marker;
			}
			
			//ajout de textes 
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {		
				if (test3D(map.getCurrentMapType())) {
					return null;
				}
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getCurrentMapType() == G_NORMAL_MAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				var icone = new GIcon();
				icone.image = racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte;
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
					
				if (fiche == "") {
					var marker = new GMarker(point, icone, {clickable: false, draggable: false});
				}
				else {	
					var marker = new GMarker(point, icone);
					GEvent.addListener(marker, "click", function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			//affiche les textes
			function afficheTextes() {
				var textes = getXMLchild(racine_carte,"textes");
				if (textes != null) {
					var texte_courant = getXMLchild(textes,"texte");
					while (texte_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(texte_courant,"latitude_texte")), eval(getXMLvalue(texte_courant,"longitude_texte")));
						var fiche = getXMLvalue(texte_courant,"lien_texte");
						var target = getXMLvalue(texte_courant,"cible_texte");
						var message = getXMLvalue(texte_courant,"lieu_texte");
						var commentaire = getXMLvalue(texte_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(texte_courant,"dim_texte");
						var angletxt = getXMLvalue(texte_courant,"angle_texte");
						var couleurtxt = getXMLvalue(texte_courant,"couleur_texte");
						var typotxt = getXMLvalue(texte_courant,"police_texte");
						var tailletxt = getXMLvalue(texte_courant,"taille_texte");
						var tempMark = createTextMarker(point2,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						texte_courant = next_sibling(texte_courant);
					}
				}
			}
			
			//affiche les pictos
			function afficheLieux() {
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point2,message,commentaire,chemicone,fiche,target);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
				function afficherCBordure() {
					var bordure = new GPolyline.fromEncoded({
						color: getXMLvalue(racine_carte,"points_couleur"),
						weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
						opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
						points: getXMLvalue(racine_carte,"points_bordure"),
						levels: getXMLvalue(racine_carte,"points_visibilite"),
						numLevels: 3,
						zoomFactor: 12
					});
				map.addOverlay(bordure);
			}
			
			//crer polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				if (plein == "1") {
					var polygone = new GPolygon(decodeLine(points), couleur, epaisseur, 1, couleur, opacite);
				}
				else {
					var polygone = new GPolyline.fromEncoded({
						color: couleur,
						weight: epaisseur,
						opacity : opacite,
						points: points,
						levels: visibilite,
						numLevels: 3,
						zoomFactor: 12
					});
				}
				if (fiche != "" && plein == "1") {
					GEvent.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return polygone;
			}
			//afficher polygones
			function afficherPolygones() {
				var polygones = getXMLchild(racine_carte,"polygones");
				if (polygones != null) {
					var polygone_courant = getXMLchild(polygones,"polygone");
					while (polygone_courant) {
						var couleur = getXMLvalue(polygone_courant,"couleur");
						var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
						var points = getXMLvalue(polygone_courant,"polyencode");
						var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
						var fiche = getXMLvalue(polygone_courant,"lien_polygone");
						var target = getXMLvalue(polygone_courant,"cible_polygone");
						var plein = getXMLvalue(polygone_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							map.addOverlay(tempZone);
						}
						polygone_courant = next_sibling(polygone_courant);
					}
				}
			}
			//ajout de pictos
			function createMarkerSymb(point,message,commentaire,chemicone,photo,fiche,target) {
				var icone = new GIcon();
				//icone.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
				//icone.image = "http://asso.acmo.free.fr/membres/cible.png";
				//icone.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
				//icone.shadow = null;
				icone.image = chemicone;
				
				icone.iconSize = new GSize(32,32);
		        icone.iconAnchor = new GPoint(0, 32);
				//icone.shadowSize = new GSize(22, 20);
				
				
				icone.infoWindowAnchor = new GPoint(Math.ceil(32/2),Math.ceil(32/2));
				//icone.imageMap = [0,0,13,0,13,13,0,13];
				
				var marker = new GMarker(point, icone);
				GEvent.addListener(marker, "click", function() {
						var cont_mess = "";
						if (fiche != "") {
							if (message != "") {
								var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p>";
							}
						}
						else {
							if (message != "") {
								var link_mess = "";
							}
						}
						cont_mess = "<div class=\"bulle\"><div class=\"illustalert\"><img src=\""+photo+"\" width=\"220\" height=\"75\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div></div>";
						marker.openInfoWindowHtml(cont_mess,{ maxWidth:230 });
					});
				return marker;
			}
			
			//afficher les symboles
			function afficherSymboles() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"symboles");
				if (points != null) {
					var point_courant = getXMLchild(points,"symbole");
					while (point_courant) {
						var lat = getXMLvalue(point_courant,"latitude_symb");
						var lon = getXMLvalue(point_courant,"longitude_symb");
						if (lat != "" && lon!= "" && eval(lat) <= 360 && eval(lon) < 90) {
							var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
							var message = getXMLvalue(point_courant,"nom_symb");
							var chemicone = getXMLvalue(point_courant,"picto_symb");
							var photo = getXMLvalue(point_courant,"photo_symb");
							var commentaire = getXMLvalue(point_courant,"commentaire_symb");
							var fiche = getXMLvalue(point_courant,"lien_symb");
							var tempMark = createMarkerSymb(point2,message,commentaire,chemicone,photo, fiche,'_blank');
							if (tempMark != null) {
								map.addOverlay(tempMark);
							}
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			function getLocation() {
				// Get location no more than 10 minutes old. 600000 ms = 10 minutes.
				navigator.geolocation.getCurrentPosition(showLocation, showError, {enableHighAccuracy:true,maximumAge:600000});
			}
			function showError(error) {
				alert(error.code + ' ' + error.message);
			}
			function showLocation(position) {
				var smartpositionlat = position.coords.latitude;
				var smartpositionlon = position.coords.longitude;
				//rome
				/*smartpositionlat = 41.89001042401824;
				smartpositionlon = 12.392578125;*/
				//monaco
				/*smartpositionlat = 43.74208054609992;
				smartpositionlon = 7.426414489746094;*/
				//aleria
				/*smartpositionlat = 42.11325452493734;
				smartpositionlon = 9.513623714447021;*/
				
				/*geoinfo.innerHTML='<p>Latitude: ' + position.coords.latitude + '</p>' 
				+ '<p>Longitude: ' + position.coords.longitude + '</p>' 
				+ '<p>Accuracy: ' + position.coords.accuracy + '</p>' 
				+ '<p>Altitude: ' + position.coords.altitude + '</p>' 
				+ '<p>Altitude accuracy: ' + position.coords.altitudeAccuracy + '</p>' 
				+ '<p>Speed: ' + position.coords.speed + '</p>' 
				+ '<p>Heading: ' + position.coords.heading + '</p>';*/
				//return {latitude: position.coords.latitude,  longitude : position.coords.longitude}
				//amliorer en fonction des rgles de localisation
				//map.panTo(new GLatLng(position.coords.latitude, position.coords.longitude));
				positionPortable = new GLatLng(smartpositionlat, smartpositionlon);
				//montrerPortable();
				//setTimeout("map.panTo(positionPortable)",2000);
				// ********** test en foction des rgles de positionnement *********//
				var latitudeinitadhs = eval(getXMLvalue(racine_carte,"latitudeinitadhs"));
				var longitudeinitadhs = eval(getXMLvalue(racine_carte,"longitudeinitadhs"));
				var latitudeminadhs = eval(getXMLvalue(racine_carte,"latitudeminadhs"));
				var latitudemaxadhs = eval(getXMLvalue(racine_carte,"latitudemaxadhs"));
				var longitudeminadhs = eval(getXMLvalue(racine_carte,"longitudeminadhs"));
				var longitudemaxadhs = eval(getXMLvalue(racine_carte,"longitudemaxadhs"));
				//var zoneadhs = new GLatLngBounds(new GLatLng(latitudeminadhs,longitudeminadhs), new GLatLng(latitudemaxadhs,longitudemaxadhs));
				var latitudezonemin =  Math.min(latitudeminadhs,smartpositionlat);
				var latitudezonemax =  Math.max(latitudemaxadhs,smartpositionlat);
				var longitudezonemin =  Math.min(longitudeminadhs,smartpositionlon);
				var longitudezonemax =  Math.max(longitudemaxadhs,smartpositionlon);
				var zonetotale = new GLatLngBounds(new GLatLng(latitudezonemin,longitudezonemin), new GLatLng(latitudezonemax,longitudezonemax));
				var lezoom = map.getBoundsZoomLevel(zonetotale);
				map.setCenter(zonetotale.getCenter(),lezoom);
			}
			
			function orderOfCreation(marker,b) {
        		return 1;
      		}
			
			function montrerPortable() {
				if (positionPortable != null) {
					var icone = new GIcon();
					icone.image = "themes/mobile/images/marker.png";
					icone.iconAnchor = new GPoint(10, 34);
					icone.iconSize = new GSize(20,34);
					icone.infoWindowAnchor = new GPoint(Math.ceil(20/2),Math.ceil(34/2));
					var message = "Votre position";
					var commentaire = "Vous &ecirc;tes ici";
					var fiche = "";
					var target = "";
					//var marker = new GMarker(positionPortable, icone);
					var marker = new GMarker(positionPortable,{zIndexProcess:orderOfCreation});
					GEvent.addListener(marker, "click", function() {
						var cont_mess = "";
						if (fiche != "") {
							if (message != "") {
								var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p>";
							}
						}
						else {
							if (message != "") {
								var link_mess = "";
							}
						}
						//cont_mess = "<div class=\"illustalert\"><img src=\""+icone.image+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
						cont_mess = "<div class=\"bulle\"><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div></div>";
						marker.openInfoWindowHtml(cont_mess,{ maxWidth:230 });
					});
					if (marker != null) {
						map.addOverlay(marker);
					}
				}
			}
			
			//afficher position courante
			if (navigator.geolocation) {
				getLocation();
			}
			
			//action sur la carte
			/*GEvent.addListener(map, "click", function(marker, point) {
				alert("ho");
				if (marker == null) {
					alert("coucou");
					map.panTo(point);
				}
			});*/
			GEvent.addListener(map, "zoomend", function() {
				map.clearOverlays();
				if (options["polygones"]) {
					afficherPolygones();
				}
				if (options["bordure"]) {
					afficherCBordure();
				}
				if (options["lieux"]) {
					afficheTextes();
					afficheLieux();
				}
				afficherSymboles();
				montrerPortable();
			});
			
			GEvent.addListener(map, "moveend", function() {
				var centre = map.getCenter();
				localisation_vue(centre.lat(),centre.lng());
			});
			
			GEvent.addListener(map, "maptypechanged", function() {
				map.clearOverlays();
				if (options["polygones"]) {
					afficherPolygones();
				}
				if (options["bordure"]) {
					afficherCBordure();
				}
				if (options["lieux"]) {
					afficheTextes();
					afficheLieux();
				}
				afficherSymboles();
				montrerPortable();
				synchro_minimap();
			});
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficherSymboles();
			montrerPortable();
			
			if (options["mini_vue"]) {
				//minivue();
				//map.addControl(new GOverviewMapControl());
			}
			if (options["titre"]) {
				titrer(id,'titre')
			}
			if (options ["obs"]) {
				listLieux(id,'obs');
			}
			if (options["commentaire"]) {
				commenter(id,'commentaire');
			}
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre  jour.");
		}
	}
	
	function reloadsymboles (id,idmetacat,idcat,village){
		if (GBrowserIsCompatible()) {
//alert(id+"//"+typo+"//"+commune);
			cartes = GetXMLSymbols(id,idmetacat,idcat,village);
		 	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");

			map.clearOverlays();

			//ajout de pictos
			function createMarker(point,message,commentaire,chemicone,fiche,target) {
				var echelle = map.getZoom();
	
				var icone = new GIcon();
				//icone.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
				//icone.image = "http://asso.acmo.free.fr/membres/cible.png";
				//icone.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
				//icone.shadow = null;
				icone.image = chemicone;
				
				if (echelle <= 14) {
					taille = 13;
				}
				else {
					if (echelle == 15) {
						taille =17;
					}
					else {
						if (echelle == 16) {
							taille = 21;
						}
						else {
							if (echelle == 17) {
								taille = 27;
							}
							else {
								taille =32;
							}
						}
					}
				}
				largeur = taille;
				hauteur = taille;
				
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
				//icone.shadowSize = new GSize(22, 20);
				
				icone.infoWindowAnchor = new GPoint(Math.ceil(largeur/2),Math.ceil(hauteur/2));
				//icone.imageMap = [0,0,13,0,13,13,0,13];
				
				var marker = new GMarker(point, icone);
				
				if (options["bulle"] != "") {
					//var saut =new RegExp(String.fromCharCode(13), "g");
					var saut =new RegExp("(\n|\r)", "g");
					commentaire = commentaire.replace(saut,"<br />");
					
					GEvent.addListener(marker, "click", function() {
						var cont_mess = "";
						if (fiche != "") {
							if (message != "") {
								var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p></div>";
							}
						}
						else {
							if (message != "") {
								var link_mess = "";
							}
						}
						cont_mess = "<div class=\"illustalert\"><img src=\""+chemicone+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
						//if (options["bulle"] == "T") {
							marker.openInfoWindowHtml(cont_mess,{ maxWidth:230 });
						//}
						/*if (options["bulle"] == "C") {
							marker.openInfoWindowHtml('<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>',{ maxWidth:230 });
							
							var dMapDiv = document.getElementById("detailmap");
							var detailmap = new GMap2(dMapDiv);
							detailmap.addControl(new GSmallZoomControl());
							detailmap.addControl(new GScaleControl());
							var leZoom = map.getZoom()+2;
							var LeZoomMax = map.getCurrentMapType().getMaximumResolution(point);
							if (map.getZoom(leZoom)+2 > LeZoomMax) {
								leZoom = LeZoomMax;
							};
							detailmap.setCenter(point , leZoom, map.getCurrentMapType());
							
							var CopyrightDiv = dMapDiv.firstChild.nextSibling;
							var CopyrightImg = dMapDiv.firstChild.nextSibling.nextSibling;
							CopyrightDiv.style.display = "none"; 
							CopyrightImg.style.display = "none";
							
							var marker_detail= new GMarker(point, icone);
							detailmap.addOverlay(marker_detail);
						}
						if (options["bulle"] == "TC") {
							if (cont_mess !="") {
								var tab1 = new GInfoWindowTab("Info", cont_mess);
								var tab2 = new GInfoWindowTab("Carte", '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13 "></div>');
								var infoTabs = [tab1,tab2];
							}
							else {
								var tab2 = new GInfoWindowTab("Carte", '<div id="detailmap" style="width: 200px; height: 150px; border: solid 1px #512d13;"></div>');
								var infoTabs = [tab2];
							}
							marker.openInfoWindowTabsHtml(infoTabs,{ maxWidth:230 });
							if (detailmap != null) {
								detailmap = null;
								dMapDiv = null;
							}
							var dMapDiv = document.getElementById("detailmap");
							var detailmap = new GMap2(dMapDiv);
							detailmap.addControl(new GSmallZoomControl());
							detailmap.addControl(new GScaleControl());
							var leZoom = map.getZoom()+2;
							var LeZoomMax = map.getCurrentMapType().getMaximumResolution(point);
							if (map.getZoom(leZoom)+2 > LeZoomMax) {
								leZoom = LeZoomMax;
							};
							detailmap.setCenter(point , leZoom, map.getCurrentMapType());
							
							var CopyrightDiv = dMapDiv.firstChild.nextSibling;
							var CopyrightImg = CopyrightDiv.nextSibling;
							CopyrightDiv.style.display = "none"; 
							CopyrightImg.style.display = "none";
							
							var marker_detail= new GMarker(point, icone);
							detailmap.addOverlay(marker_detail);
						}*/
					});
				}
				return marker;
			}
			
			//ajout de textes 
			function createTextMarker(point,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target) {		
				if (test3D(map.getCurrentMapType())) {
					return null;
				}
				var echelle = map.getZoom();
				
				if (echelle < options["seuil_texte"]) {
					return null;
				}
				
				if (map.getCurrentMapType() == G_NORMAL_MAP) {
					var typeCarte = "P";
				}
				else {
					var typeCarte = "S";
				}
				var icone = new GIcon();
				icone.image = racine_lib_module+"/lieudit.php?a="+angletxt+"&s="+tailletxt+"&c="+escape(couleurtxt)+"&p="+escape(typotxt)+"&t="+escape(message)+"&m="+typeCarte;
				
				tailleTab = tailleboxtxt.split(",");
				largeur = tailleTab[0];
				hauteur = tailleTab[1];
				
				icone.iconSize = new GSize(largeur, hauteur);
				icone.iconAnchor = new GPoint( Math.ceil(largeur/2), Math.ceil(hauteur/2));
					
				if (fiche == "") {
					var marker = new GMarker(point, icone, {clickable: false, draggable: false});
				}
				else {	
					var marker = new GMarker(point, icone);
					GEvent.addListener(marker, "click", function() {
						if (target =="") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return marker;
			}
			
			//affiche les textes
			function afficheTextes() {
				var textes = getXMLchild(racine_carte,"textes");
				if (textes != null) {
					var texte_courant = getXMLchild(textes,"texte");
					while (texte_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(texte_courant,"latitude_texte")), eval(getXMLvalue(texte_courant,"longitude_texte")));
						var fiche = getXMLvalue(texte_courant,"lien_texte");
						var target = getXMLvalue(texte_courant,"cible_texte");
						var message = getXMLvalue(texte_courant,"lieu_texte");
						var commentaire = getXMLvalue(texte_courant,"commentaire_texte");
						var tailleboxtxt = getXMLvalue(texte_courant,"dim_texte");
						var angletxt = getXMLvalue(texte_courant,"angle_texte");
						var couleurtxt = getXMLvalue(texte_courant,"couleur_texte");
						var typotxt = getXMLvalue(texte_courant,"police_texte");
						var tailletxt = getXMLvalue(texte_courant,"taille_texte");
						var tempMark = createTextMarker(point2,message,commentaire,tailleboxtxt,angletxt,couleurtxt,typotxt,tailletxt,fiche,target);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						texte_courant = next_sibling(texte_courant);
					}
				}
			}
			
			//affiche les pictos
			function afficheLieux() {
				var points = getXMLchild(racine_carte,"points");
				if (points != null) {
					var point_courant = getXMLchild(points,"point");
					while (point_courant) {
						var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
						var message = getXMLvalue(point_courant,"lieu");
						var chemicone = getXMLvalue(point_courant,"picto");
						var commentaire = getXMLvalue(point_courant,"commentaire_point");
						var fiche = getXMLvalue(point_courant,"lien");
						var target = getXMLvalue(point_courant,"cible");
						var tempMark = createMarker(point2,message,commentaire,chemicone,fiche,target);
						if (tempMark != null) {
							map.addOverlay(tempMark);
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			//limites de commune
				function afficherCBordure() {
					var bordure = new GPolyline.fromEncoded({
						color: getXMLvalue(racine_carte,"points_couleur"),
						weight: eval(getXMLvalue(racine_carte,"points_epaisseur")),
						opacity : eval(getXMLvalue(racine_carte,"points_opacite")),
						points: getXMLvalue(racine_carte,"points_bordure"),
						levels: getXMLvalue(racine_carte,"points_visibilite"),
						numLevels: 3,
						zoomFactor: 12
					});
				map.addOverlay(bordure);
			}
			
			//crer polygones
			function createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target) {
				if (plein == "1") {
					var polygone = new GPolygon(decodeLine(points), couleur, epaisseur, 1, couleur, opacite);
				}
				else {
					var polygone = new GPolyline.fromEncoded({
						color: couleur,
						weight: epaisseur,
						opacity : opacite,
						points: points,
						levels: visibilite,
						numLevels: 3,
						zoomFactor: 12
					});
				}
				if (fiche != "" && plein == "1") {
					GEvent.addListener(polygone, "click", function() {
						if (target == "") {
							window.location.href = fiche;
						}
						else {
							window.open(fiche,target,'');
						}
					});
				}
				return polygone;
			}
			//afficher polygones
			function afficherPolygones() {
				var polygones = getXMLchild(racine_carte,"polygones");
				if (polygones != null) {
					var polygone_courant = getXMLchild(polygones,"polygone");
					while (polygone_courant) {
						var couleur = getXMLvalue(polygone_courant,"couleur");
						var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
						var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
						var points = getXMLvalue(polygone_courant,"polyencode");
						var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
						var fiche = getXMLvalue(polygone_courant,"lien_polygone");
						var target = getXMLvalue(polygone_courant,"cible_polygone");
						var plein = getXMLvalue(polygone_courant,"plein");
						var tempZone = createZonePolygon(points,couleur,epaisseur,opacite,visibilite,plein,fiche,target);
						if (tempZone != null) {
							map.addOverlay(tempZone);
						}
						polygone_courant = next_sibling(polygone_courant);
					}
				}
			}
			//ajout de pictos
			function createMarkerSymb(point,message,commentaire,chemicone, photo, fiche,target) {
				var icone = new GIcon();
				//icone.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
				//icone.image = "http://asso.acmo.free.fr/membres/cible.png";
				//icone.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
				//icone.shadow = null;
				icone.image = chemicone;
				
				icone.iconSize = new GSize(32,32);
		        icone.iconAnchor = new GPoint(0, 32);
				//icone.shadowSize = new GSize(22, 20);
				
				
				icone.infoWindowAnchor = new GPoint(Math.ceil(32/2),Math.ceil(32/2));
				//icone.imageMap = [0,0,13,0,13,13,0,13];
				
				var marker = new GMarker(point, icone);
				GEvent.addListener(marker, "click", function() {
						var cont_mess = "";
						if (fiche != "") {
							if (message != "") {
								var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p>";
							}
						}
						else {
							if (message != "") {
								var link_mess = "";
							}
						}
						cont_mess = "<div class=\"bulle\"><div class=\"illustalert\"><img src=\""+photo+"\" width=\"220\" height=\"75\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div></div>";
						marker.openInfoWindowHtml(cont_mess,{ maxWidth:230 });
					});
				return marker;
			}
			
			//afficher les symboles
			function afficherSymboles() {
				//affiche les pictos
				var points = getXMLchild(racine_carte,"symboles");
				if (points != null) {
					var point_courant = getXMLchild(points,"symbole");
					while (point_courant) {
						var lat = getXMLvalue(point_courant,"latitude_symb");
						var lon = getXMLvalue(point_courant,"longitude_symb");
						if (lat != "" && lon!= "" && eval(lat) <= 360 && eval(lon) < 90) {
							var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude_symb")), eval(getXMLvalue(point_courant,"longitude_symb")));
							var message = getXMLvalue(point_courant,"nom_symb");
							var chemicone = getXMLvalue(point_courant,"picto_symb");
							var photo = getXMLvalue(point_courant,"photo_symb");
							var commentaire = getXMLvalue(point_courant,"commentaire_symb");
							var fiche = getXMLvalue(point_courant,"lien_symb");
							var tempMark = createMarkerSymb(point2,message,commentaire,chemicone, photo, fiche,'_blank');
							if (tempMark != null) {
								map.addOverlay(tempMark);
							}
						}
						point_courant = next_sibling(point_courant);
					}
				}
			}
			
			function orderOfCreation(marker,b) {
        		return 1;
      		}
			
			function montrerPortable() {
				//Aleria
				/*smartpositionlat = 42.11325452493734;
				smartpositionlon = 9.513623714447021;
				positionPortable = new GLatLng(smartpositionlat, smartpositionlon);*/
				if (positionPortable != null) {
					var icone = new GIcon();
					icone.image = "themes/mobile/images/marker.png";
					icone.iconAnchor = new GPoint(10, 34);
					icone.iconSize = new GSize(20,34);
					icone.infoWindowAnchor = new GPoint(Math.ceil(20/2),Math.ceil(34/2));
					var message = "Votre position";
					var commentaire = "Vous &ecirc;tes ici";
					var fiche = "";
					var target = "";
					//var marker = new GMarker(positionPortable, icone);
					var marker = new GMarker(positionPortable,{zIndexProcess:orderOfCreation});
					GEvent.addListener(marker, "click", function() {
						var cont_mess = "";
						if (fiche != "") {
							if (message != "") {
								var link_mess = "<p class=\"linkalert\"><a href=\""+fiche+"\" target=\""+target+"\">Pour en savoir plus...</a></p>";
							}
						}
						else {
							if (message != "") {
								var link_mess = "";
							}
						}
						//cont_mess = "<div class=\"illustalert\"><img src=\""+icone.image+"\" /></div><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div>";
						cont_mess = "<div class=\"bulle\"><div class=\"blockalert\"><h1 class=\"messalert\">"+message+"</h1><p class=\"messalert\">"+commentaire+"</p>"+link_mess+"</div></div>";
						marker.openInfoWindowHtml(cont_mess,{ maxWidth:230 });
					});
					if (marker != null) {
						map.addOverlay(marker);
					}
				}
			}
			
			if (options["polygones"]) {
				afficherPolygones();
			}
			if (options["bordure"]) {
				afficherCBordure();
			}
			if (options["lieux"]) {
				afficheTextes();
				afficheLieux();
			}
			afficherSymboles();
			montrerPortable();
			
			//action sur la carte
			GEvent.addListener(map, "click", function(marker, point) {
				if (marker == null) {
					map.panTo(point);
				}
			});
			
			GEvent.addListener(map, "zoomend", function() {
				map.clearOverlays();
				if (options["polygones"]) {
					afficherPolygones();
				}
				if (options["bordure"]) {
					afficherCBordure();
				}
				if (options["lieux"]) {
					afficheTextes();
					afficheLieux();
				}
				afficherSymboles();
				montrerPortable();
			});
			
			GEvent.addListener(map, "moveend", function() {
				var centre = map.getCenter();
			});
			
			GEvent.addListener(map, "maptypechanged", function() {
				map.clearOverlays();
				if (options["polygones"]) {
					afficherPolygones();
				}
				if (options["bordure"]) {
					afficherCBordure();
				}
				if (options["lieux"]) {
					afficheTextes();
					afficheLieux();
				}
				afficherSymboles();
				montrerPortable();
			});
		}
		else {
			alert("Ce navigateur n'est pas compatible avec ce module. Veuillez le mettre  jour.");
		}
	}
	
	function listLieux(id,zone_id) {
		if (options["obs"]) {
			if (cartes == null) {
				cartes = GetXMLSymbols(id);
			}
		   	var racineXML = getXMLroot(cartes);
			var racine_carte = getXMLchild(racineXML,"carte");	
			var points = getXMLchild(racine_carte,"points");
			if (points != null) {
				var point_courant = getXMLchild(points,"point");
				var observations = "";
				observations += "<table border=\"0\" cellpadding=\"0\" celspacing=\"0\" class=\"observations\">";
				observations += "<tr><th colspan=\"4\">D&eacute;tails</th></tr>";
				while (point_courant) {
					var point2 = new GLatLng(eval(getXMLvalue(point_courant,"latitude")), eval(getXMLvalue(point_courant,"longitude")));
					var message = getXMLvalue(point_courant,"lieu");
					var chemicone = getXMLvalue(point_courant,"picto");
					var commentaire = getXMLvalue(point_courant,"commentaire_point");
					var fiche = getXMLvalue(point_courant,"lien");
					var target = getXMLvalue(point_courant,"cible");
					
					observations += "<tr>";
					observations += "<td>";
					observations += "<img src=\""+chemicone+"\" />";
					observations += "</td><td>";
					observations += message;
					observations += "</td><td>";
					observations += commentaire;
					observations += "</td><td>";
					if (fiche != "") {
						observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
					}
					observations += "</td>";
					observations += "<tr>";
					
					point_courant = next_sibling(point_courant);
				}
			}
			var polygones = getXMLchild(racine_carte,"polygones");
			if (polygones != null) {
				var polygone_courant = getXMLchild(polygones,"polygone");
				while (polygone_courant) {
					var nom =  getXMLvalue(polygone_courant,"nom");
					var details =  getXMLvalue(polygone_courant,"details");
					var couleur = getXMLvalue(polygone_courant,"couleur");
					var epaisseur = eval(getXMLvalue(polygone_courant,"epaisseur"));
					var opacite = eval(getXMLvalue(polygone_courant,"opacite"));
					var points = getXMLvalue(polygone_courant,"polyencode");
					var visibilite = getXMLvalue(polygone_courant,"polyvisibilite");
					var plein = getXMLvalue(polygone_courant,"plein");
					var fiche = getXMLvalue(polygone_courant,"lien_polygone");
					var target = getXMLvalue(polygone_courant,"cible_polygone");
					
					observations += "<tr>";
						observations += "<td>";
						observations += "<div style=\"display: block; line-height: 1px; width: 30px; height: "+epaisseur+"; background-color: "+couleur+"; filter: alpha(opacity="+eval(opacite*100)+"); -moz-opacity: "+opacite+"; opacity: "+opacite+" \"></div>";
						observations += "</td><td>";
						observations += nom;
						observations += "</td><td>";
						observations += details;
						observations += "</td><td>";
						if (fiche != "") {
							observations += "<a href=\""+fiche+"\" target=\""+target+"\">[voir fiche]</a>";
						}
						observations += "</td>";
						observations += "<tr>";
					polygone_courant = next_sibling(polygone_courant);
				}
			}
			observations += "</table>";
			
	  		var ie = false;
			if (document.all) {
				ie = true;
			}
			if (ie) {
				 var leDiv = document.all[zone_id];
			}
			else {
				var leDiv =  document.getElementById(zone_id);
			}
			if (leDiv == null) {
				return false;
			}
			leDiv.innerHTML = observations;
		}
	}
	
	function ajout_bouton(map_x, pos_x, texte, commentaire, latitude, longitude, zoom, etat) {
		function VillageControl() {
		}
		VillageControl.prototype = new GControl();
		VillageControl.prototype.initialize = function(map_x) {
			var container = document.createElement("div");
			
			var villageDiv2 = document.createElement("div");
			this.setButtonStyle2_(villageDiv2);
			container.appendChild(villageDiv2);
			villageDiv2.title = commentaire;
			
			var villageDiv = document.createElement("div");
			this.setButtonStyle_(villageDiv);
			villageDiv2.appendChild(villageDiv);
			villageDiv.appendChild(document.createTextNode(texte));
			//image = document.createElement('img');
			//image.src = racine_lib_module+"/icns/printer.gif";
			//image.title = "Zoom sur village";
			//villageDiv.appendChild(image);
			GEvent.addDomListener(villageDiv, "click", function() {
		   		map_x.setCenter(new GLatLng(latitude, longitude), zoom, etat);
			});
			
			map_x.getContainer().appendChild(container);
			return container;
		};
		
		VillageControl.prototype.getDefaultPosition = function() {
		  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(90+((pos_x-1)*90), 7));
		};
		
		// Sets the proper CSS for the given button element.
		VillageControl.prototype.setButtonStyle_ = function(button) {
		  button.style.textDecoration = "none";
		  button.style.lineHeight = "10px";
		  button.style.color = "#000000";
		  button.style.font = "small Arial";
		  button.style.fontSize = "12px";
		  button.style.borderStyle = "solid";
		  button.style.borderColor = "white rgb(176, 176, 176) rgb(176, 176, 176) white";
		  button.style.borderWidth = "1px";
		};
		VillageControl.prototype.setButtonStyle2_ = function(button) {
		  button.style.backgroundColor = "white";
		  button.style.border = "1px solid black";
		  button.style.padding = "0px";
		  button.style.marginBottom = "0px";
		  button.style.textAlign = "center";
		  button.style.width = "5em";
		  button.style.cursor = "pointer";
		};
		map_x.addControl(new VillageControl());
	}
	
	
	function synchro_minimap() {
		if (minimap != null) {
			var letype = map.getCurrentMapType();
			var minimapDiv = document.getElementById("minimap");
			if (letype == G_SATELLITE_3D_MAP) {
				minimapDiv.style.display='none';
			}
			else {
				minimapDiv.style.display='block';
				minimap.setMapType(map.getCurrentMapType());
			}
		}
	}
	
	function Rectangle(bounds, opt_weight, opt_color) {
      this.bounds_ = bounds;
      this.weight_ = opt_weight || 2;
      this.color_ = opt_color || "#00FF00";
    }
    Rectangle.prototype = new GOverlay();

    // Creates the DIV representing this rectangle.
    Rectangle.prototype.initialize = function(map) {
		var divRect = document.createElement("div");
		divRect.style.border = this.weight_ + "px solid " + this.color_;
		divRect.style.position = "absolute";
		divRect.style.overflow = "hidden";
		divRect.style.top = "0px";
		divRect.style.left = "-500px";
		map.getPane(G_MAP_MAP_PANE).appendChild(divRect);

		this.map_ = map;
		this.div_ = divRect;
    };

    // Remove the main DIV from the map pane
    Rectangle.prototype.remove = function() {
      this.div_.parentNode.removeChild(this.div_);
    };

    // Copy our data to a new Rectangle
    Rectangle.prototype.copy = function() {
      return new Rectangle(this.bounds_, this.weight_, this.color_,
                           this.backgroundColor_, this.opacity_);
    };

    // Redraw the rectangle based on the current projection and zoom level
    Rectangle.prototype.redraw = function(force) {
      // We only need to redraw if the coordinate system has changed
      if (!force) return;

      // Calculate the DIV coordinates of two opposite corners of our bounds to
      // get the size and position of our rectangle
      var c1 = this.map_.fromLatLngToDivPixel(this.bounds_.getSouthWest());
      var c2 = this.map_.fromLatLngToDivPixel(this.bounds_.getNorthEast());

      // Now position our DIV based on the DIV coordinates of our bounds
      this.div_.style.width = Math.abs(c2.x - c1.x) + "px";
      this.div_.style.height = Math.abs(c2.y - c1.y) + "px";
      //spcifique IE vince
      if (document.all) {
      	this.div_.style.width = Math.abs(c2.x - c1.x) + (this.weight_ * 2) + "px";
      	this.div_.style.height = Math.abs(c2.y - c1.y) + (this.weight_ * 2) + "px";
      }
      this.div_.style.left = (Math.min(c2.x, c1.x) - this.weight_) + "px";
      this.div_.style.top = (Math.min(c2.y, c1.y) - this.weight_) + "px";
    };
	
	function localisation_vue(latitude,longitude) {
		if (minimap != null) {
		    /*
		    //10 KM x 10 KM
		    var lngDelta = 0.0607;
	        var latDelta = 0.04493;*/
	        
	        var z_vue = map.getBounds();
	        var lngDelta = (z_vue.getNorthEast().lng() - z_vue.getSouthWest().lng())/2;
	        var latDelta = (z_vue.getNorthEast().lat() - z_vue.getSouthWest().lat())/2;
	        
	        var pointmini = new GLatLng(eval(latitude),eval(longitude));
	        var rectBounds = new GLatLngBounds(
	           new GLatLng(eval(pointmini.lat() - latDelta), eval(pointmini.lng() - lngDelta)),
	           new GLatLng(eval(pointmini.lat() + latDelta), eval(pointmini.lng() + lngDelta)));
	        moncadre = new Rectangle(rectBounds);
	        minimap.clearOverlays();
	        minimap.addOverlay(moncadre);
	   }
	};
	
	function show_minivue() {
		var minimapDiv = document.getElementById("minimap");
		if (minimapDiv == null) {
			return false;
		}
		minimapDiv.style.display='block';
	};
	
	function minivue() {
		//ajout bouton de revisualsation
		function OpenControl() {
		};
		OpenControl.prototype = new GControl();
		OpenControl.prototype.initialize = function(minimap) {
			var container = document.createElement("div");
			var OpenDiv = document.createElement("div");
			this.setButtonStyle_(OpenDiv);
			container.appendChild(OpenDiv);
			image = document.createElement('img');
			image.src = racine_lib_module+"/icns/show_mini.gif";
			image.title = "Afficher mini-carte";
			OpenDiv.appendChild(image);
			GEvent.addDomListener(OpenDiv, "click", function() {
		   		minimapDiv.style.display='block';
			});
		
			map.getContainer().appendChild(container);
			return container;
		};
		
		OpenControl.prototype.getDefaultPosition = function() {
		  return new GControlPosition(G_ANCHOR_BOTTOM_RIGHT, new GSize(0, 0));
		};
	
		// Sets the proper CSS for the given button element.
		OpenControl.prototype.setButtonStyle_ = function(button) {
		  button.style.textDecoration = "none";
		  button.style.lineHeight = "7px";
		  button.style.color = "#0000cc";
		  button.style.backgroundColor = "white";
		  //button.style.font = "small Arial";
		  button.style.border = "1px solid black";
		  //button.style.border = "none";
		  button.style.padding = "1px";
		  button.style.marginBottom = "0px";
		  button.style.textAlign = "center";
		  //button.style.width = "6em";
		  button.style.cursor = "pointer";
		};
		map.addControl(new OpenControl());
		//fin bouton revisualsation

		
		//affichage d'une minimap  la place du controle 
		var mapDiv = document.getElementById("map");
		if (mapDiv == null) {
			return false;
		}
		
		var minimapDiv=document.createElement('div');
		minimapDiv.setAttribute('id','minimap');
		minimapDiv.style.width='70px';
		minimapDiv.style.height='120px';
		minimapDiv.style.borderWidth = "4px 1px 1px 4px";
		minimapDiv.style.borderColor = "#ffffff #888888 #888888 #ffffff";
		minimapDiv.style.borderStyle = "solid";
		minimapDiv.style.overflow = "hidden";
		minimapDiv.style.position='absolute';
		minimapDiv.style.left='-500px';
		minimapDiv.style.top='0px';
		
		mapDiv.appendChild(minimapDiv);
		
		minimap = new GMap2(minimapDiv);
		
		/*var letype = map.getCurrentMapType();
		if (letype == G_SATELLITE_3D_MAP) {
			letype = G_HYBRID_MAP;
		}*/
		
		minimap.setCenter(new GLatLng(42.17154633452751, 9.1241455078125), 6, map.getCurrentMapType());
		minimap.disableDragging();
		minimap.disableDoubleClickZoom();
		
		var miniCopyrightDiv = minimapDiv.firstChild.nextSibling;
		var miniCopyrightImg = miniCopyrightDiv.nextSibling;
		miniCopyrightDiv.style.display = "none"; 
		miniCopyrightImg.style.display = "none";
		var decalageX = mapDiv["offsetWidth"] - minimapDiv["offsetWidth"];
		var decalageY = mapDiv["offsetHeight"] - minimapDiv["offsetHeight"];
		//var x = eval(calculeX(champ) + decalageX);
		//var y =  eval(calculeY(champ) + decalageY);
		//minimapDiv.style.left=x+'px';
		//minimapDiv.style.top=y+'px';
		minimapDiv.style.left= decalageX+'px';
		minimapDiv.style.top= decalageY+'px';
		
		//fin ajout localisation
		localisation_vue(latitudeinit,longitudeinit);
		
		//ajout bouton de fermeture
		function CloseControl() {
		};
		CloseControl.prototype = new GControl();
		CloseControl.prototype.initialize = function(minimap) {
			var container = document.createElement("div");
		
			var CloseDiv = document.createElement("div");
			this.setButtonStyle_(CloseDiv);
			container.appendChild(CloseDiv);
			image = document.createElement('img');
			image.src = racine_lib_module+"/icns/miniclose.gif";
			image.title = "Fermer mini-carte";
			CloseDiv.appendChild(image);
			GEvent.addDomListener(CloseDiv, "click", function() {
		   		minimapDiv.style.display='none';
			});
		
			minimap.getContainer().appendChild(container);
			return container;
		};
		
		CloseControl.prototype.getDefaultPosition = function() {
		  return new GControlPosition(G_ANCHOR_TOP_RIGHT, new GSize(0, 0));
		};
	
		// Sets the proper CSS for the given button element.
		CloseControl.prototype.setButtonStyle_ = function(button) {
		  button.style.textDecoration = "none";
		  button.style.lineHeight = "7px";
		  button.style.color = "#0000cc";
		  button.style.backgroundColor = "white";
		  //button.style.font = "small Arial";
		  button.style.border = "1px solid black";
		  //button.style.border = "none";
		  button.style.padding = "1px";
		  button.style.marginBottom = "0px";
		  button.style.textAlign = "center";
		  //button.style.width = "6em";
		  button.style.cursor = "pointer";
		};
		minimap.addControl(new CloseControl());
		//fin bouton fermeture
		if (map.getCurrentMapType() == G_SATELLITE_3D_MAP) {
			minimapDiv.style.display='none';
		}
	};
	
	function titrer(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var titre = getXMLvalue(racine_carte,"titre");
		
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = titre;
		document.title = document.title + " - " + titre;
	}
	
	function commenter(id,zone_id) {
		if (cartes == null) {
	 		cartes = GetXMLSymbols(id);
	 	}
	   	var racineXML = getXMLroot(cartes);
		var racine_carte = getXMLchild(racineXML,"carte");
		var commentaire = getXMLvalue(racine_carte,"page_carte");
		if (commentaire == "") {
			commentaire = getXMLvalue(racine_carte,"commentaire");
		}
		var ie = false;
		if (document.all) {
			ie = true;
		}
		if (ie) {
			 var leDiv = document.all[zone_id];
		}
		else {
			var leDiv =  document.getElementById(zone_id);
		}
		if (leDiv == null) {
			return false;
		}
		leDiv.innerHTML = commentaire;
	}
	
	function GetXMLSymbols(id,idmetacat,idcat,village) {
		var sortie = "";
		var params = "";
		if (id != "") {
			params += "&Idc="+id;
		}
		if (idmetacat != "") {
			params += "&metacat="+idmetacat;
		}
		if (idcat != "") {
			params += "&cat="+idcat;
		}
		if (village != "") {
			params += "&vilage="+village;
		}
		var sources_cartes = "mobiles.php?name=SimpleAdherents&op=map_alladhs_XML"+params;
		var cartes = GetAJAXData(sources_cartes);
		return cartes;
	}
	
	function calculeX(r){
	  return calculeOffset(r,"offsetLeft");
	}
	
	function calculeH(r){
	  return r["offsetHeight"];
	}
	
	function calculeL(r){
	  return r["offsetWidth"];
	}
	
	function calculeY(r){
	  return calculeOffset(r,"offsetTop")
	}
	function calculeOffset(element,attr){
	  var offset=0;
	  while(element){
	    offset+=element[attr];
	    element=element.offsetParent;
	  }
	  return offset;
	}
	
	var map = null;
	var minimap = null;
	var cartes = null;
	var latitudeinit = 0;
	var longitudeinit = 0;
	var type3D = false;
	var positionPortable = null;
	var dialogDiv = null;
	//]]>