<?php
/**
 * Classes des fonctions utiles.
 *
 * Elles sont dans une classe pour les isoler des autres fonctions.
 * @package becmsSimpleAds
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

/**
 * Classe des fonctions.
 *
 * Cette clase contient galement les fonctions utiles (conversion de date, ...).
 * @package becmsSimpleAds
 */
class utilFuncs {
	/**
	 * Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}

	/**
	 * Prpare les donnes  tre affiches en HTML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}

	/**
	 * Prpare les donnes  tre envoyes aux procdures Javascript.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}

	/**
	 * Prpare les donnes  tre incluses dans les formulaires.
	 * @param string $texte Texte  prparer
	 * @return string texte encod.
	 */
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',$texte));
	}

	/**
	 * Remplace une donne nulle ou vide par zero.
	 * @param string $valeur Valeur  tester.
	 * @return integer Valeur ou zero.
	 */
	function notVide($valeur) {
		if ($valeur == "") {
			return 0;
		}
		else {
			return $valeur;
		}
	}
	/**
	 * Prpare les donnes  tre exportes en XML.
	 * @param string $texte Texte  prparer
	 * @return string Texte encod.
	 */
	function conditionnerXML($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		$texte = utf8_encode($texte);
		return $texte;
	}

	/**
	 * Convertit une date du format Anne-Mois-Jour (SQL) au format Jour/Mois/Anne (Franais).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2JMA($ladate){
		if ($ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($an,$mois,$jour) = explode("-",$ladate);
			return $jour."/".$mois."/".$an;
		}
	}

	/**
	 * Convertit une date du format Jour/Mois/Anne (Franais) au format Anne-Mois-Jour (SQL).
	 * @param string $ladate Date  convertir.
	 * @return string Date convertie.
	 */
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00";
		}
		else {
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		return "$annee-$mois-$jour";
	}
}
?>