<?php

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function list_index($nbreFiches, $page, $ligne_par_page,$cat) {
	global $module_name;

	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);


	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._ADSFOUND;
	}
	else {
		$indexPages .= _ADSNOTFOUND;
	}
	$indexPages .= _ADSPAGES;
	if ($min < $liminf) {
		if ($min == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$min";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?name=".$module_name."&sop=ads_for_cat&Id=".$cat."&page=$min\">$min</a>";
			$indexPages .= "</div>";
		}
		if ($min < $liminf - 1) {
			$indexPages .= "...";
		}
	}
	for ($i=$liminf;$i<=$limsup;$i++) {
		if ($i == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$i";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?name=".$module_name."&sop=ads_for_cat&Id=".$cat."&page=$i\">$i</a>";
			$indexPages .= "</div>";
		}
	}
	if ($max > $limsup) {
		if ($max > $limsup + 1) {
			$indexPages .= "...";
		}
		if ($max == $p ) {
			$indexPages .= "<div class=\"pagevide\">";
			$indexPages .= "$max";
			$indexPages .= "</div>";
		}
		else {
			$indexPages .= "<div class=\"page\">";
			$indexPages .= "<a href=\"?name=".$module_name."&sop=ads_for_cat&Id=".$cat."&page=$max\">$max</a>";
			$indexPages .= "</div>";
		}

	}
	$indexPages .= "</div>";
	return $indexPages;
}

function list_by_cats() {
	global $module_name,$adsnbrebycat;
	
	$sortie = _ADSMAILINTROLIST;
	
	$sortie .= "<h2>"._ADSTITLE."</h2>";
	
	//$ligne_par_cat = 5;
	$ligne_par_cat = $adsnbrebycat;

	$obj_ads = new BD_Annonce();
	$results = $obj_ads->getCats();
	foreach($results as $result) {
		list($Id,$categorie,$image) = $result;
		$sortie .= '&nbsp;<br /><fieldset><legend>';
		$sortie .= '<img src="images/topics/'.$image.'" alt="'.$categorie.'">'.$categorie;
		$sortie .='</legend>';

		$result2s = $obj_ads->getAds("files","",$Id,date("d/m/Y H:i:s"),"","","date","0,".$ligne_par_cat,true);
		//print_r($result2s);
		if (count($result2s) != 0) {
			$sortie .= "<ul>";
			foreach($result2s as $result2) {
				list($Id_ads,$annonce) = $result2;
				$longlim = 100;
				if (strlen($annonce) > $longlim) {
					$i = $longlim;
					while (substr($annonce,$i,1) != " ") {
						$i--;
					}
					$liste .= substr($annonce,0,$i)."...";
				}
				else {
					$liste .= $annonce;
				}
				$sortie .= '<li>'.$liste.'</li>';
				$liste = "";
			}
			$sortie .= '<li>...</li>';
			$sortie .= '</ul>';
			$sortie .= '<hr  class="cats" />';
			$sortie .= '<p class="actions">';
			$sortie .= '<a href="modules.php?name='.$module_name.'&sop=ads_for_cat&Id='.$Id.'">'._ADSALLADS.'</a>';
			$sortie .= ' &bull; ';
			$sortie .= '<a href="modules.php?name='.$module_name.'&sop=new_ads&Id='.$Id.'">'._ADSNEWONE.'</a>';
			$sortie .= '</p>';
		}
		else {
			$sortie .= '<p>'._ADSNOADS.'</p>';
			$sortie .= '<hr  class="cats" />';
			$sortie .= '<p class="actions">';
			$sortie .= '<a href="modules.php?name='.$module_name.'&sop=new_ads&Id='.$Id.'">'._ADSNEWONE.'</a>';
			$sortie .= '</p>';
		}
		$sortie .= '</fieldset>';
	}
	return $sortie;
}

function list_for_cat($cat,$page) {
	global $module_name,$adsnbreforcat;

	//$ligne_par_page = 9;
	$ligne_par_page = $adsnbreforcat;

	$obj_ads = new BD_Annonce();
	$results = $obj_ads->getCats($cat);
	$result = $results[0];
	list($cat,$categorie,$image) = $result;
	$sortie = "<h1>".'<img src="images/topics/'.$image.'" alt="'.$categorie.'" class="ads">'.$categorie."</h1>";
	$sortie .= '&nbsp;<br />';
	//$sortie .= '<img src="images/topics/'.$image.'" alt="'.$categorie.'">';

	if ($page=="-1") {
		$page = ceil($nbrefiches/$ligne_par_page);
	}

	$aujourdhui = date("d/m/Y H:i:s");

	$nbreFiches = $obj_ads->getAds("count","",$cat,$aujourdhui,"","","","",true);
	$indexlist = list_index($nbreFiches, $page, $ligne_par_page,$cat);

	$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";

	//$sortie .= '&nbsp;<br />';
	$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
	$result2s = $obj_ads->getAds("files","",$cat,$aujourdhui,"","","",$limit,true);
	//print_r($_SERVER);
	
	if (count($result2s) != 0) {
		$sortie .= "<ul class=\"ads\">";
		foreach($result2s as $result2) {
			$sortie .= '<li>';
			$sortie .= nl2br($result2["annonce"]);
			if ($result2["tel"] != "") {
				$sortie .= '<br />'._ADSTELANNONCE.$result2["tel"];
			}
			if ($result2["email"] != "") {
				$adresse = 'modules.php?name='.$module_name.'&sop=sendMail&Id='.$result2["Id"];
				$sortie .= '<br /><a href="'.$adresse.'&retour='.urlencode($_SERVER["REQUEST_URI"]).'">'._ADSEMAILANNONCE.'</a>';
			}
			$sortie .= '</li>';
		}
		$sortie .= "</ul>";
	}
	//$sortie .= '&nbsp;<br />';
	$sortie .= '<hr  class="cats" />';
	$sortie .= '<p class="actions2">';
	$sortie .= '<a href="modules.php?name='.$module_name.'&sop=new_ads&Id='.$cat.'">'._ADSNEWONE.'</a>';
	$sortie .= '</p>';
	$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
	return $sortie;
}

function edit_ads($cat_id) {
	global $module_name, $user;
	$obj_cat = new BD_Annonce();
	$results = array();

	$menu_cat = '<select name="categorie" size="1" class="saisie">';
	$cats = $obj_cat->getCats();
	foreach($cats as $cat) {
		$selected = "";
		if ($cat["Id"] == $cat_id) {
			$selected = ' selected="selected"';
		}
		$menu_cat .= '<option value="'.$cat["Id"].'"'.$selected.'>'.$cat["categorie"].'</option>';
	}
	$menu_cat .= '</select>';

	$durees = array(7,30,90);
	$menuduree = '<select name="duree" size="1" class="saisie">';
	foreach($durees as $duree) {
		$selected = "";
		if ($result["duree"] == $duree) {
			$selected = ' selected="selected"';
		}
		$menuduree .= '<option value="'.$duree.'"'.$selected.'>'.$duree._ADSDAYS.'</option>';
	}
	$menuduree .= '</select>';

	$sortie = '<h1>'._ADSEDIT.'</h1>';
	$sortie .= '<form name="editads" action="modules.php?name='.$module_name.'&sop=save_ads" method="POST" onsubmit="return validform(this)">';
	$sortie .= '<div align="center">';
	$sortie .= '&nbsp;<br />';
	$sortie .= '<fieldset><legend>'._ADSFILEEDIT.'</legend>';
	$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="formulaire">';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSCATEDIT;
	$sortie .= '</td><td>';
	$sortie .= $menu_cat;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSMESSAGEEDIT;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="annonce" cols="50" rows="10" class="saisie"></textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSAUTEUREDIT;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="auteur" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSADRESSEEDIT;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="adresse" cols="50" rows="5" class="saisie"></textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSMAILDIT;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="email" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSTELDIT;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="tel" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSDUREEEDIT;
	$sortie .= '</td><td>';
	$sortie .= $menuduree;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td colspan="2" style="text-align: center">';
	$sortie .= _ADSREQUIREDEDIT;
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._ADSCATSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="-1" name="Id">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</fieldset>';
	$sortie .= '</div>';
	$sortie .= "</form>";
	
	
	$sortie .= '
<script type="text/javascript">
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function validform(formulaire) {
		var ok = true;
		var compteur=0;
		
		if (formulaire.categorie.value == "") {
			alert("'._ADSVERIFCAT.'");
			return false;
		}
		if (formulaire.annonce.value == "") {
			alert("'._ADSVERIFANNONCE.'");
			return false;
		}
		if (formulaire.auteur.value == "") {
			alert("'._ADSVERIFAUTEUR.'");
			return false;
		}
		if (formulaire.email.value =="") {
			alert("'._ADSVERIFEMAILEMPTY.'");
			return false;
		}
		if (!validMail(formulaire.email.value)) {
			alert("'._ADSVERIFEMAIL.'");
			return false;
		}
		return ok;
	}
</script>';
	return $sortie;
}

function send_email_ads($Id,$retour) {
	global $module_name;
	$obj_ads = new BD_Annonce();
	$results = $obj_ads->getAds("files",$Id,"","","","","","",true);
	$result = $results[0];
	$sortie = "<h1>"._ADSTITREMAILREPONSE."</h1>";
	$sortie .='<form name="newmail" action="modules.php?name='.$module_name.'&sop=mailSent" method="POST" onsubmit="return validform(this)">';
	$sortie .= "<h2>"._ADSMAILANNONCE."</h2>";
	$sortie .= "<ul class=\"ads\">";
	$sortie .= "<li>";
	$sortie .= nl2br($result["annonce"]);
	if ($result["tel"] != "") {
		$sortie .= '<br />'._ADSTELANNONCE.$result["tel"];
	}
	$sortie .= "</li>";
	$sortie .= "</ul>";
	$sortie .= "<div style=\"clear: both;\">";
	$sortie .= '<fieldset><legend>'._ADSMAILREPONSE.'</legend>';
	$sortie .= '<div align="center">';
	$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="formulaire">';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSMAILREPONSEYOURNAME;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="nom" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSMAILREPONSEYOURMESSAGE;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="message" cols="50" rows="10" class="saisie"></textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSMAILREPONSEYOURMAIL;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="email" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td colspan="2" style="text-align: center">';
	$sortie .= _ADSREQUIREDEDIT;
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._ADSCATSENDBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
	$sortie .= '<input type="hidden" value="'.urldecode($retour).'" name="retour">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</div>';
	$sortie .= '</fieldset>';
	
	$sortie .= '</form>';
	
	$sortie .= '
<script type="text/javascript">
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function validform(formulaire) {
		var ok = true;
		var compteur=0;
		
		if (formulaire.message.value == "") {
			alert("'._ADSVERIFMESSAGE.'");
			return false;
		}
		if (formulaire.nom.value == "") {
			alert("'._ADSVERIFAUTEUR.'");
			return false;
		}
		if (formulaire.email.value =="") {
			alert("'._ADSVERIFEMAILEMPTY.'");
			return false;
		}
		if (!validMail(formulaire.email.value)) {
			alert("'._ADSVERIFEMAIL.'");
			return false;
		}
		return ok;
	}
</script>';
	return $sortie;
}

function email_sent_ads($Id,$nom,$message,$email,$retour) {
	$sortie = "<h1>"._ADSTITREMAILREPONSE."</h1>";
	$obj_ads = new BD_Annonce();
	$results = $obj_ads->getAds("files",$Id,"","","","","","",true);
	$result = $results[0];
	$nom = stripslashes($nom);
	$message = stripslashes($message);
	$message = _ADSEXPEDITEURNAME.$nom."\n\n"._ADSEXPEDITEURMAIL.$email."\n\n".$message."\n\n.";
	if (utilFuncs::send_email($result["email"], $email, _ADSSUBJECTMAIL, $message)) {
		$sortie .= "<p><br />"._ADSMAILSENT."</p>";
	}
	else {
		$sortie .= "<p><br />"._ADSMAILNOTSENT."</p>";
	}
	$obj_ads->ajoutReponse();
	/*$sortie .='<form name="return" action="'.$retour.'" method="POST">';
	$sortie .= '<div align="center"';
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._ADSMAILRETURN.'" name="valid">';
	$sortie .= '</div>';
	$sortie .= '</form>';*/
	return $sortie;
}

function save_ads($newads) {
	global $module_name,$nukeurl;
	$sortie = "<h1>"._ADSSAVETITLE."</h1>";

	$obj_ads = new BD_Annonce();
	$newads["date_saisie"] = date("Y-m-d H:i:s");
	
	if ($obj_ads->saveAds($newads)) {
		if ($newads["Id"] == "-1") {
			$obj_ads->ajoutProp();
		}
		$sortie .= "<p>"._ADSANNOUNCESAVED."</p>";
		//e-mail internaute
		utilFuncs::send_email($newads["email"], _ADSMAILADMIN, _ADSSUBJECTSAVEDMAIL, _ADSANNOUNCESAVEDMAIL);
		//e-mail adminstrateur
		$message = _ADSANNOUNCESAVEDMAILADMIN;
		$tab_serveur = parse_url($nukeurl);
		$racine = $tab_serveur["scheme"]."://";
		if ($tab_serveur["user"] != "") {
			$racine .= $tab_serveur["user"];
		}
		if ($tab_serveur["pass"] != "") {
			$racine .= ":".$tab_serveur["pass"];
		}
		if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
			$racine .= "@";
		}
		$racine .= $tab_serveur["host"];
		if ($tab_serveur["port"] != "") {
			$racine .= ":".$tab_serveur["port"];
		}
		$racine .= "/system.php?action=list_ads_no&op=annonce&onglet=adsno";		
		utilFuncs::send_email(_ADSMAILADMIN, _ADSMAILADMIN, _ADSSUBJECTSAVEDMAILADMIN, str_replace("<!--lien-->",$racine,_ADSANNOUNCESAVEDMAILADMIN));
	}
	else {
		$sortie .= "<p>"._ADSANNOUNCENOTSAVED."</p>";
	}
	return $sortie;
}

function displayListByCats() {
	global $module_name;
	include ('header.php');
	echo list_by_cats();
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
                  "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function displayListForCat($cat,$page) {
	global $module_name;
	include ('header.php');
	echo list_for_cat($cat,$page);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
			//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back"=>"modules.php?name=$module_name",
            "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function addNewAds($cat) {
	global $module_name;
	include ('header.php');
	echo edit_ads($cat);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
				"back"=>"javascript:window.history.back()",
                "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function saveAds($newads) {
	global $module_name;
	include ('header.php');
	echo save_ads($newads);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
				"back"=>"modules.php?name=$module_name",
                "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function sendMailAds($Id,$retour) {
	global $module_name;
	if ($Id == "") {
		header("Location: modules.php?name=".$module_name);
	}
	else {
		include ('header.php');
		
		echo send_email_ads($Id,$retour);
		
		$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
					"back"=>"javascript:window.history.back()",
	                "top"=>"#top" );
		buttonBar($bardef, "align");
		include ('footer.php');
	}
}


function mailAdsSent($Id,$nom,$message,$email,$retour) {
	global $module_name;
	if ($Id == "") {
		header("Location: modules.php?name=".$module_name);
	}
	else {
		include ('header.php');
		
		echo email_sent_ads($Id,$nom,$message,$email,$retour);
		
		$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
					"back"=>$retour,
	                "top"=>"#top" );
		buttonBar($bardef, "align");
		include ('footer.php');
	}
}

function print_facts($page) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db;

	if (file_exists("themes/$Default_Theme/style/Sections.css")){
		$moduleStyle= "<LINK REL=\"stylesheet\" HREF=\"themes/$Default_Theme/style/Chuck_Norris_Facts.css\" TYPE=\"text/css\">\n";
	} else if (file_exists("modules/Sections/css/default.css")) {
		$moduleStyle= "<LINK REL=\"StyleSheet\" HREF=\"modules/Chuck_Norris_Facts/css/default.css\" TYPE=\"text/css\">\n";
	} else $moduleStyle="";

	echo "
	<html>
	<head>
	<title>$sitename</title>
	<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
	<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
	$moduleStyle
	</head>
	<body bgcolor=\"#FFFFFF\" text=\"#000000\">
	<table border=\"0\"><tr><td>
	<table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
	<table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>
	<div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"></div>
	<div class=\"zprint\">"
	.list_citations($page)
	."</div>
		</td></tr></table></td></tr></table>

		<div class=\"printFooter\">
		<div class=\"siteName\">
    "._COMESFROM." $sitename<br>
	<a href=\"$nukeurl\">$nukeurl</a>
	</div>
	<div class=\"pageURL\">
    "._THEURL."<br>
	<a href=\"$nukeurl/modules.php?name=Chuck_Norris_Facts&sop=list&page=$page\">$nukeurl/modules.php?name=Chuck_Norris_Facts&sop=list&page=$page</a>
	</div>
	</div>
	</td></tr></table>
	</body>
	</html>
    ";

}

if (!isset($page)) {
	$page = "1";
}
if ($page == "") {
	$page = "1";
}

$newads = array(
"Id"=>(!isset($Id))?"":$Id,
"categorie"=>(!isset($categorie))?"":$categorie,
"annonce"=>(!isset($annonce))?"":$annonce,
"auteur"=>(!isset($auteur))?"":$auteur,
"adresse"=>(!isset($adresse))?"":$adresse,
"email"=>(!isset($email))?"":$email,
"tel"=>(!isset($tel))?"":$tel,
"duree"=>(!isset($duree))?"":$duree
);

switch($sop) {
	case "list":
		displayListByCats();
		break;
	case "ads_for_cat":
		displayListForCat($Id,$page);
		break;
	case "new_ads":
		addNewAds($Id);
		break;
	case "save_ads":
		saveAds($newads);
		break;
	case "sendMail":
		sendMailAds($Id,$retour);
		break;
	case "mailSent":
		mailAdsSent($Id,$nom,$message,$email,$retour);
		break;
	case "print":
		print_facts($page);
		break;
	default:
		displayListByCats();
		//echo "Aucune opration  effectuer n'a t choisie'";
		break;
}
?>