<?php
/**
 * Interface d'administration du module de gestion des petites annonces.
 *
 * Cette valeur est fixe dans link.php.
 * @package becmsSimpleAnnonce
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2008, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
	//setPath(_TXT_Modules,0);
	//setPath(_SIMPLECARTO,1);
	require_once("modules/$module_name/lib_db.php");
	require_once("modules/$module_name/utils.php");

	function list_index($nbreFiches, $page, $ligne_par_page,$tab_words="") {
		if ($tab_words != "") {
			$tab_words = "&search_words=".urlencode($tab_words);
		}
		$nboites = 5;
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._ADSFOUND;
			$indexPages .= _ADSPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=annonce&action=list&page=$min".$tab_words."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=annonce&action=list&page=$i".$tab_words."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=annonce&action=list&page=$max".$tab_words."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _ADSNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	function list_ads($page,$search_words="",$cat="",$valid=true) {
		if ($valid) {
			$ongletencours = "ads";
		}
		else {
			$ongletencours = "adsno";
		}
		$obj_cat = new BD_Annonce();
		$nbrefiches = $obj_cat->getAds("count","",$cat,"","",$search_words,"","",$valid);
		$ligne_par_page = 20;
		if ($page=="-1") {
			$page = ceil($nbrefiches/$ligne_par_page);
		}
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= list_index($nbrefiches, $page, $ligne_par_page,$search_words);
		$liste .= '</td><td width="50"></td><td>';
		$liste .= '<form name="search_form" action="system.php?op=annonce&action=search_ads&onglet='.$ongletencours.'" method="POST">';
		$liste .= _ADSWORDSTOSEARCH.'<input type="text" name="search_words" value="'.$search_words.'">';
		$liste .= ' <input name="validsearch" type="submit" value="'._ADSSEARCHBTN.'">';
		$liste .= ' <input name="valid" type="hidden" value="'.$valid.'">';
		$liste .= '</form>';
		$liste .= '</td></tr></table>';
		$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
		$results = $obj_cat->getAds("files","",$cat,"","",$search_words,"",$limit,$valid);
		$liste .= '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader" style="text-align: left">'._ADSLISTADSCAT.'</th>
					<th class="systemTabHeader">'._ADSLISTADSCONTENT.'</th>
					<th class="systemTabHeader">'._ADSLISTADSDATE.'</th>
					<th class="systemTabHeader">'._ADSREDAC.'</th>
	    			<th class="systemTabHeader">'._ADSACTIONS.'</th>
		    		</tr>';
		$pos=0;
		if ($search_words != "") {
			$search_words = "&search_words=".urlencode($search_words);
		}
		foreach ($results as $result) {
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=annonce&action=edit_ads&onglet=".$ongletencours."&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_EDIT, "status"=>"ON"),
	  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=annonce&action=delete_ads&onglet=".$ongletencours."&page=".$page."&Id=".$result["Id"].$search_words,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$resultCats = $obj_cat->getCats($result["categorie"]);
			$liste .= utilFuncs::conditionnerHTML($resultCats[0]["categorie"]);
			$liste .= '</td><td>';
			$longlim = 150;
			if (strlen($result["annonce"]) > $longlim) {
				$i = $longlim;
				while (substr($result["annonce"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["annonce"],0,$i)."...";
			}
			else {
				$liste .= $result["annonce"];
			}
			$liste .= '</td><td align="center">';
			$liste .= utilFuncs::date2JMA($result["date_saisie"]);
			$liste .= '</td><td align="center">';
			$liste .= utilFuncs::conditionnerHTML($result["auteur"])." (<a href=\"mailto:".$result["email"]."\">".$result["email"]."</a>)";
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=annonce&action=add_ads&onglet=ads">'._ADSADDADS.'</a></div>';
		return $liste;
	}
	
	function edit_ads($Id, $page,$search_words="") {
		$obj_cat = new BD_Annonce();
		$results = array();
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$results = $obj_cat->getAds("files",$Id,"","","","","","",$limit);
			$result = $results[0];
			$Id = $result["Id"];
			$menu_cat = '<select name="categorie" size="1" class="saisie">'; 
			$cats = $obj_cat->getCats();
			foreach($cats as $cat) {
				$select = "";
				if ($result["categorie"] == $cat["Id"]) {
					$select = ' selected="selected"';
				}
				$menu_cat .= '<option value="'.$cat["Id"].'"'.$select.'>'.$cat["categorie"].'</option>';
			}
			$menu_cat .= '</select>';
			$durees = array(7,30,90);
			$menuduree = '<select name="duree" size="1" class="saisie">';
			foreach($durees as $duree) {
				$selected = "";
				if ($result["duree"] == $duree) {
					$selected = ' selected="selected"';
				}
				$menuduree .= '<option value="'.$duree.'"'.$selected.'>'.$duree._ADSDAYS.'</option>';
			}
			$menuduree .= '</select>';
			if ($result["date_valid"] == "0000-00-00 00:00:00") {
				$valid = '<input type="checkbox" value="'.date("d/m/Y H:i:s").'" name="date_valid" id="date_valid"><label for="date_valid">'._ADSVALIDATEEDIT.'</label>';
				$ongletcourant = "adsno";
			}
			else {
				$valid = '<input type="text" value="'.utilFuncs::date2JMA($result["date_valid"]).'" name="date_valid" class="saisie">';
				$ongletcourant = "ads";
			}
			$datelimite = "";
			if ($result["date_limite"] != "0000-00-00 00:00:00") {
				$datelimite = '<tr><td>'
						._ADSLIMITDATE
						.'</td><td>'
						.utilFuncs::date2JMA($result["date_limite"])
						.'</td></tr>';
			}
		}
		else {
			$menu_cat = '<select name="categorie" size="1" class="saisie">'; 
			$cats = $obj_cat->getCats();
			foreach($cats as $cat) {
				$menu_cat .= '<option value="'.$cat["Id"].'">'.$cat["categorie"].'</option>';
			}
			$menu_cat .= '</select>';
			
			$durees = array(7,30,90);
			$menuduree = '<select name="duree" size="1" class="saisie">';
			foreach($durees as $duree) {
				$menuduree .= '<option value="'.$duree.'">'.$duree._ADSDAYS.'</option>';
			}
			$menuduree .= '</select>';
			$valid = '<input type="checkbox" value="'.date("d/m/Y H:i:s").'" name="date_valid" id="date_valid"><label for="date_valid">'._ADSVALIDATEEDIT.'</label>';
			$ongletcourant = "ads";
			$datelimite = "";
		}
		
		$sortie = '<form name="editads" action="system.php?op=annonce&action=save_ads&onglet='.$ongletcourant.'" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSCATEDIT;
		$sortie .= '</td><td>';
		$sortie .= $menu_cat;
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSMESSAGEEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="annonce" cols="50" rows="10" class="saisie">'.$result["annonce"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSUSEREDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="auteur" value="'.$result["auteur"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSADRESSEEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="adresse" cols="50" rows="5" class="saisie">'.$result["adresse"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSMAILDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="email" value="'.$result["email"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSTELDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="tel" value="'.$result["tel"].'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSDUREEEDIT;
		$sortie .= '</td><td>';
		$sortie .= $menuduree;
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSSAISIEEDIT2;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="date_saisie" value="'.utilFuncs::date2JMA($result["date_saisie"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _ADSVALIDSTATEEDIT;
		$sortie .= '</td><td>';
		$sortie .= $valid;
		$sortie .= '</td></tr>';
		
		$sortie .= $datelimite;
		
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._ADSCATSAVEBTN.'" name="validbtn">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}
	
	function save_ads ($Id, $categorie, $annonce, $auteur, $adresse, $email, $tel, $duree, $date_saisie, $date_valid, $page,$search_words="") {
		if ($Id=="-1" || $Id == "") {
			$date_saisie = date("Y-m-d H:i:s");
			$Id = "-1";
		}
		else {
			$date_saisie = utilFuncs::date2AMJ($date_saisie);
		}
		$date_valid = utilFuncs::date2AMJ($date_valid);
		if ($date_valid != "0000-00-00 00:00:00") {
			list($temp1,$temp2) = explode(" ",$date_valid);
			list($year,$month,$day) = explode("-",$temp1);
			list($hour,$minute,$second) = explode(":",$temp2);
			$date_limite = date("Y-m-d h:i:s",mktime($hour,$minute,$second,$month,($day+$duree),$year));
		}
		else {
			$date_limite = "0000-00-00 00:00:00";
		}
		$ads = array(
			"Id"=>$Id,
			"categorie"=>$categorie,
			"annonce"=>$annonce,
			"auteur"=>$auteur,
			"adresse"=>$auteur,
			"email"=>$email,
			"tel"=>$tel,
			"duree"=>$duree,
			"date_saisie"=>$date_saisie,
			"date_valid"=>$date_valid,
			"date_limite"=>$date_limite
		);
		$obj_ads = new BD_Annonce();
		if ($Id != "-1") {
			$results = $obj_ads->getAds("files",$Id);
		}
		if (!$obj_ads->saveAds($ads)) {
			die("DB problem");
		}
		//dbut stats
		if ($ads["Id"] == "-1") {
			$obj_ads->ajoutProp();
			if ($ads["date_valid"] != "0000-00-00 00:00:00") {
				$obj_ads->ajoutValid();
			}
		}
		else {
			$result = $results[0];
			if ($result["date_valid"] == "0000-00-00 00:00:00" && $ads["date_valid"] != "0000-00-00 00:00:00") {
				$obj_ads->ajoutValid();
			}
		}
		//"fin stats
		if ($date_valid != "0000-00-00 00:00:00") {
			utilFuncs::send_email($ads["email"], _ADSMAILVALIDADMIN, _ADSSUBJECTVALIDMAIL, _ADSANNOUNCEVALIDMAIL);
		}
		return true;
	}
	
	function delete_ads($Id,$page,$search_words,$cat,$onglet,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_Annonce();
				if($obj_ads->delAds($Id)) {
					if ($onglet == "ads") {
						$sortie = list_ads($page,$search_words,$cat,true);
						$operationOnglet = _ADSLIST;
					}
					else {
						$obj_ads->ajoutRefus();
						$sortie = list_ads($page,$search_words,$cat,false);
						$operationOnglet = _ADSLISTNO;
					}
					return (array($sortie,$operationOnglet));
				}
				else {
					die("DB problem");
				}
			}
			else {
				if ($search_words != "") {
					$search_words = "&search_words=".urlencode($search_words);
				}
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._ADSCONFIRMDELETE."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=annonce&action=delete_ads&onglet='.$onglet.'&page='.$page.'&Id='.$Id.$search_words.'&confirm=y">';
				$sortie .= "["._ADSYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._ADSNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				if ($onglet == "ads") {
					$operationOnglet = _ADSLIST;
				}
				else {
					$operationOnglet = _ADSLISTNO;
				}
				return (array($sortie,$operationOnglet));
			}
		}
		return list_ads($page,$search_words,$cat);
	}

	function list_categories() {
		$obj_cat = new BD_Annonce();
		$results = $obj_cat->getCats();
		$liste = '<table  class="lisTable">
			<tr class="systemTabHeader">
				<th class="systemTabHeader" style="text-align: left">'._ADSLISTCAT.'</th>
    			<th class="systemTabHeader">'._ADSACTION.'</th>
	    		</tr>';
		foreach($results as $result) {
			list($Id, $categorie,$image) = $result;
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=annonce&action=edit_cat&onglet=cats&Id=".$Id,"comment"=>_EDIT, "status"=>"ON"),
  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=annonce&action=delete_cat&onglet=cats&Id=".$Id,"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$liste .= '<a href="system.php?op=annonce&action=list_ads&onglet=ads&cat='.$Id.'">';
			$liste .= utilFuncs::conditionnerHTML($categorie);
			$liste .= '</a>';
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=annonce&action=add_cat&onglet=cats">'._ADSADDCAT.'</a></div>';
		return $liste;
	}

	function edit_categorie($Id) {
		$categorie = "";
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$obj_cat = new BD_Annonce();
			$results = $obj_cat->getCats($Id);
			list($Id, $categorie,$image) = $results[0];
		}
		$sortie = '<form name="editcat" action="system.php?op=annonce&action=save_cat&onglet=cats" method="POST">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		$sortie .= '<tr><td>';
		$sortie .= _ADSCATNAME;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="categorie" value="'.$categorie.'" class="saisie">';
		$sortie .= '</td></tr>';
		$sortie .= '<tr><td>';
		$sortie .= _ADSCATIMAGE;
		$sortie .= '</td><td>';
		$sortie .= '<SCRIPT language="JavaScript" src="javascripts/images.js"></SCRIPT>';
		//$sortie .= '<input type="text" name="image" value="'.$image.'">';
		$sortie .= '<select name="image" onChange="displayImg(\'myicon\',\'images/topics/\'+this.options[selectedIndex].value)" class="saisie">';
		$path1 = explode ("/", "images/topics/");
		$path = "$path1[0]/$path1[1]";
		$handle=opendir($path);
		$tlist2 = "";
		while ($file = readdir($handle)) {
			if(substr($file,0,1) != "!" && substr($file,0,1) != "_" && substr($file,0,1) != "." && !is_file($path . '/' . $file) && !is_link($path . '/' . $file)) {
				$path2 = $path."/".$file;
				$handle2=opendir($path2);
				while ($file2 = readdir($handle2)) {
					if(substr($file2,0,1) != "!" && substr($file2,0,1) != "_" && substr($file2,0,1) != "." && is_file($path2 . '/' . $file2)) {
						if ( (preg_match("#^([0-9a-zA-Z]+)([.]{1})([a-z0-9A-Z]{3})$#",$file2)) ) {
							$tlist2 .= $file."/$file2 ";
						}
					}
				}
				closedir($handle2);
			}
			if ( (preg_match("#^([0-9a-zA-Z]+)([.]{1})([a-z0-9A-Z]{3})$#",$file)) ) {
				$tlist .= "$file ";
			}
		}
		closedir($handle);
		$tlist = explode(" ", $tlist);
		sort($tlist);
		$tlist2 = explode(" ", $tlist2);
		sort($tlist2);
		$tlist = array_merge($tlist,$tlist2);
		for ($i=0; $i < sizeof($tlist); $i++) {
			if($tlist[$i]!="") {
				if ($image == $tlist[$i]) {
					$sel = ' selected="selected"';
				} else {
					$sel = '';
				}
				$sortie .= '<option value="'.$tlist[$i].'"'.$sel.'>'.$tlist[$i].'</option>';
			}
		}
		$sortie .= '</select>';
		if ($image == "") {
			$image = $tlist[1];
		}
		$sortie .= '&nbsp;<img src="images/topics/'.$image.'" name="myicon" align="middle">&nbsp;';
		$sortie .= '<a href="images/topics/ads_icons.php" onclick="window.open(\'images/topics/ads_icons.php\',\'catalogue\',\'menubar=no, status=no, scrollbars=yes, menubar=no, width=500, height=400\');return false" target="_blank">Voir catalogue</a>';
		$sortie .= '</td></tr>';
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._ADSCATSAVEBTN.'" name="valid">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		//$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
		//$sortie .= '<input type="hidden" value="'.$search_words.'" name="search_words">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}

	function save_categorie($Id,$categorie,$image) {
		$cat = array("Id"=>$Id,"categorie"=>$categorie,"image"=>$image);
		$obj_cat = new BD_Annonce();
		if (!$obj_cat->saveCat($cat)) {
			die("DB problem");
		}
		return true;
	}
	
	function delete_categorie($Id,$confirm="n") {
		if ($Id != "") {
			if ($confirm == "y"){
				$obj_ads = new BD_Annonce();
				if($obj_ads->delCat($Id)) {
					return list_categories();
				}
				else {
					die("DB problem");
				}
			}
			else {
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._ADSCONFIRMDELETECAT."</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=annonce&action=delete_cat&onglet=cats&Id='.$Id.'&confirm=y">';
				$sortie .= "["._ADSYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._ADSNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
				return $sortie;
			}
		}
		return list_categories();
	}

	function list_stats() {
		global $locale;
		$obj_stat = new BD_Annonce();
		$results = $obj_stat->getStats();
		$liste = '<table  class="lisTable">
			<tr class="systemTabHeader">
				<th class="systemTabHeader" style="text-align: left">'._ADSSTATSLISTMOIS.'</th>
				<th class="systemTabHeader">'._ADSSTATSLISTPROP.'</th>
				<th class="systemTabHeader">'._ADSSTATSLISTVALID.'</th>
				<th class="systemTabHeader">'._ADSSTATSLISTREP.'</th>
				<th class="systemTabHeader">'._ADSSTATSLISTREFUS.'</th>
	    		</tr>';
		foreach($results as $result) {
			list($Id, $mois,$proposees,$validees,$reponses,$refusees) = $result;
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			list($year,$month,$day) = explode("-",$mois);
			//$mois = date("F Y",mktime(0,0,0,$month,$day,$year));
			setlocale (LC_TIME, "$locale");
			$mois = strftime("%B %Y",mktime(0,0,0,$month,$day,$year));
			$liste .= " ".utilFuncs::conditionnerHTML(ucfirst($mois));
			$liste .= '</td><td align="center">';
			$liste .= $proposees;
			$liste .= '</td><td align="center">';
			$liste .= $validees;
			$liste .= '</td><td align="center">';
			$liste .= $reponses;
			$liste .= '</td><td align="center">';
			$liste .= $refusees;
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		return $liste;
	}
	/**
	 * Renvoie l'interface d'administration de ce module.
	 *
	 * La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
	 * Elle ne retourne aucune valeur mais effectue rellement l'affichage.
	 */
	function process_ads(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$image,$search_words,$cat, $confirm,$valid;
		global $Id, $categorie, $annonce, $auteur, $adresse, $email, $tel, $duree, $date_saisie, $date_valid;

		include("system/header_system.php");


		if (!isset($action) || $action == "") {
			$action = "list_cat";
		}
		if (!isset($page) || $page == "") {
			$page = "1";
		}

		$sortie = "";
		$operationOnglet = "";

		switch ($action) {
			case "list_cat" :
				$sortie = list_categories();
				$operationOnglet = _ADSLISTCAT;
				break;
			case "edit_cat" :
				$sortie = edit_categorie($Id);
				$operationOnglet = _ADSEDITCAT;
				break;
			case "save_cat" :
				if (save_categorie($Id,$categorie,$image)) {
					$sortie = list_categories();
				}
				$operationOnglet = _ADSLISTCAT;
				break;
			case "add_cat" :
				$sortie = edit_categorie($Id);
				$operationOnglet = _ADSNEWCAT;
				break;
			case "delete_cat" :
				$sortie = delete_categorie($Id,$confirm);
				$operationOnglet = _ADSLISTCAT;
				break;
			case "list_ads" :
				$sortie = list_ads($page,$search_words,$cat,true);
				$operationOnglet = _ADSLIST;
				break;
			case "list_ads_no" :
				$sortie = list_ads($page,$search_words,$cat,false);
				$operationOnglet = _ADSLISTNO;
				break;
			case "edit_ads" :
				$sortie = edit_ads($Id,$page,$search_words);
				$operationOnglet = _ADSEDIT;
				break;
			case "save_ads" :
				//echo "$Id//$categorie//$annonce//$auteur//$adresse//$email, $tel, $duree, $date_saisie, $date_valid";
				if (save_ads($Id, $categorie, $annonce, $auteur, $adresse, $email, $tel, $duree, $date_saisie, $date_valid, $page,$search_words)) {
					if ($onglet == "ads") {
						$sortie = list_ads($page,$search_words,$cat,true);
						$operationOnglet = _ADSLIST;
					}
					else {
						$sortie = list_ads($page,$search_words,$cat,false);
						$operationOnglet = _ADSLISTNO;
					}
				}
				break;
			case "add_ads" :
				$sortie = edit_ads("",$page,$search_words);
				$operationOnglet = _ADSNEWADS;
				break;	
			case "search_ads" :
				$sortie = list_ads($page,$search_words,"",$valid);//sur la recherche par mot clef, la catgorie est neutralise
				$operationOnglet = _ADSLISTFOUND;
				break;
			case "delete_ads" :
				list($sortie,$operationOnglet) = delete_ads($Id,$page,$cat,$search_words,$onglet,$confirm);
				break;
			case "list_stats" :
				$sortie = list_stats();
				$operationOnglet = _ADSSTATS;
				break;
		}

		if (!isset($onglet)) {
			$onglet = "cats";
		}
		if ($onglet == "") {
			$onglet = "cats";
		}
		$ongletDef=array("cats"=> array( "text"=>_ADSONGLETCATS, "url"=>"system.php?action=list_cat&op=annonce&onglet=cats"),
						"ads"=> array( "text"=>_ADSONGLETLIST, "url"=>"system.php?action=list_ads&op=annonce&onglet=ads"),
						"adsno"=> array( "text"=>_ADSONGLETLISTNOVALID, "url"=>"system.php?action=list_ads_no&op=annonce&onglet=adsno"),
						"stats"=> array( "text"=>_ADSONGLETLISTSTATS, "url"=>"system.php?action=list_stats&op=annonce&onglet=stats"));

		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_ads.css\">";
		GraphicAdmin(_ADSMODULE);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		OpenSysTable();
		echo $sortie;
		CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}

	/**
	 * Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
	 */
	switch ($op) {
		case "annonce":
			process_ads();
			break;
	}
}
else {
	display_denied();
}
/*if (is_user($user)) {
 $user_data_bloc = base64_decode($user);
 $userdata_tab = explode(":", $user_data_bloc);
 $_SESSION["s_id_client"] = $userdata_tab[0];
 }
 else {
 $_SESSION["s_id_client"] = "-1";
 }*/

?>