<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */
/*                                                                      */
/*   																	*/
/* Baliste "Annuaire de Acteur" Module . Stephan ACQUATELLA 2004		*/
/* Project: Environmental Corsican Observatory       					*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Init Part
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);

if (file_exists("modules/SimpleUsersStats/stats.php")) {
	require_once("modules/SimpleUsersStats/stats.php");
	$stat_membre = new membersStats();
}
function ajoutStat($action) {
	global $stat_membre;
	if (isset($stat_membre)) {
		$stat_membre->add_action($action);
	}
}

function listCats() {
	global $prefix, $db, $module_name;
	$categories = array();
	$catsinit = explode("//",_ACT_CAT_CAT_VALUES);
	for ($i=1;$i<=count($catsinit);$i++) {
		$cats[$i]=$catsinit[$i-1];
		$result = $db->sql_query("select Id, label  from ".$prefix."_annuaire_categorie where categorie=$i order by categorie ASC");
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query:');
		}
		$temp = array();
		while (list($Id, $label) = $db->sql_fetchrow($result)) {
			$temp[$Id] = $label;
		}
		$categories[$i] = $temp;
	}
	$nbre_cols = 2;
	$nbre_cats = count($categories);
	$nbre_lignes = ceil($nbre_cats/$nbre_cols);
	$largeur = floor((100 - (($nbre_cols-1)*2))/$nbre_cols);
	
/*	echo "&nbsp;<br>";
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">";
	for ($l=1; $l<=$nbre_lignes;$l++) {
		echo "<tr>";
		for ($c=1;$c<=$nbre_cols;$c++) {
			echo "<td width=\"$largeur%\" valign=\"top\">";
			$temp = $categories[$c+($l-1)*$nbre_cols];
			if (count($temp) != 0) {
				echo "<fieldset><legend>".$cats[$c+($l-1)*$nbre_cols]."</legend>";
				echo "<ul  class=\"listcomp\">";
				foreach ($temp as $key => $lacat) {
					echo "<li><a href=\"modules.php?name=$module_name&sop=listActeur&catid=$key\">".$lacat."</a></li>";
				}
				echo "</ul>";
				echo "</fieldset>";
			}
			echo "</td>";
			if ($c != $nbre_cols) {
				echo "<td width=\"2%\">";
				echo "&nbsp;";
				echo "</td>";
			}
		}
		echo "</tr>";
	}
	echo "</table>";*/
	
	$colonne = array();
	echo "&nbsp;<br>";
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr>";
	for ($l=1; $l<=$nbre_lignes;$l++) {
		for ($c=1;$c<=$nbre_cols;$c++) {
			$temp = $categories[$c+($l-1)*$nbre_cols];
			if (count($temp) != 0) {
				$colonne[$c] .= "<fieldset><legend>".$cats[$c+($l-1)*$nbre_cols]."</legend>";
				$colonne[$c] .= "<ul  class=\"listcomp\">";
				foreach ($temp as $key => $lacat) {
					$colonne[$c] .= "<li><a href=\"modules.php?name=$module_name&sop=listActeur&catid=$key\">".$lacat."</a></li>";
				}
				$colonne[$c] .= "</ul>";
				$colonne[$c] .= "</fieldset>\n"."&nbsp;<br>\n";
			}
		}
	}
	for ($c=1;$c<=$nbre_cols;$c++) {
		echo "<td width=\"$largeur%\" valign=\"top\">";
		echo $colonne[$c];
		echo "</td>";
		if ($c != $nbre_cols) {
			echo "<td width=\"2%\">";
			echo "&nbsp;";
			echo "</td>";
		}
	}
	echo "</tr></table>";
}

/**
 * displayAccess
 * display liste by organisme type, and competences
 * @param
 * @return
 * @see
 */
function displayAccess() {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"modules.php?name=Search\" method=\"post\">"
	."<input type=\"hidden\" name=\"type\" value=\"annuaire\">"
	.""._SEARCHONACTEUR." <input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\">"
	."</form>"
	."<div><br>[ "
	."<a href=\"modules.php?name=$module_name\">"._ALPHAACCES."</a>"
	." ]</div>";
	echo "</div>";
	echo "</fieldset>";
	
	listCats();
	
	include ('footer.php');
}
/**
 * listActeur()
 * display acteur list sorted by compentence or activity or organisme type
 * @param typid :organism type id
 * @param comid :competences domaine id
 * @param sortBy : data sorted by competence or organism type
 * @return
 * @see
 */
function listActeur($catid) {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"modules.php?name=Search\" method=\"post\">"
	."<input type=\"hidden\" name=\"type\" value=\"annuaire\">"
	.""._SEARCHONACTEUR." <input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\">"
	."</form>"
	."<div><br>[ "
	."<a href=\"modules.php?name=$module_name\">"._ALPHAACCES."</a>"
	." ]</div>";
	echo "</div>";
	echo "</fieldset>";
	
	listCats();

	echo "&nbsp;<br>";
	if (!is_null($catid)) {
		$result = $db->sql_query("select Id, nom, tel from ".$prefix."_annuaire right join ".$prefix."_annuaire_lien_categorie on Id=id_annuaire where id_categorie=".$catid." order by nom asc");
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query:');
		}
		$result2 = $db->sql_query("select categorie, label from ".$prefix."_annuaire_categorie where Id=".$catid);
		if (!$result2) {
			print_r($db->sql_error());
			die('Invalid query:');
		}
		list($idxcat, $label) = $db->sql_fetchrow($result2);
		$catsinit = explode("//",_ACT_CAT_CAT_VALUES);
		$cat_title = $catsinit[$idxcat-1]." : ".$label;
		echo "<fieldset><legend>".ucfirst($cat_title)."</legend>";
		echo "<div class=\"padfield\"></div>";
		if ($db->sql_numrows($result) > 0) {
			echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
			$pos=1;
			while(list($Id, $nom, $tel) = $db->sql_fetchrow($result)) {
				if ($pos % 2 == 0)	{
					$style = " class=\"odd\"";
				}
				else {
					$style = " class=\"notodd\"";
				}
				$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&Id=$Id\" >";
				echo "<tr>"
				."<th align=\"left\"".$style.">$sectionLink$nom</th>"
				."<td align=\"center\"".$style.">$tel</a></td>"
				."</tr>";
				$pos++;
			}
			echo "</table>";	
		}
		else {
			echo "<p>"._ANNUNOORGTYPE."</p>";
		}
		echo "</fieldset>";
	}
	include ('footer.php');
}
/**
 * listActeurArbo()
 * Affiche les acteurs regroups par domaine puis par type. Si aucune domaine n'est indiqu, tous sont affichs, sinon seul le domaine indiqu est affich.
 * @param domid :competences domaine id
 * @see
 */
function listActeurArbo($domid) {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	$result4 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
	if (!$result4) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	$menu_dom = '<select name="domid" size="1" onchange="window.location.href=\'modules.php?name='.$module_name.'&sop=listActeurArbo&domid=\'+this.value">';
	$menu_dom .= '<option value="">'._ANNUFIRSTLINECHOOSE.'</option>';
	while (list($domaine,$domidsel)= $db->sql_fetchrow($result4)) {
		$select = ($domid == $domidsel) ? " selected=\"selected\"" : "";
		$menu_dom .= '<option value="'.$domidsel.'"'.$select.'>'.$domaine.'</option>';
	}
	$menu_dom .= "</select>";
	echo "<fieldset><legend>"._ANNUCHOOSEDOM."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"\" method=\"post\">"
	.""._ANNUCHOOSEDOMMENU.$menu_dom
	."</form>";
	echo "</div>";
	echo "</fieldset>";
	echo "&nbsp;<br />";
	if ($domid == "-1" || $domid == "") {
		$result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
	}
	else {
		$result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
	}
	if (!$result2) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	while (list($domaine,$domid)= $db->sql_fetchrow($result2)) {
		echo "<h2>".ucfirst($domaine)."</h2>";
		$result = $db->sql_query("select distinct type_acteur from ".$prefix."_annuaireacteur_domaine inner join ".$prefix."_annuaireacteur_acteur on acteur_actid=actid where domaine_domid='$domid'");
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query:');
		}
		if ($db->sql_numrows($result) > 0) {
			while(list($typid) = $db->sql_fetchrow($result)) {
				$result3 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");
				if (!$result3) {
					print_r($db->sql_error());
					die('Invalid query:');
				}
				while (list($type_organisme,$typid)= $db->sql_fetchrow($result3)) {
					echo "<h3>".ucfirst($type_organisme)."</h3>";
					$result5 = $db->sql_query("select actid, nom_acteur, ville_acteur, sigle_acteur, web_acteur from ".$prefix."_annuaireacteur_acteur inner join ".$prefix."_annuaireacteur_domaine on acteur_actid=actid where type_acteur='$typid' and domaine_domid='$domid' order by nom_acteur");
					if (!$result5) {
						print_r($db->sql_error());
						die('Invalid query:');
					}
					if ($db->sql_numrows($result5) > 0) {
						echo "<ul class=\"listact\">";
						while(list($acteurid, $nom_acteur, $ville_acteur, $sigle_acteur, $web_acteur) = $db->sql_fetchrow($result5)) {
							echo "<li><a href=\"modules.php?name=$module_name&sop=viewActeur&actid=$acteurid\">".strtoupper($nom_acteur)."</a></li>";
						}
						echo "</ul>";
					}
					else {
						echo "<p>"._ANNUNOORGTYPE."</p>";
					}
				}
			}
		}
		else {
			echo "<p>"._ANNUNOORGCOMP."</p>";
		}
	}
	include ('footer.php');
}
/**
 * listOrganismType()
 * display list of existinf organism type
 * @param
 * @return
 * @see
 */
function listOrganismType() {
	global $sitename, $prefix, $db, $module_name;
	$result = $db->sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme");
	//	$mycontent="";
	//	//$mycontent.="<TABLE borderColor=#ffffff cellSpacing=2 borderColorDark=#ff8000 cellPadding=2 width=300 border=0>";
	//	$mycontent.="<TABLE class=\"tab\" cellSpacing=2 cellPadding=2 width=260 border=0>";
	//	$mycontent.="<TBODY>";
	//	//$mycontent.="<TR borderColor=#ffffff bgColor=darkorange>";
	//	$mycontent.="<TR>";
	//	$mycontent.="<TD height=39 align=center class=\"titretab\">";
	//	//$mycontent.="<FONT style=\"BACKGROUND-COLOR: darkorange\" color=#ffffff><B>Acc&egrave;s par type d'organisme</B></FONT></TD>";
	//	$mycontent.="Acc&egrave;s par type d'organisme</TD>";
	if ($db->sql_numrows($result) != 0){
		$mycontent ="<ul class=\"listcomp\">";
		while(list($typid, $type_organisme) = $db->sql_fetchrow($result)) {
			//		$mycontent.="<TR >";
			//		$mycontent.="<TD width=351 ><A href=\"modules.php?name=$module_name&amp;sop=listActeur&typid=$typid\">$type_organisme</A></TD>";
			//		$mycontent.="</TR>";
			$mycontent.="<li><a href=\"modules.php?name=$module_name&amp;sop=listActeur&typid=$typid\">$type_organisme</a></li>";
		}
		$mycontent.="</ul>";
	}
	else {
		$mycontent = "<p>"._ANNULISTNOTHING."</p>";
	}
	// $mycontent.="</TABLE>";
	return $mycontent;
}
/**
 * listCompetence()
 * list existing competences domaine
 * @param
 * @return
 * @see
 */
function listCompetence() {
	global $sitename, $prefix, $db, $module_name;
	$result = $db->sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename");
	//	$mycontent.="<TABLE  class=\"tab\" cellSpacing=2  cellPadding=2 width=270 border=0>";
	//	$mycontent.="<TBODY>";
	//	$mycontent.="<TR>";
	//	$mycontent.="<TD height=39 align=center class=\"titretab\">";
	//	$mycontent.="Acc&egrave;s par domaines de comp&eacute;tence</TD>";
	//	$mycontent.="</TR>";
	if ($db->sql_numrows($result) != 0){
		$mycontent ="<ul class=\"listcomp\">";
		while(list($domid, $domainename) = $db->sql_fetchrow($result)) {
			//$mycontent.="<TR borderColor=#ffffff bgColor=navajowhite>";
			//		$mycontent.="<TR >";
			//		$mycontent.="<TD width=351><A href=\"modules.php?name=$module_name&amp;sop=listActeur&domid=$domid\">$domainename</A></TD>";
			//		$mycontent.="</TR>";
			$mycontent.="<li><a href=\"modules.php?name=$module_name&amp;sop=listActeur&domid=$domid\">".ucfirst($domainename)."</a></li>";
		}
		$mycontent.="</ul>";
	}
	else {
		$mycontent = "<p>"._ANNULISTNOTHING."</p>";
	}
	//	$mycontent.="</TABLE>";
	return $mycontent;
}

function menu_domaines() {
	global $prefix, $db;
	
	$domaines = array();
	$result = $db->sql_query("select code, label, description from ".$prefix."_users_domain order by code asc");
	while (list($code,$label,$description)=$db->sql_fetchrow($result)){
		$domaines[] = array("code"=>$code,"label"=>$label,"description"=>$description);
	}
	
	$premier = true;
	$compteur = 1;
	$compteur2 = 1;
	$tab_dom = "\tvar tab_dom = new Array();\n";
	$legende = '<table border="0" cellspacing="0" cellpadding="0" class="menuDomaines">';
	foreach ($domaines as $domaine) {
		if ($domaine["code"] % 100 == 0) {	
			if (!$premier) {
				$legende .= '</table>';
				$legende .= '</td></tr>';
			}
			$legende .= '<tr><th class="menuDomainesGroup" id="headerdom'.$compteur.'"><a href="#" onclick="toggleDomaine(&quot;'.$compteur.'&quot;);return false">'.$domaine["label"].'</a></th></tr>';
			$legende .= '<tr id="listdom'.$compteur.'"><td>';
			$legende .= '<table border="0" cellspacing="0" cellpadding="0" class="menuDomaines2">';
			$compteur++;
			$tab_dom .= "\ttab_dom[".$domaine["code"]."]=\"".$domaine["label"]."\";\n";
		}
		else {
			$radio = '<input type="radio" name="domain_rec" value="'.$domaine["code"].'" onclick="select_domaine(this)" id="monradio'.$compteur2.'">';
			$legende .= '<tr>';
			$legende .= '<td width="30">'.$radio.'</td>';
			$legende .= '<td><label for="monradio'.$compteur2.'"><b>'.$domaine["label"].'</b><br />'.str_replace("\r", "", nl2br($domaine["description"])).'</label></td>';
			$legende .= '</tr>';
			$tab_dom .= "\ttab_dom[".$domaine["code"]."]=\"".$domaine["label"]."\";\n";
			$compteur2++;
		}
		$premier = false;
	}
	$legende .= '</table>';
	$legende .= '</td></tr>';
	$legende .= '</table>';
	return array($legende, $tab_dom);
}

function block_rec_annucomp($motclef="", $raison="", $domaine="", $myfilter="") {
	global $module_name, $carte_annuaire;
	
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo '<table cellpadding="0" cellspacing="0" border="0" class="tabsearch" align="center">';
	echo '<tr><td>'; 
	echo "<form action=\"modules.php?name=$module_name\" method=\"post\">"
	."<input type=\"hidden\" name=\"sop\" value=\"recByKeyword\">"
	.""._SEARCHONACTEUR." </td><td><input type=\"text\" name=\"keyword_rec\" size=\"30\" value=\"$motclef\" class=\"saisie\">&nbsp;&nbsp;"
	."</td><td><input type=\"submit\" value=\""._SEARCH."\">"
	."</form>";
	echo "</td></tr><tr><td colspan=\"3\">";
	echo "<hr class=\"annu\" />";
	echo "</td></tr>";
	echo '<tr><td>'; 
	echo "<form action=\"modules.php?name=$module_name\" method=\"post\">"
	."<input type=\"hidden\" name=\"sop\" value=\"recByRaison\">"
	.""._ANNURAISON." </td><td><input type=\"text\" name=\"raison_rec\" size=\"30\" value=\"$raison\" class=\"saisie\">&nbsp;&nbsp;"
	."</td><td><input type=\"submit\" value=\""._SEARCH."\">"
	."</form>";
	echo "</td></tr>";
	echo "</td></tr><tr><td colspan=\"3\">";
	echo "<hr class=\"annu\" />";
	echo "</td></tr>";
	$valsJS = menu_domaines();
	echo '
<link href="modules/'.$module_name.'/system/stl_pop.css" rel="stylesheet" type="text/css" media="all" />
<script src="modules/'.$module_name.'/system/lib_autostart.js" type="text/javascript"></script>
<script src="modules/'.$module_name.'/system/lib_zpop.js" type="text/javascript"></script>
<script src="modules/'.$module_name.'/system/lib_admin_domaines.js" type="text/javascript"></script>
<script type="text/javascript">
// <![CDATA[
	init_chemin_icones = "modules/'.$module_name.'/system";
'.$valsJS[1].'
	addToStart("newPopUpZPop(document.forms[\'search_domain\'])");
	function saisie_du_domaine() {
		if (is_empty_dom()) { 
			togglePopUpZPop(null,\''.addslashes(str_replace("\n"," ", str_replace("\"","'",$valsJS[0]))).'\',\''._ANNUDOMAINMENU.'\');
			hideAllDomaines(); 
		}
		else { 
			JustTogglePopUpZPop(); 
		}
	}
// ]]>
</script>';
	echo '<tr><td>'; 
	echo "<form action=\"modules.php?name=$module_name\" method=\"post\" name=\"search_domain\">"
	."<input type=\"hidden\" name=\"sop\" value=\"recByDom\">"
	.""._ANNUDOMAINE
	.'</td><td align="center">'
	//.'<a id= "menudom" class="menudom" href="#" onclick="if (is_empty_dom()) { togglePopUpZPop(null,\''.addslashes(str_replace("\n"," ", str_replace("\"","'",$valsJS[0]))).'\',\''._ANNUDOMAINMENU.'\');hideAllDomaines(); } else { JustTogglePopUpZPop(); };return false" title="'._ANNUDOMAINBROWSE.'">'._ANNUDOMAINCHOOSE.'</a>'
	//."<input type=\"text\" name=\"domaine_visu\" size=\"30\" value=\"$domaine\" readonly=\"readonly\" class=\"saisie\">&nbsp;&nbsp;"
	."<input type=\"text\" name=\"domaine_visu\" size=\"30\" value=\"$domaine\" onfocus=\"saisie_du_domaine()\" onchange=\"saisie_du_domaine()\" class=\"saisie\">&nbsp;&nbsp;"
	."</td><td><input type=\"submit\" value=\""._SEARCH."\">"
	."</form>";
	echo "</td></tr>";
	
	echo "<tr><td colspan=\"3\">";
	echo "<hr class=\"annu\" />";
	echo "</td></tr>";
	echo '<tr><td colspan="3" class="acttab">'; 
	echo _SEARCHGEO.'<a href="modules.php?name='.$module_name.'&sop=map_annu&Idc='.$carte_annuaire.'">'._DISPLAYANNUGEO.'</a>';
	echo "</td></tr>";
	
	echo "<tr><td colspan=\"3\">";
	/*echo "<hr class=\"annu\" />";
	echo "</td></tr>";
	echo '<tr><td>'; 
	echo "<form action=\"modules.php?name=$module_name\" method=\"post\">"
	."<input type=\"hidden\" name=\"sop\" value=\"listActeurByChar\">"
	.""._SEARCHALPHA." &nbsp;&nbsp;"
	."</td><td></td><td><input type=\"submit\" value=\""._SEARCH."\">"
	."</form>";
	echo "</td></tr><tr><td colspan=\"3\">";*/
	echo "<hr class=\"annu\" />";
	echo "</td></tr>";
	echo '<tr><td colspan="3" class="acttab">'; 
	echo _SEARCHALPHA._ANNULISTALPHA.displayAlphabet("modules.php?name=$module_name&sop=listActeurByChar",$myfilter);
	echo "</td></tr>";

	echo "</table>";
	echo "</div>";
	echo "</fieldset>";
	
	echo "&nbsp;<br>";
}

/**
 * listActeurByChar()
 *
 *
 *
 *
 */
function listActeurByChar($myfilter){
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	
	echo "<h1>".ANNUTITLE."</h1>";
	
	if ($myfilter == "") $myfilter="A";
	
	block_rec_annucomp("","","",$myfilter);
	
	echo "<fieldset><legend>"._ANNUALPHA."</legend>";
	
	echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
	/*echo "<tr>"
	//."<td class=\"titretab\ width=\"75%\"><b>"._ACTEUR_NAME."</b></td>"
	//."<td class=\"titretab\ width=\"25%\"><b>"._ACTEUR_SIGLE."</b></td>"
	."<td class=\"acttab\" colspan=2>"._ANNULISTALPHA.displayAlphabet("modules.php?name=$module_name&sop=listActeurByChar",$myfilter)."</td>"
	."</tr>";
	echo "<tr><td colspan=\"2\"><hr class=\"annu\"></td></tr>";*/

	
	if ($myfilter!="") 	$thefilter="WHERE raison LIKE '$myfilter%'";
	$result = $db->sql_query("select Id, raison, ville from ".$prefix."_annuairecompetences_struct $thefilter order by raison ASC");
	
	if ($db->sql_numrows($result) != 0) {
		$pos=1;
		while(list($Id, $nom, $tel) = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0)	{
				$style = " class=\"odd\"";
			}
			else {
				$style = " class=\"notodd\"";
			}
			$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&Id=$Id\" >";
			echo "<tr>"
			."<th align=\"left\"".$style.">$sectionLink$nom</a></th>"
			."<td align=\"center\"".$style.">$tel</td>"
			."</tr>";
			$pos++;
		}
	}
	else {
		echo "<tr><td colspan=\"2\"<p style=\"text-align: center\">"._ANNUNOORGTYPE."</p></td></tr>";
	}
	echo "</table>";
	echo "</fieldset>";

	include ('footer.php');
}

/**
 * listActeurByKeyword()
 *
 *
 *
 *
 */
function listActeurByKeyword($keyword) {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	
	echo "<h1>".ANNUTITLE."</h1>";
	
	block_rec_annucomp($keyword,"","");
	
	if (!isset($keyword) || $keyword == "") {
		$keyword = "01234567890123456789";
	}
	
	$keyword = str_replace("'","''",stripslashes($keyword));
	
	echo "<fieldset><legend>"._ANNUKEYWORD."</legend>";
	
	echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
	//echo "<tr><td colspan=\"2\"><hr class=\"annu\"></td></tr>";
	
	$sql1 = "select ".$prefix."_annuairecompetences_struct.Id, raison, ville, '3' as poids from (".$prefix."_annuairecompetences_struct left join ".$prefix."_annuairecompetences_link on id_struct=Id) left join ".$prefix."_users_domain on code=id_domain where label like '%$keyword%' or description like '%$keyword%'";
	$sql2 = "select ".$prefix."_annuairecompetences_struct.Id, raison, ville, '4' as poids from ".$prefix."_annuairecompetences_struct where raison like '%$keyword%'";
	$sql3 = "select ".$prefix."_annuairecompetences_struct.Id, raison, ville, '2' as poids from ".$prefix."_annuairecompetences_struct left join ".$prefix."_users_domain on code=metier where label like '%$keyword%' or description like '%$keyword%'";
	$sql4 = "select ".$prefix."_annuairecompetences_struct.Id, raison, ville, '1' as poids from ".$prefix."_annuairecompetences_struct where activites like '%$keyword%'";
	$sql5 = "select ".$prefix."_annuairecompetences_struct.Id, raison, ville, '1' as poids from ".$prefix."_annuairecompetences_struct where ville like '%$keyword%'";
	
	$sql = "CREATE TEMPORARY TABLE `search_annu_temp` ($sql1) UNION ALL ($sql2) UNION ALL ($sql3) UNION ALL ($sql4) UNION ALL ($sql5)";
	$noresult = $db->sql_query($sql);
	$sql = "CREATE TEMPORARY TABLE `find_annu_temp` SELECT Id, raison, ville, SUM(`poids`) AS `score` FROM `search_annu_temp` GROUP BY `Id`";
	$noresult = $db->sql_query($sql);
	$sql = "DROP TEMPORARY TABLE `search_annu_temp`";
	$noresult = $db->sql_query($sql);
	$sql = "select Id, raison, ville, score from find_annu_temp ORDER BY score DESC, raison ASC";
	$result = $db->sql_query($sql);
	
	if ($db->sql_numrows($result) != 0) {
		$pos=1;
		while(list($Id, $nom, $tel) = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0)	{
				$style = " class=\"odd\"";
			}
			else {
				$style = " class=\"notodd\"";
			}
			$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&Id=$Id\" >";
			echo "<tr>"
			."<th align=\"left\"".$style.">$sectionLink$nom</a></th>"
			."<td align=\"center\"".$style.">$tel</td>"
			."</tr>";
			$pos++;
		}
	}
	else {
		echo "<tr><td colspan=\"2\"<p style=\"text-align: center\">"._ANNUNOORGTYPE."</p></td></tr>";
	}
	$sql = "DROP TEMPORARY TABLE `find_annu_temp`";
	$noresult = $db->sql_query($sql);
	echo "</table>";
	echo "</fieldset>";

	include ('footer.php');
}

/**
 * listActeurByDom()
 *
 *
 *
 *
 */
function listActeurByDom($domaine_rec){
	global $sitename, $prefix, $db, $module_name;
	
	if (!isset($domaine_rec) || $domaine_rec == "") {
		$domaine_rec = "-1";
	}
	
	include ('header.php');
	
	echo "<h1>".ANNUTITLE."</h1>";
	if ($domaine_rec != "") {
		$result2 = $db->sql_query("select label from ".$prefix."_users_domain where code=$domaine_rec");
		list($domaine) = $db->sql_fetchrow($result2);
	}
	
	ajoutStat("001 : recherche annuaire pour domaine ".$domaine_rec."/".$domaine);
	
	block_rec_annucomp("","",$domaine);
	
	echo "<fieldset><legend>"._ANNUDOMAIN."</legend>";
	
	echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
	//echo "<tr><td colspan=\"2\"><hr class=\"annu\"></td></tr>";

	$result = $db->sql_query("select Id, raison, ville from ".$prefix."_annuairecompetences_struct inner join ".$prefix."_annuairecompetences_link on id_struct=Id where id_domain=$domaine_rec order by coef desc, raison ASC");
	if ($db->sql_numrows($result) != 0) {
		$pos=1;
		while(list($Id, $nom, $tel) = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0)	{
				$style = " class=\"odd\"";
			}
			else {
				$style = " class=\"notodd\"";
			}
			$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&Id=$Id\" >";
			echo "<tr>"
			."<th align=\"left\"".$style.">$sectionLink$nom</a></th>"
			."<td align=\"center\"".$style.">$tel</td>"
			."</tr>";
			$pos++;
		}
	}
	else {
		echo "<tr><td colspan=\"2\"<p style=\"text-align: center\">"._ANNUNOORGTYPE."</p></td></tr>";
	}
	echo "</table>";
	echo "</fieldset>";

	include ('footer.php');
}

/**
 * listActeurByDom()
 *
 *
 *
 *
 */
function listActeurByRaison($raison_rec){
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	
	echo "<h1>".ANNUTITLE."</h1>";
	
	block_rec_annucomp("",$raison_rec,"");
	
	if (!isset($raison_rec) || $raison_rec == "") {
		$raison_rec = "0123456789";
	}
	
	$raison_rec = str_replace("'","''",stripslashes($raison_rec));
	
	echo "<fieldset><legend>"._ANNURAISONREC."</legend>";
	
	echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";

	$result = $db->sql_query("select Id, raison, ville from ".$prefix."_annuairecompetences_struct where raison like '%$raison_rec%' order by raison ASC");
	if ($db->sql_numrows($result) != 0) {
		$pos=1;
		while(list($Id, $nom, $tel) = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0)	{
				$style = " class=\"odd\"";
			}
			else {
				$style = " class=\"notodd\"";
			}
			$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&Id=$Id\" >";
			echo "<tr>"
			."<th align=\"left\"".$style.">$sectionLink$nom</a></th>"
			."<td align=\"center\"".$style.">$tel</td>"
			."</tr>";
			$pos++;
		}
	}
	else {
		echo "<tr><td colspan=\"2\"<p style=\"text-align: center\">"._ANNUNOORGTYPE."</p></td></tr>";
	}
	echo "</table>";
	echo "</fieldset>";

	include ('footer.php');
}


function display_line_not_null($libelle,$texte) {
	if ($texte != "") {
		return "<tr><td class=annuaireAttr>$libelle</td><td align=left>$texte</td></tr>";
	}
	else {
		return "";
	}
}

function viewCurrentActeur() {
	global $db, $user, $prefix;
	$user_data_bloc = base64_decode($user);
    $userdata = explode(":", $user_data_bloc);
	$uid = $userdata[0];
	/*$result = $db->sql_query("select `Id`  from ".$prefix."_annuairecompetences_struct where uid='$uid'");
	if (!$result) {
		$error = $db->sql_error();
		die('Invalid query:'.$error["message"]);
	}
	list($Id) = $db->sql_fetchrow($result);
	viewActeur($Id);*/
	viewActeur("",$uid);
}

/**
 * viewActeur()
 * view Acteur data
 * @param acid :acteur id
 * @return
 * @see
 */
function viewActeur($Id,$uid="") {
	global $sitename, $prefix, $db, $admin, $module_name;
	global $user;
	
	$uid2 ="";
	if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
	    $userdata = explode(":", $user_data_bloc);
		$uid2 = $userdata[0];
	}
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	$permalien = "";
	if ($uid != "" && $Id=="") {	
		$query = " where `uid`='".$uid."'";
		$result5 = $db->sql_query("select `Id` from ".$prefix."_annuairecompetences_struct$query");
		if (!$result5) {
			print_r($db->sql_error());
			die('Invalid query:');
		}
		list($Id) = $db->sql_fetchrow($result5);
		if ($uid2==$uid) {
			global $nukeurl;
			$tab_serveur = parse_url($nukeurl);
			$racine = $tab_serveur["scheme"]."://";
			if ($tab_serveur["user"] != "") {
				$racine .= $tab_serveur["user"];
			}
			if ($tab_serveur["pass"] != "") {
				$racine .= ":".$tab_serveur["pass"];
			}
			if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
				$racine .= "@";
			}
			$racine .= $tab_serveur["host"];
			if ($tab_serveur["port"] != "") {
				$racine .= ":".$tab_serveur["port"];
			}
			$permalien = "<b>"._ANNUPERMALIEN."</b>";
			$link = $racine."/modules.php?name=SimpleAnnuComp&sop=viewActeur&uid=".$uid;
			$permalien .= '<br /><a href="'.$link.'">'.$link.'</a>';
		}
	}
	$result = $db->sql_query("select `raison`, `forme`, `date_creation`, `adresse`, `cp`, `ville`, `tel`, `fax`, `web`, `activites`, `refs`,`clubs`, `certifs`, `metier`, `domaine`,`logo`  from ".$prefix."_annuairecompetences_struct where Id='$Id'");
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	list($raison, $forme, $date_creation, $adresse, $cp, $ville, $tel, $fax, $web, $activites, $refs,$clubs, $certifs, $metier, $domaine, $logo) = $db->sql_fetchrow($result);
	
	if ($raison == "") {
		$qui = "(erreur : Id=".$Id;
		if ($_SERVER["HTTP_REFERER"] != "") {
			$qui .= " - ".$_SERVER["HTTP_REFERER"];
		}
		$qui .= " - ".$_SERVER["HTTP_USER_AGENT"];
		$qui .= " - ".$_SERVER["REMOTE_ADDR"];
		$qui .= " - ".gethostbyaddr($_SERVER["REMOTE_ADDR"]);
		$qui .= ")";
	}
	else {
		$qui = $raison;
	}
	
	ajoutStat("002 : consultation fiche annuaire de ".$qui);
	
	if ($raison == "") {
		header("Location: modules.php?name=".$module_name);
	}
	
	$result2 = $db->sql_query("select refs,label,description from ".$prefix."_annuairecompetences_link inner join ".$prefix."_users_domain on id_domain=code where id_struct=$Id order by coef desc;");
	$domsrefs=_ANNUCOMP_NOREFS;
	if ($db->sql_numrows($result2) != 0) {
		$domsrefs = "";
		while (list($refs,$label,$description) = $db->sql_fetchrow($result2)) {
			$domsrefs .= ($domsrefs != "") ? "<br />":"";
			$domsrefs .= "<b>$label : </b>$description<br /><span class=\"refs\">"._REFERENCES."$refs</span>";
		}
	}
	if ($metier != 0) {
		$result3 = $db->sql_query("select label, description from ".$prefix."_users_domain where code='".$metier."'");
		list($label,$description) = $db->sql_fetchrow($result3);
		$met = "$label : $description";
	}
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\">";
	echo "<tr><td colspan=\"3\" class=\"nom\">";
	echo $raison;
	echo "</td></tr>";
	echo "<tr><td width=\"45%\" valign=\"top\">";
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
	
	if ($logo != "") {
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td class=\"logo\">";
		echo "<img src=\"$logo\">";
		echo "</td><td width=\"10\"></td><td>";
		
	}
	echo nl2br($adresse)."<br>".$cp." ".$ville;
	if ($tel != "" || $fax != "" || $web != "") {
		echo "<br />&nbsp;<br />";
	}
	if ($tel != "") {
		echo "<b>"._TEL_ACTEUR."</b>".$tel."<br />";
	}
	if ($fax != "") {
		echo "<b>"._FAX_ACTEUR."</b>".$fax."<br />";
	}
	if ($web != "") {
		$web = "http://".str_replace("http://","",$web);
		echo "<b>"._WEB_ACTEUR."</b><a href=\"$web\">".$web."</a>";
	}
	if ($logo != "") {
		echo "</td></tr></table>";
	}
	echo "</td></tr>";
	
	if ($date_creation != "") {
		echo "<tr><td>";
		echo "<b>"._DATECREATION."</b>".preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#i","\\3/\\2/\\1",$date_creation);
		echo "</td></tr>";
	}
	if ($met != "") {
		echo "<tr><td>";
		echo "<b>"._ACTEURMETIER."</b><br />".$met;
		echo "</td></tr>";
	}
	if ($activites != "") {
		echo "<tr><td>";
		echo "<b>"._ACTEURACTIVITE."</b><br />".nl2br($activites);
		echo "</td></tr>";
	}
	if ($clubs != "") {
		echo "<tr><td>";
		echo "<b>"._ACTEURCLUBS."</b><br />".nl2br($clubs);
		echo "</td></tr>";
	}
	if ($certifs != "") {
		echo "<tr><td>";
		echo "<b>"._ACTEURCERTIFS."</b><br />".nl2br($certifs);
		echo "</td></tr>";
	}
	
	echo "</table>";
	echo "<td width=\"5%\"></td>";
	echo "</td><td width=\"50%\" valign=\"top\">";
	echo "<fieldset style=\"margin-top: 10px\"><legend>"._ANNUCOMPREFS."</legend>";
	echo $domsrefs;
	echo "</fieldset>";
	echo "</td></tr>";	
	echo "</table>";

	// Contact
	$result4 = $db->sql_query("select nom,prenom,civilite, tel, fax, email from ".$prefix."_annuairecompetences_contact where struct_id=$Id order by nom asc, prenom asc;");
	if ($db->sql_numrows($result4) != 0) {
		echo "&nbsp;<br />";
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\"><tr><td valign=\"top\">";
		echo "<fieldset><legend>"._CONTACT."</legend>";
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">";
		while(list($nom, $prenom, $civilite, $telephone, $fax, $email) = $db->sql_fetchrow($result4)) {
			if (trim($telephone) != "") {
				$TelephoneDisplay = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
				$TelephoneDisplay .= "<img src=\"images/annuaire_comp/icone_telephonenumber.gif\" border=\"0\">";
				$TelephoneDisplay .= "</td><td>&nbsp;";
				$TelephoneDisplay .= $telephone;
				$TelephoneDisplay .= "</td></tr></table>";
			}
			if (trim($fax) != "") {
				$FaxDisplay = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
				$FaxDisplay .= "<img src=\"images/annuaire_comp/icone_fax.gif\" border=\"0\">";
				$FaxDisplay .= "</td><td>&nbsp;";
				$FaxDisplay .= $fax;
				$FaxDisplay .= "</td></tr></table>";
			}
			if (trim($email) != "") {
				$MailDisplay = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
				$MailDisplay .= "<img src=\"images/annuaire_comp/icone_mail.gif\" border=\"0\">";
				$MailDisplay .= "</td><td>&nbsp;";
				$MailDisplay .= "<a href=\"mailto:$email\">".$email."</a>";
				$MailDisplay .= "</td></tr></table>";
			}
			echo "<tr><td class=\"annuaireAttr\" colspan=\"3\" id=\"contact\">$civilite $nom $prenom </td>"
			."<tr class=annuaireTexteAttr ><td width=\"30%\">$TelephoneDisplay</td><td width=\"30%\">$FaxDisplay</td><td width=\"40%\">$MailDisplay</td></tr>";
		}
		echo "</table>";
		echo "</fieldset>";
		echo "</td></tr></table>";
		if ($permalien != "") {
			echo "<p style=\"text-align: center;\">&nbsp;<br />";
			echo $permalien;
			echo "</p>";
		}
	}

	// Impression et PDF
	$bardef=array(
	"print"=>"modules.php?name=$module_name&sop=printActeurPage&Id=$Id",
	//"pdf"=>"modules.php?name=$module_name&sop=exportActeurAsPdf&Id=$Id",
	//"pdf"=>"modules.php?name=balisteEcmspdf&sop=view&Id=$Id&pdfname=FicheActeur",
	"back"=>"javascript:window.history.back();",
	"top"=>"#top"
	);
	buttonBar($bardef, "align");

	/*echo "<br><table width=\"100%\"><tr><td align=right>";
	 echo "<a href=\"modules.php?name=$module_name&sop=printActeurPage&amp;actid=$actid\" target=\"_blank\"><img src=\"images/print.gif\" border=\"0\" Alt=\""._PRINTER."\" width=\"18\" height=\"20\"></a>"
	 ." <a href=\"modules.php?name=balisteEcmspdf&sop=view&amp;actid=$actid&pdfname=FicheActeur\"><img src=\"images/pdf15x15.jpg\" border=\"0\" Alt=\""._PDF."\" width=\"15\" height=\"15\"></a>"
	 ."</font></td></tr></table>";*/

	adminEditButton("system.php?op=S_acteurEdit&onglet=acteur&Id=".$Id);

	include ('footer.php');
}

/**
 * printActeurPage($acid)
 * format acteur page for an HTML print
 * @param acid :acteur id
 * @return
 * @see
 */
function printActeurPage($Id, $ok=1) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db, $module_name;

	$printPage = "<html>"
	."<head>"
	."<title>$sitename</title>"
	."<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n\n\n"
	."</head>"
	."<body bgcolor=\"#FFFFFF\" text=\"#000000\" >"
	."<table border=\"0\"><tr><td>"
	."<table border=\"0\" width=\"640\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>"
	."<table border=\"0\" width=\"640\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>"
	."<center>"
	."<img src=\"images/$site_logo\" border=\"0\" alt=\"\"><br><br></center>";

	$result = $db->sql_query("select `Id`, `nom`, `adresse`, `tel`, `fax`, `email`, `web`, `dirigeant`, `description`, `typevente`, `agrotourisme`, `produits`  from ".$prefix."_annuaire where Id='$Id'");
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	list($Id, $nom, $adresse, $tel, $fax, $email, $web, $dirigeant, $description, $typevente, $agrotourisme, $produits) = $db->sql_fetchrow($result);
	$catsinit = explode("//",_ACT_CAT_CAT_VALUES);
	for ($i=1;$i<=count($catsinit);$i++) {
		$cats[$i]=$catsinit[$i-1];
	}
	$categories = array();
	for ($i=1;$i<=count($catsinit);$i++) {
		$result2 = $db->sql_query("select label, icone from ".$prefix."_annuaire_categorie join ".$prefix."_annuaire_lien_categorie on Id=id_categorie where id_annuaire=$Id and categorie=$i order by label ASC;");
		if (!$result2) {
			print_r($db->sql_error());
			die('Invalid query:');
		}
		$temp = array();
		while(list($label,$icone) = $db->sql_fetchrow($result2)) {
			$temp [] = array("label" => $label,"icone" => $icone);
		}
		$categories[$i] = $temp;
	}
	$printPage .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\">";
	$printPage .= "<tr><td colspan=\"5\" class=\"nom\">";
	$printPage .= $nom;
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td colspan=\"5\" class=\"dirig\">";
	if ($dirigeant != "") {
		$printPage .= $dirigeant;
	}
	else {
		$printPage .= "&nbsp;";
	}
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td>";
	$printPage .= nl2br($adresse);
	$printPage .= "<td rowspan=\"9\" width=\"20\"></td>";
	$printPage .= "<td rowspan=\"9\" class=\"vente\" valign=\"top\">".nl2br($typevente)."</td>";
	$printPage .= "<td rowspan=\"9\"width=\"20\"></td>";
	$printPage .= "<td rowspan=\"9\" class=\"icns\" valign=\"top\">";
	foreach ($categories[1] as $catprod) {
		$printPage .= "<img src=\"images/annuaire/".$catprod["icone"]."\" alt=\"".$catprod["label"]."\"><br><br>";
	}foreach ($categories[3] as $catprod) {
		$printPage .= "<img src=\"images/annuaire/".$catprod["icone"]."\" alt=\"".$catprod["label"]."\"><br><br>";
	}
	$printPage .= "</td>";
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td>";
	$microregs = array();
	foreach($categories[4] as $microreg) {
		$microregs[] = $microreg["label"];
	}
	$printPage .= join(" - ",$microregs);
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td>";
	if ($fax.$tel != "") {
		$printPage .= _TELFAX_ACTEUR.$tel;
		$printPage .= ($fax != "") ? "/".$fax : "";
		$printPage .= "</td></tr>";
	}
	if ($email != "") {
		$printPage .= "<tr><td>";
		$printPage .= _EMAIL_ACTEUR.$email;
		$printPage .= "</td></tr>";
	}
	if ($web != "") {
		$printPage .= "<tr><td>";
		$printPage .= _WEB_ACTEUR.$web;
		$printPage .= "</td></tr>";
	}
	$printPage .= "<tr><td class=\"prods\">";
	$printPage .= nl2br($produits);
	$printPage .= "</td></tr>";
	$printPage .= "<tr><td class=\"descr\">";
	$printPage .= nl2br($description);
	$printPage .= "</td></tr>";
	if ($agrotourisme != "") {
		$printPage .= "<tr><td class=\"descr\">";
		$printPage .= _ANNUAGRO.nl2br($agrotourisme);
		$printPage .= "</td></tr>";
	}
	$printPage .= "</table>";
	
	$printPage .= "</td></tr></table>";
	$printPage .= "</td></tr></table>";
	$printPage .= " <br><center>
    <font class=\"annuairePrintFooter\">
    "._COMESFROM." $sitename :::
	<a href=\"$nukeurl\">$nukeurl</a><br><br>
	</font></center>
	</td></tr></table>
	</body>
	</html>
    ";
	if ($ok) {
		echo $printPage;
	}
	else{
		return $printPage;
	}
}
/**
 * exportActeurAsPdf()
 * export Acteur page as a pdf document
 * @param acid :acteur id
 * @return
 * @see
 */
function exportActeurAsPdf($Id) {
	require("modules/balisteEcmspdf/templates/Default/html2pdf.php");
	$myhtmlPage=printActeurPage($Id,0);

	if (isset($myhtmlPage))
	{
		$pdf = new createPDF(
		$myhtmlPage,   // html  convertir
		$mytitle,  // titre de l'article
		$myurl,    // URL de l'article
		$author, // nom de l'auteur
		time()
		);
		$pdf->run();
	}
}
/**
 * displayAlphabet()
 *
 * @param datatype paramname description
 * @return datatype description
 */
function displayAlphabet($thelink,$lettreencours="A"){
	$acteurLink=$thelink."&myfilter=";
	$lettres = array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z");
	$alpha = "<div class=\"pages\">";
	foreach($lettres as $lettre) {
		if ($lettreencours == $lettre) {
			$alpha .= "<div class=\"pagevide\">".$lettre."</div>";
		}
		else {
			$alpha .= "<div class=\"page\"><a href=\"".$acteurLink.$lettre."\">".$lettre."</a></div>";
		}
	}
	$alpha .= "</div>";
	return $alpha;
}

function displayHome() {
	global $annucomppageencours;
	include ('header.php');
	
	echo "<h1>".ANNUTITLE."</h1>";

	
	
	if ($annucomppageencours == "") {
		echo "<p>Remplissez une des rubriques ci-dessus et validez pour effectuer la recherche correspondante. Les rsultats seront tris par pertinence</p>";
	}
	else {
		require_once("modules/Sections/connector_class.php");
		$sectmodule = new pageconnector();
		echo  "\n".$sectmodule->getPageContent($annucomppageencours);
	}
	
	block_rec_annucomp("","","");
	
	$bardef=array(
	//"print"=>"modules.php?name=$module_name&sop=printActeurPage&Id=$Id",
	//"pdf"=>"modules.php?name=$module_name&sop=exportActeurAsPdf&Id=$Id",
	//"pdf"=>"modules.php?name=balisteEcmspdf&sop=view&Id=$Id&pdfname=FicheActeur",
	"back"=>"javascript:window.history.back();",
	"top"=>"#top"
	);
	buttonBar($bardef, "align");
	adminEditButton("system.php?op=SAC_annuaire");

	include ('footer.php');
}

function get_map_members_XML() {
	global $module_name;
	require_once("modules/".$module_name."/system/getXMLcarto_view.php");
	$sortie = getXMLcarto();
	header("Content-Type: text/xml; charset=UTF-8");
	echo $sortie;
}

function display_map_annaire() {
	global $module_name, $_headerContent;
	global $rep,$expression;
	global $My_SQL, $vars_mod;
	require_once("modules/SimpleCarto/lib/g_params.php");

	$_headerContent ='
<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key='.$keymap.'" charset="UTF-8"></script>
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_autostart.js"></script>
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_XML_parser.js" charset="UTF-8"></script>
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_AJAX.js" charset="UTF-8"></script>
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_carto_annu.js" charset="UTF-8"></script>
<script type="text/javascript">
//<![CDATA[
	var options = new Array;
	var racine_lib_module = "modules/SimpleCarto/lib";
   //]]>
</script>
<script type="text/javascript">
// <![CDATA[
	addToStart("GetMap(\''.$vars_mod[$vars_mod["id_carte"]].'\')");
	addToStop(GUnload);
// ]]>
</script>
';
		setHeader($_headerContent);
	
	$sortie = '
<div class="annucomp">
	<h1 id="titre"></h1>
	<p id="commentaire"></p>
	<p>&nbsp;</p>
	<div id="map"></div>
</div>';
	
	include ('header.php');
    echo $sortie;
    $bardef=array(//"print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back"=>"javascript:window.history.back();",
            "top"=>"#top" );
	buttonBar($bardef, "align");
    include ('footer.php');
}

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/
$index = 1;
switch($sop) {

	case "displayAccess":
		displayAccess();
		break;

	case "listActeur":
		listActeur($catid);
		break;

	case "listOrganismType":
		listOrganismType();
		break;

	case "listCompetence":
		listCompetence();
		break;

	case "viewActeur":
		viewActeur($Id,$uid);
		break;

	case "printActeurPage":
		printActeurPage($Id);
		break;

	case "listActeurArbo" :
		listActeurArbo($domid);
		break;

	case "exportActeurAsPdf":
		exportActeurAsPdf($Id);
		break;
		
	case "listActeurByChar":
		listActeurByChar($myfilter);
		break;
	case "recByDom":
		listActeurByDom($domain_rec);
		break;
	case "recByRaison":
		listActeurByRaison($raison_rec);
		break;
	case "recByKeyword":
		listActeurByKeyword($keyword_rec);
		break;
	case "viewCurrentActeur":
		if (is_user($user)) {
			viewCurrentActeur();
		}
		else {
			displayHome();
		}
		break;
	case "map_annu_XML" :
    		get_map_members_XML();
    		break;
    	case "map_annu":
		display_map_annaire();
		break;
	default:
		displayHome();
		break;
}

?>